/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.generichandlers.AssetHandler;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericConverter;
import org.odpi.openmetadata.commonservices.generichandlers.PortHandler;
import org.odpi.openmetadata.commonservices.generichandlers.ReferenceableHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.metadatasecurity.server.OpenMetadataServerSecurityVerifier;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class ProcessHandler<PROCESS, PORT, DATA_FLOW, CONTROL_FLOW, PROCESS_CALL, LINEAGE_MAPPING>
extends ReferenceableHandler<PROCESS> {
    private AssetHandler<PROCESS> processHandler;
    private PortHandler<PORT> portHandler;
    private OpenMetadataAPIGenericConverter<DATA_FLOW> dataFlowConverter;
    private Class<DATA_FLOW> dataFlowBeanClass;
    private OpenMetadataAPIGenericConverter<CONTROL_FLOW> controlFlowConverter;
    private Class<CONTROL_FLOW> controlFlowBeanClass;
    private OpenMetadataAPIGenericConverter<PROCESS_CALL> processCallConverter;
    private Class<PROCESS_CALL> processCallBeanClass;
    private OpenMetadataAPIGenericConverter<LINEAGE_MAPPING> validValueMappingConverter;
    private Class<LINEAGE_MAPPING> validValueMappingClass;

    public ProcessHandler(OpenMetadataAPIGenericConverter<PROCESS> converter, Class<PROCESS> beanClass, OpenMetadataAPIGenericConverter<PORT> portConverter, Class<PORT> portBeanClass, OpenMetadataAPIGenericConverter<DATA_FLOW> dataFlowConverter, Class<DATA_FLOW> dataFlowBeanClass, OpenMetadataAPIGenericConverter<CONTROL_FLOW> controlFlowConverter, Class<CONTROL_FLOW> controlFlowBeanClass, OpenMetadataAPIGenericConverter<PROCESS_CALL> processCallConverter, Class<PROCESS_CALL> processCallBeanClass, OpenMetadataAPIGenericConverter<LINEAGE_MAPPING> lineageMappingConverter, Class<LINEAGE_MAPPING> lineageMappingClass, String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper, String localServerUserId, OpenMetadataServerSecurityVerifier securityVerifier, List<String> supportedZones, List<String> defaultZones, List<String> publishZones, AuditLog auditLog) {
        super(converter, beanClass, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
        this.processHandler = new AssetHandler<PROCESS>(converter, beanClass, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
        this.portHandler = new PortHandler<PORT>(portConverter, portBeanClass, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
        this.dataFlowConverter = dataFlowConverter;
        this.dataFlowBeanClass = dataFlowBeanClass;
        this.controlFlowConverter = controlFlowConverter;
        this.controlFlowBeanClass = controlFlowBeanClass;
        this.processCallConverter = processCallConverter;
        this.processCallBeanClass = processCallBeanClass;
        this.validValueMappingConverter = lineageMappingConverter;
        this.validValueMappingClass = lineageMappingClass;
    }

    public String createProcess(String userId, String externalSourceGUID, String externalSourceName, String qualifiedName, String technicalName, String technicalDescription, String formula, String implementationLanguage, List<String> zoneMembership, String owner, int ownerType, String originOrganizationCapabilityGUID, String originBusinessCapabilityGUID, Map<String, String> otherOriginValues, Map<String, String> additionalProperties, String suppliedTypeName, Map<String, Object> suppliedExtendedProperties, InstanceStatus initialStatus, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String typeName = "Process";
        if (suppliedTypeName != null) {
            typeName = suppliedTypeName;
        }
        String typeGUID = this.invalidParameterHandler.validateTypeName(typeName, "Asset", this.serviceName, methodName, this.repositoryHelper);
        Map<String, Object> extendedProperties = suppliedExtendedProperties;
        if (formula != null) {
            if (extendedProperties == null) {
                extendedProperties = new HashMap<String, Object>();
            }
            extendedProperties.put("formula", formula);
        }
        if (implementationLanguage != null) {
            if (extendedProperties == null) {
                extendedProperties = new HashMap<String, Object>();
            }
            extendedProperties.put("implementationLanguage", implementationLanguage);
        }
        return this.processHandler.createAssetInRepository(userId, externalSourceGUID, externalSourceName, qualifiedName, technicalName, technicalDescription, zoneMembership, owner, ownerType, originOrganizationCapabilityGUID, originBusinessCapabilityGUID, otherOriginValues, additionalProperties, typeGUID, typeName, extendedProperties, initialStatus, methodName);
    }

    public String createProcessFromTemplate(String userId, String externalSourceGUID, String externalSourceName, String templateGUID, String templateGUIDParameterName, String qualifiedName, String qualifiedNameParameterName, String displayName, String description, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.processHandler.addAssetFromTemplate(userId, externalSourceGUID, externalSourceName, templateGUID, templateGUIDParameterName, "d8f33bd7-afa9-4a11-a8c7-07dcec83c050", "Process", qualifiedName, qualifiedNameParameterName, displayName, description, methodName);
    }

    public void updateProcess(String userId, String externalSourceGUID, String externalSourceName, String processGUID, String processGUIDParameterName, boolean isMergeUpdate, String qualifiedName, String technicalName, String technicalDescription, String formula, String implementationLanguage, List<String> zoneMembership, String owner, int ownerType, String originOrganizationCapabilityGUID, String originBusinessCapabilityGUID, Map<String, String> otherOriginValues, Map<String, String> additionalProperties, String suppliedTypeName, Map<String, Object> suppliedExtendedProperties, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
    }

    public void updateProcessStatus(String userId, String externalSourceGUID, String externalSourceName, String processGUID, String processGUIDParameterName, InstanceStatus processStatus, String processStatusParameterName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.updateBeanStatusInRepository(userId, externalSourceGUID, externalSourceName, processGUID, processGUIDParameterName, "0db3e6ec-f5ef-4d75-ae38-b7ee6fd6ec0a", "GlossaryTerm", this.supportedZones, processStatus, processStatusParameterName, methodName);
    }

    public void setupProcessParent(String userId, String externalSourceGUID, String externalSourceName, String parentProcessGUID, String parentProcessGUIDParameterName, String childProcessGUID, String childProcessGUIDParameterName, int containmentType, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
    }

    public void clearProcessParent(String userId, String externalSourceGUID, String externalSourceName, String parentProcessGUID, String parentProcessGUIDParameterName, String childProcessGUID, String childProcessGUIDParameterName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
    }

    public void publishProcess(String userId, String processGUID, String processGUIDParameterName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.processHandler.publishAsset(userId, processGUID, processGUIDParameterName, methodName);
    }

    public void withdrawProcess(String userId, String processGUID, String processGUIDParameterName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.processHandler.publishAsset(userId, processGUID, processGUIDParameterName, methodName);
    }

    public void removeProcess(String userId, String externalSourceGUID, String externalSourceName, String processGUID, String processGUIDParameterName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.processHandler.deleteBeanInRepository(userId, externalSourceGUID, externalSourceName, processGUID, processGUIDParameterName, "d8f33bd7-afa9-4a11-a8c7-07dcec83c050", "Process", null, null, methodName);
    }

    public List<PROCESS> findProcesses(String userId, String searchString, String searchStringParameterName, int startFrom, int pageSize, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateSearchString(searchString, searchStringParameterName, methodName);
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, methodName);
        List<PROCESS> results = this.processHandler.findAssets(userId, searchString, searchStringParameterName, startFrom, validatedPageSize, methodName);
        return results;
    }

    public List<PROCESS> getProcessesByName(String userId, String name, String nameParameterName, int startFrom, int pageSize, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return null;
    }

    public PROCESS getProcessByGUID(String userId, String processGUID, String processGUIDParameterName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return null;
    }

    public PROCESS getProcessParent(String userId, String processGUID, String processGUIDParameterName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return null;
    }

    public List<PROCESS> getSubProcesses(String userId, String processGUID, String processGUIDParameterName, int startFrom, int pageSize, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return null;
    }

    public String createPort(String userId, String externalSourceGUID, String externalSourceName, String processGUID, String processGUIDParameterName, String qualifiedName, String displayName, int portType, Map<String, String> additionalProperties, String suppliedTypeName, Map<String, Object> extendedProperties, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.portHandler.createPort(userId, externalSourceGUID, externalSourceName, processGUID, processGUIDParameterName, qualifiedName, displayName, portType, additionalProperties, suppliedTypeName, extendedProperties, methodName);
    }

    public void updatePort(String userId, String externalSourceGUID, String externalSourceName, String portGUID, String portGUIDParameterName, String qualifiedName, String displayName, int portType, Map<String, String> additionalProperties, String suppliedTypeName, Map<String, Object> extendedProperties, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.portHandler.updatePort(userId, externalSourceGUID, externalSourceName, portGUID, portGUIDParameterName, qualifiedName, displayName, portType, additionalProperties, suppliedTypeName, extendedProperties, methodName);
    }

    public void setupProcessPort(String userId, String externalSourceGUID, String externalSourceName, String processGUID, String processGUIDParameterName, String portGUID, String portGUIDParameterName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.portHandler.setupProcessPort(userId, externalSourceGUID, externalSourceName, processGUID, processGUIDParameterName, portGUID, portGUIDParameterName, methodName);
    }

    public void clearProcessPort(String userId, String externalSourceGUID, String externalSourceName, String processGUID, String processGUIDParameterName, String portGUID, String portGUIDParameterName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.portHandler.clearProcessPort(userId, externalSourceGUID, externalSourceName, processGUID, processGUIDParameterName, portGUID, portGUIDParameterName, methodName);
    }

    public void setupPortDelegation(String userId, String externalSourceGUID, String externalSourceName, String portOneGUID, String portOneGUIDParameterName, String portTwoGUID, String portTwoGUIDParameterName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.portHandler.setupPortDelegation(userId, externalSourceGUID, externalSourceName, portOneGUID, portOneGUIDParameterName, portTwoGUID, portTwoGUIDParameterName, methodName);
    }

    public void clearPortDelegation(String userId, String externalSourceGUID, String externalSourceName, String portOneGUID, String portOneGUIDParameterName, String portTwoGUID, String portTwoGUIDParameterName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.portHandler.clearPortDelegation(userId, externalSourceGUID, externalSourceName, portOneGUID, portOneGUIDParameterName, portTwoGUID, portTwoGUIDParameterName, methodName);
    }

    public void setupPortSchemaType(String userId, String externalSourceGUID, String externalSourceName, String portGUID, String portGUIDParameterName, String schemaTypeGUID, String schemaTypeGUIDParameterName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.portHandler.setupPortSchemaType(userId, externalSourceGUID, externalSourceName, portGUID, portGUIDParameterName, schemaTypeGUID, schemaTypeGUIDParameterName, methodName);
    }

    public void clearPortSchemaType(String userId, String externalSourceGUID, String externalSourceName, String portGUID, String portGUIDParameterName, String schemaTypeGUID, String schemaTypeGUIDParameterName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.portHandler.clearPortSchemaType(userId, externalSourceGUID, externalSourceName, portGUID, portGUIDParameterName, schemaTypeGUID, schemaTypeGUIDParameterName, methodName);
    }

    public void removePort(String userId, String externalSourceGUID, String externalSourceName, String portGUID, String portGUIDParameterName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.portHandler.removePort(userId, externalSourceGUID, externalSourceName, portGUID, portGUIDParameterName, methodName);
    }

    public List<PORT> findPorts(String userId, String searchString, String searchStringParameterName, int startFrom, int pageSize, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.portHandler.findPorts(userId, searchString, searchStringParameterName, startFrom, pageSize, methodName);
    }

    public List<PORT> getPortsForProcess(String userId, String processGUID, String processGUIDParameterName, int startFrom, int pageSize, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.portHandler.getPortsForProcess(userId, processGUID, processGUIDParameterName, startFrom, pageSize, methodName);
    }

    public List<PORT> getPortUse(String userId, String portGUID, String portGUIDParameterName, int startFrom, int pageSize, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.portHandler.getPortUse(userId, portGUID, portGUIDParameterName, startFrom, pageSize, methodName);
    }

    public PORT getPortDelegation(String userId, String portGUID, String portGUIDParameterName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.portHandler.getPortDelegation(userId, portGUID, portGUIDParameterName, methodName);
    }

    public List<PORT> getPortsByName(String userId, String name, String nameParameterName, int startFrom, int pageSize, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.portHandler.getPortsByName(userId, name, nameParameterName, startFrom, pageSize, methodName);
    }

    public PORT getPortByGUID(String userId, String portGUID, String portGUIDParameterName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.portHandler.getPortByGUID(userId, portGUID, portGUIDParameterName, methodName);
    }

    public void setBusinessSignificant(String userId, String elementGUID, String elementGUIDParameterName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
    }

    public void clearBusinessSignificant(String userId, String elementGUID, String elementGUIDParameterName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
    }

    public String setupDataFlow(String userId, String externalSourceGUID, String externalSourceName, String dataSupplierGUID, String dataSupplierGUIDParameterName, String dataConsumerGUID, String dataConsumerGUIDParameterName, String qualifiedName, String description, String formula, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return null;
    }

    public DATA_FLOW getDataFlow(String userId, String dataSupplierGUID, String dataSupplierGUIDParameterName, String dataConsumerGUID, String dataConsumerGUIDParameterName, String qualifiedName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return null;
    }

    public void updateDataFlow(String userId, String externalSourceGUID, String externalSourceName, String dataFlowGUID, String dataFlowGUIDParameterName, String qualifiedName, String description, String formula, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
    }

    public void clearDataFlow(String userId, String externalSourceGUID, String externalSourceName, String dataFlowGUID, String dataFlowGUIDParameterName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
    }

    public List<DATA_FLOW> getDataFlowConsumers(String userId, String dataSupplierGUID, String dataSupplierGUIDParameterName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return null;
    }

    public List<DATA_FLOW> getDataFlowSuppliers(String userId, String dataConsumerGUID, String dataConsumerGUIDParameterName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return null;
    }

    public String setupControlFlow(String userId, String externalSourceGUID, String externalSourceName, String currentStepGUID, String currentStepGUIDParameterName, String nextStepGUID, String nextStepGUIDParameterName, String qualifiedName, String description, String guard, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return null;
    }

    public CONTROL_FLOW getControlFlow(String userId, String currentStepGUID, String currentStepGUIDParameterName, String nextStepGUID, String nextStepGUIDParameterName, String qualifiedName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return null;
    }

    public void updateControlFlow(String userId, String externalSourceGUID, String externalSourceName, String controlFlowGUID, String controlFlowGUIDParameterName, String qualifiedName, String description, String guard, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
    }

    public void clearControlFlow(String userId, String externalSourceGUID, String externalSourceName, String controlFlowGUID, String controlFlowGUIDParameterName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
    }

    public List<CONTROL_FLOW> getControlFlowNextSteps(String userId, String currentStepGUID, String currentStepGUIDParameterName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return null;
    }

    public List<CONTROL_FLOW> getControlFlowPreviousSteps(String userId, String currentStepGUID, String currentStepGUIDParameterName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return null;
    }

    public String setupProcessCall(String userId, String externalSourceGUID, String externalSourceName, String callerGUID, String callerGUIDParameterName, String calledGUID, String calledGUIDParameterName, String qualifiedName, String description, String formula, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return null;
    }

    public PROCESS_CALL getProcessCall(String userId, String callerGUID, String callerGUIDParameterName, String calledGUID, String calledGUIDParameterName, String qualifiedName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return null;
    }

    public void updateProcessCall(String userId, String externalSourceGUID, String externalSourceName, String processCallGUID, String processCallGUIDParameterName, String qualifiedName, String description, String formula, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
    }

    public void clearProcessCall(String userId, String externalSourceGUID, String externalSourceName, String processCallGUID, String processCallGUIDParameterName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
    }

    public List<PROCESS_CALL> getProcessCalled(String userId, String callerGUID, String callerGUIDParameterName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return null;
    }

    public List<PROCESS_CALL> getProcessCallers(String userId, String calledGUID, String calledGUIDParameterName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return null;
    }

    public void setupLineageMapping(String userId, String sourceElementGUID, String sourceElementGUIDParameterName, String destinationElementGUID, String destinationElementGUIDParameterName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
    }

    public void clearLineageMapping(String userId, String sourceElementGUID, String sourceElementGUIDParameterName, String destinationElementGUID, String destinationElementGUIDParameterName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
    }

    public List<LINEAGE_MAPPING> getDestinationLineageMappings(String userId, String sourceElementGUID, String sourceElementGUIDParameterName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return null;
    }

    public List<LINEAGE_MAPPING> getSourceLineageMappings(String userId, String destinationElementGUID, String destinationElementGUIDParameterName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return null;
    }
}

