/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericConverter;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.metadatasecurity.server.OpenMetadataServerSecurityVerifier;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityProxy;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class RelatedAssetHandler<B>
extends OpenMetadataAPIGenericHandler<B> {
    public RelatedAssetHandler(OpenMetadataAPIGenericConverter<B> converter, Class<B> beanClass, String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper, String localServerUserId, OpenMetadataServerSecurityVerifier securityVerifier, List<String> supportedZones, List<String> defaultZones, List<String> publishZones, AuditLog auditLog) {
        super(converter, beanClass, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
    }

    public int getRelatedAssetCount(String userId, String elementGUID, String elementGUIDParameterName, String elementTypeName, String relationshipTypeGUID, String relationshipTypeName, List<String> serviceSupportedZones, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        List<B> relatedAssets = this.getRelatedAssets(userId, elementGUID, elementGUIDParameterName, elementTypeName, relationshipTypeGUID, relationshipTypeName, serviceSupportedZones, 0, this.invalidParameterHandler.getMaxPagingSize(), methodName);
        if (relatedAssets == null) {
            return 0;
        }
        return relatedAssets.size();
    }

    public List<B> getRelatedAssets(String userId, String elementGUID, String elementGUIDParameterName, String elementTypeName, String relationshipTypeGUID, String relationshipTypeName, List<String> serviceSupportedZones, int startFrom, int pageSize, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        List<Relationship> relationships = this.getAttachmentLinks(userId, elementGUID, elementGUIDParameterName, elementTypeName, relationshipTypeGUID, relationshipTypeName, "Asset", startFrom, pageSize, methodName);
        ArrayList results = new ArrayList();
        String entityGUIDParameterName = "entityProxy.getGUID()";
        if (relationships != null) {
            for (Relationship relationship : relationships) {
                EntityProxy otherEnd;
                if (relationship == null || (otherEnd = this.repositoryHandler.getOtherEnd(elementGUID, elementTypeName, relationship, methodName)) == null || otherEnd.getType() == null) continue;
                try {
                    Object bean;
                    EntityDetail entity = this.getEntityFromRepository(userId, otherEnd.getGUID(), "entityProxy.getGUID()", otherEnd.getType().getTypeDefName(), null, null, serviceSupportedZones, methodName);
                    if (entity == null || (bean = this.converter.getNewBean(this.beanClass, entity, relationship, methodName)) == null) continue;
                    results.add(bean);
                }
                catch (UserNotAuthorizedException userNotAuthorizedException) {}
            }
        }
        if (results.isEmpty()) {
            return null;
        }
        return results;
    }
}

