/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.generichandlers.CollectionBuilder;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericConverter;
import org.odpi.openmetadata.commonservices.generichandlers.ReferenceableHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.metadatasecurity.server.OpenMetadataServerSecurityVerifier;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class CollectionHandler<B>
extends ReferenceableHandler<B> {
    public CollectionHandler(OpenMetadataAPIGenericConverter<B> converter, Class<B> beanClass, String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper, String localServerUserId, OpenMetadataServerSecurityVerifier securityVerifier, List<String> supportedZones, List<String> defaultZones, List<String> publishZones, AuditLog auditLog) {
        super(converter, beanClass, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
    }

    public String createCollection(String userId, String externalSourceGUID, String externalSourceName, String qualifiedName, String displayName, String description, Map<String, String> additionalProperties, String suppliedTypeName, Map<String, Object> extendedProperties, String classificationName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        String typeName = "Collection";
        if (suppliedTypeName != null) {
            typeName = suppliedTypeName;
        }
        String typeGUID = this.invalidParameterHandler.validateTypeName(typeName, "Collection", this.serviceName, methodName, this.repositoryHelper);
        CollectionBuilder builder = new CollectionBuilder(qualifiedName, displayName, description, additionalProperties, typeGUID, typeName, extendedProperties, this.repositoryHelper, this.serviceName, this.serverName);
        if (classificationName != null) {
            builder.setupCollectionClassification(userId, classificationName, methodName);
        }
        return this.createBeanInRepository(userId, externalSourceGUID, externalSourceName, typeGUID, typeName, qualifiedName, "qualifiedName", builder, methodName);
    }

    public String createFolder(String userId, String externalSourceGUID, String externalSourceName, String qualifiedName, String displayName, String description, Map<String, String> additionalProperties, String suppliedTypeName, Map<String, Object> extendedProperties, int orderBy, String orderPropertyName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        String typeName = "Collection";
        if (suppliedTypeName != null) {
            typeName = suppliedTypeName;
        }
        String typeGUID = this.invalidParameterHandler.validateTypeName(typeName, "Collection", this.serviceName, methodName, this.repositoryHelper);
        CollectionBuilder builder = new CollectionBuilder(qualifiedName, displayName, description, additionalProperties, typeGUID, typeName, extendedProperties, this.repositoryHelper, this.serviceName, this.serverName);
        builder.setupFolderClassification(userId, orderBy, orderPropertyName, methodName);
        return this.createBeanInRepository(userId, externalSourceGUID, externalSourceName, typeGUID, typeName, qualifiedName, "qualifiedName", builder, methodName);
    }

    public String createCollectionFromTemplate(String userId, String externalSourceGUID, String externalSourceName, String templateGUID, String qualifiedName, String displayName, String description, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String templateGUIDParameterName = "templateGUID";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(templateGUID, "templateGUID", methodName);
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        CollectionBuilder builder = new CollectionBuilder(qualifiedName, displayName, description, this.repositoryHelper, this.serviceName, this.serverName);
        return this.createBeanFromTemplate(userId, externalSourceGUID, externalSourceName, templateGUID, "templateGUID", "347005ba-2b35-4670-b5a7-12c9ebed0cf7", "Collection", qualifiedName, "qualifiedName", builder, methodName);
    }

    public void updateCollection(String userId, String externalSourceGUID, String externalSourceName, String collectionGUID, String collectionGUIDParameterName, String qualifiedName, String displayName, String description, Map<String, String> additionalProperties, String suppliedTypeName, Map<String, Object> extendedProperties, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(collectionGUID, collectionGUIDParameterName, methodName);
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        String typeName = "Collection";
        if (suppliedTypeName != null) {
            typeName = suppliedTypeName;
        }
        String typeGUID = this.invalidParameterHandler.validateTypeName(typeName, "Collection", this.serviceName, methodName, this.repositoryHelper);
        CollectionBuilder builder = new CollectionBuilder(qualifiedName, displayName, description, additionalProperties, typeGUID, typeName, extendedProperties, this.repositoryHelper, this.serviceName, this.serverName);
        this.updateBeanInRepository(userId, externalSourceGUID, externalSourceName, collectionGUID, collectionGUIDParameterName, typeGUID, typeName, builder.getInstanceProperties(methodName), false, methodName);
    }

    public void addFolderClassificationToCollection(String userId, String collectionGUID, String collectionGUIDParameterName, int orderBy, String orderPropertyName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(collectionGUID, collectionGUIDParameterName, methodName);
        CollectionBuilder builder = new CollectionBuilder(this.repositoryHelper, this.serviceName, this.serverName);
        this.setClassificationInRepository(userId, collectionGUID, collectionGUIDParameterName, "Collection", "3c0fa687-8a63-4c8e-8bda-ede9c78be6c7", "Folder", builder.getFolderProperties(orderBy, orderPropertyName, methodName), methodName);
    }

    public void removeFolderClassificationFromCollection(String userId, String collectionGUID, String collectionGUIDParameterName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(collectionGUID, collectionGUIDParameterName, methodName);
        this.removeClassificationFromRepository(userId, collectionGUID, collectionGUIDParameterName, "Collection", "3c0fa687-8a63-4c8e-8bda-ede9c78be6c7", "Folder", methodName);
    }

    public void addMemberToCollection(String userId, String externalSourceGUID, String externalSourceName, String collectionGUID, String collectionGUIDParameterName, String memberGUID, String memberGUIDParameterName, String membershipRationale, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        InstanceProperties properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, "membershipRationale", membershipRationale, methodName);
        this.linkElementToElement(userId, externalSourceGUID, externalSourceName, collectionGUID, collectionGUIDParameterName, "Collection", memberGUID, memberGUIDParameterName, "Referenceable", "5cabb76a-e25b-4bb5-8b93-768bbac005af", "CollectionMembership", properties, methodName);
    }

    public void removeMemberFromCollection(String userId, String externalSourceGUID, String externalSourceName, String collectionGUID, String collectionGUIDParameterName, String memberGUID, String memberGUIDParameterName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.unlinkElementFromElement(userId, false, externalSourceGUID, externalSourceName, collectionGUID, collectionGUIDParameterName, "Collection", memberGUID, memberGUIDParameterName, "a32316b8-dc8c-48c5-b12b-71c1b2a080bf", "Referenceable", "5cabb76a-e25b-4bb5-8b93-768bbac005af", "CollectionMembership", methodName);
    }

    public void removeCollection(String userId, String externalSourceGUID, String externalSourceName, String collectionGUID, String collectionGUIDParameterName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.deleteBeanInRepository(userId, externalSourceGUID, externalSourceName, collectionGUID, collectionGUIDParameterName, "347005ba-2b35-4670-b5a7-12c9ebed0cf7", "Collection", null, null, methodName);
    }

    public List<B> findCollections(String userId, String searchString, String searchStringParameterName, int startFrom, int pageSize, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.findBeans(userId, searchString, searchStringParameterName, "347005ba-2b35-4670-b5a7-12c9ebed0cf7", "Collection", null, startFrom, pageSize, methodName);
    }

    public List<B> getCollectionsByName(String userId, String name, String nameParameterName, int startFrom, int pageSize, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        ArrayList<String> specificMatchPropertyNames = new ArrayList<String>();
        specificMatchPropertyNames.add("qualifiedName");
        specificMatchPropertyNames.add("name");
        return this.getBeansByValue(userId, name, nameParameterName, "347005ba-2b35-4670-b5a7-12c9ebed0cf7", "Collection", specificMatchPropertyNames, true, null, null, false, this.supportedZones, null, startFrom, pageSize, methodName);
    }

    public B getCollectionByGUID(String userId, String guid, String guidParameterName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.getBeanFromRepository(userId, guid, guidParameterName, "Collection", methodName);
    }
}

