/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.generichandlers.ConnectorTypeBuilder;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericConverter;
import org.odpi.openmetadata.commonservices.generichandlers.ReferenceableHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ConnectorType;
import org.odpi.openmetadata.metadatasecurity.server.OpenMetadataServerSecurityVerifier;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class ConnectorTypeHandler<B>
extends ReferenceableHandler<B> {
    public ConnectorTypeHandler(OpenMetadataAPIGenericConverter<B> converter, Class<B> beanClass, String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper, String localServerUserId, OpenMetadataServerSecurityVerifier securityVerifier, List<String> supportedZones, List<String> defaultZones, List<String> publishZones, AuditLog auditLog) {
        super(converter, beanClass, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
    }

    private String findConnectorType(String userId, ConnectorType connectorType, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String guidParameterName = "connectorType.getGUID";
        String qualifiedNameParameter = "connectorType.getQualifiedName";
        String displayNameParameter = "connectorType.getDisplayName";
        if (connectorType != null) {
            if (connectorType.getGUID() != null) {
                try {
                    if (this.getEntityFromRepository(userId, connectorType.getGUID(), "ConnectorType", methodName, "connectorType.getGUID") != null) {
                        return connectorType.getGUID();
                    }
                }
                catch (InvalidParameterException invalidParameterException) {
                    // empty catch block
                }
            }
            String retrievedGUID = null;
            if (connectorType.getQualifiedName() != null) {
                retrievedGUID = this.getBeanGUIDByUniqueName(userId, connectorType.getQualifiedName(), "connectorType.getQualifiedName", "qualifiedName", "954421eb-33a6-462d-a8ca-b5709a1bd0d4", "ConnectorType", this.supportedZones, methodName);
            }
            if (retrievedGUID == null && connectorType.getDisplayName() != null) {
                retrievedGUID = this.getBeanGUIDByUniqueName(userId, connectorType.getDisplayName(), "connectorType.getDisplayName", "displayName", "954421eb-33a6-462d-a8ca-b5709a1bd0d4", "ConnectorType", this.supportedZones, methodName);
            }
            return retrievedGUID;
        }
        return null;
    }

    String saveConnectorType(String userId, String externalSourceGUID, String externalSourceName, ConnectorType connectorType, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        if (connectorType != null) {
            String existingConnectorType = this.findConnectorType(userId, connectorType, methodName);
            if (existingConnectorType == null) {
                return this.createConnectorType(userId, externalSourceGUID, externalSourceName, null, connectorType.getQualifiedName(), connectorType.getDisplayName(), connectorType.getDescription(), connectorType.getConnectorProviderClassName(), connectorType.getRecognizedAdditionalProperties(), connectorType.getRecognizedSecuredProperties(), connectorType.getRecognizedConfigurationProperties(), connectorType.getAdditionalProperties(), null, null, methodName);
            }
            String connectorTypeGUIDParameterName = "connectorType.getGUID";
            this.updateConnectorType(userId, externalSourceGUID, externalSourceName, existingConnectorType, "connectorType.getGUID", connectorType.getQualifiedName(), connectorType.getDisplayName(), connectorType.getDescription(), connectorType.getConnectorProviderClassName(), connectorType.getRecognizedAdditionalProperties(), connectorType.getRecognizedSecuredProperties(), connectorType.getRecognizedConfigurationProperties(), connectorType.getAdditionalProperties(), null, null, false, methodName);
            return existingConnectorType;
        }
        return null;
    }

    public String createConnectorType(String userId, String externalSourceGUID, String externalSourceName, String anchorGUID, String qualifiedName, String displayName, String description, String connectorProviderClassName, List<String> recognizedAdditionalProperties, List<String> recognizedSecuredProperties, List<String> recognizedConfigurationProperties, Map<String, String> additionalProperties, String suppliedTypeName, Map<String, Object> extendedProperties, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String nameParameter = "qualifiedName";
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        String typeName = "ConnectorType";
        if (suppliedTypeName != null) {
            typeName = suppliedTypeName;
        }
        String typeGUID = this.invalidParameterHandler.validateTypeName(typeName, "ConnectorType", this.serviceName, methodName, this.repositoryHelper);
        ConnectorTypeBuilder builder = new ConnectorTypeBuilder(qualifiedName, displayName, description, connectorProviderClassName, recognizedAdditionalProperties, recognizedSecuredProperties, recognizedConfigurationProperties, additionalProperties, typeGUID, typeName, extendedProperties, this.repositoryHelper, this.serviceName, this.serverName);
        if (anchorGUID != null) {
            builder.setAnchors(userId, anchorGUID, methodName);
        }
        return this.createBeanInRepository(userId, externalSourceGUID, externalSourceName, typeGUID, typeName, qualifiedName, "qualifiedName", builder, methodName);
    }

    public String createConnectorTypeFromTemplate(String userId, String externalSourceGUID, String externalSourceName, String templateGUID, String qualifiedName, String displayName, String description, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String templateGUIDParameterName = "templateGUID";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(templateGUID, "templateGUID", methodName);
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        ConnectorTypeBuilder builder = new ConnectorTypeBuilder(qualifiedName, displayName, description, this.repositoryHelper, this.serviceName, this.serverName);
        return this.createBeanFromTemplate(userId, externalSourceGUID, externalSourceName, templateGUID, "templateGUID", "954421eb-33a6-462d-a8ca-b5709a1bd0d4", "ConnectorType", qualifiedName, "qualifiedName", builder, methodName);
    }

    public String getConnectorTypeForConnection(String userId, String externalSourceGUID, String externalSourceName, String anchorGUID, String qualifiedName, String displayName, String description, String connectorProviderClassName, List<String> recognizedAdditionalProperties, List<String> recognizedSecuredProperties, List<String> recognizedConfigurationProperties, Map<String, String> additionalProperties, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String qualifiedNameParameterName = "qualifiedName";
        String connectorTypeGUID = this.getBeanGUIDByUniqueName(userId, qualifiedName, qualifiedNameParameterName, "qualifiedName", "954421eb-33a6-462d-a8ca-b5709a1bd0d4", "ConnectorType", this.supportedZones, methodName);
        if (connectorTypeGUID == null) {
            connectorTypeGUID = this.createConnectorType(userId, externalSourceGUID, externalSourceName, anchorGUID, qualifiedName, displayName, description, connectorProviderClassName, recognizedAdditionalProperties, recognizedSecuredProperties, recognizedConfigurationProperties, additionalProperties, null, null, methodName);
        }
        return connectorTypeGUID;
    }

    public void updateConnectorType(String userId, String externalSourceGUID, String externalSourceName, String connectorTypeGUID, String connectorTypeGUIDParameterName, String qualifiedName, String displayName, String description, String connectorProviderClassName, List<String> recognizedAdditionalProperties, List<String> recognizedSecuredProperties, List<String> recognizedConfigurationProperties, Map<String, String> additionalProperties, String suppliedTypeName, Map<String, Object> extendedProperties, boolean isMergeUpdate, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String nameParameter = "qualifiedName";
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        String typeName = "ConnectorType";
        if (suppliedTypeName != null) {
            typeName = suppliedTypeName;
        }
        String typeGUID = this.invalidParameterHandler.validateTypeName(typeName, "ConnectorType", this.serviceName, methodName, this.repositoryHelper);
        ConnectorTypeBuilder builder = new ConnectorTypeBuilder(qualifiedName, displayName, description, connectorProviderClassName, recognizedAdditionalProperties, recognizedSecuredProperties, recognizedConfigurationProperties, additionalProperties, typeGUID, typeName, extendedProperties, this.repositoryHelper, this.serviceName, this.serverName);
        this.updateBeanInRepository(userId, externalSourceGUID, externalSourceName, connectorTypeGUID, connectorTypeGUIDParameterName, typeGUID, typeName, this.supportedZones, builder.getInstanceProperties(methodName), isMergeUpdate, methodName);
    }

    public void removeConnectorType(String userId, String externalSourceGUID, String externalSourceName, String guid, String guidParameterName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.deleteBeanInRepository(userId, externalSourceGUID, externalSourceName, guid, guidParameterName, "954421eb-33a6-462d-a8ca-b5709a1bd0d4", "ConnectorType", null, null, methodName);
    }

    public List<B> findConnectorTypes(String userId, String searchString, String searchStringParameterName, int startFrom, int pageSize, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.findBeans(userId, searchString, searchStringParameterName, "954421eb-33a6-462d-a8ca-b5709a1bd0d4", "ConnectorType", null, startFrom, pageSize, methodName);
    }

    public List<B> getConnectorTypesByName(String userId, String name, String nameParameterName, int startFrom, int pageSize, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        ArrayList<String> specificMatchPropertyNames = new ArrayList<String>();
        specificMatchPropertyNames.add("qualifiedName");
        specificMatchPropertyNames.add("displayName");
        specificMatchPropertyNames.add("connectorProviderClassName");
        return this.getBeansByValue(userId, name, nameParameterName, "954421eb-33a6-462d-a8ca-b5709a1bd0d4", "ConnectorType", specificMatchPropertyNames, true, null, null, false, this.supportedZones, null, startFrom, pageSize, methodName);
    }

    public B getConnectorTypeByGUID(String userId, String guid, String guidParameterName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.getBeanFromRepository(userId, guid, guidParameterName, "ConnectorType", methodName);
    }
}

