/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.generichandlers.DataFieldBuilder;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericConverter;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.metadatasecurity.server.OpenMetadataServerSecurityVerifier;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityProxy;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class DataFieldHandler<B>
extends OpenMetadataAPIGenericHandler<B> {
    public DataFieldHandler(OpenMetadataAPIGenericConverter<B> converter, Class<B> beanClass, String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper, String localServerUserId, OpenMetadataServerSecurityVerifier securityVerifier, List<String> supportedZones, List<String> defaultZones, List<String> publishZones, AuditLog auditLog) {
        super(converter, beanClass, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
    }

    public List<B> getPreviousDataFieldsForAsset(String userId, String discoveryReportGUID, int startingFrom, int pageSize, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String discoveryReportGUIDParameterName = "discoveryReportGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(discoveryReportGUID, "discoveryReportGUID", methodName);
        this.invalidParameterHandler.validatePaging(startingFrom, pageSize, methodName);
        return null;
    }

    public List<B> getNewDataFieldsForAsset(String userId, String discoveryReportGUID, int startingFrom, int pageSize, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String discoveryReportGUIDParameterName = "discoveryReportGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(discoveryReportGUID, "discoveryReportGUID", methodName);
        this.invalidParameterHandler.validatePaging(startingFrom, pageSize, methodName);
        List<Relationship> annotationRelationships = super.getAttachmentLinks(userId, discoveryReportGUID, "discoveryReportGUID", "OpenDiscoveryAnalysisReport", "51d386a3-3857-42e3-a3df-14a6cad08b93", "DiscoveredAnnotation", "SchemaAnalysisAnnotation", 0, this.invalidParameterHandler.getMaxPagingSize(), methodName);
        if (annotationRelationships != null && !annotationRelationships.isEmpty()) {
            for (Relationship relationship : annotationRelationships) {
                EntityProxy annotationEnd;
                if (relationship == null || (annotationEnd = relationship.getEntityOneProxy()) == null) continue;
                String annotationEndParameterName = "annotationEnd.getGUID()";
                List<String> entityGUIDs = super.getAttachedElementGUIDs(userId, annotationEnd.getGUID(), "annotationEnd.getGUID()", "DataField", "60f2d263-e24d-4f20-8c0d-b5e22222cd54", "DiscoveredDataField", "DataField", startingFrom, pageSize, methodName);
                return this.getDataFields(userId, entityGUIDs, methodName);
            }
        }
        return null;
    }

    public List<B> getNestedDataFields(String userId, String parentDataFieldGUID, int startingFrom, int pageSize, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String dataFieldGUIDParameterName = "parentDataFieldGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(parentDataFieldGUID, "parentDataFieldGUID", methodName);
        this.invalidParameterHandler.validatePaging(startingFrom, pageSize, methodName);
        List<String> entityGUIDs = super.getAttachedElementGUIDs(userId, parentDataFieldGUID, "parentDataFieldGUID", "DataField", "60f2d263-e24d-4f20-8c0d-b5e12356cd54", "DiscoveredNestedDataField", "DataField", startingFrom, pageSize, methodName);
        return this.getDataFields(userId, entityGUIDs, methodName);
    }

    private List<B> getDataFields(String userId, List<String> dataFieldGUIDs, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        ArrayList<B> results = new ArrayList<B>();
        if (dataFieldGUIDs != null) {
            for (String entityGUID : dataFieldGUIDs) {
                B bean;
                if (entityGUID == null || (bean = this.getDataField(userId, entityGUID, methodName)) == null) continue;
                results.add(bean);
            }
            if (!results.isEmpty()) {
                return results;
            }
        }
        return null;
    }

    public B getDataField(String userId, String dataFieldGUID, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String dataFieldGUIDParameterName = "dataFieldGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(dataFieldGUID, "dataFieldGUID", methodName);
        EntityDetail entity = super.getEntityFromRepository(userId, dataFieldGUID, "dataFieldGUID", "DataField", methodName);
        List<Relationship> relationships = super.getAllAttachmentLinks(userId, dataFieldGUID, "dataFieldGUID", "DataField", methodName);
        return this.converter.getNewComplexBean(this.beanClass, entity, relationships, methodName);
    }

    private String addDataField(String userId, String externalSourceGUID, String externalSourceName, String parentEntityGUID, String parentEntityParameterName, String parentEntityType, String relationshipTypeGUID, String relationshipTypeName, int dataFieldPosition, String dataFieldName, String dataFieldType, String dataFieldDescription, List<String> dataFieldAliases, int dataFieldSortOrder, String defaultValue, Map<String, String> additionalProperties, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String dataFieldGUID;
        String dataFieldNameParameterName = "dataFieldName";
        String dataFieldGUIDParameterName = "dataFieldGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(parentEntityGUID, parentEntityParameterName, methodName);
        this.invalidParameterHandler.validateName(dataFieldName, "dataFieldName", methodName);
        String assetGUID = null;
        EntityDetail anchorEntity = this.validateAnchorEntity(userId, parentEntityGUID, parentEntityParameterName, parentEntityType, false, this.supportedZones, methodName);
        if (anchorEntity != null) {
            assetGUID = anchorEntity.getGUID();
        }
        DataFieldBuilder builder = new DataFieldBuilder(dataFieldName, dataFieldType, dataFieldDescription, dataFieldAliases, dataFieldSortOrder, defaultValue, additionalProperties, "3c5bbc8b-d562-4b04-b189-c7b7f0bf2cea", "DataField", null, this.repositoryHelper, this.serviceName, this.serverName);
        if (assetGUID != null) {
            builder.setAnchors(userId, assetGUID, methodName);
        }
        if ((dataFieldGUID = this.createBeanInRepository(userId, externalSourceGUID, externalSourceName, "3c5bbc8b-d562-4b04-b189-c7b7f0bf2cea", "DataField", null, null, builder, methodName)) != null) {
            InstanceProperties relationshipProperties = this.repositoryHelper.addIntPropertyToInstance(this.serviceName, null, "dataFieldPosition", dataFieldPosition, methodName);
            this.linkElementToElement(userId, externalSourceGUID, externalSourceName, parentEntityGUID, parentEntityParameterName, parentEntityType, dataFieldGUID, "dataFieldGUID", "DataField", relationshipTypeGUID, relationshipTypeName, relationshipProperties, methodName);
        }
        return dataFieldGUID;
    }

    public String addDataFieldToDiscoveryReport(String userId, String externalSourceGUID, String externalSourceName, String annotationGUID, int dataFieldPosition, String dataFieldName, String dataFieldType, String dataFieldDescription, List<String> dataFieldAliases, int dataFieldSortOrder, String defaultValue, Map<String, String> additionalProperties, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String annotationGUIDParameterName = "annotationGUID";
        return this.addDataField(userId, externalSourceGUID, externalSourceName, annotationGUID, "annotationGUID", "Annotation", "60f2d263-e24d-4f20-8c0d-b5e22222cd54", "DiscoveredDataField", dataFieldPosition, dataFieldName, dataFieldType, dataFieldDescription, dataFieldAliases, dataFieldSortOrder, defaultValue, additionalProperties, methodName);
    }

    public String addDataFieldToDataField(String userId, String externalSourceGUID, String externalSourceName, String parentDataFieldGUID, int dataFieldPosition, String dataFieldName, String dataFieldType, String dataFieldDescription, List<String> dataFieldAliases, int dataFieldSortOrder, String defaultValue, Map<String, String> additionalProperties, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String parentDataFieldGUIDParameterName = "parentDataFieldGUID";
        return this.addDataField(userId, externalSourceGUID, externalSourceName, parentDataFieldGUID, "parentDataFieldGUID", "DataField", "60f2d263-e24d-4f20-8c0d-b5e12356cd54", "DiscoveredNestedDataField", dataFieldPosition, dataFieldName, dataFieldType, dataFieldDescription, dataFieldAliases, dataFieldSortOrder, defaultValue, additionalProperties, methodName);
    }

    public void updateDataField(String userId, String externalSourceGUID, String externalSourceName, String dataFieldGUID, boolean isMergeUpdate, String dataFieldName, String dataFieldType, String dataFieldDescription, List<String> dataFieldAliases, int dataFieldSortOrder, String defaultValue, Map<String, String> additionalProperties, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String dataFieldGUIDParameterName = "dataFieldGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        DataFieldBuilder builder = new DataFieldBuilder(dataFieldName, dataFieldType, dataFieldDescription, dataFieldAliases, dataFieldSortOrder, defaultValue, additionalProperties, "3c5bbc8b-d562-4b04-b189-c7b7f0bf2cea", "DataField", null, this.repositoryHelper, this.serviceName, this.serverName);
        super.updateBeanInRepository(userId, externalSourceGUID, externalSourceName, dataFieldGUID, "dataFieldGUID", "3c5bbc8b-d562-4b04-b189-c7b7f0bf2cea", "DataField", builder.getInstanceProperties(methodName), isMergeUpdate, methodName);
    }

    public void deleteDataField(String userId, String externalSourceGUID, String externalSourceName, String dataFieldGUID, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String dataFieldGUIDParameterName = "dataFieldGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(dataFieldGUID, "dataFieldGUID", methodName);
        super.deleteBeanInRepository(userId, externalSourceGUID, externalSourceName, dataFieldGUID, "dataFieldGUID", "3c5bbc8b-d562-4b04-b189-c7b7f0bf2cea", "DataField", null, null, methodName);
    }
}

