/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.generichandlers.EndpointBuilder;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericConverter;
import org.odpi.openmetadata.commonservices.generichandlers.ReferenceableHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Endpoint;
import org.odpi.openmetadata.metadatasecurity.server.OpenMetadataServerSecurityVerifier;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class EndpointHandler<B>
extends ReferenceableHandler<B> {
    public EndpointHandler(OpenMetadataAPIGenericConverter<B> converter, Class<B> beanClass, String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper, String localServerUserId, OpenMetadataServerSecurityVerifier securityVerifier, List<String> supportedZones, List<String> defaultZones, List<String> publishZones, AuditLog auditLog) {
        super(converter, beanClass, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
    }

    private String findEndpoint(String userId, Endpoint endpoint, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String guidParameterName = "endpoint.getGUID";
        String qualifiedNameParameter = "endpoint.getQualifiedName";
        String displayNameParameter = "endpoint.getDisplayName";
        if (endpoint != null) {
            if (endpoint.getGUID() != null) {
                try {
                    if (this.getEntityFromRepository(userId, endpoint.getGUID(), "Endpoint", methodName, "endpoint.getGUID") != null) {
                        return endpoint.getGUID();
                    }
                }
                catch (InvalidParameterException invalidParameterException) {
                    // empty catch block
                }
            }
            String retrievedGUID = null;
            if (endpoint.getQualifiedName() != null) {
                retrievedGUID = this.getBeanGUIDByUniqueName(userId, endpoint.getQualifiedName(), "endpoint.getQualifiedName", "qualifiedName", "114e9f8f-5ff3-4c32-bd37-a7eb42712253", "Connection", this.supportedZones, methodName);
            }
            if (retrievedGUID == null && endpoint.getDisplayName() != null) {
                retrievedGUID = this.getBeanGUIDByUniqueName(userId, endpoint.getDisplayName(), "endpoint.getDisplayName", "name", "114e9f8f-5ff3-4c32-bd37-a7eb42712253", "Connection", this.supportedZones, methodName);
            }
            return retrievedGUID;
        }
        return null;
    }

    String saveEndpoint(String userId, String externalSourceGUID, String externalSourceName, Endpoint endpoint, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String existingEndpointGUID = this.findEndpoint(userId, endpoint, methodName);
        if (existingEndpointGUID == null) {
            return this.createEndpoint(userId, externalSourceGUID, externalSourceName, null, endpoint.getQualifiedName(), endpoint.getDisplayName(), endpoint.getDescription(), endpoint.getAddress(), endpoint.getProtocol(), endpoint.getEncryptionMethod(), endpoint.getAdditionalProperties(), null, null, methodName);
        }
        this.updateEndpoint(userId, externalSourceGUID, externalSourceName, existingEndpointGUID, null, endpoint.getQualifiedName(), endpoint.getDisplayName(), endpoint.getDescription(), endpoint.getAddress(), endpoint.getProtocol(), endpoint.getEncryptionMethod(), endpoint.getAdditionalProperties(), null, null, false, methodName);
        return existingEndpointGUID;
    }

    public String createEndpoint(String userId, String externalSourceGUID, String externalSourceName, String anchorGUID, String qualifiedName, String displayName, String description, String networkAddress, String protocol, String encryptionMethod, Map<String, String> additionalProperties, String suppliedTypeName, Map<String, Object> extendedProperties, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String nameParameter = "qualifiedName";
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        String typeName = "Endpoint";
        if (suppliedTypeName != null) {
            typeName = suppliedTypeName;
        }
        String typeGUID = this.invalidParameterHandler.validateTypeName(typeName, "Endpoint", this.serviceName, methodName, this.repositoryHelper);
        EndpointBuilder builder = new EndpointBuilder(qualifiedName, displayName, description, networkAddress, protocol, encryptionMethod, additionalProperties, typeGUID, typeName, extendedProperties, this.repositoryHelper, this.serviceName, this.serverName);
        if (anchorGUID != null) {
            builder.setAnchors(userId, anchorGUID, methodName);
        }
        return this.createBeanInRepository(userId, externalSourceGUID, externalSourceName, typeGUID, typeName, qualifiedName, "qualifiedName", builder, methodName);
    }

    public String createEndpointFromTemplate(String userId, String externalSourceGUID, String externalSourceName, String templateGUID, String qualifiedName, String displayName, String description, String networkAddress, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String templateGUIDParameterName = "templateGUID";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(templateGUID, "templateGUID", methodName);
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        EndpointBuilder builder = new EndpointBuilder(qualifiedName, displayName, description, networkAddress, this.repositoryHelper, this.serviceName, this.serverName);
        return this.createBeanFromTemplate(userId, externalSourceGUID, externalSourceName, templateGUID, "templateGUID", "dbc20663-d705-4ff0-8424-80c262c6b8e7", "Endpoint", qualifiedName, "qualifiedName", builder, methodName);
    }

    String getEndpointForConnection(String userId, String externalSourceGUID, String externalSourceName, String anchorGUID, String qualifiedName, String displayName, String description, String networkAddress, String protocol, String encryptionMethod, Map<String, String> additionalProperties, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String networkAddressParameterName = "networkAddress";
        ArrayList<String> propertyNames = new ArrayList<String>();
        propertyNames.add("networkAddress");
        List<EntityDetail> currentEndpoints = this.getEntitiesByValue(userId, networkAddress, "networkAddress", "dbc20663-d705-4ff0-8424-80c262c6b8e7", "Endpoint", propertyNames, true, null, null, false, this.supportedZones, null, 0, this.invalidParameterHandler.getMaxPagingSize(), methodName);
        if (currentEndpoints != null && !currentEndpoints.isEmpty()) {
            for (EntityDetail endpoint : currentEndpoints) {
                if (endpoint == null || endpoint.getGUID() == null) continue;
                return endpoint.getGUID();
            }
        }
        return this.createEndpoint(userId, externalSourceGUID, externalSourceName, anchorGUID, qualifiedName, displayName, description, networkAddress, protocol, encryptionMethod, additionalProperties, null, null, methodName);
    }

    public void updateEndpoint(String userId, String externalSourceGUID, String externalSourceName, String endpointGUID, String endpointGUIDParameterName, String qualifiedName, String displayName, String description, String networkAddress, String protocol, String encryptionMethod, Map<String, String> additionalProperties, String suppliedTypeName, Map<String, Object> extendedProperties, boolean isMergeUpdate, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String nameParameter = "qualifiedName";
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        String typeName = "Endpoint";
        if (suppliedTypeName != null) {
            typeName = suppliedTypeName;
        }
        String typeGUID = this.invalidParameterHandler.validateTypeName(typeName, "Endpoint", this.serviceName, methodName, this.repositoryHelper);
        EndpointBuilder builder = new EndpointBuilder(qualifiedName, displayName, description, networkAddress, protocol, encryptionMethod, additionalProperties, typeGUID, typeName, extendedProperties, this.repositoryHelper, this.serviceName, this.serverName);
        this.updateBeanInRepository(userId, externalSourceGUID, externalSourceName, endpointGUID, endpointGUIDParameterName, typeGUID, typeName, this.supportedZones, builder.getInstanceProperties(methodName), isMergeUpdate, methodName);
    }

    public void removeEndpoint(String userId, String externalSourceGUID, String externalSourceName, String guid, String guidParameterName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.deleteBeanInRepository(userId, externalSourceGUID, externalSourceName, guid, guidParameterName, "dbc20663-d705-4ff0-8424-80c262c6b8e7", "Endpoint", null, null, methodName);
    }

    public List<B> getEndpointsByNetworkAddress(String userId, String networkAddress, String networkAddressParameterName, List<String> serviceSupportedZones, int startFrom, int pageSize, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        ArrayList<String> propertyNames = new ArrayList<String>();
        propertyNames.add("networkAddress");
        return this.getBeansByValue(userId, networkAddress, networkAddressParameterName, "dbc20663-d705-4ff0-8424-80c262c6b8e7", "Endpoint", propertyNames, true, null, null, false, serviceSupportedZones, null, startFrom, pageSize, methodName);
    }

    public List<B> findEndpoints(String userId, String searchString, String searchStringParameterName, int startFrom, int pageSize, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.findBeans(userId, searchString, searchStringParameterName, "dbc20663-d705-4ff0-8424-80c262c6b8e7", "Endpoint", null, startFrom, pageSize, methodName);
    }

    public List<B> getEndpointsByName(String userId, String name, String nameParameterName, int startFrom, int pageSize, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        ArrayList<String> specificMatchPropertyNames = new ArrayList<String>();
        specificMatchPropertyNames.add("qualifiedName");
        specificMatchPropertyNames.add("displayName");
        specificMatchPropertyNames.add("networkAddress");
        return this.getBeansByValue(userId, name, nameParameterName, "dbc20663-d705-4ff0-8424-80c262c6b8e7", "Endpoint", specificMatchPropertyNames, true, null, null, false, this.supportedZones, null, startFrom, pageSize, methodName);
    }

    public B getEndpointByGUID(String userId, String guid, String guidParameterName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.getBeanFromRepository(userId, guid, guidParameterName, "Endpoint", methodName);
    }
}

