/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericConverter;
import org.odpi.openmetadata.commonservices.generichandlers.ReferenceableHandler;
import org.odpi.openmetadata.commonservices.generichandlers.UserIdentityBuilder;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.metadatasecurity.server.OpenMetadataServerSecurityVerifier;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class UserIdentityHandler<B>
extends ReferenceableHandler<B> {
    public UserIdentityHandler(OpenMetadataAPIGenericConverter<B> converter, Class<B> beanClass, String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper, String localServerUserId, OpenMetadataServerSecurityVerifier securityVerifier, List<String> supportedZones, List<String> defaultZones, List<String> publishZones, AuditLog auditLog) {
        super(converter, beanClass, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
    }

    public String createUserIdentity(String userId, String externalSourceGUID, String externalSourceName, String profileGUID, String profileGUIDParameterName, String qualifiedName, Map<String, String> additionalProperties, String suppliedTypeName, Map<String, Object> extendedProperties, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String userIdentityGUID;
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        String typeName = "UserIdentity";
        if (suppliedTypeName != null) {
            typeName = suppliedTypeName;
        }
        String typeGUID = this.invalidParameterHandler.validateTypeName(typeName, "UserIdentity", this.serviceName, methodName, this.repositoryHelper);
        UserIdentityBuilder builder = new UserIdentityBuilder(qualifiedName, additionalProperties, typeGUID, typeName, extendedProperties, this.repositoryHelper, this.serviceName, this.serverName);
        if (profileGUID != null) {
            builder.setAnchors(userId, profileGUID, methodName);
        }
        if ((userIdentityGUID = this.createBeanInRepository(userId, externalSourceGUID, externalSourceName, typeGUID, typeName, qualifiedName, "qualifiedName", builder, methodName)) != null && profileGUID != null) {
            String userIdentityGUIDParameterName = "userIdentityGUID";
            this.linkElementToElement(userId, externalSourceGUID, externalSourceName, profileGUID, profileGUIDParameterName, "ActorProfile", userIdentityGUID, "userIdentityGUID", "UserIdentity", this.supportedZones, "01664609-e777-4079-b543-6baffe910ff1", "ProfileIdentity", null, methodName);
        }
        return userIdentityGUID;
    }

    public void updateUserIdentity(String userId, String externalSourceGUID, String externalSourceName, String userIdentityGUID, String userIdentityGUIDParameterName, String qualifiedName, Map<String, String> additionalProperties, String typeName, Map<String, Object> extendedProperties, boolean isMergeUpdate, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(userIdentityGUID, userIdentityGUIDParameterName, methodName);
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        String typeGUID = this.invalidParameterHandler.validateTypeName(typeName, "UserIdentity", this.serviceName, methodName, this.repositoryHelper);
        UserIdentityBuilder builder = new UserIdentityBuilder(qualifiedName, additionalProperties, typeGUID, typeName, extendedProperties, this.repositoryHelper, this.serviceName, this.serverName);
        this.updateBeanInRepository(userId, externalSourceGUID, externalSourceName, userIdentityGUID, userIdentityGUIDParameterName, typeGUID, typeName, builder.getInstanceProperties(methodName), isMergeUpdate, methodName);
    }

    public void deleteUserIdentity(String userId, String externalSourceGUID, String externalSourceName, String userIdentityGUID, String userIdentityGUIDParameterName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.deleteBeanInRepository(userId, externalSourceGUID, externalSourceName, userIdentityGUID, userIdentityGUIDParameterName, "fbe95779-1f3c-4ac6-aa9d-24963ff16282", "UserIdentity", null, null, methodName);
    }

    public void addIdentityToProfile(String userId, String externalSourceGUID, String externalSourceName, String userIdentityGUID, String userIdentityGUIDParameterName, String profileGUID, String profileGUIDParameterName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.relinkElementToNewElement(userId, externalSourceGUID, externalSourceName, userIdentityGUID, userIdentityGUIDParameterName, "UserIdentity", true, profileGUID, profileGUIDParameterName, "ActorProfile", this.supportedZones, "01664609-e777-4079-b543-6baffe910ff1", "ProfileIdentity", null, methodName);
    }

    public void removeIdentifyFromProfile(String userId, String externalSourceGUID, String externalSourceName, String userIdentityGUID, String userIdentityGUIDParameterName, String profileGUID, String profileGUIDParameterName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.unlinkElementFromElement(userId, false, externalSourceGUID, externalSourceName, profileGUID, profileGUIDParameterName, "ActorProfile", userIdentityGUID, userIdentityGUIDParameterName, "fbe95779-1f3c-4ac6-aa9d-24963ff16282", "UserIdentity", (List<String>)this.supportedZones, "01664609-e777-4079-b543-6baffe910ff1", "ProfileIdentity", methodName);
    }

    public List<B> getUserIdentitiesByName(String userId, String name, String nameParameterName, int startFrom, int pageSize, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.getBeansByQualifiedName(userId, "fbe95779-1f3c-4ac6-aa9d-24963ff16282", "UserIdentity", name, nameParameterName, this.supportedZones, startFrom, pageSize, methodName);
    }

    public B getUserIdentityByGUID(String userId, String guid, String guidParameterName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.getBeanFromRepository(userId, guid, guidParameterName, "UserIdentity", methodName);
    }
}

