/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericConverter;
import org.odpi.openmetadata.commonservices.generichandlers.ReferenceableHandler;
import org.odpi.openmetadata.commonservices.generichandlers.ValidValuesBuilder;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.metadatasecurity.server.OpenMetadataServerSecurityVerifier;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityProxy;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class ValidValuesHandler<VALID_VALUE, VALID_VALUE_ASSIGNMENT, VALID_VALUE_ASSIGNMENT_DEF, VALID_VALUE_IMPLEMENTATION, VALID_VALUE_IMPLEMENTATION_DEF, VALID_VALUE_MAPPING, REFERENCE_VALUE_ASSIGNMENT, REFERENCE_VALUE_ASSIGNED_ITEM>
extends ReferenceableHandler<VALID_VALUE> {
    private OpenMetadataAPIGenericConverter<VALID_VALUE_ASSIGNMENT> validValueAssignmentConverter;
    private Class<VALID_VALUE_ASSIGNMENT> validValueAssignmentClass;
    private OpenMetadataAPIGenericConverter<VALID_VALUE_ASSIGNMENT_DEF> validValueAssignmentDefConverter;
    private Class<VALID_VALUE_ASSIGNMENT_DEF> validValueAssignmentDefClass;
    private OpenMetadataAPIGenericConverter<VALID_VALUE_IMPLEMENTATION> validValueImplementationConverter;
    private Class<VALID_VALUE_IMPLEMENTATION> validValueImplementationClass;
    private OpenMetadataAPIGenericConverter<VALID_VALUE_IMPLEMENTATION_DEF> validValueImplementationDefConverter;
    private Class<VALID_VALUE_IMPLEMENTATION_DEF> validValueImplementationDefClass;
    private OpenMetadataAPIGenericConverter<VALID_VALUE_MAPPING> validValueMappingConverter;
    private Class<VALID_VALUE_MAPPING> validValueMappingClass;
    private OpenMetadataAPIGenericConverter<REFERENCE_VALUE_ASSIGNMENT> referenceValueAssignmentConverter;
    private Class<REFERENCE_VALUE_ASSIGNMENT> referenceValueAssignmentClass;
    private OpenMetadataAPIGenericConverter<REFERENCE_VALUE_ASSIGNED_ITEM> referenceValueAssignedItemConverter;
    private Class<REFERENCE_VALUE_ASSIGNED_ITEM> referenceValueAssignedItemClass;

    public ValidValuesHandler(OpenMetadataAPIGenericConverter<VALID_VALUE> converter, Class<VALID_VALUE> beanClass, OpenMetadataAPIGenericConverter<VALID_VALUE_ASSIGNMENT> validValueAssignmentConverter, Class<VALID_VALUE_ASSIGNMENT> validValueAssignmentClass, OpenMetadataAPIGenericConverter<VALID_VALUE_ASSIGNMENT_DEF> validValueAssignmentDefConverter, Class<VALID_VALUE_ASSIGNMENT_DEF> validValueAssignmentDefClass, OpenMetadataAPIGenericConverter<VALID_VALUE_IMPLEMENTATION> validValueImplementationConverter, Class<VALID_VALUE_IMPLEMENTATION> validValueImplementationClass, OpenMetadataAPIGenericConverter<VALID_VALUE_IMPLEMENTATION_DEF> validValueImplementationDefConverter, Class<VALID_VALUE_IMPLEMENTATION_DEF> validValueImplementationDefClass, OpenMetadataAPIGenericConverter<VALID_VALUE_MAPPING> validValueMappingConverter, Class<VALID_VALUE_MAPPING> validValueMappingClass, OpenMetadataAPIGenericConverter<REFERENCE_VALUE_ASSIGNMENT> referenceValueAssignmentConverter, Class<REFERENCE_VALUE_ASSIGNMENT> referenceValueAssignmentClass, OpenMetadataAPIGenericConverter<REFERENCE_VALUE_ASSIGNED_ITEM> referenceValueAssignedItemConverter, Class<REFERENCE_VALUE_ASSIGNED_ITEM> referenceValueAssignedItemClass, String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper, String localServerUserId, OpenMetadataServerSecurityVerifier securityVerifier, List<String> supportedZones, List<String> defaultZones, List<String> publishZones, AuditLog auditLog) {
        super(converter, beanClass, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
        this.validValueAssignmentConverter = validValueAssignmentConverter;
        this.validValueAssignmentClass = validValueAssignmentClass;
        this.validValueAssignmentDefConverter = validValueAssignmentDefConverter;
        this.validValueAssignmentDefClass = validValueAssignmentDefClass;
        this.validValueImplementationConverter = validValueImplementationConverter;
        this.validValueImplementationClass = validValueImplementationClass;
        this.validValueImplementationDefConverter = validValueImplementationDefConverter;
        this.validValueImplementationDefClass = validValueImplementationDefClass;
        this.validValueMappingConverter = validValueMappingConverter;
        this.validValueMappingClass = validValueMappingClass;
        this.referenceValueAssignmentConverter = referenceValueAssignmentConverter;
        this.referenceValueAssignmentClass = referenceValueAssignmentClass;
        this.referenceValueAssignedItemConverter = referenceValueAssignedItemConverter;
        this.referenceValueAssignedItemClass = referenceValueAssignedItemClass;
    }

    public String createValidValueSet(String userId, String externalSourceGUID, String externalSourceName, String qualifiedName, String displayName, String description, String usage, String scope, boolean isDeprecated, Map<String, String> additionalProperties, Map<String, Object> extendedProperties, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String nameParameter = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        ValidValuesBuilder builder = new ValidValuesBuilder(qualifiedName, displayName, description, usage, scope, null, isDeprecated, additionalProperties, extendedProperties, this.repositoryHelper, this.serviceName, this.serverName);
        return this.createBeanInRepository(userId, externalSourceGUID, externalSourceName, "7de10805-7c44-40e3-a410-ffc51306801b", "ValidValuesSet", qualifiedName, "qualifiedName", builder, methodName);
    }

    public String createValidValueDefinition(String userId, String externalSourceGUID, String externalSourceName, String setGUID, String qualifiedName, String displayName, String description, String usage, String scope, String preferredValue, boolean isDeprecated, Map<String, String> additionalProperties, Map<String, Object> extendedProperties, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String nameParameter = "qualifiedName";
        String setParameter = "setGUID";
        String definitionParameter = "definitionGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        ValidValuesBuilder builder = new ValidValuesBuilder(qualifiedName, displayName, description, usage, scope, preferredValue, isDeprecated, additionalProperties, extendedProperties, this.repositoryHelper, this.serviceName, this.serverName);
        String definitionGUID = this.createBeanInRepository(userId, externalSourceGUID, externalSourceName, "09b2133a-f045-42cc-bb00-ee602b74c618", "ValidValueDefinition", qualifiedName, "qualifiedName", builder, methodName);
        if (definitionGUID != null && setGUID != null) {
            this.linkElementToElement(userId, externalSourceGUID, externalSourceName, setGUID, "setGUID", "ValidValuesSet", definitionGUID, "definitionGUID", "ValidValueDefinition", "6337c9cd-8e5a-461b-97f9-5151bcb97a9e", "ValidValueMember", null, methodName);
        }
        return definitionGUID;
    }

    public void updateValidValue(String userId, String externalSourceGUID, String externalSourceName, String validValueGUID, String qualifiedName, String displayName, String description, String usage, String scope, String preferredValue, boolean isDeprecated, Map<String, String> additionalProperties, Map<String, Object> extendedProperties, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String guidParameter = "validValueGUID";
        String nameParameter = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(validValueGUID, "validValueGUID", methodName);
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        ValidValuesBuilder builder = new ValidValuesBuilder(qualifiedName, displayName, description, usage, scope, preferredValue, isDeprecated, additionalProperties, extendedProperties, this.repositoryHelper, this.serviceName, this.serverName);
        this.updateBeanInRepository(userId, externalSourceGUID, externalSourceName, validValueGUID, "validValueGUID", "09b2133a-f045-42cc-bb00-ee602b74c618", "ValidValueDefinition", builder.getInstanceProperties(methodName), false, methodName);
    }

    public void deleteValidValue(String userId, String externalSourceGUID, String externalSourceName, String validValueGUID, String qualifiedName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String guidParameter = "validValueGUID";
        String nameParameter = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(validValueGUID, "validValueGUID", methodName);
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        this.deleteBeanInRepository(userId, externalSourceGUID, externalSourceName, validValueGUID, "validValueGUID", "09b2133a-f045-42cc-bb00-ee602b74c618", "ValidValueDefinition", "qualifiedName", qualifiedName, methodName);
    }

    public void attachValidValueToSet(String userId, String externalSourceGUID, String externalSourceName, String setGUID, String validValueGUID, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String setGUIDParameter = "setGUID";
        String validValueGUIDParameter = "validValueGUID";
        this.linkElementToElement(userId, externalSourceGUID, externalSourceName, setGUID, "setGUID", "ValidValuesSet", validValueGUID, "validValueGUID", "ValidValueDefinition", "6337c9cd-8e5a-461b-97f9-5151bcb97a9e", "ValidValueMember", null, methodName);
    }

    public void detachValidValueFromSet(String userId, String externalSourceGUID, String externalSourceName, String setGUID, String validValueGUID, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String setGUIDParameter = "setGUID";
        String validValueGUIDParameter = "validValueGUID";
        this.unlinkElementFromElement(userId, false, externalSourceGUID, externalSourceName, setGUID, "setGUID", "ValidValuesSet", validValueGUID, "validValueGUID", "09b2133a-f045-42cc-bb00-ee602b74c618", "ValidValueDefinition", "6337c9cd-8e5a-461b-97f9-5151bcb97a9e", "ValidValueMember", methodName);
    }

    public void linkValidValueToImplementation(String userId, String externalSourceGUID, String externalSourceName, String validValueGUID, String assetGUID, String symbolicName, String implementationValue, Map<String, String> additionalValues, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String validValueGUIDParameter = "validValueGUID";
        String assetGUIDParameter = "assetGUID";
        InstanceProperties properties = null;
        if (symbolicName != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, "symbolicName", symbolicName, methodName);
        }
        if (implementationValue != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "implementationValue", implementationValue, methodName);
        }
        if (additionalValues != null && !additionalValues.isEmpty()) {
            properties = this.repositoryHelper.addStringMapPropertyToInstance(this.serviceName, properties, "additionalValues", additionalValues, methodName);
        }
        this.linkElementToElement(userId, externalSourceGUID, externalSourceName, validValueGUID, "validValueGUID", "ValidValueDefinition", assetGUID, "assetGUID", "Asset", "d9a39553-6a47-4477-a217-844300c07cf2", "ValidValuesImplementation", properties, methodName);
    }

    public void unlinkValidValueFromImplementation(String userId, String externalSourceGUID, String externalSourceName, String validValueGUID, String assetGUID, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String validValueGUIDParameter = "validValueGUID";
        String assetGUIDParameter = "assetGUID";
        this.unlinkElementFromElement(userId, false, externalSourceGUID, externalSourceName, validValueGUID, "validValueGUID", "ValidValueDefinition", assetGUID, "assetGUID", "896d14c2-7522-4f6c-8519-757711943fe6", "Asset", "d9a39553-6a47-4477-a217-844300c07cf2", "ValidValuesImplementation", methodName);
    }

    public void assignValidValueToConsumer(String userId, String externalSourceGUID, String externalSourceName, String validValueGUID, String consumerGUID, boolean strictRequirement, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String validValueGUIDParameter = "validValueGUID";
        String consumerGUIDParameter = "consumerGUID";
        InstanceProperties relationshipProperties = this.repositoryHelper.addBooleanPropertyToInstance(this.serviceName, null, "strictRequirement", strictRequirement, methodName);
        this.linkElementToElement(userId, externalSourceGUID, externalSourceName, consumerGUID, "consumerGUID", "Referenceable", validValueGUID, "validValueGUID", "ValidValueDefinition", "c5d48b73-eadd-47db-ab64-3be99b2fb32d", "ValidValuesAssignment", relationshipProperties, methodName);
    }

    public void unassignValidValueFromConsumer(String userId, String externalSourceGUID, String externalSourceName, String validValueGUID, String consumerGUID, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String validValueGUIDParameter = "validValueGUID";
        String consumerGUIDParameter = "consumerGUID";
        this.unlinkElementFromElement(userId, false, externalSourceGUID, externalSourceName, consumerGUID, "consumerGUID", "Referenceable", validValueGUID, "validValueGUID", "09b2133a-f045-42cc-bb00-ee602b74c618", "ValidValueDefinition", "c5d48b73-eadd-47db-ab64-3be99b2fb32d", "ValidValuesAssignment", methodName);
    }

    public void assignReferenceValueToItem(String userId, String externalSourceGUID, String externalSourceName, String validValueGUID, String referenceableGUID, int confidence, String steward, String notes, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String validValueGUIDParameter = "validValueGUID";
        String referenceableGUIDParameter = "referenceableGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(validValueGUID, "validValueGUID", methodName);
        this.invalidParameterHandler.validateGUID(referenceableGUID, "referenceableGUID", methodName);
        InstanceProperties relationshipProperties = this.repositoryHelper.addIntPropertyToInstance(this.serviceName, null, "confidence", confidence, methodName);
        if (steward != null) {
            relationshipProperties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, "steward", steward, methodName);
        }
        if (notes != null) {
            relationshipProperties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, "notes", notes, methodName);
        }
        this.linkElementToElement(userId, externalSourceGUID, externalSourceName, referenceableGUID, "referenceableGUID", "Referenceable", validValueGUID, "validValueGUID", "ValidValueDefinition", "111e6d2e-94e9-43ed-b4ed-f0d220668cbf", "ReferenceValueAssignment", relationshipProperties, methodName);
    }

    public void unassignReferenceValueFromItem(String userId, String externalSourceGUID, String externalSourceName, String validValueGUID, String referenceableGUID, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String validValueGUIDParameter = "validValueGUID";
        String referenceableGUIDParameter = "referenceableGUID";
        this.unlinkElementFromElement(userId, false, externalSourceGUID, externalSourceName, referenceableGUID, "referenceableGUID", "Referenceable", validValueGUID, "validValueGUID", "09b2133a-f045-42cc-bb00-ee602b74c618", "ValidValueDefinition", "111e6d2e-94e9-43ed-b4ed-f0d220668cbf", "ReferenceValueAssignment", methodName);
    }

    public void mapValidValues(String userId, String externalSourceGUID, String externalSourceName, String validValue1GUID, String validValue2GUID, String associationDescription, int confidence, String steward, String notes, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String validValue1GUIDParameter = "validValue1GUID";
        String validValue2GUIDParameter = "validValue2GUID";
        InstanceProperties relationshipProperties = this.repositoryHelper.addIntPropertyToInstance(this.serviceName, null, "confidence", confidence, methodName);
        if (associationDescription != null) {
            relationshipProperties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, "associationDescription", associationDescription, methodName);
        }
        if (steward != null) {
            relationshipProperties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, "steward", steward, methodName);
        }
        if (notes != null) {
            relationshipProperties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, "notes", notes, methodName);
        }
        this.linkElementToElement(userId, externalSourceGUID, externalSourceName, validValue2GUID, "validValue2GUID", "ValidValueDefinition", validValue1GUID, "validValue1GUID", "ValidValueDefinition", "203ce62c-3cbf-4542-bf82-81820cba718f", "203ce62c-3cbf-4542-bf82-81820cba718f", relationshipProperties, methodName);
    }

    public void unmapValidValues(String userId, String externalSourceGUID, String externalSourceName, String validValue1GUID, String validValue2GUID, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String validValue1GUIDParameter = "validValue1GUID";
        String validValue2GUIDParameter = "validValue2GUID";
        this.unlinkElementFromElement(userId, false, externalSourceGUID, externalSourceName, validValue2GUID, "validValue2GUID", "ValidValueDefinition", validValue1GUID, "validValue1GUID", "09b2133a-f045-42cc-bb00-ee602b74c618", "ValidValueDefinition", "203ce62c-3cbf-4542-bf82-81820cba718f", "203ce62c-3cbf-4542-bf82-81820cba718f", methodName);
    }

    public VALID_VALUE getValidValueByGUID(String userId, String validValueGUID, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String validValueGUIDParameter = "validValueGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(validValueGUID, "validValueGUID", methodName);
        VALID_VALUE validValue = null;
        EntityDetail entity = this.repositoryHandler.getEntityByGUID(userId, validValueGUID, "validValueGUID", "ValidValueDefinition", methodName);
        if (entity != null) {
            validValue = (VALID_VALUE)this.converter.getNewBean(this.beanClass, entity, methodName);
        }
        return validValue;
    }

    public List<VALID_VALUE> getValidValueByName(String userId, String name, String nameParameterName, int startFrom, int pageSize, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        ArrayList<String> specificMatchPropertyNames = new ArrayList<String>();
        specificMatchPropertyNames.add("qualifiedName");
        specificMatchPropertyNames.add("name");
        return this.getBeansByValue(userId, name, nameParameterName, "09b2133a-f045-42cc-bb00-ee602b74c618", "ValidValueDefinition", specificMatchPropertyNames, true, null, null, false, this.supportedZones, null, startFrom, pageSize, methodName);
    }

    public List<VALID_VALUE> findValidValues(String userId, String searchString, String searchStringParameterName, int startFrom, int pageSize, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.findBeans(userId, searchString, searchStringParameterName, "09b2133a-f045-42cc-bb00-ee602b74c618", "ValidValueDefinition", null, startFrom, pageSize, methodName);
    }

    public List<VALID_VALUE> getValidValueSetMembers(String userId, String validValueSetGUID, String validValueSetGUIDParameter, int startFrom, int pageSize, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.getAttachedElements(userId, null, null, validValueSetGUID, validValueSetGUIDParameter, "ValidValuesSet", "6337c9cd-8e5a-461b-97f9-5151bcb97a9e", "ValidValueMember", "ValidValueDefinition", null, null, 2, this.supportedZones, startFrom, pageSize, methodName);
    }

    public List<VALID_VALUE> getSetsForValidValue(String userId, String validValueGUID, String validValueGUIDParameter, int startFrom, int pageSize, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.getAttachedElements(userId, null, null, validValueGUID, validValueGUIDParameter, "ValidValueDefinition", "6337c9cd-8e5a-461b-97f9-5151bcb97a9e", "ValidValueMember", "ValidValuesSet", null, null, 1, this.supportedZones, startFrom, pageSize, methodName);
    }

    public List<VALID_VALUE_ASSIGNMENT> getValidValuesAssignmentConsumers(String userId, String validValueGUID, String validValueGUIDParameter, List<String> serviceSupportedZones, int startFrom, int pageSize, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String guidParameterName = "relationship.end1.guid";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(validValueGUID, validValueGUIDParameter, methodName);
        this.validateAnchorEntity(userId, validValueGUID, validValueGUIDParameter, "ValidValueDefinition", false, serviceSupportedZones, methodName);
        List<Relationship> relationships = this.getAttachmentLinks(userId, validValueGUID, validValueGUIDParameter, "ValidValueDefinition", "c5d48b73-eadd-47db-ab64-3be99b2fb32d", "ValidValuesAssignment", "Referenceable", startFrom, pageSize, methodName);
        if (relationships == null || relationships.isEmpty()) {
            return null;
        }
        ArrayList<VALID_VALUE_ASSIGNMENT> results = new ArrayList<VALID_VALUE_ASSIGNMENT>();
        for (Relationship relationship : relationships) {
            EntityProxy end1;
            if (relationship == null || (end1 = relationship.getEntityOneProxy()) == null) continue;
            try {
                EntityDetail consumerEntity = this.repositoryHandler.getEntityByGUID(userId, end1.getGUID(), "relationship.end1.guid", "Referenceable", methodName);
                this.validateAnchorEntity(userId, end1.getGUID(), "Referenceable", consumerEntity, "relationship.end1.guid", false, serviceSupportedZones, methodName);
                VALID_VALUE_ASSIGNMENT bean = this.validValueAssignmentConverter.getNewBean(this.validValueAssignmentClass, consumerEntity, relationship, methodName);
                if (bean == null) continue;
                results.add(bean);
            }
            catch (InvalidParameterException | UserNotAuthorizedException throwable) {}
        }
        if (results.isEmpty()) {
            return null;
        }
        return results;
    }

    public List<VALID_VALUE_ASSIGNMENT_DEF> getValidValuesAssignmentDefinition(String userId, String referenceableGUID, String referenceableGUIDParameter, int startFrom, int pageSize, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String guidParameterName = "relationship.end2.guid";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(referenceableGUID, referenceableGUIDParameter, methodName);
        this.validateAnchorEntity(userId, referenceableGUID, referenceableGUIDParameter, "Referenceable", false, this.supportedZones, methodName);
        List<Relationship> relationships = this.getAttachmentLinks(userId, referenceableGUID, referenceableGUIDParameter, "Referenceable", "c5d48b73-eadd-47db-ab64-3be99b2fb32d", "ValidValuesAssignment", "ValidValueDefinition", startFrom, pageSize, methodName);
        if (relationships == null || relationships.isEmpty()) {
            return null;
        }
        ArrayList<VALID_VALUE_ASSIGNMENT_DEF> results = new ArrayList<VALID_VALUE_ASSIGNMENT_DEF>();
        for (Relationship relationship : relationships) {
            EntityProxy end2;
            if (relationship == null || (end2 = relationship.getEntityTwoProxy()) == null) continue;
            try {
                EntityDetail consumerEntity = this.repositoryHandler.getEntityByGUID(userId, end2.getGUID(), "relationship.end2.guid", "ValidValueDefinition", methodName);
                this.validateAnchorEntity(userId, end2.getGUID(), "ValidValueDefinition", consumerEntity, "relationship.end2.guid", false, this.supportedZones, methodName);
                VALID_VALUE_ASSIGNMENT_DEF bean = this.validValueAssignmentDefConverter.getNewBean(this.validValueAssignmentDefClass, consumerEntity, relationship, methodName);
                if (bean == null) continue;
                results.add(bean);
            }
            catch (InvalidParameterException | UserNotAuthorizedException throwable) {}
        }
        if (results.isEmpty()) {
            return null;
        }
        return results;
    }

    public List<VALID_VALUE_IMPLEMENTATION> getValidValuesImplementationAssets(String userId, String validValueGUID, String validValueGUIDParameter, List<String> serviceSupportedZones, int startFrom, int pageSize, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String guidParameterName = "relationship.end1.guid";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(validValueGUID, validValueGUIDParameter, methodName);
        this.validateAnchorEntity(userId, validValueGUID, validValueGUIDParameter, "ValidValueDefinition", false, serviceSupportedZones, methodName);
        List<Relationship> relationships = this.getAttachmentLinks(userId, validValueGUID, validValueGUIDParameter, "ValidValueDefinition", "d9a39553-6a47-4477-a217-844300c07cf2", "ValidValuesImplementation", "Asset", startFrom, pageSize, methodName);
        if (relationships == null || relationships.isEmpty()) {
            return null;
        }
        ArrayList<VALID_VALUE_IMPLEMENTATION> results = new ArrayList<VALID_VALUE_IMPLEMENTATION>();
        for (Relationship relationship : relationships) {
            EntityProxy end1;
            if (relationship == null || (end1 = relationship.getEntityOneProxy()) == null) continue;
            try {
                EntityDetail consumerEntity = this.repositoryHandler.getEntityByGUID(userId, end1.getGUID(), "relationship.end1.guid", "Asset", methodName);
                this.validateAnchorEntity(userId, end1.getGUID(), "Asset", consumerEntity, "relationship.end1.guid", false, serviceSupportedZones, methodName);
                VALID_VALUE_IMPLEMENTATION bean = this.validValueImplementationConverter.getNewBean(this.validValueImplementationClass, consumerEntity, relationship, methodName);
                if (bean == null) continue;
                results.add(bean);
            }
            catch (InvalidParameterException | UserNotAuthorizedException throwable) {}
        }
        if (results.isEmpty()) {
            return null;
        }
        return results;
    }

    public List<VALID_VALUE_IMPLEMENTATION_DEF> getValidValuesImplementationDefinitions(String userId, String assetGUID, String assetGUIDParameter, int startFrom, int pageSize, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String guidParameterName = "relationship.end2.guid";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(assetGUID, assetGUIDParameter, methodName);
        this.validateAnchorEntity(userId, assetGUID, assetGUIDParameter, "Asset", false, this.supportedZones, methodName);
        List<Relationship> relationships = this.getAttachmentLinks(userId, assetGUID, assetGUIDParameter, "Asset", "d9a39553-6a47-4477-a217-844300c07cf2", "ValidValuesImplementation", "ValidValueDefinition", startFrom, pageSize, methodName);
        if (relationships == null || relationships.isEmpty()) {
            return null;
        }
        ArrayList<VALID_VALUE_IMPLEMENTATION_DEF> results = new ArrayList<VALID_VALUE_IMPLEMENTATION_DEF>();
        for (Relationship relationship : relationships) {
            EntityProxy end2;
            if (relationship == null || (end2 = relationship.getEntityTwoProxy()) == null) continue;
            try {
                EntityDetail consumerEntity = this.repositoryHandler.getEntityByGUID(userId, end2.getGUID(), "relationship.end2.guid", "ValidValueDefinition", methodName);
                this.validateAnchorEntity(userId, end2.getGUID(), "ValidValueDefinition", consumerEntity, "relationship.end2.guid", false, this.supportedZones, methodName);
                VALID_VALUE_IMPLEMENTATION_DEF bean = this.validValueImplementationDefConverter.getNewBean(this.validValueImplementationDefClass, consumerEntity, relationship, methodName);
                if (bean == null) continue;
                results.add(bean);
            }
            catch (InvalidParameterException | UserNotAuthorizedException throwable) {}
        }
        if (results.isEmpty()) {
            return null;
        }
        return results;
    }

    public List<VALID_VALUE_MAPPING> getValidValueMappings(String userId, String validValueGUID, String validValueGUIDParameter, int startFrom, int pageSize, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String guidParameterName = "relationship.end1.guid";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(validValueGUID, validValueGUIDParameter, methodName);
        this.validateAnchorEntity(userId, validValueGUID, validValueGUIDParameter, "ValidValueDefinition", false, this.supportedZones, methodName);
        List<Relationship> relationships = this.getAttachmentLinks(userId, validValueGUID, validValueGUIDParameter, "ValidValueDefinition", "203ce62c-3cbf-4542-bf82-81820cba718f", "ValidValuesMapping", "ValidValueDefinition", startFrom, pageSize, methodName);
        if (relationships == null || relationships.isEmpty()) {
            return null;
        }
        ArrayList<VALID_VALUE_MAPPING> results = new ArrayList<VALID_VALUE_MAPPING>();
        for (Relationship relationship : relationships) {
            EntityProxy proxy;
            if (relationship == null || (proxy = this.repositoryHandler.getOtherEnd(validValueGUID, "ValidValueDefinition", relationship, methodName)) == null) continue;
            try {
                EntityDetail consumerEntity = this.repositoryHandler.getEntityByGUID(userId, proxy.getGUID(), "relationship.end1.guid", "ValidValueDefinition", methodName);
                this.validateAnchorEntity(userId, proxy.getGUID(), "ValidValueDefinition", consumerEntity, "relationship.end1.guid", false, this.supportedZones, methodName);
                VALID_VALUE_MAPPING bean = this.validValueMappingConverter.getNewBean(this.validValueMappingClass, consumerEntity, relationship, methodName);
                if (bean == null) continue;
                results.add(bean);
            }
            catch (InvalidParameterException | UserNotAuthorizedException throwable) {}
        }
        if (results.isEmpty()) {
            return null;
        }
        return results;
    }

    public List<REFERENCE_VALUE_ASSIGNED_ITEM> getReferenceValueAssignedItems(String userId, String validValueGUID, String validValueGUIDParameter, List<String> serviceSupportedZones, int startFrom, int pageSize, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String guidParameterName = "relationship.end1.guid";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(validValueGUID, validValueGUIDParameter, methodName);
        this.validateAnchorEntity(userId, validValueGUID, validValueGUIDParameter, "ValidValueDefinition", false, serviceSupportedZones, methodName);
        List<Relationship> relationships = this.getAttachmentLinks(userId, validValueGUID, validValueGUIDParameter, "ValidValueDefinition", "111e6d2e-94e9-43ed-b4ed-f0d220668cbf", "ReferenceValueAssignment", "Referenceable", startFrom, pageSize, methodName);
        if (relationships == null || relationships.isEmpty()) {
            return null;
        }
        ArrayList<REFERENCE_VALUE_ASSIGNED_ITEM> results = new ArrayList<REFERENCE_VALUE_ASSIGNED_ITEM>();
        for (Relationship relationship : relationships) {
            EntityProxy end1;
            if (relationship == null || (end1 = relationship.getEntityOneProxy()) == null) continue;
            try {
                EntityDetail consumerEntity = this.repositoryHandler.getEntityByGUID(userId, end1.getGUID(), "relationship.end1.guid", "Referenceable", methodName);
                this.validateAnchorEntity(userId, end1.getGUID(), "Referenceable", consumerEntity, "relationship.end1.guid", false, serviceSupportedZones, methodName);
                REFERENCE_VALUE_ASSIGNED_ITEM bean = this.referenceValueAssignedItemConverter.getNewBean(this.referenceValueAssignedItemClass, consumerEntity, relationship, methodName);
                if (bean == null) continue;
                results.add(bean);
            }
            catch (InvalidParameterException | UserNotAuthorizedException throwable) {}
        }
        if (results.isEmpty()) {
            return null;
        }
        return results;
    }

    public List<REFERENCE_VALUE_ASSIGNMENT> getReferenceValueAssignments(String userId, String referenceableGUID, String referenceableGUIDParameterName, int startFrom, int pageSize, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String guidParameterName = "relationship.end2.guid";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(referenceableGUID, referenceableGUIDParameterName, methodName);
        this.validateAnchorEntity(userId, referenceableGUID, referenceableGUIDParameterName, "Referenceable", false, this.supportedZones, methodName);
        List<Relationship> relationships = this.getAttachmentLinks(userId, referenceableGUID, referenceableGUIDParameterName, "Referenceable", "111e6d2e-94e9-43ed-b4ed-f0d220668cbf", "ReferenceValueAssignment", "ValidValueDefinition", startFrom, pageSize, methodName);
        if (relationships == null || relationships.isEmpty()) {
            return null;
        }
        ArrayList<REFERENCE_VALUE_ASSIGNMENT> results = new ArrayList<REFERENCE_VALUE_ASSIGNMENT>();
        for (Relationship relationship : relationships) {
            EntityProxy end2;
            if (relationship == null || (end2 = relationship.getEntityTwoProxy()) == null) continue;
            try {
                EntityDetail consumerEntity = this.repositoryHandler.getEntityByGUID(userId, end2.getGUID(), "relationship.end2.guid", "ValidValueDefinition", methodName);
                this.validateAnchorEntity(userId, end2.getGUID(), "ValidValueDefinition", consumerEntity, "relationship.end2.guid", false, this.supportedZones, methodName);
                REFERENCE_VALUE_ASSIGNMENT bean = this.referenceValueAssignmentConverter.getNewBean(this.referenceValueAssignmentClass, consumerEntity, relationship, methodName);
                if (bean == null) continue;
                results.add(bean);
            }
            catch (InvalidParameterException | UserNotAuthorizedException throwable) {}
        }
        if (results.isEmpty()) {
            return null;
        }
        return results;
    }
}

