/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers.ffdc;

import org.odpi.openmetadata.frameworks.auditlog.messagesets.AuditLogMessageDefinition;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.AuditLogMessageSet;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.AuditLogRecordSeverity;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLogRecordSeverity;

public enum GenericHandlersAuditCode implements AuditLogMessageSet
{
    UNABLE_TO_SET_ANCHORS("OMAG-GENERIC-HANDLERS-0001", OMRSAuditLogRecordSeverity.ERROR, "The Open Metadata Service {0} is not able to set the Anchors classification on entity {1} of type {2} ({3}) during method {4}. The resulting exception was {5} with error message {6}", "The server was attempting to add Anchors classifications to a collection of metadata instances that are logically part of the same object.  This classification is used to optimize the retrieval and maintenance of complex objects.  It is optional function.  The server continues to process the original request which will complete successfully unless something else goes wrong.", "No specific action is required.  This message is to highlight that the retrieval and management of metadata is not optimalbecause none of the repositories in the cohort support the Anchors classification.  To enable the optimization provided through the Anchors classification, add an Egeria native metadata server to the cohort.  This will provide the support for the Anchors classification."),
    SETTING_UP_EXTERNAL_ID("OMAG-GENERIC-HANDLERS-0002", OMRSAuditLogRecordSeverity.INFO, "{0} has linked {1} element {2} to external identifier {3} from third party metadata source {4} ({5}) as part of the {6} operation.", "The described linkage is stored in one of the connected open metadata repositories.", "No specific action is required.  This message is to highlight that the association has been made."),
    PERMITTED_SYNC_CHANGING("OMAG-GENERIC-HANDLERS-0003", OMRSAuditLogRecordSeverity.INFO, "The permitted synchronization for {0} {1} ({2}) has changed for identifier {3} from {4} to {5}", "The described synchronization configuration is stored in one of the connected open metadata repositories.", "Verify that the configuration for the integration connector supporting this third party technology has legitimately changed to the new permitted synchronization."),
    NEW_EXTERNAL_RELATIONSHIP("OMAG-GENERIC-HANDLERS-0004", OMRSAuditLogRecordSeverity.INFO, "{0} has created a new {1} relationship between {2} {3} and {4} {5} during method {6} on behalf of external metadata manager {7} ({8})", "The described new relationship is stored in one of the connected open metadata repositories.", "No action is required now but this message can be useful to understand where particular relationships came from."),
    EXTERNAL_RELATIONSHIP_REMOVED("OMAG-GENERIC-HANDLERS-0005", OMRSAuditLogRecordSeverity.INFO, "{0} has removed the {1} relationship between {2} {3} and {4} {5} during method {6} on behalf of external metadata manager {7} ({8})", "The removed relationship was stored in one of the connected open metadata repositories but has now been removed.", "No action is required now but this message can be useful to understand why a particular relationship has been removed.");

    private String logMessageId;
    private OMRSAuditLogRecordSeverity severity;
    private String logMessage;
    private String systemAction;
    private String userAction;

    private GenericHandlersAuditCode(String messageId, OMRSAuditLogRecordSeverity severity, String message, String systemAction, String userAction) {
        this.logMessageId = messageId;
        this.severity = severity;
        this.logMessage = message;
        this.systemAction = systemAction;
        this.userAction = userAction;
    }

    public AuditLogMessageDefinition getMessageDefinition() {
        return new AuditLogMessageDefinition(this.logMessageId, (AuditLogRecordSeverity)this.severity, this.logMessage, this.systemAction, this.userAction);
    }

    public AuditLogMessageDefinition getMessageDefinition(String ... params) {
        AuditLogMessageDefinition messageDefinition = new AuditLogMessageDefinition(this.logMessageId, (AuditLogRecordSeverity)this.severity, this.logMessage, this.systemAction, this.userAction);
        messageDefinition.setMessageParameters(params);
        return messageDefinition;
    }

    public String toString() {
        return "GenericHandlersAuditCode{logMessageId='" + this.logMessageId + "', severity=" + this.severity + ", logMessage='" + this.logMessage + "', systemAction='" + this.systemAction + "', userAction='" + this.userAction + "'}";
    }
}

