/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.util.Date;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericBuilder;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class AnnotationBuilder
extends OpenMetadataAPIGenericBuilder {
    private final String annotationType;
    private final String summary;
    private final int confidenceLevel;
    private final String expression;
    private final String explanation;
    private final String analysisStep;
    private final String jsonProperties;
    private final Map<String, String> additionalProperties;
    private Map<String, String> candidateClassifications = null;
    private List<String> candidateDataClassGUIDs = null;
    private long matchingValues = 0L;
    private long nonMatchingValues = 0L;
    private int length = 0;
    private String inferredDataType = null;
    private String inferredFormat = null;
    private int inferredLength = 0;
    private int inferredPrecision = 0;
    private int inferredScale = 0;
    private Map<String, String> profileProperties = null;
    private Map<String, Boolean> profileFlags = null;
    private Map<String, Long> profileCounts = null;
    private List<String> valueList = null;
    private Map<String, Integer> valueCount = null;
    private String valueRangeFrom = null;
    private String valueRangeTo = null;
    private String averageValue = null;
    private Map<String, String> dataSourceProperties = null;
    private Date createTime = null;
    private Date modifiedTime = null;
    private int size = 0;
    private String encoding = null;
    private String qualityDimension = null;
    private int qualityScore = 0;
    private String relatedEntityGUID = null;
    private String relationshipTypeName = null;
    private Map<String, String> relationshipProperties = null;
    private String discoveryActivity = null;
    private String actionRequested = null;
    private Map<String, String> actionProperties = null;
    private String schemaName = null;
    private String schemaTypeName = null;
    private String informalTerm = null;
    private String informalTopic = null;
    private List<String> candidateGlossaryTermGUIDs = null;
    private List<String> candidateGlossaryCategoryGUIDs = null;
    private List<String> duplicateAnchorGUIDs = null;
    private List<String> matchingPropertyNames = null;
    private List<String> matchingClassificationNames = null;
    private List<String> matchingAttachmentGUIDs = null;
    private List<String> matchingRelationshipGUIDs = null;

    AnnotationBuilder(String annotationType, String summary, int confidenceLevel, String expression, String explanation, String analysisStep, String jsonProperties, Map<String, String> additionalProperties, String typeGUID, String typeName, Map<String, Object> extendedProperties, List<Classification> existingClassifications, OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(typeGUID, typeName, extendedProperties, InstanceStatus.ACTIVE, existingClassifications, repositoryHelper, serviceName, serverName);
        this.annotationType = annotationType;
        this.summary = summary;
        this.confidenceLevel = confidenceLevel;
        this.expression = expression;
        this.explanation = explanation;
        this.analysisStep = analysisStep;
        this.jsonProperties = jsonProperties;
        this.additionalProperties = additionalProperties;
        this.repositoryHelper = repositoryHelper;
        this.serviceName = serviceName;
        this.serverName = serverName;
    }

    void setClassificationSubtypeProperties(Map<String, String> candidateClassifications) {
        this.candidateClassifications = candidateClassifications;
    }

    void setDataClassSubtypeProperties(List<String> candidateDataClassGUIDs, long matchingValues, long nonMatchingValues) {
        this.candidateDataClassGUIDs = candidateDataClassGUIDs;
        this.matchingValues = matchingValues;
        this.nonMatchingValues = nonMatchingValues;
    }

    void setDataProfileSubtypeProperties(int length, String inferredDataType, String inferredFormat, int inferredLength, int inferredPrecision, int inferredScale, Map<String, String> profileProperties, Map<String, Boolean> profileFlags, Map<String, Long> profileCounts, List<String> valueList, Map<String, Integer> valueCount, String valueRangeFrom, String valueRangeTo, String averageValue) {
        this.length = length;
        this.inferredDataType = inferredDataType;
        this.inferredFormat = inferredFormat;
        this.inferredLength = inferredLength;
        this.inferredPrecision = inferredPrecision;
        this.inferredScale = inferredScale;
        this.profileProperties = profileProperties;
        this.profileFlags = profileFlags;
        this.profileCounts = profileCounts;
        this.valueList = valueList;
        this.valueCount = valueCount;
        this.valueRangeFrom = valueRangeFrom;
        this.valueRangeTo = valueRangeTo;
        this.averageValue = averageValue;
    }

    void setDataSourceMeasurementSubtypeProperties(Map<String, String> dataSourceProperties) {
        this.dataSourceProperties = dataSourceProperties;
    }

    void setDataSourcePhysicalStatusSubtypeProperties(Map<String, String> dataSourceProperties, Date createTime, Date modifiedTime, int size, String encoding) {
        this.dataSourceProperties = dataSourceProperties;
        this.createTime = createTime;
        this.modifiedTime = modifiedTime;
        this.size = size;
        this.encoding = encoding;
    }

    void setQualitySubtypeProperties(String qualityDimension, int qualityScore) {
        this.qualityDimension = qualityDimension;
        this.qualityScore = qualityScore;
    }

    void setRelationshipAdviceSubtypeProperties(String relatedEntityGUID, String relationshipTypeName, Map<String, String> relationshipProperties) {
        this.relatedEntityGUID = relatedEntityGUID;
        this.relationshipTypeName = relationshipTypeName;
        this.relationshipProperties = relationshipProperties;
    }

    void setRequestForActionSubtypeProperties(String discoveryActivity, String actionRequested, Map<String, String> actionProperties) {
        this.discoveryActivity = discoveryActivity;
        this.actionRequested = actionRequested;
        this.actionProperties = actionProperties;
    }

    void setSchemaAnalysisSubTypeProperties(String schemaName, String schemaTypeName) {
        this.schemaName = schemaName;
        this.schemaTypeName = schemaTypeName;
    }

    void setSemanticSubTypeProperties(String informalTerm, String informalTopic, List<String> candidateGlossaryTermGUIDs, List<String> candidateGlossaryCategoryGUIDs) {
        this.informalTerm = informalTerm;
        this.informalTopic = informalTopic;
        this.candidateGlossaryTermGUIDs = candidateGlossaryTermGUIDs;
        this.candidateGlossaryCategoryGUIDs = candidateGlossaryCategoryGUIDs;
    }

    void setSuspectDuplicateSubTypeProperties(List<String> duplicateAnchorGUIDs, List<String> matchingPropertyNames, List<String> matchingClassificationNames, List<String> matchingAttachmentGUIDs, List<String> matchingRelationshipGUIDs) {
        this.duplicateAnchorGUIDs = duplicateAnchorGUIDs;
        this.matchingPropertyNames = matchingPropertyNames;
        this.matchingClassificationNames = matchingClassificationNames;
        this.matchingAttachmentGUIDs = matchingAttachmentGUIDs;
        this.matchingRelationshipGUIDs = matchingRelationshipGUIDs;
    }

    @Override
    public InstanceProperties getInstanceProperties(String methodName) throws InvalidParameterException {
        InstanceProperties properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, "annotationType", this.annotationType, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "summary", this.summary, methodName);
        properties = this.repositoryHelper.addIntPropertyToInstance(this.serviceName, properties, "confidenceLevel", this.confidenceLevel, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "expression", this.expression, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "explanation", this.explanation, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "discoveryRequestStep", this.analysisStep, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "jsonProperties", this.jsonProperties, methodName);
        properties = this.repositoryHelper.addStringMapPropertyToInstance(this.serviceName, properties, "additionalProperties", this.additionalProperties, methodName);
        this.setEffectivityDates(properties);
        if (this.repositoryHelper.isTypeOf(this.serviceName, this.typeName, "ClassificationAnnotation")) {
            return this.addClassificationAnnotationInstanceProperties(properties, methodName);
        }
        if (this.repositoryHelper.isTypeOf(this.serviceName, this.typeName, "DataClassAnnotation")) {
            return this.addDataClassAnnotationInstanceProperties(properties, methodName);
        }
        if (this.repositoryHelper.isTypeOf(this.serviceName, this.typeName, "DataProfileAnnotation")) {
            return this.addDataProfileAnnotationInstanceProperties(properties, methodName);
        }
        if (this.repositoryHelper.isTypeOf(this.serviceName, this.typeName, "DataSourcePhysicalStatusAnnotation")) {
            return this.addDataSourcePhysicalStatusAnnotationInstanceProperties(properties, methodName);
        }
        if (this.repositoryHelper.isTypeOf(this.serviceName, this.typeName, "DataSourceMeasurementAnnotation")) {
            return this.addDataSourceMeasurementAnnotationInstanceProperties(properties, methodName);
        }
        if (this.repositoryHelper.isTypeOf(this.serviceName, this.typeName, "QualityAnnotation")) {
            return this.addQualityAnnotationInstanceProperties(properties, methodName);
        }
        if (this.repositoryHelper.isTypeOf(this.serviceName, this.typeName, "RelationshipAdviceAnnotation")) {
            return this.addRelationshipAdviceAnnotationInstanceProperties(properties, methodName);
        }
        if (this.repositoryHelper.isTypeOf(this.serviceName, this.typeName, "RequestForActionAnnotation")) {
            return this.addRequestForActionAnnotationInstanceProperties(properties, methodName);
        }
        if (this.repositoryHelper.isTypeOf(this.serviceName, this.typeName, "SchemaAnalysisAnnotation")) {
            return this.addSchemaAnalysisAnnotationInstanceProperties(properties, methodName);
        }
        if (this.repositoryHelper.isTypeOf(this.serviceName, this.typeName, "SemanticAnnotation")) {
            return this.addSemanticAnnotationInstanceProperties(properties, methodName);
        }
        if (this.repositoryHelper.isTypeOf(this.serviceName, this.typeName, "SuspectDuplicateAnnotation")) {
            return this.addSuspectDuplicateAnnotationInstanceProperties(properties, methodName);
        }
        return properties;
    }

    private InstanceProperties addClassificationAnnotationInstanceProperties(InstanceProperties properties, String methodName) {
        properties = this.repositoryHelper.addStringMapPropertyToInstance(this.serviceName, properties, "candidateClassifications", this.candidateClassifications, methodName);
        return properties;
    }

    private InstanceProperties addDataClassAnnotationInstanceProperties(InstanceProperties properties, String methodName) {
        properties = this.repositoryHelper.addStringArrayPropertyToInstance(this.serviceName, properties, "candidateDataClassGUIDs", this.candidateDataClassGUIDs, methodName);
        properties = this.repositoryHelper.addLongPropertyToInstance(this.serviceName, properties, "matchingValues", this.matchingValues, methodName);
        properties = this.repositoryHelper.addLongPropertyToInstance(this.serviceName, properties, "nonMatchingValues", this.nonMatchingValues, methodName);
        return properties;
    }

    private InstanceProperties addDataProfileAnnotationInstanceProperties(InstanceProperties properties, String methodName) {
        properties = this.repositoryHelper.addIntPropertyToInstance(this.serviceName, properties, "length", this.length, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "inferredDataType", this.inferredDataType, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "inferredFormat", this.inferredFormat, methodName);
        properties = this.repositoryHelper.addIntPropertyToInstance(this.serviceName, properties, "inferredLength", this.inferredLength, methodName);
        properties = this.repositoryHelper.addIntPropertyToInstance(this.serviceName, properties, "inferredPrecision", this.inferredPrecision, methodName);
        properties = this.repositoryHelper.addIntPropertyToInstance(this.serviceName, properties, "inferredScale", this.inferredScale, methodName);
        properties = this.repositoryHelper.addStringMapPropertyToInstance(this.serviceName, properties, "profileProperties", this.profileProperties, methodName);
        properties = this.repositoryHelper.addBooleanMapPropertyToInstance(this.serviceName, properties, "profileFlags", this.profileFlags, methodName);
        properties = this.repositoryHelper.addLongMapPropertyToInstance(this.serviceName, properties, "profileCounts", this.profileCounts, methodName);
        properties = this.repositoryHelper.addStringArrayPropertyToInstance(this.serviceName, properties, "valueList", this.valueList, methodName);
        properties = this.repositoryHelper.addIntMapPropertyToInstance(this.serviceName, properties, "valueCount", this.valueCount, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "valueRangeTo", this.valueRangeFrom, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "valueRangeTo", this.valueRangeTo, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "averageValue", this.averageValue, methodName);
        return properties;
    }

    private InstanceProperties addDataSourcePhysicalStatusAnnotationInstanceProperties(InstanceProperties properties, String methodName) {
        properties = this.addDataSourceMeasurementAnnotationInstanceProperties(properties, methodName);
        properties = this.repositoryHelper.addDatePropertyToInstance(this.serviceName, properties, "sourceCreateTime", this.createTime, methodName);
        properties = this.repositoryHelper.addDatePropertyToInstance(this.serviceName, properties, "sourceUpdateTime", this.modifiedTime, methodName);
        properties = this.repositoryHelper.addIntPropertyToInstance(this.serviceName, properties, "size", this.size, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "encoding", this.encoding, methodName);
        return properties;
    }

    private InstanceProperties addDataSourceMeasurementAnnotationInstanceProperties(InstanceProperties properties, String methodName) {
        properties = this.repositoryHelper.addStringMapPropertyToInstance(this.serviceName, properties, "dataSourceProperties", this.dataSourceProperties, methodName);
        return properties;
    }

    private InstanceProperties addQualityAnnotationInstanceProperties(InstanceProperties properties, String methodName) {
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "qualityDimension", this.qualityDimension, methodName);
        properties = this.repositoryHelper.addIntPropertyToInstance(this.serviceName, properties, "qualityScore", this.qualityScore, methodName);
        return properties;
    }

    private InstanceProperties addRelationshipAdviceAnnotationInstanceProperties(InstanceProperties properties, String methodName) {
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "relatedEntityGUID", this.relatedEntityGUID, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "relationshipTypeName", this.relationshipTypeName, methodName);
        properties = this.repositoryHelper.addStringMapPropertyToInstance(this.serviceName, properties, "relationshipProperties", this.relationshipProperties, methodName);
        return properties;
    }

    private InstanceProperties addRequestForActionAnnotationInstanceProperties(InstanceProperties properties, String methodName) {
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "discoveryActivity", this.discoveryActivity, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "actionRequested", this.actionRequested, methodName);
        properties = this.repositoryHelper.addStringMapPropertyToInstance(this.serviceName, properties, "actionProperties", this.actionProperties, methodName);
        return properties;
    }

    private InstanceProperties addSchemaAnalysisAnnotationInstanceProperties(InstanceProperties properties, String methodName) {
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "schemaName", this.schemaName, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "schemaType", this.schemaTypeName, methodName);
        return properties;
    }

    private InstanceProperties addSemanticAnnotationInstanceProperties(InstanceProperties properties, String methodName) {
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "informalTerm", this.informalTerm, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "informalTopic", this.informalTopic, methodName);
        properties = this.repositoryHelper.addStringArrayPropertyToInstance(this.serviceName, properties, "candidateGlossaryTermGUIDs", this.candidateGlossaryTermGUIDs, methodName);
        properties = this.repositoryHelper.addStringArrayPropertyToInstance(this.serviceName, properties, "candidateGlossaryCategoryGUIDs", this.candidateGlossaryCategoryGUIDs, methodName);
        return properties;
    }

    private InstanceProperties addSuspectDuplicateAnnotationInstanceProperties(InstanceProperties properties, String methodName) {
        properties = this.repositoryHelper.addStringArrayPropertyToInstance(this.serviceName, properties, "duplicateAnchorGUIDs", this.duplicateAnchorGUIDs, methodName);
        properties = this.repositoryHelper.addStringArrayPropertyToInstance(this.serviceName, properties, "matchingPropertyNames", this.matchingPropertyNames, methodName);
        properties = this.repositoryHelper.addStringArrayPropertyToInstance(this.serviceName, properties, "matchingClassificationNames", this.matchingClassificationNames, methodName);
        properties = this.repositoryHelper.addStringArrayPropertyToInstance(this.serviceName, properties, "matchingAttachmentGUIDS", this.matchingAttachmentGUIDs, methodName);
        properties = this.repositoryHelper.addStringArrayPropertyToInstance(this.serviceName, properties, "matchingRelationshipGUIDs", this.matchingRelationshipGUIDs, methodName);
        return properties;
    }
}

