/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.util.Date;
import java.util.Map;
import org.odpi.openmetadata.commonservices.generichandlers.ReferenceableBuilder;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.OCFCheckedExceptionBase;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeErrorException;

public class DiscoveryAnalysisReportBuilder
extends ReferenceableBuilder {
    private final String displayName;
    private final String description;
    private final Date creationDate;
    private final Map<String, String> analysisParameters;
    private final int discoveryRequestStatus;

    DiscoveryAnalysisReportBuilder(String qualifiedName, String displayName, String description, Date creationDate, Map<String, String> analysisParameters, int discoveryRequestStatus, Map<String, String> additionalProperties, Map<String, Object> extendedProperties, OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(qualifiedName, additionalProperties, "acc7cbc8-09c3-472b-87dd-f78459323dcb", "OpenDiscoveryAnalysisReport", extendedProperties, InstanceStatus.DRAFT, repositoryHelper, serviceName, serverName);
        this.displayName = displayName;
        this.description = description;
        this.creationDate = creationDate;
        this.analysisParameters = analysisParameters;
        this.discoveryRequestStatus = discoveryRequestStatus;
    }

    @Override
    public InstanceProperties getInstanceProperties(String methodName) throws InvalidParameterException {
        InstanceProperties properties = super.getInstanceProperties(methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "displayName", this.displayName, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "description", this.description, methodName);
        properties = this.repositoryHelper.addDatePropertyToInstance(this.serviceName, properties, "executionDate", this.creationDate, methodName);
        properties = this.repositoryHelper.addStringMapPropertyToInstance(this.serviceName, properties, "analysisParameters", this.analysisParameters, methodName);
        try {
            properties = this.repositoryHelper.addEnumPropertyToInstance(this.serviceName, properties, "discoveryServiceStatus", "b2fdeddd-24eb-4e9c-a2a4-2693828d4a69", "DiscoveryServiceRequestStatus", this.discoveryRequestStatus, methodName);
        }
        catch (TypeErrorException error) {
            throw new InvalidParameterException((OCFCheckedExceptionBase)((Object)error), "discoveryServiceStatus");
        }
        return properties;
    }
}

