/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.commonservices.generichandlers.ffdc.GenericHandlersErrorCode;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementClassification;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementHeader;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementOrigin;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementOriginCategory;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementStatus;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementStub;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementType;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementVersions;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityProxy;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceAuditHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProvenanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefLink;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public abstract class OpenMetadataAPIGenericConverter<B> {
    protected OMRSRepositoryHelper repositoryHelper;
    protected String serviceName;
    protected String serverName;

    public OpenMetadataAPIGenericConverter(OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        this.repositoryHelper = repositoryHelper;
        this.serviceName = serviceName;
        this.serverName = serverName;
    }

    public B getNewBean(Class<B> beanClass, EntityDetail entity, String methodName) throws PropertyServerException {
        String thisMethodName = "getNewBean(entity)";
        this.handleUnimplementedConverterMethod(beanClass.getName(), "getNewBean(entity)", this.getClass().getName(), methodName);
        return null;
    }

    public B getNewBean(Class<B> beanClass, EntityDetail entity, Relationship relationship, String methodName) throws PropertyServerException {
        String thisMethodName = "getNewBean(entity, relationship)";
        this.handleUnimplementedConverterMethod(beanClass.getName(), "getNewBean(entity, relationship)", this.getClass().getName(), methodName);
        return null;
    }

    public B getNewComplexBean(Class<B> beanClass, EntityDetail primaryEntity, List<Relationship> relationships, String methodName) throws PropertyServerException {
        String thisMethodName = "getNewComplexBean";
        this.handleUnimplementedConverterMethod(beanClass.getName(), "getNewComplexBean", this.getClass().getName(), methodName);
        return null;
    }

    public B getNewComplexBean(Class<B> beanClass, EntityDetail primaryEntity, List<EntityDetail> supplementaryEntities, List<Relationship> relationships, String methodName) throws PropertyServerException {
        String thisMethodName = "getNewComplexBean(with supplementary entities)";
        this.handleUnimplementedConverterMethod(beanClass.getName(), "getNewComplexBean(with supplementary entities)", this.getClass().getName(), methodName);
        return null;
    }

    public B getNewRelationshipBean(Class<B> beanClass, Relationship relationship, String methodName) throws PropertyServerException {
        String thisMethodName = "getNewRelationshipBean";
        this.handleUnimplementedConverterMethod(beanClass.getName(), "getNewRelationshipBean", this.getClass().getName(), methodName);
        return null;
    }

    public B getNewSchemaTypeBean(Class<B> beanClass, InstanceHeader schemaRootHeader, String schemaTypeTypeName, InstanceProperties instanceProperties, List<Classification> schemaRootClassifications, int attributeCount, String validValueSetGUID, B externalSchemaType, B mapFromSchemaType, B mapToSchemaType, List<B> schemaTypeOptions, String methodName) throws PropertyServerException {
        String thisMethodName = "getNewSchemaTypeBean";
        this.handleUnimplementedConverterMethod(beanClass.getName(), "getNewSchemaTypeBean", this.getClass().getName(), methodName);
        return null;
    }

    public B getNewSchemaTypeBean(Class<B> beanClass, InstanceHeader schemaRootHeader, String schemaTypeTypeName, InstanceProperties instanceProperties, List<Classification> schemaRootClassifications, int attributeCount, String validValueSetGUID, String externalSchemaTypeGUID, B externalSchemaType, String mapFromSchemaTypeGUID, B mapFromSchemaType, String mapToSchemaTypeGUID, B mapToSchemaType, List<String> schemaTypeOptionGUIDs, List<B> schemaTypeOptions, List<Relationship> queryTargets, String methodName) throws PropertyServerException {
        return this.getNewSchemaTypeBean(beanClass, schemaRootHeader, schemaTypeTypeName, instanceProperties, schemaRootClassifications, attributeCount, validValueSetGUID, externalSchemaType, mapFromSchemaType, mapToSchemaType, schemaTypeOptions, methodName);
    }

    public <T> B getNewSchemaAttributeBean(Class<B> beanClass, EntityDetail schemaAttributeEntity, Class<T> typeClass, T schemaType, List<Relationship> schemaAttributeRelationships, String methodName) throws PropertyServerException {
        String thisMethodName = "getNewSchemaAttributeBean)";
        this.handleUnimplementedConverterMethod(beanClass.getName(), "getNewSchemaAttributeBean)", this.getClass().getName(), methodName);
        return null;
    }

    private void handleUnimplementedConverterMethod(String beanClassName, String missingMethodName, String converterClassName, String methodName) throws PropertyServerException {
        throw new PropertyServerException(GenericHandlersErrorCode.MISSING_CONVERTER_METHOD.getMessageDefinition(this.serviceName, missingMethodName, converterClassName, beanClassName, methodName), this.getClass().getName(), methodName);
    }

    protected void handleInvalidBeanClass(String beanClassName, Exception error, String methodName) throws PropertyServerException {
        throw new PropertyServerException(GenericHandlersErrorCode.INVALID_BEAN_CLASS.getMessageDefinition(beanClassName, methodName, this.serviceName, this.serverName, error.getMessage()), this.getClass().getName(), methodName, (Throwable)error);
    }

    protected void handleUnexpectedBeanClass(String beanClassName, String expectedBeanClass, String methodName) throws PropertyServerException {
        throw new PropertyServerException(GenericHandlersErrorCode.UNEXPECTED_BEAN_CLASS.getMessageDefinition(beanClassName, methodName, this.serviceName, this.serverName, expectedBeanClass), this.getClass().getName(), methodName);
    }

    protected void handleMissingMetadataInstance(String beanClassName, TypeDefCategory typeDefCategory, String methodName) throws PropertyServerException {
        throw new PropertyServerException(GenericHandlersErrorCode.MISSING_METADATA_INSTANCE.getMessageDefinition(this.serviceName, beanClassName, typeDefCategory.getName(), methodName), this.getClass().getName(), methodName);
    }

    void validateInstanceType(String expectedTypeName, String beanClassName, InstanceAuditHeader instanceAuditHeader, String methodName) throws PropertyServerException {
        String actualTypeName = "<null>";
        if (instanceAuditHeader.getType() != null && instanceAuditHeader.getType().getTypeDefName() != null) {
            actualTypeName = instanceAuditHeader.getType().getTypeDefName();
        }
        this.validateInstanceType(expectedTypeName, beanClassName, actualTypeName, methodName);
    }

    protected void validateInstanceType(String expectedTypeName, String beanClassName, String actualTypeName, String methodName) throws PropertyServerException {
        if (this.repositoryHelper.isTypeOf(this.serviceName, actualTypeName, expectedTypeName)) {
            return;
        }
        throw new PropertyServerException(GenericHandlersErrorCode.BAD_INSTANCE_TYPE.getMessageDefinition(this.serviceName, beanClassName, actualTypeName, methodName, expectedTypeName), this.getClass().getName(), methodName);
    }

    protected void handleBadEntity(String beanClassName, EntityDetail entity, String methodName) throws PropertyServerException {
        if (entity != null) {
            throw new PropertyServerException(GenericHandlersErrorCode.BAD_ENTITY.getMessageDefinition(methodName, this.serviceName, entity.toString()), this.getClass().getName(), methodName);
        }
        this.handleMissingMetadataInstance(beanClassName, TypeDefCategory.ENTITY_DEF, methodName);
    }

    protected void handleBadEntityProxy(Relationship relationship, int end, EntityProxy entityProxy, String methodName) throws PropertyServerException {
        String entityProxyString = "<null>";
        if (entityProxy != null) {
            entityProxyString = entityProxy.toString();
        }
        throw new PropertyServerException(GenericHandlersErrorCode.BAD_ENTITY_PROXY.getMessageDefinition(relationship.getGUID(), methodName, this.serviceName, Integer.toString(end), entityProxyString), this.getClass().getName(), methodName);
    }

    protected void handleBadRelationship(String beanClassName, Relationship relationship, String methodName) throws PropertyServerException {
        if (relationship != null) {
            throw new PropertyServerException(GenericHandlersErrorCode.BAD_RELATIONSHIP.getMessageDefinition(methodName, this.serviceName, relationship.toString()), this.getClass().getName(), methodName);
        }
        this.handleMissingMetadataInstance(beanClassName, TypeDefCategory.RELATIONSHIP_DEF, methodName);
    }

    protected InstanceProperties getClassificationProperties(String classificationName, EntityDetail entity) {
        List entityClassifications;
        if (entity != null && (entityClassifications = entity.getClassifications()) != null) {
            return this.getClassificationProperties(classificationName, entityClassifications);
        }
        return null;
    }

    protected InstanceProperties getClassificationProperties(String classificationName, List<Classification> entityClassifications) {
        if (entityClassifications != null) {
            for (Classification entityClassification : entityClassifications) {
                if (entityClassification == null || !classificationName.equals(entityClassification.getName())) continue;
                return entityClassification.getProperties();
            }
        }
        return null;
    }

    protected ElementHeader getMetadataElementHeader(Class<B> beanClass, EntityDetail entity, String methodName) throws PropertyServerException {
        if (entity != null) {
            return this.getMetadataElementHeader(beanClass, (InstanceHeader)entity, entity.getClassifications(), methodName);
        }
        this.handleMissingMetadataInstance(beanClass.getName(), TypeDefCategory.ENTITY_DEF, methodName);
        return null;
    }

    public ElementHeader getMetadataElementHeader(Class<B> beanClass, InstanceHeader header, List<Classification> entityClassifications, String methodName) throws PropertyServerException {
        if (header != null) {
            ElementHeader elementHeader = new ElementHeader();
            elementHeader.setGUID(header.getGUID());
            elementHeader.setStatus(this.getElementStatus(header.getStatus()));
            elementHeader.setClassifications(this.getElementClassifications(entityClassifications));
            elementHeader.setType(this.getElementType((InstanceAuditHeader)header));
            ElementOrigin elementOrigin = new ElementOrigin();
            elementOrigin.setSourceServer(this.serverName);
            elementOrigin.setOriginCategory(this.getElementOriginCategory(header.getInstanceProvenanceType()));
            elementOrigin.setHomeMetadataCollectionId(header.getMetadataCollectionId());
            elementOrigin.setHomeMetadataCollectionName(header.getMetadataCollectionName());
            elementOrigin.setLicense(header.getInstanceLicense());
            elementHeader.setOrigin(elementOrigin);
            elementHeader.setVersions(this.getElementVersions((InstanceAuditHeader)header));
            return elementHeader;
        }
        this.handleMissingMetadataInstance(beanClass.getName(), TypeDefCategory.ENTITY_DEF, methodName);
        return null;
    }

    protected ElementStatus getElementStatus(InstanceStatus instanceStatus) {
        if (instanceStatus != null) {
            switch (instanceStatus) {
                case UNKNOWN: {
                    return ElementStatus.UNKNOWN;
                }
                case DRAFT: {
                    return ElementStatus.DRAFT;
                }
                case PREPARED: {
                    return ElementStatus.PREPARED;
                }
                case PROPOSED: {
                    return ElementStatus.PROPOSED;
                }
                case APPROVED: {
                    return ElementStatus.APPROVED;
                }
                case REJECTED: {
                    return ElementStatus.REJECTED;
                }
                case APPROVED_CONCEPT: {
                    return ElementStatus.APPROVED_CONCEPT;
                }
                case UNDER_DEVELOPMENT: {
                    return ElementStatus.UNDER_DEVELOPMENT;
                }
                case DEVELOPMENT_COMPLETE: {
                    return ElementStatus.DEVELOPMENT_COMPLETE;
                }
                case APPROVED_FOR_DEPLOYMENT: {
                    return ElementStatus.APPROVED_FOR_DEPLOYMENT;
                }
                case STANDBY: {
                    return ElementStatus.STANDBY;
                }
                case ACTIVE: {
                    return ElementStatus.ACTIVE;
                }
                case FAILED: {
                    return ElementStatus.FAILED;
                }
                case DISABLED: {
                    return ElementStatus.DISABLED;
                }
                case COMPLETE: {
                    return ElementStatus.COMPLETE;
                }
                case DEPRECATED: {
                    return ElementStatus.DEPRECATED;
                }
                case OTHER: {
                    return ElementStatus.OTHER;
                }
            }
        }
        return ElementStatus.UNKNOWN;
    }

    public ElementStub getElementStub(Class<B> beanClass, EntityProxy entityProxy, String methodName) throws PropertyServerException {
        if (entityProxy != null) {
            ElementHeader elementHeader = this.getMetadataElementHeader(beanClass, (InstanceHeader)entityProxy, entityProxy.getClassifications(), methodName);
            ElementStub elementStub = new ElementStub(elementHeader);
            elementStub.setUniqueName(this.repositoryHelper.getStringProperty(this.serviceName, "qualifiedName", entityProxy.getUniqueProperties(), methodName));
            return elementStub;
        }
        this.handleMissingMetadataInstance(beanClass.getName(), TypeDefCategory.ENTITY_DEF, methodName);
        return null;
    }

    public ElementStub getElementStub(Class<B> beanClass, EntityDetail entity, String methodName) throws PropertyServerException {
        if (entity != null) {
            ElementHeader elementHeader = this.getMetadataElementHeader(beanClass, entity, methodName);
            ElementStub elementStub = new ElementStub(elementHeader);
            elementStub.setUniqueName(this.repositoryHelper.getStringProperty(this.serviceName, "qualifiedName", entity.getProperties(), methodName));
            return elementStub;
        }
        this.handleMissingMetadataInstance(beanClass.getName(), TypeDefCategory.ENTITY_DEF, methodName);
        return null;
    }

    public ElementStub getElementStub(Class<B> beanClass, Relationship relationship, String methodName) throws PropertyServerException {
        if (relationship != null) {
            ElementHeader elementHeader = this.getMetadataElementHeader(beanClass, (InstanceHeader)relationship, null, methodName);
            return new ElementStub(elementHeader);
        }
        this.handleMissingMetadataInstance(beanClass.getName(), TypeDefCategory.RELATIONSHIP_DEF, methodName);
        return null;
    }

    List<ElementClassification> getEntityClassifications(EntityDetail entity) {
        if (entity != null) {
            return this.getElementClassifications(entity.getClassifications());
        }
        return null;
    }

    protected List<ElementClassification> getElementClassifications(List<Classification> entityClassifications) {
        ArrayList<ElementClassification> beanClassifications = null;
        if (entityClassifications != null) {
            beanClassifications = new ArrayList<ElementClassification>();
            for (Classification entityClassification : entityClassifications) {
                if (entityClassification == null) continue;
                ElementClassification beanClassification = new ElementClassification();
                beanClassification.setClassificationName(entityClassification.getName());
                beanClassification.setClassificationProperties(this.repositoryHelper.getInstancePropertiesAsMap(entityClassification.getProperties()));
                beanClassifications.add(beanClassification);
            }
        }
        return beanClassifications;
    }

    protected ElementType getElementType(InstanceAuditHeader instanceHeader) {
        ElementType elementType = new ElementType();
        InstanceType instanceType = instanceHeader.getType();
        if (instanceType != null) {
            elementType.setTypeId(instanceType.getTypeDefGUID());
            elementType.setTypeName(instanceType.getTypeDefName());
            elementType.setTypeVersion(instanceType.getTypeDefVersion());
            elementType.setTypeDescription(instanceType.getTypeDefDescription());
            List typeDefSuperTypes = instanceType.getTypeDefSuperTypes();
            if (typeDefSuperTypes != null && !typeDefSuperTypes.isEmpty()) {
                ArrayList<String> superTypes = new ArrayList<String>();
                for (TypeDefLink typeDefLink : typeDefSuperTypes) {
                    if (typeDefLink == null) continue;
                    superTypes.add(typeDefLink.getName());
                }
                if (!superTypes.isEmpty()) {
                    elementType.setSuperTypeNames(superTypes);
                }
            }
        }
        return elementType;
    }

    protected ElementVersions getElementVersions(InstanceAuditHeader header) {
        ElementVersions elementVersions = new ElementVersions();
        elementVersions.setCreatedBy(header.getCreatedBy());
        elementVersions.setCreateTime(header.getCreateTime());
        elementVersions.setUpdatedBy(header.getUpdatedBy());
        elementVersions.setUpdateTime(header.getUpdateTime());
        elementVersions.setMaintainedBy(header.getMaintainedBy());
        elementVersions.setVersion(header.getVersion());
        return elementVersions;
    }

    protected ElementOriginCategory getElementOriginCategory(InstanceProvenanceType instanceProvenanceType) {
        if (instanceProvenanceType != null) {
            switch (instanceProvenanceType) {
                case DEREGISTERED_REPOSITORY: {
                    return ElementOriginCategory.DEREGISTERED_REPOSITORY;
                }
                case EXTERNAL_SOURCE: {
                    return ElementOriginCategory.EXTERNAL_SOURCE;
                }
                case EXPORT_ARCHIVE: {
                    return ElementOriginCategory.EXPORT_ARCHIVE;
                }
                case LOCAL_COHORT: {
                    return ElementOriginCategory.LOCAL_COHORT;
                }
                case CONTENT_PACK: {
                    return ElementOriginCategory.CONTENT_PACK;
                }
                case CONFIGURATION: {
                    return ElementOriginCategory.CONFIGURATION;
                }
                case UNKNOWN: {
                    return ElementOriginCategory.UNKNOWN;
                }
            }
        }
        return ElementOriginCategory.UNKNOWN;
    }

    protected String getQualifiedName(InstanceProperties instanceProperties) {
        String methodName = "getQualifiedName";
        if (instanceProperties != null) {
            return this.repositoryHelper.getStringProperty(this.serviceName, "qualifiedName", instanceProperties, "getQualifiedName");
        }
        return null;
    }

    protected String removeQualifiedName(InstanceProperties instanceProperties) {
        String methodName = "removeQualifiedName";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, "qualifiedName", instanceProperties, "removeQualifiedName");
        }
        return null;
    }

    protected Map<String, String> removeAdditionalProperties(InstanceProperties instanceProperties) {
        String methodName = "removeAdditionalProperties";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringMapFromProperty(this.serviceName, "additionalProperties", instanceProperties, "removeAdditionalProperties");
        }
        return null;
    }

    protected Map<String, Object> getRemainingExtendedProperties(InstanceProperties instanceProperties) {
        if (instanceProperties != null) {
            return this.repositoryHelper.getInstancePropertiesAsMap(instanceProperties);
        }
        return null;
    }

    protected String removeDisplayName(InstanceProperties instanceProperties) {
        String methodName = "removeDisplayName";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, "displayName", instanceProperties, "removeDisplayName");
        }
        return null;
    }

    protected String getDisplayName(InstanceProperties instanceProperties) {
        String methodName = "getDisplayName";
        if (instanceProperties != null) {
            return this.repositoryHelper.getStringProperty(this.serviceName, "displayName", instanceProperties, "getDisplayName");
        }
        return null;
    }

    protected String removeName(InstanceProperties instanceProperties) {
        String methodName = "removeName";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, "name", instanceProperties, "removeName");
        }
        return null;
    }

    protected String getDescription(InstanceProperties instanceProperties) {
        String methodName = "getDescription";
        if (instanceProperties != null) {
            return this.repositoryHelper.getStringProperty(this.serviceName, "description", instanceProperties, "getDescription");
        }
        return null;
    }

    protected String removeDescription(InstanceProperties instanceProperties) {
        String methodName = "removeDescription";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, "description", instanceProperties, "removeDescription");
        }
        return null;
    }

    protected String removeKeyword(InstanceProperties instanceProperties) {
        String methodName = "removeKeyword";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, "keyword", instanceProperties, "removeKeyword");
        }
        return null;
    }

    protected String removeTopicType(InstanceProperties instanceProperties) {
        String methodName = "removeTopicType";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, "topicType", instanceProperties, "removeTopicType");
        }
        return null;
    }

    protected String removeOperatingSystem(InstanceProperties instanceProperties) {
        String methodName = "removeOperatingSystem";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, "operatingSystem", instanceProperties, "removeOperatingSystem");
        }
        return null;
    }

    protected String removeOperatingSystemPatchLevel(InstanceProperties instanceProperties) {
        String methodName = "removeOperatingSystemPatchLevel";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, "operatingSystemPatchLevel", instanceProperties, "removeOperatingSystemPatchLevel");
        }
        return null;
    }

    protected int removeMinimumInstances(InstanceProperties instanceProperties) {
        String methodName = "removeMinimumInstances";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeIntProperty(this.serviceName, "minimumInstances", instanceProperties, "removeMinimumInstances");
        }
        return 0;
    }

    protected int removeMaximumInstances(InstanceProperties instanceProperties) {
        String methodName = "removeMaximumInstances";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeIntProperty(this.serviceName, "maximumInstances", instanceProperties, "removeMaximumInstances");
        }
        return 0;
    }

    protected String removeInitials(InstanceProperties instanceProperties) {
        String methodName = "removeInitials";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, "initials", instanceProperties, "removeInitials");
        }
        return null;
    }

    protected String removeGivenNames(InstanceProperties instanceProperties) {
        String methodName = "removeGivenNames";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, "givenNames", instanceProperties, "removeGivenNames");
        }
        return null;
    }

    protected String removeSurname(InstanceProperties instanceProperties) {
        String methodName = "removeSurname";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, "surname", instanceProperties, "removeSurname");
        }
        return null;
    }

    protected String removeFullName(InstanceProperties instanceProperties) {
        String methodName = "removeFullName";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, "fullName", instanceProperties, "removeFullName");
        }
        return null;
    }

    protected String removePreferredLanguage(InstanceProperties instanceProperties) {
        String methodName = "removePreferredLanguage";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, "preferredLanguage", instanceProperties, "removePreferredLanguage");
        }
        return null;
    }

    protected String removeJobTitle(InstanceProperties instanceProperties) {
        String methodName = "removeJobTitle";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, "jobTitle", instanceProperties, "removeJobTitle");
        }
        return null;
    }

    protected String removeEmployeeNumber(InstanceProperties instanceProperties) {
        String methodName = "removeEmployeeNumber";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, "employeeNumber", instanceProperties, "removeEmployeeNumber");
        }
        return null;
    }

    protected String removeEmployeeType(InstanceProperties instanceProperties) {
        String methodName = "removeEmployeeType";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, "employeeType", instanceProperties, "removeEmployeeType");
        }
        return null;
    }

    protected String removeContactType(InstanceProperties instanceProperties) {
        String methodName = "removeContactType";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, "contactType", instanceProperties, "removeContactType");
        }
        return null;
    }

    protected String removeContactMethodService(InstanceProperties instanceProperties) {
        String methodName = "removeContactMethodService";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, "contactMethodService", instanceProperties, "removeContactMethodService");
        }
        return null;
    }

    protected String removeContactMethodValue(InstanceProperties instanceProperties) {
        String methodName = "removeContactMethodValue";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, "contactMethodValue", instanceProperties, "removeContactMethodValue");
        }
        return null;
    }

    protected String removeMission(InstanceProperties instanceProperties) {
        String methodName = "removeMission";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, "mission", instanceProperties, "removeMission");
        }
        return null;
    }

    protected String removeAssociationType(InstanceProperties instanceProperties) {
        String methodName = "removeAssociationType";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, "associationType", instanceProperties, "removeAssociationType");
        }
        return null;
    }

    protected String removeIdentifier(InstanceProperties instanceProperties) {
        String methodName = "removeIdentifier";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, "identifier", instanceProperties, "removeIdentifier");
        }
        return null;
    }

    protected String removeURL(InstanceProperties instanceProperties) {
        String methodName = "removeURL";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, "url", instanceProperties, "removeURL");
        }
        return null;
    }

    protected String removeOrganization(InstanceProperties instanceProperties) {
        String methodName = "removeOrganization";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, "organization", instanceProperties, "removeOrganization");
        }
        return null;
    }

    protected String removeReferenceVersion(InstanceProperties instanceProperties) {
        String methodName = "removeReferenceVersion";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, "referenceVersion", instanceProperties, "removeReferenceVersion");
        }
        return null;
    }

    protected String removeReferenceId(InstanceProperties instanceProperties) {
        String methodName = "removeReferenceId";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, "referenceId", instanceProperties, "removeReferenceId");
        }
        return null;
    }

    protected String getReferenceId(InstanceProperties instanceProperties) {
        String methodName = "getReferenceId";
        if (instanceProperties != null) {
            return this.repositoryHelper.getStringProperty(this.serviceName, "referenceId", instanceProperties, "getReferenceId");
        }
        return null;
    }

    protected String removeOrderPropertyName(InstanceProperties instanceProperties) {
        String methodName = "removeOrderPropertyName";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, "orderPropertyName", instanceProperties, "removeOrderPropertyName");
        }
        return null;
    }

    protected String removeMembershipRationale(InstanceProperties instanceProperties) {
        String methodName = "removeMembershipRationale";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, "membershipRationale", instanceProperties, "removeMembershipRationale");
        }
        return null;
    }

    protected Map<String, String> removeMappingProperties(InstanceProperties instanceProperties) {
        String methodName = "removeMappingProperties";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringMapFromProperty(this.serviceName, "mappingProperties", instanceProperties, "removeMappingProperties");
        }
        return null;
    }

    protected Date removeLastSynchronized(InstanceProperties instanceProperties) {
        String methodName = "removeLastSynchronized";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeDateProperty(this.serviceName, "lastSynchronized", instanceProperties, "removeLastSynchronized");
        }
        return null;
    }

    protected String removeNetworkAddress(InstanceProperties instanceProperties) {
        String methodName = "removeNetworkAddress";
        if (instanceProperties != null) {
            String networkAddress = this.repositoryHelper.removeStringProperty(this.serviceName, "networkAddress", instanceProperties, "removeNetworkAddress");
            if (networkAddress == null) {
                networkAddress = this.repositoryHelper.removeStringProperty(this.serviceName, "address", instanceProperties, "removeNetworkAddress");
            }
            return networkAddress;
        }
        return null;
    }

    protected String removePostalAddress(InstanceProperties instanceProperties) {
        String methodName = "removePostalAddress";
        if (instanceProperties != null) {
            String postalAddress = this.repositoryHelper.removeStringProperty(this.serviceName, "postalAddress", instanceProperties, "removePostalAddress");
            if (postalAddress == null) {
                postalAddress = this.repositoryHelper.removeStringProperty(this.serviceName, "address", instanceProperties, "removePostalAddress");
            }
            return postalAddress;
        }
        return null;
    }

    protected String removeCoordinates(InstanceProperties instanceProperties) {
        String methodName = "removeCoordinates";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, "coordinates", instanceProperties, "removeCoordinates");
        }
        return null;
    }

    protected String removeMapProjection(InstanceProperties instanceProperties) {
        String methodName = "removeMapProjection";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, "mapProjection", instanceProperties, "removeMapProjection");
        }
        return null;
    }

    protected String removeTimeZone(InstanceProperties instanceProperties) {
        String methodName = "removeTimeZone";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, "timezone", instanceProperties, "removeTimeZone");
        }
        return null;
    }

    protected String removeLevel(InstanceProperties instanceProperties) {
        String methodName = "removeLevel";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, "level", instanceProperties, "removeLevel");
        }
        return null;
    }

    protected String removeProtocol(InstanceProperties instanceProperties) {
        String methodName = "removeProtocol";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, "protocol", instanceProperties, "removeProtocol");
        }
        return null;
    }

    protected String removeEncryptionMethod(InstanceProperties instanceProperties) {
        String methodName = "removeEncryptionMethod";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, "encryptionMethod", instanceProperties, "removeEncryptionMethod");
        }
        return null;
    }

    protected String removeConnectorProviderClassName(InstanceProperties instanceProperties) {
        String methodName = "removeConnectorProviderClassName";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, "connectorProviderClassName", instanceProperties, "removeConnectorProviderClassName");
        }
        return null;
    }

    protected String removeSupportedAssetTypeName(InstanceProperties instanceProperties) {
        String methodName = "removeSupportedAssetTypeName";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, "supportedAssetTypeName", instanceProperties, "removeSupportedAssetTypeName");
        }
        return null;
    }

    protected String removeExpectedDataFormat(InstanceProperties instanceProperties) {
        String methodName = "removeExpectedDataFormat";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, "expectedDataFormat", instanceProperties, "removeExpectedDataFormat");
        }
        return null;
    }

    protected String removeConnectorFrameworkName(InstanceProperties instanceProperties) {
        String connectorFrameworkName;
        String methodName = "removeConnectorFrameworkName";
        if (instanceProperties != null && (connectorFrameworkName = this.repositoryHelper.removeStringProperty(this.serviceName, "connectorFrameworkName", instanceProperties, "removeConnectorFrameworkName")) != null) {
            return connectorFrameworkName;
        }
        return "Open Connector Framework (OCF)";
    }

    protected String removeConnectorInterfaceLanguage(InstanceProperties instanceProperties) {
        String connectorInterfaceLanguage;
        String methodName = "removeConnectorInterfaceLanguage";
        if (instanceProperties != null && (connectorInterfaceLanguage = this.repositoryHelper.removeStringProperty(this.serviceName, "connectorInterfaceLanguage", instanceProperties, "removeConnectorInterfaceLanguage")) != null) {
            return connectorInterfaceLanguage;
        }
        return "Java";
    }

    protected List<String> removeConnectorInterfaces(InstanceProperties instanceProperties) {
        String methodName = "removeConnectorInterfaces";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringArrayProperty(this.serviceName, "connectorInterfaces", instanceProperties, "removeConnectorInterfaces");
        }
        return null;
    }

    protected String removeTargetTechnologySource(InstanceProperties instanceProperties) {
        String methodName = "removeTargetTechnologySource";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, "targetTechnologySource", instanceProperties, "removeTargetTechnologySource");
        }
        return null;
    }

    protected String removeTargetTechnologyName(InstanceProperties instanceProperties) {
        String methodName = "removeTargetTechnologyName";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, "targetTechnologyName", instanceProperties, "removeTargetTechnologyName");
        }
        return null;
    }

    protected List<String> removeTargetTechnologyInterfaces(InstanceProperties instanceProperties) {
        String methodName = "removeTargetTechnologyInterfaces";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringArrayProperty(this.serviceName, "targetTechnologyInterfaces", instanceProperties, "removeTargetTechnologyInterfaces");
        }
        return null;
    }

    protected List<String> removeTargetTechnologyVersions(InstanceProperties instanceProperties) {
        String methodName = "removeTargetTechnologyVersions";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringArrayProperty(this.serviceName, "targetTechnologyVersions", instanceProperties, "removeTargetTechnologyVersions");
        }
        return null;
    }

    protected List<String> removeRecognizedAdditionalProperties(InstanceProperties instanceProperties) {
        String methodName = "removeRecognizedAdditionalProperties";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringArrayProperty(this.serviceName, "recognizedAdditionalProperties", instanceProperties, "removeRecognizedAdditionalProperties");
        }
        return null;
    }

    protected List<String> removeRecognizedSecuredProperties(InstanceProperties instanceProperties) {
        String methodName = "removeRecognizedSecuredProperties";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringArrayProperty(this.serviceName, "recognizedSecuredProperties", instanceProperties, "removeRecognizedSecuredProperties");
        }
        return null;
    }

    protected List<String> removeRecognizedConfigurationProperties(InstanceProperties instanceProperties) {
        String methodName = "removeRecognizedConfigurationProperties";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringArrayProperty(this.serviceName, "recognizedConfigurationProperties", instanceProperties, "removeRecognizedConfigurationProperties");
        }
        return null;
    }

    protected Map<String, String> removeSecuredProperties(InstanceProperties instanceProperties) {
        String methodName = "removeSecuredProperties";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringMapFromProperty(this.serviceName, "securedProperties", instanceProperties, "removeSecuredProperties");
        }
        return null;
    }

    protected Map<String, Object> removeConfigurationProperties(InstanceProperties instanceProperties) {
        String methodName = "removeConfigurationProperties";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeMapFromProperty(this.serviceName, "configurationProperties", instanceProperties, "removeConfigurationProperties");
        }
        return null;
    }

    protected String removeUserId(InstanceProperties instanceProperties) {
        String methodName = "removeUserId";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, "userId", instanceProperties, "removeUserId");
        }
        return null;
    }

    protected String removeClearPassword(InstanceProperties instanceProperties) {
        String methodName = "removeClearPassword";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, "clearPassword", instanceProperties, "removeClearPassword");
        }
        return null;
    }

    protected String removeEncryptedPassword(InstanceProperties instanceProperties) {
        String methodName = "removeEncryptedPassword";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, "encryptedPassword", instanceProperties, "removeEncryptedPassword");
        }
        return null;
    }

    protected String getAssetSummary(InstanceProperties instanceProperties) {
        String methodName = "removeEncryptedPassword";
        if (instanceProperties != null) {
            return this.repositoryHelper.getStringProperty(this.serviceName, "assetSummary", instanceProperties, "removeEncryptedPassword");
        }
        return null;
    }

    protected Map<String, Object> getArguments(InstanceProperties instanceProperties) {
        String methodName = "getArguments";
        if (instanceProperties != null) {
            return this.repositoryHelper.getMapFromProperty(this.serviceName, "arguments", instanceProperties, "getArguments");
        }
        return null;
    }

    protected List<String> removeZoneMembership(InstanceProperties instanceProperties) {
        String methodName = "removeZoneMembership";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringArrayProperty(this.serviceName, "zoneMembership", instanceProperties, "removeZoneMembership");
        }
        return null;
    }

    protected String removeZoneName(InstanceProperties instanceProperties) {
        String methodName = "removeZoneName";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, "zoneName", instanceProperties, "removeZoneName");
        }
        return null;
    }

    protected String removeSubjectAreaName(InstanceProperties instanceProperties) {
        String methodName = "removeSubjectAreaName";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, "subjectAreaName", instanceProperties, "removeSubjectAreaName");
        }
        return null;
    }

    protected List<String> getZoneMembership(InstanceProperties instanceProperties) {
        String methodName = "getZoneMembership";
        if (instanceProperties != null) {
            return this.repositoryHelper.getStringArrayProperty(this.serviceName, "zoneMembership", instanceProperties, "getZoneMembership");
        }
        return null;
    }

    protected String removeOwner(InstanceProperties instanceProperties) {
        String methodName = "removeOwner";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, "owner", instanceProperties, "removeOwner");
        }
        return null;
    }

    protected String getOwner(InstanceProperties instanceProperties) {
        String methodName = "getOwner";
        if (instanceProperties != null) {
            return this.repositoryHelper.getStringProperty(this.serviceName, "owner", instanceProperties, "getOwner");
        }
        return null;
    }

    protected String getOwnerTypeName(InstanceProperties instanceProperties) {
        String methodName = "getOwnerTypeName";
        if (instanceProperties != null) {
            return this.repositoryHelper.getStringProperty(this.serviceName, "ownerTypeName", instanceProperties, "getOwnerTypeName");
        }
        return null;
    }

    protected String getOwnerPropertyName(InstanceProperties instanceProperties) {
        String methodName = "getOwnerPropertyName";
        if (instanceProperties != null) {
            return this.repositoryHelper.getStringProperty(this.serviceName, "ownerPropertyName", instanceProperties, "getOwnerPropertyName");
        }
        return null;
    }

    protected int getOwnerTypeOrdinal(InstanceProperties instanceProperties) {
        String methodName = "getOwnerTypeOrdinal";
        if (instanceProperties != null) {
            return this.repositoryHelper.getEnumPropertyOrdinal(this.serviceName, "ownerType", instanceProperties, "getOwnerTypeOrdinal");
        }
        return 0;
    }

    protected int removeOwnerTypeOrdinal(InstanceProperties instanceProperties) {
        String methodName = "removeOwnerTypeOrdinal";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeEnumPropertyOrdinal(this.serviceName, "ownerType", instanceProperties, "removeOwnerTypeOrdinal");
        }
        return 0;
    }

    protected String removeOwnerPropertyName(InstanceProperties instanceProperties) {
        String methodName = "removeClassificationPropertyName";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, "ownerPropertyName", instanceProperties, "removeClassificationPropertyName");
        }
        return null;
    }

    protected String removeOwnerTypeName(InstanceProperties instanceProperties) {
        String methodName = "removeTypePropertyName";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, "ownerTypeName", instanceProperties, "removeTypePropertyName");
        }
        return null;
    }

    protected String removeRoleTypeName(InstanceProperties instanceProperties) {
        String methodName = "removeRoleTypeName";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, "roleTypeName", instanceProperties, "removeRoleTypeName");
        }
        return null;
    }

    protected String removeDistinguishedName(InstanceProperties instanceProperties) {
        String methodName = "removeDistinguishedName";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, "distinguishedName", instanceProperties, "removeDistinguishedName");
        }
        return null;
    }

    protected List<String> getGroups(InstanceProperties instanceProperties) {
        String methodName = "getGroups";
        if (instanceProperties != null) {
            return this.repositoryHelper.getStringArrayProperty(this.serviceName, "groups", instanceProperties, "getGroups");
        }
        return null;
    }

    protected List<String> getSecurityLabels(InstanceProperties instanceProperties) {
        String methodName = "getSecurityLabels";
        if (instanceProperties != null) {
            return this.repositoryHelper.getStringArrayProperty(this.serviceName, "securityLabels", instanceProperties, "getSecurityLabels");
        }
        return null;
    }

    protected Map<String, String> getSecurityProperties(InstanceProperties instanceProperties) {
        String methodName = "getSecurityProperties";
        if (instanceProperties != null) {
            return this.repositoryHelper.getStringMapFromProperty(this.serviceName, "securityProperties", instanceProperties, "getSecurityProperties");
        }
        return null;
    }

    protected int removeKarmaPoints(InstanceProperties instanceProperties) {
        String methodName = "removeKarmaPoints";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeIntProperty(this.serviceName, "karmaPoints", instanceProperties, "removeKarmaPoints");
        }
        return 0;
    }

    protected String getOriginOrganizationGUID(InstanceProperties instanceProperties) {
        String methodName = "getOriginOrganizationGUID";
        if (instanceProperties != null) {
            return this.repositoryHelper.getStringProperty(this.serviceName, "organization", instanceProperties, "getOriginOrganizationGUID");
        }
        return null;
    }

    protected String getOriginBusinessCapabilityGUID(InstanceProperties instanceProperties) {
        String methodName = "getOriginBusinessCapabilityGUID";
        if (instanceProperties != null) {
            return this.repositoryHelper.getStringProperty(this.serviceName, "businessCapability", instanceProperties, "getOriginBusinessCapabilityGUID");
        }
        return null;
    }

    protected Map<String, String> getOtherOriginValues(InstanceProperties instanceProperties) {
        String methodName = "getOtherOriginValues";
        if (instanceProperties != null) {
            return this.repositoryHelper.getStringMapFromProperty(this.serviceName, "otherOriginValues", instanceProperties, "getOtherOriginValues");
        }
        return null;
    }

    protected Date removeSourceCreateTime(InstanceProperties instanceProperties) {
        String methodName = "removeSourceCreateTime";
        if (instanceProperties != null) {
            Date createTime1 = this.repositoryHelper.removeDateProperty(this.serviceName, "sourceCreateTime", instanceProperties, "removeSourceCreateTime");
            Date createTime2 = this.repositoryHelper.removeDateProperty(this.serviceName, "createTime", instanceProperties, "removeSourceCreateTime");
            return createTime1 == null ? createTime2 : createTime1;
        }
        return null;
    }

    protected Date removeSourceUpdateTime(InstanceProperties instanceProperties) {
        String methodName = "removeSourceUpdateTime";
        if (instanceProperties != null) {
            Date modifiedTime1 = this.repositoryHelper.removeDateProperty(this.serviceName, "sourceUpdateTime", instanceProperties, "removeSourceUpdateTime");
            Date modifiedTime2 = this.repositoryHelper.removeDateProperty(this.serviceName, "updateTime", instanceProperties, "removeSourceUpdateTime");
            return modifiedTime1 == null ? modifiedTime2 : modifiedTime1;
        }
        return null;
    }

    protected String removePathName(InstanceProperties instanceProperties) {
        String methodName = "removePathName";
        if (instanceProperties != null) {
            return this.repositoryHelper.getStringProperty(this.serviceName, "pathName", instanceProperties, "removePathName");
        }
        return null;
    }

    protected Date removeStoreCreateTime(InstanceProperties instanceProperties) {
        String methodName = "removeStoreCreateTime";
        if (instanceProperties != null) {
            Date createTime1 = this.repositoryHelper.removeDateProperty(this.serviceName, "storeCreateTime", instanceProperties, "removeStoreCreateTime");
            Date createTime2 = this.repositoryHelper.removeDateProperty(this.serviceName, "createTime", instanceProperties, "removeStoreCreateTime");
            return createTime1 == null ? createTime2 : createTime1;
        }
        return null;
    }

    protected Date removeStoreUpdateTime(InstanceProperties instanceProperties) {
        String methodName = "removeStoreUpdateTime";
        if (instanceProperties != null) {
            Date modifiedTime1 = this.repositoryHelper.removeDateProperty(this.serviceName, "storeUpdateTime", instanceProperties, "removeStoreUpdateTime");
            Date modifiedTime2 = this.repositoryHelper.removeDateProperty(this.serviceName, "updateTime", instanceProperties, "removeStoreUpdateTime");
            return modifiedTime1 == null ? modifiedTime2 : modifiedTime1;
        }
        return null;
    }

    protected String getDataStoreEncodingType(InstanceProperties instanceProperties) {
        String methodName = "getDataStoreEncodingType";
        if (instanceProperties != null) {
            return this.repositoryHelper.getStringProperty(this.serviceName, "encoding", instanceProperties, "getDataStoreEncodingType");
        }
        return null;
    }

    protected String getDataStoreEncodingLanguage(InstanceProperties instanceProperties) {
        String methodName = "getDataStoreEncodingLanguage";
        if (instanceProperties != null) {
            return this.repositoryHelper.getStringProperty(this.serviceName, "language", instanceProperties, "getDataStoreEncodingLanguage");
        }
        return null;
    }

    protected String getDataStoreEncodingDescription(InstanceProperties instanceProperties) {
        String methodName = "getDataStoreEncodingDescription";
        if (instanceProperties != null) {
            return this.repositoryHelper.getStringProperty(this.serviceName, "description", instanceProperties, "getDataStoreEncodingDescription");
        }
        return null;
    }

    protected Map<String, String> getEncodingProperties(InstanceProperties instanceProperties) {
        String methodName = "getEncodingProperties";
        if (instanceProperties != null) {
            return this.repositoryHelper.getStringMapFromProperty(this.serviceName, "properties", instanceProperties, "getEncodingProperties");
        }
        return null;
    }

    protected String removeDatabaseType(InstanceProperties instanceProperties) {
        String methodName = "removeDatabaseType";
        if (instanceProperties != null) {
            String type1 = this.repositoryHelper.removeStringProperty(this.serviceName, "deployedImplementationType", instanceProperties, "removeDatabaseType");
            String type2 = this.repositoryHelper.removeStringProperty(this.serviceName, "type", instanceProperties, "removeDatabaseType");
            return type1 == null ? type2 : type1;
        }
        return null;
    }

    protected String removeDatabaseVersion(InstanceProperties instanceProperties) {
        String methodName = "removeDatabaseVersion";
        if (instanceProperties != null) {
            String version1 = this.repositoryHelper.removeStringProperty(this.serviceName, "databaseVersion", instanceProperties, "removeDatabaseVersion");
            String version2 = this.repositoryHelper.removeStringProperty(this.serviceName, "version", instanceProperties, "removeDatabaseVersion");
            return version1 == null ? version2 : version1;
        }
        return null;
    }

    protected String removeDatabaseInstance(InstanceProperties instanceProperties) {
        String methodName = "removeDatabaseInstance";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, "instance", instanceProperties, "removeDatabaseInstance");
        }
        return null;
    }

    protected String removeDatabaseImportedFrom(InstanceProperties instanceProperties) {
        String methodName = "removeDatabaseImportedFrom";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, "importedFrom", instanceProperties, "removeDatabaseImportedFrom");
        }
        return null;
    }

    protected String removeFileType(InstanceProperties instanceProperties) {
        String methodName = "removeFileType";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, "fileType", instanceProperties, "removeFileType");
        }
        return null;
    }

    protected String getFormat(InstanceProperties instanceProperties) {
        String methodName = "getFormat";
        if (instanceProperties != null) {
            return this.repositoryHelper.getStringProperty(this.serviceName, "format", instanceProperties, "getFormat");
        }
        return null;
    }

    protected String getEncryption(InstanceProperties instanceProperties) {
        String methodName = "getEncryption";
        if (instanceProperties != null) {
            return this.repositoryHelper.getStringProperty(this.serviceName, "encryption", instanceProperties, "getEncryption");
        }
        return null;
    }

    protected String removeDeployedImplementationType(InstanceProperties instanceProperties) {
        String methodName = "removeDeployedImplementationType";
        if (instanceProperties != null) {
            String type = this.repositoryHelper.removeStringProperty(this.serviceName, "deployedImplementationType", instanceProperties, "removeDeployedImplementationType");
            if (type == null) {
                type = this.repositoryHelper.removeStringProperty(this.serviceName, "type", instanceProperties, "removeDeployedImplementationType");
            }
            return type;
        }
        return null;
    }

    protected String removeCapabilityType(InstanceProperties instanceProperties) {
        String methodName = "removeCapabilityType";
        if (instanceProperties != null) {
            String type = this.repositoryHelper.removeStringProperty(this.serviceName, "capabilityType", instanceProperties, "removeCapabilityType");
            if (type == null) {
                type = this.repositoryHelper.removeStringProperty(this.serviceName, "type", instanceProperties, "removeCapabilityType");
            }
            if (type == null) {
                type = this.repositoryHelper.removeStringProperty(this.serviceName, "deployedImplementationType", instanceProperties, "removeCapabilityType");
            }
            return type;
        }
        return null;
    }

    protected String removeCapabilityVersion(InstanceProperties instanceProperties) {
        String methodName = "removeCapabilityVersion";
        if (instanceProperties != null) {
            String version1 = this.repositoryHelper.removeStringProperty(this.serviceName, "capabilityVersion", instanceProperties, "removeCapabilityVersion");
            String version2 = this.repositoryHelper.removeStringProperty(this.serviceName, "version", instanceProperties, "removeCapabilityVersion");
            return version1 == null ? version2 : version1;
        }
        return null;
    }

    protected String removePatchLevel(InstanceProperties instanceProperties) {
        String methodName = "removePatchLevel";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, "patchLevel", instanceProperties, "removePatchLevel");
        }
        return null;
    }

    protected boolean removeIsDeprecated(InstanceProperties instanceProperties) {
        String methodName = "removeIsDeprecated";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeBooleanProperty(this.serviceName, "isDeprecated", instanceProperties, "removeIsDeprecated");
        }
        return false;
    }

    protected boolean removeIsDefaultValue(InstanceProperties instanceProperties) {
        String methodName = "removeIsDefaultValue";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeBooleanProperty(this.serviceName, "isDefaultValue", instanceProperties, "removeIsDefaultValue");
        }
        return false;
    }

    protected String removeAnchorGUID(InstanceProperties instanceProperties) {
        String methodName = "removeAnchorGUID";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, "anchorGUID", instanceProperties, "removeAnchorGUID");
        }
        return null;
    }

    protected String getAnchorGUID(InstanceProperties instanceProperties) {
        String methodName = "getAnchorGUID";
        if (instanceProperties != null) {
            return this.repositoryHelper.getStringProperty(this.serviceName, "anchorGUID", instanceProperties, "getAnchorGUID");
        }
        return null;
    }

    protected String removeDataType(InstanceProperties instanceProperties) {
        String methodName = "removeDataType";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, "dataType", instanceProperties, "removeDataType");
        }
        return null;
    }

    protected String removeDefaultValue(InstanceProperties instanceProperties) {
        String methodName = "removeDefaultValue";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, "defaultValue", instanceProperties, "removeDefaultValue");
        }
        return null;
    }

    protected String removeFixedValue(InstanceProperties instanceProperties) {
        String methodName = "removeFixedValue";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, "fixedValue", instanceProperties, "removeFixedValue");
        }
        return null;
    }

    protected String getQuery(InstanceProperties instanceProperties) {
        String methodName = "setQuery";
        if (instanceProperties != null) {
            return this.repositoryHelper.getStringProperty(this.serviceName, "query", instanceProperties, "setQuery");
        }
        return null;
    }

    protected String getQueryId(InstanceProperties instanceProperties) {
        String methodName = "setQueryId";
        if (instanceProperties != null) {
            return this.repositoryHelper.getStringProperty(this.serviceName, "queryId", instanceProperties, "setQueryId");
        }
        return null;
    }

    protected String removeVersionNumber(InstanceProperties instanceProperties) {
        String methodName = "removeVersionNumber";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, "versionNumber", instanceProperties, "removeVersionNumber");
        }
        return null;
    }

    protected String removeId(InstanceProperties instanceProperties) {
        String methodName = "removeId";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, "id", instanceProperties, "removeId");
        }
        return null;
    }

    protected Date removeCreatedTime(InstanceProperties instanceProperties) {
        String methodName = "removeCreatedTime";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeDateProperty(this.serviceName, "createdTime", instanceProperties, "removeCreatedTime");
        }
        return null;
    }

    protected Date removeLastModifiedTime(InstanceProperties instanceProperties) {
        String methodName = "removeLastModifiedTime";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeDateProperty(this.serviceName, "lastModifiedTime", instanceProperties, "removeLastModifiedTime");
        }
        return null;
    }

    protected String removeLastModifier(InstanceProperties instanceProperties) {
        String methodName = "removeId";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, "lastModifier", instanceProperties, "removeId");
        }
        return null;
    }

    protected String removeAuthor(InstanceProperties instanceProperties) {
        String methodName = "removeAuthor";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, "author", instanceProperties, "removeAuthor");
        }
        return null;
    }

    protected String removeEncodingStandard(InstanceProperties instanceProperties) {
        String methodName = "removeEncodingStandard";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, "encodingStandard", instanceProperties, "removeEncodingStandard");
        }
        return null;
    }

    protected String removeNamespace(InstanceProperties instanceProperties) {
        String methodName = "removeNamespace";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, "namespace", instanceProperties, "removeNamespace");
        }
        return null;
    }

    protected int removePosition(InstanceProperties instanceProperties) {
        String methodName = "removePosition";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeIntProperty(this.serviceName, "position", instanceProperties, "removePosition");
        }
        return 0;
    }

    protected int getPosition(InstanceProperties instanceProperties) {
        String methodName = "getPosition";
        if (instanceProperties != null) {
            return this.repositoryHelper.getIntProperty(this.serviceName, "position", instanceProperties, "getPosition");
        }
        return 0;
    }

    protected int removeMinCardinality(InstanceProperties instanceProperties) {
        String methodName = "removeMinCardinality";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeIntProperty(this.serviceName, "minCardinality", instanceProperties, "removeMinCardinality");
        }
        return 0;
    }

    protected int removeMaxCardinality(InstanceProperties instanceProperties) {
        String methodName = "removeMaxCardinality";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeIntProperty(this.serviceName, "maxCardinality", instanceProperties, "removeMaxCardinality");
        }
        return -1;
    }

    protected boolean removeAllowsDuplicateValues(InstanceProperties instanceProperties) {
        String methodName = "removeAllowsDuplicateValues";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeBooleanProperty(this.serviceName, "allowsDuplicateValues", instanceProperties, "removeAllowsDuplicateValues");
        }
        return true;
    }

    protected boolean removeOrderedValues(InstanceProperties instanceProperties) {
        String methodName = "removeOrderedValues";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeBooleanProperty(this.serviceName, "orderedValues", instanceProperties, "removeOrderedValues");
        }
        return false;
    }

    protected String removeDefaultValueOverride(InstanceProperties instanceProperties) {
        String methodName = "removeDefaultValueOverride";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, "defaultValueOverride", instanceProperties, "removeDefaultValueOverride");
        }
        return null;
    }

    protected int removeMinimumLength(InstanceProperties instanceProperties) {
        String methodName = "removeMinimumLength";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeIntProperty(this.serviceName, "minimumLength", instanceProperties, "removeMinimumLength");
        }
        return 0;
    }

    protected int removeLength(InstanceProperties instanceProperties) {
        String methodName = "removeLength";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeIntProperty(this.serviceName, "length", instanceProperties, "removeLength");
        }
        return 0;
    }

    protected int removePrecision(InstanceProperties instanceProperties) {
        String methodName = "removePrecision";
        if (instanceProperties != null) {
            int retrievedValue = this.repositoryHelper.removeIntProperty(this.serviceName, "precision", instanceProperties, "removePrecision");
            if (retrievedValue == 0) {
                retrievedValue = this.repositoryHelper.removeIntProperty(this.serviceName, "significantDigits", instanceProperties, "removePrecision");
            }
            return retrievedValue;
        }
        return 0;
    }

    protected boolean removeIsNullable(InstanceProperties instanceProperties) {
        String methodName = "removeIsNullable";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeBooleanProperty(this.serviceName, "isNullable", instanceProperties, "removeIsNullable");
        }
        return false;
    }

    protected boolean removeRequired(InstanceProperties instanceProperties) {
        String methodName = "removeRequired";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeBooleanProperty(this.serviceName, "required", instanceProperties, "removeRequired");
        }
        return false;
    }

    protected String removeNativeClass(InstanceProperties instanceProperties) {
        String methodName = "removeNativeClass";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, "nativeClass", instanceProperties, "removeNativeClass");
        }
        return null;
    }

    protected List<String> removeAliases(InstanceProperties instanceProperties) {
        String methodName = "removeAliases";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringArrayProperty(this.serviceName, "aliases", instanceProperties, "removeAliases");
        }
        return null;
    }

    protected String getGuard(InstanceProperties instanceProperties) {
        String methodName = "getGuard";
        if (instanceProperties != null) {
            return this.repositoryHelper.getStringProperty(this.serviceName, "guard", instanceProperties, "getGuard");
        }
        return null;
    }

    protected String getFormula(InstanceProperties instanceProperties) {
        String methodName = "getFormula";
        if (instanceProperties != null) {
            return this.repositoryHelper.getStringProperty(this.serviceName, "formula", instanceProperties, "getFormula");
        }
        return null;
    }

    protected String removeFormula(InstanceProperties instanceProperties) {
        String methodName = "removeFormula";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, "formula", instanceProperties, "removeFormula");
        }
        return null;
    }

    protected String getImplementationLanguage(InstanceProperties instanceProperties) {
        String methodName = "getImplementationLanguage";
        if (instanceProperties != null) {
            return this.repositoryHelper.getStringProperty(this.serviceName, "implementationLanguage", instanceProperties, "getImplementationLanguage");
        }
        return null;
    }

    protected String removeImplementationLanguage(InstanceProperties instanceProperties) {
        String methodName = "removeImplementationLanguage";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, "implementationLanguage", instanceProperties, "removeImplementationLanguage");
        }
        return null;
    }

    protected String removeSource(InstanceProperties instanceProperties) {
        String methodName = "removeSource";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, "source", instanceProperties, "removeSource");
        }
        return null;
    }

    protected String getUsage(InstanceProperties instanceProperties) {
        String methodName = "getUsage";
        if (instanceProperties != null) {
            return this.repositoryHelper.getStringProperty(this.serviceName, "usage", instanceProperties, "getUsage");
        }
        return null;
    }

    protected String removeUsage(InstanceProperties instanceProperties) {
        String methodName = "removeUsage";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, "usage", instanceProperties, "removeUsage");
        }
        return null;
    }

    protected String removeLanguage(InstanceProperties instanceProperties) {
        String methodName = "removeLanguage";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, "language", instanceProperties, "removeLanguage");
        }
        return null;
    }

    protected String getSummary(InstanceProperties instanceProperties) {
        String methodName = "getSummary";
        if (instanceProperties != null) {
            return this.repositoryHelper.getStringProperty(this.serviceName, "summary", instanceProperties, "getSummary");
        }
        return null;
    }

    protected String removeSummary(InstanceProperties instanceProperties) {
        String methodName = "removeSummary";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, "summary", instanceProperties, "removeSummary");
        }
        return null;
    }

    protected String getAbbreviation(InstanceProperties instanceProperties) {
        String methodName = "getAbbreviation";
        if (instanceProperties != null) {
            return this.repositoryHelper.getStringProperty(this.serviceName, "abbreviation", instanceProperties, "getAbbreviation");
        }
        return null;
    }

    protected String removeAbbreviation(InstanceProperties instanceProperties) {
        String methodName = "removeAbbreviation";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, "abbreviation", instanceProperties, "removeAbbreviation");
        }
        return null;
    }

    protected String removeExamples(InstanceProperties instanceProperties) {
        String methodName = "removeExamples";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, "examples", instanceProperties, "removeExamples");
        }
        return null;
    }

    protected String removeTitle(InstanceProperties instanceProperties) {
        String methodName = "removeTitle";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, "title", instanceProperties, "removeTitle");
        }
        return null;
    }

    protected String removePronouns(InstanceProperties instanceProperties) {
        String methodName = "removePronouns";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, "pronouns", instanceProperties, "removePronouns");
        }
        return null;
    }

    protected String removeText(InstanceProperties instanceProperties) {
        String methodName = "removeText";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, "text", instanceProperties, "removeText");
        }
        return null;
    }

    protected String removePriority(InstanceProperties instanceProperties) {
        String methodName = "removePriority";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, "priority", instanceProperties, "removePriority");
        }
        return null;
    }

    protected int removeIntPriority(InstanceProperties instanceProperties) {
        String methodName = "removeIntPriority";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeIntProperty(this.serviceName, "priority", instanceProperties, "removeIntPriority");
        }
        return 0;
    }

    protected int removeHeadCount(InstanceProperties instanceProperties) {
        String methodName = "removeHeadCount";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeIntProperty(this.serviceName, "headCount", instanceProperties, "removeHeadCount");
        }
        return 0;
    }

    protected String removeScope(InstanceProperties instanceProperties) {
        String methodName = "removeScope";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, "scope", instanceProperties, "removeScope");
        }
        return null;
    }

    protected List<String> removeImplications(InstanceProperties instanceProperties) {
        String methodName = "removeImplications";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringArrayProperty(this.serviceName, "implications", instanceProperties, "removeImplications");
        }
        return null;
    }

    protected List<String> removeOutcomes(InstanceProperties instanceProperties) {
        String methodName = "removeOutcomes";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringArrayProperty(this.serviceName, "outcomes", instanceProperties, "removeOutcomes");
        }
        return null;
    }

    protected List<String> removeResults(InstanceProperties instanceProperties) {
        String methodName = "removeResults";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringArrayProperty(this.serviceName, "results", instanceProperties, "removeResults");
        }
        return null;
    }

    protected List<String> removeBusinessImperatives(InstanceProperties instanceProperties) {
        String methodName = "removeBusinessImperatives";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringArrayProperty(this.serviceName, "businessImperatives", instanceProperties, "removeBusinessImperatives");
        }
        return null;
    }

    protected String removeJurisdiction(InstanceProperties instanceProperties) {
        String methodName = "removeJurisdiction";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, "jurisdiction", instanceProperties, "removeJurisdiction");
        }
        return null;
    }

    protected String removeDetails(InstanceProperties instanceProperties) {
        String methodName = "removeDetails";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, "details", instanceProperties, "removeDetails");
        }
        return null;
    }

    protected String getRationale(InstanceProperties instanceProperties) {
        String methodName = "removeRationale";
        if (instanceProperties != null) {
            return this.repositoryHelper.getStringProperty(this.serviceName, "rationale", instanceProperties, "removeRationale");
        }
        return null;
    }

    protected String removeImplementationDescription(InstanceProperties instanceProperties) {
        String methodName = "removeImplementationDescription";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, "implementationDescription", instanceProperties, "removeImplementationDescription");
        }
        return null;
    }

    protected String removeCriteria(InstanceProperties instanceProperties) {
        String methodName = "removeCriteria";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, "criteria", instanceProperties, "removeCriteria");
        }
        return null;
    }

    protected int removeDomainIdentifier(InstanceProperties instanceProperties) {
        String methodName = "removeDomainIdentifier";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeIntProperty(this.serviceName, "domainIdentifier", instanceProperties, "removeDomainIdentifier");
        }
        return 0;
    }

    protected int removeLevelIdentifier(InstanceProperties instanceProperties) {
        String methodName = "removeLevelIdentifier";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeIntProperty(this.serviceName, "levelIdentifier", instanceProperties, "removeLevelIdentifier");
        }
        return 0;
    }

    protected String removeMeasurement(InstanceProperties instanceProperties) {
        String methodName = "removeMeasurement";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, "measurement", instanceProperties, "removeMeasurement");
        }
        return null;
    }

    protected String removeTarget(InstanceProperties instanceProperties) {
        String methodName = "removeTarget";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, "target", instanceProperties, "removeTarget");
        }
        return null;
    }

    protected String removeClassificationName(InstanceProperties instanceProperties) {
        String methodName = "removeClassificationName";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, "classificationName", instanceProperties, "removeClassificationName");
        }
        return null;
    }

    protected String removeClassificationPropertyName(InstanceProperties instanceProperties) {
        String methodName = "removeClassificationPropertyName";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, "classificationPropertyName", instanceProperties, "removeClassificationPropertyName");
        }
        return null;
    }

    protected String removeProcessingEngineUserId(InstanceProperties instanceProperties) {
        String methodName = "removeProcessingEngineUserId";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, "processingEngineUserId", instanceProperties, "removeProcessingEngineUserId");
        }
        return null;
    }

    protected String removeRequestType(InstanceProperties instanceProperties) {
        String methodName = "removeRequestType";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, "requestType", instanceProperties, "removeRequestType");
        }
        return null;
    }

    protected Map<String, String> removeRequestParameters(InstanceProperties instanceProperties) {
        String methodName = "removeRequestParameters";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringMapFromProperty(this.serviceName, "requestParameters", instanceProperties, "removeRequestParameters");
        }
        return null;
    }

    protected String removeExecutorEngineGUID(InstanceProperties instanceProperties) {
        String methodName = "removeExecutorEngineGUID";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, "executorEngineGUID", instanceProperties, "removeExecutorEngineGUID");
        }
        return null;
    }

    protected String removeExecutorEngineName(InstanceProperties instanceProperties) {
        String methodName = "removeExecutorEngineName";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, "executorEngineName", instanceProperties, "removeExecutorEngineName");
        }
        return null;
    }

    protected String removeProcessName(InstanceProperties instanceProperties) {
        String methodName = "removeProcessName";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, "processName", instanceProperties, "removeProcessName");
        }
        return null;
    }

    protected String removeGovernanceActionTypeGUID(InstanceProperties instanceProperties) {
        String methodName = "removeGovernanceActionTypeGUID";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, "governanceActionTypeGUID", instanceProperties, "removeGovernanceActionTypeGUID");
        }
        return null;
    }

    protected String removeGovernanceActionTypeName(InstanceProperties instanceProperties) {
        String methodName = "removeGovernanceActionTypeName";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, "governanceActionTypeName", instanceProperties, "removeGovernanceActionTypeName");
        }
        return null;
    }

    protected List<String> removeProducedGuards(InstanceProperties instanceProperties) {
        String methodName = "removeProducedGuards";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringArrayProperty(this.serviceName, "producedGuards", instanceProperties, "removeProducedGuards");
        }
        return null;
    }

    protected List<String> removeMandatoryGuards(InstanceProperties instanceProperties) {
        String methodName = "removeMandatoryGuards";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringArrayProperty(this.serviceName, "mandatoryGuards", instanceProperties, "removeMandatoryGuards");
        }
        return null;
    }

    protected List<String> removeReceivedGuards(InstanceProperties instanceProperties) {
        String methodName = "removeReceivedGuards";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringArrayProperty(this.serviceName, "receivedGuards", instanceProperties, "removeReceivedGuards");
        }
        return null;
    }

    protected List<String> removeCompletionGuards(InstanceProperties instanceProperties) {
        String methodName = "removeCompletionGuards";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringArrayProperty(this.serviceName, "completionGuards", instanceProperties, "removeCompletionGuards");
        }
        return null;
    }

    protected Date removeStartDate(InstanceProperties instanceProperties) {
        String methodName = "removeStartDate";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeDateProperty(this.serviceName, "startDate", instanceProperties, "removeStartDate");
        }
        return null;
    }

    protected Date removePlannedEndDate(InstanceProperties instanceProperties) {
        String methodName = "removePlannedEndDate";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeDateProperty(this.serviceName, "plannedEndDate", instanceProperties, "removePlannedEndDate");
        }
        return null;
    }

    protected Date removeCreationTime(InstanceProperties instanceProperties) {
        String methodName = "removeCreationTime";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeDateProperty(this.serviceName, "creationTime", instanceProperties, "removeCreationTime");
        }
        return null;
    }

    protected Date removeDueTime(InstanceProperties instanceProperties) {
        String methodName = "removeDueTime";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeDateProperty(this.serviceName, "dueTime", instanceProperties, "removeDueTime");
        }
        return null;
    }

    protected Date removeCompletionTime(InstanceProperties instanceProperties) {
        String methodName = "removeCompletionTime";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeDateProperty(this.serviceName, "completionTime", instanceProperties, "removeCompletionTime");
        }
        return null;
    }

    protected Date removeCompletionDate(InstanceProperties instanceProperties) {
        String methodName = "removeCompletionDate";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeDateProperty(this.serviceName, "completionDate", instanceProperties, "removeCompletionDate");
        }
        return null;
    }

    protected String removeStatus(InstanceProperties instanceProperties) {
        String methodName = "removeStatus";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, "status", instanceProperties, "removeStatus");
        }
        return null;
    }

    protected String removeRequestSourceName(InstanceProperties instanceProperties) {
        String methodName = "removeRequestSourceName";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, "requestSourceName", instanceProperties, "removeRequestSourceName");
        }
        return null;
    }

    protected String removeActionTargetName(InstanceProperties instanceProperties) {
        String methodName = "removeActionTargetName";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, "actionTargetName", instanceProperties, "removeActionTargetName");
        }
        return null;
    }

    protected String removeOriginGovernanceService(InstanceProperties instanceProperties) {
        String methodName = "removeOriginGovernanceService";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, "originGovernanceService", instanceProperties, "removeOriginGovernanceService");
        }
        return null;
    }

    protected String removeOriginGovernanceEngine(InstanceProperties instanceProperties) {
        String methodName = "removeOriginGovernanceEngine";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, "originGovernanceEngine", instanceProperties, "removeOriginGovernanceEngine");
        }
        return null;
    }

    protected String getLicenseGUID(InstanceProperties instanceProperties) {
        String methodName = "getLicenseGUID";
        if (instanceProperties != null) {
            return this.repositoryHelper.getStringProperty(this.serviceName, "licenseGUID", instanceProperties, "getLicenseGUID");
        }
        return null;
    }

    protected String getCertificationGUID(InstanceProperties instanceProperties) {
        String methodName = "getCertificationGUID";
        if (instanceProperties != null) {
            return this.repositoryHelper.getStringProperty(this.serviceName, "certificateGUID", instanceProperties, "getCertificationGUID");
        }
        return null;
    }

    protected Date getStart(InstanceProperties instanceProperties) {
        String methodName = "getStart";
        if (instanceProperties != null) {
            return this.repositoryHelper.getDateProperty(this.serviceName, "start", instanceProperties, "getStart");
        }
        return null;
    }

    protected Date getEnd(InstanceProperties instanceProperties) {
        String methodName = "getEnd";
        if (instanceProperties != null) {
            return this.repositoryHelper.getDateProperty(this.serviceName, "end", instanceProperties, "getEnd");
        }
        return null;
    }

    protected String getConditions(InstanceProperties instanceProperties) {
        String methodName = "getConditions";
        if (instanceProperties != null) {
            return this.repositoryHelper.getStringProperty(this.serviceName, "conditions", instanceProperties, "getConditions");
        }
        return null;
    }

    protected String getCustodian(InstanceProperties instanceProperties) {
        String methodName = "getCustodian";
        if (instanceProperties != null) {
            return this.repositoryHelper.getStringProperty(this.serviceName, "custodian", instanceProperties, "getCustodian");
        }
        return null;
    }

    protected String getCertifiedBy(InstanceProperties instanceProperties) {
        String methodName = "getCertifiedBy";
        if (instanceProperties != null) {
            return this.repositoryHelper.getStringProperty(this.serviceName, "certifiedBy", instanceProperties, "getCertifiedBy");
        }
        return null;
    }

    protected String getRecipient(InstanceProperties instanceProperties) {
        String methodName = "getRecipient";
        if (instanceProperties != null) {
            return this.repositoryHelper.getStringProperty(this.serviceName, "recipient", instanceProperties, "getRecipient");
        }
        return null;
    }

    protected String getLicensedBy(InstanceProperties instanceProperties) {
        String methodName = "getLicensedBy";
        if (instanceProperties != null) {
            return this.repositoryHelper.getStringProperty(this.serviceName, "licensedBy", instanceProperties, "getLicensedBy");
        }
        return null;
    }

    protected String getLicensee(InstanceProperties instanceProperties) {
        String methodName = "getLicensee";
        if (instanceProperties != null) {
            return this.repositoryHelper.getStringProperty(this.serviceName, "licensee", instanceProperties, "getLicensee");
        }
        return null;
    }

    protected String removePreferredValue(InstanceProperties instanceProperties) {
        String methodName = "removePreferredValue";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, "preferredValue", instanceProperties, "removePreferredValue");
        }
        return null;
    }

    protected boolean getStrictRequirement(InstanceProperties instanceProperties) {
        String methodName = "getStrictRequirement";
        if (instanceProperties != null) {
            return this.repositoryHelper.getBooleanProperty(this.serviceName, "strictRequirement", instanceProperties, "getStrictRequirement");
        }
        return false;
    }

    protected int getConfidence(InstanceProperties instanceProperties) {
        String methodName = "getConfidence";
        if (instanceProperties != null) {
            return this.repositoryHelper.getIntProperty(this.serviceName, "confidence", instanceProperties, "getConfidence");
        }
        return 0;
    }

    protected String getSteward(InstanceProperties instanceProperties) {
        String methodName = "getSteward";
        if (instanceProperties != null) {
            return this.repositoryHelper.getStringProperty(this.serviceName, "steward", instanceProperties, "getSteward");
        }
        return null;
    }

    protected String getStewardTypeName(InstanceProperties instanceProperties) {
        String methodName = "getStewardTypeName";
        if (instanceProperties != null) {
            return this.repositoryHelper.getStringProperty(this.serviceName, "stewardTypeName", instanceProperties, "getStewardTypeName");
        }
        return null;
    }

    protected String getStewardPropertyName(InstanceProperties instanceProperties) {
        String methodName = "getStewardPropertyName";
        if (instanceProperties != null) {
            return this.repositoryHelper.getStringProperty(this.serviceName, "stewardPropertyName", instanceProperties, "getStewardPropertyName");
        }
        return null;
    }

    protected String getNotes(InstanceProperties instanceProperties) {
        String methodName = "getNotes";
        if (instanceProperties != null) {
            return this.repositoryHelper.getStringProperty(this.serviceName, "notes", instanceProperties, "getNotes");
        }
        return null;
    }

    protected String getPointType(InstanceProperties instanceProperties) {
        String methodName = "getPointType";
        if (instanceProperties != null) {
            return this.repositoryHelper.getStringProperty(this.serviceName, "pointType", instanceProperties, "getPointType");
        }
        return null;
    }

    protected String getAssociationDescription(InstanceProperties instanceProperties) {
        String methodName = "getAssociationDescription";
        if (instanceProperties != null) {
            return this.repositoryHelper.getStringProperty(this.serviceName, "associationDescription", instanceProperties, "getAssociationDescription");
        }
        return null;
    }

    protected String getSymbolicName(InstanceProperties instanceProperties) {
        String methodName = "getSymbolicName";
        if (instanceProperties != null) {
            return this.repositoryHelper.getStringProperty(this.serviceName, "symbolicName", instanceProperties, "getSymbolicName");
        }
        return null;
    }

    protected String getImplementationValue(InstanceProperties instanceProperties) {
        String methodName = "getImplementationValue";
        if (instanceProperties != null) {
            return this.repositoryHelper.getStringProperty(this.serviceName, "implementationValue", instanceProperties, "getImplementationValue");
        }
        return null;
    }

    protected Map<String, String> getAdditionalValues(InstanceProperties instanceProperties) {
        String methodName = "getAdditionalValues";
        if (instanceProperties != null) {
            return this.repositoryHelper.getStringMapFromProperty(this.serviceName, "additionalValues", instanceProperties, "getAdditionalValues");
        }
        return null;
    }

    protected String removeCommentText(InstanceProperties instanceProperties) {
        String methodName = "removeCommentText";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, "text", instanceProperties, "removeCommentText");
        }
        return null;
    }

    protected boolean getIsPublic(InstanceProperties instanceProperties) {
        String methodName = "getIsPublic";
        if (instanceProperties != null) {
            return this.repositoryHelper.getBooleanProperty(this.serviceName, "isPublic", instanceProperties, "getIsPublic");
        }
        return false;
    }

    protected boolean removeIsPublic(InstanceProperties instanceProperties) {
        String methodName = "removeIsPublic";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeBooleanProperty(this.serviceName, "isPublic", instanceProperties, "removeIsPublic");
        }
        return false;
    }

    protected String removeReview(InstanceProperties instanceProperties) {
        String methodName = "removeReview";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, "review", instanceProperties, "removeReview");
        }
        return null;
    }

    protected String removeTagName(InstanceProperties instanceProperties) {
        String methodName = "removeTagName";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, "tagName", instanceProperties, "removeTagName");
        }
        return null;
    }

    protected String removeTagDescription(InstanceProperties instanceProperties) {
        String methodName = "removeTagDescription";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, "tagDescription", instanceProperties, "removeTagDescription");
        }
        return null;
    }

    protected Date removeExecutionDate(InstanceProperties instanceProperties) {
        String methodName = "removeExecutionDate";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeDateProperty(this.serviceName, "executionDate", instanceProperties, "removeExecutionDate");
        }
        return null;
    }

    protected Map<String, String> removeAnalysisParameters(InstanceProperties instanceProperties) {
        String methodName = "removeAnalysisParameters";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringMapFromProperty(this.serviceName, "analysisParameters", instanceProperties, "removeAnalysisParameters");
        }
        return null;
    }

    protected String removeAnalysisStep(InstanceProperties instanceProperties) {
        String methodName = "removeAnalysisStep";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, "discoveryRequestStep", instanceProperties, "removeAnalysisStep");
        }
        return null;
    }

    protected String removeAnnotationType(InstanceProperties instanceProperties) {
        String methodName = "removeAnnotationType";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, "annotationType", instanceProperties, "removeAnnotationType");
        }
        return null;
    }

    protected int removeConfidenceLevel(InstanceProperties instanceProperties) {
        String methodName = "removeConfidenceLevel";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeIntProperty(this.serviceName, "confidenceLevel", instanceProperties, "removeConfidenceLevel");
        }
        return 0;
    }

    protected String removeExpression(InstanceProperties instanceProperties) {
        String methodName = "removeExpression";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, "annotationType", instanceProperties, "removeExpression");
        }
        return null;
    }

    protected String removeExplanation(InstanceProperties instanceProperties) {
        String methodName = "removeExplanation";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, "explanation", instanceProperties, "removeExplanation");
        }
        return null;
    }

    protected String removeJsonProperties(InstanceProperties instanceProperties) {
        String methodName = "removeJsonProperties";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, "jsonProperties", instanceProperties, "removeJsonProperties");
        }
        return null;
    }

    protected Date removeReviewDate(InstanceProperties instanceProperties) {
        String methodName = "removeReviewDate";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeDateProperty(this.serviceName, "reviewDate", instanceProperties, "removeReviewDate");
        }
        return null;
    }

    protected String removeSteward(InstanceProperties instanceProperties) {
        String methodName = "removeSteward";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, "steward", instanceProperties, "removeSteward");
        }
        return null;
    }

    protected String removeComment(InstanceProperties instanceProperties) {
        String methodName = "removeComment";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, "comment", instanceProperties, "removeComment");
        }
        return null;
    }

    protected String removeSchemaName(InstanceProperties instanceProperties) {
        String methodName = "removeSchemaName";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, "schemaName", instanceProperties, "removeSchemaName");
        }
        return null;
    }

    protected String removeSchemaType(InstanceProperties instanceProperties) {
        String methodName = "removeSchemaType";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, "schemaType", instanceProperties, "removeSchemaType");
        }
        return null;
    }

    protected Map<String, String> removeCandidateClassifications(InstanceProperties instanceProperties) {
        String methodName = "removeCandidateClassifications";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringMapFromProperty(this.serviceName, "candidateClassifications", instanceProperties, "removeCandidateClassifications");
        }
        return null;
    }

    protected List<String> removeCandidateDataClassGUIDs(InstanceProperties instanceProperties) {
        String methodName = "removeCandidateDataClassGUIDs";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringArrayProperty(this.serviceName, "candidateDataClassGUIDs", instanceProperties, "removeCandidateDataClassGUIDs");
        }
        return null;
    }

    protected String removeInferredDataType(InstanceProperties instanceProperties) {
        String methodName = "removeInferredDataType";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, "inferredDataType", instanceProperties, "removeInferredDataType");
        }
        return null;
    }

    protected String removeInferredFormat(InstanceProperties instanceProperties) {
        String methodName = "removeInferredFormat";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, "inferredFormat", instanceProperties, "removeInferredFormat");
        }
        return null;
    }

    protected int removeInferredLength(InstanceProperties instanceProperties) {
        String methodName = "removeInferredLength";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeIntProperty(this.serviceName, "inferredLength", instanceProperties, "removeInferredLength");
        }
        return 0;
    }

    protected int removeInferredPrecision(InstanceProperties instanceProperties) {
        String methodName = "removeInferredPrecision";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeIntProperty(this.serviceName, "inferredPrecision", instanceProperties, "removeInferredPrecision");
        }
        return 0;
    }

    protected int removeInferredScale(InstanceProperties instanceProperties) {
        String methodName = "removeInferredScale";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeIntProperty(this.serviceName, "inferredScale", instanceProperties, "removeInferredScale");
        }
        return 0;
    }

    protected Map<String, String> removeProfileProperties(InstanceProperties instanceProperties) {
        String methodName = "removeProfileProperties";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringMapFromProperty(this.serviceName, "profileProperties", instanceProperties, "removeProfileProperties");
        }
        return null;
    }

    protected Map<String, Boolean> removeProfileFlags(InstanceProperties instanceProperties) {
        String methodName = "removeProfileFlags";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeBooleanMapFromProperty(this.serviceName, "profileFlags", instanceProperties, "removeProfileFlags");
        }
        return null;
    }

    protected Map<String, Long> removeProfileCounts(InstanceProperties instanceProperties) {
        String methodName = "removeProfileCounts";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeLongMapFromProperty(this.serviceName, "profileCounts", instanceProperties, "removeProfileCounts");
        }
        return null;
    }

    protected List<String> removeValueList(InstanceProperties instanceProperties) {
        String methodName = "removeValueList";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringArrayProperty(this.serviceName, "valueList", instanceProperties, "removeValueList");
        }
        return null;
    }

    protected Map<String, Integer> removeValueCount(InstanceProperties instanceProperties) {
        String methodName = "removeValueCount";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeIntegerMapFromProperty(this.serviceName, "valueCount", instanceProperties, "removeValueCount");
        }
        return null;
    }

    protected String removeValueRangeFrom(InstanceProperties instanceProperties) {
        String methodName = "removeValueRangeFrom";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, "valueRangeTo", instanceProperties, "removeValueRangeFrom");
        }
        return null;
    }

    protected String removeValueRangeTo(InstanceProperties instanceProperties) {
        String methodName = "removeValueRangeTo";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, "valueRangeTo", instanceProperties, "removeValueRangeTo");
        }
        return null;
    }

    protected String removeAverageValue(InstanceProperties instanceProperties) {
        String methodName = "removeAverageValue";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, "averageValue", instanceProperties, "removeAverageValue");
        }
        return null;
    }

    protected Map<String, String> removeDataSourceProperties(InstanceProperties instanceProperties) {
        String methodName = "removeDataSourceProperties";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringMapFromProperty(this.serviceName, "dataSourceProperties", instanceProperties, "removeDataSourceProperties");
        }
        return null;
    }

    protected int removeSize(InstanceProperties instanceProperties) {
        String methodName = "removeSize";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeIntProperty(this.serviceName, "size", instanceProperties, "removeSize");
        }
        return 0;
    }

    protected String removeEncoding(InstanceProperties instanceProperties) {
        String methodName = "removeEncoding";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, "encoding", instanceProperties, "removeEncoding");
        }
        return null;
    }

    protected String removeParameterType(InstanceProperties instanceProperties) {
        String methodName = "removeParameterType";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, "parameterType", instanceProperties, "removeParameterType");
        }
        return null;
    }

    protected String removeQualityDimension(InstanceProperties instanceProperties) {
        String methodName = "removeQualityDimension";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, "qualityDimension", instanceProperties, "removeQualityDimension");
        }
        return null;
    }

    protected int removeQualityScore(InstanceProperties instanceProperties) {
        String methodName = "removeQualityScore";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeIntProperty(this.serviceName, "qualityScore", instanceProperties, "removeQualityScore");
        }
        return 0;
    }

    protected String removeDuplicateAnchorGUID(InstanceProperties instanceProperties) {
        String methodName = "removeDuplicateAnchorGUID";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, "duplicateAnchorGUID", instanceProperties, "removeDuplicateAnchorGUID");
        }
        return null;
    }

    protected List<String> removeDivergentPropertyNames(InstanceProperties instanceProperties) {
        String methodName = "removeDivergentPropertyNames";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringArrayProperty(this.serviceName, "divergentPropertyNames", instanceProperties, "removeDivergentPropertyNames");
        }
        return null;
    }

    protected String removeDivergentClassificationName(InstanceProperties instanceProperties) {
        String methodName = "removeDivergentClassificationName";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, "divergentClassificationName", instanceProperties, "removeDivergentClassificationName");
        }
        return null;
    }

    protected List<String> removeDivergentClassificationPropertyNames(InstanceProperties instanceProperties) {
        String methodName = "removeDivergentClassificationPropertyNames";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringArrayProperty(this.serviceName, "divergentClassificationPropertyNames", instanceProperties, "removeDivergentClassificationPropertyNames");
        }
        return null;
    }

    protected String removeDivergentRelationshipGUID(InstanceProperties instanceProperties) {
        String methodName = "removeDivergentRelationshipGUID";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, "divergentRelationshipGUID", instanceProperties, "removeDivergentRelationshipGUID");
        }
        return null;
    }

    protected List<String> removeDivergentRelationshipPropertyNames(InstanceProperties instanceProperties) {
        String methodName = "removeDivergentRelationshipPropertyNames";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringArrayProperty(this.serviceName, "divergentRelationshipPropertyNames", instanceProperties, "removeDivergentRelationshipPropertyNames");
        }
        return null;
    }

    protected String removeAttachmentGUID(InstanceProperties instanceProperties) {
        String methodName = "removeAttachmentGUID";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, "attachmentGUID", instanceProperties, "removeAttachmentGUID");
        }
        return null;
    }

    protected String removeDuplicateAttachmentGUID(InstanceProperties instanceProperties) {
        String methodName = "removeDuplicateAttachmentGUID";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, "duplicateAttachmentGUID", instanceProperties, "removeDuplicateAttachmentGUID");
        }
        return null;
    }

    protected String removeRelatedEntityGUID(InstanceProperties instanceProperties) {
        String methodName = "removeRelatedEntityGUID";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, "relatedEntityGUID", instanceProperties, "removeRelatedEntityGUID");
        }
        return null;
    }

    protected String removeRelationshipTypeName(InstanceProperties instanceProperties) {
        String methodName = "removeRelationshipTypeName";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, "relationshipTypeName", instanceProperties, "removeRelationshipTypeName");
        }
        return null;
    }

    protected Map<String, String> removeRelationshipProperties(InstanceProperties instanceProperties) {
        String methodName = "removeRelationshipProperties";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringMapFromProperty(this.serviceName, "relationshipProperties", instanceProperties, "removeRelationshipProperties");
        }
        return null;
    }

    protected String removeDiscoveryActivity(InstanceProperties instanceProperties) {
        String methodName = "removeDiscoveryActivity";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, "discoveryActivity", instanceProperties, "removeDiscoveryActivity");
        }
        return null;
    }

    protected String removeActionRequested(InstanceProperties instanceProperties) {
        String methodName = "removeActionRequested";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, "actionRequested", instanceProperties, "removeActionRequested");
        }
        return null;
    }

    protected Map<String, String> removeActionProperties(InstanceProperties instanceProperties) {
        String methodName = "removeActionProperties";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringMapFromProperty(this.serviceName, "actionProperties", instanceProperties, "removeActionProperties");
        }
        return null;
    }

    protected String removeInformalTerm(InstanceProperties instanceProperties) {
        String methodName = "removeInformalTerm";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, "informalTerm", instanceProperties, "removeInformalTerm");
        }
        return null;
    }

    protected List<String> removeCandidateGlossaryTermGUIDs(InstanceProperties instanceProperties) {
        String methodName = "removeCandidateGlossaryTermGUIDs";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringArrayProperty(this.serviceName, "candidateGlossaryTermGUIDs", instanceProperties, "removeCandidateGlossaryTermGUIDs");
        }
        return null;
    }

    protected String removeInformalTopic(InstanceProperties instanceProperties) {
        String methodName = "removeInformalTopic";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, "informalTopic", instanceProperties, "removeInformalTopic");
        }
        return null;
    }

    protected List<String> removeCandidateGlossaryCategoryGUIDs(InstanceProperties instanceProperties) {
        String methodName = "removeCandidateGlossaryCategoryGUIDs";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringArrayProperty(this.serviceName, "candidateGlossaryCategoryGUIDs", instanceProperties, "removeCandidateGlossaryCategoryGUIDs");
        }
        return null;
    }

    protected List<String> removeDuplicateAnchorGUIDs(InstanceProperties instanceProperties) {
        String methodName = "removeDuplicateAnchorGUIDs";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringArrayProperty(this.serviceName, "duplicateAnchorGUIDs", instanceProperties, "removeDuplicateAnchorGUIDs");
        }
        return null;
    }

    protected List<String> removeMatchingPropertyNames(InstanceProperties instanceProperties) {
        String methodName = "removeMatchingPropertyNames";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringArrayProperty(this.serviceName, "matchingPropertyNames", instanceProperties, "removeMatchingPropertyNames");
        }
        return null;
    }

    protected List<String> removeMatchingClassificationNames(InstanceProperties instanceProperties) {
        String methodName = "removeMatchingClassificationNames";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringArrayProperty(this.serviceName, "matchingClassificationNames", instanceProperties, "removeMatchingClassificationNames");
        }
        return null;
    }

    protected List<String> removeMatchingAttachmentGUIDs(InstanceProperties instanceProperties) {
        String methodName = "removeMatchingAttachmentGUIDs";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringArrayProperty(this.serviceName, "matchingAttachmentGUIDS", instanceProperties, "removeMatchingAttachmentGUIDs");
        }
        return null;
    }

    protected List<String> removeMatchingRelationshipGUIDs(InstanceProperties instanceProperties) {
        String methodName = "removeMatchingRelationshipGUIDs";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringArrayProperty(this.serviceName, "matchingRelationshipGUIDs", instanceProperties, "removeMatchingRelationshipGUIDs");
        }
        return null;
    }

    protected String removeDataFieldName(InstanceProperties instanceProperties) {
        String methodName = "removeDataFieldName";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, "dataFieldName", instanceProperties, "removeDataFieldName");
        }
        return null;
    }

    protected String removeDataFieldType(InstanceProperties instanceProperties) {
        String methodName = "removeDataFieldType";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, "dataFieldType", instanceProperties, "removeDataFieldType");
        }
        return null;
    }

    protected String removeDataFieldDescription(InstanceProperties instanceProperties) {
        String methodName = "removeDataFieldDescription";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, "dataFieldDescription", instanceProperties, "removeDataFieldDescription");
        }
        return null;
    }

    protected List<String> removeDataFieldAliases(InstanceProperties instanceProperties) {
        String methodName = "removeDataFieldAliases";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringArrayProperty(this.serviceName, "dataFieldAliases", instanceProperties, "removeDataFieldAliases");
        }
        return null;
    }
}

