/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.util.Date;
import java.util.Map;
import org.odpi.openmetadata.commonservices.generichandlers.ReferenceableBuilder;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.ClassificationOrigin;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProvenanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeErrorException;

public class ProjectBuilder
extends ReferenceableBuilder {
    private String identifier = null;
    private String name = null;
    private String description = null;
    private Date startDate = null;
    private Date plannedEndDate = null;
    private String projectStatus = null;

    public ProjectBuilder(String qualifiedName, String identifier, String name, String description, Date startDate, Date plannedEndDate, String projectStatus, Map<String, String> additionalProperties, String typeGUID, String typeName, Map<String, Object> extendedProperties, OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(qualifiedName, additionalProperties, typeGUID, typeName, extendedProperties, repositoryHelper, serviceName, serverName);
        this.identifier = identifier;
        this.name = name;
        this.description = description;
        this.startDate = startDate;
        this.plannedEndDate = plannedEndDate;
        this.projectStatus = projectStatus;
    }

    public ProjectBuilder(String qualifiedName, String identifier, String name, String description, OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(qualifiedName, repositoryHelper, serviceName, serverName);
        this.identifier = identifier;
        this.name = name;
        this.description = description;
    }

    ProjectBuilder(OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super("0799569f-0c16-4a1f-86d9-e2e89568f7fd", "Project", repositoryHelper, serviceName, serverName);
    }

    public void setCampaignClassification(String userId, String methodName) throws InvalidParameterException {
        this.setProjectTypeClassification(userId, "Campaign", methodName);
    }

    public void setTaskClassification(String userId, String methodName) throws InvalidParameterException {
        this.setProjectTypeClassification(userId, "Task", methodName);
    }

    public void setProjectTypeClassification(String userId, String classificationName, String methodName) throws InvalidParameterException {
        try {
            Classification classification = this.repositoryHelper.getNewClassification(this.serviceName, null, null, InstanceProvenanceType.LOCAL_COHORT, userId, classificationName, this.typeName, ClassificationOrigin.ASSIGNED, null, null);
            this.newClassifications.put(classification.getName(), classification);
        }
        catch (TypeErrorException error) {
            this.errorHandler.handleUnsupportedType((Exception)((Object)error), methodName, "SecurityTags");
        }
    }

    @Override
    public InstanceProperties getInstanceProperties(String methodName) throws InvalidParameterException {
        InstanceProperties properties = super.getInstanceProperties(methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "identifier", this.identifier, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "name", this.name, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "description", this.description, methodName);
        properties = this.repositoryHelper.addDatePropertyToInstance(this.serviceName, properties, "startDate", this.startDate, methodName);
        properties = this.repositoryHelper.addDatePropertyToInstance(this.serviceName, properties, "plannedEndDate", this.plannedEndDate, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "projectStatus", this.projectStatus, methodName);
        return properties;
    }
}

