/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers.ffdc;

import org.odpi.openmetadata.frameworks.auditlog.messagesets.AuditLogMessageDefinition;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.AuditLogMessageSet;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.AuditLogRecordSeverity;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLogRecordSeverity;

public enum GenericHandlersAuditCode implements AuditLogMessageSet
{
    UNABLE_TO_SET_ANCHORS("OMAG-GENERIC-HANDLERS-0001", OMRSAuditLogRecordSeverity.ERROR, "The Open Metadata Service {0} is not able to set the Anchors classification on entity {1} of type {2} ({3}) during method {4}. The resulting exception was {5} with error message {6}", "The server was attempting to add Anchors classifications to a collection of metadata instances that are logically part of the same object.  This classification is used to optimize the retrieval and maintenance of complex objects.  It is optional function.  The server continues to process the original request which will complete successfully unless something else goes wrong.", "No specific action is required.  This message is to highlight that the retrieval and management of metadata is not optimalbecause none of the repositories in the cohort support the Anchors classification.  To enable the optimization provided through the Anchors classification, add an Egeria native metadata server to the cohort.  This will provide the support for the Anchors classification."),
    SETTING_UP_EXTERNAL_ID("OMAG-GENERIC-HANDLERS-0002", OMRSAuditLogRecordSeverity.INFO, "{0} has linked {1} element {2} to external identifier {3} from third party metadata source {4} ({5}) as part of the {6} operation.", "The described linkage is stored in one of the connected open metadata repositories.", "No specific action is required.  This message is to highlight that the association has been made."),
    PERMITTED_SYNC_CHANGING("OMAG-GENERIC-HANDLERS-0003", OMRSAuditLogRecordSeverity.INFO, "The permitted synchronization for {0} {1} ({2}) has changed for identifier {3} from {4} to {5}", "The described synchronization configuration is stored in one of the connected open metadata repositories.", "Verify that the configuration for the integration connector supporting this third party technology has legitimately changed to the new permitted synchronization."),
    NEW_EXTERNAL_RELATIONSHIP("OMAG-GENERIC-HANDLERS-0004", OMRSAuditLogRecordSeverity.INFO, "{0} has created a new {1} relationship between {2} {3} and {4} {5} during method {6} on behalf of external metadata manager {7} ({8})", "The described new relationship is stored in one of the connected open metadata repositories.", "No action is required now but this message can be useful to understand where particular relationships came from."),
    EXTERNAL_RELATIONSHIP_UPDATED("OMAG-GENERIC-HANDLERS-0005", OMRSAuditLogRecordSeverity.INFO, "{0} has updated an existing {1} relationship {2} during method {3} on behalf of external metadata manager {4} ({5})", "The updated properties of described relationship is stored in one of the connected open metadata repositories.", "No action is required now but this message can be useful to understand where particular relationships' values came from."),
    EXTERNAL_RELATIONSHIP_REMOVED("OMAG-GENERIC-HANDLERS-0006", OMRSAuditLogRecordSeverity.INFO, "{0} has removed the {1} relationship between {2} {3} and {4} {5} during method {6} on behalf of external metadata manager {7} ({8})", "The removed relationship was stored in one of the connected open metadata repositories but has now been removed.", "No action is required now but this message can be useful to understand why a particular relationship has been removed."),
    UNABLE_TO_DELETE_UNANCHORED_BEAN("OMAG-GENERIC-HANDLERS-0007", OMRSAuditLogRecordSeverity.EXCEPTION, "The Open Metadata Service {0} has deleted a relationship, resulting in entity {1} of type {2} ({3}) losing its anchor.An attempt was made to delete this unanchored entity, which failed.  The resulting exception was {5} with error message {6}", "The server attempted to delete an entity that had lost its anchor. As the relationship was successfully deleted, the call succeeds. ", "This message is to highlight that an entity has lost its anchor, and a delete was attempted on it, but failed. An administrator should assess what is required for the entity, and either delete it or supply a new anchor for it."),
    IGNORING_UNNECESSARY_ENTITY_UPDATE("OMAG-GENERIC-HANDLERS-0008", OMRSAuditLogRecordSeverity.INFO, "Ignoring unnecessary update to {0} entity with unique identifier {1} through method {2} by user {3}", "No update is made to the entity in the repository because the new properties are the same as the old. In order to determine that the update is unnecessary, Egeria has retrieved the existing entity from the repository and compared it to the new values.", "Determine if the processing by Egeria is the most efficient way to detect if an update is required to the entity and make adjustments to the caller's logic if appropriate."),
    IGNORING_UNNECESSARY_RELATIONSHIP_UPDATE("OMAG-GENERIC-HANDLERS-0009", OMRSAuditLogRecordSeverity.INFO, "Ignoring unnecessary update to {0} relationship with unique identifier {1} through method {2} by user {3}", "No update is made to the relationship in the repository because the new properties are the same as the old. In order to determine that the update is unnecessary, Egeria has retrieved the existing relationship from the repository and compared it to the new values.", "Determine if the processing by Egeria is the most efficient way to detect if an update is required to the relationship and make adjustments to the caller's logic if appropriate."),
    IGNORING_UNNECESSARY_CLASSIFICATION_UPDATE("OMAG-GENERIC-HANDLERS-0010", OMRSAuditLogRecordSeverity.INFO, "Ignoring unnecessary update to {0} classification attached to entity with unique identifier {1} through method {2} by user {3}", "No update is made to the classification in the repository because the new properties are the same as the old. In order to determine that the update is unnecessary, Egeria has retrieved the existing entity from the repository and compared the classification properties to the new values.", "Determine if the processing by Egeria is the most efficient way to detect if an update is required to the classification and make adjustments to the caller's logic if appropriate."),
    INITIATE_GOVERNANCE_ACTION("OMAG-GENERIC-HANDLERS-0020", OMRSAuditLogRecordSeverity.STARTUP, "Initializing a new governance action {0} for request type {1} to run on governance engine {2} with receivedGuards of {3}, mandatoryGuards of {4}, supplied with request parameters {5} and a start time of {6}", "A new GovernanceAction entity is created.  This will be picked up by the Governance Engine OMASs running in the connected cohorts and passed onto their connected engine hosts.  These engine hosts will compete for the right to execute the governance action.", "Validate that this governance action should be initialized.  If so, check that the Governance Engine OMASs running in the connected cohorts publish the governance action to their connected engine host(s)."),
    INITIATE_GOVERNANCE_ACTION_FROM_TYPE("OMAG-GENERIC-HANDLERS-0021", OMRSAuditLogRecordSeverity.STARTUP, "Initializing a new governance action {0} from governance action type {1} for request type {2} to run on governance engine {3} with receivedGuards of {4}, mandatoryGuards of {5}, supplied with request parameters {6} and a start time of {7}", "A new GovernanceAction entity is created using the definition of the governance action type.  This will be picked up by the Governance Engine OMASs running in the connected cohorts and passed onto their connected engine hosts.  These engine hosts will compete for the right to execute the governance action.", "Validate that this governance action should be initialized using this type.  If so, check that the Governance Engine OMASs running in the connected cohorts publish the governance action to their connected engine host(s)."),
    ADD_ACTION_TARGETS("OMAG-GENERIC-HANDLERS-0022", OMRSAuditLogRecordSeverity.STARTUP, "Adding action target {0} ({1}) to governance action {2} ({3})", "The governance action is linked to the action target so that it is made available to the governance action service when it runs.", "Validate that this action target should be added to the governance action."),
    ACTION_CLAIM_REQUEST("OMAG-GENERIC-HANDLERS-0023", OMRSAuditLogRecordSeverity.STARTUP, "Governance engine with {0} userId is claiming governance action {1}", "The governance engine is requesting permission to execute the governance action.  This will be successful if the governance engine is the first to claim the governance action and it is in APPROVED status.", "Validate that one of the governance engines successfully claims the governance action."),
    SUCCESSFUL_ACTION_CLAIM_REQUEST("OMAG-GENERIC-HANDLERS-0024", OMRSAuditLogRecordSeverity.STARTUP, "Governance engine with {0} userId has successfully claimed governance action {1}", "The governance action is updated to show that the governance engine has claimed it and that its status is now WAITING.  This will be successful if the governance engine is the first to claim the governance action and it is in APPROVED status.", "Validate that only one of the governance engines successfully claims the governance action."),
    GOVERNANCE_ACTION_STATUS_CHANGE("OMAG-GENERIC-HANDLERS-0025", OMRSAuditLogRecordSeverity.STARTUP, "Status changed from {0} to {1} for governance action {2} by governance engine with {3} userId", "The governance action's status has been updated as requested.", "Validate that the status change is valid.");

    private String logMessageId;
    private OMRSAuditLogRecordSeverity severity;
    private String logMessage;
    private String systemAction;
    private String userAction;

    private GenericHandlersAuditCode(String messageId, OMRSAuditLogRecordSeverity severity, String message, String systemAction, String userAction) {
        this.logMessageId = messageId;
        this.severity = severity;
        this.logMessage = message;
        this.systemAction = systemAction;
        this.userAction = userAction;
    }

    public AuditLogMessageDefinition getMessageDefinition() {
        return new AuditLogMessageDefinition(this.logMessageId, (AuditLogRecordSeverity)this.severity, this.logMessage, this.systemAction, this.userAction);
    }

    public AuditLogMessageDefinition getMessageDefinition(String ... params) {
        AuditLogMessageDefinition messageDefinition = new AuditLogMessageDefinition(this.logMessageId, (AuditLogRecordSeverity)this.severity, this.logMessage, this.systemAction, this.userAction);
        messageDefinition.setMessageParameters(params);
        return messageDefinition;
    }

    public String toString() {
        return "GenericHandlersAuditCode{logMessageId='" + this.logMessageId + "', severity=" + this.severity + ", logMessage='" + this.logMessage + "', systemAction='" + this.systemAction + "', userAction='" + this.userAction + "'}";
    }
}

