/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.generichandlers.ActorProfileBuilder;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericConverter;
import org.odpi.openmetadata.commonservices.generichandlers.ReferenceableHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.metadatasecurity.server.OpenMetadataServerSecurityVerifier;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityProxy;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class ActorProfileHandler<B>
extends ReferenceableHandler<B> {
    public ActorProfileHandler(OpenMetadataAPIGenericConverter<B> converter, Class<B> beanClass, String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper, String localServerUserId, OpenMetadataServerSecurityVerifier securityVerifier, List<String> supportedZones, List<String> defaultZones, List<String> publishZones, AuditLog auditLog) {
        super(converter, beanClass, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
    }

    public String createActorProfile(String userId, String externalSourceGUID, String externalSourceName, String qualifiedName, String name, String description, Map<String, String> additionalProperties, String suppliedTypeName, Map<String, Object> extendedProperties, Date effectiveFrom, Date effectiveTo, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        String typeName = "ActorProfile";
        if (suppliedTypeName != null) {
            typeName = suppliedTypeName;
        }
        String typeGUID = this.invalidParameterHandler.validateTypeName(typeName, "ActorProfile", this.serviceName, methodName, this.repositoryHelper);
        ActorProfileBuilder builder = new ActorProfileBuilder(qualifiedName, name, description, additionalProperties, typeGUID, typeName, extendedProperties, this.repositoryHelper, this.serviceName, this.serverName);
        builder.setEffectivityDates(effectiveFrom, effectiveTo);
        return this.createBeanInRepository(userId, externalSourceGUID, externalSourceName, typeGUID, typeName, qualifiedName, "qualifiedName", builder, methodName);
    }

    public String createActorProfileFromTemplate(String userId, String externalSourceGUID, String externalSourceName, String templateGUID, String qualifiedName, String name, String description, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String templateGUIDParameterName = "templateGUID";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(templateGUID, "templateGUID", methodName);
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        ActorProfileBuilder builder = new ActorProfileBuilder(qualifiedName, name, description, this.repositoryHelper, this.serviceName, this.serverName);
        return this.createBeanFromTemplate(userId, externalSourceGUID, externalSourceName, templateGUID, "templateGUID", "5a2f38dc-d69d-4a6f-ad26-ac86f118fa35", "ActorProfile", qualifiedName, "qualifiedName", builder, methodName);
    }

    public void updateActorProfile(String userId, String externalSourceGUID, String externalSourceName, String profileGUID, String profileGUIDParameterName, String qualifiedName, String name, String description, Map<String, String> additionalProperties, String typeName, Map<String, Object> extendedProperties, boolean isMergeUpdate, Date effectiveFrom, Date effectiveTo, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(profileGUID, profileGUIDParameterName, methodName);
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        String typeGUID = this.invalidParameterHandler.validateTypeName(typeName, "ActorProfile", this.serviceName, methodName, this.repositoryHelper);
        ActorProfileBuilder builder = new ActorProfileBuilder(qualifiedName, name, description, additionalProperties, typeGUID, typeName, extendedProperties, this.repositoryHelper, this.serviceName, this.serverName);
        builder.setEffectivityDates(effectiveFrom, effectiveTo);
        this.updateBeanInRepository(userId, externalSourceGUID, externalSourceName, profileGUID, profileGUIDParameterName, typeGUID, typeName, false, false, this.supportedZones, builder.getInstanceProperties(methodName), isMergeUpdate, new Date(), methodName);
    }

    public void linkPeerPersonProfiles(String userId, String externalSourceGUID, String externalSourceName, String profile1GUID, String profile1GUIDParameterName, String profile2GUID, String profile2GUIDParameterName, Date effectiveFrom, Date effectiveTo, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.linkElementToElement(userId, externalSourceGUID, externalSourceName, profile1GUID, profile1GUIDParameterName, "Person", profile2GUID, profile2GUIDParameterName, "Person", false, false, this.supportedZones, "4a316abe-bccd-4d11-ad5a-4bfb4079b80b", "Peer", this.setUpEffectiveDates(null, effectiveFrom, effectiveTo), methodName);
    }

    public void unlinkPeerPersonProfiles(String userId, String externalSourceGUID, String externalSourceName, String profile1GUID, String profile1GUIDParameterName, String profile2GUID, String profile2GUIDParameterName, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.unlinkElementFromElement(userId, false, externalSourceGUID, externalSourceName, profile1GUID, profile1GUIDParameterName, "Person", profile2GUID, profile2GUIDParameterName, "ac406bf8-e53e-49f1-9088-2af28bbbd285", "Person", false, false, this.supportedZones, "4a316abe-bccd-4d11-ad5a-4bfb4079b80b", "Peer", effectiveTime, methodName);
    }

    public void linkTeamHierarchy(String userId, String externalSourceGUID, String externalSourceName, String superTeamGUID, String superTeamGUIDParameterName, String subTeamGUID, String subTeamGUIDParameterName, boolean delegationEscalationAuthority, Date effectiveFrom, Date effectiveTo, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        ActorProfileBuilder builder = new ActorProfileBuilder(this.repositoryHelper, this.serviceName, this.serverName);
        InstanceProperties relationshipProperties = builder.getTeamStructureProperties(delegationEscalationAuthority, methodName);
        this.linkElementToElement(userId, externalSourceGUID, externalSourceName, superTeamGUID, superTeamGUIDParameterName, "Team", subTeamGUID, subTeamGUIDParameterName, "Team", false, false, this.supportedZones, "5ebc4fb2-b62a-4269-8f18-e9237a2229ca", "TeamStructure", this.setUpEffectiveDates(relationshipProperties, effectiveFrom, effectiveTo), methodName);
    }

    public void unlinkTeamHierarchy(String userId, String externalSourceGUID, String externalSourceName, String superTeamGUID, String superTeamGUIDParameterName, String subTeamGUID, String subTeamGUIDParameterName, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.unlinkElementFromElement(userId, false, externalSourceGUID, externalSourceName, superTeamGUID, superTeamGUIDParameterName, "Team", subTeamGUID, subTeamGUIDParameterName, "36db26d5-aba2-439b-bc15-d62d373c5db6", "Team", false, false, this.supportedZones, "5ebc4fb2-b62a-4269-8f18-e9237a2229ca", "TeamStructure", effectiveTime, methodName);
    }

    public void removeActorProfile(String userId, String externalSourceGUID, String externalSourceName, String profileGUID, String profileGUIDParameterName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.deleteBeanInRepository(userId, externalSourceGUID, externalSourceName, profileGUID, profileGUIDParameterName, "5a2f38dc-d69d-4a6f-ad26-ac86f118fa35", "ActorProfile", null, null, false, false, new Date(), methodName);
    }

    public List<B> findActorProfiles(String userId, String searchString, String searchStringParameterName, int startFrom, int pageSize, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        List<EntityDetail> entities = this.findEntities(userId, searchString, searchStringParameterName, "5a2f38dc-d69d-4a6f-ad26-ac86f118fa35", "ActorProfile", null, null, null, startFrom, pageSize, effectiveTime, methodName);
        if (entities != null) {
            ArrayList<B> beans = new ArrayList<B>();
            for (EntityDetail entity : entities) {
                B bean;
                if (entity == null || (bean = this.getFullProfileBean(userId, entity, effectiveTime, methodName)) == null) continue;
                beans.add(bean);
            }
            if (!beans.isEmpty()) {
                return beans;
            }
        }
        return null;
    }

    public List<B> getActorProfilesByName(String userId, String name, String nameParameterName, int startFrom, int pageSize, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        ArrayList<String> specificMatchPropertyNames = new ArrayList<String>();
        specificMatchPropertyNames.add("qualifiedName");
        specificMatchPropertyNames.add("name");
        List<EntityDetail> entities = this.getEntitiesByValue(userId, name, nameParameterName, "5a2f38dc-d69d-4a6f-ad26-ac86f118fa35", "ActorProfile", specificMatchPropertyNames, true, null, null, false, false, this.supportedZones, null, startFrom, pageSize, effectiveTime, methodName);
        if (entities != null) {
            ArrayList<B> beans = new ArrayList<B>();
            for (EntityDetail entity : entities) {
                B bean;
                if (entity == null || (bean = this.getFullProfileBean(userId, entity, effectiveTime, methodName)) == null) continue;
                beans.add(bean);
            }
            if (!beans.isEmpty()) {
                return beans;
            }
        }
        return null;
    }

    public List<B> getPersonalProfilesByName(String userId, String name, String nameParameterName, int startFrom, int pageSize, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        ArrayList<String> specificMatchPropertyNames = new ArrayList<String>();
        specificMatchPropertyNames.add("qualifiedName");
        specificMatchPropertyNames.add("name");
        List<EntityDetail> entities = this.getEntitiesByValue(userId, name, nameParameterName, "ac406bf8-e53e-49f1-9088-2af28bbbd285", "Person", specificMatchPropertyNames, true, null, null, false, false, this.supportedZones, null, startFrom, pageSize, effectiveTime, methodName);
        if (entities != null) {
            ArrayList<B> beans = new ArrayList<B>();
            for (EntityDetail entity : entities) {
                B bean;
                if (entity == null || (bean = this.getPersonalProfileBean(userId, entity, effectiveTime, methodName)) == null) continue;
                beans.add(bean);
            }
            if (!beans.isEmpty()) {
                return beans;
            }
        }
        return null;
    }

    public B getActorProfileByGUID(String userId, String guid, String guidParameterName, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        EntityDetail entity = this.getEntityFromRepository(userId, guid, guidParameterName, "ActorProfile", null, null, false, false, this.supportedZones, effectiveTime, methodName);
        if (entity != null) {
            return this.getFullProfileBean(userId, entity, effectiveTime, methodName);
        }
        return null;
    }

    public B getPersonalProfileByGUID(String userId, String guid, String guidParameterName, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        EntityDetail entity = this.getEntityFromRepository(userId, guid, guidParameterName, "Person", null, null, false, false, this.supportedZones, effectiveTime, methodName);
        if (entity != null) {
            return this.getPersonalProfileBean(userId, entity, effectiveTime, methodName);
        }
        return null;
    }

    public B getActorProfileForUser(String userId, String profileUserId, String profileUserIdParameterName, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        EntityDetail entity;
        String userGUIDParameterName = "userIdentity.getGUID";
        EntityDetail userIdentity = this.getEntityByUniqueQualifiedName(userId, "fbe95779-1f3c-4ac6-aa9d-24963ff16282", "UserIdentity", profileUserId, profileUserIdParameterName, false, false, effectiveTime, methodName);
        if (userIdentity != null && (entity = this.getAttachedEntity(userId, userIdentity.getGUID(), "userIdentity.getGUID", "UserIdentity", "01664609-e777-4079-b543-6baffe910ff1", "ProfileIdentity", "ActorProfile", false, false, this.supportedZones, effectiveTime, methodName)) != null) {
            return this.getFullProfileBean(userId, entity, effectiveTime, methodName);
        }
        return null;
    }

    public B getPersonalProfileForUser(String userId, String profileUserId, String profileUserIdParameterName, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        EntityDetail profileEntity;
        String userGUIDParameterName = "userIdentity.getGUID";
        EntityDetail userIdentity = this.getEntityByUniqueQualifiedName(userId, "fbe95779-1f3c-4ac6-aa9d-24963ff16282", "UserIdentity", profileUserId, profileUserIdParameterName, false, false, effectiveTime, methodName);
        if (userIdentity != null && (profileEntity = this.getAttachedEntity(userId, userIdentity.getGUID(), "userIdentity.getGUID", "UserIdentity", "01664609-e777-4079-b543-6baffe910ff1", "ProfileIdentity", "Person", false, false, this.supportedZones, effectiveTime, methodName)) != null) {
            return this.getPersonalProfileBean(userId, profileEntity, effectiveTime, methodName);
        }
        return null;
    }

    public B getActorProfileByUniqueName(String userId, String qualifiedName, String qualifiedNameParameterName, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        EntityDetail entity = this.getEntityByUniqueQualifiedName(userId, "5a2f38dc-d69d-4a6f-ad26-ac86f118fa35", "ActorProfile", qualifiedName, qualifiedNameParameterName, false, false, effectiveTime, methodName);
        if (entity != null) {
            return this.getFullProfileBean(userId, entity, effectiveTime, methodName);
        }
        return null;
    }

    public B getPersonalProfileByUniqueName(String userId, String qualifiedName, String qualifiedNameParameterName, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        EntityDetail entity = this.getEntityByUniqueQualifiedName(userId, "ac406bf8-e53e-49f1-9088-2af28bbbd285", "Person", qualifiedName, qualifiedNameParameterName, false, false, effectiveTime, methodName);
        if (entity != null) {
            return this.getPersonalProfileBean(userId, entity, effectiveTime, methodName);
        }
        return null;
    }

    private B getFullProfileBean(String userId, EntityDetail primaryEntity, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        List<EntityDetail> contactDetails;
        String profileGUIDParameterName = "profileGUID";
        ArrayList<EntityDetail> supplementaryEntities = new ArrayList<EntityDetail>();
        List<EntityDetail> userIdentities = this.getAttachedEntities(userId, primaryEntity.getGUID(), "profileGUID", "ActorProfile", "01664609-e777-4079-b543-6baffe910ff1", "ProfileIdentity", "UserIdentity", null, null, false, false, this.supportedZones, 0, 0, effectiveTime, methodName);
        if (userIdentities != null) {
            supplementaryEntities.addAll(userIdentities);
        }
        if ((contactDetails = this.getAttachedEntities(userId, primaryEntity.getGUID(), "profileGUID", "ActorProfile", "6cb9af43-184e-4dfa-854a-1572bcf0fe75", "ContactThrough", "ContactDetails", null, null, false, false, this.supportedZones, 0, 0, effectiveTime, methodName)) != null) {
            supplementaryEntities.addAll(contactDetails);
        }
        return this.converter.getNewComplexBean(this.beanClass, primaryEntity, supplementaryEntities, null, methodName);
    }

    private B getPersonalProfileBean(String userId, EntityDetail primaryEntity, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String profileGUIDParameterName = "profileGUID";
        String userIdentityGUIDParameterName = "userIdentityGUID";
        String contributionRecordGUIDParameterName = "contributionRecordGUID";
        String contactDetailsGUIDParameterName = "contactDetailsGUID";
        ArrayList<EntityDetail> supplementaryEntities = new ArrayList<EntityDetail>();
        List<Relationship> relationships = this.getAllAttachmentLinks(userId, primaryEntity.getGUID(), "profileGUID", "Person", false, effectiveTime, methodName);
        if (relationships != null) {
            for (Relationship relationship : relationships) {
                EntityDetail entity;
                EntityProxy entityProxy;
                if (relationship == null || relationship.getType() == null) continue;
                String relationshipTypeName = relationship.getType().getTypeDefName();
                if (this.repositoryHelper.isTypeOf(this.serviceName, relationshipTypeName, "ProfileIdentity")) {
                    entityProxy = this.repositoryHelper.getOtherEnd(this.serviceName, primaryEntity.getGUID(), relationship);
                    entity = this.getEntityFromRepository(userId, entityProxy.getGUID(), "userIdentityGUID", "UserIdentity", null, null, false, false, this.supportedZones, effectiveTime, methodName);
                    if (entity == null) continue;
                    supplementaryEntities.add(entity);
                    continue;
                }
                if (this.repositoryHelper.isTypeOf(this.serviceName, relationshipTypeName, "ContactThrough")) {
                    entityProxy = this.repositoryHelper.getOtherEnd(this.serviceName, primaryEntity.getGUID(), relationship);
                    entity = this.getEntityFromRepository(userId, entityProxy.getGUID(), "contactDetailsGUID", "ContactDetails", null, null, false, false, this.supportedZones, effectiveTime, methodName);
                    if (entity == null) continue;
                    supplementaryEntities.add(entity);
                    continue;
                }
                if (!this.repositoryHelper.isTypeOf(this.serviceName, relationshipTypeName, "PersonalContribution") || (entity = this.getEntityFromRepository(userId, (entityProxy = this.repositoryHelper.getOtherEnd(this.serviceName, primaryEntity.getGUID(), relationship)).getGUID(), "contributionRecordGUID", "ContributionRecord", null, null, false, false, this.supportedZones, effectiveTime, methodName)) == null) continue;
                supplementaryEntities.add(entity);
            }
        }
        return this.converter.getNewComplexBean(this.beanClass, primaryEntity, supplementaryEntities, relationships, methodName);
    }
}

