/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericConverter;
import org.odpi.openmetadata.commonservices.generichandlers.ReferenceableHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.metadatasecurity.server.OpenMetadataServerSecurityVerifier;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityProxy;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class CertificationHandler<B>
extends ReferenceableHandler<B> {
    public CertificationHandler(OpenMetadataAPIGenericConverter<B> converter, Class<B> beanClass, String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper, String localServerUserId, OpenMetadataServerSecurityVerifier securityVerifier, List<String> supportedZones, List<String> defaultZones, List<String> publishZones, AuditLog auditLog) {
        super(converter, beanClass, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
    }

    public int countCertifications(String userId, String connectedEntityGUID, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return super.countAttachments(userId, connectedEntityGUID, "Referenceable", "390559eb-6a0c-4dd7-bc95-b9074caffa7f", "Certification", effectiveTime, methodName);
    }

    public List<B> getCertifications(String userId, String parentGUID, String parentGUIDParameterName, int startFrom, int pageSize, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getCertifications(userId, parentGUID, parentGUIDParameterName, this.supportedZones, startFrom, pageSize, effectiveTime, methodName);
    }

    public List<B> getCertifications(String userId, String parentGUID, String parentGUIDParameterName, List<String> serviceSupportedZones, int startFrom, int pageSize, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        List<Relationship> relationships = this.getAttachmentLinks(userId, parentGUID, parentGUIDParameterName, "Referenceable", "390559eb-6a0c-4dd7-bc95-b9074caffa7f", "Certification", "CertificationType", startFrom, pageSize, effectiveTime, methodName);
        if (relationships != null) {
            ArrayList results = new ArrayList();
            for (Relationship relationship : relationships) {
                EntityProxy entityProxy;
                if (relationship == null || (entityProxy = relationship.getEntityTwoProxy()) == null) continue;
                String entityParameterName = "entityProxyTwo.getGUID";
                EntityDetail entity = this.getEntityFromRepository(userId, entityProxy.getGUID(), "entityProxyTwo.getGUID", "CertificationType", null, null, false, false, serviceSupportedZones, effectiveTime, methodName);
                results.add(this.converter.getNewBean(this.beanClass, entity, relationship, methodName));
            }
            if (results.isEmpty()) {
                return null;
            }
            return results;
        }
        return null;
    }
}

