/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.util.Date;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericConverter;
import org.odpi.openmetadata.commonservices.generichandlers.SchemaAttributeBuilder;
import org.odpi.openmetadata.commonservices.generichandlers.SchemaAttributeHandler;
import org.odpi.openmetadata.commonservices.generichandlers.SchemaElementHandler;
import org.odpi.openmetadata.commonservices.generichandlers.SchemaTypeBuilder;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryErrorHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.metadatasecurity.server.OpenMetadataServerSecurityVerifier;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class DisplayDataContainerHandler<SCHEMA_ATTRIBUTE, SCHEMA_TYPE>
extends SchemaElementHandler<SCHEMA_ATTRIBUTE> {
    private String serviceName;
    private String serverName;
    private OMRSRepositoryHelper repositoryHelper;
    private InvalidParameterHandler invalidParameterHandler;
    private SchemaAttributeHandler<SCHEMA_ATTRIBUTE, SCHEMA_TYPE> dataContainerHandler;
    protected RepositoryErrorHandler errorHandler;

    public DisplayDataContainerHandler(OpenMetadataAPIGenericConverter<SCHEMA_ATTRIBUTE> dataContainerConverter, Class<SCHEMA_ATTRIBUTE> dataContainerClass, OpenMetadataAPIGenericConverter<SCHEMA_TYPE> schemaTypeConverter, Class<SCHEMA_TYPE> schemaTypeClass, String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper, String localServerUserId, OpenMetadataServerSecurityVerifier securityVerifier, List<String> supportedZones, List<String> defaultZones, List<String> publishZones, AuditLog auditLog) {
        super(dataContainerConverter, dataContainerClass, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
        this.serviceName = serviceName;
        this.serverName = serverName;
        this.invalidParameterHandler = invalidParameterHandler;
        this.repositoryHelper = repositoryHelper;
        this.dataContainerHandler = new SchemaAttributeHandler<SCHEMA_ATTRIBUTE, SCHEMA_TYPE>(dataContainerConverter, dataContainerClass, schemaTypeConverter, schemaTypeClass, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
        this.errorHandler = new RepositoryErrorHandler(repositoryHelper, serviceName, serverName, auditLog);
    }

    public String createDataContainer(String userId, String externalSourceGUID, String externalSourceName, String parentGUID, String qualifiedName, String displayName, String description, boolean isDeprecated, int elementPosition, int minCardinality, int maxCardinality, Map<String, String> additionalProperties, String typeName, Map<String, Object> extendedProperties, Map<String, String> vendorProperties, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String parentElementGUIDParameterName = "parentGUID";
        String schemaTypeGUIDParameterName = "schemaTypeGUID";
        String qualifiedNameParameterName = "qualifiedName";
        String databaseSchemaTypeGUID = this.dataContainerHandler.getAssetSchemaTypeGUID(userId, externalSourceGUID, externalSourceName, parentGUID, "parentGUID", "DeployedDatabaseSchema", "f20f5f45-1afb-41c1-9a09-34d8812626a4", "RelationalDBSchemaType", methodName);
        if (databaseSchemaTypeGUID != null) {
            String attributeTypeName = "DisplayDataContainer";
            String attributeTypeId = "f2a4ff99-1954-48c0-8081-92d1a4dfd910";
            if (typeName != null) {
                attributeTypeName = typeName;
                attributeTypeId = this.invalidParameterHandler.validateTypeName(typeName, "DisplayDataContainer", this.serviceName, methodName, this.repositoryHelper);
            }
            SchemaAttributeBuilder schemaAttributeBuilder = new SchemaAttributeBuilder(qualifiedName, displayName, description, elementPosition, minCardinality, maxCardinality, isDeprecated, null, true, false, 0, 0, 0, 0, false, null, null, additionalProperties, attributeTypeId, attributeTypeName, extendedProperties, this.repositoryHelper, this.serviceName, this.serverName);
            schemaAttributeBuilder.setAnchors(userId, parentGUID, methodName);
            SchemaTypeBuilder schemaTypeBuilder = new SchemaTypeBuilder(qualifiedName + ":containerType", "2f5796f5-3fac-4501-9d0d-207aa8620d16", "DisplayDataSchemaType", this.repositoryHelper, this.serviceName, this.serverName);
            schemaAttributeBuilder.setSchemaType(userId, schemaTypeBuilder, methodName);
            String dataContainerGUID = this.dataContainerHandler.createNestedSchemaAttribute(userId, externalSourceGUID, externalSourceName, databaseSchemaTypeGUID, "schemaTypeGUID", "RelationalDBSchemaType", "86b176a2-015c-44a6-8106-54d5d69ba661", "AttributeForSchema", qualifiedName, "qualifiedName", schemaAttributeBuilder, methodName);
            if (dataContainerGUID != null) {
                this.dataContainerHandler.setVendorProperties(userId, dataContainerGUID, vendorProperties, methodName);
            }
            return dataContainerGUID;
        }
        return null;
    }

    public String createDataContainerFromTemplate(String userId, String externalSourceGUID, String externalSourceName, String templateGUID, String parentGUID, String qualifiedName, String displayName, String description, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String guidParameterName = "parentGUID";
        String parentElementGUIDParameterName = "parentGUID";
        String templateParameterName = "templateGUID";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateGUID(parentGUID, "parentGUID", methodName);
        this.invalidParameterHandler.validateGUID(templateGUID, "templateGUID", methodName);
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        String databaseSchemaTypeGUID = this.dataContainerHandler.getAssetSchemaTypeGUID(userId, externalSourceGUID, externalSourceName, parentGUID, "parentGUID", "DeployedDatabaseSchema", "f20f5f45-1afb-41c1-9a09-34d8812626a4", "RelationalDBSchemaType", methodName);
        if (databaseSchemaTypeGUID != null) {
            SchemaAttributeBuilder builder = new SchemaAttributeBuilder(qualifiedName, displayName, description, this.repositoryHelper, this.serviceName, this.serverName);
            builder.setAnchors(userId, parentGUID, methodName);
            String dataContainerGUID = this.dataContainerHandler.createBeanFromTemplate(userId, externalSourceGUID, externalSourceName, templateGUID, "templateGUID", "f2a4ff99-1954-48c0-8081-92d1a4dfd910", "DisplayDataContainer", qualifiedName, "qualifiedName", builder, methodName);
            if (dataContainerGUID != null) {
                String databaseSchemaTypeGUIDParameterName = "databaseSchemaTypeGUID";
                String dataContainerGUIDParameterName = "dataContainerGUID";
                this.dataContainerHandler.linkElementToElement(userId, externalSourceGUID, externalSourceName, databaseSchemaTypeGUID, "databaseSchemaTypeGUID", "RelationalDBSchemaType", dataContainerGUID, "dataContainerGUID", "DisplayDataContainer", false, false, this.supportedZones, "86b176a2-015c-44a6-8106-54d5d69ba661", "AttributeForSchema", null, methodName);
                return dataContainerGUID;
            }
        }
        return null;
    }

    public void updateDataContainer(String userId, String externalSourceGUID, String externalSourceName, String dataContainerGUID, String qualifiedName, String displayName, String description, boolean isDeprecated, Map<String, String> additionalProperties, String typeName, Map<String, Object> extendedProperties, Map<String, String> vendorProperties, boolean isMergeUpdate, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String elementGUIDParameterName = "dataContainerGUID";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(dataContainerGUID, "dataContainerGUID", methodName);
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        String attributeTypeName = "DisplayDataContainer";
        String attributeTypeId = "f2a4ff99-1954-48c0-8081-92d1a4dfd910";
        if (typeName != null) {
            attributeTypeName = typeName;
            attributeTypeId = this.invalidParameterHandler.validateTypeName(typeName, "DisplayDataContainer", this.serviceName, methodName, this.repositoryHelper);
        }
        InstanceProperties properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, "qualifiedName", qualifiedName, methodName);
        if (displayName != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "displayName", displayName, methodName);
        }
        if (description != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "description", description, methodName);
        }
        properties = this.repositoryHelper.addBooleanPropertyToInstance(this.serviceName, properties, "isDeprecated", isDeprecated, methodName);
        if (additionalProperties != null) {
            properties = this.repositoryHelper.addStringMapPropertyToInstance(this.serviceName, properties, "additionalProperties", additionalProperties, methodName);
        }
        if (extendedProperties != null) {
            try {
                properties = this.repositoryHelper.addPropertyMapToInstance(this.serviceName, null, extendedProperties, methodName);
            }
            catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException error) {
                String propertyName = "extendedProperties";
                this.errorHandler.handleUnsupportedProperty((Exception)((Object)error), methodName, "extendedProperties");
            }
        }
        this.dataContainerHandler.updateBeanInRepository(userId, externalSourceGUID, externalSourceName, dataContainerGUID, "dataContainerGUID", attributeTypeId, attributeTypeName, false, false, this.supportedZones, properties, isMergeUpdate, new Date(), methodName);
        this.dataContainerHandler.setVendorProperties(userId, dataContainerGUID, vendorProperties, methodName);
    }

    public void removeDataContainer(String userId, String externalSourceGUID, String externalSourceName, String dataContainerGUID, String dataContainerGUIDParameterName, String qualifiedName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        this.dataContainerHandler.deleteBeanInRepository(userId, externalSourceGUID, externalSourceName, dataContainerGUID, dataContainerGUIDParameterName, "f2a4ff99-1954-48c0-8081-92d1a4dfd910", "DisplayDataContainer", "qualifiedName", qualifiedName, false, false, new Date(), methodName);
    }

    public List<SCHEMA_ATTRIBUTE> findDataContainers(String userId, String searchString, int startFrom, int pageSize, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String searchStringParameterName = "searchString";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateSearchString(searchString, "searchString", methodName);
        return this.dataContainerHandler.findSchemaAttributes(userId, searchString, "searchString", "f2a4ff99-1954-48c0-8081-92d1a4dfd910", "DisplayDataContainer", null, null, startFrom, pageSize, methodName);
    }

    public List<SCHEMA_ATTRIBUTE> getContainersForParent(String userId, String parentGUID, int startFrom, int pageSize, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String parentElementGUIDParameterName = "parentGUID";
        String databaseSchemaTypeGUID = this.dataContainerHandler.getAssetSchemaTypeGUID(userId, null, null, parentGUID, "parentGUID", "DeployedDatabaseSchema", "f20f5f45-1afb-41c1-9a09-34d8812626a4", "RelationalDBSchemaType", methodName);
        if (databaseSchemaTypeGUID != null) {
            String databaseSchemaTypeGUIDParameterName = "databaseSchemaTypeGUID";
            return this.dataContainerHandler.getSchemaAttributesForComplexSchemaType(userId, databaseSchemaTypeGUID, "databaseSchemaTypeGUID", null, "CalculatedValue", startFrom, pageSize, methodName);
        }
        return null;
    }

    public List<SCHEMA_ATTRIBUTE> getDataContainersByName(String userId, String name, int startFrom, int pageSize, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.dataContainerHandler.getSchemaAttributesByName(userId, "f2a4ff99-1954-48c0-8081-92d1a4dfd910", "DisplayDataContainer", name, null, null, startFrom, pageSize, methodName);
    }

    public SCHEMA_ATTRIBUTE getDataContainerByGUID(String userId, String guid, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String guidParameterName = "guid";
        return this.dataContainerHandler.getSchemaAttribute(userId, guid, "guid", "DisplayDataContainer", null, null, methodName);
    }
}

