/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.generichandlers.GovernanceZoneBuilder;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericConverter;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.metadatasecurity.server.OpenMetadataServerSecurityVerifier;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class GovernanceZoneHandler<B>
extends OpenMetadataAPIGenericHandler<B> {
    public GovernanceZoneHandler(OpenMetadataAPIGenericConverter<B> converter, Class<B> beanClass, String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper, String localServerUserId, OpenMetadataServerSecurityVerifier securityVerifier, List<String> supportedZones, List<String> defaultZones, List<String> publishZones, AuditLog auditLog) {
        super(converter, beanClass, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
    }

    public String createGovernanceZone(String userId, String externalSourceGUID, String externalSourceName, String qualifiedName, String displayName, String description, String criteria, String scope, int domainIdentifier, Map<String, String> additionalProperties, String suppliedTypeName, Map<String, Object> extendedProperties, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String typeName = "GovernanceZone";
        if (suppliedTypeName != null) {
            typeName = suppliedTypeName;
        }
        String typeGUID = this.invalidParameterHandler.validateTypeName(typeName, "GovernanceZone", this.serviceName, methodName, this.repositoryHelper);
        GovernanceZoneBuilder builder = new GovernanceZoneBuilder(qualifiedName, displayName, description, criteria, scope, domainIdentifier, additionalProperties, typeGUID, typeName, extendedProperties, this.repositoryHelper, this.serviceName, this.serverName);
        return this.createBeanInRepository(userId, externalSourceGUID, externalSourceName, typeGUID, typeName, qualifiedName, "qualifiedName", builder, methodName);
    }

    public void updateGovernanceZone(String userId, String externalSourceGUID, String externalSourceName, String zoneGUID, String zoneGUIDParameterName, String qualifiedName, String displayName, String description, String criteria, String scope, int domainIdentifier, Map<String, String> additionalProperties, String suppliedTypeName, Map<String, Object> extendedProperties, boolean isMergeUpdate, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String typeName = "GovernanceZone";
        if (suppliedTypeName != null) {
            typeName = suppliedTypeName;
        }
        String typeGUID = this.invalidParameterHandler.validateTypeName(typeName, "GovernanceZone", this.serviceName, methodName, this.repositoryHelper);
        GovernanceZoneBuilder builder = new GovernanceZoneBuilder(qualifiedName, displayName, description, criteria, scope, domainIdentifier, additionalProperties, typeGUID, typeName, extendedProperties, this.repositoryHelper, this.serviceName, this.serverName);
        this.updateBeanInRepository(userId, externalSourceGUID, externalSourceName, zoneGUID, zoneGUIDParameterName, "290a192b-42a7-449a-935a-269ca62cfdac", "GovernanceZone", false, false, this.supportedZones, builder.getInstanceProperties(methodName), isMergeUpdate, new Date(), methodName);
    }

    public B getGovernanceZone(String userId, String qualifiedName, String qualifiedNameParameter, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.getBeanByUniqueName(userId, qualifiedName, qualifiedNameParameter, "qualifiedName", "290a192b-42a7-449a-935a-269ca62cfdac", "GovernanceZone", false, false, this.supportedZones, new Date(), methodName);
    }

    public Relationship getGovernanceZoneParentGUID(String userId, String zoneGUID, String zoneGUIDParameter, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.getUniqueAttachmentLink(userId, zoneGUID, zoneGUIDParameter, "GovernanceZone", "ee6cf469-cb4d-4c3b-a4c7-e2da1236d139", "ZoneHierarchy", null, "GovernanceZone", 1, false, new Date(), methodName);
    }

    public List<Relationship> getGovernanceZoneChildrenGUIDs(String userId, String zoneGUID, String zoneGUIDParameter, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.getAttachmentLinks(userId, zoneGUID, zoneGUIDParameter, "GovernanceZone", "ee6cf469-cb4d-4c3b-a4c7-e2da1236d139", "ZoneHierarchy", null, "GovernanceZone", 2, false, 0, 0, new Date(), methodName);
    }

    public List<B> getGovernanceZones(String userId, int startFrom, int pageSize, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.getBeansByType(userId, "290a192b-42a7-449a-935a-269ca62cfdac", "GovernanceZone", null, false, false, this.supportedZones, startFrom, pageSize, new Date(), methodName);
    }

    public List<B> getGovernanceZonesByDomain(String userId, int domainIdentifier, int startFrom, int pageSize, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        if (domainIdentifier == 0) {
            return this.getGovernanceZones(userId, startFrom, pageSize, methodName);
        }
        List<EntityDetail> entities = this.getEntitiesByType(userId, "290a192b-42a7-449a-935a-269ca62cfdac", "GovernanceZone", null, false, false, this.supportedZones, startFrom, pageSize, new Date(), methodName);
        ArrayList results = new ArrayList();
        if (entities != null) {
            for (EntityDetail entity : entities) {
                if (entity == null || entity.getProperties() == null || this.repositoryHelper.getIntProperty(this.serviceName, "domainIdentifier", entity.getProperties(), methodName) != domainIdentifier) continue;
                Object bean = this.converter.getNewBean(this.beanClass, entity, methodName);
                results.add(bean);
            }
        }
        if (results.isEmpty()) {
            return null;
        }
        return results;
    }
}

