/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericConverter;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ConnectorType;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.DataItemSortOrder;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementClassification;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementHeader;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementOrigin;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementStatus;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementType;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.EmbeddedConnection;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Endpoint;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.OwnerType;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.VirtualConnection;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityProxy;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EnumPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceAuditHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProvenanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefLink;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public abstract class OCFConverter<B>
extends OpenMetadataAPIGenericConverter<B> {
    protected OCFConverter(OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(repositoryHelper, serviceName, serverName);
    }

    protected void setUpElementHeader(ElementHeader elementHeader, EntityDetail entity, String expectedTypeName, String methodName) throws PropertyServerException {
        if (entity != null) {
            super.validateInstanceType(expectedTypeName, elementHeader.getClass().getName(), (InstanceAuditHeader)entity, methodName);
            elementHeader.setGUID(entity.getGUID());
            elementHeader.setType(this.getElementType((InstanceHeader)entity));
            elementHeader.setURL(entity.getInstanceURL());
            elementHeader.setClassifications(this.getEntityClassifications(entity));
        } else {
            super.handleMissingMetadataInstance(elementHeader.getClass().getName(), TypeDefCategory.ENTITY_DEF, methodName);
        }
    }

    protected void setUpElementHeader(ElementHeader elementHeader, InstanceHeader instanceHeader, List<Classification> classifications, String methodName) throws PropertyServerException {
        if (instanceHeader != null) {
            elementHeader.setGUID(instanceHeader.getGUID());
            elementHeader.setType(this.getElementType(instanceHeader));
            elementHeader.setURL(instanceHeader.getInstanceURL());
            elementHeader.setClassifications(this.getEntityClassifications(classifications));
        } else {
            super.handleMissingMetadataInstance(elementHeader.getClass().getName(), TypeDefCategory.ENTITY_DEF, methodName);
        }
    }

    private List<ElementClassification> getEntityClassifications(EntityDetail entity) {
        if (entity != null) {
            return this.getEntityClassifications(entity.getClassifications());
        }
        return null;
    }

    protected List<ElementClassification> getEntityClassifications(List<Classification> entityClassifications) {
        ArrayList<ElementClassification> beanClassifications = null;
        if (entityClassifications != null) {
            beanClassifications = new ArrayList<ElementClassification>();
            for (Classification entityClassification : entityClassifications) {
                if (entityClassification == null) continue;
                ElementClassification beanClassification = new ElementClassification();
                beanClassification.setElementSourceServer(this.serverName);
                beanClassification.setElementOrigin(this.getElementOrigin(entityClassification.getInstanceProvenanceType()));
                beanClassification.setElementMetadataCollectionId(entityClassification.getMetadataCollectionId());
                beanClassification.setElementMetadataCollectionName(entityClassification.getMetadataCollectionName());
                beanClassification.setElementLicense(entityClassification.getInstanceLicense());
                beanClassification.setElementCreatedBy(entityClassification.getCreatedBy());
                beanClassification.setElementUpdatedBy(entityClassification.getUpdatedBy());
                beanClassification.setElementMaintainedBy(entityClassification.getMaintainedBy());
                beanClassification.setElementCreateTime(entityClassification.getCreateTime());
                beanClassification.setElementUpdateTime(entityClassification.getUpdateTime());
                beanClassification.setElementVersion(entityClassification.getVersion());
                beanClassification.setStatus(this.getElementStatus(entityClassification.getStatus()));
                beanClassification.setClassificationName(entityClassification.getName());
                beanClassification.setClassificationProperties(this.repositoryHelper.getInstancePropertiesAsMap(entityClassification.getProperties()));
                beanClassifications.add(beanClassification);
            }
        }
        return beanClassifications;
    }

    protected ElementClassification getClassification(String classificationName, List<ElementClassification> beanClassifications) {
        if (classificationName != null && beanClassifications != null) {
            for (ElementClassification classification : beanClassifications) {
                if (classification == null || !classification.getClassificationName().equals(classificationName)) continue;
                return classification;
            }
        }
        return null;
    }

    protected List<ElementClassification> removeClassification(String classificationName, List<ElementClassification> beanClassifications) {
        if (classificationName != null && beanClassifications != null) {
            ArrayList<ElementClassification> results = new ArrayList<ElementClassification>();
            for (ElementClassification classification : beanClassifications) {
                if (classification == null || classification.getClassificationName().equals(classificationName)) continue;
                results.add(classification);
            }
            if (!results.isEmpty()) {
                return results;
            }
        }
        return null;
    }

    private ElementType getElementType(InstanceHeader instanceHeader) {
        ElementType elementType = new ElementType();
        InstanceType instanceType = instanceHeader.getType();
        if (instanceType != null) {
            elementType.setElementSourceServer(this.serverName);
            elementType.setElementOrigin(this.getElementOrigin(instanceHeader.getInstanceProvenanceType()));
            elementType.setElementMetadataCollectionId(instanceHeader.getMetadataCollectionId());
            elementType.setElementMetadataCollectionName(instanceHeader.getMetadataCollectionName());
            elementType.setElementLicense(instanceHeader.getInstanceLicense());
            elementType.setElementCreatedBy(instanceHeader.getCreatedBy());
            elementType.setElementUpdatedBy(instanceHeader.getUpdatedBy());
            elementType.setElementMaintainedBy(instanceHeader.getMaintainedBy());
            elementType.setElementCreateTime(instanceHeader.getCreateTime());
            elementType.setElementUpdateTime(instanceHeader.getUpdateTime());
            elementType.setElementVersion(instanceHeader.getVersion());
            elementType.setStatus(this.getElementStatus(instanceHeader.getStatus()));
            elementType.setElementTypeId(instanceType.getTypeDefGUID());
            elementType.setElementTypeName(instanceType.getTypeDefName());
            elementType.setElementTypeVersion(instanceType.getTypeDefVersion());
            elementType.setElementTypeDescription(instanceType.getTypeDefDescription());
            List typeDefSuperTypes = instanceType.getTypeDefSuperTypes();
            if (typeDefSuperTypes != null && !typeDefSuperTypes.isEmpty()) {
                ArrayList<String> superTypes = new ArrayList<String>();
                for (TypeDefLink typeDefLink : typeDefSuperTypes) {
                    if (typeDefLink == null) continue;
                    superTypes.add(typeDefLink.getName());
                }
                if (!superTypes.isEmpty()) {
                    elementType.setElementSuperTypeNames(superTypes);
                }
            }
        }
        return elementType;
    }

    private ElementOrigin getElementOrigin(InstanceProvenanceType instanceProvenanceType) {
        if (instanceProvenanceType != null) {
            switch (instanceProvenanceType) {
                case DEREGISTERED_REPOSITORY: {
                    return ElementOrigin.DEREGISTERED_REPOSITORY;
                }
                case EXTERNAL_SOURCE: {
                    return ElementOrigin.EXTERNAL_SOURCE;
                }
                case EXPORT_ARCHIVE: {
                    return ElementOrigin.EXPORT_ARCHIVE;
                }
                case LOCAL_COHORT: {
                    return ElementOrigin.LOCAL_COHORT;
                }
                case CONTENT_PACK: {
                    return ElementOrigin.CONTENT_PACK;
                }
                case CONFIGURATION: {
                    return ElementOrigin.CONFIGURATION;
                }
                case UNKNOWN: {
                    return ElementOrigin.UNKNOWN;
                }
            }
        }
        return ElementOrigin.UNKNOWN;
    }

    private ElementStatus getElementStatus(InstanceStatus instanceStatus) {
        if (instanceStatus != null) {
            switch (instanceStatus) {
                case UNKNOWN: {
                    return ElementStatus.UNKNOWN;
                }
                case DRAFT: {
                    return ElementStatus.DRAFT;
                }
                case PREPARED: {
                    return ElementStatus.PREPARED;
                }
                case PROPOSED: {
                    return ElementStatus.PROPOSED;
                }
                case APPROVED: {
                    return ElementStatus.APPROVED;
                }
                case REJECTED: {
                    return ElementStatus.REJECTED;
                }
                case APPROVED_CONCEPT: {
                    return ElementStatus.APPROVED_CONCEPT;
                }
                case UNDER_DEVELOPMENT: {
                    return ElementStatus.UNDER_DEVELOPMENT;
                }
                case DEVELOPMENT_COMPLETE: {
                    return ElementStatus.DEVELOPMENT_COMPLETE;
                }
                case APPROVED_FOR_DEPLOYMENT: {
                    return ElementStatus.APPROVED_FOR_DEPLOYMENT;
                }
                case STANDBY: {
                    return ElementStatus.STANDBY;
                }
                case ACTIVE: {
                    return ElementStatus.ACTIVE;
                }
                case FAILED: {
                    return ElementStatus.FAILED;
                }
                case DISABLED: {
                    return ElementStatus.DISABLED;
                }
                case COMPLETE: {
                    return ElementStatus.COMPLETE;
                }
                case DEPRECATED: {
                    return ElementStatus.DEPRECATED;
                }
                case OTHER: {
                    return ElementStatus.OTHER;
                }
            }
        }
        return ElementStatus.UNKNOWN;
    }

    protected DataItemSortOrder removeSortOrder(InstanceProperties instanceProperties) {
        String methodName = "removeSortOrder";
        if (instanceProperties != null) {
            int ordinal = this.repositoryHelper.removeEnumPropertyOrdinal(this.serviceName, "sortOrder", instanceProperties, "removeSortOrder");
            for (DataItemSortOrder dataItemSortOrder : DataItemSortOrder.values()) {
                if (dataItemSortOrder.getOpenTypeOrdinal() != ordinal) continue;
                return dataItemSortOrder;
            }
        }
        return DataItemSortOrder.UNKNOWN;
    }

    protected OwnerType removeOwnerTypeFromProperties(InstanceProperties properties) {
        OwnerType ownerType = this.getOwnerTypeFromProperties(properties);
        if (properties != null) {
            Map instancePropertiesMap = properties.getInstanceProperties();
            if (instancePropertiesMap != null) {
                instancePropertiesMap.remove("ownerType");
            }
            properties.setInstanceProperties(instancePropertiesMap);
        }
        return ownerType;
    }

    protected OwnerType getOwnerTypeFromProperties(InstanceProperties properties) {
        InstancePropertyValue instancePropertyValue;
        Map instancePropertiesMap;
        OwnerType ownerType = OwnerType.OTHER;
        if (properties != null && (instancePropertiesMap = properties.getInstanceProperties()) != null && (instancePropertyValue = (InstancePropertyValue)instancePropertiesMap.get("ownerType")) instanceof EnumPropertyValue) {
            EnumPropertyValue enumPropertyValue = (EnumPropertyValue)instancePropertyValue;
            switch (enumPropertyValue.getOrdinal()) {
                case 0: {
                    ownerType = OwnerType.USER_ID;
                    break;
                }
                case 1: {
                    ownerType = OwnerType.PROFILE_ID;
                    break;
                }
                case 99: {
                    ownerType = OwnerType.OTHER;
                }
            }
        }
        return ownerType;
    }

    protected Connection getEmbeddedConnection(Class<B> beanClass, EntityDetail primaryEntity, List<EntityDetail> supplementaryEntities, List<Relationship> relationships, String methodName) throws PropertyServerException {
        if (primaryEntity != null && primaryEntity.getType() != null) {
            String actualTypeName = primaryEntity.getType().getTypeDefName();
            if (this.repositoryHelper.isTypeOf(this.serviceName, actualTypeName, "VirtualConnection")) {
                return this.getNewVirtualConnection(beanClass, primaryEntity, supplementaryEntities, relationships, methodName);
            }
            if (this.repositoryHelper.isTypeOf(this.serviceName, actualTypeName, "Connection")) {
                return this.getNewConnection(beanClass, primaryEntity, supplementaryEntities, relationships, methodName);
            }
            super.validateInstanceType("Connection", beanClass.getName(), (InstanceAuditHeader)primaryEntity, methodName);
        } else {
            this.handleMissingMetadataInstance(beanClass.getName(), TypeDefCategory.ENTITY_DEF, methodName);
        }
        return null;
    }

    private Connection getNewVirtualConnection(Class<B> beanClass, EntityDetail primaryEntity, List<EntityDetail> supplementaryEntities, List<Relationship> relationships, String methodName) throws PropertyServerException {
        try {
            VirtualConnection connection = new VirtualConnection();
            this.fillInConnectionProperties((Connection)connection, primaryEntity, relationships, methodName);
            if (relationships == null || relationships.isEmpty()) {
                this.handleMissingMetadataInstance(beanClass.getName(), TypeDefCategory.RELATIONSHIP_DEF, methodName);
                return null;
            }
            HashMap<String, EntityDetail> entityDetailMap = new HashMap<String, EntityDetail>();
            if (supplementaryEntities != null) {
                for (EntityDetail entity : supplementaryEntities) {
                    if (entity == null || entity.getGUID() == null) continue;
                    entityDetailMap.put(entity.getGUID(), entity);
                }
            }
            if (entityDetailMap.isEmpty()) {
                this.handleMissingMetadataInstance(beanClass.getName(), TypeDefCategory.ENTITY_DEF, methodName);
                return null;
            }
            ArrayList<EmbeddedConnection> embeddedConnections = new ArrayList<EmbeddedConnection>();
            for (Relationship relationship : relationships) {
                EntityDetail embeddedConnectionEntity;
                EntityProxy embeddedConnectionProxy;
                EntityProxy parentConnectionProxy;
                if (relationship == null || relationship.getType() == null || !this.repositoryHelper.isTypeOf(this.serviceName, relationship.getType().getTypeDefName(), "EmbeddedConnection") || (parentConnectionProxy = relationship.getEntityOneProxy()) == null || !primaryEntity.getGUID().equals(parentConnectionProxy.getGUID()) || (embeddedConnectionProxy = relationship.getEntityTwoProxy()) == null || embeddedConnectionProxy.getGUID() == null || (embeddedConnectionEntity = (EntityDetail)entityDetailMap.get(embeddedConnectionProxy.getGUID())) == null) continue;
                InstanceProperties properties = relationship.getProperties();
                EmbeddedConnection embeddedConnection = new EmbeddedConnection();
                embeddedConnection.setPosition(this.getPosition(properties));
                embeddedConnection.setDisplayName(this.getDisplayName(properties));
                embeddedConnection.setArguments(this.getArguments(properties));
                embeddedConnection.setEmbeddedConnection(this.getEmbeddedConnection(beanClass, primaryEntity, supplementaryEntities, relationships, methodName));
                embeddedConnections.add(embeddedConnection);
            }
            if (!embeddedConnections.isEmpty()) {
                connection.setEmbeddedConnections(embeddedConnections);
            }
            return connection;
        }
        catch (ClassCastException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }

    private Connection getNewConnection(Class<B> beanClass, EntityDetail primaryEntity, List<EntityDetail> supplementaryEntities, List<Relationship> relationships, String methodName) throws PropertyServerException {
        try {
            Connection connection = new Connection();
            this.fillInConnectionProperties(connection, primaryEntity, relationships, methodName);
            if (supplementaryEntities != null) {
                for (EntityDetail entity : supplementaryEntities) {
                    if (entity == null || entity.getType() == null) continue;
                    String actualTypeName = entity.getType().getTypeDefName();
                    if (this.repositoryHelper.isTypeOf(this.serviceName, actualTypeName, "Endpoint")) {
                        Endpoint endpoint = this.getEndpoint(entity, methodName);
                        connection.setEndpoint(endpoint);
                        continue;
                    }
                    if (!this.repositoryHelper.isTypeOf(this.serviceName, actualTypeName, "ConnectorType")) continue;
                    ConnectorType connectorType = this.getConnectorType(entity, methodName);
                    connection.setConnectorType(connectorType);
                }
            }
            return connection;
        }
        catch (ClassCastException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }

    private void fillInConnectionProperties(Connection connection, EntityDetail entity, List<Relationship> relationships, String methodName) throws PropertyServerException {
        this.setUpElementHeader((ElementHeader)connection, entity, "Connection", methodName);
        InstanceProperties instanceProperties = new InstanceProperties(entity.getProperties());
        connection.setQualifiedName(this.removeQualifiedName(instanceProperties));
        connection.setAdditionalProperties(this.removeAdditionalProperties(instanceProperties));
        connection.setDisplayName(this.removeDisplayName(instanceProperties));
        connection.setDescription(this.removeDescription(instanceProperties));
        connection.setSecuredProperties(this.removeSecuredProperties(instanceProperties));
        connection.setConfigurationProperties(this.removeConfigurationProperties(instanceProperties));
        connection.setUserId(this.removeUserId(instanceProperties));
        connection.setClearPassword(this.removeClearPassword(instanceProperties));
        connection.setEncryptedPassword(this.removeEncryptedPassword(instanceProperties));
        connection.setExtendedProperties(this.getRemainingExtendedProperties(instanceProperties));
        if (relationships != null) {
            for (Relationship relationship : relationships) {
                if (relationship == null || !this.repositoryHelper.isTypeOf(this.serviceName, relationship.getType().getTypeDefName(), "ConnectionToAsset")) continue;
                connection.setAssetSummary(this.getAssetSummary(instanceProperties));
            }
        }
    }

    private Endpoint getEndpoint(EntityDetail entity, String methodName) throws PropertyServerException {
        Endpoint endpoint = new Endpoint();
        this.setUpElementHeader((ElementHeader)endpoint, entity, "Endpoint", methodName);
        InstanceProperties instanceProperties = new InstanceProperties(entity.getProperties());
        endpoint.setQualifiedName(this.removeQualifiedName(instanceProperties));
        endpoint.setAdditionalProperties(this.removeAdditionalProperties(instanceProperties));
        endpoint.setDisplayName(this.removeName(instanceProperties));
        endpoint.setDescription(this.removeDescription(instanceProperties));
        endpoint.setAddress(this.removeNetworkAddress(instanceProperties));
        endpoint.setProtocol(this.removeProtocol(instanceProperties));
        endpoint.setEncryptionMethod(this.removeEncryptionMethod(instanceProperties));
        endpoint.setExtendedProperties(this.getRemainingExtendedProperties(instanceProperties));
        return endpoint;
    }

    private ConnectorType getConnectorType(EntityDetail entity, String methodName) throws PropertyServerException {
        ConnectorType connectorType = new ConnectorType();
        this.setUpElementHeader((ElementHeader)connectorType, entity, "ConnectorType", methodName);
        InstanceProperties instanceProperties = new InstanceProperties(entity.getProperties());
        connectorType.setQualifiedName(this.removeQualifiedName(instanceProperties));
        connectorType.setAdditionalProperties(this.removeAdditionalProperties(instanceProperties));
        connectorType.setDisplayName(this.removeName(instanceProperties));
        connectorType.setDescription(this.removeDescription(instanceProperties));
        connectorType.setSupportedAssetTypeName(this.removeSupportedAssetTypeName(instanceProperties));
        connectorType.setExpectedDataFormat(this.removeExpectedDataFormat(instanceProperties));
        connectorType.setConnectorProviderClassName(this.removeConnectorProviderClassName(instanceProperties));
        connectorType.setConnectorFrameworkName(this.removeConnectorFrameworkName(instanceProperties));
        connectorType.setConnectorInterfaceLanguage(this.removeConnectorInterfaceLanguage(instanceProperties));
        connectorType.setConnectorInterfaces(this.removeConnectorInterfaces(instanceProperties));
        connectorType.setTargetTechnologySource(this.removeTargetTechnologySource(instanceProperties));
        connectorType.setTargetTechnologyName(this.removeTargetTechnologyName(instanceProperties));
        connectorType.setTargetTechnologyInterfaces(this.removeTargetTechnologyInterfaces(instanceProperties));
        connectorType.setTargetTechnologyVersions(this.removeTargetTechnologyVersions(instanceProperties));
        connectorType.setRecognizedAdditionalProperties(this.removeRecognizedAdditionalProperties(instanceProperties));
        connectorType.setRecognizedSecuredProperties(this.removeRecognizedSecuredProperties(instanceProperties));
        connectorType.setRecognizedConfigurationProperties(this.removeRecognizedConfigurationProperties(instanceProperties));
        connectorType.setExtendedProperties(this.getRemainingExtendedProperties(instanceProperties));
        return connectorType;
    }
}

