/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.commonservices.generichandlers.OCFConverter;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.discovery.properties.Annotation;
import org.odpi.openmetadata.frameworks.discovery.properties.AnnotationStatus;
import org.odpi.openmetadata.frameworks.discovery.properties.ClassificationAnnotation;
import org.odpi.openmetadata.frameworks.discovery.properties.DataClassAnnotation;
import org.odpi.openmetadata.frameworks.discovery.properties.DataProfileAnnotation;
import org.odpi.openmetadata.frameworks.discovery.properties.DataProfileLogAnnotation;
import org.odpi.openmetadata.frameworks.discovery.properties.DataSourceMeasurementAnnotation;
import org.odpi.openmetadata.frameworks.discovery.properties.DataSourcePhysicalStatusAnnotation;
import org.odpi.openmetadata.frameworks.discovery.properties.DivergentAttachmentClassificationAnnotation;
import org.odpi.openmetadata.frameworks.discovery.properties.DivergentAttachmentRelationshipAnnotation;
import org.odpi.openmetadata.frameworks.discovery.properties.DivergentAttachmentValueAnnotation;
import org.odpi.openmetadata.frameworks.discovery.properties.DivergentClassificationAnnotation;
import org.odpi.openmetadata.frameworks.discovery.properties.DivergentRelationshipAnnotation;
import org.odpi.openmetadata.frameworks.discovery.properties.DivergentValueAnnotation;
import org.odpi.openmetadata.frameworks.discovery.properties.ElementClassification;
import org.odpi.openmetadata.frameworks.discovery.properties.ElementHeader;
import org.odpi.openmetadata.frameworks.discovery.properties.ElementOrigin;
import org.odpi.openmetadata.frameworks.discovery.properties.ElementStatus;
import org.odpi.openmetadata.frameworks.discovery.properties.ElementType;
import org.odpi.openmetadata.frameworks.discovery.properties.QualityAnnotation;
import org.odpi.openmetadata.frameworks.discovery.properties.RelationshipAdviceAnnotation;
import org.odpi.openmetadata.frameworks.discovery.properties.RequestForActionAnnotation;
import org.odpi.openmetadata.frameworks.discovery.properties.SchemaAnalysisAnnotation;
import org.odpi.openmetadata.frameworks.discovery.properties.SemanticAnnotation;
import org.odpi.openmetadata.frameworks.discovery.properties.SuspectDuplicateAnnotation;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityProxy;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EnumPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceAuditHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProvenanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefLink;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public abstract class ODFConverter<B>
extends OCFConverter<B> {
    public ODFConverter(OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(repositoryHelper, serviceName, serverName);
    }

    protected ElementHeader getMetadataElementHeader(Class<B> beanClass, EntityDetail entity, String methodName) throws PropertyServerException {
        if (entity != null) {
            ElementHeader elementHeader = new ElementHeader();
            elementHeader.setElementSourceServer(this.serverName);
            elementHeader.setElementOrigin(this.getElementOrigin(entity.getInstanceProvenanceType()));
            elementHeader.setElementMetadataCollectionId(entity.getMetadataCollectionId());
            elementHeader.setElementMetadataCollectionName(entity.getMetadataCollectionName());
            elementHeader.setElementLicense(entity.getInstanceLicense());
            elementHeader.setElementCreatedBy(entity.getCreatedBy());
            elementHeader.setElementUpdatedBy(entity.getUpdatedBy());
            elementHeader.setElementMaintainedBy(entity.getMaintainedBy());
            elementHeader.setElementCreateTime(entity.getCreateTime());
            elementHeader.setElementUpdateTime(entity.getUpdateTime());
            elementHeader.setElementVersion(entity.getVersion());
            elementHeader.setStatus(this.getElementStatus(entity.getStatus()));
            elementHeader.setGUID(entity.getGUID());
            elementHeader.setClassifications(this.getEntityClassifications(entity));
            elementHeader.setType(this.getElementType((InstanceHeader)entity));
            elementHeader.setMappingProperties(entity.getMappingProperties());
            elementHeader.setGUID(entity.getGUID());
            elementHeader.setType(this.getElementType((InstanceHeader)entity));
            elementHeader.setURL(entity.getInstanceURL());
            elementHeader.setClassifications(this.getEntityClassifications(entity));
            return elementHeader;
        }
        super.handleMissingMetadataInstance(beanClass.getName(), TypeDefCategory.ENTITY_DEF, methodName);
        return null;
    }

    private List<ElementClassification> getEntityClassifications(EntityDetail entity) {
        List entityClassifications;
        ArrayList<ElementClassification> beanClassifications = null;
        if (entity != null && (entityClassifications = entity.getClassifications()) != null) {
            beanClassifications = new ArrayList<ElementClassification>();
            for (Classification entityClassification : entityClassifications) {
                if (entityClassification == null) continue;
                ElementClassification beanClassification = new ElementClassification();
                beanClassification.setElementSourceServer(this.serverName);
                beanClassification.setElementOrigin(this.getElementOrigin(entityClassification.getInstanceProvenanceType()));
                beanClassification.setElementMetadataCollectionId(entityClassification.getMetadataCollectionId());
                beanClassification.setElementMetadataCollectionName(entityClassification.getMetadataCollectionName());
                beanClassification.setElementLicense(entityClassification.getInstanceLicense());
                beanClassification.setElementCreatedBy(entityClassification.getCreatedBy());
                beanClassification.setElementUpdatedBy(entityClassification.getUpdatedBy());
                beanClassification.setElementMaintainedBy(entityClassification.getMaintainedBy());
                beanClassification.setElementCreateTime(entityClassification.getCreateTime());
                beanClassification.setElementUpdateTime(entityClassification.getUpdateTime());
                beanClassification.setElementVersion(entityClassification.getVersion());
                beanClassification.setStatus(this.getElementStatus(entityClassification.getStatus()));
                beanClassification.setClassificationName(entityClassification.getName());
                beanClassification.setClassificationProperties(this.repositoryHelper.getInstancePropertiesAsMap(entityClassification.getProperties()));
                beanClassifications.add(beanClassification);
            }
        }
        return beanClassifications;
    }

    private ElementType getElementType(InstanceHeader instanceHeader) {
        ElementType elementType = new ElementType();
        InstanceType instanceType = instanceHeader.getType();
        if (instanceType != null) {
            elementType.setElementTypeId(instanceType.getTypeDefGUID());
            elementType.setElementTypeName(instanceType.getTypeDefName());
            elementType.setElementTypeVersion(instanceType.getTypeDefVersion());
            elementType.setElementTypeDescription(instanceType.getTypeDefDescription());
            List typeDefSuperTypes = instanceType.getTypeDefSuperTypes();
            if (typeDefSuperTypes != null && !typeDefSuperTypes.isEmpty()) {
                ArrayList<String> superTypes = new ArrayList<String>();
                for (TypeDefLink typeDefLink : typeDefSuperTypes) {
                    if (typeDefLink == null) continue;
                    superTypes.add(typeDefLink.getName());
                }
                if (!superTypes.isEmpty()) {
                    elementType.setElementSuperTypeNames(superTypes);
                }
            }
        }
        return elementType;
    }

    private ElementOrigin getElementOrigin(InstanceProvenanceType instanceProvenanceType) {
        if (instanceProvenanceType != null) {
            switch (instanceProvenanceType) {
                case DEREGISTERED_REPOSITORY: {
                    return ElementOrigin.DEREGISTERED_REPOSITORY;
                }
                case EXTERNAL_SOURCE: {
                    return ElementOrigin.EXTERNAL_SOURCE;
                }
                case EXPORT_ARCHIVE: {
                    return ElementOrigin.EXPORT_ARCHIVE;
                }
                case LOCAL_COHORT: {
                    return ElementOrigin.LOCAL_COHORT;
                }
                case CONTENT_PACK: {
                    return ElementOrigin.CONTENT_PACK;
                }
                case CONFIGURATION: {
                    return ElementOrigin.CONFIGURATION;
                }
                case UNKNOWN: {
                    return ElementOrigin.UNKNOWN;
                }
            }
        }
        return ElementOrigin.UNKNOWN;
    }

    private ElementStatus getElementStatus(InstanceStatus instanceStatus) {
        if (instanceStatus != null) {
            switch (instanceStatus) {
                case UNKNOWN: {
                    return ElementStatus.UNKNOWN;
                }
                case DRAFT: {
                    return ElementStatus.DRAFT;
                }
                case PREPARED: {
                    return ElementStatus.PREPARED;
                }
                case PROPOSED: {
                    return ElementStatus.PROPOSED;
                }
                case APPROVED: {
                    return ElementStatus.APPROVED;
                }
                case REJECTED: {
                    return ElementStatus.REJECTED;
                }
                case APPROVED_CONCEPT: {
                    return ElementStatus.APPROVED_CONCEPT;
                }
                case UNDER_DEVELOPMENT: {
                    return ElementStatus.UNDER_DEVELOPMENT;
                }
                case DEVELOPMENT_COMPLETE: {
                    return ElementStatus.DEVELOPMENT_COMPLETE;
                }
                case APPROVED_FOR_DEPLOYMENT: {
                    return ElementStatus.APPROVED_FOR_DEPLOYMENT;
                }
                case STANDBY: {
                    return ElementStatus.STANDBY;
                }
                case ACTIVE: {
                    return ElementStatus.ACTIVE;
                }
                case FAILED: {
                    return ElementStatus.FAILED;
                }
                case DISABLED: {
                    return ElementStatus.DISABLED;
                }
                case COMPLETE: {
                    return ElementStatus.COMPLETE;
                }
                case DEPRECATED: {
                    return ElementStatus.DEPRECATED;
                }
                case OTHER: {
                    return ElementStatus.OTHER;
                }
            }
        }
        return ElementStatus.UNKNOWN;
    }

    protected Annotation getAnnotationBean(Class<B> beanClass, EntityDetail primaryEntity, List<EntityDetail> supplementaryEntities, List<Relationship> relationships, String methodName) throws PropertyServerException {
        if (primaryEntity != null && primaryEntity.getType() != null) {
            String actualTypeName = primaryEntity.getType().getTypeDefName();
            if (this.repositoryHelper.isTypeOf(this.serviceName, actualTypeName, "ClassificationAnnotation")) {
                return this.getNewClassificationAnnotation(beanClass, primaryEntity, supplementaryEntities, relationships, methodName);
            }
            if (this.repositoryHelper.isTypeOf(this.serviceName, actualTypeName, "DataClassAnnotation")) {
                return this.getNewDataClassAnnotation(beanClass, primaryEntity, supplementaryEntities, relationships, methodName);
            }
            if (this.repositoryHelper.isTypeOf(this.serviceName, actualTypeName, "DataProfileAnnotation")) {
                return this.getNewDataProfileAnnotation(beanClass, primaryEntity, supplementaryEntities, relationships, methodName);
            }
            if (this.repositoryHelper.isTypeOf(this.serviceName, actualTypeName, "DataProfileLogAnnotation")) {
                return this.getNewDataProfileLogAnnotation(beanClass, primaryEntity, supplementaryEntities, relationships, methodName);
            }
            if (this.repositoryHelper.isTypeOf(this.serviceName, actualTypeName, "DataSourcePhysicalStatusAnnotation")) {
                return this.getNewDataSourcePhysicalStatusAnnotation(beanClass, primaryEntity, supplementaryEntities, relationships, methodName);
            }
            if (this.repositoryHelper.isTypeOf(this.serviceName, actualTypeName, "DataSourceMeasurementAnnotation")) {
                return this.getNewDataSourceMeasurementAnnotation(beanClass, primaryEntity, supplementaryEntities, relationships, methodName);
            }
            if (this.repositoryHelper.isTypeOf(this.serviceName, actualTypeName, "DivergentValueAnnotation")) {
                return this.getNewDivergentValueAnnotation(beanClass, primaryEntity, supplementaryEntities, relationships, methodName);
            }
            if (this.repositoryHelper.isTypeOf(this.serviceName, actualTypeName, "DivergentClassificationAnnotation")) {
                return this.getNewDivergentClassificationAnnotation(beanClass, primaryEntity, supplementaryEntities, relationships, methodName);
            }
            if (this.repositoryHelper.isTypeOf(this.serviceName, actualTypeName, "DivergentRelationshipAnnotation")) {
                return this.getNewDivergentRelationshipAnnotation(beanClass, primaryEntity, supplementaryEntities, relationships, methodName);
            }
            if (this.repositoryHelper.isTypeOf(this.serviceName, actualTypeName, "DivergentAttachmentAnnotation")) {
                return this.getNewDivergentAttachmentValueAnnotation(beanClass, primaryEntity, supplementaryEntities, relationships, methodName);
            }
            if (this.repositoryHelper.isTypeOf(this.serviceName, actualTypeName, "DivergentAttachmentClassificationAnnotation")) {
                return this.getNewDivergentAttachmentClassificationAnnotation(beanClass, primaryEntity, supplementaryEntities, relationships, methodName);
            }
            if (this.repositoryHelper.isTypeOf(this.serviceName, actualTypeName, "DivergentAttachmentRelationshipAnnotation")) {
                return this.getNewDivergentAttachmentRelationshipAnnotation(beanClass, primaryEntity, supplementaryEntities, relationships, methodName);
            }
            if (this.repositoryHelper.isTypeOf(this.serviceName, actualTypeName, "QualityAnnotation")) {
                return this.getNewQualityAnnotation(beanClass, primaryEntity, supplementaryEntities, relationships, methodName);
            }
            if (this.repositoryHelper.isTypeOf(this.serviceName, actualTypeName, "RelationshipAdviceAnnotation")) {
                return this.getNewRelationshipAdviceAnnotation(beanClass, primaryEntity, supplementaryEntities, relationships, methodName);
            }
            if (this.repositoryHelper.isTypeOf(this.serviceName, actualTypeName, "RequestForActionAnnotation")) {
                return this.getNewRequestForActionAnnotation(beanClass, primaryEntity, supplementaryEntities, relationships, methodName);
            }
            if (this.repositoryHelper.isTypeOf(this.serviceName, actualTypeName, "SchemaAnalysisAnnotation")) {
                return this.getNewSchemaAnalysisAnnotation(beanClass, primaryEntity, supplementaryEntities, relationships, methodName);
            }
            if (this.repositoryHelper.isTypeOf(this.serviceName, actualTypeName, "SemanticAnnotation")) {
                return this.getNewSemanticAnnotation(beanClass, primaryEntity, supplementaryEntities, relationships, methodName);
            }
            if (this.repositoryHelper.isTypeOf(this.serviceName, actualTypeName, "SuspectDuplicateAnnotation")) {
                return this.getNewSuspectDuplicateAnnotation(beanClass, primaryEntity, supplementaryEntities, relationships, methodName);
            }
            if (this.repositoryHelper.isTypeOf(this.serviceName, actualTypeName, "Annotation")) {
                return this.getNewAnnotation(beanClass, primaryEntity, supplementaryEntities, relationships, methodName);
            }
            super.validateInstanceType("Annotation", beanClass.getName(), (InstanceAuditHeader)primaryEntity, methodName);
        } else {
            this.handleMissingMetadataInstance(beanClass.getName(), TypeDefCategory.ENTITY_DEF, methodName);
        }
        return null;
    }

    private Annotation getNewClassificationAnnotation(Class<B> beanClass, EntityDetail primaryEntity, List<EntityDetail> supplementaryEntities, List<Relationship> relationships, String methodName) throws PropertyServerException {
        try {
            ClassificationAnnotation annotation = new ClassificationAnnotation();
            InstanceProperties remainingProperties = this.fillInCommonAnnotationProperties(beanClass, (Annotation)annotation, primaryEntity, supplementaryEntities, relationships, methodName);
            annotation.setCandidateClassifications(this.removeCandidateClassifications(remainingProperties));
            annotation.setExtendedProperties(this.getRemainingExtendedProperties(remainingProperties));
            return annotation;
        }
        catch (ClassCastException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }

    private Annotation getNewDataClassAnnotation(Class<B> beanClass, EntityDetail primaryEntity, List<EntityDetail> supplementaryEntities, List<Relationship> relationships, String methodName) throws PropertyServerException {
        try {
            DataClassAnnotation annotation = new DataClassAnnotation();
            InstanceProperties remainingProperties = this.fillInCommonAnnotationProperties(beanClass, (Annotation)annotation, primaryEntity, supplementaryEntities, relationships, methodName);
            annotation.setCandidateDataClassGUIDs(this.removeCandidateDataClassGUIDs(remainingProperties));
            annotation.setExtendedProperties(this.getRemainingExtendedProperties(remainingProperties));
            return annotation;
        }
        catch (ClassCastException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }

    private Annotation getNewDataProfileAnnotation(Class<B> beanClass, EntityDetail primaryEntity, List<EntityDetail> supplementaryEntities, List<Relationship> relationships, String methodName) throws PropertyServerException {
        try {
            DataProfileAnnotation annotation = new DataProfileAnnotation();
            InstanceProperties remainingProperties = this.fillInCommonAnnotationProperties(beanClass, (Annotation)annotation, primaryEntity, supplementaryEntities, relationships, methodName);
            annotation.setLength(this.removeLength(remainingProperties));
            annotation.setInferredDataType(this.removeInferredDataType(remainingProperties));
            annotation.setInferredFormat(this.removeInferredFormat(remainingProperties));
            annotation.setInferredLength(this.removeInferredLength(remainingProperties));
            annotation.setInferredPrecision(this.removeInferredPrecision(remainingProperties));
            annotation.setInferredScale(this.removeInferredScale(remainingProperties));
            annotation.setProfileProperties(this.removeProfileProperties(remainingProperties));
            annotation.setProfileFlags(this.removeProfileFlags(remainingProperties));
            annotation.setProfileCounts(this.removeProfileCounts(remainingProperties));
            annotation.setValueList(this.removeValueList(remainingProperties));
            annotation.setValueCount(this.removeValueCount(remainingProperties));
            annotation.setValueRangeFrom(this.removeValueRangeFrom(remainingProperties));
            annotation.setValueRangeTo(this.removeValueRangeTo(remainingProperties));
            annotation.setAverageValue(this.removeAverageValue(remainingProperties));
            annotation.setExtendedProperties(this.getRemainingExtendedProperties(remainingProperties));
            return annotation;
        }
        catch (ClassCastException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }

    private Annotation getNewDataProfileLogAnnotation(Class<B> beanClass, EntityDetail primaryEntity, List<EntityDetail> supplementaryEntities, List<Relationship> relationships, String methodName) throws PropertyServerException {
        try {
            DataProfileLogAnnotation annotation = new DataProfileLogAnnotation();
            InstanceProperties remainingProperties = this.fillInCommonAnnotationProperties(beanClass, (Annotation)annotation, primaryEntity, supplementaryEntities, relationships, methodName);
            ArrayList<String> dataProfileLogNames = new ArrayList<String>();
            if (relationships != null) {
                for (Relationship relationship : relationships) {
                    EntityProxy endTwo;
                    if (relationship == null || !this.repositoryHelper.isTypeOf(this.serviceName, relationship.getType().getTypeDefName(), "DataProfileLogFile") || (endTwo = relationship.getEntityTwoProxy()) == null) continue;
                    String name = this.repositoryHelper.getStringProperty(this.serviceName, "qualifiedName", endTwo.getUniqueProperties(), methodName);
                    if (name == null) {
                        name = endTwo.getGUID();
                    }
                    dataProfileLogNames.add(name);
                }
            }
            annotation.setDataProfileLogFileNames(dataProfileLogNames);
            annotation.setExtendedProperties(this.getRemainingExtendedProperties(remainingProperties));
            return annotation;
        }
        catch (ClassCastException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }

    private Annotation getNewDataSourceMeasurementAnnotation(Class<B> beanClass, EntityDetail primaryEntity, List<EntityDetail> supplementaryEntities, List<Relationship> relationships, String methodName) throws PropertyServerException {
        try {
            DataSourceMeasurementAnnotation annotation = new DataSourceMeasurementAnnotation();
            InstanceProperties remainingProperties = this.fillInCommonAnnotationProperties(beanClass, (Annotation)annotation, primaryEntity, supplementaryEntities, relationships, methodName);
            annotation.setDataSourceProperties(this.removeDataSourceProperties(remainingProperties));
            annotation.setExtendedProperties(this.getRemainingExtendedProperties(remainingProperties));
            return annotation;
        }
        catch (ClassCastException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }

    private Annotation getNewDataSourcePhysicalStatusAnnotation(Class<B> beanClass, EntityDetail primaryEntity, List<EntityDetail> supplementaryEntities, List<Relationship> relationships, String methodName) throws PropertyServerException {
        try {
            DataSourcePhysicalStatusAnnotation annotation = new DataSourcePhysicalStatusAnnotation();
            InstanceProperties remainingProperties = this.fillInCommonAnnotationProperties(beanClass, (Annotation)annotation, primaryEntity, supplementaryEntities, relationships, methodName);
            annotation.setDataSourceProperties(this.removeDataSourceProperties(remainingProperties));
            annotation.setCreateTime(this.removeSourceCreateTime(remainingProperties));
            annotation.setModifiedTime(this.removeSourceUpdateTime(remainingProperties));
            annotation.setSize(this.removeSize(remainingProperties));
            annotation.setEncoding(this.removeEncoding(remainingProperties));
            annotation.setExtendedProperties(this.getRemainingExtendedProperties(remainingProperties));
            return annotation;
        }
        catch (ClassCastException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }

    private Annotation getNewDivergentValueAnnotation(Class<B> beanClass, EntityDetail primaryEntity, List<EntityDetail> supplementaryEntities, List<Relationship> relationships, String methodName) throws PropertyServerException {
        try {
            DivergentValueAnnotation annotation = new DivergentValueAnnotation();
            InstanceProperties remainingProperties = this.fillInCommonAnnotationProperties(beanClass, (Annotation)annotation, primaryEntity, supplementaryEntities, relationships, methodName);
            annotation.setDuplicateAnchorGUID(this.removeDuplicateAnchorGUID(remainingProperties));
            annotation.setDivergentPropertyNames(this.removeDivergentPropertyNames(remainingProperties));
            annotation.setExtendedProperties(this.getRemainingExtendedProperties(remainingProperties));
            return annotation;
        }
        catch (ClassCastException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }

    private Annotation getNewDivergentClassificationAnnotation(Class<B> beanClass, EntityDetail primaryEntity, List<EntityDetail> supplementaryEntities, List<Relationship> relationships, String methodName) throws PropertyServerException {
        try {
            DivergentClassificationAnnotation annotation = new DivergentClassificationAnnotation();
            InstanceProperties remainingProperties = this.fillInCommonAnnotationProperties(beanClass, (Annotation)annotation, primaryEntity, supplementaryEntities, relationships, methodName);
            annotation.setDuplicateAnchorGUID(this.removeDuplicateAnchorGUID(remainingProperties));
            annotation.setDivergentClassificationName(this.removeDivergentClassificationName(remainingProperties));
            annotation.setDivergentClassificationPropertyNames(this.removeDivergentClassificationPropertyNames(remainingProperties));
            annotation.setExtendedProperties(this.getRemainingExtendedProperties(remainingProperties));
            return annotation;
        }
        catch (ClassCastException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }

    private Annotation getNewDivergentRelationshipAnnotation(Class<B> beanClass, EntityDetail primaryEntity, List<EntityDetail> supplementaryEntities, List<Relationship> relationships, String methodName) throws PropertyServerException {
        try {
            DivergentRelationshipAnnotation annotation = new DivergentRelationshipAnnotation();
            InstanceProperties remainingProperties = this.fillInCommonAnnotationProperties(beanClass, (Annotation)annotation, primaryEntity, supplementaryEntities, relationships, methodName);
            annotation.setDuplicateAnchorGUID(this.removeDuplicateAnchorGUID(remainingProperties));
            annotation.setDivergentRelationshipGUID(this.removeDivergentRelationshipGUID(remainingProperties));
            annotation.setDivergentRelationshipPropertyNames(this.removeDivergentRelationshipPropertyNames(remainingProperties));
            annotation.setExtendedProperties(this.getRemainingExtendedProperties(remainingProperties));
            return annotation;
        }
        catch (ClassCastException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }

    private Annotation getNewDivergentAttachmentValueAnnotation(Class<B> beanClass, EntityDetail primaryEntity, List<EntityDetail> supplementaryEntities, List<Relationship> relationships, String methodName) throws PropertyServerException {
        try {
            DivergentAttachmentValueAnnotation annotation = new DivergentAttachmentValueAnnotation();
            InstanceProperties remainingProperties = this.fillInCommonAnnotationProperties(beanClass, (Annotation)annotation, primaryEntity, supplementaryEntities, relationships, methodName);
            annotation.setAttachmentGUID(this.removeAttachmentGUID(remainingProperties));
            annotation.setDuplicateAttachmentGUID(this.removeDuplicateAttachmentGUID(remainingProperties));
            annotation.setDuplicateAnchorGUID(this.removeDuplicateAnchorGUID(remainingProperties));
            annotation.setDivergentPropertyNames(this.removeDivergentPropertyNames(remainingProperties));
            annotation.setExtendedProperties(this.getRemainingExtendedProperties(remainingProperties));
            return annotation;
        }
        catch (ClassCastException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }

    private Annotation getNewDivergentAttachmentClassificationAnnotation(Class<B> beanClass, EntityDetail primaryEntity, List<EntityDetail> supplementaryEntities, List<Relationship> relationships, String methodName) throws PropertyServerException {
        try {
            DivergentAttachmentClassificationAnnotation annotation = new DivergentAttachmentClassificationAnnotation();
            InstanceProperties remainingProperties = this.fillInCommonAnnotationProperties(beanClass, (Annotation)annotation, primaryEntity, supplementaryEntities, relationships, methodName);
            annotation.setAttachmentGUID(this.removeAttachmentGUID(remainingProperties));
            annotation.setDuplicateAttachmentGUID(this.removeDuplicateAttachmentGUID(remainingProperties));
            annotation.setDuplicateAnchorGUID(this.removeDuplicateAnchorGUID(remainingProperties));
            annotation.setDivergentClassificationName(this.removeDivergentClassificationName(remainingProperties));
            annotation.setDivergentClassificationPropertyNames(this.removeDivergentClassificationPropertyNames(remainingProperties));
            annotation.setExtendedProperties(this.getRemainingExtendedProperties(remainingProperties));
            return annotation;
        }
        catch (ClassCastException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }

    private Annotation getNewDivergentAttachmentRelationshipAnnotation(Class<B> beanClass, EntityDetail primaryEntity, List<EntityDetail> supplementaryEntities, List<Relationship> relationships, String methodName) throws PropertyServerException {
        try {
            DivergentAttachmentRelationshipAnnotation annotation = new DivergentAttachmentRelationshipAnnotation();
            InstanceProperties remainingProperties = this.fillInCommonAnnotationProperties(beanClass, (Annotation)annotation, primaryEntity, supplementaryEntities, relationships, methodName);
            annotation.setAttachmentGUID(this.removeAttachmentGUID(remainingProperties));
            annotation.setDuplicateAttachmentGUID(this.removeDuplicateAttachmentGUID(remainingProperties));
            annotation.setDuplicateAnchorGUID(this.removeDuplicateAnchorGUID(remainingProperties));
            annotation.setDivergentRelationshipGUID(this.removeDivergentRelationshipGUID(remainingProperties));
            annotation.setDivergentRelationshipPropertyNames(this.removeDivergentClassificationPropertyNames(remainingProperties));
            annotation.setExtendedProperties(this.getRemainingExtendedProperties(remainingProperties));
            return annotation;
        }
        catch (ClassCastException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }

    private Annotation getNewQualityAnnotation(Class<B> beanClass, EntityDetail primaryEntity, List<EntityDetail> supplementaryEntities, List<Relationship> relationships, String methodName) throws PropertyServerException {
        try {
            QualityAnnotation annotation = new QualityAnnotation();
            InstanceProperties remainingProperties = this.fillInCommonAnnotationProperties(beanClass, (Annotation)annotation, primaryEntity, supplementaryEntities, relationships, methodName);
            annotation.setQualityDimension(this.removeQualityDimension(remainingProperties));
            annotation.setQualityScore(this.removeQualityScore(remainingProperties));
            annotation.setExtendedProperties(this.getRemainingExtendedProperties(remainingProperties));
            return annotation;
        }
        catch (ClassCastException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }

    private Annotation getNewRelationshipAdviceAnnotation(Class<B> beanClass, EntityDetail primaryEntity, List<EntityDetail> supplementaryEntities, List<Relationship> relationships, String methodName) throws PropertyServerException {
        try {
            RelationshipAdviceAnnotation annotation = new RelationshipAdviceAnnotation();
            InstanceProperties remainingProperties = this.fillInCommonAnnotationProperties(beanClass, (Annotation)annotation, primaryEntity, supplementaryEntities, relationships, methodName);
            annotation.setRelatedEntityGUID(this.removeRelatedEntityGUID(remainingProperties));
            annotation.setRelationshipTypeName(this.removeRelationshipTypeName(remainingProperties));
            annotation.setRelationshipProperties(this.removeRelationshipProperties(remainingProperties));
            annotation.setExtendedProperties(this.getRemainingExtendedProperties(remainingProperties));
            return annotation;
        }
        catch (ClassCastException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }

    private Annotation getNewRequestForActionAnnotation(Class<B> beanClass, EntityDetail primaryEntity, List<EntityDetail> supplementaryEntities, List<Relationship> relationships, String methodName) throws PropertyServerException {
        try {
            RequestForActionAnnotation annotation = new RequestForActionAnnotation();
            InstanceProperties remainingProperties = this.fillInCommonAnnotationProperties(beanClass, (Annotation)annotation, primaryEntity, supplementaryEntities, relationships, methodName);
            annotation.setDiscoveryActivity(this.removeDiscoveryActivity(remainingProperties));
            annotation.setActionRequested(this.removeActionRequested(remainingProperties));
            annotation.setActionProperties(this.removeActionProperties(remainingProperties));
            annotation.setExtendedProperties(this.getRemainingExtendedProperties(remainingProperties));
            return annotation;
        }
        catch (ClassCastException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }

    private Annotation getNewSchemaAnalysisAnnotation(Class<B> beanClass, EntityDetail primaryEntity, List<EntityDetail> supplementaryEntities, List<Relationship> relationships, String methodName) throws PropertyServerException {
        try {
            SchemaAnalysisAnnotation annotation = new SchemaAnalysisAnnotation();
            InstanceProperties remainingProperties = this.fillInCommonAnnotationProperties(beanClass, (Annotation)annotation, primaryEntity, supplementaryEntities, relationships, methodName);
            annotation.setSchemaName(this.removeSchemaName(remainingProperties));
            annotation.setSchemaTypeName(this.removeSchemaType(remainingProperties));
            int dataFieldCount = 0;
            if (relationships != null) {
                for (Relationship relationship : relationships) {
                    if (relationship == null || !this.repositoryHelper.isTypeOf(this.serviceName, relationship.getType().getTypeDefName(), "DiscoveredDataField")) continue;
                    ++dataFieldCount;
                }
            }
            annotation.setDiscoveredDataFields(dataFieldCount);
            annotation.setExtendedProperties(this.getRemainingExtendedProperties(remainingProperties));
            return annotation;
        }
        catch (ClassCastException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }

    private Annotation getNewSemanticAnnotation(Class<B> beanClass, EntityDetail primaryEntity, List<EntityDetail> supplementaryEntities, List<Relationship> relationships, String methodName) throws PropertyServerException {
        try {
            SemanticAnnotation annotation = new SemanticAnnotation();
            InstanceProperties remainingProperties = this.fillInCommonAnnotationProperties(beanClass, (Annotation)annotation, primaryEntity, supplementaryEntities, relationships, methodName);
            annotation.setInformalTerm(this.removeInformalTerm(remainingProperties));
            annotation.setCandidateGlossaryTermGUIDs(this.removeCandidateGlossaryTermGUIDs(remainingProperties));
            annotation.setInformalTopic(this.removeInformalTopic(remainingProperties));
            annotation.setCandidateGlossaryCategoryGUIDs(this.removeCandidateGlossaryCategoryGUIDs(remainingProperties));
            annotation.setExtendedProperties(this.getRemainingExtendedProperties(remainingProperties));
            return annotation;
        }
        catch (ClassCastException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }

    private Annotation getNewSuspectDuplicateAnnotation(Class<B> beanClass, EntityDetail primaryEntity, List<EntityDetail> supplementaryEntities, List<Relationship> relationships, String methodName) throws PropertyServerException {
        try {
            SuspectDuplicateAnnotation annotation = new SuspectDuplicateAnnotation();
            InstanceProperties remainingProperties = this.fillInCommonAnnotationProperties(beanClass, (Annotation)annotation, primaryEntity, supplementaryEntities, relationships, methodName);
            annotation.setDuplicateAnchorGUIDs(this.removeDuplicateAnchorGUIDs(remainingProperties));
            annotation.setMatchingPropertyNames(this.removeMatchingPropertyNames(remainingProperties));
            annotation.setMatchingClassificationNames(this.removeMatchingClassificationNames(remainingProperties));
            annotation.setMatchingAttachmentGUIDs(this.removeMatchingAttachmentGUIDs(remainingProperties));
            annotation.setMatchingRelationshipGUIDs(this.removeMatchingRelationshipGUIDs(remainingProperties));
            annotation.setExtendedProperties(this.getRemainingExtendedProperties(remainingProperties));
            return annotation;
        }
        catch (ClassCastException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }

    private Annotation getNewAnnotation(Class<B> beanClass, EntityDetail primaryEntity, List<EntityDetail> supplementaryEntities, List<Relationship> relationships, String methodName) throws PropertyServerException {
        try {
            Annotation annotation = new Annotation();
            InstanceProperties remainingProperties = this.fillInCommonAnnotationProperties(beanClass, annotation, primaryEntity, supplementaryEntities, relationships, methodName);
            annotation.setExtendedProperties(this.getRemainingExtendedProperties(remainingProperties));
            return annotation;
        }
        catch (ClassCastException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }

    private InstanceProperties fillInCommonAnnotationProperties(Class<B> beanClass, Annotation annotation, EntityDetail primaryEntity, List<EntityDetail> supplementaryEntities, List<Relationship> relationships, String methodName) throws PropertyServerException {
        annotation.setElementHeader(this.getMetadataElementHeader(beanClass, primaryEntity, methodName));
        InstanceProperties instanceProperties = null;
        if (primaryEntity.getProperties() != null) {
            instanceProperties = new InstanceProperties(primaryEntity.getProperties());
        }
        annotation.setAnnotationType(this.removeAnnotationType(instanceProperties));
        annotation.setSummary(this.removeSummary(instanceProperties));
        annotation.setConfidenceLevel(this.removeConfidenceLevel(instanceProperties));
        annotation.setExpression(this.removeExpression(instanceProperties));
        annotation.setExplanation(this.removeExplanation(instanceProperties));
        annotation.setAnalysisStep(this.removeAnalysisStep(instanceProperties));
        annotation.setJsonProperties(this.removeJsonProperties(instanceProperties));
        annotation.setAdditionalProperties(this.removeAdditionalProperties(instanceProperties));
        if (supplementaryEntities != null) {
            for (EntityDetail entity : supplementaryEntities) {
                String actualTypeName;
                if (entity == null || entity.getType() == null || !this.repositoryHelper.isTypeOf(this.serviceName, actualTypeName = entity.getType().getTypeDefName(), "AnnotationReview")) continue;
                InstanceProperties properties = new InstanceProperties(entity.getProperties());
                annotation.setReviewDate(this.removeReviewDate(properties));
                annotation.setSteward(this.removeSteward(properties));
                annotation.setReviewComment(this.removeComment(properties));
            }
        }
        if (relationships != null) {
            for (Relationship relationship : relationships) {
                if (relationship == null || !this.repositoryHelper.isTypeOf(this.serviceName, relationship.getType().getTypeDefName(), "AnnotationReviewLink")) continue;
                annotation.setAnnotationStatus(this.getAnnotationStatusFromProperties(instanceProperties));
            }
        }
        return instanceProperties;
    }

    private AnnotationStatus getAnnotationStatusFromProperties(InstanceProperties properties) {
        Map instancePropertiesMap;
        InstancePropertyValue instancePropertyValue;
        AnnotationStatus requestStatus = AnnotationStatus.UNKNOWN_STATUS;
        if (properties != null && (instancePropertyValue = (InstancePropertyValue)(instancePropertiesMap = properties.getInstanceProperties()).get("annotationStatus")) instanceof EnumPropertyValue) {
            EnumPropertyValue enumPropertyValue = (EnumPropertyValue)instancePropertyValue;
            switch (enumPropertyValue.getOrdinal()) {
                case 0: {
                    requestStatus = AnnotationStatus.NEW_ANNOTATION;
                    break;
                }
                case 1: {
                    requestStatus = AnnotationStatus.REVIEWED_ANNOTATION;
                    break;
                }
                case 2: {
                    requestStatus = AnnotationStatus.APPROVED_ANNOTATION;
                    break;
                }
                case 3: {
                    requestStatus = AnnotationStatus.ACTIONED_ANNOTATION;
                    break;
                }
                case 4: {
                    requestStatus = AnnotationStatus.INVALID_ANNOTATION;
                    break;
                }
                case 5: {
                    requestStatus = AnnotationStatus.IGNORE_ANNOTATION;
                    break;
                }
                case 98: {
                    requestStatus = AnnotationStatus.OTHER_STATUS;
                    break;
                }
                default: {
                    requestStatus = AnnotationStatus.UNKNOWN_STATUS;
                }
            }
        }
        return requestStatus;
    }
}

