/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.util.Map;
import org.odpi.openmetadata.commonservices.generichandlers.ReferenceableBuilder;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.ClassificationOrigin;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProvenanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeErrorException;

public class CollectionBuilder
extends ReferenceableBuilder {
    private String displayName = null;
    private String description = null;

    CollectionBuilder(String qualifiedName, String displayName, String description, Map<String, String> additionalProperties, String typeGUID, String typeName, Map<String, Object> extendedProperties, OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(qualifiedName, additionalProperties, typeGUID, typeName, extendedProperties, repositoryHelper, serviceName, serverName);
        this.displayName = displayName;
        this.description = description;
    }

    CollectionBuilder(String qualifiedName, String displayName, String description, OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(qualifiedName, null, "347005ba-2b35-4670-b5a7-12c9ebed0cf7", "Collection", null, repositoryHelper, serviceName, serverName);
        this.displayName = displayName;
        this.description = description;
    }

    CollectionBuilder(OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super("347005ba-2b35-4670-b5a7-12c9ebed0cf7", "Collection", repositoryHelper, serviceName, serverName);
    }

    @Override
    public InstanceProperties getInstanceProperties(String methodName) throws InvalidParameterException {
        InstanceProperties properties = super.getInstanceProperties(methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "displayName", this.displayName, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "description", this.description, methodName);
        return properties;
    }

    void setupCollectionClassification(String userId, String classificationName, String methodName) throws InvalidParameterException {
        try {
            Classification classification = this.repositoryHelper.getNewClassification(this.serviceName, null, null, InstanceProvenanceType.LOCAL_COHORT, userId, classificationName, this.typeName, ClassificationOrigin.ASSIGNED, null, null);
            this.newClassifications.put(classification.getName(), classification);
        }
        catch (TypeErrorException error) {
            this.errorHandler.handleUnsupportedType((Exception)((Object)error), methodName, "Folder");
        }
    }

    void setupFolderClassification(String userId, int orderBy, String orderPropertyName, String methodName) throws InvalidParameterException {
        try {
            Classification classification = this.repositoryHelper.getNewClassification(this.serviceName, null, null, InstanceProvenanceType.LOCAL_COHORT, userId, "Folder", this.typeName, ClassificationOrigin.ASSIGNED, null, this.getFolderProperties(orderBy, orderPropertyName, methodName));
            this.newClassifications.put(classification.getName(), classification);
        }
        catch (TypeErrorException error) {
            this.errorHandler.handleUnsupportedType((Exception)((Object)error), methodName, "Folder");
        }
    }

    InstanceProperties getFolderProperties(int orderBy, String orderPropertyName, String methodName) {
        InstanceProperties properties = this.repositoryHelper.addIntPropertyToInstance(this.serviceName, null, "orderBy", orderBy, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "orderPropertyName", orderPropertyName, methodName);
        return properties;
    }
}

