/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.generichandlers.AssetHandler;
import org.odpi.openmetadata.commonservices.generichandlers.ConnectionHandler;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIDummyBean;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIDummyBeanConverter;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericConverter;
import org.odpi.openmetadata.commonservices.generichandlers.ReferenceableBuilder;
import org.odpi.openmetadata.commonservices.generichandlers.SchemaAttributeBuilder;
import org.odpi.openmetadata.commonservices.generichandlers.SchemaAttributeHandler;
import org.odpi.openmetadata.commonservices.generichandlers.SchemaTypeBuilder;
import org.odpi.openmetadata.commonservices.generichandlers.SoftwareServerCapabilityHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.metadatasecurity.server.OpenMetadataServerSecurityVerifier;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class FilesAndFoldersHandler<FILESYSTEM, FOLDER, FILE> {
    private String serviceName;
    private String serverName;
    private String localServerUserId;
    private OMRSRepositoryHelper repositoryHelper;
    private RepositoryHandler repositoryHandler;
    private InvalidParameterHandler invalidParameterHandler;
    private SoftwareServerCapabilityHandler<FILESYSTEM> fileSystemHandler;
    private AssetHandler<FOLDER> folderHandler;
    private AssetHandler<FILE> fileHandler;
    private ConnectionHandler<OpenMetadataAPIDummyBean> connectionHandler;
    private SchemaAttributeHandler<OpenMetadataAPIDummyBean, OpenMetadataAPIDummyBean> schemaAttributeHandler;
    private static final String folderDivider = "/";
    private static final String fileSystemDivider = "://";
    private static final String fileTypeDivider = "\\.";
    private static final String defaultAvroFileType = "avro";
    private static final String defaultCSVFileType = "csv";

    public FilesAndFoldersHandler(OpenMetadataAPIGenericConverter<FILESYSTEM> fileSystemConverter, Class<FILESYSTEM> fileSystemBeanClass, OpenMetadataAPIGenericConverter<FOLDER> folderConverter, Class<FOLDER> folderBeanClass, OpenMetadataAPIGenericConverter<FILE> fileConverter, Class<FILE> fileBeanClass, String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper, String localServerUserId, OpenMetadataServerSecurityVerifier securityVerifier, List<String> supportedZones, List<String> defaultZones, List<String> publishZones, AuditLog auditLog) {
        this.serviceName = serviceName;
        this.serverName = serverName;
        this.localServerUserId = localServerUserId;
        this.invalidParameterHandler = invalidParameterHandler;
        this.repositoryHandler = repositoryHandler;
        this.repositoryHelper = repositoryHelper;
        this.fileSystemHandler = new SoftwareServerCapabilityHandler<FILESYSTEM>(fileSystemConverter, fileSystemBeanClass, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
        this.folderHandler = new AssetHandler<FOLDER>(folderConverter, folderBeanClass, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
        this.fileHandler = new AssetHandler<FILE>(fileConverter, fileBeanClass, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
        OpenMetadataAPIDummyBeanConverter dummyConverter = new OpenMetadataAPIDummyBeanConverter(repositoryHelper, serviceName, serverName);
        this.connectionHandler = new ConnectionHandler<OpenMetadataAPIDummyBean>(dummyConverter, OpenMetadataAPIDummyBean.class, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
        OpenMetadataAPIDummyBeanConverter dummySchemaAttributeConverter = new OpenMetadataAPIDummyBeanConverter(repositoryHelper, serviceName, serverName);
        this.schemaAttributeHandler = new SchemaAttributeHandler<OpenMetadataAPIDummyBean, OpenMetadataAPIDummyBean>(dummySchemaAttributeConverter, OpenMetadataAPIDummyBean.class, dummySchemaAttributeConverter, OpenMetadataAPIDummyBean.class, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
    }

    private String getFileSystemName(String pathName) {
        String[] tokens;
        String result = null;
        if (pathName != null && !pathName.isEmpty() && (tokens = pathName.split(fileSystemDivider)).length > 1) {
            result = tokens[0] + fileSystemDivider;
        }
        return result;
    }

    private List<String> getFolderNames(String pathName) {
        String[] tokens;
        ArrayList<String> result = null;
        if (pathName != null && !pathName.isEmpty() && (tokens = pathName.split(folderDivider)).length > 1) {
            int startingToken = 0;
            if (tokens[startingToken].length() == 0) {
                startingToken = 1;
            } else if (this.getFileSystemName(pathName) != null) {
                startingToken = 2;
            }
            int endingToken = tokens.length;
            if (this.getFileName(pathName) != null) {
                --endingToken;
            }
            if (startingToken != endingToken) {
                result = new ArrayList<String>(Arrays.asList(tokens).subList(startingToken, endingToken));
            }
        }
        return result;
    }

    private String getFileName(String pathName) {
        String result = null;
        if (pathName != null && !pathName.isEmpty()) {
            String[] tokens = pathName.split(folderDivider);
            result = tokens[tokens.length - 1];
        }
        return result;
    }

    private String getFileType(String pathName) {
        String[] tokens;
        String result = null;
        if (pathName != null && !pathName.isEmpty() && (tokens = pathName.split(fileTypeDivider)).length > 1) {
            result = tokens[tokens.length - 1];
        }
        return result;
    }

    public String createFileSystem(String userId, String externalSourceGUID, String externalSourceName, String uniqueName, String displayName, String description, String type, String version, String patchLevel, String source, String format, String encryption, Map<String, String> additionalProperties, Map<String, String> vendorProperties, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.fileSystemHandler.createFileSystem(userId, externalSourceGUID, externalSourceName, uniqueName, displayName, description, type, version, patchLevel, source, format, encryption, additionalProperties, vendorProperties, null, null, methodName);
    }

    private String createFolder(String userId, String externalSourceGUID, String externalSourceName, String pathName, String displayName, String description, String typeName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String folderAssetGUIDParameterName = "folderAssetGUID";
        String folderAssetTypeName = "FileFolder";
        if (typeName != null) {
            folderAssetTypeName = typeName;
        }
        return this.folderHandler.createAssetWithConnection(userId, externalSourceGUID, externalSourceName, "folderAssetGUID", pathName, displayName, description, null, folderAssetTypeName, null, InstanceStatus.ACTIVE, true, null, null, pathName, null, null, methodName);
    }

    private String createFileAsset(String userId, String externalSourceGUID, String externalSourceName, String fileType, String pathName, String displayName, String description, String typeName, Map<String, Object> initialExtendedProperties, Map<String, Object> configurationProperties, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String fileAssetGUIDParameterName = "fileAssetGUID";
        HashMap<String, Object> extendedProperties = new HashMap<String, String>();
        if (initialExtendedProperties != null) {
            extendedProperties = new HashMap<String, Object>(initialExtendedProperties);
        }
        extendedProperties.put("fileType", fileType);
        String fileAssetTypeName = "DataFile";
        if (typeName != null) {
            fileAssetTypeName = typeName;
        }
        return this.fileHandler.createAssetWithConnection(userId, externalSourceGUID, externalSourceName, "fileAssetGUID", pathName, displayName, description, null, fileAssetTypeName, extendedProperties, InstanceStatus.ACTIVE, true, configurationProperties, null, pathName, null, null, methodName);
    }

    private String createFolderInCatalog(String userId, String externalSourceGUID, String externalSourceName, String connectToGUID, String pathName, String folderName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String connectToParameterName = "connectToGUID";
        String folderParameterName = "folderGUID";
        String folderGUID = this.createFolder(userId, externalSourceGUID, externalSourceName, pathName, folderName, null, "FileFolder", methodName);
        if (connectToGUID != null) {
            if (this.repositoryHandler.isEntityATypeOf(userId, connectToGUID, "connectToGUID", "SoftwareServerCapability", new Date(), methodName)) {
                this.folderHandler.linkElementToElement(userId, externalSourceGUID, externalSourceName, connectToGUID, "connectToGUID", "SoftwareServerCapability", folderGUID, "folderGUID", "FileFolder", false, false, "56315447-88a6-4235-ba91-fead86524ebf", "ServerAssetUse", null, methodName);
            } else {
                this.folderHandler.linkElementToElement(userId, externalSourceGUID, externalSourceName, connectToGUID, "connectToGUID", "FileFolder", folderGUID, "folderGUID", "FileFolder", false, false, "48ac9028-45dd-495d-b3e1-622685b54a01", "FolderHierarchy", null, methodName);
            }
        }
        return folderGUID;
    }

    private List<String> createFolderStructureInCatalog(String userId, String externalSourceGUID, String externalSourceName, String connectToGUID, String fileSystemName, List<String> folderNames, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String localMethodName = "->createFolderStructureInCatalog";
        ArrayList<String> folderGUIDs = new ArrayList<String>();
        if (folderNames != null && !folderNames.isEmpty()) {
            Object pathName = null;
            Object folderName = null;
            String nextConnectToGUID = connectToGUID;
            for (String folderFragment : folderNames) {
                pathName = pathName == null ? (fileSystemName != null ? fileSystemName + folderFragment : folderFragment) : pathName + folderDivider + folderFragment;
                folderName = folderName != null ? (String)folderName + folderDivider + folderFragment : folderFragment;
                String currentFolderGUID = this.getFolderGUIDByPathName(userId, (String)pathName, methodName);
                if (currentFolderGUID == null) {
                    String folderGUID = this.createFolderInCatalog(userId, externalSourceGUID, externalSourceName, nextConnectToGUID, (String)pathName, (String)folderName, methodName + "->createFolderStructureInCatalog");
                    folderGUIDs.add(folderGUID);
                    nextConnectToGUID = folderGUID;
                    continue;
                }
                folderGUIDs.add(currentFolderGUID);
                nextConnectToGUID = currentFolderGUID;
            }
        }
        if (folderGUIDs.isEmpty()) {
            return null;
        }
        return folderGUIDs;
    }

    public List<String> createFolderStructureInCatalog(String userId, String externalSourceGUID, String externalSourceName, String connectToGUID, String pathName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.createFolderStructureInCatalog(userId, externalSourceGUID, externalSourceName, connectToGUID, this.getFileSystemName(pathName), this.getFolderNames(pathName), methodName);
    }

    public void attachFolderToFileSystem(String userId, String externalSourceGUID, String externalSourceName, String fileSystemGUID, String fileSystemGUIDParameterName, String folderGUID, String folderGUIDParameterName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.folderHandler.linkElementToElement(userId, externalSourceGUID, externalSourceName, fileSystemGUID, fileSystemGUIDParameterName, "SoftwareServerCapability", folderGUID, folderGUIDParameterName, "FileFolder", false, false, "56315447-88a6-4235-ba91-fead86524ebf", "ServerAssetUse", null, methodName);
    }

    public void detachFolderFromFileSystem(String userId, String externalSourceGUID, String externalSourceName, String fileSystemGUID, String fileSystemGUIDParameterName, String folderGUID, String folderGUIDParameterName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.folderHandler.unlinkElementFromElement(userId, false, externalSourceGUID, externalSourceName, fileSystemGUID, fileSystemGUIDParameterName, "SoftwareServerCapability", folderGUID, folderGUIDParameterName, "229ed5cc-de31-45fc-beb4-9919fd247398", "FileFolder", false, false, "56315447-88a6-4235-ba91-fead86524ebf", "ServerAssetUse", null, methodName);
    }

    public void attachDataFileAssetToFolder(String userId, String externalSourceGUID, String externalSourceName, String folderGUID, String folderGUIDParameterName, String fileGUID, String fileGUIDParameterName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.fileHandler.linkElementToElement(userId, externalSourceGUID, externalSourceName, folderGUID, folderGUIDParameterName, "FileFolder", fileGUID, fileGUIDParameterName, "DataFile", false, false, "970a3405-fde1-4039-8249-9aa5f56d5151", "LinkedFile", null, methodName);
    }

    public void detachDataFileAssetFromFolder(String userId, String externalSourceGUID, String externalSourceName, String folderGUID, String folderGUIDParameterName, String fileGUID, String fileGUIDParameterName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.folderHandler.unlinkElementFromElement(userId, false, externalSourceGUID, externalSourceName, fileGUID, fileGUIDParameterName, "DataFile", folderGUID, folderGUIDParameterName, "229ed5cc-de31-45fc-beb4-9919fd247398", "FileFolder", false, false, "970a3405-fde1-4039-8249-9aa5f56d5151", "LinkedFile", null, methodName);
    }

    public void moveDataFileInCatalog(String userId, String externalSourceGUID, String externalSourceName, String newParentFolder, String newParentFolderGUIDParameterName, String fileGUID, String fileGUIDParameterName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String endpointGUIDParameterName = "endpointGUID";
        Date effectiveTime = new Date();
        String newFolderPathName = this.folderHandler.getBeanStringPropertyFromRepository(userId, newParentFolder, newParentFolderGUIDParameterName, "FileFolder", "qualifiedName", effectiveTime, methodName);
        String existingFilePathName = this.fileHandler.getBeanStringPropertyFromRepository(userId, newParentFolder, newParentFolderGUIDParameterName, "DataFile", "qualifiedName", effectiveTime, methodName);
        String fileName = this.getFileName(existingFilePathName);
        String fullPathName = newFolderPathName + folderDivider + fileName;
        this.fileHandler.relinkElementToNewElement(userId, externalSourceGUID, externalSourceName, fileGUID, fileGUIDParameterName, "DataFile", false, newParentFolder, newParentFolderGUIDParameterName, "FileFolder", "970a3405-fde1-4039-8249-9aa5f56d5151", "LinkedFile", null, methodName);
        this.fileHandler.updateBeanPropertyInRepository(userId, externalSourceGUID, externalSourceName, fileGUID, fileGUIDParameterName, "10752b4a-4b5d-4519-9eae-fdd6d162122f", "DataFile", "qualifiedName", fullPathName, false, false, effectiveTime, methodName);
        ArrayList<String> relationshipPath = new ArrayList<String>();
        relationshipPath.add("e777d660-8dbe-453e-8b83-903771f054c0");
        relationshipPath.add("887a7132-d6bc-4b92-a483-e80b60c86fb2");
        List<Object> endpointGUIDs = new ArrayList();
        while (endpointGUIDs != null) {
            endpointGUIDs = this.fileHandler.getRelatedEntityGUIDs(userId, fileGUID, fileGUIDParameterName, "10752b4a-4b5d-4519-9eae-fdd6d162122f", relationshipPath, "Endpoint", 0, this.invalidParameterHandler.getMaxPagingSize(), effectiveTime, methodName);
            if (endpointGUIDs.isEmpty()) {
                endpointGUIDs = null;
                continue;
            }
            for (String string : endpointGUIDs) {
                if (string == null) continue;
                this.fileSystemHandler.updateBeanPropertyInRepository(userId, externalSourceGUID, externalSourceName, string, "endpointGUID", "dbc20663-d705-4ff0-8424-80c262c6b8e7", "Endpoint", "networkAddress", fullPathName, false, false, effectiveTime, methodName);
            }
        }
    }

    public void moveDataFolderInCatalog(String userId, String externalSourceGUID, String externalSourceName, String newParentFolderGUID, String newParentFolderGUIDParameterName, String movingFolderGUID, String movingFolderGUIDParameterName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(newParentFolderGUID, newParentFolderGUIDParameterName, methodName);
        this.invalidParameterHandler.validateGUID(movingFolderGUID, movingFolderGUIDParameterName, methodName);
        this.invalidParameterHandler.throwMethodNotSupported(userId, this.serviceName, this.serverName, methodName);
    }

    private List<String> addFileAssetPath(String userId, String externalSourceGUID, String externalSourceName, String fileAssetGUID, String fileAssetParameterName, String pathName, String pathNameParameterName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        ArrayList<String> assetGUIDList = new ArrayList<String>();
        String fileSystemGUID = null;
        String fileSystemName = this.getFileSystemName(pathName);
        if (fileSystemName != null && (fileSystemGUID = this.fileSystemHandler.getBeanGUIDByQualifiedName(userId, "fe30a033-8f86-4d17-8986-e6166fa24177", "SoftwareServerCapability", fileSystemName, pathNameParameterName, false, false, new Date(), methodName)) == null) {
            fileSystemGUID = this.fileSystemHandler.createFileSystem(this.localServerUserId, externalSourceGUID, externalSourceName, fileSystemName, fileSystemName, null, null, null, null, null, null, null, null, null, null, null, methodName);
        }
        List<String> folderNames = this.getFolderNames(pathName);
        List<String> folderGUIDs = null;
        String fileParentGUID = folderNames == null ? fileSystemGUID : ((folderGUIDs = this.createFolderStructureInCatalog(this.localServerUserId, externalSourceGUID, externalSourceName, fileSystemGUID, fileSystemName, folderNames, methodName)) != null && !folderGUIDs.isEmpty() ? folderGUIDs.get(folderGUIDs.size() - 1) : fileSystemGUID);
        if (fileAssetGUID != null && fileParentGUID != null) {
            if (fileParentGUID.equals(fileSystemGUID)) {
                this.folderHandler.linkElementToElement(userId, externalSourceGUID, externalSourceName, fileParentGUID, pathNameParameterName, "SoftwareServerCapability", fileAssetGUID, fileAssetParameterName, "DataFile", false, false, "56315447-88a6-4235-ba91-fead86524ebf", "ServerAssetUse", null, methodName);
            } else {
                this.folderHandler.linkElementToElement(userId, externalSourceGUID, externalSourceName, fileParentGUID, pathNameParameterName, "FileFolder", fileAssetGUID, fileAssetParameterName, "DataFile", false, false, "4cb88900-1446-4eb6-acea-29cd9da45e63", "NestedFile", null, methodName);
            }
        }
        if (fileSystemGUID != null) {
            assetGUIDList.add(fileSystemGUID);
        }
        if (folderGUIDs != null) {
            assetGUIDList.addAll(folderGUIDs);
        }
        if (fileAssetGUID != null) {
            assetGUIDList.add(fileAssetGUID);
        }
        if (assetGUIDList.isEmpty()) {
            return null;
        }
        return assetGUIDList;
    }

    public List<String> addDataFileAssetToCatalog(String userId, String externalSourceGUID, String externalSourceName, String displayName, String description, String pathName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String pathParameterName = "pathName";
        String fileAssetParameterName = "fileAssetGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateName(pathName, "pathName", methodName);
        String fileType = this.getFileType(pathName);
        String fileAssetGUID = this.createFileAsset(userId, externalSourceGUID, externalSourceName, fileType, pathName, displayName, description, "DataFile", null, null, methodName);
        return this.addFileAssetPath(userId, externalSourceGUID, externalSourceName, fileAssetGUID, "fileAssetGUID", pathName, "pathName", methodName);
    }

    private Map<String, Object> getExtendedProperties(String pathName, Date createTime, Date modifiedTime, String encodingType, String encodingLanguage, String encodingDescription, Map<String, String> encodingProperties, String fileType, Map<String, Object> extendedProperties) {
        Map<String, Object> assetExtendedProperties = extendedProperties;
        if (assetExtendedProperties == null) {
            assetExtendedProperties = new HashMap<String, Object>();
        }
        if (pathName != null) {
            assetExtendedProperties.put("pathName", pathName);
        }
        if (createTime != null) {
            assetExtendedProperties.put("storeCreateTime", createTime);
        }
        if (modifiedTime != null) {
            assetExtendedProperties.put("storeUpdateTime", modifiedTime);
        }
        if (encodingType != null) {
            assetExtendedProperties.put("encoding", encodingType);
        }
        if (encodingLanguage != null) {
            assetExtendedProperties.put("language", encodingLanguage);
        }
        if (encodingDescription != null) {
            assetExtendedProperties.put("description", encodingDescription);
        }
        if (encodingProperties != null) {
            assetExtendedProperties.put("properties", encodingProperties);
        }
        if (fileType != null) {
            assetExtendedProperties.put("fileType", fileType);
        }
        if (assetExtendedProperties.isEmpty()) {
            return null;
        }
        return assetExtendedProperties;
    }

    public List<String> addDataFolderAssetToCatalog(String userId, String externalSourceGUID, String externalSourceName, String pathName, String displayName, String description, Date createTime, Date modifiedTime, String encodingType, String encodingLanguage, String encodingDescription, Map<String, String> encodingProperties, Map<String, String> additionalProperties, String connectorProviderClassName, String typeName, Map<String, Object> extendedProperties, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String pathParameterName = "pathName";
        String folderAssetParameterName = "folderAssetGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateName(pathName, "pathName", methodName);
        Map<String, Object> assetExtendedProperties = this.getExtendedProperties(pathName, createTime, modifiedTime, encodingType, encodingLanguage, encodingDescription, encodingProperties, null, extendedProperties);
        String folderAssetTypeName = "DataFolder";
        if (typeName != null) {
            folderAssetTypeName = typeName;
        }
        String folderAssetGUID = this.fileHandler.createAssetWithConnection(userId, externalSourceGUID, externalSourceName, "folderAssetGUID", pathName, displayName, description, additionalProperties, folderAssetTypeName, assetExtendedProperties, InstanceStatus.ACTIVE, true, null, connectorProviderClassName, pathName, null, null, methodName);
        return this.addFileAssetPath(userId, externalSourceGUID, externalSourceName, folderAssetGUID, "folderAssetGUID", pathName, "pathName", methodName);
    }

    public List<String> addDataFolderAssetToCatalog(String userId, String externalSourceGUID, String externalSourceName, String pathName, String displayName, String description, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String pathParameterName = "pathName";
        String folderAssetParameterName = "folderAssetGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateName(pathName, "pathName", methodName);
        String folderAssetGUID = this.createFolder(userId, externalSourceGUID, externalSourceName, pathName, displayName, description, "DataFolder", methodName);
        return this.addFileAssetPath(userId, externalSourceGUID, externalSourceName, folderAssetGUID, "folderAssetGUID", pathName, "pathName", methodName);
    }

    public List<String> addFileToCatalog(String userId, String externalSourceGUID, String externalSourceName, String qualifiedName, String displayName, String description, String pathName, Date createTime, Date modifiedTime, String encodingType, String encodingLanguage, String encodingDescription, Map<String, String> encodingProperties, String suppliedFileType, Map<String, String> additionalProperties, String connectorProviderClassName, String typeName, Map<String, Object> extendedProperties, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String fileAssetGUID;
        String fileType;
        String pathParameterName = "qualifiedName";
        String fileAssetParameterName = "fileAssetGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        String fullPath = pathName;
        if (fullPath == null) {
            fullPath = qualifiedName;
        }
        if ((fileType = suppliedFileType) != null) {
            fileType = this.getFileType(fullPath);
        }
        Map<String, Object> assetExtendedProperties = this.getExtendedProperties(fullPath, createTime, modifiedTime, encodingType, encodingLanguage, encodingDescription, encodingProperties, fileType, extendedProperties);
        String fileAssetTypeName = typeName;
        if (fileAssetTypeName == null) {
            fileAssetTypeName = defaultCSVFileType.equals(fileType) ? "CSVFile" : (defaultAvroFileType.equals(fileType) ? "AvroFile" : "DataFile");
        }
        if ((fileAssetGUID = this.fileHandler.createAssetWithConnection(userId, externalSourceGUID, externalSourceName, "fileAssetGUID", fullPath, displayName, description, additionalProperties, fileAssetTypeName, assetExtendedProperties, InstanceStatus.ACTIVE, true, null, connectorProviderClassName, fullPath, null, null, methodName)) != null) {
            return this.addFileAssetPath(userId, externalSourceGUID, externalSourceName, fileAssetGUID, "fileAssetGUID", fullPath, "qualifiedName", methodName);
        }
        return null;
    }

    public List<String> addFileToCatalogFromTemplate(String userId, String externalSourceGUID, String externalSourceName, String templateGUID, String fullPath, String displayName, String description, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String templateGUIDParameterName = "templateGUID";
        String qualifiedNameParameterName = "fullPath";
        String fileAssetParameterName = "fileAssetGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(templateGUID, "templateGUID", methodName);
        this.invalidParameterHandler.validateName(fullPath, "fullPath", methodName);
        String fileAssetGUID = this.fileHandler.addAssetFromTemplate(userId, externalSourceGUID, externalSourceName, templateGUID, "templateGUID", "10752b4a-4b5d-4519-9eae-fdd6d162122f", "DataFile", fullPath, "fullPath", displayName, description, fullPath, methodName);
        if (fileAssetGUID != null) {
            return this.addFileAssetPath(userId, externalSourceGUID, externalSourceName, fileAssetGUID, "fileAssetGUID", fullPath, "fullPath", methodName);
        }
        return null;
    }

    public List<String> addFolderToCatalogFromTemplate(String userId, String externalSourceGUID, String externalSourceName, String templateGUID, String pathName, String displayName, String description, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String templateGUIDParameterName = "templateGUID";
        String qualifiedNameParameterName = "pathName";
        String fileAssetParameterName = "folderAssetGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(templateGUID, "templateGUID", methodName);
        this.invalidParameterHandler.validateName(pathName, "pathName", methodName);
        String folderAssetGUID = this.fileHandler.addAssetFromTemplate(userId, externalSourceGUID, externalSourceName, templateGUID, "templateGUID", "9f1fb984-db15-43ee-85fb-f8b0353bfb8b", "DataFolder", pathName, "pathName", displayName, description, pathName, methodName);
        if (folderAssetGUID != null) {
            return this.addFileAssetPath(userId, externalSourceGUID, externalSourceName, folderAssetGUID, "folderAssetGUID", pathName, "pathName", methodName);
        }
        return null;
    }

    public List<String> addAvroFileToCatalog(String userId, String externalSourceGUID, String externalSourceName, String displayName, String description, String fullPath, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String pathParameterName = "fullPath";
        String fileAssetParameterName = "fileAssetGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateName(fullPath, "fullPath", methodName);
        String fileType = this.getFileType(fullPath);
        if (fileType == null) {
            fileType = defaultAvroFileType;
        }
        String fileAssetGUID = this.createFileAsset(userId, externalSourceGUID, externalSourceName, fileType, fullPath, displayName, description, "AvroFile", null, null, methodName);
        return this.addFileAssetPath(userId, externalSourceGUID, externalSourceName, fileAssetGUID, "fileAssetGUID", fullPath, "fullPath", methodName);
    }

    public List<String> addCSVFileToCatalog(String userId, String externalSourceGUID, String externalSourceName, String displayName, String description, String fullPath, List<String> columnHeaders, Character delimiterCharacter, Character quoteCharacter, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String pathParameterName = "fullPath";
        String fileAssetGUIDParameterName = "fileAssetGUID";
        String schemaTypeGUIDParameterName = "schemaTypeGUID";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateName(fullPath, "fullPath", methodName);
        String fileType = this.getFileType(fullPath);
        if (fileType == null) {
            fileType = defaultCSVFileType;
        }
        if (delimiterCharacter == null) {
            delimiterCharacter = Character.valueOf(',');
        }
        if (quoteCharacter == null) {
            quoteCharacter = Character.valueOf('\"');
        }
        HashMap<String, Object> extendedProperties = new HashMap<String, Object>();
        extendedProperties.put("delimiterCharacter", delimiterCharacter.toString());
        extendedProperties.put("quoteCharacter", quoteCharacter.toString());
        extendedProperties.put("fileType", fileType);
        HashMap<String, Object> configurationProperties = new HashMap<String, Object>();
        configurationProperties.put("delimiterCharacter", delimiterCharacter);
        configurationProperties.put("quoteCharacter", quoteCharacter);
        if (columnHeaders != null) {
            configurationProperties.put("columnNames", columnHeaders);
        }
        if (configurationProperties.isEmpty()) {
            configurationProperties = null;
        }
        String fileAssetGUID = this.createFileAsset(userId, externalSourceGUID, externalSourceName, fileType, fullPath, displayName, description, "CSVFile", extendedProperties, configurationProperties, methodName);
        if (columnHeaders != null && !columnHeaders.isEmpty()) {
            String schemaTypeGUID = this.schemaAttributeHandler.getAssetSchemaTypeGUID(userId, externalSourceGUID, externalSourceName, fileAssetGUID, "fileAssetGUID", "CSVFile", "248975ec-8019-4b8a-9caf-084c8b724233", "TabularSchemaType", methodName);
            int columnCount = 0;
            for (String columnName : columnHeaders) {
                if (columnName == null) continue;
                String columnQualifiedName = fullPath + "::" + columnName + "::" + columnCount;
                String columnDisplayName = columnName + "::" + columnCount;
                SchemaAttributeBuilder schemaAttributeBuilder = new SchemaAttributeBuilder(columnQualifiedName, columnDisplayName, null, columnCount, 1, 1, false, null, true, false, 0, 0, 0, 0, false, null, null, null, "af6265e7-5f58-4a9c-9ae7-8d4284be62bd", "TabularFileColumn", null, this.repositoryHelper, this.serviceName, this.serverName);
                ++columnCount;
                schemaAttributeBuilder.setAnchors(userId, fileAssetGUID, methodName);
                SchemaTypeBuilder schemaTypeBuilder = new SchemaTypeBuilder(columnQualifiedName + ":columnType", "f0f75fba-9136-4082-8352-0ad74f3c36ed", "PrimitiveSchemaType", this.repositoryHelper, this.serviceName, this.serverName);
                schemaTypeBuilder.setDataType("String");
                schemaAttributeBuilder.setSchemaType(userId, schemaTypeBuilder, methodName);
                this.schemaAttributeHandler.createNestedSchemaAttribute(userId, externalSourceGUID, externalSourceName, schemaTypeGUID, "schemaTypeGUID", "TabularSchemaType", "86b176a2-015c-44a6-8106-54d5d69ba661", "AttributeForSchema", columnQualifiedName, "qualifiedName", schemaAttributeBuilder, methodName);
            }
        }
        return this.addFileAssetPath(userId, externalSourceGUID, externalSourceName, fileAssetGUID, "fileAssetGUID", fullPath, "fullPath", methodName);
    }

    public void updateFileInCatalog(String userId, String externalSourceGUID, String externalSourceName, String dataFileGUID, boolean isMergeUpdate, String fullPath, String displayName, String description, Date createTime, Date modifiedTime, String encodingType, String encodingLanguage, String encodingDescription, Map<String, String> encodingProperties, String suppliedFileType, Map<String, String> additionalProperties, Map<String, Object> extendedProperties, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String dataFileGUIDParameterName = "dataFileGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(dataFileGUID, "dataFileGUID", methodName);
        Map<String, Object> assetExtendedProperties = this.getExtendedProperties(fullPath, createTime, modifiedTime, encodingType, encodingLanguage, encodingDescription, encodingProperties, suppliedFileType, extendedProperties);
        this.fileHandler.updateAsset(userId, externalSourceGUID, externalSourceName, dataFileGUID, "dataFileGUID", fullPath, displayName, description, additionalProperties, "10752b4a-4b5d-4519-9eae-fdd6d162122f", "DataFile", assetExtendedProperties, isMergeUpdate, methodName);
    }

    public void updateFolderInCatalog(String userId, String externalSourceGUID, String externalSourceName, String dataFileGUID, boolean isMergeUpdate, String fullPath, String displayName, String description, Date createTime, Date modifiedTime, String encodingType, String encodingLanguage, String encodingDescription, Map<String, String> encodingProperties, Map<String, String> additionalProperties, Map<String, Object> extendedProperties, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String dataFolderGUIDParameterName = "dataFolderGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(dataFileGUID, "dataFolderGUID", methodName);
        Map<String, Object> assetExtendedProperties = this.getExtendedProperties(fullPath, createTime, modifiedTime, encodingType, encodingLanguage, encodingDescription, encodingProperties, null, extendedProperties);
        this.fileHandler.updateAsset(userId, externalSourceGUID, externalSourceName, dataFileGUID, "dataFolderGUID", fullPath, displayName, description, additionalProperties, "9f1fb984-db15-43ee-85fb-f8b0353bfb8b", "DataFolder", assetExtendedProperties, isMergeUpdate, methodName);
    }

    public void archiveFileInCatalog(String userId, String externalSourceGUID, String externalSourceName, String dataFileGUID, String dataFileGUIDParameterName, Date archiveDate, String archiveProcess, Map<String, String> archiveProperties, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(dataFileGUID, dataFileGUIDParameterName, methodName);
        ReferenceableBuilder builder = new ReferenceableBuilder(this.repositoryHelper, this.serviceName, this.serverName);
        Date effectiveTime = new Date();
        this.fileHandler.archiveBeanInRepository(userId, externalSourceGUID, externalSourceName, dataFileGUID, dataFileGUIDParameterName, "DataFile", builder.getMementoProperties(archiveDate, userId, archiveProcess, archiveProperties, methodName), true, false, effectiveTime, methodName);
        String connectionGUID = this.fileHandler.getAttachedElementGUID(userId, dataFileGUID, dataFileGUIDParameterName, "DataFile", "e777d660-8dbe-453e-8b83-903771f054c0", "ConnectionToAsset", "Connection", 0, true, false, effectiveTime, methodName);
        if (connectionGUID != null) {
            String connectionGUIDParameterName = "connectionGUID";
            this.connectionHandler.deleteBeanInRepository(userId, externalSourceGUID, externalSourceName, connectionGUID, "connectionGUID", "114e9f8f-5ff3-4c32-bd37-a7eb42712253", "Connection", null, null, true, false, effectiveTime, methodName);
        }
    }

    public void archiveFolderInCatalog(String userId, String externalSourceGUID, String externalSourceName, String dataFolderGUID, String dataFolderGUIDParameterName, Date archiveDate, String archiveProcess, Map<String, String> archiveProperties, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(dataFolderGUID, dataFolderGUIDParameterName, methodName);
        ReferenceableBuilder builder = new ReferenceableBuilder(this.repositoryHelper, this.serviceName, this.serverName);
        Date effectiveTime = new Date();
        this.fileHandler.archiveBeanInRepository(userId, externalSourceGUID, externalSourceName, dataFolderGUID, dataFolderGUIDParameterName, "DataFolder", builder.getMementoProperties(archiveDate, userId, archiveProcess, archiveProperties, methodName), false, false, effectiveTime, methodName);
        String connectionGUID = this.fileHandler.getAttachedElementGUID(userId, dataFolderGUID, dataFolderGUIDParameterName, "DataFolder", "e777d660-8dbe-453e-8b83-903771f054c0", "ConnectionToAsset", "Connection", 0, false, false, effectiveTime, methodName);
        if (connectionGUID != null) {
            String connectionGUIDParameterName = "connectionGUID";
            this.connectionHandler.deleteBeanInRepository(userId, externalSourceGUID, externalSourceName, connectionGUID, "connectionGUID", "114e9f8f-5ff3-4c32-bd37-a7eb42712253", "Connection", null, null, false, false, effectiveTime, methodName);
        }
    }

    public void deleteFileFromCatalog(String userId, String externalSourceGUID, String externalSourceName, String dataFileGUID, String fullPathname, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String dataFileGUIDParameterName = "dataFileGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(dataFileGUID, "dataFileGUID", methodName);
        this.fileHandler.deleteBeanInRepository(userId, externalSourceGUID, externalSourceName, dataFileGUID, "dataFileGUID", "10752b4a-4b5d-4519-9eae-fdd6d162122f", "DataFile", "qualifiedName", fullPathname, false, false, new Date(), methodName);
    }

    public void deleteFolderFromCatalog(String userId, String externalSourceGUID, String externalSourceName, String dataFolderGUID, String fullPathname, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String dataFolderGUIDParameterName = "dataFolderGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(dataFolderGUID, "dataFolderGUID", methodName);
        this.fileHandler.deleteBeanInRepository(userId, externalSourceGUID, externalSourceName, dataFolderGUID, "dataFolderGUID", "9f1fb984-db15-43ee-85fb-f8b0353bfb8b", "DataFolder", "qualifiedName", fullPathname, false, false, new Date(), methodName);
    }

    public FILESYSTEM getFileSystemByGUID(String userId, String softwareServerCapabilityGUID, String guidParameterName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return (FILESYSTEM)this.fileSystemHandler.getBeanFromRepository(userId, softwareServerCapabilityGUID, guidParameterName, "SoftwareServerCapability", false, false, new Date(), methodName);
    }

    public FILESYSTEM getFileSystemByUniqueName(String userId, String uniqueName, String parameterName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return (FILESYSTEM)this.fileSystemHandler.getBeanByQualifiedName(userId, "fe30a033-8f86-4d17-8986-e6166fa24177", "SoftwareServerCapability", uniqueName, parameterName, methodName);
    }

    public List<String> getFileSystems(String userId, int startingFrom, int pageSize, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.fileSystemHandler.getSoftwareServerCapabilityGUIDsByClassification(userId, "FileSystem", startingFrom, pageSize, methodName);
    }

    public FOLDER getFolderByGUID(String userId, String folderGUID, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String guidName = "folderGUID";
        return (FOLDER)this.folderHandler.getBeanFromRepository(userId, folderGUID, "folderGUID", "FileFolder", false, false, new Date(), methodName);
    }

    private String getFolderGUIDByPathName(String userId, String pathName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String nameName = "pathName";
        return this.folderHandler.getBeanGUIDByQualifiedName(userId, "229ed5cc-de31-45fc-beb4-9919fd247398", "FileFolder", pathName, "pathName", false, false, new Date(), methodName);
    }

    public FOLDER getFolderByPathName(String userId, String pathName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String nameName = "pathName";
        return (FOLDER)this.folderHandler.getBeanByQualifiedName(userId, "229ed5cc-de31-45fc-beb4-9919fd247398", "FileFolder", pathName, "pathName", methodName);
    }

    public List<FOLDER> findFolderByPathName(String userId, String pathName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String nameName = "pathName";
        return this.folderHandler.findBeansByQualifiedName(userId, "229ed5cc-de31-45fc-beb4-9919fd247398", "FileFolder", pathName, "pathName", false, false, 0, this.invalidParameterHandler.getMaxPagingSize(), new Date(), methodName);
    }

    public List<FOLDER> findFolderByName(String userId, String name, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String nameName = "name";
        return this.folderHandler.findAssetsByName(userId, "229ed5cc-de31-45fc-beb4-9919fd247398", "FileFolder", name, "name", 0, this.invalidParameterHandler.getMaxPagingSize(), null, methodName);
    }

    public List<String> getTopLevelFolders(String userId, String fileSystemGUID, String fileSystemParameterName, int startingFrom, int pageSize, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.folderHandler.getAttachedElementGUIDs(userId, fileSystemGUID, fileSystemParameterName, "SoftwareServerCapability", "56315447-88a6-4235-ba91-fead86524ebf", "ServerAssetUse", "FileFolder", false, false, startingFrom, pageSize, new Date(), methodName);
    }

    public List<String> getNestedFolders(String userId, String parentFolderGUID, String parentFolderParameterName, int startingFrom, int pageSize, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.folderHandler.getAttachedElementGUIDs(userId, parentFolderGUID, parentFolderParameterName, "FileFolder", "48ac9028-45dd-495d-b3e1-622685b54a01", "FolderHierarchy", "FileFolder", false, false, startingFrom, pageSize, new Date(), methodName);
    }

    public List<String> getFolderFiles(String userId, String folderGUID, String folderGUIDParameterName, int startingFrom, int pageSize, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.fileHandler.getAttachedElementGUIDs(userId, folderGUID, folderGUIDParameterName, "FileFolder", "48ac9028-45dd-495d-b3e1-622685b54a01", "FolderHierarchy", "FileFolder", false, false, startingFrom, pageSize, effectiveTime, methodName);
    }

    public FILE getDataFileByGUID(String userId, String dataFileGUID, String dataFileGUIDParameterName, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return (FILE)this.fileHandler.getBeanFromRepository(userId, dataFileGUID, dataFileGUIDParameterName, "DataFile", false, false, effectiveTime, methodName);
    }

    public FILE getDataFileByPathName(String userId, String pathName, String pathNameParameterName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return (FILE)this.fileHandler.getBeanByQualifiedName(userId, "10752b4a-4b5d-4519-9eae-fdd6d162122f", "DataFile", pathName, pathNameParameterName, methodName);
    }

    public List<FILE> findDataFileByPathName(String userId, String pathName, String pathNameParameterName, int startingFrom, int pageSize, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.fileHandler.findBeansByQualifiedName(userId, "10752b4a-4b5d-4519-9eae-fdd6d162122f", "DataFile", pathName, pathNameParameterName, false, false, startingFrom, pageSize, new Date(), methodName);
    }

    public List<FILE> findDataFilesByName(String userId, String name, String nameParameterName, int startingFrom, int pageSize, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.fileHandler.findAssetsByName(userId, "10752b4a-4b5d-4519-9eae-fdd6d162122f", "DataFile", name, nameParameterName, startingFrom, pageSize, null, methodName);
    }
}

