/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.generichandlers.GlossaryCategoryBuilder;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericConverter;
import org.odpi.openmetadata.commonservices.generichandlers.ReferenceableHandler;
import org.odpi.openmetadata.commonservices.generichandlers.ffdc.GenericHandlersErrorCode;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.metadatasecurity.server.OpenMetadataServerSecurityVerifier;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class GlossaryCategoryHandler<B>
extends ReferenceableHandler<B> {
    public GlossaryCategoryHandler(OpenMetadataAPIGenericConverter<B> converter, Class<B> beanClass, String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper, String localServerUserId, OpenMetadataServerSecurityVerifier securityVerifier, List<String> supportedZones, List<String> defaultZones, List<String> publishZones, AuditLog auditLog) {
        super(converter, beanClass, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
    }

    public String createGlossaryCategory(String userId, String glossaryGUID, String glossaryGUIDParameterName, String qualifiedName, String displayName, String description, Map<String, String> additionalProperties, String suppliedTypeName, Map<String, Object> extendedProperties, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(glossaryGUID, glossaryGUIDParameterName, methodName);
        String typeName = "GlossaryCategory";
        if (suppliedTypeName != null) {
            typeName = suppliedTypeName;
        }
        String typeGUID = this.invalidParameterHandler.validateTypeName(typeName, "GlossaryCategory", this.serviceName, methodName, this.repositoryHelper);
        GlossaryCategoryBuilder builder = new GlossaryCategoryBuilder(qualifiedName, displayName, description, additionalProperties, extendedProperties, this.repositoryHelper, this.serviceName, this.serverName);
        builder.setAnchors(userId, glossaryGUID, methodName);
        String glossaryCategoryGUID = this.createBeanInRepository(userId, null, null, typeGUID, typeName, qualifiedName, "qualifiedName", builder, methodName);
        if (glossaryCategoryGUID != null) {
            String glossaryCategoryGUIDParameterName = "glossaryCategoryGUID";
            this.linkElementToElement(userId, null, null, glossaryGUID, glossaryGUIDParameterName, "Glossary", glossaryCategoryGUID, "glossaryCategoryGUID", "GlossaryCategory", false, false, this.supportedZones, "c628938e-815e-47db-8d1c-59bb2e84e028", "CategoryAnchor", null, methodName);
        }
        return glossaryCategoryGUID;
    }

    public String createGlossaryCategoryFromTemplate(String userId, String templateGUID, String qualifiedName, String displayName, String description, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String templateGUIDParameterName = "templateGUID";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(templateGUID, "templateGUID", methodName);
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        GlossaryCategoryBuilder builder = new GlossaryCategoryBuilder(qualifiedName, displayName, description, this.repositoryHelper, this.serviceName, this.serverName);
        return this.createBeanFromTemplate(userId, null, null, templateGUID, "templateGUID", "e507485b-9b5a-44c9-8a28-6967f7ff3672", "GlossaryCategory", qualifiedName, "qualifiedName", builder, methodName);
    }

    public void updateGlossaryCategory(String userId, String glossaryCategoryGUID, String glossaryCategoryGUIDParameterName, String qualifiedName, String displayName, String description, Map<String, String> additionalProperties, String suppliedTypeName, Map<String, Object> extendedProperties, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(glossaryCategoryGUID, glossaryCategoryGUIDParameterName, methodName);
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        String typeName = "GlossaryCategory";
        if (suppliedTypeName != null) {
            typeName = suppliedTypeName;
        }
        String typeGUID = this.invalidParameterHandler.validateTypeName(typeName, "GlossaryCategory", this.serviceName, methodName, this.repositoryHelper);
        GlossaryCategoryBuilder builder = new GlossaryCategoryBuilder(qualifiedName, displayName, description, additionalProperties, extendedProperties, this.repositoryHelper, this.serviceName, this.serverName);
        this.updateBeanInRepository(userId, null, null, glossaryCategoryGUID, glossaryCategoryGUIDParameterName, typeGUID, typeName, false, false, this.supportedZones, builder.getInstanceProperties(methodName), false, new Date(), methodName);
    }

    public void setupCategoryParent(String userId, String glossaryParentCategoryGUID, String glossaryParentCategoryGUIDParameterName, String glossaryChildCategoryGUID, String glossaryChildCategoryGUIDParameterName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.linkElementToElement(userId, null, null, glossaryParentCategoryGUID, glossaryParentCategoryGUIDParameterName, "GlossaryCategory", glossaryChildCategoryGUID, glossaryChildCategoryGUIDParameterName, "GlossaryCategory", false, false, this.supportedZones, "71e4b6fb-3412-4193-aff3-a16eccd87e8e", "CategoryHierarchyLink", null, methodName);
    }

    public void clearCategoryParent(String userId, String glossaryParentCategoryGUID, String glossaryParentCategoryGUIDParameterName, String glossaryChildCategoryGUID, String glossaryChildCategoryGUIDParameterName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.unlinkElementFromElement(userId, false, null, null, glossaryParentCategoryGUID, glossaryParentCategoryGUIDParameterName, "GlossaryCategory", glossaryChildCategoryGUID, glossaryChildCategoryGUIDParameterName, "e507485b-9b5a-44c9-8a28-6967f7ff3672", "GlossaryCategory", false, false, "71e4b6fb-3412-4193-aff3-a16eccd87e8e", "CategoryHierarchyLink", null, methodName);
    }

    public void removeGlossaryCategory(String userId, String glossaryCategoryGUID, String glossaryCategoryGUIDParameterName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.deleteBeanInRepository(userId, null, null, glossaryCategoryGUID, glossaryCategoryGUIDParameterName, "e507485b-9b5a-44c9-8a28-6967f7ff3672", "GlossaryCategory", null, null, false, false, new Date(), methodName);
    }

    public List<B> findGlossaryCategories(String userId, String searchString, String searchStringParameterName, int startFrom, int pageSize, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.findBeans(userId, searchString, searchStringParameterName, "e507485b-9b5a-44c9-8a28-6967f7ff3672", "GlossaryCategory", null, startFrom, pageSize, effectiveTime, methodName);
    }

    public List<B> getCategoriesForGlossary(String userId, String glossaryGUID, String glossaryGUIDParameterName, int startFrom, int pageSize, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.getAttachedElements(userId, glossaryGUID, glossaryGUIDParameterName, "Glossary", "c628938e-815e-47db-8d1c-59bb2e84e028", "CategoryAnchor", "GlossaryCategory", startFrom, pageSize, null, methodName);
    }

    public List<B> getGlossaryCategoriesByName(String userId, String name, String nameParameterName, int startFrom, int pageSize, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateName(name, nameParameterName, methodName);
        ArrayList<String> specificMatchPropertyNames = new ArrayList<String>();
        specificMatchPropertyNames.add("qualifiedName");
        specificMatchPropertyNames.add("displayName");
        return this.getBeansByValue(userId, name, nameParameterName, "e507485b-9b5a-44c9-8a28-6967f7ff3672", "GlossaryCategory", specificMatchPropertyNames, true, null, null, false, false, this.supportedZones, null, startFrom, pageSize, null, methodName);
    }

    public B getGlossaryCategoryParent(String userId, String glossaryCategoryGUID, String glossaryCategoryGUIDParameterName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        List results = this.getAttachedElements(userId, glossaryCategoryGUID, glossaryCategoryGUIDParameterName, "GlossaryCategory", "71e4b6fb-3412-4193-aff3-a16eccd87e8e", "CategoryHierarchyLink", "GlossaryCategory", null, null, 1, false, false, 0, this.invalidParameterHandler.getMaxPagingSize(), null, methodName);
        if (results == null || results.isEmpty()) {
            return null;
        }
        if (results.size() == 1) {
            return results.get(0);
        }
        throw new PropertyServerException(GenericHandlersErrorCode.MULTIPLE_BEANS_FOUND.getMessageDefinition("GlossaryCategory", methodName, results.toString(), glossaryCategoryGUID, this.serviceName, this.serverName), this.getClass().getName(), methodName);
    }

    public List<B> getGlossarySubCategories(String userId, String glossaryCategoryGUID, String glossaryCategoryGUIDParameterName, int startFrom, int pageSize, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.getAttachedElements(userId, glossaryCategoryGUID, glossaryCategoryGUIDParameterName, "GlossaryCategory", "71e4b6fb-3412-4193-aff3-a16eccd87e8e", "CategoryHierarchyLink", "GlossaryCategory", null, null, 2, false, false, startFrom, pageSize, null, methodName);
    }

    public B getGlossaryCategoryByGUID(String userId, String guid, String guidParameterName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.getBeanFromRepository(userId, guid, guidParameterName, "GlossaryCategory", false, false, this.supportedZones, new Date(), methodName);
    }
}

