/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.generichandlers.AssetHandler;
import org.odpi.openmetadata.commonservices.generichandlers.ITInfrastructureBuilder;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericConverter;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.metadatasecurity.server.OpenMetadataServerSecurityVerifier;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class ITInfrastructureHandler<B>
extends AssetHandler<B> {
    public ITInfrastructureHandler(OpenMetadataAPIGenericConverter<B> converter, Class<B> beanClass, String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper, String localServerUserId, OpenMetadataServerSecurityVerifier securityVerifier, List<String> supportedZones, List<String> defaultZones, List<String> publishZones, AuditLog auditLog) {
        super(converter, beanClass, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
    }

    public void setupHostClusterMember(String userId, String externalSourceGUID, String externalSourceName, String hostClusterGUID, String hostClusterGUIDParameterName, String hostGUID, String hostGUIDParameterName, Date effectiveFrom, Date effectiveTo, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.linkElementToElement(userId, externalSourceGUID, externalSourceName, hostClusterGUID, hostClusterGUIDParameterName, "HostCluster", hostGUID, hostGUIDParameterName, "Host", false, false, this.supportedZones, "1a1c3933-a583-4b0c-9e42-c3691296a8e0", "HostClusterMember", this.setUpEffectiveDates(null, effectiveFrom, effectiveTo), methodName);
    }

    public void clearHostClusterMember(String userId, String externalSourceGUID, String externalSourceName, String hostClusterGUID, String hostClusterGUIDParameterName, String hostGUID, String hostGUIDParameterName, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.unlinkElementFromElement(userId, false, externalSourceGUID, externalSourceName, hostClusterGUID, hostClusterGUIDParameterName, "HostCluster", hostGUID, hostGUIDParameterName, "1abd16db-5b8a-4fd9-aee5-205db3febe99", "Host", false, false, "1a1c3933-a583-4b0c-9e42-c3691296a8e0", "HostClusterMember", effectiveTime, methodName);
    }

    public void setupHostDeployedVirtualContainer(String userId, String externalSourceGUID, String externalSourceName, String hostGUID, String hostGUIDParameterName, String virtualContainerGUID, String virtualContainerGUIDParameterName, Date effectiveFrom, Date effectiveTo, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.linkElementToElement(userId, externalSourceGUID, externalSourceName, hostGUID, hostGUIDParameterName, "Host", virtualContainerGUID, virtualContainerGUIDParameterName, "VirtualContainer", false, false, this.supportedZones, "4b981d89-e356-4d9b-8f17-b3a8d5a86676", "DeployedVirtualContainer", this.setUpEffectiveDates(null, effectiveFrom, effectiveTo), methodName);
    }

    public void clearHostDeployedVirtualContainer(String userId, String externalSourceGUID, String externalSourceName, String hostGUID, String hostGUIDParameterName, String virtualContainerGUID, String virtualContainerGUIDParameterName, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.unlinkElementFromElement(userId, false, externalSourceGUID, externalSourceName, hostGUID, hostGUIDParameterName, "Host", virtualContainerGUID, virtualContainerGUIDParameterName, "e2393236-100f-4ac0-a5e6-ce4e96c521e7", "VirtualContainer", false, false, "4b981d89-e356-4d9b-8f17-b3a8d5a86676", "DeployedVirtualContainer", effectiveTime, methodName);
    }

    public void setupSoftwareServerPlatformDeployment(String userId, String externalSourceGUID, String externalSourceName, String hostGUID, String hostGUIDParameterName, String softwareServerPlatformGUID, String softwareServerPlatformGUIDParameterName, Date deploymentTime, String deployer, int platformStatus, Date effectiveFrom, Date effectiveTo, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        ITInfrastructureBuilder builder = new ITInfrastructureBuilder(this.repositoryHelper, this.serviceName, this.serverName);
        InstanceProperties relationshipProperties = builder.getSoftwareServerPlatformDeploymentProperties(deploymentTime, deployer, platformStatus, methodName);
        this.linkElementToElement(userId, externalSourceGUID, externalSourceName, hostGUID, hostGUIDParameterName, "Host", softwareServerPlatformGUID, softwareServerPlatformGUIDParameterName, "SoftwareServerPlatform", false, false, this.supportedZones, "b909eb3b-5205-4180-9f63-122a65b30738", "SoftwareServerPlatformDeployment", this.setUpEffectiveDates(relationshipProperties, effectiveFrom, effectiveTo), methodName);
    }

    public void clearSoftwareServerPlatformDeployment(String userId, String externalSourceGUID, String externalSourceName, String hostGUID, String hostGUIDParameterName, String softwareServerPlatformGUID, String softwareServerPlatformGUIDParameterName, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.unlinkElementFromElement(userId, false, externalSourceGUID, externalSourceName, hostGUID, hostGUIDParameterName, "Host", softwareServerPlatformGUID, softwareServerPlatformGUIDParameterName, "ba7c7884-32ce-4991-9c41-9778f1fec6aa", "SoftwareServerPlatform", false, false, "b909eb3b-5205-4180-9f63-122a65b30738", "SoftwareServerPlatformDeployment", effectiveTime, methodName);
    }

    public void setupSoftwareServerDeployment(String userId, String externalSourceGUID, String externalSourceName, String softwareServerPlatformGUID, String softwareServerPlatformGUIDParameterName, String softwareServerGUID, String softwareServerGUIDParameterName, Date deploymentTime, String deployer, int serverStatus, Date effectiveFrom, Date effectiveTo, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        ITInfrastructureBuilder builder = new ITInfrastructureBuilder(this.repositoryHelper, this.serviceName, this.serverName);
        InstanceProperties relationshipProperties = builder.getSoftwareServerSupportedCapabilitiesProperties(deploymentTime, deployer, serverStatus, methodName);
        this.linkElementToElement(userId, externalSourceGUID, externalSourceName, softwareServerPlatformGUID, softwareServerPlatformGUIDParameterName, "SoftwareServerPlatform", softwareServerGUID, softwareServerGUIDParameterName, "SoftwareServer", false, false, this.supportedZones, "d909eb3b-5205-4180-9f63-122a65b30738", "SoftwareServerDeployment", this.setUpEffectiveDates(relationshipProperties, effectiveFrom, effectiveTo), methodName);
    }

    public void clearSoftwareServerDeployment(String userId, String externalSourceGUID, String externalSourceName, String softwareServerPlatformGUID, String softwareServerPlatformGUIDParameterName, String softwareServerGUID, String softwareServerGUIDParameterName, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.unlinkElementFromElement(userId, false, externalSourceGUID, externalSourceName, softwareServerPlatformGUID, softwareServerPlatformGUIDParameterName, "SoftwareServerPlatform", softwareServerGUID, softwareServerGUIDParameterName, "896d14c2-7522-4f6c-8519-757711943fe6", "SoftwareServer", false, false, "d909eb3b-5205-4180-9f63-122a65b30738", "SoftwareServerDeployment", effectiveTime, methodName);
    }

    public void setupSoftwareServerEndpoint(String userId, String externalSourceGUID, String externalSourceName, String softwareServerGUID, String softwareServerGUIDParameterName, String endpointGUID, String endpointGUIDParameterName, Date effectiveFrom, Date effectiveTo, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.linkElementToElement(userId, externalSourceGUID, externalSourceName, softwareServerGUID, softwareServerGUIDParameterName, "SoftwareServer", endpointGUID, endpointGUIDParameterName, "Endpoint", false, false, this.supportedZones, "2b8bfab4-8023-4611-9833-82a0dc95f187", "ServerEndpoint", this.setUpEffectiveDates(null, effectiveFrom, effectiveTo), methodName);
    }

    public void clearSoftwareServerEndpoint(String userId, String externalSourceGUID, String externalSourceName, String softwareServerGUID, String softwareServerGUIDParameterName, String endpointGUID, String endpointGUIDParameterName, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.unlinkElementFromElement(userId, false, externalSourceGUID, externalSourceName, softwareServerGUID, softwareServerGUIDParameterName, "SoftwareServer", endpointGUID, endpointGUIDParameterName, "dbc20663-d705-4ff0-8424-80c262c6b8e7", "Endpoint", false, false, "2b8bfab4-8023-4611-9833-82a0dc95f187", "ServerEndpoint", effectiveTime, methodName);
    }

    public void setupSoftwareServerSupportedCapability(String userId, String externalSourceGUID, String externalSourceName, String softwareServerGUID, String softwareServerGUIDParameterName, String softwareServerCapabilityGUID, String softwareServerCapabilityGUIDParameterName, Date deploymentTime, String deployer, int serverCapabilityStatus, Date effectiveFrom, Date effectiveTo, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        ITInfrastructureBuilder builder = new ITInfrastructureBuilder(this.repositoryHelper, this.serviceName, this.serverName);
        InstanceProperties relationshipProperties = builder.getSoftwareServerSupportedCapabilitiesProperties(deploymentTime, deployer, serverCapabilityStatus, methodName);
        this.linkElementToElement(userId, externalSourceGUID, externalSourceName, softwareServerGUID, softwareServerGUIDParameterName, "SoftwareServer", softwareServerCapabilityGUID, softwareServerCapabilityGUIDParameterName, "SoftwareServerCapability", false, false, this.supportedZones, "8b7d7da5-0668-4174-a43b-8f8c6c068dd0", "SoftwareServerSupportedCapability", this.setUpEffectiveDates(relationshipProperties, effectiveFrom, effectiveTo), methodName);
    }

    public void clearSoftwareServerSupportedCapability(String userId, String externalSourceGUID, String externalSourceName, String softwareServerGUID, String softwareServerGUIDParameterName, String softwareServerCapabilityGUID, String softwareServerCapabilityGUIDParameterName, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.unlinkElementFromElement(userId, false, externalSourceGUID, externalSourceName, softwareServerGUID, softwareServerGUIDParameterName, "SoftwareServer", softwareServerCapabilityGUID, softwareServerCapabilityGUIDParameterName, "fe30a033-8f86-4d17-8986-e6166fa24177", "SoftwareServerCapability", false, false, "8b7d7da5-0668-4174-a43b-8f8c6c068dd0", "SoftwareServerSupportedCapability", effectiveTime, methodName);
    }

    public void setupSoftwareServerCapabilityAssetUse(String userId, String externalSourceGUID, String externalSourceName, String softwareServerCapabilityGUID, String softwareServerCapabilityGUIDParameterName, String assetGUID, String assetGUIDParameterName, String description, int useType, Date effectiveFrom, Date effectiveTo, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        ITInfrastructureBuilder builder = new ITInfrastructureBuilder(this.repositoryHelper, this.serviceName, this.serverName);
        InstanceProperties relationshipProperties = builder.getSoftwareServerCapabilitiesAssetUseProperties(description, useType, methodName);
        this.linkElementToElement(userId, externalSourceGUID, externalSourceName, softwareServerCapabilityGUID, softwareServerCapabilityGUIDParameterName, "SoftwareServerCapability", assetGUID, assetGUIDParameterName, "Asset", false, false, this.supportedZones, "56315447-88a6-4235-ba91-fead86524ebf", "ServerAssetUse", this.setUpEffectiveDates(relationshipProperties, effectiveFrom, effectiveTo), methodName);
    }

    public void clearSoftwareServerCapabilityAssetUse(String userId, String externalSourceGUID, String externalSourceName, String softwareServerCapabilityGUID, String softwareServerCapabilityGUIDParameterName, String assetGUID, String assetGUIDParameterName, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.unlinkElementFromElement(userId, false, externalSourceGUID, externalSourceName, softwareServerCapabilityGUID, softwareServerCapabilityGUIDParameterName, "SoftwareServerCapability", assetGUID, assetGUIDParameterName, "896d14c2-7522-4f6c-8519-757711943fe6", "Asset", false, false, "56315447-88a6-4235-ba91-fead86524ebf", "ServerAssetUse", effectiveTime, methodName);
    }

    public void setupHostNetwork(String userId, String externalSourceGUID, String externalSourceName, String hostGUID, String hostGUIDParameterName, String networkGUID, String networkGUIDParameterName, Date effectiveFrom, Date effectiveTo, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.linkElementToElement(userId, externalSourceGUID, externalSourceName, hostGUID, hostGUIDParameterName, "Host", networkGUID, networkGUIDParameterName, "Network", false, false, this.supportedZones, "f2bd7401-c064-41ac-862c-e5bcdc98fa1e", "HostNetwork", this.setUpEffectiveDates(null, effectiveFrom, effectiveTo), methodName);
    }

    public void clearHostNetwork(String userId, String externalSourceGUID, String externalSourceName, String hostGUID, String hostGUIDParameterName, String networkGUID, String networkGUIDParameterName, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.unlinkElementFromElement(userId, false, externalSourceGUID, externalSourceName, hostGUID, hostGUIDParameterName, "Host", networkGUID, networkGUIDParameterName, "e0430f59-f021-411a-9d81-883e1ff3f6f6", "Network", false, false, "f2bd7401-c064-41ac-862c-e5bcdc98fa1e", "HostNetwork", effectiveTime, methodName);
    }

    public void setupNetworkGatewayLink(String userId, String externalSourceGUID, String externalSourceName, String networkGatewayGUID, String networkGatewayGUIDParameterName, String networkGUID, String networkGUIDParameterName, Date effectiveFrom, Date effectiveTo, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.linkElementToElement(userId, externalSourceGUID, externalSourceName, networkGatewayGUID, networkGatewayGUIDParameterName, "NetworkGateway", networkGUID, networkGUIDParameterName, "Network", false, false, this.supportedZones, "5bece460-1fa6-41fb-a29f-fdaf65ec8ce3", "NetworkGatewayLink", this.setUpEffectiveDates(null, effectiveFrom, effectiveTo), methodName);
    }

    public void clearNetworkGatewayLink(String userId, String externalSourceGUID, String externalSourceName, String networkGatewayGUID, String networkGatewayGUIDParameterName, String networkGUID, String networkGUIDParameterName, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.unlinkElementFromElement(userId, false, externalSourceGUID, externalSourceName, networkGatewayGUID, networkGatewayGUIDParameterName, "NetworkGateway", networkGUID, networkGUIDParameterName, "e0430f59-f021-411a-9d81-883e1ff3f6f6", "Network", false, false, "5bece460-1fa6-41fb-a29f-fdaf65ec8ce3", "NetworkGatewayLink", effectiveTime, methodName);
    }

    public void addCloudProviderClassification(String userId, String hostGUID, String hostGUIDParameterName, String providerName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(hostGUID, hostGUIDParameterName, methodName);
        ITInfrastructureBuilder builder = new ITInfrastructureBuilder(this.repositoryHelper, this.serviceName, this.serverName);
        this.setClassificationInRepository(userId, hostGUID, hostGUIDParameterName, "Host", "a2bfdd08-d0a8-49db-bc97-7f240628104", "CloudProvider", builder.getCloudProviderProperties(providerName, methodName), methodName);
    }

    public void removeCloudProviderClassification(String userId, String hostGUID, String hostGUIDParameterName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.removeClassificationFromRepository(userId, hostGUID, hostGUIDParameterName, "Host", "a2bfdd08-d0a8-49db-bc97-7f240628104", "CloudProvider", methodName);
    }

    public void addCloudPlatformClassification(String userId, String softwareServerPlatformGUID, String softwareServerPlatformGUIDParameterName, String implementationType, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(softwareServerPlatformGUID, softwareServerPlatformGUIDParameterName, methodName);
        ITInfrastructureBuilder builder = new ITInfrastructureBuilder(this.repositoryHelper, this.serviceName, this.serverName);
        this.setClassificationInRepository(userId, softwareServerPlatformGUID, softwareServerPlatformGUIDParameterName, "SoftwareServerPlatform", "1b8f8511-e606-4f65-86d3-84891706ad12", "CloudPlatform", builder.getCloudPlatformProperties(implementationType, methodName), methodName);
    }

    public void removeCloudPlatformClassification(String userId, String softwareServerPlatformGUID, String softwareServerPlatformParameterName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.removeClassificationFromRepository(userId, softwareServerPlatformGUID, softwareServerPlatformParameterName, "SoftwareServerPlatform", "1b8f8511-e606-4f65-86d3-84891706ad12", "CloudPlatform", methodName);
    }

    public void addCloudTenantClassification(String userId, String softwareServerGUID, String softwareServerGUIDParameterName, String tenantName, String tenantType, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(softwareServerGUID, softwareServerGUIDParameterName, methodName);
        ITInfrastructureBuilder builder = new ITInfrastructureBuilder(this.repositoryHelper, this.serviceName, this.serverName);
        this.setClassificationInRepository(userId, softwareServerGUID, softwareServerGUIDParameterName, "SoftwareServer", "1b8f8522-e606-4f65-86d3-84891706ad12", "CloudTenant", builder.getCloudTenantProperties(tenantName, tenantType, methodName), methodName);
    }

    public void removeCloudTenantClassification(String userId, String softwareServerGUID, String softwareServerGUIDParameterName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.removeClassificationFromRepository(userId, softwareServerGUID, softwareServerGUIDParameterName, "SoftwareServer", "1b8f8522-e606-4f65-86d3-84891706ad12", "CloudTenant", methodName);
    }

    public void addCloudServiceClassification(String userId, String softwareServerCapabilityGUID, String softwareServerCapabilityGUIDParameterName, String offeringName, String serviceType, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(softwareServerCapabilityGUID, softwareServerCapabilityGUIDParameterName, methodName);
        ITInfrastructureBuilder builder = new ITInfrastructureBuilder(this.repositoryHelper, this.serviceName, this.serverName);
        this.setClassificationInRepository(userId, softwareServerCapabilityGUID, softwareServerCapabilityGUIDParameterName, "SoftwareServerCapability", "337e7b1a-ad4b-4818-aa3e-0ff3307b2fbe6", "CloudService", builder.getCloudServiceProperties(offeringName, serviceType, methodName), methodName);
    }

    public void removeCloudServiceClassification(String userId, String softwareServerCapabilityGUID, String softwareServerCapabilityGUIDParameterName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.removeClassificationFromRepository(userId, softwareServerCapabilityGUID, softwareServerCapabilityGUIDParameterName, "SoftwareServerCapability", "337e7b1a-ad4b-4818-aa3e-0ff3307b2fbe6", "CloudService", methodName);
    }
}

