/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericConverter;
import org.odpi.openmetadata.commonservices.generichandlers.SchemaAttributeBuilder;
import org.odpi.openmetadata.commonservices.generichandlers.SchemaElementHandler;
import org.odpi.openmetadata.commonservices.generichandlers.SchemaTypeBuilder;
import org.odpi.openmetadata.commonservices.generichandlers.SchemaTypeHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.metadatasecurity.server.OpenMetadataServerSecurityVerifier;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntitySummary;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.ClassificationErrorException;

public class SchemaAttributeHandler<SCHEMA_ATTRIBUTE, SCHEMA_TYPE>
extends SchemaElementHandler<SCHEMA_ATTRIBUTE> {
    private OpenMetadataAPIGenericConverter<SCHEMA_ATTRIBUTE> schemaAttributeConverter;
    private Class<SCHEMA_TYPE> schemaTypeBeanClass;
    private SchemaTypeHandler<SCHEMA_TYPE> schemaTypeHandler;

    public SchemaAttributeHandler(OpenMetadataAPIGenericConverter<SCHEMA_ATTRIBUTE> schemaAttributeConverter, Class<SCHEMA_ATTRIBUTE> schemaAttributeBeanClass, OpenMetadataAPIGenericConverter<SCHEMA_TYPE> schemaTypeConverter, Class<SCHEMA_TYPE> schemaTypeBeanClass, String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper, String localServerUserId, OpenMetadataServerSecurityVerifier securityVerifier, List<String> supportedZones, List<String> defaultZones, List<String> publishZones, AuditLog auditLog) {
        super(schemaAttributeConverter, schemaAttributeBeanClass, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
        this.schemaAttributeConverter = schemaAttributeConverter;
        this.schemaTypeBeanClass = schemaTypeBeanClass;
        this.schemaTypeHandler = new SchemaTypeHandler<SCHEMA_TYPE>(schemaTypeConverter, schemaTypeBeanClass, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
    }

    public String createSchemaAttributeFromTemplate(String userId, String externalSourceGUID, String externalSourceName, String parentElementGUID, String parentElementGUIDParameterName, String templateGUID, String qualifiedName, String displayName, String description, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String templateGUIDParameterName = "templateGUID";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(parentElementGUID, parentElementGUIDParameterName, methodName);
        this.invalidParameterHandler.validateGUID(templateGUID, "templateGUID", methodName);
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        Date effectiveTime = new Date();
        SchemaAttributeBuilder builder = new SchemaAttributeBuilder(qualifiedName, displayName, description, this.repositoryHelper, this.serviceName, this.serverName);
        String schemaAttributeGUID = this.createBeanFromTemplate(userId, externalSourceGUID, externalSourceName, templateGUID, "templateGUID", "1a5e159b-913a-43b1-95fe-04433b25fca9", "SchemaAttribute", qualifiedName, "qualifiedName", builder, methodName);
        if (schemaAttributeGUID != null) {
            String schemaAttributeGUIDParameterName = "schemaAttributeGUID";
            EntityDetail parentEntity = this.getEntityFromRepository(userId, parentElementGUID, parentElementGUIDParameterName, "SchemaElement", null, null, false, false, this.supportedZones, effectiveTime, methodName);
            String parentElementTypeName = "SchemaType";
            String parentElementRelationshipTypeGUID = "86b176a2-015c-44a6-8106-54d5d69ba661";
            String parentElementRelationshipTypeName = "AttributeForSchema";
            if (parentEntity != null && parentEntity.getType() != null && this.repositoryHelper.isTypeOf(this.serviceName, parentEntity.getType().getTypeDefName(), "SchemaAttribute")) {
                parentElementTypeName = "SchemaAttribute";
                parentElementRelationshipTypeGUID = "0ffb9d87-7074-45da-a9b0-ae0859611133";
                parentElementRelationshipTypeName = "NestedSchemaAttribute";
            }
            this.linkElementToElement(userId, externalSourceGUID, externalSourceName, parentElementGUID, parentElementGUIDParameterName, parentElementTypeName, schemaAttributeGUID, "schemaAttributeGUID", builder.getTypeName(), false, false, this.supportedZones, parentElementRelationshipTypeGUID, parentElementRelationshipTypeName, null, methodName);
        }
        return schemaAttributeGUID;
    }

    public String createNestedSchemaAttribute(String userId, String externalSourceGUID, String externalSourceName, String parentElementGUID, String parentElementGUIDParameterName, String qualifiedName, String qualifiedNameParameterName, SchemaAttributeBuilder schemaAttributeBuilder, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(parentElementGUID, parentElementGUIDParameterName, methodName);
        this.invalidParameterHandler.validateName(qualifiedName, qualifiedNameParameterName, methodName);
        EntityDetail parentEntity = this.getEntityFromRepository(userId, parentElementGUID, parentElementGUIDParameterName, "SchemaElement", null, null, false, false, this.supportedZones, null, methodName);
        String parentAttributeTypeName = "ComplexSchemaType";
        String parentAttributeRelationshipTypeGUID = "86b176a2-015c-44a6-8106-54d5d69ba661";
        String parentAttributeRelationshipTypeName = "AttributeForSchema";
        if (parentEntity != null && parentEntity.getType() != null) {
            String anchorGUID;
            if (this.repositoryHelper.isTypeOf(this.serviceName, parentEntity.getType().getTypeDefName(), "SchemaAttribute")) {
                parentAttributeTypeName = "SchemaAttribute";
                parentAttributeRelationshipTypeGUID = "0ffb9d87-7074-45da-a9b0-ae0859611133";
                parentAttributeRelationshipTypeName = "NestedSchemaAttribute";
            }
            if ((anchorGUID = this.getAnchorGUIDFromAnchorsClassification(parentEntity, methodName)) != null) {
                schemaAttributeBuilder.setAnchors(userId, anchorGUID, methodName);
            }
            return this.createNestedSchemaAttribute(userId, externalSourceGUID, externalSourceName, parentElementGUID, parentElementGUIDParameterName, parentAttributeTypeName, parentAttributeRelationshipTypeGUID, parentAttributeRelationshipTypeName, qualifiedName, qualifiedNameParameterName, schemaAttributeBuilder, methodName);
        }
        this.invalidParameterHandler.throwUnknownElement(userId, parentElementGUID, "SchemaElement", this.serviceName, this.serverName, methodName);
        return null;
    }

    public String createNestedSchemaAttribute(String userId, String externalSourceGUID, String externalSourceName, String parentElementGUID, String parentElementGUIDParameterName, String qualifiedName, String qualifiedNameParameterName, String displayName, String description, String externalSchemaTypeGUID, String dataType, String defaultValue, String fixedValue, String validValuesSetGUID, String formula, boolean isDeprecated, int elementPosition, int minCardinality, int maxCardinality, boolean allowsDuplicateValues, boolean orderedValues, String defaultValueOverride, int sortOrder, int minimumLength, int length, int significantDigits, boolean isNullable, String nativeJavaClass, List<String> aliases, Map<String, String> additionalProperties, String typeName, Map<String, Object> extendedProperties, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(parentElementGUID, parentElementGUIDParameterName, methodName);
        this.invalidParameterHandler.validateName(qualifiedName, qualifiedNameParameterName, methodName);
        String schemaAttributeTypeName = "SchemaAttribute";
        String schemaAttributeTypeId = "1a5e159b-913a-43b1-95fe-04433b25fca9";
        if (typeName != null) {
            schemaAttributeTypeName = typeName;
            schemaAttributeTypeId = this.invalidParameterHandler.validateTypeName(typeName, "SchemaAttribute", this.serviceName, methodName, this.repositoryHelper);
        }
        SchemaAttributeBuilder schemaAttributeBuilder = new SchemaAttributeBuilder(qualifiedName, displayName, description, elementPosition, minCardinality, maxCardinality, isDeprecated, defaultValueOverride, allowsDuplicateValues, orderedValues, sortOrder, minimumLength, length, significantDigits, isNullable, nativeJavaClass, aliases, additionalProperties, schemaAttributeTypeId, schemaAttributeTypeName, extendedProperties, this.repositoryHelper, this.serviceName, this.serverName);
        if (formula != null) {
            schemaAttributeBuilder.setCalculatedValue(userId, externalSourceGUID, externalSourceName, formula, methodName);
        }
        SchemaTypeBuilder schemaTypeBuilder = this.getSchemaTypeBuilder(qualifiedName, externalSchemaTypeGUID, dataType, defaultValue, fixedValue, validValuesSetGUID);
        schemaAttributeBuilder.setSchemaType(userId, schemaTypeBuilder, methodName);
        return this.createNestedSchemaAttribute(userId, externalSourceGUID, externalSourceName, parentElementGUID, parentElementGUIDParameterName, qualifiedName, qualifiedNameParameterName, schemaAttributeBuilder, methodName);
    }

    SchemaTypeBuilder getSchemaTypeBuilder(String qualifiedName, String externalSchemaTypeGUID, String dataType, String defaultValue, String fixedValue, String validValuesSetGUID) {
        String schemaTypeGUID = "a13b409f-fd67-4506-8d94-14dfafd250a4";
        String schemaTypeName = "StructSchemaType";
        if (externalSchemaTypeGUID != null) {
            schemaTypeGUID = "78de00ea-3d69-47ff-a6d6-767587526624";
            schemaTypeName = "ExternalSchemaType";
        } else if (validValuesSetGUID != null) {
            schemaTypeGUID = "24b092ac-42e9-43dc-aeca-eb034ce307d9";
            schemaTypeName = "EnumSchemaType";
        } else if (fixedValue != null) {
            schemaTypeGUID = "520ebb91-c4eb-4d46-a3b1-974875cdcf0d";
            schemaTypeName = "LiteralSchemaType";
        } else if (dataType != null) {
            schemaTypeGUID = "f0f75fba-9136-4082-8352-0ad74f3c36ed";
            schemaTypeName = "PrimitiveSchemaType";
        }
        SchemaTypeBuilder schemaTypeBuilder = new SchemaTypeBuilder(qualifiedName + ":Type", schemaTypeGUID, schemaTypeName, this.repositoryHelper, this.serviceName, this.serverName);
        schemaTypeBuilder.setDataType(dataType);
        schemaTypeBuilder.setDefaultValue(defaultValue);
        schemaTypeBuilder.setFixedValue(fixedValue);
        schemaTypeBuilder.setExternalSchemaTypeGUID(externalSchemaTypeGUID);
        schemaTypeBuilder.setValidValuesSetGUID(validValuesSetGUID);
        return schemaTypeBuilder;
    }

    public String createNestedSchemaAttribute(String userId, String externalSourceGUID, String externalSourceName, String parentElementGUID, String parentElementGUIDParameterName, String parentElementTypeName, String parentAttributeRelationshipTypeGUID, String parentAttributeRelationshipTypeName, String qualifiedName, String qualifiedNameParameterName, SchemaAttributeBuilder schemaAttributeBuilder, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(parentElementGUID, parentElementGUIDParameterName, methodName);
        this.invalidParameterHandler.validateName(qualifiedName, qualifiedNameParameterName, methodName);
        String schemaAttributeGUID = this.createBeanInRepository(userId, externalSourceGUID, externalSourceName, schemaAttributeBuilder.getTypeGUID(), schemaAttributeBuilder.getTypeName(), qualifiedName, "qualifiedName", schemaAttributeBuilder, methodName);
        if (schemaAttributeGUID != null) {
            String schemaAttributeGUIDParameterName = "schemaAttributeGUID";
            this.addEmbeddedTypes(userId, externalSourceGUID, externalSourceName, schemaAttributeGUID, "schemaAttributeGUID", schemaAttributeBuilder.getTypeName(), schemaAttributeBuilder.getSchemaTypeBuilder(), methodName);
            this.linkElementToElement(userId, externalSourceGUID, externalSourceName, parentElementGUID, parentElementGUIDParameterName, parentElementTypeName, schemaAttributeGUID, "schemaAttributeGUID", schemaAttributeBuilder.getTypeName(), false, false, this.supportedZones, parentAttributeRelationshipTypeGUID, parentAttributeRelationshipTypeName, null, methodName);
            return schemaAttributeGUID;
        }
        return null;
    }

    public List<SCHEMA_ATTRIBUTE> getSchemaAttributesForComplexSchemaType(String userId, String schemaTypeGUID, String guidParameterName, String requiredClassificationName, String omittedClassificationName, int startFrom, int pageSize, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getSchemaAttributesForComplexSchemaType(userId, schemaTypeGUID, guidParameterName, "SchemaAttribute", requiredClassificationName, omittedClassificationName, this.supportedZones, startFrom, pageSize, methodName);
    }

    public List<SCHEMA_ATTRIBUTE> getSchemaAttributesForComplexSchemaType(String userId, String schemaTypeGUID, String schemaTypeGUIDParameterName, String schemaAttributeTypeName, String requiredClassificationName, String omittedClassificationName, List<String> serviceSupportedZones, int startFrom, int pageSize, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String schemaAttributeGUIDParameterName = "schemaAttributeEntity.getGUID()";
        String typeName = "SchemaAttribute";
        if (schemaAttributeTypeName != null) {
            typeName = schemaAttributeTypeName;
        }
        List<EntityDetail> entities = this.getAttachedEntities(userId, schemaTypeGUID, schemaTypeGUIDParameterName, "SchemaType", "86b176a2-015c-44a6-8106-54d5d69ba661", "AttributeForSchema", typeName, requiredClassificationName, omittedClassificationName, false, false, serviceSupportedZones, startFrom, pageSize, new Date(), methodName);
        ArrayList<SCHEMA_ATTRIBUTE> results = new ArrayList<SCHEMA_ATTRIBUTE>();
        if (entities != null) {
            for (EntityDetail schemaAttributeEntity : entities) {
                if (schemaAttributeEntity == null) continue;
                results.add(this.getSchemaAttributeFromEntity(userId, schemaAttributeEntity.getGUID(), "schemaAttributeEntity.getGUID()", schemaAttributeEntity, methodName));
            }
        }
        if (results.isEmpty()) {
            return null;
        }
        return results;
    }

    public List<SCHEMA_ATTRIBUTE> getAttachedSchemaAttributes(String userId, String parentElementGUID, String parentElementGUIDParameterName, String schemaAttributeTypeName, int startFrom, int pageSize, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        EntityDetail parentEntity = this.getEntityFromRepository(userId, parentElementGUID, parentElementGUIDParameterName, "SchemaElement", null, null, false, false, this.supportedZones, null, methodName);
        if (parentEntity != null && parentEntity.getType() != null) {
            if (this.repositoryHelper.isTypeOf(this.serviceName, parentEntity.getType().getTypeDefName(), "SchemaAttribute")) {
                return this.getNestedSchemaAttributes(userId, parentElementGUID, parentElementGUIDParameterName, schemaAttributeTypeName, this.supportedZones, startFrom, pageSize, methodName);
            }
            return this.getSchemaAttributesForComplexSchemaType(userId, parentElementGUID, parentElementGUIDParameterName, schemaAttributeTypeName, null, null, this.supportedZones, startFrom, pageSize, methodName);
        }
        return null;
    }

    public List<SCHEMA_ATTRIBUTE> getNestedSchemaAttributes(String userId, String schemaAttributeGUID, String schemaAttributeGUIDParameterName, int startFrom, int pageSize, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getNestedSchemaAttributes(userId, schemaAttributeGUID, schemaAttributeGUIDParameterName, "SchemaAttribute", this.supportedZones, startFrom, pageSize, methodName);
    }

    public List<SCHEMA_ATTRIBUTE> getNestedSchemaAttributes(String userId, String schemaAttributeGUID, String schemaAttributeGUIDParameterName, String schemaAttributeTypeName, List<String> serviceSupportedZones, int startFrom, int pageSize, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String nestedSchemaAttributeGUIDParameterName = "schemaAttributeEntity.getGUID()";
        String resultTypeName = "SchemaAttribute";
        if (schemaAttributeTypeName != null) {
            resultTypeName = schemaAttributeTypeName;
        }
        List<EntityDetail> entities = this.getAttachedEntities(userId, schemaAttributeGUID, schemaAttributeGUIDParameterName, "SchemaAttribute", "0ffb9d87-7074-45da-a9b0-ae0859611133", "NestedSchemaAttribute", resultTypeName, null, null, false, false, serviceSupportedZones, startFrom, pageSize, new Date(), methodName);
        ArrayList<SCHEMA_ATTRIBUTE> results = new ArrayList<SCHEMA_ATTRIBUTE>();
        if (entities != null) {
            for (EntityDetail schemaAttributeEntity : entities) {
                if (schemaAttributeEntity == null) continue;
                results.add(this.getSchemaAttributeFromEntity(userId, schemaAttributeEntity.getGUID(), "schemaAttributeEntity.getGUID()", schemaAttributeEntity, methodName));
            }
        } else {
            EntityDetail entity = this.getAttachedEntity(userId, schemaAttributeGUID, schemaAttributeGUIDParameterName, "SchemaAttribute", "2d955049-e59b-45dd-8e62-cde1add59f9e", "SchemaAttributeType", "SchemaAttribute", false, false, this.supportedZones, null, methodName);
            if (entity != null) {
                String schemaTypeGUIDParameterName = "schemaTypeGUID";
                return this.getSchemaAttributesForComplexSchemaType(userId, entity.getGUID(), schemaTypeGUIDParameterName, schemaAttributeTypeName, null, null, this.supportedZones, startFrom, pageSize, methodName);
            }
        }
        if (results.isEmpty()) {
            return null;
        }
        return results;
    }

    private List<Relationship> getSchemaAttributeRelationships(String userId, EntityDetail schemaAttributeEntity, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String schemaAttributeGUIDParameterName = "schemaAttributeEntity";
        ArrayList<Relationship> results = new ArrayList<Relationship>();
        List<Relationship> relationships = this.getAttachmentLinks(userId, schemaAttributeEntity.getGUID(), "schemaAttributeEntity", "SchemaAttribute", null, null, "SchemaAttribute", 0, this.invalidParameterHandler.getMaxPagingSize(), null, methodName);
        if (relationships != null) {
            for (Relationship relationship : relationships) {
                if (relationship == null || relationship.getType() == null) continue;
                String typeName = relationship.getType().getTypeDefName();
                if ("ForeignKey".equals(typeName)) {
                    results.add(relationship);
                    continue;
                }
                if (!"GraphEdgeLink".equals(typeName)) continue;
                results.add(relationship);
            }
        }
        if (results.isEmpty()) {
            return null;
        }
        return results;
    }

    private SCHEMA_ATTRIBUTE getSchemaAttributeFromEntity(String userId, String schemaAttributeGUID, String schemaAttributeGUIDParameterName, EntityDetail schemaAttributeEntity, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        if (schemaAttributeEntity != null && schemaAttributeEntity.getType() != null) {
            Object schemaType = null;
            try {
                Classification typeClassification = this.repositoryHelper.getClassificationFromEntity(this.serviceName, (EntitySummary)schemaAttributeEntity, "TypeEmbeddedAttribute", methodName);
                if (typeClassification != null && typeClassification.getProperties() != null) {
                    String schemaTypeName = this.repositoryHelper.getStringProperty(this.serviceName, "schemaTypeName", typeClassification.getProperties(), methodName);
                    schemaType = this.schemaTypeHandler.getSchemaTypeFromInstance(userId, (InstanceHeader)schemaAttributeEntity, schemaTypeName, typeClassification.getProperties(), schemaAttributeEntity.getClassifications(), null, methodName);
                }
            }
            catch (ClassificationErrorException typeClassification) {
                // empty catch block
            }
            if (schemaType == null) {
                schemaType = this.schemaTypeHandler.getSchemaTypeForParent(userId, schemaAttributeGUID, schemaAttributeGUIDParameterName, "SchemaAttribute", "2d955049-e59b-45dd-8e62-cde1add59f9e", "SchemaAttributeType", null, methodName);
            }
            List<Relationship> attributeRelationships = this.getSchemaAttributeRelationships(userId, schemaAttributeEntity, methodName);
            return this.schemaAttributeConverter.getNewSchemaAttributeBean(this.beanClass, schemaAttributeEntity, this.schemaTypeBeanClass, schemaType, attributeRelationships, methodName);
        }
        return null;
    }

    private List<SCHEMA_ATTRIBUTE> getSchemaAttributesFromEntities(String userId, List<EntityDetail> schemaAttributeEntities, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String parameterName = "schemaAttributeEntities";
        if (schemaAttributeEntities != null) {
            ArrayList<SCHEMA_ATTRIBUTE> schemaAttributes = new ArrayList<SCHEMA_ATTRIBUTE>();
            for (EntityDetail entity : schemaAttributeEntities) {
                if (entity == null) continue;
                schemaAttributes.add(this.getSchemaAttributeFromEntity(userId, entity.getGUID(), "schemaAttributeEntities", entity, methodName));
            }
            if (!schemaAttributes.isEmpty()) {
                return schemaAttributes;
            }
        }
        return null;
    }

    public SCHEMA_ATTRIBUTE getSchemaAttribute(String userId, String schemaAttributeGUID, String schemaAttributeGUIDParameterName, String expectedTypeName, String requiredClassificationName, String omittedClassificationName, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String typeParameterName = "expectedTypeName";
        this.invalidParameterHandler.validateGUID(schemaAttributeGUID, schemaAttributeGUIDParameterName, methodName);
        this.invalidParameterHandler.validateName(expectedTypeName, "expectedTypeName", methodName);
        EntityDetail schemaAttributeEntity = this.getEntityFromRepository(userId, schemaAttributeGUID, schemaAttributeGUIDParameterName, expectedTypeName, requiredClassificationName, omittedClassificationName, false, false, this.supportedZones, null, methodName);
        return this.getSchemaAttributeFromEntity(userId, schemaAttributeGUID, schemaAttributeGUIDParameterName, schemaAttributeEntity, methodName);
    }

    public List<SCHEMA_ATTRIBUTE> getSchemaAttributesByName(String userId, String typeGUID, String typeName, String name, String requiredClassificationName, String omittedClassificationName, int elementStart, int maxElements, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getSchemaAttributesByName(userId, typeGUID, typeName, name, requiredClassificationName, omittedClassificationName, this.supportedZones, elementStart, maxElements, methodName);
    }

    public List<SCHEMA_ATTRIBUTE> getSchemaAttributesByName(String userId, String typeGUID, String typeName, String name, String requiredClassificationName, String omittedClassificationName, List<String> serviceSupportedZones, int startFrom, int pageSize, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String nameParameterName = "name";
        ArrayList<String> specificMatchPropertyNames = new ArrayList<String>();
        specificMatchPropertyNames.add("qualifiedName");
        specificMatchPropertyNames.add("displayName");
        List<EntityDetail> schemaAttributeEntities = this.getEntitiesByValue(userId, name, "name", typeGUID, typeName, specificMatchPropertyNames, true, requiredClassificationName, omittedClassificationName, false, false, serviceSupportedZones, null, startFrom, pageSize, new Date(), methodName);
        return this.getSchemaAttributesFromEntities(userId, schemaAttributeEntities, methodName);
    }

    public List<SCHEMA_ATTRIBUTE> findSchemaAttributes(String userId, String searchString, String searchStringParameterName, String resultTypeGUID, String resultTypeName, String requiredClassificationName, String omittedClassificationName, int startFrom, int pageSize, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        List<EntityDetail> schemaAttributeEntities = this.findEntities(userId, searchString, searchStringParameterName, resultTypeGUID, resultTypeName, requiredClassificationName, omittedClassificationName, null, startFrom, pageSize, null, methodName);
        return this.getSchemaAttributesFromEntities(userId, schemaAttributeEntities, methodName);
    }

    public void updateSchemaAttribute(String userId, String externalSourceGUID, String externalSourceName, String schemaAttributeGUID, String schemaAttributeGUIDParameterName, String qualifiedName, String qualifiedNameParameterName, String displayName, String description, boolean isDeprecated, int elementPosition, int minCardinality, int maxCardinality, boolean allowsDuplicateValues, boolean orderedValues, String defaultValueOverride, int sortOrder, int minimumLength, int length, int significantDigits, boolean isNullable, String nativeJavaClass, List<String> aliases, Map<String, String> additionalProperties, Map<String, Object> extendedProperties, boolean isMergeUpdate, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(schemaAttributeGUID, schemaAttributeGUIDParameterName, methodName);
        if (!isMergeUpdate) {
            this.invalidParameterHandler.validateName(qualifiedName, qualifiedNameParameterName, methodName);
        }
        SchemaAttributeBuilder schemaAttributeBuilder = new SchemaAttributeBuilder(qualifiedName, displayName, description, elementPosition, minCardinality, maxCardinality, isDeprecated, defaultValueOverride, allowsDuplicateValues, orderedValues, sortOrder, minimumLength, length, significantDigits, isNullable, nativeJavaClass, aliases, additionalProperties, "1a5e159b-913a-43b1-95fe-04433b25fca9", "SchemaAttribute", extendedProperties, this.repositoryHelper, this.serviceName, this.serverName);
        this.updateSchemaAttribute(userId, externalSourceGUID, externalSourceName, schemaAttributeGUID, schemaAttributeGUIDParameterName, schemaAttributeBuilder.getInstanceProperties(methodName), isMergeUpdate, methodName);
    }

    public void updateSchemaAttribute(String userId, String externalSourceGUID, String externalSourceName, String schemaAttributeGUID, InstanceProperties instanceProperties) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "updateSchemaAttribute";
        String parameterName = "schemaAttributeGUID";
        this.updateBeanInRepository(userId, externalSourceGUID, externalSourceName, schemaAttributeGUID, "schemaAttributeGUID", "1a5e159b-913a-43b1-95fe-04433b25fca9", "SchemaAttribute", false, false, this.supportedZones, instanceProperties, true, this.getEffectiveTime(instanceProperties), "updateSchemaAttribute");
    }

    public void updateSchemaAttribute(String userId, String externalSourceGUID, String externalSourceName, String schemaAttributeGUID, String schemaAttributeGUIDParameterName, InstanceProperties instanceProperties, boolean isMergeUpdate, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.updateBeanInRepository(userId, externalSourceGUID, externalSourceName, schemaAttributeGUID, schemaAttributeGUIDParameterName, "1a5e159b-913a-43b1-95fe-04433b25fca9", "SchemaAttribute", false, false, this.supportedZones, instanceProperties, isMergeUpdate, this.getEffectiveTime(instanceProperties), methodName);
    }

    public void removeSchemaTypes(String userId, String externalSourceGUID, String externalSourceName, String schemaAttributeGUID, String schemaAttributeGUIDParameterName, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
    }
}

