/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.util.Map;
import org.odpi.openmetadata.commonservices.generichandlers.ReferenceableBuilder;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.ClassificationOrigin;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProvenanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeErrorException;

public class SoftwareServerCapabilityBuilder
extends ReferenceableBuilder {
    private String displayName;
    private String description;
    private String type;
    private String version;
    private String patchLevel;
    private String source;

    public SoftwareServerCapabilityBuilder(String qualifiedName, String displayName, String description, String type, String version, String patchLevel, String source, Map<String, String> additionalProperties, String typeId, String typeName, Map<String, Object> extendedProperties, OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(qualifiedName, additionalProperties, typeId, typeName, extendedProperties, repositoryHelper, serviceName, serverName);
        this.displayName = displayName;
        this.description = description;
        this.type = type;
        this.version = version;
        this.patchLevel = patchLevel;
        this.source = source;
    }

    public SoftwareServerCapabilityBuilder(OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(repositoryHelper, serviceName, serverName);
        this.displayName = null;
        this.description = null;
        this.type = null;
        this.version = null;
        this.patchLevel = null;
        this.source = null;
    }

    void setCapabilityTypeClassification(String userId, String classificationName, String methodName) throws InvalidParameterException {
        try {
            Classification classification = this.repositoryHelper.getNewClassification(this.serviceName, null, null, InstanceProvenanceType.LOCAL_COHORT, userId, classificationName, this.typeName, ClassificationOrigin.ASSIGNED, null, null);
            this.newClassifications.put(classification.getName(), classification);
        }
        catch (TypeErrorException error) {
            this.errorHandler.handleUnsupportedType((Exception)((Object)error), methodName, "LatestChange");
        }
    }

    void setFileSystemClassification(String userId, String format, String encryption, String methodName) throws InvalidParameterException {
        InstanceProperties properties = null;
        if (format != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, "format", format, methodName);
        }
        if (encryption != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "encryption", encryption, methodName);
        }
        super.setEffectivityDates(properties);
        try {
            Classification classification = this.repositoryHelper.getNewClassification(this.serviceName, null, null, InstanceProvenanceType.LOCAL_COHORT, userId, "FileSystem", this.typeName, ClassificationOrigin.ASSIGNED, null, properties);
            this.newClassifications.put(classification.getName(), classification);
        }
        catch (TypeErrorException error) {
            this.errorHandler.handleUnsupportedType((Exception)((Object)error), methodName, "LatestChange");
        }
    }

    @Override
    public InstanceProperties getInstanceProperties(String methodName) throws InvalidParameterException {
        InstanceProperties properties = super.getInstanceProperties(methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "name", this.displayName, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "description", this.description, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "deployedImplementationType", this.type, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "capabilityVersion", this.version, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "patchLevel", this.patchLevel, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "source", this.source, methodName);
        return properties;
    }
}

