/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericConverter;
import org.odpi.openmetadata.commonservices.generichandlers.ReferenceableHandler;
import org.odpi.openmetadata.commonservices.generichandlers.SchemaTypeBuilder;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.metadatasecurity.server.OpenMetadataServerSecurityVerifier;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class EventTypeHandler<B>
extends ReferenceableHandler<B> {
    public EventTypeHandler(OpenMetadataAPIGenericConverter<B> converter, Class<B> beanClass, String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper, String localServerUserId, OpenMetadataServerSecurityVerifier securityVerifier, List<String> supportedZones, List<String> defaultZones, List<String> publishZones, AuditLog auditLog) {
        super(converter, beanClass, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
    }

    public String createEventType(String userId, String externalSourceGUID, String externalSourceName, String topicGUID, String topicGUIDParameterName, String qualifiedName, String displayName, String description, String versionNumber, boolean isDeprecated, String author, String usage, String encodingStandard, String namespace, Map<String, String> additionalProperties, String suppliedTypeName, Map<String, Object> extendedProperties, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(topicGUID, topicGUIDParameterName, methodName);
        String typeName = "EventType";
        if (suppliedTypeName != null) {
            typeName = suppliedTypeName;
        }
        String typeGUID = this.invalidParameterHandler.validateTypeName(typeName, "EventType", this.serviceName, methodName, this.repositoryHelper);
        String eventTypeListGUIDParameterName = "eventTypeListGUID";
        String eventTypeListGUID = this.getEventTypeListGUID(userId, externalSourceGUID, externalSourceName, topicGUID, topicGUIDParameterName, qualifiedName, methodName);
        SchemaTypeBuilder builder = new SchemaTypeBuilder(qualifiedName, displayName, description, versionNumber, isDeprecated, author, usage, encodingStandard, namespace, additionalProperties, typeGUID, typeName, extendedProperties, this.repositoryHelper, this.serviceName, this.serverName);
        builder.setAnchors(userId, topicGUID, methodName);
        String eventTypeGUID = this.createBeanInRepository(userId, externalSourceGUID, externalSourceName, typeGUID, typeName, qualifiedName, "qualifiedName", builder, methodName);
        if (eventTypeGUID != null) {
            String eventTypeGUIDParameterName = "eventTypeGUID";
            this.linkElementToElement(userId, externalSourceGUID, externalSourceName, eventTypeListGUID, "eventTypeListGUID", "EventTypeList", eventTypeGUID, "eventTypeGUID", "EventType", false, false, this.supportedZones, "eb4f1f98-c649-4560-8a46-da17c02764a9", "SchemaTypeOption", null, methodName);
        }
        return eventTypeGUID;
    }

    public String createEventTypeFromTemplate(String userId, String externalSourceGUID, String externalSourceName, String topicGUID, String topicGUIDParameterName, String templateGUID, String qualifiedName, String displayName, String description, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String templateGUIDParameterName = "templateGUID";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(templateGUID, "templateGUID", methodName);
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        String eventTypeListGUIDParameterName = "eventTypeListGUID";
        String eventTypeListGUID = this.getEventTypeListGUID(userId, externalSourceGUID, externalSourceName, topicGUID, topicGUIDParameterName, qualifiedName, methodName);
        SchemaTypeBuilder builder = new SchemaTypeBuilder(qualifiedName, displayName, description, this.repositoryHelper, this.serviceName, this.serverName);
        String eventTypeGUID = this.createBeanFromTemplate(userId, externalSourceGUID, externalSourceName, templateGUID, "templateGUID", "8bc88aba-d7e4-4334-957f-cfe8e8eadc32", "EventType", qualifiedName, "qualifiedName", builder, methodName);
        String eventTypeGUIDParameterName = "eventTypeGUID";
        this.linkElementToElement(userId, externalSourceGUID, externalSourceName, eventTypeListGUID, "eventTypeListGUID", "EventTypeList", eventTypeGUID, "eventTypeGUID", "EventType", false, false, this.supportedZones, "eb4f1f98-c649-4560-8a46-da17c02764a9", "SchemaTypeOption", null, methodName);
        return eventTypeGUID;
    }

    public void updateEventType(String userId, String externalSourceGUID, String externalSourceName, String eventTypeGUID, String eventTypeGUIDParameterName, String qualifiedName, String displayName, String description, String versionNumber, boolean isDeprecated, String author, String usage, String encodingStandard, String namespace, Map<String, String> additionalProperties, String suppliedTypeName, Map<String, Object> extendedProperties, boolean isMergeUpdate, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(eventTypeGUID, eventTypeGUIDParameterName, methodName);
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        String typeName = "EventType";
        if (suppliedTypeName != null) {
            typeName = suppliedTypeName;
        }
        String typeGUID = this.invalidParameterHandler.validateTypeName(typeName, "EventType", this.serviceName, methodName, this.repositoryHelper);
        SchemaTypeBuilder builder = new SchemaTypeBuilder(qualifiedName, displayName, description, versionNumber, isDeprecated, author, usage, encodingStandard, namespace, additionalProperties, typeGUID, typeName, extendedProperties, this.repositoryHelper, this.serviceName, this.serverName);
        this.updateBeanInRepository(userId, externalSourceGUID, externalSourceName, eventTypeGUID, eventTypeGUIDParameterName, typeGUID, typeName, false, false, this.supportedZones, builder.getInstanceProperties(methodName), isMergeUpdate, null, methodName);
    }

    public void removeEventType(String userId, String externalSourceGUID, String externalSourceName, String eventTypeGUID, String eventTypeGUIDParameterName, String qualifiedName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.deleteBeanInRepository(userId, externalSourceGUID, externalSourceName, eventTypeGUID, eventTypeGUIDParameterName, "8bc88aba-d7e4-4334-957f-cfe8e8eadc32", "EventType", "qualifiedName", qualifiedName, false, false, null, methodName);
    }

    public List<B> findEventTypes(String userId, String searchString, String searchStringParameterName, int startFrom, int pageSize, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.findBeans(userId, searchString, searchStringParameterName, "8bc88aba-d7e4-4334-957f-cfe8e8eadc32", "EventType", null, startFrom, pageSize, effectiveTime, methodName);
    }

    public List<B> getEventTypesForEventSet(String userId, String eventSetGUID, String eventSetGUIDParameterName, int startFrom, int pageSize, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.getAttachedElements(userId, eventSetGUID, eventSetGUIDParameterName, "EventSet", "5cabb76a-e25b-4bb5-8b93-768bbac005af", "CollectionMembership", "EventType", startFrom, pageSize, effectiveTime, methodName);
    }

    public List<B> getEventTypesByName(String userId, String name, String nameParameterName, int startFrom, int pageSize, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateName(name, nameParameterName, methodName);
        ArrayList<String> specificMatchPropertyNames = new ArrayList<String>();
        specificMatchPropertyNames.add("qualifiedName");
        specificMatchPropertyNames.add("displayName");
        return this.getBeansByValue(userId, name, nameParameterName, "8bc88aba-d7e4-4334-957f-cfe8e8eadc32", "EventType", specificMatchPropertyNames, true, null, null, false, false, this.supportedZones, null, startFrom, pageSize, effectiveTime, methodName);
    }

    public List<B> getEventTypesForTopic(String userId, String topicGUID, String topicGUIDParameterName, int startFrom, int pageSize, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        Date effectiveTime = new Date();
        EntityDetail eventTypeListEntity = this.getAttachedEntity(userId, topicGUID, topicGUIDParameterName, "Topic", "815b004d-73c6-4728-9dd9-536f4fe803cd", "AssetSchemaType", "EventTypeList", false, false, this.supportedZones, effectiveTime, methodName);
        if (eventTypeListEntity != null) {
            String eventTypeListGUIDParameterName = "eventTypeListGUID";
            return this.getAttachedElements(userId, eventTypeListEntity.getGUID(), "eventTypeListGUID", "EventTypeList", "eb4f1f98-c649-4560-8a46-da17c02764a9", "SchemaTypeOption", "EventType", null, null, 2, false, false, startFrom, pageSize, effectiveTime, methodName);
        }
        return null;
    }

    private String getEventTypeListGUID(String userId, String externalSourceGUID, String externalSourceName, String topicGUID, String topicGUIDParameterName, String topicQualifiedName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String eventTypeListGUID;
        EntityDetail eventListEntity = this.getAttachedEntity(userId, topicGUID, topicGUIDParameterName, "Topic", "815b004d-73c6-4728-9dd9-536f4fe803cd", "AssetSchemaType", "EventTypeList", false, false, this.supportedZones, new Date(), methodName);
        if (eventListEntity == null) {
            SchemaTypeBuilder builder = new SchemaTypeBuilder(topicQualifiedName + "_EventList", "77ccda3d-c4c6-464c-a424-4b2cb27ac06c", "EventTypeList", this.repositoryHelper, this.serviceName, this.serverName);
            builder.setAnchors(userId, topicGUID, methodName);
            eventTypeListGUID = this.repositoryHandler.createEntity(userId, "77ccda3d-c4c6-464c-a424-4b2cb27ac06c", "EventTypeList", externalSourceGUID, externalSourceName, builder.getInstanceProperties(methodName), builder.getEntityClassifications(), builder.getInstanceStatus(), methodName);
            if (eventTypeListGUID != null) {
                String eventTypeListGUIDParameterName = "eventTypeListGUID";
                this.linkElementToElement(userId, externalSourceGUID, externalSourceName, topicGUID, topicGUIDParameterName, "Topic", eventTypeListGUID, "eventTypeListGUID", "EventTypeList", false, false, this.supportedZones, "815b004d-73c6-4728-9dd9-536f4fe803cd", "AssetSchemaType", null, methodName);
            } else {
                this.errorHandler.logNullInstance("EventTypeList", methodName);
            }
        } else {
            eventTypeListGUID = eventListEntity.getGUID();
        }
        return eventTypeListGUID;
    }

    public B getEventTypeByGUID(String userId, String guid, String guidParameterName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.getBeanFromRepository(userId, guid, guidParameterName, "EventType", false, false, this.supportedZones, new Date(), methodName);
    }
}

