/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.generichandlers.ExternalIdentifierBuilder;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericConverter;
import org.odpi.openmetadata.commonservices.generichandlers.ReferenceableHandler;
import org.odpi.openmetadata.commonservices.generichandlers.ffdc.GenericHandlersAuditCode;
import org.odpi.openmetadata.commonservices.generichandlers.ffdc.GenericHandlersErrorCode;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryIteratorForEntities;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryRelatedEntitiesIterator;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.metadatasecurity.server.OpenMetadataServerSecurityVerifier;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class ExternalIdentifierHandler<EXTERNAL_ID, OPEN_METADATA_ELEMENT_HEADER>
extends ReferenceableHandler<EXTERNAL_ID> {
    private OpenMetadataAPIGenericConverter<OPEN_METADATA_ELEMENT_HEADER> elementConverter;
    private Class<OPEN_METADATA_ELEMENT_HEADER> elementBeanClass;

    public ExternalIdentifierHandler(OpenMetadataAPIGenericConverter<EXTERNAL_ID> converter, Class<EXTERNAL_ID> beanClass, OpenMetadataAPIGenericConverter<OPEN_METADATA_ELEMENT_HEADER> elementConverter, Class<OPEN_METADATA_ELEMENT_HEADER> elementBeanClass, String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper, String localServerUserId, OpenMetadataServerSecurityVerifier securityVerifier, List<String> supportedZones, List<String> defaultZones, List<String> publishZones, AuditLog auditLog) {
        super(converter, beanClass, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
        this.elementConverter = elementConverter;
        this.elementBeanClass = elementBeanClass;
    }

    public void setUpExternalIdentifier(String userId, String elementGUID, String elementGUIDParameterName, String elementTypeName, String identifier, String identifierParameterName, int identifierKeyPattern, String identifierDescription, String identifierUsage, String identifierSource, Map<String, String> identifierMappingProperties, String scopeGUID, String scopeGUIDParameterName, String scopeQualifiedName, String scopeTypeName, int permittedSynchronization, String synchronizationDescription, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String externalIdGUID;
        String externalIdGUIDParameterName = "externalIdGUID";
        EntityDetail externalIdEntity = this.getExternalIdEntity(userId, identifier, identifierParameterName, scopeGUID, scopeGUIDParameterName, scopeQualifiedName, scopeTypeName, effectiveTime, methodName);
        if (externalIdEntity == null) {
            externalIdGUID = this.createExternalIdentifier(userId, identifier, identifierKeyPattern, scopeGUID, scopeGUIDParameterName, scopeTypeName, permittedSynchronization, synchronizationDescription, methodName);
            this.auditLog.logMessage(methodName, GenericHandlersAuditCode.SETTING_UP_EXTERNAL_ID.getMessageDefinition(this.serviceName, elementTypeName, elementGUID, identifier, scopeQualifiedName, scopeGUID, methodName));
        } else {
            externalIdGUID = externalIdEntity.getGUID();
            this.updateExternalIdentifier(userId, externalIdGUID, "externalIdGUID", identifier, identifierKeyPattern, methodName);
        }
        Relationship resourceLink = this.getResourceLinkRelationship(userId, elementGUID, elementGUIDParameterName, elementTypeName, externalIdGUID, effectiveTime, methodName);
        if (resourceLink == null) {
            this.createExternalIdLink(userId, elementGUID, elementGUIDParameterName, elementTypeName, externalIdGUID, "externalIdGUID", identifierDescription, identifierUsage, identifierSource, identifierMappingProperties, methodName);
        } else {
            this.updateExternalIdLink(userId, resourceLink, identifierDescription, identifierUsage, identifierSource, identifierMappingProperties, methodName);
        }
    }

    public void logRelationshipCreation(String scopeGUID, String scopeQualifiedName, String relationshipType, String end1GUID, String end1TypeName, String end2GUID, String end2TypeName, String methodName) {
        if (scopeGUID != null) {
            this.auditLog.logMessage(methodName, GenericHandlersAuditCode.NEW_EXTERNAL_RELATIONSHIP.getMessageDefinition(this.serviceName, relationshipType, end1TypeName, end1GUID, end2TypeName, end2GUID, methodName, scopeGUID, scopeQualifiedName));
        }
    }

    public void logRelationshipRemoval(String scopeGUID, String scopeQualifiedName, String relationshipType, String end1GUID, String end1TypeName, String end2GUID, String end2TypeName, String methodName) {
        if (scopeGUID != null) {
            this.auditLog.logMessage(methodName, GenericHandlersAuditCode.EXTERNAL_RELATIONSHIP_REMOVED.getMessageDefinition(this.serviceName, relationshipType, end1TypeName, end1GUID, end2TypeName, end2GUID, methodName, scopeGUID, scopeQualifiedName));
        }
    }

    public void removeExternalIdentifier(String userId, String elementGUID, String elementGUIDParameterName, String elementTypeName, String identifier, String identifierParameterName, int identifierKeyPattern, String identifierDescription, String identifierUsage, String identifierSource, Map<String, String> identifierMappingProperties, String scopeGUID, String scopeGUIDParameterName, String scopeQualifiedName, String scopeTypeName, int permittedSynchronization, String synchronizationDescription, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
    }

    public EntityDetail confirmSynchronization(String userId, String elementGUID, String elementGUIDParameterName, String elementTypeName, String identifier, String identifierParameterName, String scopeGUID, String scopeGUIDParameterName, String scopeQualifiedName, String scopeTypeName, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateGUID(elementGUID, elementGUIDParameterName, methodName);
        this.invalidParameterHandler.validateGUID(scopeGUID, scopeGUIDParameterName, methodName);
        this.invalidParameterHandler.validateName(identifier, identifierParameterName, methodName);
        EntityDetail externalIdEntity = this.getExternalIdEntity(userId, identifier, identifierParameterName, scopeGUID, scopeGUIDParameterName, scopeQualifiedName, scopeTypeName, effectiveTime, methodName);
        if (externalIdEntity == null) {
            throw new InvalidParameterException(GenericHandlersErrorCode.UNKNOWN_EXTERNAL_IDENTITY.getMessageDefinition(this.serviceName, identifier, scopeQualifiedName, scopeGUID, elementTypeName, elementGUID), this.getClass().getName(), methodName, identifierParameterName);
        }
        Relationship resourceLink = this.getResourceLinkRelationship(userId, elementGUID, elementGUIDParameterName, elementTypeName, externalIdEntity.getGUID(), effectiveTime, methodName);
        if (resourceLink == null) {
            throw new InvalidParameterException(GenericHandlersErrorCode.UNKNOWN_RESOURCE_LINK.getMessageDefinition(this.serviceName, identifier, scopeQualifiedName, scopeGUID, elementTypeName, elementGUID), this.getClass().getName(), methodName, identifierParameterName);
        }
        InstanceProperties newProperties = resourceLink.getProperties() == null ? this.repositoryHelper.addDatePropertyToInstance(this.serviceName, null, "lastSynchronized", new Date(), methodName) : this.repositoryHelper.addDatePropertyToInstance(this.serviceName, new InstanceProperties(resourceLink.getProperties()), "lastSynchronized", new Date(), methodName);
        this.repositoryHandler.updateRelationshipProperties(userId, null, null, resourceLink, newProperties, methodName);
        return externalIdEntity;
    }

    private EntityDetail getExternalIdEntity(String userId, String identifier, String identifierParameterName, String scopeGUID, String scopeGUIDParameterName, String scopeQualifiedName, String scopeTypeName, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateGUID(scopeGUID, scopeGUIDParameterName, methodName);
        this.invalidParameterHandler.validateName(identifier, identifierParameterName, methodName);
        ArrayList<String> propertyNames = new ArrayList<String>();
        propertyNames.add("identifier");
        int queryPageSize = this.invalidParameterHandler.getMaxPagingSize();
        RepositoryIteratorForEntities identifierIterator = this.getEntitySearchIterator(userId, identifier, "7c8f8c2c-cc48-429e-8a21-a1f1851ccdb0", "ExternalId", propertyNames, true, null, false, false, 0, queryPageSize, effectiveTime, methodName);
        while (identifierIterator.moreToReceive()) {
            EntityDetail externalIdEntity = identifierIterator.getNext();
            if (!this.validateExternalIdentifierScope(userId, identifier, externalIdEntity, scopeGUID, scopeQualifiedName, scopeTypeName, effectiveTime, methodName)) continue;
            return externalIdEntity;
        }
        return null;
    }

    private Relationship getResourceLinkRelationship(String userId, String elementGUID, String elementGUIDParameterName, String elementTypeName, String externalIdGUID, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateGUID(elementGUID, elementGUIDParameterName, methodName);
        List<Relationship> resourceLinks = this.getAttachmentLinks(userId, elementGUID, elementGUIDParameterName, elementTypeName, "28ab0381-c662-4b6d-b787-5d77208de126", "ExternalIdLink", externalIdGUID, "ExternalId", 0, this.invalidParameterHandler.getMaxPagingSize(), effectiveTime, methodName);
        if (resourceLinks != null) {
            for (Relationship relationship : resourceLinks) {
                if (relationship == null || relationship.getEntityOneProxy() == null || !elementGUID.equals(relationship.getEntityOneProxy().getGUID())) continue;
                return relationship;
            }
        }
        return null;
    }

    private boolean validateExternalIdentifierScope(String userId, String identifier, EntityDetail externalIdEntity, String scopeGUID, String scopeQualifiedName, String scopeTypeName, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String externalIdGUIDParameterName = "externalIdEntity.getGUID()";
        if (externalIdEntity != null && externalIdEntity.getType() != null) {
            List<Relationship> externalIdScopes = this.getAttachmentLinks(userId, externalIdEntity.getGUID(), "externalIdEntity.getGUID()", "ExternalId", "8c5b1415-2d1f-4190-ba6c-1fdd47f03269", "ExternalIdScope", scopeGUID, scopeTypeName, 0, this.invalidParameterHandler.getMaxPagingSize(), effectiveTime, methodName);
            return externalIdScopes != null;
        }
        throw new PropertyServerException(GenericHandlersErrorCode.NULL_EXTERNAL_ID_ENTITY.getMessageDefinition(identifier, scopeTypeName, scopeQualifiedName, scopeGUID), this.getClass().getName(), methodName);
    }

    private String createExternalIdentifier(String userId, String identifier, int identifierKeyPattern, String scopeGUID, String scopeGUIDParameterName, String scopeTypeName, int permittedSynchronization, String synchronizationDescription, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String externalIdGUIDParameterName = "externalIdentifierGUID";
        ExternalIdentifierBuilder builder = new ExternalIdentifierBuilder(identifier, identifierKeyPattern, this.repositoryHelper, this.serviceName, this.serverName);
        builder.setAnchors(userId, scopeGUID, methodName);
        String externalIdGUID = this.createBeanInRepository(userId, null, null, "7c8f8c2c-cc48-429e-8a21-a1f1851ccdb0", "ExternalId", null, null, builder, methodName);
        if (externalIdGUID != null) {
            InstanceProperties scopeProperties = builder.getExternalIdScopeProperties(synchronizationDescription, permittedSynchronization, methodName);
            this.linkElementToElement(userId, null, null, scopeGUID, scopeGUIDParameterName, scopeTypeName, externalIdGUID, "externalIdentifierGUID", "ExternalId", false, false, this.supportedZones, "8c5b1415-2d1f-4190-ba6c-1fdd47f03269", "ExternalIdScope", scopeProperties, methodName);
        }
        return externalIdGUID;
    }

    private void updateExternalIdentifier(String userId, String externalIdGUID, String externalIdGUIDParameterName, String identifier, int identifierKeyPattern, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        ExternalIdentifierBuilder builder = new ExternalIdentifierBuilder(identifier, identifierKeyPattern, this.repositoryHelper, this.serviceName, this.serverName);
        this.updateBeanInRepository(userId, null, null, externalIdGUID, externalIdGUIDParameterName, "7c8f8c2c-cc48-429e-8a21-a1f1851ccdb0", "ExternalId", false, false, this.supportedZones, builder.getInstanceProperties(methodName), true, new Date(), methodName);
    }

    private void createExternalIdLink(String userId, String elementGUID, String elementGUIDParameterName, String elementTypeName, String externalIdGUID, String externalIdGUIDParameterName, String identifierDescription, String identifierUsage, String identifierSource, Map<String, String> identifierMappingProperties, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        ExternalIdentifierBuilder builder = new ExternalIdentifierBuilder(this.repositoryHelper, this.serviceName, this.serverName);
        InstanceProperties resourceLinkProperties = builder.getExternalIdResourceLinkProperties(identifierDescription, identifierUsage, identifierSource, identifierMappingProperties, methodName);
        this.linkElementToElement(userId, null, null, elementGUID, elementGUIDParameterName, elementTypeName, externalIdGUID, externalIdGUIDParameterName, "ExternalId", false, false, this.supportedZones, "28ab0381-c662-4b6d-b787-5d77208de126", "ExternalIdLink", resourceLinkProperties, methodName);
    }

    private void updateExternalIdLink(String userId, Relationship externalIdLink, String identifierDescription, String identifierUsage, String identifierSource, Map<String, String> identifierMappingProperties, String methodName) throws UserNotAuthorizedException, PropertyServerException {
        InstanceProperties existingProperties;
        ExternalIdentifierBuilder builder = new ExternalIdentifierBuilder(this.repositoryHelper, this.serviceName, this.serverName);
        if (externalIdLink != null && (this.propertyUpdateNeeded(identifierDescription, "description", existingProperties = externalIdLink.getProperties(), methodName) || this.propertyUpdateNeeded(identifierUsage, "usage", existingProperties, methodName) || this.propertyUpdateNeeded(identifierSource, "source", existingProperties, methodName))) {
            InstanceProperties properties = builder.getExternalIdResourceLinkProperties(identifierDescription, identifierUsage, identifierSource, identifierMappingProperties, methodName);
            this.repositoryHandler.updateRelationshipProperties(userId, null, null, externalIdLink, properties, methodName);
        }
    }

    private boolean propertyUpdateNeeded(String newValue, String propertyName, InstanceProperties existingProperties, String methodName) {
        String existingValue = this.repositoryHelper.getStringProperty(this.serviceName, propertyName, existingProperties, methodName);
        if (existingValue == null && newValue == null) {
            return false;
        }
        if (existingValue == null) {
            return true;
        }
        return !existingValue.equals(newValue);
    }

    private void updateScopeProperties(String userId, Relationship externalIdScope, int permittedSynchronization, String synchronizationDescription, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        ExternalIdentifierBuilder builder = new ExternalIdentifierBuilder(this.repositoryHelper, this.serviceName, this.serverName);
        InstanceProperties properties = builder.getExternalIdScopeProperties(synchronizationDescription, permittedSynchronization, methodName);
        this.repositoryHandler.updateRelationshipProperties(userId, null, null, externalIdScope, properties, methodName);
    }

    public int countExternalIdentifiers(String userId, String elementGUID, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return super.countAttachments(userId, elementGUID, "Referenceable", "28ab0381-c662-4b6d-b787-5d77208de126", "ExternalIdLink", effectiveTime, methodName);
    }

    public List<EXTERNAL_ID> getExternalIdentifiersForElement(String userId, String elementGUID, String elementGUIDParameterName, String elementTypeName, List<String> serviceSupportedZones, int startingFrom, int pageSize, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getExternalIdentifiersForScope(userId, elementGUID, elementGUIDParameterName, elementTypeName, serviceSupportedZones, null, "Referenceable", null, startingFrom, pageSize, effectiveTime, methodName);
    }

    public List<EXTERNAL_ID> getExternalIdentifiersForScope(String userId, String elementGUID, String elementGUIDParameterName, String elementTypeName, String scopeGUID, String scopeTypeName, String scopeQualifiedName, int startingFrom, int pageSize, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getExternalIdentifiersForScope(userId, elementGUID, elementGUIDParameterName, elementTypeName, this.supportedZones, scopeGUID, scopeTypeName, scopeQualifiedName, startingFrom, pageSize, effectiveTime, methodName);
    }

    public List<EXTERNAL_ID> getExternalIdentifiersForScope(String userId, String elementGUID, String elementGUIDParameterName, String elementTypeName, List<String> serviceSupportedZones, String scopeGUID, String scopeTypeName, String scopeQualifiedName, int startingFrom, int pageSize, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.invalidParameterHandler.validateGUID(elementGUID, elementGUIDParameterName, methodName);
        ArrayList results = new ArrayList();
        List<Relationship> externalIdLinks = this.getAttachmentLinks(userId, elementGUID, elementGUIDParameterName, elementTypeName, "28ab0381-c662-4b6d-b787-5d77208de126", "ExternalIdLink", null, "ExternalId", 0, false, startingFrom, pageSize, effectiveTime, methodName);
        if (externalIdLinks != null) {
            for (Relationship externalIdLink : externalIdLinks) {
                List<Relationship> externalIdScopes;
                if (externalIdLink == null || externalIdLink.getEntityTwoProxy() == null) continue;
                String externalIdGUIDParameterName = "externalIdLink.getEntityTwoProxy().getGUID()";
                String externalIdGUID = externalIdLink.getEntityTwoProxy().getGUID();
                EntityDetail externalIdEntity = this.getEntityFromRepository(userId, externalIdGUID, "externalIdLink.getEntityTwoProxy().getGUID()", "ExternalId", null, null, false, false, serviceSupportedZones, effectiveTime, methodName);
                if (externalIdEntity == null || externalIdEntity.getType() == null || (externalIdScopes = this.getAttachmentLinks(userId, externalIdGUID, "externalIdLink.getEntityTwoProxy().getGUID()", "ExternalId", "8c5b1415-2d1f-4190-ba6c-1fdd47f03269", "ExternalIdScope", null, scopeTypeName, 0, false, startingFrom, pageSize, effectiveTime, methodName)) == null) continue;
                for (Relationship externalIdScope : externalIdScopes) {
                    if (externalIdScope == null || externalIdScope.getEntityOneProxy() == null || scopeGUID != null && !scopeGUID.equals(externalIdScope.getEntityOneProxy().getGUID())) continue;
                    ArrayList<Relationship> externalIdRelationships = new ArrayList<Relationship>();
                    externalIdRelationships.add(externalIdLink);
                    externalIdRelationships.add(externalIdScope);
                    Object bean = this.converter.getNewComplexBean(this.beanClass, externalIdEntity, externalIdRelationships, methodName);
                    if (bean == null) continue;
                    results.add(bean);
                }
            }
        }
        if (results.isEmpty()) {
            return null;
        }
        return results;
    }

    public List<EntityDetail> getElementEntitiesForScope(String userId, String scopeGUID, String scopeParameterName, String scopeTypeName, String requestedTypeName, int startingFrom, int pageSize, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String requestedTypeNameParameterName = "requestedTypeName";
        this.invalidParameterHandler.validateGUID(scopeGUID, scopeParameterName, methodName);
        this.invalidParameterHandler.validateName(requestedTypeName, "requestedTypeName", methodName);
        int queryPageSize = this.invalidParameterHandler.validatePaging(startingFrom, pageSize, methodName);
        RepositoryRelatedEntitiesIterator externalIdIterator = new RepositoryRelatedEntitiesIterator(this.repositoryHandler, userId, scopeGUID, scopeTypeName, "8c5b1415-2d1f-4190-ba6c-1fdd47f03269", "ExternalIdScope", null, false, false, 0, 0, effectiveTime, methodName);
        int skippedResults = 0;
        ArrayList<EntityDetail> results = new ArrayList<EntityDetail>();
        while (externalIdIterator.moreToReceive() && (queryPageSize == 0 || results.size() < queryPageSize)) {
            EntityDetail externalIdEntity = externalIdIterator.getNext();
            if (externalIdEntity == null) continue;
            RepositoryRelatedEntitiesIterator elementIterator = new RepositoryRelatedEntitiesIterator(this.repositoryHandler, userId, externalIdEntity.getGUID(), "ExternalId", "28ab0381-c662-4b6d-b787-5d77208de126", "ExternalIdLink", null, false, false, 0, 0, effectiveTime, methodName);
            while (externalIdIterator.moreToReceive() && (queryPageSize == 0 || results.size() < queryPageSize)) {
                EntityDetail elementEntity = elementIterator.getNext();
                if (elementEntity == null || elementEntity.getType() == null || !this.repositoryHelper.isTypeOf(this.serviceName, elementEntity.getType().getTypeDefName(), requestedTypeName)) continue;
                if (skippedResults < startingFrom) {
                    ++skippedResults;
                    continue;
                }
                results.add(elementEntity);
            }
        }
        if (results.isEmpty()) {
            return null;
        }
        return results;
    }

    public List<OPEN_METADATA_ELEMENT_HEADER> getElementsForExternalIdentifier(String userId, String scopeGUID, String scopeParameterName, String scopeTypeName, String scopeQualifiedName, String externalIdentifier, int startingFrom, int pageSize, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String externalIdentifierParameterName = "externalIdentifier";
        this.invalidParameterHandler.validateGUID(scopeGUID, scopeParameterName, methodName);
        this.invalidParameterHandler.validateName(externalIdentifier, "externalIdentifier", methodName);
        ArrayList<String> propertyNames = new ArrayList<String>();
        propertyNames.add("identifier");
        List<EntityDetail> matchingExternalIds = this.getEntitiesByValue(userId, externalIdentifier, "externalIdentifier", "7c8f8c2c-cc48-429e-8a21-a1f1851ccdb0", "ExternalId", propertyNames, true, null, null, false, false, this.supportedZones, null, 0, this.invalidParameterHandler.getMaxPagingSize(), effectiveTime, methodName);
        if (matchingExternalIds != null) {
            String matchingEntityGUIDParameterName = "matchingEntity.getGUID()";
            for (EntityDetail matchingEntity : matchingExternalIds) {
                List<Relationship> externalIdRelationships;
                if (matchingEntity == null || (externalIdRelationships = this.getAttachmentLinks(userId, scopeGUID, scopeParameterName, scopeTypeName, "8c5b1415-2d1f-4190-ba6c-1fdd47f03269", "ExternalIdScope", scopeGUID, "ExternalId", 0, this.invalidParameterHandler.getMaxPagingSize(), effectiveTime, methodName)) == null || !externalIdRelationships.isEmpty()) continue;
                return this.getElementHeaders(userId, matchingEntity.getGUID(), "matchingEntity.getGUID()", startingFrom, pageSize, effectiveTime, methodName);
            }
        }
        return null;
    }

    private List<OPEN_METADATA_ELEMENT_HEADER> getElementHeaders(String userId, String externalIdGUID, String externalIdGUIDParameterName, int startingFrom, int pageSize, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateGUID(externalIdGUID, externalIdGUIDParameterName, methodName);
        this.invalidParameterHandler.validateName(externalIdGUID, externalIdGUIDParameterName, methodName);
        List<EntityDetail> elementEntities = this.getAttachedEntities(userId, externalIdGUID, externalIdGUIDParameterName, "ExternalId", "28ab0381-c662-4b6d-b787-5d77208de126", "ExternalIdLink", "Referenceable", null, null, 0, false, false, this.supportedZones, startingFrom, pageSize, effectiveTime, methodName);
        ArrayList<OPEN_METADATA_ELEMENT_HEADER> results = new ArrayList<OPEN_METADATA_ELEMENT_HEADER>();
        if (elementEntities != null) {
            for (EntityDetail elementEntity : elementEntities) {
                OPEN_METADATA_ELEMENT_HEADER bean;
                if (elementEntity == null || (bean = this.elementConverter.getNewBean(this.elementBeanClass, elementEntity, methodName)) == null) continue;
                results.add(bean);
            }
        }
        if (results.isEmpty()) {
            return null;
        }
        return results;
    }
}

