/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.generichandlers.GovernanceActionBuilder;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericConverter;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericHandler;
import org.odpi.openmetadata.commonservices.generichandlers.ffdc.GenericHandlersErrorCode;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryEntitiesIterator;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryRelationshipsIterator;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositorySelectedEntitiesIterator;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.OCFCheckedExceptionBase;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.governanceaction.properties.GovernanceActionStatus;
import org.odpi.openmetadata.frameworks.governanceaction.properties.NewActionTarget;
import org.odpi.openmetadata.metadatasecurity.server.OpenMetadataServerSecurityVerifier;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.MatchCriteria;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EnumPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeErrorException;

public class GovernanceActionHandler<B>
extends OpenMetadataAPIGenericHandler<B> {
    public GovernanceActionHandler(OpenMetadataAPIGenericConverter<B> converter, Class<B> beanClass, String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper, String localServerUserId, OpenMetadataServerSecurityVerifier securityVerifier, List<String> supportedZones, List<String> defaultZones, List<String> publishZones, AuditLog auditLog) {
        super(converter, beanClass, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
    }

    public String initiateGovernanceActionProcess(String userId, String processQualifiedName, List<String> requestSourceGUIDs, List<NewActionTarget> actionTargets, Map<String, String> requestParameters, Date startTime, String originatorServiceName, String originatorEngineName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String qualifiedNameParameterName = "processQualifiedName";
        String governanceActionTypeGUIDParameterName = "governanceActionFlowRelationship.getEntityTwoProxy().getGUID()";
        Date effectiveTime = new Date();
        String governanceActionProcessGUID = this.getBeanGUIDByUniqueName(userId, processQualifiedName, "processQualifiedName", "qualifiedName", "4d3a2b8d-9e2e-4832-b338-21c74e45b238", "GovernanceActionProcess", false, false, this.supportedZones, effectiveTime, methodName);
        Relationship governanceActionFlowRelationship = this.repositoryHandler.getUniqueRelationshipByType(userId, governanceActionProcessGUID, "GovernanceActionProcess", true, "5f6ddee5-31ea-4d4f-9c3f-00ad2fcb2aa0", "GovernanceActionFlow", false, effectiveTime, methodName);
        if (governanceActionFlowRelationship != null) {
            String governanceActionTypeGUID = governanceActionFlowRelationship.getEntityTwoProxy().getGUID();
            String guard = this.repositoryHelper.getStringProperty(this.serviceName, "guard", governanceActionFlowRelationship.getProperties(), methodName);
            return this.initiateGovernanceActionFromType(userId, null, governanceActionTypeGUID, "governanceActionFlowRelationship.getEntityTwoProxy().getGUID()", guard, requestParameters, requestSourceGUIDs, actionTargets, startTime, processQualifiedName, originatorServiceName, originatorEngineName, effectiveTime, methodName);
        }
        throw new InvalidParameterException(GenericHandlersErrorCode.NO_PROCESS_IMPLEMENTATION.getMessageDefinition(processQualifiedName), this.getClass().getName(), methodName, "processQualifiedName");
    }

    private String initiateGovernanceActionFromType(String userId, String anchorGUID, String governanceActionTypeGUID, String governanceActionTypeGUIDParameterName, String guard, Map<String, String> initialRequestParameters, List<String> requestSourceGUIDs, List<NewActionTarget> actionTargets, Date startTime, String requestSourceName, String originatorServiceName, String originatorEngineName, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        Relationship governanceActionTypeExecutorRelationship = this.repositoryHandler.getUniqueRelationshipByType(userId, governanceActionTypeGUID, "GovernanceActionType", true, "f672245f-35b5-4ca7-b645-014cf61d5b75", "GovernanceActionTypeExecutor", false, effectiveTime, methodName);
        if (governanceActionTypeExecutorRelationship == null) {
            throw new InvalidParameterException(GenericHandlersErrorCode.UNKNOWN_EXECUTOR.getMessageDefinition(governanceActionTypeGUID, "GovernanceActionTypeExecutor"), this.getClass().getName(), methodName, governanceActionTypeGUIDParameterName);
        }
        EntityDetail governanceActionTypeEntity = this.getEntityFromRepository(userId, governanceActionTypeGUID, governanceActionTypeGUIDParameterName, "GovernanceActionType", null, null, false, false, this.supportedZones, effectiveTime, methodName);
        String governanceActionTypeName = this.repositoryHelper.getStringProperty(this.serviceName, "qualifiedName", governanceActionTypeEntity.getProperties(), methodName);
        int domainIdentifier = this.repositoryHelper.getIntProperty(this.serviceName, "domainIdentifier", governanceActionTypeEntity.getProperties(), methodName);
        String displayName = this.repositoryHelper.getStringProperty(this.serviceName, "displayName", governanceActionTypeEntity.getProperties(), methodName);
        String description = this.repositoryHelper.getStringProperty(this.serviceName, "description", governanceActionTypeEntity.getProperties(), methodName);
        ArrayList<String> receivedGuards = null;
        if (guard != null) {
            receivedGuards = new ArrayList<String>();
            receivedGuards.add(guard);
        }
        String governanceEngineName = this.repositoryHelper.getStringProperty(this.serviceName, "qualifiedName", governanceActionTypeExecutorRelationship.getEntityTwoProxy().getUniqueProperties(), methodName);
        String requestType = this.repositoryHelper.getStringProperty(this.serviceName, "requestType", governanceActionTypeExecutorRelationship.getProperties(), methodName);
        Map<String, String> requestParameters = this.repositoryHelper.getStringMapFromProperty(this.serviceName, "requestParameters", governanceActionTypeExecutorRelationship.getProperties(), methodName);
        if (initialRequestParameters != null && !initialRequestParameters.isEmpty()) {
            if (requestParameters == null) {
                requestParameters = initialRequestParameters;
            } else {
                requestParameters.putAll(initialRequestParameters);
            }
        }
        List<String> mandatoryGuards = this.getMandatoryGuards(userId, governanceActionTypeGUID, effectiveTime);
        return this.initiateGovernanceAction(userId, governanceActionTypeName + ":" + UUID.randomUUID().toString(), domainIdentifier, displayName, description, requestSourceGUIDs, actionTargets, mandatoryGuards, receivedGuards, startTime, governanceEngineName, requestType, requestParameters, governanceActionTypeGUID, governanceActionTypeName, anchorGUID, requestSourceName, originatorServiceName, originatorEngineName, methodName);
    }

    public String initiateGovernanceAction(String userId, String qualifiedName, int domainIdentifier, String displayName, String description, List<String> requestSourceGUIDs, List<NewActionTarget> actionTargets, List<String> mandatoryGuards, List<String> receivedGuards, Date startTime, String governanceEngineName, String requestType, Map<String, String> requestParameters, String governanceActionTypeGUID, String governanceActionTypeName, String anchorGUID, String requestSourceName, String originatorServiceName, String originatorEngineName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String governanceActionGUID;
        String qualifiedNameParameterName = "qualifiedName";
        String engineNameParameterName = "governanceEngineName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        this.invalidParameterHandler.validateName(governanceEngineName, "governanceEngineName", methodName);
        Date effectiveTime = null;
        String governanceEngineGUID = this.validateGovernanceEngineName(userId, governanceEngineName, "governanceEngineName", methodName);
        GovernanceActionBuilder builder = new GovernanceActionBuilder(qualifiedName, domainIdentifier, displayName, description, governanceEngineGUID, governanceEngineName, requestSourceName, governanceActionTypeGUID, governanceActionTypeName, requestType, requestParameters, mandatoryGuards, receivedGuards, 0, startTime, null, null, null, null, this.repositoryHelper, this.serviceName, this.serverName);
        if (anchorGUID != null) {
            builder.setAnchors(userId, anchorGUID, methodName);
        }
        if ((governanceActionGUID = this.createBeanInRepository(userId, null, null, "c976d88a-2b11-4b40-b972-c38d41bfc6be", "GovernanceAction", qualifiedName, "qualifiedName", builder, methodName)) != null) {
            String governanceActionGUIDParameterName = "governanceActionGUID";
            String governanceActionTypeGUIDParameterName = "governanceActionTypeGUID";
            InstanceProperties originatorProperties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, "originGovernanceService", originatorServiceName, methodName);
            originatorProperties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, originatorProperties, "originGovernanceEngine", originatorEngineName, methodName);
            if (governanceActionTypeGUID != null) {
                this.linkElementToElement(userId, null, null, governanceActionTypeGUID, "governanceActionTypeGUID", "GovernanceActionType", governanceActionGUID, "governanceActionGUID", "GovernanceAction", false, false, this.supportedZones, "31e734ec-5baf-4e96-9f0d-e8a85081cb14", "GovernanceActionTypeUse", originatorProperties, methodName);
            }
            if (requestSourceGUIDs != null && !requestSourceGUIDs.isEmpty()) {
                String requestSourceGUIDParameterName = "requestSourceGUIDs[x]";
                originatorProperties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, originatorProperties, "requestSourceName", requestSourceName, methodName);
                for (String requestSourceGUID : requestSourceGUIDs) {
                    if (requestSourceGUID == null) continue;
                    this.linkElementToElement(userId, null, null, requestSourceGUID, "requestSourceGUIDs[x]", "OpenMetadataRoot", governanceActionGUID, "governanceActionGUID", "GovernanceAction", false, false, this.supportedZones, "5323a705-4c1f-456a-9741-41fdcb8e93ac", "GovernanceActionRequestSource", originatorProperties, methodName);
                }
            }
            this.addActionTargets(userId, governanceActionGUID, "governanceActionGUID", actionTargets, methodName);
            if (mandatoryGuards == null || receivedGuards != null && receivedGuards.containsAll(mandatoryGuards)) {
                this.updateGovernanceActionStatus(userId, governanceActionGUID, 1, effectiveTime, methodName);
            }
        }
        return governanceActionGUID;
    }

    private void addActionTargets(String userId, String governanceActionGUID, String governanceActionGUIDParameterName, List<NewActionTarget> actionTargets, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        if (actionTargets != null && !actionTargets.isEmpty()) {
            String actionTargetGUIDParameterName = "actionTargets[x]";
            for (NewActionTarget actionTarget : actionTargets) {
                String actionTargetGUID = actionTarget.getActionTargetGUID();
                String actionTargetName = actionTarget.getActionTargetName();
                if (actionTargetGUID == null) continue;
                InstanceProperties properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, "actionTargetName", actionTargetName, methodName);
                this.linkElementToElement(userId, null, null, governanceActionGUID, governanceActionGUIDParameterName, "GovernanceAction", actionTargetGUID, "actionTargets[x]", "Referenceable", false, false, this.supportedZones, "46ec49bf-af66-4575-aab7-06ce895120cd", "TargetForAction", properties, methodName);
            }
        }
    }

    private String validateGovernanceEngineName(String userId, String governanceEngineName, String governanceEngineNameParameterName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String governanceEngineGUID = this.getBeanGUIDByUniqueName(userId, governanceEngineName, governanceEngineNameParameterName, "qualifiedName", "3fa23d4a-aceb-422f-9301-04ed474c6f74", "GovernanceEngine", false, false, this.supportedZones, new Date(), methodName);
        if (governanceEngineGUID == null) {
            throw new InvalidParameterException(GenericHandlersErrorCode.UNKNOWN_ENGINE_NAME.getMessageDefinition(governanceEngineName, this.serviceName, this.serverName), this.getClass().getName(), methodName, governanceEngineNameParameterName);
        }
        return governanceEngineGUID;
    }

    public B getGovernanceAction(String userId, String governanceActionGUID, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String governanceActionGUIDParameterName = "governanceActionGUID";
        String actionTargetGUIDParameterName = "actionTargetGUID";
        String requestSourceGUIDParameterName = "requestSourceGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(governanceActionGUID, "governanceActionGUID", methodName);
        EntityDetail primaryEntity = this.getEntityFromRepository(userId, governanceActionGUID, "governanceActionGUID", "GovernanceAction", null, null, true, true, this.supportedZones, effectiveTime, methodName);
        if (primaryEntity != null) {
            ArrayList<Relationship> relationships = new ArrayList<Relationship>();
            ArrayList<EntityDetail> supplementaryEntities = new ArrayList<EntityDetail>();
            RepositoryRelationshipsIterator iterator = new RepositoryRelationshipsIterator(this.repositoryHandler, userId, governanceActionGUID, "GovernanceAction", null, null, true, 0, this.invalidParameterHandler.getMaxPagingSize(), effectiveTime, methodName);
            while (iterator.moreToReceive()) {
                Relationship relationship = iterator.getNext();
                if (relationship == null || relationship.getType() == null) continue;
                String actualTypeName = relationship.getType().getTypeDefName();
                if (this.repositoryHelper.isTypeOf(this.serviceName, actualTypeName, "GovernanceActionExecutor")) {
                    relationships.add(relationship);
                    continue;
                }
                if (this.repositoryHelper.isTypeOf(this.serviceName, actualTypeName, "GovernanceActionTypeUse")) {
                    relationships.add(relationship);
                    continue;
                }
                if (this.repositoryHelper.isTypeOf(this.serviceName, actualTypeName, "TargetForAction")) {
                    relationships.add(relationship);
                    String actionTargetGUID = relationship.getEntityTwoProxy().getGUID();
                    supplementaryEntities.add(this.getEntityFromRepository(userId, actionTargetGUID, "actionTargetGUID", "Referenceable", null, null, true, true, this.supportedZones, effectiveTime, methodName));
                    continue;
                }
                if (!this.repositoryHelper.isTypeOf(this.serviceName, actualTypeName, "GovernanceActionRequestSource")) continue;
                relationships.add(relationship);
                String requestSourceGUID = relationship.getEntityOneProxy().getGUID();
                supplementaryEntities.add(this.getEntityFromRepository(userId, requestSourceGUID, "requestSourceGUID", "OpenMetadataRoot", null, null, true, true, this.supportedZones, effectiveTime, methodName));
            }
            return this.converter.getNewComplexBean(this.beanClass, primaryEntity, supplementaryEntities, relationships, methodName);
        }
        return null;
    }

    public GovernanceActionStatus getActionStatus(String propertyName, InstanceProperties properties) {
        InstancePropertyValue instancePropertyValue;
        Map instancePropertiesMap;
        GovernanceActionStatus governanceActionStatus = GovernanceActionStatus.OTHER;
        if (properties != null && (instancePropertiesMap = properties.getInstanceProperties()) != null && (instancePropertyValue = (InstancePropertyValue)instancePropertiesMap.get(propertyName)) instanceof EnumPropertyValue) {
            EnumPropertyValue enumPropertyValue = (EnumPropertyValue)instancePropertyValue;
            switch (enumPropertyValue.getOrdinal()) {
                case 0: {
                    governanceActionStatus = GovernanceActionStatus.REQUESTED;
                    break;
                }
                case 1: {
                    governanceActionStatus = GovernanceActionStatus.APPROVED;
                    break;
                }
                case 2: {
                    governanceActionStatus = GovernanceActionStatus.WAITING;
                    break;
                }
                case 3: {
                    governanceActionStatus = GovernanceActionStatus.ACTIVATING;
                    break;
                }
                case 4: {
                    governanceActionStatus = GovernanceActionStatus.IN_PROGRESS;
                    break;
                }
                case 10: {
                    governanceActionStatus = GovernanceActionStatus.ACTIONED;
                    break;
                }
                case 11: {
                    governanceActionStatus = GovernanceActionStatus.INVALID;
                    break;
                }
                case 12: {
                    governanceActionStatus = GovernanceActionStatus.IGNORED;
                    break;
                }
                case 13: {
                    governanceActionStatus = GovernanceActionStatus.FAILED;
                    break;
                }
                case 99: {
                    governanceActionStatus = GovernanceActionStatus.OTHER;
                }
            }
        }
        return governanceActionStatus;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void claimGovernanceAction(String userId, String governanceActionGUID, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String guidParameterName = "governanceActionGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(governanceActionGUID, "governanceActionGUID", methodName);
        EntityDetail entity = this.getEntityFromRepository(userId, governanceActionGUID, "governanceActionGUID", "GovernanceAction", null, null, false, false, this.supportedZones, effectiveTime, methodName);
        if (entity == null) throw new PropertyServerException(GenericHandlersErrorCode.MISSING_GOVERNANCE_ACTION.getMessageDefinition(governanceActionGUID, "governanceActionGUID", this.serviceName, methodName), this.getClass().getName(), methodName);
        InstanceProperties properties = entity.getProperties();
        if (properties == null) throw new PropertyServerException(GenericHandlersErrorCode.MISSING_GOVERNANCE_ACTION_PROPERTIES.getMessageDefinition(governanceActionGUID, "governanceActionGUID", this.serviceName, methodName), this.getClass().getName(), methodName);
        GovernanceActionStatus status = this.getActionStatus("actionStatus", properties);
        String processingEngineUserId = this.repositoryHelper.getStringProperty(this.serviceName, "processingEngineUserId", properties, methodName);
        if (status != GovernanceActionStatus.APPROVED || processingEngineUserId != null) {
            throw new PropertyServerException(GenericHandlersErrorCode.INVALID_GOVERNANCE_ACTION_STATUS.getMessageDefinition(userId, governanceActionGUID, processingEngineUserId, status.getName()), this.getClass().getName(), methodName);
        }
        GovernanceActionBuilder builder = new GovernanceActionBuilder(2, userId, this.repositoryHelper, this.serviceName, this.serverName);
        this.updateBeanInRepository(userId, null, null, governanceActionGUID, "governanceActionGUID", "c976d88a-2b11-4b40-b972-c38d41bfc6be", "GovernanceAction", false, false, this.supportedZones, builder.getClaimInstanceProperties(methodName), true, effectiveTime, methodName);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void updateGovernanceActionStatus(String userId, String governanceActionGUID, int governanceActionStatus, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String guidParameterName = "governanceActionGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(governanceActionGUID, "governanceActionGUID", methodName);
        EntityDetail entity = this.getEntityFromRepository(userId, governanceActionGUID, "governanceActionGUID", "GovernanceAction", null, null, false, false, this.supportedZones, effectiveTime, methodName);
        if (entity == null) throw new PropertyServerException(GenericHandlersErrorCode.MISSING_GOVERNANCE_ACTION.getMessageDefinition(governanceActionGUID, "governanceActionGUID", this.serviceName, methodName), this.getClass().getName(), methodName);
        InstanceProperties properties = entity.getProperties();
        if (properties == null) throw new PropertyServerException(GenericHandlersErrorCode.MISSING_GOVERNANCE_ACTION_PROPERTIES.getMessageDefinition(governanceActionGUID, "governanceActionGUID", this.serviceName, methodName), this.getClass().getName(), methodName);
        String processingEngineUserId = this.repositoryHelper.getStringProperty(this.serviceName, "processingEngineUserId", properties, methodName);
        if ((processingEngineUserId != null || governanceActionStatus != 1) && !userId.equals(processingEngineUserId)) throw new UserNotAuthorizedException(GenericHandlersErrorCode.INVALID_PROCESSING_USER.getMessageDefinition(userId, methodName, governanceActionGUID, processingEngineUserId), this.getClass().getName(), methodName, userId);
        try {
            properties = this.repositoryHelper.addEnumPropertyToInstance(this.serviceName, null, "actionStatus", "a6e698b0-a4f7-4a39-8c80-db0bb0f972ec", "GovernanceActionStatus", governanceActionStatus, methodName);
        }
        catch (TypeErrorException error) {
            throw new InvalidParameterException((OCFCheckedExceptionBase)error, "activityType");
        }
        this.updateBeanInRepository(userId, null, null, governanceActionGUID, "governanceActionGUID", "c976d88a-2b11-4b40-b972-c38d41bfc6be", "GovernanceAction", false, false, this.supportedZones, properties, true, effectiveTime, methodName);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void recordCompletionStatus(String userId, String governanceActionGUID, int status, Map<String, String> callerRequestParameters, List<String> outputGuards, List<NewActionTarget> newActionTargets, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        List<NewActionTarget> nextActionTargets;
        String guidParameterName = "governanceActionGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(governanceActionGUID, "governanceActionGUID", methodName);
        EntityDetail governanceActionEntity = this.getEntityFromRepository(userId, governanceActionGUID, "governanceActionGUID", "GovernanceAction", null, null, false, false, this.supportedZones, effectiveTime, methodName);
        if (governanceActionEntity == null) throw new PropertyServerException(GenericHandlersErrorCode.MISSING_GOVERNANCE_ACTION.getMessageDefinition(governanceActionGUID, "governanceActionGUID", this.serviceName, methodName), this.getClass().getName(), methodName);
        InstanceProperties properties = governanceActionEntity.getProperties();
        if (properties == null) throw new PropertyServerException(GenericHandlersErrorCode.MISSING_GOVERNANCE_ACTION_PROPERTIES.getMessageDefinition(governanceActionGUID, "governanceActionGUID", this.serviceName, methodName), this.getClass().getName(), methodName);
        String processingEngineUserId = this.repositoryHelper.getStringProperty(this.serviceName, "processingEngineUserId", properties, methodName);
        if (!userId.equals(processingEngineUserId)) throw new UserNotAuthorizedException(GenericHandlersErrorCode.INVALID_PROCESSING_USER.getMessageDefinition(userId, methodName, governanceActionGUID, processingEngineUserId), this.getClass().getName(), methodName, userId);
        GovernanceActionBuilder builder = new GovernanceActionBuilder(this.repositoryHelper, this.serviceName, this.serverName);
        this.repositoryHandler.updateEntityProperties(userId, null, null, governanceActionGUID, governanceActionEntity, "c976d88a-2b11-4b40-b972-c38d41bfc6be", "GovernanceAction", builder.getCompletionInstanceProperties(governanceActionEntity.getProperties(), status, new Date(), outputGuards, methodName), methodName);
        List<NewActionTarget> currentActionTargets = this.markActionTargetsAsComplete(userId, governanceActionGUID, effectiveTime, status);
        if (currentActionTargets != null && !currentActionTargets.isEmpty()) {
            if (newActionTargets != null && !newActionTargets.isEmpty()) {
                nextActionTargets = new ArrayList<NewActionTarget>(currentActionTargets);
                for (NewActionTarget newActionTarget : newActionTargets) {
                    boolean isNewActionTarget = true;
                    for (NewActionTarget currentActionTarget : currentActionTargets) {
                        if (currentActionTarget == null || !currentActionTarget.getActionTargetGUID().equals(newActionTarget.getActionTargetGUID()) || !currentActionTarget.getActionTargetName().equals(newActionTarget.getActionTargetName())) continue;
                        isNewActionTarget = false;
                    }
                    if (!isNewActionTarget) continue;
                    nextActionTargets.add(newActionTarget);
                }
            } else {
                nextActionTargets = currentActionTargets;
            }
        } else {
            nextActionTargets = newActionTargets;
        }
        String anchorGUID = this.getAnchorGUIDFromAnchorsClassification(governanceActionEntity, methodName);
        String processName = this.repositoryHelper.getStringProperty(this.serviceName, "processName", properties, methodName);
        this.initiateNextGovernanceActions(userId, governanceActionGUID, anchorGUID, processName, outputGuards, nextActionTargets, callerRequestParameters, effectiveTime, methodName);
    }

    private List<NewActionTarget> markActionTargetsAsComplete(String userId, String governanceActionGUID, Date effectiveTime, int status) throws UserNotAuthorizedException, PropertyServerException {
        String methodName = "markActionTargetsAsComplete";
        ArrayList<NewActionTarget> currentActionTargets = null;
        List actionTargetRelationships = this.repositoryHandler.getRelationshipsByType(userId, governanceActionGUID, "GovernanceAction", "46ec49bf-af66-4575-aab7-06ce895120cd", "TargetForAction", false, 0, 0, effectiveTime, "markActionTargetsAsComplete");
        if (actionTargetRelationships != null) {
            currentActionTargets = new ArrayList<NewActionTarget>();
            for (Relationship actionTarget : actionTargetRelationships) {
                InstanceProperties newActionTargetProperties;
                if (actionTarget == null) continue;
                NewActionTarget currentActionTarget = new NewActionTarget();
                currentActionTarget.setActionTargetGUID(actionTarget.getEntityTwoProxy().getGUID());
                InstanceProperties actionTargetProperties = actionTarget.getProperties();
                currentActionTarget.setActionTargetName(this.repositoryHelper.getStringProperty(this.serviceName, "actionTargetName", actionTargetProperties, "markActionTargetsAsComplete"));
                currentActionTargets.add(currentActionTarget);
                if (actionTargetProperties.getPropertyValue("status") != null) continue;
                try {
                    newActionTargetProperties = this.repositoryHelper.addEnumPropertyToInstance(this.serviceName, actionTarget.getProperties(), "status", "a6e698b0-a4f7-4a39-8c80-db0bb0f972ec", "GovernanceActionStatus", status, "markActionTargetsAsComplete");
                }
                catch (TypeErrorException error) {
                    throw new PropertyServerException((OCFCheckedExceptionBase)error);
                }
                newActionTargetProperties = this.repositoryHelper.addDatePropertyToInstance(this.serviceName, newActionTargetProperties, "completionDate", new Date(), "markActionTargetsAsComplete");
                this.repositoryHandler.updateRelationshipProperties(userId, null, null, actionTarget, newActionTargetProperties, "markActionTargetsAsComplete");
            }
        }
        return currentActionTargets;
    }

    private void initiateNextGovernanceActions(String userId, String previousGovernanceActionGUID, String anchorGUID, String processName, List<String> outputGuards, List<NewActionTarget> newActionTargets, Map<String, String> currentRequestParameters, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        Relationship governanceActionTypeUseRelationship = this.repositoryHandler.getUniqueRelationshipByType(userId, previousGovernanceActionGUID, "GovernanceAction", false, "31e734ec-5baf-4e96-9f0d-e8a85081cb14", "GovernanceActionTypeUse", false, effectiveTime, methodName);
        if (governanceActionTypeUseRelationship != null) {
            String governanceActionTypeGUID = governanceActionTypeUseRelationship.getEntityOneProxy().getGUID();
            String originatorServiceName = this.repositoryHelper.getStringProperty(this.serviceName, "originGovernanceService", governanceActionTypeUseRelationship.getProperties(), methodName);
            String originatorEngineName = this.repositoryHelper.getStringProperty(this.serviceName, "originGovernanceEngine", governanceActionTypeUseRelationship.getProperties(), methodName);
            List nextActionTypes = this.repositoryHandler.getRelationshipsByType(userId, governanceActionTypeGUID, "GovernanceActionType", "d9567840-9904-43a5-990b-4585c0446e00", "NextGovernanceActionType", false, 0, 0, effectiveTime, methodName);
            if (nextActionTypes != null) {
                for (Relationship nextActionType : nextActionTypes) {
                    boolean validNextAction;
                    if (nextActionType == null || governanceActionTypeGUID.equals(nextActionType.getEntityOneProxy().getGUID())) continue;
                    String guard = this.repositoryHelper.getStringProperty(this.serviceName, "guard", nextActionType.getProperties(), methodName);
                    boolean bl = validNextAction = guard == null;
                    if (guard != null && outputGuards != null) {
                        for (String outputGuard : outputGuards) {
                            if (outputGuard == null || !outputGuard.equals(guard)) continue;
                            validNextAction = true;
                        }
                    }
                    if (!validNextAction) continue;
                    boolean mandatoryGuard = this.repositoryHelper.getBooleanProperty(this.serviceName, "mandatoryGuard", nextActionType.getProperties(), methodName);
                    boolean ignoreMultipleTriggers = this.repositoryHelper.getBooleanProperty(this.serviceName, "ignoreMultipleTriggers", nextActionType.getProperties(), methodName);
                    String nextGovernanceActionGUID = this.newGovernanceActionNeeded(userId, governanceActionTypeGUID, anchorGUID, guard, ignoreMultipleTriggers, effectiveTime, newActionTargets);
                    if (nextGovernanceActionGUID == null) {
                        String governanceActionTypeGUIDParameterName = "governanceActionTypeUseRelationship.getEntityOneProxy().getGUID()";
                        nextGovernanceActionGUID = anchorGUID == null ? this.initiateGovernanceActionFromType(userId, previousGovernanceActionGUID, governanceActionTypeGUID, "governanceActionTypeUseRelationship.getEntityOneProxy().getGUID()", guard, currentRequestParameters, null, newActionTargets, new Date(), processName, originatorServiceName, originatorEngineName, effectiveTime, methodName) : this.initiateGovernanceActionFromType(userId, anchorGUID, governanceActionTypeGUID, "governanceActionTypeUseRelationship.getEntityOneProxy().getGUID()", guard, currentRequestParameters, null, newActionTargets, new Date(), processName, originatorServiceName, originatorEngineName, effectiveTime, methodName);
                    }
                    if (nextGovernanceActionGUID == null) continue;
                    InstanceProperties nextGovernanceActionProperties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, "guard", guard, methodName);
                    nextGovernanceActionProperties = this.repositoryHelper.addBooleanPropertyToInstance(this.serviceName, nextGovernanceActionProperties, "mandatoryGuard", mandatoryGuard, methodName);
                    nextGovernanceActionProperties = this.repositoryHelper.addBooleanPropertyToInstance(this.serviceName, nextGovernanceActionProperties, "ignoreMultipleTriggers", ignoreMultipleTriggers, methodName);
                    this.repositoryHandler.createRelationship(userId, "4efd16d4-f397-449c-a75d-ebea42fe581b", null, null, previousGovernanceActionGUID, nextGovernanceActionGUID, nextGovernanceActionProperties, methodName);
                }
            }
        }
    }

    private List<String> getMandatoryGuards(String userId, String governanceActionTypeGUID, Date effectiveTime) throws UserNotAuthorizedException, PropertyServerException {
        String methodName = "getMandatoryGuards";
        List dependedOnActionTypes = this.repositoryHandler.getRelationshipsByType(userId, governanceActionTypeGUID, "GovernanceActionType", "d9567840-9904-43a5-990b-4585c0446e00", "NextGovernanceActionType", false, 0, 0, effectiveTime, "getMandatoryGuards");
        if (dependedOnActionTypes != null) {
            ArrayList<String> mandatoryGuards = new ArrayList<String>();
            for (Relationship dependedOnActionType : dependedOnActionTypes) {
                String guard;
                boolean mandatoryGuard;
                if (dependedOnActionType == null || dependedOnActionType.getEntityTwoProxy() == null || !governanceActionTypeGUID.equals(dependedOnActionType.getEntityTwoProxy().getGUID()) || !(mandatoryGuard = this.repositoryHelper.getBooleanProperty(this.serviceName, "mandatoryGuard", dependedOnActionType.getProperties(), "getMandatoryGuards")) || (guard = this.repositoryHelper.getStringProperty(this.serviceName, "guard", dependedOnActionType.getProperties(), "getMandatoryGuards")) == null) continue;
                mandatoryGuards.add(guard);
            }
            if (mandatoryGuards.isEmpty()) {
                return null;
            }
            return mandatoryGuards;
        }
        return null;
    }

    private String newGovernanceActionNeeded(String userId, String governanceActionTypeGUID, String anchorGUID, String guard, boolean ignoreMultipleTriggers, Date effectiveTime, List<NewActionTarget> newActionTargets) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        if (anchorGUID != null && governanceActionTypeGUID != null) {
            String methodName = "newGovernanceActionNeeded";
            String governanceActionGUIDParameterName = "governanceActionTypeUse.getEntityTwoProxy().getGUID()";
            List governanceActionTypeUses = this.repositoryHandler.getRelationshipsByType(userId, governanceActionTypeGUID, "GovernanceActionType", "31e734ec-5baf-4e96-9f0d-e8a85081cb14", "GovernanceActionTypeUse", false, 0, 0, effectiveTime, "newGovernanceActionNeeded");
            if (governanceActionTypeUses != null) {
                for (Relationship governanceActionTypeUse : governanceActionTypeUses) {
                    String nextGovernanceActionAnchorGUID;
                    EntityDetail nextGovernanceAction;
                    if (governanceActionTypeUse == null || governanceActionTypeUse.getEntityTwoProxy() == null || (nextGovernanceAction = this.getEntityFromRepository(userId, governanceActionTypeUse.getEntityTwoProxy().getGUID(), "governanceActionTypeUse.getEntityTwoProxy().getGUID()", "GovernanceAction", null, null, false, false, this.supportedZones, effectiveTime, "newGovernanceActionNeeded")) == null || !anchorGUID.equals(nextGovernanceActionAnchorGUID = this.getAnchorGUIDFromAnchorsClassification(nextGovernanceAction, "newGovernanceActionNeeded"))) continue;
                    ArrayList<String> receivedGuards = this.repositoryHelper.getStringArrayProperty(this.serviceName, "receivedGuards", nextGovernanceAction.getProperties(), "newGovernanceActionNeeded");
                    List mandatoryGuards = this.repositoryHelper.getStringArrayProperty(this.serviceName, "mandatoryGuard", nextGovernanceAction.getProperties(), "newGovernanceActionNeeded");
                    int governanceActionStatus = this.repositoryHelper.getEnumPropertyOrdinal(this.serviceName, "actionStatus", nextGovernanceAction.getProperties(), "newGovernanceActionNeeded");
                    if ((governanceActionStatus != 0 || mandatoryGuards == null || receivedGuards != null && receivedGuards.contains(guard)) && !ignoreMultipleTriggers) {
                        return null;
                    }
                    this.addActionTargets(userId, nextGovernanceAction.getGUID(), "governanceActionTypeUse.getEntityTwoProxy().getGUID()", newActionTargets, "newGovernanceActionNeeded");
                    if (receivedGuards == null) {
                        receivedGuards = new ArrayList<String>();
                        receivedGuards.add(guard);
                    } else if (!receivedGuards.contains(guard)) {
                        receivedGuards.add(guard);
                    }
                    InstanceProperties entityProperties = nextGovernanceAction.getProperties();
                    entityProperties = this.repositoryHelper.addStringArrayPropertyToInstance(this.serviceName, entityProperties, "receivedGuards", receivedGuards, "newGovernanceActionNeeded");
                    if (governanceActionStatus == 0 && (mandatoryGuards == null || receivedGuards.containsAll(mandatoryGuards))) {
                        try {
                            entityProperties = this.repositoryHelper.addEnumPropertyToInstance(this.serviceName, entityProperties, "actionStatus", "a6e698b0-a4f7-4a39-8c80-db0bb0f972ec", "GovernanceActionStatus", 1, "newGovernanceActionNeeded");
                        }
                        catch (TypeErrorException error) {
                            throw new PropertyServerException((OCFCheckedExceptionBase)error);
                        }
                    }
                    this.repositoryHandler.updateEntityProperties(userId, null, null, nextGovernanceAction.getGUID(), nextGovernanceAction, "c976d88a-2b11-4b40-b972-c38d41bfc6be", "GovernanceAction", entityProperties, "newGovernanceActionNeeded");
                    return nextGovernanceAction.getGUID();
                }
            }
        }
        return null;
    }

    public List<B> getGovernanceActions(String userId, int startFrom, int pageSize, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        RepositoryEntitiesIterator iterator = new RepositoryEntitiesIterator(this.repositoryHandler, userId, "c976d88a-2b11-4b40-b972-c38d41bfc6be", "GovernanceAction", "qualifiedName", false, false, 0, this.invalidParameterHandler.getMaxPagingSize(), effectiveTime, methodName);
        ArrayList<B> results = new ArrayList<B>();
        int entityCount = 0;
        while (iterator.moreToReceive() && (pageSize == 0 || results.size() < pageSize)) {
            B bean;
            EntityDetail nextGovernanceAction = iterator.getNext();
            if (++entityCount <= startFrom || (bean = this.getGovernanceAction(userId, nextGovernanceAction.getGUID(), effectiveTime, methodName)) == null) continue;
            results.add(bean);
        }
        if (results.isEmpty()) {
            return null;
        }
        return results;
    }

    public List<B> getActiveGovernanceActions(String userId, int startFrom, int pageSize, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        RepositoryEntitiesIterator iterator = new RepositoryEntitiesIterator(this.repositoryHandler, userId, "c976d88a-2b11-4b40-b972-c38d41bfc6be", "GovernanceAction", "qualifiedName", false, false, 0, this.invalidParameterHandler.getMaxPagingSize(), effectiveTime, methodName);
        ArrayList<B> results = new ArrayList<B>();
        int entityCount = 0;
        while (iterator.moreToReceive() && (pageSize == 0 || results.size() < pageSize)) {
            B bean;
            int status;
            EntityDetail nextGovernanceAction = iterator.getNext();
            if (++entityCount <= startFrom || (status = this.repositoryHelper.getEnumPropertyOrdinal(this.serviceName, "status", nextGovernanceAction.getProperties(), methodName)) != 0 && status != 1 && status != 2 && status != 3 || (bean = this.getGovernanceAction(userId, nextGovernanceAction.getGUID(), effectiveTime, methodName)) == null) continue;
            results.add(bean);
        }
        if (results.isEmpty()) {
            return null;
        }
        return results;
    }

    public List<B> getActiveClaimedGovernanceActions(String userId, String governanceEngineGUID, int startFrom, int pageSize, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String guidParameterName = "governanceEngineGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(governanceEngineGUID, "governanceEngineGUID", methodName);
        InstanceProperties properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, "processingEngineUserId", userId, methodName);
        RepositorySelectedEntitiesIterator iterator = new RepositorySelectedEntitiesIterator(this.repositoryHandler, userId, "c976d88a-2b11-4b40-b972-c38d41bfc6be", properties, MatchCriteria.ANY, "qualifiedName", false, false, 0, this.invalidParameterHandler.getMaxPagingSize(), effectiveTime, methodName);
        ArrayList<B> results = new ArrayList<B>();
        int entityCount = 0;
        while (iterator.moreToReceive() && (pageSize == 0 || results.size() < pageSize)) {
            B bean;
            int status;
            EntityDetail nextGovernanceAction = iterator.getNext();
            if (++entityCount <= startFrom || (status = this.repositoryHelper.getEnumPropertyOrdinal(this.serviceName, "status", nextGovernanceAction.getProperties(), methodName)) != 2 && status != 3 || (bean = this.getGovernanceAction(userId, nextGovernanceAction.getGUID(), effectiveTime, methodName)) == null) continue;
            results.add(bean);
        }
        if (results.isEmpty()) {
            return null;
        }
        return results;
    }

    public void updateActionTargetStatus(String userId, String actionTargetGUID, int status, Date startDate, Date completionDate, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String guidParameterName = "actionTargetGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(actionTargetGUID, "actionTargetGUID", methodName);
        Relationship actionTarget = this.repositoryHandler.getRelationshipByGUID(userId, actionTargetGUID, "actionTargetGUID", "TargetForAction", effectiveTime, methodName);
        if (actionTarget != null) {
            InstanceProperties newActionTargetProperties;
            try {
                newActionTargetProperties = this.repositoryHelper.addEnumPropertyToInstance(this.serviceName, actionTarget.getProperties(), "status", "a6e698b0-a4f7-4a39-8c80-db0bb0f972ec", "GovernanceActionStatus", status, methodName);
            }
            catch (TypeErrorException error) {
                throw new PropertyServerException((OCFCheckedExceptionBase)error);
            }
            newActionTargetProperties = this.repositoryHelper.addDatePropertyToInstance(this.serviceName, newActionTargetProperties, "startDate", startDate, methodName);
            newActionTargetProperties = this.repositoryHelper.addDatePropertyToInstance(this.serviceName, newActionTargetProperties, "completionDate", completionDate, methodName);
            this.repositoryHandler.updateRelationshipProperties(userId, null, null, actionTarget, newActionTargetProperties, methodName);
        }
    }
}

