/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.generichandlers.CommentBuilder;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericConverter;
import org.odpi.openmetadata.commonservices.generichandlers.ReferenceableHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.metadatasecurity.server.OpenMetadataServerSecurityVerifier;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class CommentHandler<B>
extends ReferenceableHandler<B> {
    public CommentHandler(OpenMetadataAPIGenericConverter<B> converter, Class<B> beanClass, String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper, String localServerUserId, OpenMetadataServerSecurityVerifier securityVerifier, List<String> supportedZones, List<String> defaultZones, List<String> publishZones, AuditLog auditLog) {
        super(converter, beanClass, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
    }

    public int countAttachedComments(String userId, String elementGUID, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return super.countAttachments(userId, elementGUID, "Referenceable", "0d90501b-bf29-4621-a207-0c8c953bdac9", "AttachedComment", effectiveTime, methodName);
    }

    public String attachNewComment(String userId, String externalSourceGUID, String externalSourceName, String anchorGUID, String parentGUID, String parentGUIDParameterName, int commentType, String commentText, boolean isPublic, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String commentGUID;
        String textParameter = "commentText";
        String commentGUIDParameter = "commentGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(parentGUID, parentGUIDParameterName, methodName);
        this.invalidParameterHandler.validateText(commentText, "commentText", methodName);
        String qualifiedName = UUID.randomUUID().toString();
        CommentBuilder builder = new CommentBuilder(qualifiedName, commentType, commentText, isPublic, this.repositoryHelper, this.serviceName, this.serverName);
        if (anchorGUID != null) {
            builder.setAnchors(userId, anchorGUID, methodName);
        }
        if ((commentGUID = this.createBeanInRepository(userId, externalSourceGUID, externalSourceName, "1a226073-9c84-40e4-a422-fbddb9b84278", "Comment", qualifiedName, "qualifiedName", builder, methodName)) != null) {
            this.linkElementToElement(userId, externalSourceGUID, externalSourceName, parentGUID, parentGUIDParameterName, "Referenceable", commentGUID, "commentGUID", "Comment", false, false, this.supportedZones, "0d90501b-bf29-4621-a207-0c8c953bdac9", "AttachedComment", builder.getRelationshipInstanceProperties(methodName), methodName);
        }
        return commentGUID;
    }

    public void updateComment(String userId, String externalSourceGUID, String externalSourceName, String commentGUID, String commentGUIDParameterName, int commentType, String commentText, boolean isPublic, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String textParameter = "commentText";
        this.invalidParameterHandler.validateText(commentText, "commentText", methodName);
        CommentBuilder builder = new CommentBuilder(null, commentType, commentText, isPublic, this.repositoryHelper, this.serviceName, this.serverName);
        this.updateBeanInRepository(userId, externalSourceGUID, externalSourceName, commentGUID, commentGUIDParameterName, "1a226073-9c84-40e4-a422-fbddb9b84278", "Comment", false, false, this.supportedZones, builder.getInstanceProperties(methodName), true, new Date(), methodName);
    }

    public void removeCommentFromElement(String userId, String externalSourceGUID, String externalSourceName, String commentGUID, String commentGUIDParameterName, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.deleteBeanInRepository(userId, externalSourceGUID, externalSourceName, commentGUID, commentGUIDParameterName, "1a226073-9c84-40e4-a422-fbddb9b84278", "Comment", null, null, false, false, new Date(), methodName);
    }

    public List<B> getComments(String userId, String anchorGUID, String anchorGUIDParameterName, String elementGUID, String elementGUIDParameterName, String elementTypeName, List<String> serviceSupportedZones, int startingFrom, int pageSize, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getAttachedElements(userId, anchorGUID, anchorGUIDParameterName, elementGUID, elementGUIDParameterName, elementTypeName, "0d90501b-bf29-4621-a207-0c8c953bdac9", "AttachedComment", "Comment", null, null, 0, false, false, serviceSupportedZones, startingFrom, pageSize, effectiveTime, methodName);
    }

    public List<B> getComments(String userId, String elementGUID, String elementGUIDParameterName, String elementTypeName, List<String> serviceSupportedZones, int startingFrom, int pageSize, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getAttachedElements(userId, null, null, elementGUID, elementGUIDParameterName, elementTypeName, "0d90501b-bf29-4621-a207-0c8c953bdac9", "AttachedComment", "Comment", null, null, 0, false, false, serviceSupportedZones, startingFrom, pageSize, effectiveTime, methodName);
    }

    public List<B> getComments(String userId, String elementGUID, String elementGUIDParameterName, String elementTypeName, int startingFrom, int pageSize, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getAttachedElements(userId, null, null, elementGUID, elementGUIDParameterName, elementTypeName, "0d90501b-bf29-4621-a207-0c8c953bdac9", "AttachedComment", "Comment", null, null, 0, false, false, this.supportedZones, startingFrom, pageSize, effectiveTime, methodName);
    }
}

