/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericConverter;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericHandler;
import org.odpi.openmetadata.commonservices.generichandlers.PropertyFacetBuilder;
import org.odpi.openmetadata.commonservices.generichandlers.ReferenceableBuilder;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.metadatasecurity.server.OpenMetadataServerSecurityVerifier;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntitySummary;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.ClassificationErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeErrorException;

public class ReferenceableHandler<B>
extends OpenMetadataAPIGenericHandler<B> {
    public ReferenceableHandler(OpenMetadataAPIGenericConverter<B> converter, Class<B> beanClass, String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper, String localServerUserId, OpenMetadataServerSecurityVerifier securityVerifier, List<String> supportedZones, List<String> defaultZones, List<String> publishZones, AuditLog auditLog) {
        super(converter, beanClass, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
    }

    public String getBeanGUIDByQualifiedName(String userId, String typeGUID, String typeName, String name, String nameParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getBeanGUIDByQualifiedName(userId, typeGUID, typeName, name, nameParameterName, forLineage, forDuplicateProcessing, this.supportedZones, effectiveTime, methodName);
    }

    public String getBeanGUIDByQualifiedName(String userId, String typeGUID, String typeName, String name, String nameParameterName, boolean forLineage, boolean forDuplicateProcessing, List<String> serviceSupportedZones, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String resultTypeGUID = "a32316b8-dc8c-48c5-b12b-71c1b2a080bf";
        String resultTypeName = "Referenceable";
        if (typeGUID != null) {
            resultTypeGUID = typeGUID;
        }
        if (typeName != null) {
            resultTypeName = typeName;
        }
        return this.getBeanGUIDByUniqueName(userId, name, nameParameterName, "qualifiedName", resultTypeGUID, resultTypeName, forLineage, forDuplicateProcessing, serviceSupportedZones, effectiveTime, methodName);
    }

    public B getBeanByQualifiedName(String userId, String typeGUID, String typeName, String name, String nameParameterName, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getBeanByQualifiedName(userId, typeGUID, typeName, name, nameParameterName, false, false, this.supportedZones, new Date(), methodName);
    }

    public B getBeanByQualifiedName(String userId, String typeGUID, String typeName, String name, String nameParameterName, boolean forLineage, boolean forDuplicateProcessing, List<String> serviceSupportedZones, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String resultTypeGUID = "a32316b8-dc8c-48c5-b12b-71c1b2a080bf";
        String resultTypeName = "Referenceable";
        if (typeGUID != null) {
            resultTypeGUID = typeGUID;
        }
        if (typeName != null) {
            resultTypeName = typeName;
        }
        return this.getBeanByUniqueName(userId, name, nameParameterName, "qualifiedName", resultTypeGUID, resultTypeName, forLineage, forDuplicateProcessing, serviceSupportedZones, effectiveTime, methodName);
    }

    public List<String> getBeanGUIDsByQualifiedName(String userId, String typeGUID, String typeName, String name, String nameParameterName, boolean forLineage, boolean forDuplicateProcessing, int startFrom, int pageSize, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getBeanGUIDsByQualifiedName(userId, typeGUID, typeName, name, nameParameterName, forLineage, forDuplicateProcessing, this.supportedZones, startFrom, pageSize, effectiveTime, methodName);
    }

    public List<String> getBeanGUIDsByQualifiedName(String userId, String typeGUID, String typeName, String name, String nameParameterName, boolean forLineage, boolean forDuplicateProcessing, List<String> serviceSupportedZones, int startFrom, int pageSize, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String resultTypeGUID = "a32316b8-dc8c-48c5-b12b-71c1b2a080bf";
        String resultTypeName = "Referenceable";
        if (typeGUID != null) {
            resultTypeGUID = typeGUID;
        }
        if (typeName != null) {
            resultTypeName = typeName;
        }
        ArrayList<String> specificMatchPropertyNames = new ArrayList<String>();
        specificMatchPropertyNames.add("qualifiedName");
        return this.getEntityGUIDsByValue(userId, name, nameParameterName, resultTypeGUID, resultTypeName, specificMatchPropertyNames, true, null, null, forLineage, forDuplicateProcessing, serviceSupportedZones, null, startFrom, pageSize, effectiveTime, methodName);
    }

    public List<B> getBeansByQualifiedName(String userId, String typeGUID, String typeName, String name, String nameParameterName, int startFrom, int pageSize, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getBeansByQualifiedName(userId, typeGUID, typeName, name, nameParameterName, this.supportedZones, startFrom, pageSize, null, methodName);
    }

    public List<B> getBeansByQualifiedName(String userId, String typeGUID, String typeName, String name, String nameParameterName, List<String> serviceSupportedZones, int startFrom, int pageSize, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String resultTypeGUID = "a32316b8-dc8c-48c5-b12b-71c1b2a080bf";
        String resultTypeName = "Referenceable";
        if (typeGUID != null) {
            resultTypeGUID = typeGUID;
        }
        if (typeName != null) {
            resultTypeName = typeName;
        }
        ArrayList<String> specificMatchPropertyNames = new ArrayList<String>();
        specificMatchPropertyNames.add("qualifiedName");
        return this.getBeansByValue(userId, name, nameParameterName, resultTypeGUID, resultTypeName, specificMatchPropertyNames, true, null, null, false, false, serviceSupportedZones, null, startFrom, pageSize, effectiveTime, methodName);
    }

    public EntityDetail getEntityByUniqueQualifiedName(String userId, String typeGUID, String typeName, String name, String nameParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String resultTypeGUID = "a32316b8-dc8c-48c5-b12b-71c1b2a080bf";
        String resultTypeName = "Referenceable";
        if (typeGUID != null) {
            resultTypeGUID = typeGUID;
        }
        if (typeName != null) {
            resultTypeName = typeName;
        }
        ArrayList<String> specificMatchPropertyNames = new ArrayList<String>();
        specificMatchPropertyNames.add("qualifiedName");
        List<EntityDetail> matchingEntities = this.getEntitiesByValue(userId, name, nameParameterName, resultTypeGUID, resultTypeName, specificMatchPropertyNames, true, null, null, forLineage, forDuplicateProcessing, this.supportedZones, null, 0, 0, effectiveTime, methodName);
        if (matchingEntities == null) {
            return null;
        }
        if (matchingEntities.size() == 1) {
            return matchingEntities.get(0);
        }
        this.errorHandler.handleAmbiguousEntityName(name, nameParameterName, resultTypeName, matchingEntities, methodName);
        return null;
    }

    public List<String> findBeanGUIDsByQualifiedName(String userId, String typeGUID, String typeName, String name, String nameParameterName, boolean forLineage, boolean forDuplicateProcessing, List<String> serviceSupportedZones, int startFrom, int pageSize, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String resultTypeGUID = "896d14c2-7522-4f6c-8519-757711943fe6";
        String resultTypeName = "Asset";
        if (typeGUID != null) {
            resultTypeGUID = typeGUID;
        }
        if (typeName != null) {
            resultTypeName = typeName;
        }
        ArrayList<String> specificMatchPropertyNames = new ArrayList<String>();
        specificMatchPropertyNames.add("qualifiedName");
        return this.getEntityGUIDsByValue(userId, name, nameParameterName, resultTypeGUID, resultTypeName, specificMatchPropertyNames, false, null, null, forLineage, forDuplicateProcessing, serviceSupportedZones, null, startFrom, pageSize, effectiveTime, methodName);
    }

    public List<B> findBeansByQualifiedName(String userId, String typeGUID, String typeName, String name, String nameParameterName, boolean forLineage, boolean forDuplicateProcessing, int startFrom, int pageSize, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.findBeansByQualifiedName(userId, typeGUID, typeName, name, nameParameterName, forLineage, forDuplicateProcessing, this.supportedZones, startFrom, pageSize, effectiveTime, methodName);
    }

    public List<B> findBeansByQualifiedName(String userId, String typeGUID, String typeName, String name, String nameParameterName, boolean forLineage, boolean forDuplicateProcessing, List<String> serviceSupportedZones, int startFrom, int pageSize, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String resultTypeGUID = "a32316b8-dc8c-48c5-b12b-71c1b2a080bf";
        String resultTypeName = "Referenceable";
        if (typeGUID != null) {
            resultTypeGUID = typeGUID;
        }
        if (typeName != null) {
            resultTypeName = typeName;
        }
        ArrayList<String> specificMatchPropertyNames = new ArrayList<String>();
        specificMatchPropertyNames.add("qualifiedName");
        return this.getBeansByValue(userId, name, nameParameterName, resultTypeGUID, resultTypeName, specificMatchPropertyNames, false, null, null, forLineage, forDuplicateProcessing, serviceSupportedZones, null, startFrom, pageSize, effectiveTime, methodName);
    }

    public void addOwner(String userId, String beanGUID, String beanGUIDParameterName, String beanGUIDTypeName, String owner, String ownerTypeName, String ownerPropertyName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        ReferenceableBuilder builder = new ReferenceableBuilder("a32316b8-dc8c-48c5-b12b-71c1b2a080bf", "Referenceable", this.repositoryHelper, this.serviceName, this.serverName);
        this.setClassificationInRepository(userId, null, null, beanGUID, beanGUIDParameterName, beanGUIDTypeName, "8139a911-a4bd-432b-a9f4-f6d11c511abe", "Ownership", builder.getOwnershipProperties(owner, ownerTypeName, ownerPropertyName, methodName), false, false, false, new Date(), methodName);
    }

    public void removeOwner(String userId, String beanGUID, String beanGUIDParameterName, String beanGUIDTypeName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.removeClassificationFromRepository(userId, null, null, beanGUID, beanGUIDParameterName, beanGUIDTypeName, "8139a911-a4bd-432b-a9f4-f6d11c511abe", "Ownership", false, false, new Date(), methodName);
    }

    public void addSecurityTags(String userId, String beanGUID, String beanGUIDParameterName, String beanGUIDTypeName, List<String> securityLabels, Map<String, Object> securityProperties, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        ReferenceableBuilder builder = new ReferenceableBuilder("a32316b8-dc8c-48c5-b12b-71c1b2a080bf", "Referenceable", this.repositoryHelper, this.serviceName, this.serverName);
        this.setClassificationInRepository(userId, null, null, beanGUID, beanGUIDParameterName, beanGUIDTypeName, "a0b07a86-9fd3-40ca-bb9b-fe83c6981deb", "SecurityTags", builder.getSecurityTagProperties(securityLabels, securityProperties, methodName), false, false, false, new Date(), methodName);
    }

    public void removeSecurityTags(String userId, String beanGUID, String beanGUIDParameterName, String beanGUIDTypeName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.removeClassificationFromRepository(userId, null, null, beanGUID, beanGUIDParameterName, beanGUIDTypeName, "a0b07a86-9fd3-40ca-bb9b-fe83c6981deb", "SecurityTags", false, false, new Date(), methodName);
    }

    public void setBusinessSignificant(String userId, String beanGUID, String beanGUIDParameterName, String beanGUIDTypeName, String description, String scope, String businessCapabilityGUID, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        ReferenceableBuilder builder = new ReferenceableBuilder("a32316b8-dc8c-48c5-b12b-71c1b2a080bf", "Referenceable", this.repositoryHelper, this.serviceName, this.serverName);
        this.setClassificationInRepository(userId, null, null, beanGUID, beanGUIDParameterName, beanGUIDTypeName, "085febdd-f129-4f4b-99aa-01f3e6294e9f", "BusinessSignificance", builder.getBusinessSignificanceProperties(description, scope, businessCapabilityGUID, methodName), false, false, false, new Date(), methodName);
    }

    public void clearBusinessSignificant(String userId, String beanGUID, String beanGUIDParameterName, String beanGUIDTypeName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.removeClassificationFromRepository(userId, null, null, beanGUID, beanGUIDParameterName, beanGUIDTypeName, "085febdd-f129-4f4b-99aa-01f3e6294e9f", "BusinessSignificance", false, false, new Date(), methodName);
    }

    public void addTemplateClassification(String userId, String beanGUID, String beanGUIDParameterName, String beanGUIDTypeName, String name, String description, Map<String, String> additionalProperties, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        ReferenceableBuilder builder = new ReferenceableBuilder("a32316b8-dc8c-48c5-b12b-71c1b2a080bf", "Referenceable", this.repositoryHelper, this.serviceName, this.serverName);
        this.setClassificationInRepository(userId, null, null, beanGUID, beanGUIDParameterName, beanGUIDTypeName, "25fad4a2-c2d6-440d-a5b1-e537881f84ee", "Template", builder.getTemplateProperties(name, description, additionalProperties, methodName), false, false, false, new Date(), methodName);
    }

    public void removeTemplateClassification(String userId, String beanGUID, String beanGUIDParameterName, String beanGUIDTypeName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.removeClassificationFromRepository(userId, null, null, beanGUID, beanGUIDParameterName, beanGUIDTypeName, "25fad4a2-c2d6-440d-a5b1-e537881f84ee", "Template", false, false, new Date(), methodName);
    }

    public List<B> getMoreInformation(String userId, String startingGUID, String startingGUIDParameterName, String suppliedStartingTypeName, String suppliedResultingTypeName, int startFrom, int pageSize, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getMoreInformation(userId, startingGUID, startingGUIDParameterName, suppliedStartingTypeName, suppliedResultingTypeName, this.supportedZones, startFrom, pageSize, null, methodName);
    }

    public List<B> getMoreInformation(String userId, String startingGUID, String startingGUIDParameterName, String suppliedStartingTypeName, String suppliedResultingTypeName, List<String> serviceSupportedZones, int startFrom, int pageSize, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String startingTypeName = "Referenceable";
        String resultingTypeName = "Referenceable";
        if (suppliedStartingTypeName != null) {
            startingTypeName = suppliedStartingTypeName;
        }
        if (suppliedResultingTypeName != null) {
            resultingTypeName = suppliedResultingTypeName;
        }
        return this.getAttachedElements(userId, null, null, startingGUID, startingGUIDParameterName, startingTypeName, "1cbf059e-2c11-4e0c-8aae-1da42c1ee73f", "MoreInformation", resultingTypeName, null, null, 0, false, false, serviceSupportedZones, startFrom, pageSize, effectiveTime, methodName);
    }

    public void saveSemanticAssignment(String userId, String externalSourceGUID, String externalSourceName, String beanGUID, String beanGUIDParameter, String glossaryTermGUID, String glossaryTermGUIDParameter, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.linkElementToElement(userId, externalSourceGUID, externalSourceName, beanGUID, beanGUIDParameter, "Referenceable", glossaryTermGUID, glossaryTermGUIDParameter, "GlossaryTerm", false, false, this.supportedZones, "e6670973-645f-441a-bec7-6f5570345b92", "SemanticAssignment", null, methodName);
    }

    public void saveSemanticAssignment(String userId, String externalSourceGUID, String externalSourceName, String beanGUID, String beanGUIDParameter, String glossaryTermGUID, String glossaryTermGUIDParameter, String description, String expression, int statusOrdinal, int confidence, String createdBy, String steward, String source, Date effectiveFrom, Date effectiveTo, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        InstanceProperties properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, "description", description, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "expression", expression, methodName);
        try {
            properties = this.repositoryHelper.addEnumPropertyToInstance(this.serviceName, properties, "status", "c8fe36ac-369f-4799-af75-46b9c1343ab3", "TermAssignmentStatus", statusOrdinal, methodName);
        }
        catch (TypeErrorException error) {
            this.errorHandler.handleUnsupportedType((Exception)((Object)error), methodName, "TermAssignmentStatus");
        }
        properties = this.repositoryHelper.addIntPropertyToInstance(this.serviceName, properties, "confidence", confidence, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "createdBy", createdBy, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "steward", steward, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "source", source, methodName);
        this.linkElementToElement(userId, externalSourceGUID, externalSourceName, beanGUID, beanGUIDParameter, "Referenceable", glossaryTermGUID, glossaryTermGUIDParameter, "GlossaryTerm", false, false, this.supportedZones, "e6670973-645f-441a-bec7-6f5570345b92", "SemanticAssignment", this.setUpEffectiveDates(properties, effectiveFrom, effectiveTo), methodName);
    }

    public void removeSemanticAssignment(String userId, String externalSourceGUID, String externalSourceName, String beanGUID, String beanGUIDParameter, String glossaryTermGUID, String glossaryTermGUIDParameter, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.unlinkElementFromElement(userId, false, externalSourceGUID, externalSourceName, beanGUID, beanGUIDParameter, "Referenceable", glossaryTermGUID, glossaryTermGUIDParameter, "0db3e6ec-f5ef-4d75-ae38-b7ee6fd6ec0a", "GlossaryTerm", false, false, this.supportedZones, "e6670973-645f-441a-bec7-6f5570345b92", "SemanticAssignment", effectiveTime, methodName);
    }

    public void saveResourceListMember(String userId, String externalSourceGUID, String externalSourceName, String beanGUID, String beanGUIDParameter, String memberGUID, String memberGUIDParameter, String resourceUse, boolean watchResource, Date effectiveFrom, Date effectiveTo, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        InstanceProperties properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, "resourceUse", resourceUse, methodName);
        properties = this.repositoryHelper.addBooleanPropertyToInstance(this.serviceName, properties, "watchResource", watchResource, methodName);
        this.linkElementToElement(userId, externalSourceGUID, externalSourceName, beanGUID, beanGUIDParameter, "Referenceable", memberGUID, memberGUIDParameter, "Referenceable", false, false, this.supportedZones, "73cf5658-6a73-4ebc-8f4d-44fdfac0b437", "ResourceList", this.setUpEffectiveDates(properties, effectiveFrom, effectiveTo), methodName);
    }

    public void removeResourceListMember(String userId, String externalSourceGUID, String externalSourceName, String beanGUID, String beanGUIDParameter, String memberGUID, String memberGUIDParameter, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        if (beanGUID != null) {
            this.unlinkElementFromElement(userId, false, externalSourceGUID, externalSourceName, beanGUID, beanGUIDParameter, "Referenceable", memberGUID, memberGUIDParameter, "a32316b8-dc8c-48c5-b12b-71c1b2a080bf", "Referenceable", false, false, this.supportedZones, "73cf5658-6a73-4ebc-8f4d-44fdfac0b437", "ResourceList", effectiveTime, methodName);
        }
    }

    public List<B> getCollectionMembers(String userId, String collectionGUID, String collectionGUIDParameterName, int startFrom, int pageSize, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.getAttachedElements(userId, collectionGUID, collectionGUIDParameterName, "Collection", "5cabb76a-e25b-4bb5-8b93-768bbac005af", "CollectionMembership", "Referenceable", startFrom, pageSize, effectiveTime, methodName);
    }

    private void setKnowDuplicateClassification(String userId, EntityDetail entity, String guidParameterName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        boolean classificationNeeded = true;
        try {
            if (this.repositoryHelper.getClassificationFromEntity(this.serviceName, (EntitySummary)entity, "KnownDuplicate", methodName) == null) {
                classificationNeeded = false;
            }
        }
        catch (ClassificationErrorException classificationErrorException) {
            // empty catch block
        }
        if (classificationNeeded) {
            this.setClassificationInRepository(userId, null, null, entity, guidParameterName, "Referenceable", "e55062b2-907f-44bd-9831-255642285731", "KnownDuplicate", null, false, true, false, new Date(), methodName);
        }
    }

    public void linkElementsAsPeerDuplicates(String userId, String element1GUID, String element1GUIDParameter, String element2GUID, String element2GUIDParameter, boolean setKnownDuplicate, int statusIdentifier, String steward, String stewardTypeName, String stewardPropertyName, String source, String notes, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(element1GUID, element1GUIDParameter, methodName);
        this.invalidParameterHandler.validateGUID(element2GUID, element2GUIDParameter, methodName);
        EntityDetail entity1 = this.getEntityFromRepository(userId, element1GUID, element1GUIDParameter, "Referenceable", null, null, false, true, this.supportedZones, null, methodName);
        EntityDetail entity2 = this.getEntityFromRepository(userId, element2GUID, element2GUIDParameter, "Referenceable", null, null, false, true, this.supportedZones, null, methodName);
        if (setKnownDuplicate) {
            this.setKnowDuplicateClassification(userId, entity1, element1GUIDParameter, methodName);
            this.setKnowDuplicateClassification(userId, entity2, element2GUIDParameter, methodName);
        }
        InstanceProperties properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, "steward", steward, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "stewardTypeName", stewardTypeName, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "stewardPropertyName", stewardPropertyName, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "source", source, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "notes", notes, methodName);
        properties = this.repositoryHelper.addIntPropertyToInstance(this.serviceName, properties, "statusIdentifier", statusIdentifier, methodName);
        this.linkElementToElement(userId, null, null, element1GUID, element1GUIDParameter, "Referenceable", element2GUID, element2GUIDParameter, "Referenceable", false, true, this.supportedZones, "a94b2929-9e62-4b12-98ab-8ac45691e5bd", "PeerDuplicateLink", properties, methodName);
    }

    public void unlinkElementsAsPeerDuplicates(String userId, String element1GUID, String element1GUIDParameter, String element2GUID, String element2GUIDParameter, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(element1GUID, element1GUIDParameter, methodName);
        this.invalidParameterHandler.validateGUID(element2GUID, element2GUIDParameter, methodName);
        this.repositoryHandler.removeRelationshipBetweenEntities(userId, null, null, "a94b2929-9e62-4b12-98ab-8ac45691e5bd", "PeerDuplicateLink", element1GUID, "Referenceable", element2GUID, true, effectiveTime, methodName);
        if (this.getAttachmentLinks(userId, element1GUID, element1GUIDParameter, "Referenceable", "a94b2929-9e62-4b12-98ab-8ac45691e5bd", "PeerDuplicateLink", null, null, 0, true, 0, this.invalidParameterHandler.getMaxPagingSize(), effectiveTime, methodName) == null) {
            this.removeClassificationFromRepository(userId, null, null, element1GUID, element1GUIDParameter, "Referenceable", "e55062b2-907f-44bd-9831-255642285731", "KnownDuplicate", false, true, effectiveTime, methodName);
        }
        if (this.getAttachmentLinks(userId, element2GUID, element2GUIDParameter, "Referenceable", "a94b2929-9e62-4b12-98ab-8ac45691e5bd", "PeerDuplicateLink", null, null, 0, true, 0, this.invalidParameterHandler.getMaxPagingSize(), null, methodName) == null) {
            this.removeClassificationFromRepository(userId, null, null, element2GUID, element2GUIDParameter, "Referenceable", "e55062b2-907f-44bd-9831-255642285731", "KnownDuplicate", false, true, null, methodName);
        }
    }

    public void setVendorProperties(String userId, String referenceableGUID, Map<String, String> vendorProperties, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        block5: {
            List<EntityDetail> propertyFacets;
            block4: {
                String referenceableGUIDParameter = "referenceableGUID";
                String propertyFacetGUIDParameter = "propertyFacet[x]";
                this.invalidParameterHandler.validateUserId(userId, methodName);
                this.invalidParameterHandler.validateGUID(referenceableGUID, "referenceableGUID", methodName);
                Date effectiveTime = new Date();
                propertyFacets = this.getAttachedEntities(userId, referenceableGUID, "referenceableGUID", "Referenceable", "58c87647-ada9-4c90-a3c3-a40ace46b1f7", "ReferenceableFacet", "PropertyFacet", null, null, 0, false, false, this.supportedZones, 0, this.invalidParameterHandler.getMaxPagingSize(), effectiveTime, methodName);
                if (vendorProperties == null) break block4;
                PropertyFacetBuilder builder = new PropertyFacetBuilder(referenceableGUID + "_vendorProperties", null, "vendorProperties", vendorProperties, this.repositoryHelper, this.serviceName, this.serverName);
                if (propertyFacets != null) {
                    for (EntityDetail propertyFacet : propertyFacets) {
                        String description;
                        if (propertyFacet == null || !"vendorProperties".equals(description = this.repositoryHelper.getStringProperty(this.serviceName, "description", propertyFacet.getProperties(), methodName))) continue;
                        this.updateBeanInRepository(userId, null, null, propertyFacet.getGUID(), "propertyFacet[x]", "6403a704-aad6-41c2-8e08-b9525c006f85", "PropertyFacet", false, false, this.supportedZones, builder.getInstanceProperties(methodName), true, effectiveTime, methodName);
                    }
                } else {
                    builder.setAnchors(userId, referenceableGUID, methodName);
                    String propertyFacetGUID = this.createBeanInRepository(userId, null, null, "6403a704-aad6-41c2-8e08-b9525c006f85", "PropertyFacet", null, null, builder, methodName);
                    InstanceProperties relationshipProperties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, "source", this.serviceName, methodName);
                    this.linkElementToElement(userId, null, null, referenceableGUID, "referenceableGUID", "Referenceable", propertyFacetGUID, "propertyFacet[x]", "PropertyFacet", false, false, this.supportedZones, "58c87647-ada9-4c90-a3c3-a40ace46b1f7", "ReferenceableFacet", relationshipProperties, methodName);
                }
                break block5;
            }
            if (propertyFacets == null) break block5;
            for (EntityDetail propertyFacet : propertyFacets) {
                String description;
                if (propertyFacet == null || !"vendorProperties".equals(description = this.repositoryHelper.getStringProperty(this.serviceName, "description", propertyFacet.getProperties(), methodName))) continue;
                this.deleteBeanInRepository(userId, null, null, propertyFacet.getGUID(), "propertyFacet[x]", "6403a704-aad6-41c2-8e08-b9525c006f85", "PropertyFacet", null, null, false, false, new Date(), methodName);
            }
        }
    }

    public Map<String, String> getVendorProperties(String userId, String referenceableGUID, String referenceableGUIDParameter, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        List<EntityDetail> propertyFacets = this.getAttachedEntities(userId, referenceableGUID, referenceableGUIDParameter, "Referenceable", "58c87647-ada9-4c90-a3c3-a40ace46b1f7", "ReferenceableFacet", "PropertyFacet", null, null, 0, false, false, this.supportedZones, 0, this.invalidParameterHandler.getMaxPagingSize(), null, methodName);
        if (propertyFacets != null) {
            for (EntityDetail propertyFacet : propertyFacets) {
                String description;
                if (propertyFacet == null || !"vendorProperties".equals(description = this.repositoryHelper.getStringProperty(this.serviceName, "description", propertyFacet.getProperties(), methodName))) continue;
                return this.repositoryHelper.getStringMapFromProperty(this.serviceName, "properties", propertyFacet.getProperties(), methodName);
            }
        }
        return null;
    }
}

