/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericConverter;
import org.odpi.openmetadata.commonservices.generichandlers.ReferenceableHandler;
import org.odpi.openmetadata.commonservices.generichandlers.SchemaTypeBuilder;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.metadatasecurity.server.OpenMetadataServerSecurityVerifier;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

class SchemaElementHandler<B>
extends ReferenceableHandler<B> {
    SchemaElementHandler(OpenMetadataAPIGenericConverter<B> converter, Class<B> beanClass, String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper, String localServerUserId, OpenMetadataServerSecurityVerifier securityVerifier, List<String> supportedZones, List<String> defaultZones, List<String> publishZones, AuditLog auditLog) {
        super(converter, beanClass, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
    }

    String getAssetSchemaTypeGUID(String userId, String externalSourceGUID, String externalSourceName, String assetGUID, String assetGUIDParameterName, String assetTypeName, String schemaTypeTypeGUID, String schemaTypeTypeName, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(assetGUID, assetGUIDParameterName, methodName);
        String assetQualifiedName = this.getBeanStringPropertyFromRepository(userId, assetGUID, assetGUIDParameterName, assetTypeName, "qualifiedName", effectiveTime, methodName);
        if (assetQualifiedName == null) {
            this.invalidParameterHandler.throwUnknownElement(userId, assetGUID, assetTypeName, this.serviceName, this.serverName, methodName);
            return null;
        }
        EntityDetail schemaTypeEntity = this.getAttachedEntity(userId, assetGUID, assetGUIDParameterName, assetTypeName, "815b004d-73c6-4728-9dd9-536f4fe803cd", "AssetSchemaType", schemaTypeTypeName, false, false, this.supportedZones, effectiveTime, methodName);
        if (schemaTypeEntity == null) {
            String schemaTypeQualifiedName = "SchemaOf:" + assetQualifiedName;
            SchemaTypeBuilder builder = new SchemaTypeBuilder(schemaTypeQualifiedName, schemaTypeTypeGUID, schemaTypeTypeName, this.repositoryHelper, this.serviceName, this.serverName);
            builder.setAnchors(userId, assetGUID, methodName);
            String schemaTypeGUID = this.createBeanInRepository(userId, externalSourceGUID, externalSourceName, schemaTypeTypeGUID, schemaTypeTypeName, schemaTypeQualifiedName, "qualifiedName", builder, methodName);
            String schemaTypeGUIDParameterName = "schemaTypeGUID";
            if (schemaTypeGUID != null) {
                this.linkElementToElement(userId, externalSourceGUID, externalSourceName, assetGUID, assetGUIDParameterName, assetTypeName, schemaTypeGUID, "schemaTypeGUID", schemaTypeTypeName, false, false, this.supportedZones, "815b004d-73c6-4728-9dd9-536f4fe803cd", "AssetSchemaType", null, methodName);
            }
            return schemaTypeGUID;
        }
        return schemaTypeEntity.getGUID();
    }

    void addEmbeddedTypes(String userId, String externalSourceGUID, String externalSourceName, String schemaTypeGUID, String schemaTypeGUIDParameterName, String schemaTypeTypeName, SchemaTypeBuilder schemaTypeBuilder, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        List<SchemaTypeBuilder> schemaOptionBuilders;
        String mapFromParameterName = "mapFromSchemaType";
        String mapToParameterName = "mapToSchemaType";
        String externalParameterName = "externalSchemaType";
        String optionParameterName = "optionSchemaType";
        if (this.repositoryHelper.isTypeOf(this.serviceName, schemaTypeBuilder.getTypeName(), "ExternalSchemaType")) {
            String externalSchemaGUID = schemaTypeBuilder.getExternalSchemaTypeGUID();
            if (externalSchemaGUID != null) {
                this.linkElementToElement(userId, externalSourceGUID, externalSourceName, schemaTypeGUID, schemaTypeGUIDParameterName, schemaTypeTypeName, externalSchemaGUID, "externalSchemaType", "SchemaType", false, false, this.supportedZones, "9a5d78c2-1716-4783-bfc6-c300a9e2d092", "LinkedExternalSchemaType", null, methodName);
            }
        } else if (this.repositoryHelper.isTypeOf(this.serviceName, schemaTypeBuilder.getTypeName(), "MapSchemaType")) {
            SchemaTypeBuilder mapFromBuilder = schemaTypeBuilder.getMapFrom();
            SchemaTypeBuilder mapToBuilder = schemaTypeBuilder.getMapTo();
            String mapFromGUID = schemaTypeBuilder.getMapFromGUID();
            String mapToGUID = schemaTypeBuilder.getMapToGUID();
            if (mapFromBuilder != null) {
                mapFromGUID = this.addSchemaType(userId, externalSourceGUID, externalSourceName, mapFromBuilder.qualifiedName, mapFromBuilder, methodName);
            }
            if (mapFromGUID != null) {
                this.linkElementToElement(userId, externalSourceGUID, externalSourceName, schemaTypeGUID, schemaTypeGUIDParameterName, schemaTypeTypeName, mapFromGUID, "mapFromSchemaType", "SchemaType", false, false, this.supportedZones, "6189d444-2da4-4cd7-9332-e48a1c340b44", "MapFromElementType", null, methodName);
            }
            if (mapToBuilder != null) {
                mapToGUID = this.addSchemaType(userId, externalSourceGUID, externalSourceName, mapToBuilder.qualifiedName, mapToBuilder, methodName);
            }
            if (mapToGUID != null) {
                this.linkElementToElement(userId, externalSourceGUID, externalSourceName, schemaTypeGUID, schemaTypeGUIDParameterName, schemaTypeTypeName, mapToGUID, "mapToSchemaType", "SchemaType", false, false, this.supportedZones, "8b9856b3-451e-45fc-afc7-fddefd81a73a", "MapToElementType", null, methodName);
            }
        } else if (this.repositoryHelper.isTypeOf(this.serviceName, schemaTypeBuilder.getTypeName(), "SchemaTypeChoice") && (schemaOptionBuilders = schemaTypeBuilder.getSchemaOptions()) != null) {
            for (SchemaTypeBuilder schemaOptionBuilder : schemaOptionBuilders) {
                String optionGUID;
                if (schemaOptionBuilder == null || (optionGUID = this.addSchemaType(userId, externalSourceGUID, externalSourceName, schemaOptionBuilder.qualifiedName, schemaOptionBuilder, methodName)) == null) continue;
                this.linkElementToElement(userId, externalSourceGUID, externalSourceName, schemaTypeGUID, schemaTypeGUIDParameterName, schemaTypeTypeName, optionGUID, "optionSchemaType", "SchemaType", false, false, this.supportedZones, "5caf954a-3e33-4cbd-b17d-8b8613bd2db8", "SchemaTypeChoice", null, methodName);
            }
        }
    }

    private String addSchemaType(String userId, String externalSourceGUID, String externalSourceName, String qualifiedName, SchemaTypeBuilder schemaTypeBuilder, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String schemaTypeGUIDParameterName = "schemaTypeGUID";
        String schemaTypeGUID = this.createBeanInRepository(userId, externalSourceGUID, externalSourceName, schemaTypeBuilder.getTypeGUID(), schemaTypeBuilder.getTypeName(), qualifiedName, "qualifiedName", schemaTypeBuilder, methodName);
        this.addEmbeddedTypes(userId, externalSourceGUID, externalSourceName, schemaTypeGUID, "schemaTypeGUID", "SchemaType", schemaTypeBuilder, methodName);
        return schemaTypeGUID;
    }

    int countSchemaAttributes(String userId, String schemaElementGUID, String guidParameterName, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(schemaElementGUID, guidParameterName, methodName);
        int count = this.repositoryHandler.countAttachedRelationshipsByType(userId, schemaElementGUID, "SchemaElement", "0ffb9d87-7074-45da-a9b0-ae0859611133", "NestedSchemaAttribute", false, effectiveTime, methodName);
        if (count == 0) {
            count = this.repositoryHandler.countAttachedRelationshipsByType(userId, schemaElementGUID, "SchemaElement", "86b176a2-015c-44a6-8106-54d5d69ba661", "AttributeForSchema", false, effectiveTime, methodName);
        }
        return count;
    }

    public void setupQueryTargetRelationship(String userId, String externalSourceGUID, String externalSourceName, String schemaElementGUID, String schemaElementGUIDParameterName, String schemaElementTypeName, String queryId, String query, String queryTargetGUID, String queryTargetGUIDParameterName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String queryParameterName = "query";
        this.invalidParameterHandler.validateObject((Object)query, "query", methodName);
        InstanceProperties properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, "query", query, methodName);
        if (queryId != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "queryId", queryId, methodName);
        }
        this.linkElementToElement(userId, externalSourceGUID, externalSourceName, schemaElementGUID, schemaElementGUIDParameterName, schemaElementTypeName, queryTargetGUID, queryTargetGUIDParameterName, "SchemaElement", false, false, this.supportedZones, "1c2622b7-ac21-413c-89e1-6f61f348cd19", "DerivedSchemaTypeQueryTarget", properties, methodName);
    }

    public void updateQueryTargetRelationship(String userId, String externalSourceGUID, String externalSourceName, String schemaElementGUID, String schemaElementGUIDParameterName, String schemaElementTypeName, String queryId, String query, String queryTargetGUID, String queryTargetGUIDParameterName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String queryParameterName = "query";
        this.invalidParameterHandler.validateObject((Object)query, "query", methodName);
        InstanceProperties properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, "query", query, methodName);
        if (queryId != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "queryId", queryId, methodName);
        }
        this.updateElementToElementLink(userId, externalSourceGUID, externalSourceName, schemaElementGUID, schemaElementGUIDParameterName, schemaElementTypeName, queryTargetGUID, queryTargetGUIDParameterName, "SchemaElement", "1c2622b7-ac21-413c-89e1-6f61f348cd19", "DerivedSchemaTypeQueryTarget", properties, methodName);
    }

    public void clearQueryTargetRelationship(String userId, String externalSourceGUID, String externalSourceName, String schemaElementGUID, String schemaElementGUIDParameterName, String schemaElementTypeName, String queryTargetGUID, String queryTargetGUIDParameterName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.unlinkElementFromElement(userId, false, externalSourceGUID, externalSourceName, schemaElementGUID, schemaElementGUIDParameterName, schemaElementTypeName, queryTargetGUID, queryTargetGUIDParameterName, "718d4244-8559-49ed-ad5a-10e5c305a656", "SchemaElement", false, false, "1c2622b7-ac21-413c-89e1-6f61f348cd19", "DerivedSchemaTypeQueryTarget", null, methodName);
    }
}

