/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericConverter;
import org.odpi.openmetadata.commonservices.generichandlers.SchemaElementHandler;
import org.odpi.openmetadata.commonservices.generichandlers.SchemaTypeBuilder;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.metadatasecurity.server.OpenMetadataServerSecurityVerifier;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class SchemaTypeHandler<B>
extends SchemaElementHandler<B> {
    private OpenMetadataAPIGenericConverter<B> schemaTypeConverter;

    public SchemaTypeHandler(OpenMetadataAPIGenericConverter<B> converter, Class<B> beanClass, String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper, String localServerUserId, OpenMetadataServerSecurityVerifier securityVerifier, List<String> supportedZones, List<String> defaultZones, List<String> publishZones, AuditLog auditLog) {
        super(converter, beanClass, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
        this.schemaTypeConverter = converter;
    }

    public String addSchemaType(String userId, String externalSourceGUID, String externalSourceName, SchemaTypeBuilder schemaTypeBuilder, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String schemaTypeGUIDParameterName = "schemaTypeGUID";
        String schemaTypeGUID = this.createBeanInRepository(userId, externalSourceGUID, externalSourceName, schemaTypeBuilder.getTypeGUID(), schemaTypeBuilder.getTypeName(), schemaTypeBuilder.getQualifiedName(), "qualifiedName", schemaTypeBuilder, methodName);
        this.addEmbeddedTypes(userId, externalSourceGUID, externalSourceName, schemaTypeGUID, "schemaTypeGUID", schemaTypeBuilder.getTypeName(), schemaTypeBuilder, methodName);
        return schemaTypeGUID;
    }

    public String addSchemaType(String userId, String externalSourceGUID, String externalSourceName, String qualifiedName, String displayName, String description, String versionNumber, boolean isDeprecated, String author, String usage, String encodingStandard, String namespace, Map<String, String> additionalProperties, String suppliedTypeName, Map<String, Object> extendedProperties, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        String typeName = "SchemaType";
        if (suppliedTypeName != null) {
            typeName = suppliedTypeName;
        }
        String typeGUID = this.invalidParameterHandler.validateTypeName(typeName, "SchemaType", this.serviceName, methodName, this.repositoryHelper);
        SchemaTypeBuilder builder = new SchemaTypeBuilder(qualifiedName, displayName, description, versionNumber, isDeprecated, author, usage, encodingStandard, namespace, additionalProperties, typeGUID, typeName, extendedProperties, this.repositoryHelper, this.serviceName, this.serverName);
        return this.addSchemaType(userId, externalSourceGUID, externalSourceName, builder, methodName);
    }

    public String addPrimitiveSchemaType(String userId, String externalSourceGUID, String externalSourceName, String qualifiedName, String displayName, String description, String versionNumber, boolean isDeprecated, String author, String usage, String encodingStandard, String namespace, String dataType, String defaultValue, Map<String, String> additionalProperties, String suppliedTypeName, Map<String, Object> extendedProperties, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        String typeName = "PrimitiveSchemaType";
        if (suppliedTypeName != null) {
            typeName = suppliedTypeName;
        }
        String typeGUID = this.invalidParameterHandler.validateTypeName(typeName, "PrimitiveSchemaType", this.serviceName, methodName, this.repositoryHelper);
        SchemaTypeBuilder builder = new SchemaTypeBuilder(qualifiedName, displayName, description, versionNumber, isDeprecated, author, usage, encodingStandard, namespace, additionalProperties, typeGUID, typeName, extendedProperties, this.repositoryHelper, this.serviceName, this.serverName);
        builder.setDataType(dataType);
        builder.setDefaultValue(defaultValue);
        return this.addSchemaType(userId, externalSourceGUID, externalSourceName, builder, methodName);
    }

    public String addLiteralSchemaType(String userId, String externalSourceGUID, String externalSourceName, String qualifiedName, String displayName, String description, String versionNumber, boolean isDeprecated, String author, String usage, String encodingStandard, String namespace, String dataType, String fixedValue, Map<String, String> additionalProperties, String suppliedTypeName, Map<String, Object> extendedProperties, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        String typeName = "LiteralSchemaType";
        if (suppliedTypeName != null) {
            typeName = suppliedTypeName;
        }
        String typeGUID = this.invalidParameterHandler.validateTypeName(typeName, "LiteralSchemaType", this.serviceName, methodName, this.repositoryHelper);
        SchemaTypeBuilder builder = new SchemaTypeBuilder(qualifiedName, displayName, description, versionNumber, isDeprecated, author, usage, encodingStandard, namespace, additionalProperties, typeGUID, typeName, extendedProperties, this.repositoryHelper, this.serviceName, this.serverName);
        builder.setDataType(dataType);
        builder.setFixedValue(fixedValue);
        return this.addSchemaType(userId, externalSourceGUID, externalSourceName, builder, methodName);
    }

    public String addEnumSchemaType(String userId, String externalSourceGUID, String externalSourceName, String qualifiedName, String displayName, String description, String versionNumber, boolean isDeprecated, String author, String usage, String encodingStandard, String namespace, String dataType, String defaultValue, String validValuesSetGUID, Map<String, String> additionalProperties, String suppliedTypeName, Map<String, Object> extendedProperties, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        String typeName = "EnumSchemaType";
        if (suppliedTypeName != null) {
            typeName = suppliedTypeName;
        }
        String typeGUID = this.invalidParameterHandler.validateTypeName(typeName, "EnumSchemaType", this.serviceName, methodName, this.repositoryHelper);
        SchemaTypeBuilder builder = new SchemaTypeBuilder(qualifiedName, displayName, description, versionNumber, isDeprecated, author, usage, encodingStandard, namespace, additionalProperties, typeGUID, typeName, extendedProperties, this.repositoryHelper, this.serviceName, this.serverName);
        builder.setDataType(dataType);
        builder.setDefaultValue(defaultValue);
        builder.setValidValuesSetGUID(validValuesSetGUID);
        return this.addSchemaType(userId, externalSourceGUID, externalSourceName, builder, methodName);
    }

    public String addStructSchemaType(String userId, String externalSourceGUID, String externalSourceName, String qualifiedName, String displayName, String description, String versionNumber, boolean isDeprecated, String author, String usage, String encodingStandard, String namespace, Map<String, String> additionalProperties, String suppliedTypeName, Map<String, Object> extendedProperties, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        String typeName = "StructSchemaType";
        if (suppliedTypeName != null) {
            typeName = suppliedTypeName;
        }
        String typeGUID = this.invalidParameterHandler.validateTypeName(typeName, "StructSchemaType", this.serviceName, methodName, this.repositoryHelper);
        SchemaTypeBuilder builder = new SchemaTypeBuilder(qualifiedName, displayName, description, versionNumber, isDeprecated, author, usage, encodingStandard, namespace, additionalProperties, typeGUID, typeName, extendedProperties, this.repositoryHelper, this.serviceName, this.serverName);
        return this.addSchemaType(userId, externalSourceGUID, externalSourceName, builder, methodName);
    }

    public String addSchemaTypeChoice(String userId, String externalSourceGUID, String externalSourceName, String qualifiedName, String displayName, String description, String versionNumber, boolean isDeprecated, String author, String usage, String encodingStandard, String namespace, Map<String, String> additionalProperties, String suppliedTypeName, Map<String, Object> extendedProperties, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        String typeName = "SchemaTypeChoice";
        if (suppliedTypeName != null) {
            typeName = suppliedTypeName;
        }
        String typeGUID = this.invalidParameterHandler.validateTypeName(typeName, "SchemaTypeChoice", this.serviceName, methodName, this.repositoryHelper);
        SchemaTypeBuilder builder = new SchemaTypeBuilder(qualifiedName, displayName, description, versionNumber, isDeprecated, author, usage, encodingStandard, namespace, additionalProperties, typeGUID, typeName, extendedProperties, this.repositoryHelper, this.serviceName, this.serverName);
        return this.addSchemaType(userId, externalSourceGUID, externalSourceName, builder, methodName);
    }

    public String addMapSchemaType(String userId, String externalSourceGUID, String externalSourceName, String qualifiedName, String displayName, String description, String versionNumber, boolean isDeprecated, String author, String usage, String encodingStandard, String namespace, String mapFromSchemaTypeGUID, String mapToSchemaTypeGUID, Map<String, String> additionalProperties, String suppliedTypeName, Map<String, Object> extendedProperties, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String qualifiedNameParameterName = "qualifiedName";
        String fromGUIDParameterName = "mapFromSchemaTypeGUID";
        String toGUIDParameterName = "mapToSchemaTypeGUID";
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        this.invalidParameterHandler.validateGUID(mapFromSchemaTypeGUID, "mapFromSchemaTypeGUID", methodName);
        this.invalidParameterHandler.validateGUID(mapToSchemaTypeGUID, "mapToSchemaTypeGUID", methodName);
        String typeName = "SchemaTypeChoice";
        if (suppliedTypeName != null) {
            typeName = suppliedTypeName;
        }
        String typeGUID = this.invalidParameterHandler.validateTypeName(typeName, "SchemaTypeChoice", this.serviceName, methodName, this.repositoryHelper);
        SchemaTypeBuilder builder = new SchemaTypeBuilder(qualifiedName, displayName, description, versionNumber, isDeprecated, author, usage, encodingStandard, namespace, additionalProperties, typeGUID, typeName, extendedProperties, this.repositoryHelper, this.serviceName, this.serverName);
        builder.setMapGUIDs(mapFromSchemaTypeGUID, mapToSchemaTypeGUID);
        return this.addSchemaType(userId, externalSourceGUID, externalSourceName, builder, methodName);
    }

    public String createSchemaTypeFromTemplate(String userId, String externalSourceGUID, String externalSourceName, String templateGUID, String qualifiedName, String displayName, String description, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String templateGUIDParameterName = "templateGUID";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(templateGUID, "templateGUID", methodName);
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        SchemaTypeBuilder builder = new SchemaTypeBuilder(qualifiedName, displayName, description, this.repositoryHelper, this.serviceName, this.serverName);
        return this.createBeanFromTemplate(userId, externalSourceGUID, externalSourceName, templateGUID, "templateGUID", "5bd4a3e7-d22d-4a3d-a115-066ee8e0754f", "SchemaType", qualifiedName, "qualifiedName", builder, methodName);
    }

    public void updateSchemaType(String userId, String externalSourceGUID, String externalSourceName, String existingSchemaTypeGUID, String existingSchemaTypeGUIDParameterName, SchemaTypeBuilder builder) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "updateSchemaType";
        this.updateSchemaType(userId, externalSourceGUID, externalSourceName, existingSchemaTypeGUID, existingSchemaTypeGUIDParameterName, builder, false, "updateSchemaType");
    }

    public void updateSchemaType(String userId, String externalSourceGUID, String externalSourceName, String existingSchemaTypeGUID, String existingSchemaTypeGUIDParameterName, SchemaTypeBuilder builder, boolean isMergeUpdate, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        InstanceProperties properties = builder.getInstanceProperties(methodName);
        this.updateBeanInRepository(userId, externalSourceGUID, externalSourceName, existingSchemaTypeGUID, existingSchemaTypeGUIDParameterName, this.getSchemaTypeTypeGUID(builder), this.getSchemaTypeTypeName(builder), false, false, this.supportedZones, properties, isMergeUpdate, this.getEffectiveTime(properties), methodName);
    }

    public void updateSchemaType(String userId, String externalSourceGUID, String externalSourceName, String schemaTypeGUID, String qualifiedName, String displayName, String description, String versionNumber, boolean isDeprecated, String author, String usage, String encodingStandard, String namespace, Map<String, String> additionalProperties, String suppliedTypeName, Map<String, Object> extendedProperties, boolean isMergeUpdate, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String qualifiedNameParameterName = "qualifiedName";
        String elementGUIDParameterName = "schemaTypeGUID";
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        String typeName = "SchemaType";
        if (suppliedTypeName != null) {
            typeName = suppliedTypeName;
        }
        String typeGUID = this.invalidParameterHandler.validateTypeName(typeName, "SchemaType", this.serviceName, methodName, this.repositoryHelper);
        SchemaTypeBuilder builder = new SchemaTypeBuilder(qualifiedName, displayName, description, versionNumber, isDeprecated, author, usage, encodingStandard, namespace, additionalProperties, typeGUID, typeName, extendedProperties, this.repositoryHelper, this.serviceName, this.serverName);
        this.updateSchemaType(userId, externalSourceGUID, externalSourceName, schemaTypeGUID, "schemaTypeGUID", builder, isMergeUpdate, methodName);
    }

    private String getSchemaTypeTypeGUID(SchemaTypeBuilder builder) {
        if (builder.getTypeGUID() != null) {
            return builder.getTypeGUID();
        }
        return "5bd4a3e7-d22d-4a3d-a115-066ee8e0754f";
    }

    private String getSchemaTypeTypeName(SchemaTypeBuilder builder) {
        if (builder.getTypeName() != null) {
            return builder.getTypeName();
        }
        return "SchemaType";
    }

    public void removeSchemaType(String userId, String externalSourceGUID, String externalSourceName, String schemaTypeGUID, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String guidParameterName = "schemaTypeGUID";
        this.deleteBeanInRepository(userId, externalSourceGUID, externalSourceName, schemaTypeGUID, "schemaTypeGUID", "5bd4a3e7-d22d-4a3d-a115-066ee8e0754f", "SchemaType", null, null, false, false, new Date(), methodName);
    }

    public B getSchemaTypeForAsset(String userId, String assetGUID, String assetGUIDParameterName, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getSchemaTypeForParent(userId, assetGUID, assetGUIDParameterName, "Asset", "815b004d-73c6-4728-9dd9-536f4fe803cd", "AssetSchemaType", effectiveTime, methodName);
    }

    public B getSchemaTypeForPort(String userId, String portGUID, String portGUIDParameterName, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getSchemaTypeForParent(userId, portGUID, portGUIDParameterName, "Port", "B216fA00-8281-F9CC-9911-Ae6377f2b457", "PortSchema", effectiveTime, methodName);
    }

    public B getSchemaTypeForParent(String userId, String parentGUID, String parentGUIDParameterName, String parentTypeName, String relationshipTypeGUID, String relationshipTypeName, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        EntityDetail schemaTypeEntity = this.getAttachedEntity(userId, parentGUID, parentGUIDParameterName, parentTypeName, relationshipTypeGUID, relationshipTypeName, "SchemaType", false, false, this.supportedZones, effectiveTime, methodName);
        return this.getSchemaTypeFromEntity(userId, schemaTypeEntity, effectiveTime, methodName);
    }

    public B getSchemaType(String userId, String schemaTypeGUID, String guidParameterName, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        EntityDetail schemaTypeEntity = this.getEntityFromRepository(userId, schemaTypeGUID, guidParameterName, "SchemaType", null, null, false, false, this.supportedZones, effectiveTime, methodName);
        return this.getSchemaTypeFromEntity(userId, schemaTypeEntity, effectiveTime, methodName);
    }

    public List<B> findSchemaTypes(String userId, String searchString, int startFrom, int pageSize, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.findSchemaTypes(userId, "SchemaType", searchString, startFrom, pageSize, effectiveTime, methodName);
    }

    public List<B> findSchemaTypes(String userId, String suppliedTypeName, String searchString, int startFrom, int pageSize, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String searchStringParameterName = "searchString";
        String typeName = "SchemaType";
        if (suppliedTypeName != null) {
            typeName = suppliedTypeName;
        }
        String typeGUID = this.invalidParameterHandler.validateTypeName(typeName, "SchemaType", this.serviceName, methodName, this.repositoryHelper);
        List<EntityDetail> entities = this.findEntities(userId, searchString, "searchString", typeGUID, typeName, null, null, null, startFrom, pageSize, effectiveTime, methodName);
        return this.getSchemaTypesFromEntities(userId, entities, effectiveTime, methodName);
    }

    public List<B> getSchemaTypeByName(String userId, String name, int startFrom, int pageSize, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.getSchemaTypeByName(userId, "SchemaType", name, startFrom, pageSize, effectiveTime, methodName);
    }

    public List<B> getSchemaTypeByName(String userId, String suppliedTypeName, String name, int startFrom, int pageSize, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String nameParameterName = "name";
        String typeName = "SchemaType";
        if (suppliedTypeName != null) {
            typeName = suppliedTypeName;
        }
        String typeGUID = this.invalidParameterHandler.validateTypeName(typeName, "SchemaType", this.serviceName, methodName, this.repositoryHelper);
        ArrayList<String> specificMatchPropertyNames = new ArrayList<String>();
        specificMatchPropertyNames.add("qualifiedName");
        specificMatchPropertyNames.add("displayName");
        List<EntityDetail> entities = this.getEntitiesByValue(userId, name, "name", typeGUID, typeName, specificMatchPropertyNames, true, null, null, false, false, this.supportedZones, null, startFrom, pageSize, effectiveTime, methodName);
        return this.getSchemaTypesFromEntities(userId, entities, effectiveTime, methodName);
    }

    public B getSchemaTypeForElement(String userId, String parentElementGUID, String parentElementTypeName, Date effectiveTime, String methodName) {
        String parentElementGUIDParameterName = "parentElementGUID";
        return null;
    }

    private List<B> getSchemaTypesFromEntities(String userId, List<EntityDetail> schemaTypeEntities, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        ArrayList<B> results = new ArrayList<B>();
        if (schemaTypeEntities != null) {
            for (EntityDetail entity : schemaTypeEntities) {
                if (entity == null) continue;
                results.add(this.getSchemaTypeFromEntity(userId, entity, effectiveTime, methodName));
            }
        }
        if (results.isEmpty()) {
            return null;
        }
        return results;
    }

    private B getSchemaTypeFromEntity(String userId, EntityDetail schemaTypeEntity, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        if (schemaTypeEntity != null && schemaTypeEntity.getType() != null) {
            return this.getSchemaTypeFromInstance(userId, (InstanceHeader)schemaTypeEntity, schemaTypeEntity.getType().getTypeDefName(), schemaTypeEntity.getProperties(), schemaTypeEntity.getClassifications(), effectiveTime, methodName);
        }
        return null;
    }

    public B getSchemaTypeFromInstance(String userId, InstanceHeader schemaRootHeader, String schemaRootTypeName, InstanceProperties instanceProperties, List<Classification> entityClassifications, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        List<EntityDetail> schemaTypeOptionsEntities;
        EntityDetail externalSchemaTypeEntity;
        String schemaGUIDParameterName = "schemaRootGUID";
        int attributeCount = 0;
        String validValuesSetGUID = null;
        String externalSchemaTypeGUID = null;
        Object externalSchemaType = null;
        String mapToSchemaTypeGUID = null;
        Object mapToSchemaType = null;
        String mapFromSchemaTypeGUID = null;
        Object mapFromSchemaType = null;
        ArrayList<String> schemaTypeOptionGUIDs = null;
        ArrayList<B> schemaTypeOptions = null;
        if (this.repositoryHelper.isTypeOf(this.serviceName, schemaRootTypeName, "ExternalSchemaType") && (externalSchemaTypeEntity = this.getAttachedEntity(userId, schemaRootHeader.getGUID(), "schemaRootGUID", "SchemaElement", "9a5d78c2-1716-4783-bfc6-c300a9e2d092", "LinkedExternalSchemaType", "SchemaType", 2, false, false, this.supportedZones, effectiveTime, methodName)) != null) {
            externalSchemaTypeGUID = externalSchemaTypeEntity.getGUID();
            externalSchemaType = this.getSchemaTypeFromEntity(userId, externalSchemaTypeEntity, effectiveTime, methodName);
        }
        if (this.repositoryHelper.isTypeOf(this.serviceName, schemaRootTypeName, "ComplexSchemaType")) {
            attributeCount = this.countSchemaAttributes(userId, schemaRootHeader.getGUID(), "schemaRootGUID", effectiveTime, methodName);
        } else if (this.repositoryHelper.isTypeOf(this.serviceName, schemaRootTypeName, "EnumSchemaType")) {
            EntityDetail validValuesSetEntity = this.getAttachedEntity(userId, schemaRootHeader.getGUID(), "schemaRootGUID", "SchemaElement", "c5d48b73-eadd-47db-ab64-3be99b2fb32d", "ValidValuesAssignment", "ValidValuesSet", false, false, this.supportedZones, effectiveTime, methodName);
            if (validValuesSetEntity != null) {
                validValuesSetGUID = validValuesSetEntity.getGUID();
            }
        } else if (this.repositoryHelper.isTypeOf(this.serviceName, schemaRootTypeName, "MapSchemaType")) {
            EntityDetail mapToSchemaTypeEntity;
            EntityDetail mapFromSchemaTypeEntity = this.getAttachedEntity(userId, schemaRootHeader.getGUID(), "schemaRootGUID", "SchemaElement", "6189d444-2da4-4cd7-9332-e48a1c340b44", "MapFromElementType", "SchemaType", false, false, this.supportedZones, effectiveTime, methodName);
            if (mapFromSchemaTypeEntity != null) {
                mapFromSchemaTypeGUID = mapFromSchemaTypeEntity.getGUID();
                mapFromSchemaType = this.getSchemaTypeFromEntity(userId, mapFromSchemaTypeEntity, effectiveTime, methodName);
            }
            if ((mapToSchemaTypeEntity = this.getAttachedEntity(userId, schemaRootHeader.getGUID(), "schemaRootGUID", "SchemaElement", "8b9856b3-451e-45fc-afc7-fddefd81a73a", "MapToElementType", "SchemaType", false, false, this.supportedZones, effectiveTime, methodName)) != null) {
                mapToSchemaTypeGUID = mapToSchemaTypeEntity.getGUID();
                mapToSchemaType = this.getSchemaTypeFromEntity(userId, mapToSchemaTypeEntity, effectiveTime, methodName);
            }
        } else if (this.repositoryHelper.isTypeOf(this.serviceName, schemaRootTypeName, "SchemaTypeChoice") && (schemaTypeOptionsEntities = this.getAttachedEntities(userId, schemaRootHeader.getGUID(), "schemaRootGUID", "SchemaElement", "eb4f1f98-c649-4560-8a46-da17c02764a9", "SchemaTypeOption", "SchemaType", null, null, 0, false, false, this.supportedZones, 0, this.invalidParameterHandler.getMaxPagingSize(), effectiveTime, methodName)) != null && !schemaTypeOptionsEntities.isEmpty()) {
            schemaTypeOptionGUIDs = new ArrayList<String>();
            schemaTypeOptions = new ArrayList<B>();
            for (EntityDetail schemaTypeOptionEntity : schemaTypeOptionsEntities) {
                if (schemaTypeOptionEntity == null) continue;
                schemaTypeOptionGUIDs.add(schemaTypeOptionEntity.getGUID());
                schemaTypeOptions.add(this.getSchemaTypeFromEntity(userId, schemaTypeOptionEntity, effectiveTime, methodName));
            }
        }
        List<Relationship> queryTargets = this.getAttachmentLinks(userId, schemaRootHeader.getGUID(), "schemaRootGUID", "SchemaElement", "1c2622b7-ac21-413c-89e1-6f61f348cd19", "DerivedSchemaTypeQueryTarget", null, "SchemaElement", 2, false, 0, 0, effectiveTime, methodName);
        return this.schemaTypeConverter.getNewSchemaTypeBean(this.beanClass, schemaRootHeader, schemaRootTypeName, instanceProperties, entityClassifications, attributeCount, validValuesSetGUID, externalSchemaTypeGUID, externalSchemaType, mapFromSchemaTypeGUID, mapFromSchemaType, mapToSchemaTypeGUID, mapToSchemaType, schemaTypeOptionGUIDs, schemaTypeOptions, queryTargets, methodName);
    }
}

