/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.util.Date;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericConverter;
import org.odpi.openmetadata.commonservices.generichandlers.ReferenceableHandler;
import org.odpi.openmetadata.commonservices.generichandlers.SoftwareServerCapabilityBuilder;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.metadatasecurity.server.OpenMetadataServerSecurityVerifier;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class SoftwareServerCapabilityHandler<B>
extends ReferenceableHandler<B> {
    public SoftwareServerCapabilityHandler(OpenMetadataAPIGenericConverter<B> converter, Class<B> beanClass, String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper, String localServerUserId, OpenMetadataServerSecurityVerifier securityVerifier, List<String> supportedZones, List<String> defaultZones, List<String> publishZones, AuditLog auditLog) {
        super(converter, beanClass, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
    }

    public String createFileSystem(String userId, String externalSourceGUID, String externalSourceName, String uniqueName, String displayName, String description, String type, String version, String patchLevel, String source, String format, String encryption, Map<String, String> additionalProperties, Map<String, String> vendorProperties, Date effectiveFrom, Date effectiveTo, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        SoftwareServerCapabilityBuilder builder = new SoftwareServerCapabilityBuilder(uniqueName, displayName, description, type, version, patchLevel, source, additionalProperties, "82efa1fa-501f-4ac7-942c-6536c4a1cd61", "DataManager", null, this.repositoryHelper, this.serviceName, this.serverName);
        builder.setEffectivityDates(effectiveFrom, effectiveTo);
        builder.setFileSystemClassification(userId, format, encryption, methodName);
        String fileSystemGUID = this.createBeanInRepository(userId, externalSourceGUID, externalSourceName, "82efa1fa-501f-4ac7-942c-6536c4a1cd61", "DataManager", uniqueName, "qualifiedName", builder, methodName);
        if (fileSystemGUID != null) {
            this.setVendorProperties(userId, fileSystemGUID, vendorProperties, methodName);
        }
        return fileSystemGUID;
    }

    public String createSoftwareServerCapability(String userId, String externalSourceGUID, String externalSourceName, String specializedTypeName, String classificationName, String uniqueName, String displayName, String description, String type, String version, String patchLevel, String source, Map<String, String> additionalProperties, Map<String, Object> extendedProperties, Map<String, String> vendorProperties, Date effectiveFrom, Date effectiveTo, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String capabilityGUID;
        String typeGUID = "fe30a033-8f86-4d17-8986-e6166fa24177";
        String typeName = "SoftwareServerCapability";
        if (specializedTypeName != null) {
            typeName = specializedTypeName;
            typeGUID = this.invalidParameterHandler.validateTypeName(typeName, "SoftwareServerCapability", this.serviceName, methodName, this.repositoryHelper);
        }
        SoftwareServerCapabilityBuilder builder = new SoftwareServerCapabilityBuilder(uniqueName, displayName, description, type, version, patchLevel, source, additionalProperties, typeGUID, typeName, extendedProperties, this.repositoryHelper, this.serviceName, this.serverName);
        builder.setEffectivityDates(effectiveFrom, effectiveTo);
        if (classificationName != null) {
            builder.setCapabilityTypeClassification(userId, classificationName, methodName);
        }
        if ((capabilityGUID = this.createBeanInRepository(userId, externalSourceGUID, externalSourceName, typeGUID, typeName, uniqueName, "qualifiedName", builder, methodName)) != null) {
            this.setVendorProperties(userId, capabilityGUID, vendorProperties, methodName);
        }
        return capabilityGUID;
    }

    public String createSoftwareServerCapability(String userId, String externalSourceGUID, String externalSourceName, String specializedTypeGUID, String specializedTypeName, String classificationName, String uniqueName, String displayName, String description, String type, String version, String patchLevel, String source, Map<String, String> additionalProperties, Map<String, String> vendorProperties, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.createSoftwareServerCapability(userId, externalSourceGUID, externalSourceName, specializedTypeName, classificationName, uniqueName, displayName, description, type, version, patchLevel, source, additionalProperties, null, vendorProperties, null, null, methodName);
    }

    public String createSoftwareServerCapabilityFromTemplate(String userId, String externalSourceGUID, String externalSourceName, String templateGUID, String templateGUIDParameterName, String qualifiedName, String qualifiedNameParameterName, String displayName, String description, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(templateGUID, templateGUIDParameterName, methodName);
        this.invalidParameterHandler.validateName(qualifiedName, qualifiedNameParameterName, methodName);
        SoftwareServerCapabilityBuilder builder = new SoftwareServerCapabilityBuilder(qualifiedName, displayName, description, this.repositoryHelper, this.serviceName, this.serverName);
        return this.createBeanFromTemplate(userId, externalSourceGUID, externalSourceName, templateGUID, templateGUIDParameterName, "fe30a033-8f86-4d17-8986-e6166fa24177", "SoftwareServerCapability", qualifiedName, "qualifiedName", builder, methodName);
    }

    public void addSoftwareServerCapabilityClassification(String userId, String externalSourceGUID, String externalSourceName, String softwareServerCapabilityGUID, String softwareServerCapabilityGUIDParameterName, String classificationName, Date effectiveFrom, Date effectiveTo, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String classificationParameterName = "classificationName";
        String classificationTypeGUID = this.invalidParameterHandler.validateTypeName(classificationName, null, this.serviceName, methodName, this.repositoryHelper);
        this.invalidParameterHandler.validateGUID(classificationName, "classificationName", methodName);
        this.setClassificationInRepository(userId, externalSourceGUID, externalSourceName, softwareServerCapabilityGUID, softwareServerCapabilityGUIDParameterName, "SoftwareServerCapability", classificationTypeGUID, classificationName, this.setUpEffectiveDates(null, effectiveFrom, effectiveTo), false, false, false, new Date(), methodName);
    }

    public void updateSoftwareServerCapability(String userId, String externalSourceGUID, String externalSourceName, String capabilityGUID, String capabilityGUIDParameterName, String uniqueName, String displayName, String description, String type, String version, String patchLevel, String source, Map<String, String> additionalProperties, Map<String, Object> extendedProperties, Map<String, String> vendorProperties, boolean isMergeUpdate, Date effectiveFrom, Date effectiveTo, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String typeGUID = "fe30a033-8f86-4d17-8986-e6166fa24177";
        String typeName = "SoftwareServerCapability";
        SoftwareServerCapabilityBuilder builder = new SoftwareServerCapabilityBuilder(uniqueName, displayName, description, type, version, patchLevel, source, additionalProperties, typeGUID, typeName, extendedProperties, this.repositoryHelper, this.serviceName, this.serverName);
        builder.setEffectivityDates(effectiveFrom, effectiveTo);
        this.updateBeanInRepository(userId, externalSourceGUID, externalSourceName, capabilityGUID, capabilityGUIDParameterName, typeGUID, typeName, false, false, this.supportedZones, builder.getInstanceProperties(methodName), isMergeUpdate, this.getEffectiveTime(effectiveFrom, effectiveTo), methodName);
        this.setVendorProperties(userId, capabilityGUID, vendorProperties, methodName);
    }

    public List<String> getSoftwareServerCapabilityGUIDsByType(String userId, String typeGUID, String typeName, int startingFrom, int maxPageSize, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.getBeanGUIDsByType(userId, typeGUID, typeName, null, false, false, this.supportedZones, startingFrom, maxPageSize, effectiveTime, methodName);
    }

    public List<B> getSoftwareServerCapabilitiesByType(String userId, String typeGUID, String typeName, int startingFrom, int maxPageSize, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.getBeansByType(userId, typeGUID, typeName, null, false, false, this.supportedZones, startingFrom, maxPageSize, effectiveTime, methodName);
    }

    public List<B> getSoftwareServerCapabilitiesByClassification(String userId, String classificationName, int startingFrom, int maxPageSize, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.getBeansByClassification(userId, "fe30a033-8f86-4d17-8986-e6166fa24177", classificationName, false, false, startingFrom, maxPageSize, effectiveTime, methodName);
    }

    public List<String> getSoftwareServerCapabilityGUIDsByClassification(String userId, String classificationName, int startingFrom, int maxPageSize, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.getBeanGUIDsByClassification(userId, "fe30a033-8f86-4d17-8986-e6166fa24177", classificationName, false, false, startingFrom, maxPageSize, new Date(), methodName);
    }
}

