/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericConverter;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericHandler;
import org.odpi.openmetadata.commonservices.generichandlers.SubjectAreaBuilder;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.metadatasecurity.server.OpenMetadataServerSecurityVerifier;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class SubjectAreaHandler<B>
extends OpenMetadataAPIGenericHandler<B> {
    public SubjectAreaHandler(OpenMetadataAPIGenericConverter<B> converter, Class<B> beanClass, String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper, String localServerUserId, OpenMetadataServerSecurityVerifier securityVerifier, List<String> supportedZones, List<String> defaultZones, List<String> publishZones, AuditLog auditLog) {
        super(converter, beanClass, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
    }

    public String createSubjectArea(String userId, String externalSourceGUID, String externalSourceName, String qualifiedName, String displayName, String description, String usage, String scope, int domainIdentifier, Map<String, String> additionalProperties, String suppliedTypeName, Map<String, Object> extendedProperties, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String typeName = "SubjectAreaDefinition";
        if (suppliedTypeName != null) {
            typeName = suppliedTypeName;
        }
        String typeGUID = this.invalidParameterHandler.validateTypeName(typeName, "SubjectAreaDefinition", this.serviceName, methodName, this.repositoryHelper);
        SubjectAreaBuilder builder = new SubjectAreaBuilder(qualifiedName, displayName, description, usage, scope, domainIdentifier, additionalProperties, typeGUID, typeName, extendedProperties, this.repositoryHelper, this.serviceName, this.serverName);
        return this.createBeanInRepository(userId, externalSourceGUID, externalSourceName, typeGUID, typeName, qualifiedName, "qualifiedName", builder, methodName);
    }

    public void updateSubjectArea(String userId, String externalSourceGUID, String externalSourceName, String subjectAreaGUID, String subjectAreaGUIDParameterName, String qualifiedName, String displayName, String description, String criteria, String scope, int domainIdentifier, Map<String, String> additionalProperties, String suppliedTypeName, Map<String, Object> extendedProperties, boolean isMergeUpdate, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String typeName = "SubjectAreaDefinition";
        if (suppliedTypeName != null) {
            typeName = suppliedTypeName;
        }
        String typeGUID = this.invalidParameterHandler.validateTypeName(typeName, "SubjectAreaDefinition", this.serviceName, methodName, this.repositoryHelper);
        SubjectAreaBuilder builder = new SubjectAreaBuilder(qualifiedName, displayName, description, criteria, scope, domainIdentifier, additionalProperties, typeGUID, typeName, extendedProperties, this.repositoryHelper, this.serviceName, this.serverName);
        this.updateBeanInRepository(userId, externalSourceGUID, externalSourceName, subjectAreaGUID, subjectAreaGUIDParameterName, "d28c3839-bc6f-41ad-a882-5667e01fea72", "SubjectAreaDefinition", false, false, this.supportedZones, builder.getInstanceProperties(methodName), isMergeUpdate, new Date(), methodName);
    }

    public B getSubjectArea(String userId, String qualifiedName, String qualifiedNameParameter, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.getBeanByUniqueName(userId, qualifiedName, qualifiedNameParameter, "qualifiedName", "d28c3839-bc6f-41ad-a882-5667e01fea72", "SubjectAreaDefinition", null, methodName);
    }

    public String getSubjectAreaParentGUID(String userId, String subjectAreaGUID, String subjectAreaGUIDParameter, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        EntityDetail entity = this.getAttachedEntity(userId, subjectAreaGUID, subjectAreaGUIDParameter, "SubjectAreaDefinition", "89c3c695-9e8d-4660-9f44-ed971fd55f89", "GovernedBy", "GovernanceDefinition", false, false, this.supportedZones, null, methodName);
        if (entity != null) {
            return entity.getGUID();
        }
        return null;
    }

    public List<String> getSubjectAreaChildrenGUIDs(String userId, String subjectAreaGUID, String subjectAreaGUIDParameter, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        List<EntityDetail> entities = this.getAttachedEntities(userId, subjectAreaGUID, subjectAreaGUIDParameter, "SubjectAreaDefinition", "89c3c695-9e8d-4660-9f44-ed971fd55f89", "GovernedBy", "GovernanceDefinition", null, null, 0, false, false, this.supportedZones, 0, 0, effectiveTime, methodName);
        ArrayList<String> results = new ArrayList<String>();
        if (entities != null) {
            for (EntityDetail entity : entities) {
                if (entity == null) continue;
                results.add(entity.getGUID());
            }
        }
        if (results.isEmpty()) {
            return null;
        }
        return results;
    }

    public List<B> getSubjectAreas(String userId, int startFrom, int pageSize, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.getBeansByType(userId, "d28c3839-bc6f-41ad-a882-5667e01fea72", "SubjectAreaDefinition", null, false, false, this.supportedZones, startFrom, pageSize, new Date(), methodName);
    }

    public List<B> getSubjectAreasByDomain(String userId, int domainIdentifier, int startFrom, int pageSize, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        if (domainIdentifier == 0) {
            return this.getSubjectAreas(userId, startFrom, pageSize, methodName);
        }
        List<EntityDetail> entities = this.getEntitiesByType(userId, "d28c3839-bc6f-41ad-a882-5667e01fea72", "SubjectAreaDefinition", null, false, false, this.supportedZones, startFrom, pageSize, new Date(), methodName);
        ArrayList results = new ArrayList();
        if (entities != null) {
            for (EntityDetail entity : entities) {
                if (entity == null || entity.getProperties() == null || this.repositoryHelper.getIntProperty(this.serviceName, "domainIdentifier", entity.getProperties(), methodName) != domainIdentifier) continue;
                Object bean = this.converter.getNewBean(this.beanClass, entity, methodName);
                results.add(bean);
            }
        }
        if (results.isEmpty()) {
            return null;
        }
        return results;
    }
}

