/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.commonservices.generichandlers.ReferenceableBuilder;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.ClassificationOrigin;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProvenanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeErrorException;

public class AssetBuilder
extends ReferenceableBuilder {
    private String technicalName = null;
    private String versionIdentifier = null;
    private String technicalDescription = null;

    protected AssetBuilder(OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super("896d14c2-7522-4f6c-8519-757711943fe6", "Asset", repositoryHelper, serviceName, serverName);
    }

    protected AssetBuilder(String typeGUID, String typeName, OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(typeGUID, typeName, repositoryHelper, serviceName, serverName);
    }

    protected AssetBuilder(String qualifiedName, String technicalName, String versionIdentifier, String technicalDescription, Map<String, String> additionalProperties, String typeGUID, String typeName, Map<String, Object> extendedProperties, OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(qualifiedName, additionalProperties, typeGUID, typeName, extendedProperties, repositoryHelper, serviceName, serverName);
        this.technicalName = technicalName;
        this.versionIdentifier = versionIdentifier;
        this.technicalDescription = technicalDescription;
    }

    protected AssetBuilder(String qualifiedName, String technicalName, String versionIdentifier, String technicalDescription, Map<String, String> additionalProperties, String typeGUID, String typeName, Map<String, Object> extendedProperties, InstanceStatus initialStatus, OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(qualifiedName, additionalProperties, typeGUID, typeName, extendedProperties, initialStatus, repositoryHelper, serviceName, serverName);
        this.technicalName = technicalName;
        this.versionIdentifier = versionIdentifier;
        this.technicalDescription = technicalDescription;
    }

    protected void setAssetZones(String userId, List<String> zoneMembership, String methodName) throws InvalidParameterException {
        try {
            Classification classification = this.repositoryHelper.getNewClassification(this.serviceName, null, null, InstanceProvenanceType.LOCAL_COHORT, userId, "AssetZoneMembership", this.typeName, ClassificationOrigin.ASSIGNED, null, this.getZoneMembershipProperties(zoneMembership, methodName));
            this.newClassifications.put(classification.getName(), classification);
        }
        catch (TypeErrorException error) {
            this.errorHandler.handleUnsupportedType((Exception)((Object)error), methodName, "AssetZoneMembership");
        }
    }

    InstanceProperties getZoneMembershipProperties(List<String> zoneMembership, String methodName) {
        InstanceProperties properties = null;
        if (zoneMembership != null) {
            properties = this.repositoryHelper.addStringArrayPropertyToInstance(this.serviceName, null, "zoneMembership", zoneMembership, methodName);
        }
        this.setEffectivityDates(properties);
        return properties;
    }

    protected void setAssetOwnership(String userId, String owner, int ownerType, String methodName) throws InvalidParameterException {
        if (owner != null) {
            if (ownerType == 0) {
                this.setOwnershipClassification(userId, owner, "UserIdentity", null, methodName);
            } else if (ownerType == 1) {
                this.setOwnershipClassification(userId, owner, "ActorProfile", null, methodName);
            }
            this.setOwnershipClassification(userId, owner, null, null, methodName);
        }
    }

    @Deprecated
    InstanceProperties getOwnerProperties(String owner, int ownerType, String methodName) {
        if (owner != null) {
            if (ownerType == 0) {
                return this.getOwnershipProperties(owner, "UserIdentity", null, methodName);
            }
            if (ownerType == 1) {
                return this.getOwnershipProperties(owner, "ActorProfile", null, methodName);
            }
            return this.getOwnershipProperties(owner, null, null, methodName);
        }
        return null;
    }

    void setAssetOrigin(String userId, String organization, String organizationPropertyName, String businessCapability, String businessCapabilityPropertyName, Map<String, String> otherOriginValues, String methodName) throws InvalidParameterException {
        if (organization != null || businessCapability != null || otherOriginValues != null && !otherOriginValues.isEmpty()) {
            try {
                Classification classification = this.repositoryHelper.getNewClassification(this.serviceName, null, null, InstanceProvenanceType.LOCAL_COHORT, userId, "AssetOrigin", this.typeName, ClassificationOrigin.ASSIGNED, null, this.getOriginProperties(organization, organizationPropertyName, businessCapability, businessCapabilityPropertyName, otherOriginValues, methodName));
                this.newClassifications.put(classification.getName(), classification);
            }
            catch (TypeErrorException error) {
                this.errorHandler.handleUnsupportedType((Exception)((Object)error), methodName, "AssetOrigin");
            }
        }
    }

    InstanceProperties getOriginProperties(String organization, String organizationPropertyName, String businessCapability, String businessCapabilityPropertyName, Map<String, String> otherOriginValues, String methodName) {
        InstanceProperties properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, "organization", organization, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "organizationPropertyName", organizationPropertyName, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "businessCapability", businessCapability, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "businessCapabilityPropertyName", businessCapabilityPropertyName, methodName);
        properties = this.repositoryHelper.addStringMapPropertyToInstance(this.serviceName, properties, "otherOriginValues", otherOriginValues, methodName);
        this.setEffectivityDates(properties);
        return properties;
    }

    void setReferenceData(String userId, String methodName) throws InvalidParameterException {
        try {
            Classification classification = this.repositoryHelper.getNewClassification(this.serviceName, null, null, InstanceProvenanceType.LOCAL_COHORT, userId, "ReferenceData", this.typeName, ClassificationOrigin.ASSIGNED, null, null);
            this.newClassifications.put(classification.getName(), classification);
        }
        catch (TypeErrorException error) {
            this.errorHandler.handleUnsupportedType((Exception)((Object)error), methodName, "ReferenceData");
        }
    }

    @Override
    public InstanceProperties getInstanceProperties(String methodName) throws InvalidParameterException {
        InstanceProperties properties = super.getInstanceProperties(methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "name", this.technicalName, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "versionIdentifier", this.versionIdentifier, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "description", this.technicalDescription, methodName);
        return properties;
    }
}

