/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.generichandlers.ConnectionBuilder;
import org.odpi.openmetadata.commonservices.generichandlers.ConnectorTypeHandler;
import org.odpi.openmetadata.commonservices.generichandlers.EmbeddedConnectionBuilder;
import org.odpi.openmetadata.commonservices.generichandlers.EndpointHandler;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIDummyBean;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIDummyBeanConverter;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericConverter;
import org.odpi.openmetadata.commonservices.generichandlers.ReferenceableHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryRelationshipsIterator;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ConnectorType;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.EmbeddedConnection;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Endpoint;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.VirtualConnection;
import org.odpi.openmetadata.metadatasecurity.server.OpenMetadataServerSecurityVerifier;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityProxy;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntitySummary;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class ConnectionHandler<B>
extends ReferenceableHandler<B> {
    private final EndpointHandler<OpenMetadataAPIDummyBean> endpointHandler;
    private final ConnectorTypeHandler<OpenMetadataAPIDummyBean> connectorTypeHandler;

    public ConnectionHandler(OpenMetadataAPIGenericConverter<B> converter, Class<B> beanClass, String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper, String localServerUserId, OpenMetadataServerSecurityVerifier securityVerifier, List<String> supportedZones, List<String> defaultZones, List<String> publishZones, AuditLog auditLog) {
        super(converter, beanClass, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
        this.endpointHandler = new EndpointHandler<OpenMetadataAPIDummyBean>(new OpenMetadataAPIDummyBeanConverter(repositoryHelper, serviceName, serverName), OpenMetadataAPIDummyBean.class, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
        this.connectorTypeHandler = new ConnectorTypeHandler<OpenMetadataAPIDummyBean>(new OpenMetadataAPIDummyBeanConverter(repositoryHelper, serviceName, serverName), OpenMetadataAPIDummyBean.class, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
    }

    private String findConnection(String userId, String connectionGUID, String qualifiedName, String displayName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String guidParameterName = "connectionGUID";
        String qualifiedNameParameter = "qualifiedName";
        String displayNameParameter = "displayName";
        if (connectionGUID != null) {
            try {
                if (this.getEntityFromRepository(userId, connectionGUID, "connectionGUID", "Connection", null, null, forLineage, forDuplicateProcessing, this.supportedZones, effectiveTime, methodName) != null) {
                    return connectionGUID;
                }
            }
            catch (InvalidParameterException invalidParameterException) {
                // empty catch block
            }
        }
        String retrievedGUID = null;
        if (qualifiedName != null) {
            retrievedGUID = this.getBeanGUIDByUniqueName(userId, qualifiedName, "qualifiedName", "qualifiedName", "114e9f8f-5ff3-4c32-bd37-a7eb42712253", "Connection", false, false, this.supportedZones, effectiveTime, methodName);
        }
        if (retrievedGUID == null && displayName != null) {
            retrievedGUID = this.getBeanGUIDByUniqueName(userId, displayName, "displayName", "displayName", "114e9f8f-5ff3-4c32-bd37-a7eb42712253", "Connection", false, false, this.supportedZones, effectiveTime, methodName);
        }
        return retrievedGUID;
    }

    public String saveConnection(String userId, String externalSourceGUID, String externalSourceName, String anchorGUID, String assetGUID, String assetGUIDParameterName, String assetTypeName, Connection connection, String assetSummary, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String connectionParameterName = "connection";
        String connectorTypeParameterName = "connection.connectorType";
        this.invalidParameterHandler.validateObject((Object)connection, "connection", methodName);
        this.invalidParameterHandler.validateObject((Object)connection.getConnectorType(), "connection.connectorType", methodName);
        String existingConnectionGUID = this.findConnection(userId, connection.getGUID(), connection.getQualifiedName(), connection.getDisplayName(), forLineage, forDuplicateProcessing, effectiveTime, methodName);
        if (existingConnectionGUID == null) {
            return this.addConnection(userId, externalSourceGUID, externalSourceName, anchorGUID, assetGUID, assetGUIDParameterName, assetTypeName, connection, assetSummary, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        }
        return this.updateConnection(userId, externalSourceGUID, externalSourceName, anchorGUID, existingConnectionGUID, connection, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    private void saveAssociatedConnectionEntities(String userId, String externalSourceGUID, String externalSourceName, String anchorGUID, String connectionGUID, Endpoint endpoint, ConnectorType connectorType, List<EmbeddedConnection> embeddedConnections, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String connectionGUIDParameterName = "connectionGUID";
        if (endpoint != null) {
            String endpointGUID = this.endpointHandler.saveEndpoint(userId, externalSourceGUID, externalSourceName, endpoint, forLineage, forDuplicateProcessing, effectiveTime, methodName);
            if (endpointGUID != null) {
                this.repositoryHandler.ensureRelationship(userId, "Endpoint", null, null, endpointGUID, connectionGUID, "887a7132-d6bc-4b92-a483-e80b60c86fb2", "ConnectionEndpoint", null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
            }
        } else {
            this.repositoryHandler.removeAllRelationshipsOfType(userId, externalSourceGUID, externalSourceName, connectionGUID, "Connection", "887a7132-d6bc-4b92-a483-e80b60c86fb2", "ConnectionEndpoint", forLineage, forDuplicateProcessing, effectiveTime, methodName);
        }
        if (connectorType != null) {
            String connectorTypeGUID = this.connectorTypeHandler.saveConnectorType(userId, externalSourceGUID, externalSourceName, connectorType, methodName);
            if (connectorTypeGUID != null) {
                this.repositoryHandler.ensureRelationship(userId, externalSourceGUID, externalSourceName, "Connection", connectionGUID, connectorTypeGUID, "e542cfc1-0b4b-42b9-9921-f0a5a88aaf96", "ConnectionConnectorType", null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
            }
        } else {
            this.repositoryHandler.removeAllRelationshipsOfType(userId, externalSourceGUID, externalSourceName, connectionGUID, "Connection", "e542cfc1-0b4b-42b9-9921-f0a5a88aaf96", "ConnectionConnectorType", forLineage, forDuplicateProcessing, effectiveTime, methodName);
        }
        this.unlinkAllElements(userId, false, externalSourceGUID, externalSourceName, connectionGUID, "connectionGUID", "Connection", forLineage, forDuplicateProcessing, this.supportedZones, "eb6dfdd2-8c6f-4f0d-a17d-f6ce4799f64f", "EmbeddedConnection", effectiveTime, methodName);
        if (embeddedConnections != null && !embeddedConnections.isEmpty()) {
            for (EmbeddedConnection embeddedConnection : embeddedConnections) {
                if (embeddedConnection == null) continue;
                Connection realConnection = embeddedConnection.getEmbeddedConnection();
                String realConnectionGUID = this.saveConnection(userId, externalSourceGUID, externalSourceName, anchorGUID, null, null, null, realConnection, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
                if (realConnection == null) continue;
                EmbeddedConnectionBuilder embeddedConnectionBuilder = new EmbeddedConnectionBuilder(embeddedConnection.getPosition(), embeddedConnection.getArguments(), embeddedConnection.getDisplayName(), this.repositoryHelper, this.serviceName, this.serverName);
                embeddedConnectionBuilder.setAnchors(userId, anchorGUID, methodName);
                this.repositoryHandler.createRelationship(userId, "e542cfc1-0b4b-42b9-9921-f0a5a88aaf96", externalSourceGUID, externalSourceName, connectionGUID, realConnectionGUID, embeddedConnectionBuilder.getInstanceProperties(methodName), methodName);
            }
        }
    }

    private String addConnection(String userId, String externalSourceGUID, String externalSourceName, String anchorGUID, String assetGUID, String assetGUIDParameterName, String assetTypeName, Connection connection, String assetSummary, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String connectionGUID;
        String connectionParameterName = "connection";
        this.invalidParameterHandler.validateObject((Object)connection.getConnectorType(), "connection", methodName);
        String connectionTypeGUID = "114e9f8f-5ff3-4c32-bd37-a7eb42712253";
        String connectionTypeName = "Connection";
        List embeddedConnections = null;
        if (connection instanceof VirtualConnection) {
            connectionTypeGUID = "82f9c664-e59d-484c-a8f3-17088c23a2f3";
            connectionTypeName = "VirtualConnection";
            VirtualConnection virtualConnection = (VirtualConnection)connection;
            embeddedConnections = virtualConnection.getEmbeddedConnections();
        }
        ConnectionBuilder connectionBuilder = new ConnectionBuilder(connection.getQualifiedName(), connection.getDisplayName(), connection.getDescription(), connection.getAdditionalProperties(), connection.getSecuredProperties(), connection.getConfigurationProperties(), connection.getUserId(), connection.getClearPassword(), connection.getEncryptedPassword(), "114e9f8f-5ff3-4c32-bd37-a7eb42712253", "Connection", connection.getExtendedProperties(), this.repositoryHelper, this.serviceName, this.serverName);
        if (anchorGUID != null) {
            connectionBuilder.setAnchors(userId, anchorGUID, methodName);
        }
        if ((connectionGUID = this.createBeanInRepository(userId, externalSourceGUID, externalSourceName, connectionTypeGUID, connectionTypeName, connectionBuilder, effectiveTime, methodName)) != null) {
            this.saveAssociatedConnectionEntities(userId, externalSourceGUID, externalSourceName, anchorGUID, connectionGUID, connection.getEndpoint(), connection.getConnectorType(), embeddedConnections, forLineage, forDuplicateProcessing, effectiveTime, methodName);
            if (assetGUID != null) {
                InstanceProperties properties = null;
                if (assetSummary != null) {
                    properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, "assetSummary", assetSummary, methodName);
                }
                this.linkElementToElement(userId, null, null, connectionGUID, "connection", "Connection", assetGUID, assetGUIDParameterName, assetTypeName, forLineage, forDuplicateProcessing, this.supportedZones, "e777d660-8dbe-453e-8b83-903771f054c0", "ConnectionToAsset", properties, null, null, effectiveTime, methodName);
            }
        }
        return connectionGUID;
    }

    private String updateConnection(String userId, String externalSourceGUID, String externalSourceName, String anchorGUID, String existingConnectionGUID, Connection connection, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String parameterName = "connection";
        this.invalidParameterHandler.validateObject((Object)connection.getConnectorType(), "connection", methodName);
        String connectionTypeName = "Connection";
        List embeddedConnections = null;
        if (connection instanceof VirtualConnection) {
            connectionTypeName = "VirtualConnection";
            VirtualConnection virtualConnection = (VirtualConnection)connection;
            embeddedConnections = virtualConnection.getEmbeddedConnections();
        }
        this.updateConnection(userId, externalSourceGUID, externalSourceName, existingConnectionGUID, "connection", connection.getQualifiedName(), connection.getDisplayName(), connection.getDescription(), connection.getAdditionalProperties(), connection.getSecuredProperties(), connection.getConfigurationProperties(), connection.getUserId(), connection.getClearPassword(), connection.getEncryptedPassword(), connectionTypeName, connection.getExtendedProperties(), false, null, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        this.saveAssociatedConnectionEntities(userId, externalSourceGUID, externalSourceName, anchorGUID, existingConnectionGUID, connection.getEndpoint(), connection.getConnectorType(), embeddedConnections, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        return existingConnectionGUID;
    }

    public void addAssetConnection(String userId, String externalSourceGUID, String externalSourceName, String assetGUID, String assetGUIDParameterName, String assetTypeName, String assetQualifiedName, boolean anchorEndpointToAsset, Map<String, Object> configurationProperties, String connectorProviderClassName, String networkAddress, String protocol, String encryptionMethod, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String connectorTypeGUID;
        String connectorTypeGUIDParameterName = "connectorTypeGUID";
        if (connectorProviderClassName != null) {
            String connectorTypeName = assetTypeName + ":" + assetQualifiedName + " ConnectorType";
            connectorTypeGUID = this.connectorTypeHandler.getConnectorTypeForConnection(userId, null, null, null, connectorTypeName, connectorTypeName, null, assetTypeName, null, connectorProviderClassName, "Open Connector Framework (OCF)", "Java", null, null, null, null, null, null, null, null, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        } else {
            connectorTypeGUID = this.connectorTypeHandler.getConnectorTypeForAsset(userId, assetTypeName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        }
        if (connectorTypeGUID != null) {
            String endpointGUIDParameterName = "endpointGUID";
            String endpointDescription = "Access information to connect to the actual asset: ";
            String endpointName = assetQualifiedName + " Endpoint";
            String connectionName = assetQualifiedName + " Connection";
            String anchorGUID = null;
            if (anchorEndpointToAsset) {
                anchorGUID = assetGUID;
            }
            String endpointGUID = this.endpointHandler.getEndpointForConnection(userId, externalSourceGUID, externalSourceName, anchorGUID, endpointName, endpointName, "Access information to connect to the actual asset: " + networkAddress, networkAddress, protocol, encryptionMethod, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
            this.createConnection(userId, externalSourceGUID, externalSourceName, assetGUID, assetGUIDParameterName, null, connectionName, connectionName, null, null, null, configurationProperties, null, null, null, "Connection", null, connectorTypeGUID, "connectorTypeGUID", endpointGUID, "endpointGUID", effectiveFrom, effectiveTo, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        }
    }

    public String createConnection(String userId, String externalSourceGUID, String externalSourceName, String assetGUID, String assetGUIDParameterName, String assetSummary, String qualifiedName, String displayName, String description, Map<String, String> additionalProperties, Map<String, String> securedProperties, Map<String, Object> configurationProperties, String connectorUserId, String clearPassword, String encryptedPassword, String connectorTypeGUID, String connectorTypeGUIDParameterName, String endpointGUID, String endpointGUIDParameterName, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.createConnection(userId, externalSourceGUID, externalSourceName, assetGUID, assetGUIDParameterName, assetSummary, qualifiedName, displayName, description, additionalProperties, securedProperties, configurationProperties, connectorUserId, clearPassword, encryptedPassword, "Connection", null, connectorTypeGUID, connectorTypeGUIDParameterName, endpointGUID, endpointGUIDParameterName, effectiveFrom, effectiveTo, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public String createVirtualConnection(String userId, String externalSourceGUID, String externalSourceName, String assetGUID, String assetGUIDParameterName, String assetSummary, String qualifiedName, String displayName, String description, Map<String, String> additionalProperties, Map<String, String> securedProperties, Map<String, Object> configurationProperties, String connectorUserId, String clearPassword, String encryptedPassword, String connectorTypeGUID, String connectorTypeGUIDParameterName, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.createConnection(userId, externalSourceGUID, externalSourceName, assetGUID, assetGUIDParameterName, assetSummary, qualifiedName, displayName, description, additionalProperties, securedProperties, configurationProperties, connectorUserId, clearPassword, encryptedPassword, "VirtualConnection", null, connectorTypeGUID, connectorTypeGUIDParameterName, effectiveFrom, effectiveTo, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public String createConnection(String userId, String externalSourceGUID, String externalSourceName, String assetGUID, String assetGUIDParameterName, String assetSummary, String qualifiedName, String displayName, String description, Map<String, String> additionalProperties, Map<String, String> securedProperties, Map<String, Object> configurationProperties, String connectorUserId, String clearPassword, String encryptedPassword, String connectionTypeName, Map<String, Object> extendedProperties, String connectorTypeGUID, String connectorTypeGUIDParameterName, String endpointGUID, String endpointGUIDParameterName, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String connectionGUID;
        String nameParameter = "qualifiedName";
        String connectionGUIDParameterName = "connectionGUID";
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        String connectionTypeId = this.invalidParameterHandler.validateTypeName(connectionTypeName, "Connection", this.serviceName, methodName, this.repositoryHelper);
        ConnectionBuilder builder = new ConnectionBuilder(qualifiedName, displayName, description, additionalProperties, securedProperties, configurationProperties, connectorUserId, clearPassword, encryptedPassword, connectionTypeId, connectionTypeName, extendedProperties, this.repositoryHelper, this.serviceName, this.serverName);
        builder.setEffectivityDates(effectiveFrom, effectiveTo);
        if (assetGUID != null) {
            builder.setAnchors(userId, assetGUID, methodName);
        }
        if ((connectionGUID = this.createBeanInRepository(userId, externalSourceGUID, externalSourceName, connectionTypeId, connectionTypeName, builder, effectiveTime, methodName)) != null) {
            if (assetGUID != null) {
                InstanceProperties relationshipProperties = null;
                if (assetSummary != null) {
                    relationshipProperties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, "assetSummary", assetSummary, methodName);
                }
                this.uncheckedLinkElementToElement(userId, externalSourceGUID, externalSourceName, connectionGUID, "connectionGUID", connectionTypeName, assetGUID, assetGUIDParameterName, "Asset", forLineage, forDuplicateProcessing, this.supportedZones, "e777d660-8dbe-453e-8b83-903771f054c0", "ConnectionToAsset", this.setUpEffectiveDates(relationshipProperties, effectiveFrom, effectiveTo), effectiveTime, methodName);
            }
            if (connectorTypeGUID != null) {
                this.linkElementToElement(userId, externalSourceGUID, externalSourceName, connectionGUID, "connectionGUID", connectionTypeName, connectorTypeGUID, connectorTypeGUIDParameterName, "ConnectorType", forLineage, forDuplicateProcessing, this.supportedZones, "e542cfc1-0b4b-42b9-9921-f0a5a88aaf96", "ConnectionConnectorType", null, effectiveFrom, effectiveTo, effectiveTime, methodName);
            }
            if (endpointGUID != null) {
                this.linkElementToElement(userId, externalSourceGUID, externalSourceName, endpointGUID, endpointGUIDParameterName, "Endpoint", connectionGUID, "connectionGUID", connectionTypeName, forLineage, forDuplicateProcessing, this.supportedZones, "887a7132-d6bc-4b92-a483-e80b60c86fb2", "ConnectionEndpoint", null, effectiveFrom, effectiveTo, effectiveTime, methodName);
            }
        }
        return connectionGUID;
    }

    public void addEmbeddedConnection(String userId, String externalSourceGUID, String externalSourceName, String virtualConnectionGUID, String virtualConnectionGUIDParameterName, int position, String displayName, Map<String, Object> arguments, String embeddedConnectionGUID, String embeddedConnectionGUIDParameterName, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(virtualConnectionGUID, virtualConnectionGUIDParameterName, methodName);
        this.invalidParameterHandler.validateGUID(embeddedConnectionGUID, embeddedConnectionGUIDParameterName, methodName);
        InstanceProperties properties = this.repositoryHelper.addIntPropertyToInstance(this.serviceName, null, "position", position, methodName);
        if (displayName != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "displayName", displayName, methodName);
        }
        if (arguments != null && !arguments.isEmpty()) {
            properties = this.repositoryHelper.addMapPropertyToInstance(this.serviceName, properties, "arguments", arguments, methodName);
        }
        this.linkElementToElement(userId, externalSourceGUID, externalSourceName, virtualConnectionGUID, virtualConnectionGUIDParameterName, "VirtualConnection", embeddedConnectionGUID, embeddedConnectionGUIDParameterName, "Connection", forLineage, forDuplicateProcessing, this.supportedZones, "eb6dfdd2-8c6f-4f0d-a17d-f6ce4799f64f", "EmbeddedConnection", properties, effectiveFrom, effectiveTo, effectiveTime, methodName);
    }

    public void removeEmbeddedConnection(String userId, String externalSourceGUID, String externalSourceName, String connectionGUID, String connectionGUIDParameterName, String embeddedConnectionGUID, String embeddedConnectionGUIDParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.unlinkElementFromElement(userId, false, externalSourceGUID, externalSourceName, connectionGUID, connectionGUIDParameterName, "VirtualConnection", embeddedConnectionGUID, embeddedConnectionGUIDParameterName, "114e9f8f-5ff3-4c32-bd37-a7eb42712253", "Connection", forLineage, forDuplicateProcessing, (List<String>)this.supportedZones, "eb6dfdd2-8c6f-4f0d-a17d-f6ce4799f64f", "EmbeddedConnection", effectiveTime, methodName);
    }

    public String createConnectionFromTemplate(String userId, String externalSourceGUID, String externalSourceName, String templateGUID, String templateGUIDParameterName, String qualifiedName, String qualifiedNameParameterName, String displayName, String description, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(templateGUID, templateGUIDParameterName, methodName);
        this.invalidParameterHandler.validateName(qualifiedName, qualifiedNameParameterName, methodName);
        ConnectionBuilder builder = new ConnectionBuilder(qualifiedName, displayName, description, this.repositoryHelper, this.serviceName, this.serverName);
        return this.createBeanFromTemplate(userId, externalSourceGUID, externalSourceName, templateGUID, templateGUIDParameterName, "114e9f8f-5ff3-4c32-bd37-a7eb42712253", "Connection", qualifiedName, "qualifiedName", builder, this.supportedZones, methodName);
    }

    public void updateConnection(String userId, String externalSourceGUID, String externalSourceName, String connectionGUID, String connectionGUIDParameterName, String qualifiedName, String displayName, String description, Map<String, String> additionalProperties, Map<String, String> securedProperties, Map<String, Object> configurationProperties, String connectorUserId, String clearPassword, String encryptedPassword, String typeName, Map<String, Object> extendedProperties, boolean isMergeUpdate, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String nameParameter = "qualifiedName";
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        String typeGUID = this.invalidParameterHandler.validateTypeName(typeName, "Connection", this.serviceName, methodName, this.repositoryHelper);
        ConnectionBuilder builder = new ConnectionBuilder(qualifiedName, displayName, description, additionalProperties, securedProperties, configurationProperties, connectorUserId, clearPassword, encryptedPassword, typeGUID, typeName, extendedProperties, this.repositoryHelper, this.serviceName, this.serverName);
        builder.setEffectivityDates(effectiveFrom, effectiveTo);
        this.updateBeanInRepository(userId, externalSourceGUID, externalSourceName, connectionGUID, connectionGUIDParameterName, typeGUID, typeName, forLineage, forDuplicateProcessing, (List<String>)this.supportedZones, builder.getInstanceProperties(methodName), isMergeUpdate, effectiveTime, methodName);
    }

    public void addConnectionConnectorType(String userId, String externalSourceGUID, String externalSourceName, String connectionGUID, String connectionGUIDParameterName, String connectorTypeGUID, String connectorTypeGUIDParameterName, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.linkElementToElement(userId, externalSourceGUID, externalSourceName, connectionGUID, connectionGUIDParameterName, "Connection", connectorTypeGUID, connectorTypeGUIDParameterName, "ConnectorType", forLineage, forDuplicateProcessing, this.supportedZones, "e542cfc1-0b4b-42b9-9921-f0a5a88aaf96", "ConnectionConnectorType", null, effectiveFrom, effectiveTo, effectiveTime, methodName);
    }

    public void removeConnectionConnectorType(String userId, String externalSourceGUID, String externalSourceName, String connectionGUID, String connectionGUIDParameterName, String connectorTypeGUID, String connectorTypeGUIDParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.unlinkElementFromElement(userId, false, externalSourceGUID, externalSourceName, connectionGUID, connectionGUIDParameterName, "Connection", connectorTypeGUID, connectorTypeGUIDParameterName, "954421eb-33a6-462d-a8ca-b5709a1bd0d4", "ConnectorType", forLineage, forDuplicateProcessing, (List<String>)this.supportedZones, "e542cfc1-0b4b-42b9-9921-f0a5a88aaf96", "ConnectionConnectorType", effectiveTime, methodName);
    }

    public void addConnectionEndpoint(String userId, String externalSourceGUID, String externalSourceName, String connectionGUID, String connectionGUIDParameterName, String endpointGUID, String endpointGUIDParameterName, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.linkElementToElement(userId, externalSourceGUID, externalSourceName, endpointGUID, endpointGUIDParameterName, "Endpoint", connectionGUID, connectionGUIDParameterName, "Connection", forLineage, forDuplicateProcessing, this.supportedZones, "887a7132-d6bc-4b92-a483-e80b60c86fb2", "ConnectionEndpoint", null, effectiveFrom, effectiveTo, effectiveTime, methodName);
    }

    public void removeConnectionEndpoint(String userId, String externalSourceGUID, String externalSourceName, String connectionGUID, String connectionGUIDParameterName, String endpointGUID, String endpointGUIDParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.unlinkElementFromElement(userId, false, externalSourceGUID, externalSourceName, endpointGUID, endpointGUIDParameterName, "Endpoint", connectionGUID, connectionGUIDParameterName, "114e9f8f-5ff3-4c32-bd37-a7eb42712253", "Connection", forLineage, forDuplicateProcessing, (List<String>)this.supportedZones, "887a7132-d6bc-4b92-a483-e80b60c86fb2", "ConnectionEndpoint", effectiveTime, methodName);
    }

    public void addConnectionToAsset(String userId, String externalSourceGUID, String externalSourceName, String connectionGUID, String connectionGUIDParameterName, String assetGUID, String assetGUIDParameterName, String assetSummary, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        InstanceProperties properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, "assetSummary", assetSummary, methodName);
        this.linkElementToElement(userId, externalSourceGUID, externalSourceName, connectionGUID, connectionGUIDParameterName, "Connection", assetGUID, assetGUIDParameterName, "Asset", forLineage, forDuplicateProcessing, this.supportedZones, "e777d660-8dbe-453e-8b83-903771f054c0", "ConnectionToAsset", properties, effectiveFrom, effectiveTo, effectiveTime, methodName);
        this.addAnchorsClassification(userId, connectionGUID, connectionGUIDParameterName, "Connection", assetGUID, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void removeConnectionToAsset(String userId, String externalSourceGUID, String externalSourceName, String connectionGUID, String connectionGUIDParameterName, String assetGUID, String assetGUIDParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.unlinkElementFromElement(userId, false, externalSourceGUID, externalSourceName, connectionGUID, connectionGUIDParameterName, "Connection", assetGUID, assetGUIDParameterName, "896d14c2-7522-4f6c-8519-757711943fe6", "Asset", forLineage, forDuplicateProcessing, (List<String>)this.supportedZones, "e777d660-8dbe-453e-8b83-903771f054c0", "ConnectionToAsset", effectiveTime, methodName);
    }

    public void removeConnection(String userId, String externalSourceGUID, String externalSourceName, String guid, String guidParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.deleteBeanInRepository(userId, externalSourceGUID, externalSourceName, guid, guidParameterName, "114e9f8f-5ff3-4c32-bd37-a7eb42712253", "Connection", null, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public int countConnections(String userId, String assetGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.countAttachments(userId, assetGUID, "Asset", "e777d660-8dbe-453e-8b83-903771f054c0", "ConnectionToAsset", 1, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public B getConnectionForAsset(String userId, String assetGUID, String assetGUIDParameterName, List<String> serviceSupportedZones, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        EntityDetail assetEntity = this.getEntityFromRepository(userId, assetGUID, assetGUIDParameterName, "Asset", null, null, forLineage, forDuplicateProcessing, serviceSupportedZones, effectiveTime, methodName);
        List<EntityDetail> connectionEntities = this.getAttachedEntities(userId, assetEntity, assetGUIDParameterName, "Asset", "e777d660-8dbe-453e-8b83-903771f054c0", "ConnectionToAsset", "Connection", null, null, 1, forLineage, forDuplicateProcessing, serviceSupportedZones, 0, this.invalidParameterHandler.getMaxPagingSize(), effectiveTime, methodName);
        if (connectionEntities == null) {
            return null;
        }
        EntityDetail selectedEntity = this.securityVerifier.selectConnection(userId, assetEntity, connectionEntities, this.repositoryHelper, this.serviceName, methodName);
        return this.getFullConnection(userId, selectedEntity, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    private B getFullConnection(String userId, EntityDetail connectionEntity, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        if (connectionEntity != null && connectionEntity.getType() != null) {
            List<Relationship> supplementaryRelationships = this.getEmbeddedRelationships(userId, (EntitySummary)connectionEntity, forLineage, forDuplicateProcessing, effectiveTime, methodName);
            ArrayList<EntityDetail> supplementaryEntities = new ArrayList<EntityDetail>();
            if (supplementaryRelationships != null) {
                for (Relationship relationship : supplementaryRelationships) {
                    if (relationship == null || relationship.getType() == null) continue;
                    EntityProxy entityProxy = null;
                    if (this.repositoryHelper.isTypeOf(this.serviceName, relationship.getType().getTypeDefName(), "ConnectionConnectorType") || this.repositoryHelper.isTypeOf(this.serviceName, relationship.getType().getTypeDefName(), "EmbeddedConnection")) {
                        entityProxy = relationship.getEntityTwoProxy();
                    } else if (this.repositoryHelper.isTypeOf(this.serviceName, relationship.getType().getTypeDefName(), "ConnectionEndpoint")) {
                        entityProxy = relationship.getEntityOneProxy();
                    }
                    if (entityProxy == null || entityProxy.getGUID() == null || entityProxy.getType() == null) continue;
                    String entityGUIDParameterName = "embeddedRelationship proxy";
                    EntityDetail supplementaryEntity = this.getEntityFromRepository(userId, entityProxy.getGUID(), "embeddedRelationship proxy", entityProxy.getType().getTypeDefName(), null, null, forLineage, forDuplicateProcessing, this.supportedZones, effectiveTime, methodName);
                    if (supplementaryEntity == null) continue;
                    supplementaryEntities.add(supplementaryEntity);
                }
            }
            if (supplementaryEntities.isEmpty()) {
                supplementaryEntities = null;
            }
            return this.converter.getNewComplexBean(this.beanClass, connectionEntity, supplementaryEntities, supplementaryRelationships, methodName);
        }
        return null;
    }

    private List<Relationship> getEmbeddedRelationships(String userId, EntitySummary connectionEntity, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws PropertyServerException, UserNotAuthorizedException, InvalidParameterException {
        ArrayList<Relationship> supplementaryRelationships = new ArrayList<Relationship>();
        if (connectionEntity != null && connectionEntity.getType() != null) {
            RepositoryRelationshipsIterator iterator = new RepositoryRelationshipsIterator(this.repositoryHandler, this.invalidParameterHandler, userId, connectionEntity.getGUID(), connectionEntity.getType().getTypeDefName(), null, null, 0, forLineage, forDuplicateProcessing, 0, this.invalidParameterHandler.getMaxPagingSize(), effectiveTime, methodName);
            while (iterator.moreToReceive()) {
                List<Relationship> embeddedConnectionRelationships;
                Relationship relationship = iterator.getNext();
                if (relationship == null || relationship.getType() == null) continue;
                if (this.repositoryHelper.isTypeOf(this.serviceName, relationship.getType().getTypeDefName(), "ConnectionEndpoint") || this.repositoryHelper.isTypeOf(this.serviceName, relationship.getType().getTypeDefName(), "ConnectionConnectorType") || this.repositoryHelper.isTypeOf(this.serviceName, relationship.getType().getTypeDefName(), "ConnectionToAsset")) {
                    supplementaryRelationships.add(relationship);
                    continue;
                }
                if (!this.repositoryHelper.isTypeOf(this.serviceName, relationship.getType().getTypeDefName(), "EmbeddedConnection")) continue;
                supplementaryRelationships.add(relationship);
                EntityProxy embeddedConnectionEnd = relationship.getEntityTwoProxy();
                if (embeddedConnectionEnd == null || embeddedConnectionEnd.getGUID() == null || (embeddedConnectionRelationships = this.getEmbeddedRelationships(userId, (EntitySummary)embeddedConnectionEnd, forLineage, forDuplicateProcessing, effectiveTime, methodName)) == null) continue;
                supplementaryRelationships.addAll(embeddedConnectionRelationships);
            }
        }
        if (supplementaryRelationships.isEmpty()) {
            return null;
        }
        return supplementaryRelationships;
    }

    private List<B> getFullConnections(String userId, List<EntityDetail> entities, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        ArrayList<B> results = new ArrayList<B>();
        if (entities != null) {
            for (EntityDetail entity : entities) {
                B bean;
                if (entity == null || (bean = this.getFullConnection(userId, entity, forLineage, forDuplicateProcessing, effectiveTime, methodName)) == null) continue;
                results.add(bean);
            }
        }
        if (!results.isEmpty()) {
            return results;
        }
        return null;
    }

    public List<B> getConnectionsForAsset(String userId, String assetGUID, String assetGUIDParameterName, List<String> serviceSupportedZones, int startingFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        List<EntityDetail> entities = super.getAttachedEntities(userId, assetGUID, assetGUIDParameterName, "Asset", "e777d660-8dbe-453e-8b83-903771f054c0", "ConnectionToAsset", "Connection", null, null, 1, forLineage, forDuplicateProcessing, serviceSupportedZones, startingFrom, pageSize, effectiveTime, methodName);
        return this.getFullConnections(userId, entities, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public List<B> findConnections(String userId, String searchString, String searchStringParameterName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        List<EntityDetail> entities = this.findEntities(userId, searchString, searchStringParameterName, "114e9f8f-5ff3-4c32-bd37-a7eb42712253", "Connection", null, null, null, startFrom, pageSize, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        return this.getFullConnections(userId, entities, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public List<B> getConnectionsByName(String userId, String name, String nameParameterName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        ArrayList<String> specificMatchPropertyNames = new ArrayList<String>();
        specificMatchPropertyNames.add("qualifiedName");
        specificMatchPropertyNames.add("displayName");
        List<EntityDetail> entities = this.getEntitiesByValue(userId, name, nameParameterName, "114e9f8f-5ff3-4c32-bd37-a7eb42712253", "Connection", specificMatchPropertyNames, true, false, null, null, forLineage, forDuplicateProcessing, this.supportedZones, null, startFrom, pageSize, effectiveTime, methodName);
        return this.getFullConnections(userId, entities, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public B getConnectionByGUID(String userId, String guid, String guidParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        EntityDetail entity = this.getEntityFromRepository(userId, guid, guidParameterName, "Connection", null, null, forLineage, forDuplicateProcessing, this.supportedZones, effectiveTime, methodName);
        if (entity != null) {
            return this.getFullConnection(userId, entity, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        }
        return null;
    }
}

