/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.generichandlers.GlossaryTermBuilder;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericConverter;
import org.odpi.openmetadata.commonservices.generichandlers.ReferenceableHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.metadatasecurity.server.OpenMetadataServerSecurityVerifier;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class GlossaryTermHandler<B>
extends ReferenceableHandler<B> {
    public GlossaryTermHandler(OpenMetadataAPIGenericConverter<B> converter, Class<B> beanClass, String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper, String localServerUserId, OpenMetadataServerSecurityVerifier securityVerifier, List<String> supportedZones, List<String> defaultZones, List<String> publishZones, AuditLog auditLog) {
        super(converter, beanClass, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
    }

    public String createGlossaryTerm(String userId, String externalSourceGUID, String externalSourceName, String glossaryGUID, String glossaryGUIDParameterName, String qualifiedName, String displayName, String summary, String description, String examples, String abbreviation, String usage, Map<String, String> additionalProperties, String suppliedTypeName, Map<String, Object> extendedProperties, InstanceStatus initialStatus, Date effectiveFrom, Date effectiveTo, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        InstanceStatus instanceStatus = InstanceStatus.ACTIVE;
        if (initialStatus != null) {
            instanceStatus = initialStatus;
        }
        String typeName = "GlossaryTerm";
        if (suppliedTypeName != null) {
            typeName = suppliedTypeName;
        }
        String typeGUID = this.invalidParameterHandler.validateTypeName(typeName, "GlossaryTerm", this.serviceName, methodName, this.repositoryHelper);
        GlossaryTermBuilder builder = new GlossaryTermBuilder(qualifiedName, displayName, summary, description, examples, abbreviation, usage, additionalProperties, extendedProperties, instanceStatus, this.repositoryHelper, this.serviceName, this.serverName);
        builder.setAnchors(userId, glossaryGUID, methodName);
        builder.setEffectivityDates(effectiveFrom, effectiveTo);
        String glossaryTermGUID = this.createBeanInRepository(userId, externalSourceGUID, externalSourceName, typeGUID, typeName, builder, effectiveTime, methodName);
        if (glossaryTermGUID != null) {
            String glossaryTermGUIDParameterName = "glossaryTermGUID";
            this.uncheckedLinkElementToElement(userId, externalSourceGUID, externalSourceName, glossaryGUID, glossaryGUIDParameterName, "Glossary", glossaryTermGUID, "glossaryTermGUID", "GlossaryTerm", false, false, this.supportedZones, "1d43d661-bdc7-4a91-a996-3239b8f82e56", "TermAnchor", null, effectiveTime, methodName);
        }
        return glossaryTermGUID;
    }

    public String createGlossaryTermFromTemplate(String userId, String externalSourceGUID, String externalSourceName, String templateGUID, String qualifiedName, String displayName, String description, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String templateGUIDParameterName = "templateGUID";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(templateGUID, "templateGUID", methodName);
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        GlossaryTermBuilder builder = new GlossaryTermBuilder(qualifiedName, displayName, description, this.repositoryHelper, this.serviceName, this.serverName);
        return this.createBeanFromTemplate(userId, externalSourceGUID, externalSourceName, templateGUID, "templateGUID", "0db3e6ec-f5ef-4d75-ae38-b7ee6fd6ec0a", "GlossaryTerm", qualifiedName, "qualifiedName", builder, this.supportedZones, methodName);
    }

    public void updateGlossaryTerm(String userId, String externalSourceGUID, String externalSourceName, String glossaryTermGUID, String glossaryTermGUIDParameterName, String qualifiedName, String displayName, String summary, String description, String examples, String abbreviation, String usage, Map<String, String> additionalProperties, String typeName, Map<String, Object> extendedProperties, Date effectiveFrom, Date effectiveTo, boolean isMergeUpdate, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(glossaryTermGUID, glossaryTermGUIDParameterName, methodName);
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        String typeGUID = this.invalidParameterHandler.validateTypeName(typeName, "GlossaryTerm", this.serviceName, methodName, this.repositoryHelper);
        GlossaryTermBuilder builder = new GlossaryTermBuilder(qualifiedName, displayName, summary, description, examples, abbreviation, usage, additionalProperties, extendedProperties, InstanceStatus.ACTIVE, this.repositoryHelper, this.serviceName, this.serverName);
        builder.setEffectivityDates(effectiveFrom, effectiveTo);
        this.updateBeanInRepository(userId, externalSourceGUID, externalSourceName, glossaryTermGUID, glossaryTermGUIDParameterName, typeGUID, typeName, forLineage, forDuplicateProcessing, (List<String>)this.supportedZones, builder.getInstanceProperties(methodName), isMergeUpdate, effectiveTime, methodName);
    }

    public void updateGlossaryTermStatus(String userId, String externalSourceGUID, String externalSourceName, String glossaryTermGUID, String glossaryTermGUIDParameterName, InstanceStatus glossaryTermStatus, String glossaryTermStatusParameterName, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.updateBeanStatusInRepository(userId, externalSourceGUID, externalSourceName, glossaryTermGUID, glossaryTermGUIDParameterName, "0db3e6ec-f5ef-4d75-ae38-b7ee6fd6ec0a", "GlossaryTerm", forLineage, forDuplicateProcessing, this.supportedZones, glossaryTermStatus, glossaryTermStatusParameterName, effectiveTime, methodName);
    }

    public void setupTermCategory(String userId, String externalSourceGUID, String externalSourceName, String glossaryCategoryGUID, String glossaryCategoryGUIDParameterName, String glossaryTermGUID, String glossaryTermGUIDParameterName, String description, int relationshipStatus, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(glossaryCategoryGUID, glossaryCategoryGUIDParameterName, methodName);
        this.invalidParameterHandler.validateGUID(glossaryTermGUID, glossaryTermGUIDParameterName, methodName);
        GlossaryTermBuilder builder = new GlossaryTermBuilder(this.repositoryHelper, this.serviceName, this.serverName);
        this.linkElementToElement(userId, externalSourceGUID, externalSourceName, glossaryCategoryGUID, glossaryCategoryGUIDParameterName, "GlossaryCategory", glossaryTermGUID, glossaryTermGUIDParameterName, "GlossaryTerm", forLineage, forDuplicateProcessing, this.supportedZones, "696a81f5-ac60-46c7-b9fd-6979a1e7ad27", "TermCategorization", builder.getTermCategorizationProperties(description, relationshipStatus, methodName), effectiveFrom, effectiveTo, effectiveTime, methodName);
    }

    public void clearTermCategory(String userId, String externalSourceGUID, String externalSourceName, String glossaryCategoryGUID, String glossaryCategoryGUIDParameterName, String glossaryTermGUID, String glossaryTermGUIDParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(glossaryCategoryGUID, glossaryCategoryGUIDParameterName, methodName);
        this.invalidParameterHandler.validateGUID(glossaryTermGUID, glossaryTermGUIDParameterName, methodName);
        this.unlinkElementFromElement(userId, false, externalSourceGUID, externalSourceName, glossaryCategoryGUID, glossaryCategoryGUIDParameterName, "GlossaryCategory", glossaryTermGUID, glossaryTermGUIDParameterName, "0db3e6ec-f5ef-4d75-ae38-b7ee6fd6ec0a", "GlossaryTerm", forLineage, forDuplicateProcessing, "696a81f5-ac60-46c7-b9fd-6979a1e7ad27", "TermCategorization", effectiveTime, methodName);
    }

    public void setupTermRelationship(String userId, String externalSourceGUID, String externalSourceName, String glossaryTermOneGUID, String glossaryTermOneGUIDParameterName, String relationshipTypeName, String relationshipTypeParameterName, String glossaryTermTwoGUID, String glossaryTermTwoGUIDParameterName, String expression, String description, int relationshipStatus, String steward, String source, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(glossaryTermOneGUID, glossaryTermOneGUIDParameterName, methodName);
        this.invalidParameterHandler.validateGUID(glossaryTermTwoGUID, glossaryTermTwoGUIDParameterName, methodName);
        this.invalidParameterHandler.validateName(relationshipTypeName, relationshipTypeParameterName, methodName);
        String relationshipTypeGUID = this.invalidParameterHandler.validateTypeName(relationshipTypeName, relationshipTypeName, this.serviceName, methodName, this.repositoryHelper);
        GlossaryTermBuilder builder = new GlossaryTermBuilder(this.repositoryHelper, this.serviceName, this.serverName);
        this.linkElementToElement(userId, externalSourceGUID, externalSourceName, glossaryTermOneGUID, glossaryTermOneGUIDParameterName, "GlossaryTerm", glossaryTermTwoGUID, glossaryTermTwoGUIDParameterName, "GlossaryTerm", forLineage, forDuplicateProcessing, this.supportedZones, relationshipTypeGUID, relationshipTypeName, builder.getTermRelationshipProperties(expression, description, relationshipStatus, steward, source, methodName), effectiveFrom, effectiveTo, effectiveTime, methodName);
    }

    public void updateTermRelationship(String userId, String externalSourceGUID, String externalSourceName, String glossaryTermOneGUID, String glossaryTermOneGUIDParameterName, String relationshipTypeName, String relationshipTypeParameterName, String glossaryTermTwoGUID, String glossaryTermTwoGUIDParameterName, String expression, String description, int relationshipStatus, String steward, String source, Date effectiveFrom, Date effectiveTo, boolean isMergeUpdate, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(glossaryTermOneGUID, glossaryTermOneGUIDParameterName, methodName);
        this.invalidParameterHandler.validateGUID(glossaryTermTwoGUID, glossaryTermTwoGUIDParameterName, methodName);
        this.invalidParameterHandler.validateName(relationshipTypeName, relationshipTypeParameterName, methodName);
        String relationshipTypeGUID = this.invalidParameterHandler.validateTypeName(relationshipTypeName, relationshipTypeName, this.serviceName, methodName, this.repositoryHelper);
        GlossaryTermBuilder builder = new GlossaryTermBuilder(this.repositoryHelper, this.serviceName, this.serverName);
        builder.setEffectivityDates(effectiveFrom, effectiveTo);
        this.updateElementToElementLink(userId, externalSourceGUID, externalSourceName, glossaryTermOneGUID, glossaryTermOneGUIDParameterName, "GlossaryTerm", glossaryTermTwoGUID, glossaryTermTwoGUIDParameterName, "GlossaryTerm", forLineage, forDuplicateProcessing, this.supportedZones, relationshipTypeGUID, relationshipTypeName, isMergeUpdate, builder.getTermRelationshipProperties(expression, description, relationshipStatus, steward, source, methodName), effectiveTime, methodName);
    }

    public void clearTermRelationship(String userId, String externalSourceGUID, String externalSourceName, String glossaryTermOneGUID, String glossaryTermOneGUIDParameterName, String relationshipTypeName, String relationshipTypeParameterName, String glossaryTermTwoGUID, String glossaryTermTwoGUIDParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(glossaryTermOneGUID, glossaryTermOneGUIDParameterName, methodName);
        this.invalidParameterHandler.validateGUID(glossaryTermTwoGUID, glossaryTermTwoGUIDParameterName, methodName);
        this.invalidParameterHandler.validateName(relationshipTypeName, relationshipTypeParameterName, methodName);
        String relationshipTypeGUID = this.invalidParameterHandler.validateTypeName(relationshipTypeName, relationshipTypeName, this.serviceName, methodName, this.repositoryHelper);
        this.unlinkElementFromElement(userId, false, externalSourceGUID, externalSourceName, glossaryTermOneGUID, glossaryTermOneGUIDParameterName, "GlossaryTerm", glossaryTermTwoGUID, glossaryTermTwoGUIDParameterName, "0db3e6ec-f5ef-4d75-ae38-b7ee6fd6ec0a", "GlossaryTerm", forLineage, forDuplicateProcessing, relationshipTypeGUID, relationshipTypeName, effectiveTime, methodName);
    }

    public void setTermAsAbstractConcept(String userId, String externalSourceGUID, String externalSourceName, String glossaryTermGUID, String glossaryTermGUIDParameterName, Date effectiveFrom, Date effectiveTo, boolean isMergeUpdate, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(glossaryTermGUID, glossaryTermGUIDParameterName, methodName);
        this.setClassificationInRepository(userId, externalSourceGUID, externalSourceName, glossaryTermGUID, glossaryTermGUIDParameterName, "GlossaryTerm", "9d725a07-4abf-4939-a268-419d200b69c2", "AbstractConcept", this.setUpEffectiveDates(null, effectiveFrom, effectiveTo), isMergeUpdate, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void clearTermAsAbstractConcept(String userId, String externalSourceGUID, String externalSourceName, String glossaryTermGUID, String glossaryTermGUIDParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(glossaryTermGUID, glossaryTermGUIDParameterName, methodName);
        this.removeClassificationFromRepository(userId, externalSourceGUID, externalSourceName, glossaryTermGUID, glossaryTermGUIDParameterName, "GlossaryTerm", "9d725a07-4abf-4939-a268-419d200b69c2", "AbstractConcept", forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void setTermAsDataValue(String userId, String externalSourceGUID, String externalSourceName, String glossaryTermGUID, String glossaryTermGUIDParameterName, Date effectiveFrom, Date effectiveTo, boolean isMergeUpdate, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(glossaryTermGUID, glossaryTermGUIDParameterName, methodName);
        this.setClassificationInRepository(userId, externalSourceGUID, externalSourceName, glossaryTermGUID, glossaryTermGUIDParameterName, "GlossaryTerm", "ab253e31-3d8a-45a7-8592-24329a189b9e", "DataValue", this.setUpEffectiveDates(null, effectiveFrom, effectiveTo), isMergeUpdate, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void clearTermAsDataValue(String userId, String externalSourceGUID, String externalSourceName, String glossaryTermGUID, String glossaryTermGUIDParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(glossaryTermGUID, glossaryTermGUIDParameterName, methodName);
        this.removeClassificationFromRepository(userId, externalSourceGUID, externalSourceName, glossaryTermGUID, glossaryTermGUIDParameterName, "GlossaryTerm", "ab253e31-3d8a-45a7-8592-24329a189b9e", "DataValue", forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void setTermAsActivity(String userId, String externalSourceGUID, String externalSourceName, String glossaryTermGUID, String glossaryTermGUIDParameterName, int activityType, Date effectiveFrom, Date effectiveTo, boolean isMergeUpdate, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(glossaryTermGUID, glossaryTermGUIDParameterName, methodName);
        GlossaryTermBuilder builder = new GlossaryTermBuilder(this.repositoryHelper, this.serviceName, this.serverName);
        builder.setEffectivityDates(effectiveFrom, effectiveTo);
        this.setClassificationInRepository(userId, externalSourceGUID, externalSourceName, glossaryTermGUID, glossaryTermGUIDParameterName, "GlossaryTerm", "317f0e52-1548-41e6-b90c-6ae5e6c53fed", "ActivityDescription", builder.getActivityTypeProperties(activityType, methodName), isMergeUpdate, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void clearTermAsActivity(String userId, String externalSourceGUID, String externalSourceName, String glossaryTermGUID, String glossaryTermGUIDParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(glossaryTermGUID, glossaryTermGUIDParameterName, methodName);
        this.removeClassificationFromRepository(userId, externalSourceGUID, externalSourceName, glossaryTermGUID, glossaryTermGUIDParameterName, "GlossaryTerm", "317f0e52-1548-41e6-b90c-6ae5e6c53fed", "ActivityDescription", forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void setTermAsContext(String userId, String externalSourceGUID, String externalSourceName, String glossaryTermGUID, String glossaryTermGUIDParameterName, String description, String scope, Date effectiveFrom, Date effectiveTo, boolean isMergeUpdate, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(glossaryTermGUID, glossaryTermGUIDParameterName, methodName);
        GlossaryTermBuilder builder = new GlossaryTermBuilder(this.repositoryHelper, this.serviceName, this.serverName);
        builder.setEffectivityDates(effectiveFrom, effectiveTo);
        this.setClassificationInRepository(userId, externalSourceGUID, externalSourceName, glossaryTermGUID, glossaryTermGUIDParameterName, "GlossaryTerm", "54f9f41a-3871-4650-825d-59a41de01330e", "ContextDefinition", builder.getContextDescriptionProperties(description, scope, methodName), isMergeUpdate, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void clearTermAsContext(String userId, String externalSourceGUID, String externalSourceName, String glossaryTermGUID, String glossaryTermGUIDParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(glossaryTermGUID, glossaryTermGUIDParameterName, methodName);
        this.removeClassificationFromRepository(userId, externalSourceGUID, externalSourceName, glossaryTermGUID, glossaryTermGUIDParameterName, "GlossaryTerm", "54f9f41a-3871-4650-825d-59a41de01330e", "ContextDefinition", forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void setTermAsSpineObject(String userId, String externalSourceGUID, String externalSourceName, String glossaryTermGUID, String glossaryTermGUIDParameterName, Date effectiveFrom, Date effectiveTo, boolean isMergeUpdate, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(glossaryTermGUID, glossaryTermGUIDParameterName, methodName);
        this.setClassificationInRepository(userId, externalSourceGUID, externalSourceName, glossaryTermGUID, glossaryTermGUIDParameterName, "GlossaryTerm", "a41ee152-de1e-4533-8535-2f8b37897cac", "SpineObject", this.setUpEffectiveDates(null, effectiveFrom, effectiveTo), isMergeUpdate, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void clearTermAsSpineObject(String userId, String externalSourceGUID, String externalSourceName, String glossaryTermGUID, String glossaryTermGUIDParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(glossaryTermGUID, glossaryTermGUIDParameterName, methodName);
        this.removeClassificationFromRepository(userId, externalSourceGUID, externalSourceName, glossaryTermGUID, glossaryTermGUIDParameterName, "GlossaryTerm", "a41ee152-de1e-4533-8535-2f8b37897cac", "SpineObject", forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void setTermAsSpineAttribute(String userId, String externalSourceGUID, String externalSourceName, String glossaryTermGUID, String glossaryTermGUIDParameterName, Date effectiveFrom, Date effectiveTo, boolean isMergeUpdate, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(glossaryTermGUID, glossaryTermGUIDParameterName, methodName);
        this.setClassificationInRepository(userId, externalSourceGUID, externalSourceName, glossaryTermGUID, glossaryTermGUIDParameterName, "GlossaryTerm", "ccb749ba-34ec-4f71-8755-4d8b383c34c3", "SpineAttribute", this.setUpEffectiveDates(null, effectiveFrom, effectiveTo), isMergeUpdate, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void clearTermAsSpineAttribute(String userId, String externalSourceGUID, String externalSourceName, String glossaryTermGUID, String glossaryTermGUIDParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(glossaryTermGUID, glossaryTermGUIDParameterName, methodName);
        this.removeClassificationFromRepository(userId, externalSourceGUID, externalSourceName, glossaryTermGUID, glossaryTermGUIDParameterName, "GlossaryTerm", "ccb749ba-34ec-4f71-8755-4d8b383c34c3", "SpineAttribute", forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void setTermAsObjectIdentifier(String userId, String externalSourceGUID, String externalSourceName, String glossaryTermGUID, String glossaryTermGUIDParameterName, Date effectiveFrom, Date effectiveTo, boolean isMergeUpdate, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(glossaryTermGUID, glossaryTermGUIDParameterName, methodName);
        this.setClassificationInRepository(userId, externalSourceGUID, externalSourceName, glossaryTermGUID, glossaryTermGUIDParameterName, "GlossaryTerm", "3d1e4389-27de-44fa-8df4-d57bfaf809ea", "ObjectIdentifier", this.setUpEffectiveDates(null, effectiveFrom, effectiveTo), isMergeUpdate, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void clearTermAsObjectIdentifier(String userId, String externalSourceGUID, String externalSourceName, String glossaryTermGUID, String glossaryTermGUIDParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(glossaryTermGUID, glossaryTermGUIDParameterName, methodName);
        this.removeClassificationFromRepository(userId, externalSourceGUID, externalSourceName, glossaryTermGUID, glossaryTermGUIDParameterName, "GlossaryTerm", "3d1e4389-27de-44fa-8df4-d57bfaf809ea", "ObjectIdentifier", forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void removeGlossaryTerm(String userId, String externalSourceGUID, String externalSourceName, String glossaryTermGUID, String glossaryTermGUIDParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.deleteBeanInRepository(userId, externalSourceGUID, externalSourceName, glossaryTermGUID, glossaryTermGUIDParameterName, "0db3e6ec-f5ef-4d75-ae38-b7ee6fd6ec0a", "GlossaryTerm", null, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public List<B> getTermsByName(String userId, String name, String nameParameterName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        ArrayList<String> specificMatchPropertyNames = new ArrayList<String>();
        specificMatchPropertyNames.add("qualifiedName");
        specificMatchPropertyNames.add("displayName");
        return this.getBeansByValue(userId, name, nameParameterName, "0db3e6ec-f5ef-4d75-ae38-b7ee6fd6ec0a", "GlossaryTerm", specificMatchPropertyNames, true, null, null, forLineage, forDuplicateProcessing, this.supportedZones, null, startFrom, pageSize, effectiveTime, methodName);
    }

    public List<B> findTerms(String userId, String name, String nameParameterName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        ArrayList<String> specificMatchPropertyNames = new ArrayList<String>();
        specificMatchPropertyNames.add("qualifiedName");
        specificMatchPropertyNames.add("displayName");
        return this.getBeansByValue(userId, name, nameParameterName, "0db3e6ec-f5ef-4d75-ae38-b7ee6fd6ec0a", "GlossaryTerm", specificMatchPropertyNames, false, null, null, forLineage, forDuplicateProcessing, this.supportedZones, null, startFrom, pageSize, effectiveTime, methodName);
    }

    public B getTerm(String userId, String guid, String guidParameter, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getBeanFromRepository(userId, guid, guidParameter, "GlossaryTerm", forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public List<B> getTermsForGlossary(String userId, String glossaryGUID, String glossaryGUIDParameterName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.getAttachedElements(userId, glossaryGUID, glossaryGUIDParameterName, "Glossary", "1d43d661-bdc7-4a91-a996-3239b8f82e56", "TermAnchor", "GlossaryTerm", null, null, 0, forLineage, forDuplicateProcessing, startFrom, pageSize, effectiveTime, methodName);
    }

    public List<B> getTermsForGlossaryCategory(String userId, String glossaryCategoryGUID, String glossaryCategoryGUIDParameterName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.getAttachedElements(userId, glossaryCategoryGUID, glossaryCategoryGUIDParameterName, "GlossaryCategory", "696a81f5-ac60-46c7-b9fd-6979a1e7ad27", "TermCategorization", "GlossaryTerm", null, null, 0, forLineage, forDuplicateProcessing, startFrom, pageSize, effectiveTime, methodName);
    }

    public List<B> getAttachedMeanings(String userId, String elementGUID, String elementGUIDParameterName, String elementTypeName, List<String> serviceSupportedZones, int startingFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getAttachedElements(userId, null, null, elementGUID, elementGUIDParameterName, elementTypeName, "e6670973-645f-441a-bec7-6f5570345b92", "SemanticAssignment", "GlossaryTerm", null, null, 0, forLineage, forDuplicateProcessing, serviceSupportedZones, startingFrom, pageSize, effectiveTime, methodName);
    }
}

