/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.generichandlers.GovernanceActionBuilder;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericConverter;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericHandler;
import org.odpi.openmetadata.commonservices.generichandlers.ffdc.GenericHandlersAuditCode;
import org.odpi.openmetadata.commonservices.generichandlers.ffdc.GenericHandlersErrorCode;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryEntitiesIterator;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryRelationshipsIterator;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositorySelectedEntitiesIterator;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.OCFCheckedExceptionBase;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.governanceaction.properties.GovernanceActionStatus;
import org.odpi.openmetadata.frameworks.governanceaction.properties.NewActionTarget;
import org.odpi.openmetadata.metadatasecurity.server.OpenMetadataServerSecurityVerifier;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.MatchCriteria;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EnumPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeErrorException;

public class GovernanceActionHandler<B>
extends OpenMetadataAPIGenericHandler<B> {
    public GovernanceActionHandler(OpenMetadataAPIGenericConverter<B> converter, Class<B> beanClass, String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper, String localServerUserId, OpenMetadataServerSecurityVerifier securityVerifier, List<String> supportedZones, List<String> defaultZones, List<String> publishZones, AuditLog auditLog) {
        super(converter, beanClass, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
    }

    public String initiateGovernanceActionProcess(String userId, String processQualifiedName, List<String> requestSourceGUIDs, List<NewActionTarget> actionTargets, Map<String, String> requestParameters, Date startTime, String originatorServiceName, String originatorEngineName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String qualifiedNameParameterName = "processQualifiedName";
        String governanceActionTypeGUIDParameterName = "governanceActionFlowRelationship.getEntityTwoProxy().getGUID()";
        Date effectiveTime = new Date();
        String governanceActionProcessGUID = this.getBeanGUIDByUniqueName(userId, processQualifiedName, "processQualifiedName", "qualifiedName", "4d3a2b8d-9e2e-4832-b338-21c74e45b238", "GovernanceActionProcess", false, false, this.supportedZones, effectiveTime, methodName);
        if (governanceActionProcessGUID != null) {
            Relationship governanceActionFlowRelationship = this.repositoryHandler.getUniqueRelationshipByType(userId, governanceActionProcessGUID, "GovernanceActionProcess", true, "5f6ddee5-31ea-4d4f-9c3f-00ad2fcb2aa0", "GovernanceActionFlow", false, false, effectiveTime, methodName);
            if (governanceActionFlowRelationship != null) {
                String governanceActionTypeGUID = governanceActionFlowRelationship.getEntityTwoProxy().getGUID();
                String guard = this.repositoryHelper.getStringProperty(this.serviceName, "guard", governanceActionFlowRelationship.getProperties(), methodName);
                return this.prepareGovernanceActionFromType(userId, null, governanceActionTypeGUID, "governanceActionFlowRelationship.getEntityTwoProxy().getGUID()", guard, false, startTime, null, requestParameters, requestSourceGUIDs, actionTargets, processQualifiedName + UUID.randomUUID(), processQualifiedName, originatorServiceName, originatorEngineName, methodName);
            }
            throw new InvalidParameterException(GenericHandlersErrorCode.NO_PROCESS_IMPLEMENTATION.getMessageDefinition(processQualifiedName), this.getClass().getName(), methodName, "processQualifiedName");
        }
        throw new InvalidParameterException(GenericHandlersErrorCode.UNKNOWN_PROCESS.getMessageDefinition(processQualifiedName), this.getClass().getName(), methodName, "processQualifiedName");
    }

    private String prepareGovernanceActionFromType(String userId, String anchorGUID, String governanceActionTypeGUID, String governanceActionTypeGUIDParameterName, String guard, boolean mandatoryGuard, Date suppliedStartTime, String previousGovernanceActionGUID, Map<String, String> initialRequestParameters, List<String> requestSourceGUIDs, List<NewActionTarget> newActionTargets, String processName, String requestSourceName, String originatorServiceName, String originatorEngineName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String governanceActionGUID;
        Relationship governanceActionTypeExecutorRelationship = this.repositoryHandler.getUniqueRelationshipByType(userId, governanceActionTypeGUID, "GovernanceActionType", true, "f672245f-35b5-4ca7-b645-014cf61d5b75", "GovernanceActionTypeExecutor", false, false, null, methodName);
        if (governanceActionTypeExecutorRelationship == null) {
            throw new InvalidParameterException(GenericHandlersErrorCode.UNKNOWN_EXECUTOR.getMessageDefinition(governanceActionTypeGUID, "GovernanceActionTypeExecutor"), this.getClass().getName(), methodName, governanceActionTypeGUIDParameterName);
        }
        EntityDetail governanceActionTypeEntity = this.getEntityFromRepository(userId, governanceActionTypeGUID, governanceActionTypeGUIDParameterName, "GovernanceActionType", null, null, false, false, this.supportedZones, null, methodName);
        boolean ignoreMultipleTriggers = this.repositoryHelper.getBooleanProperty(this.serviceName, "ignoreMultipleTriggers", governanceActionTypeEntity.getProperties(), methodName);
        String governanceActionTypeName = this.repositoryHelper.getStringProperty(this.serviceName, "qualifiedName", governanceActionTypeEntity.getProperties(), methodName);
        int domainIdentifier = this.repositoryHelper.getIntProperty(this.serviceName, "domainIdentifier", governanceActionTypeEntity.getProperties(), methodName);
        String displayName = this.repositoryHelper.getStringProperty(this.serviceName, "displayName", governanceActionTypeEntity.getProperties(), methodName);
        String description = this.repositoryHelper.getStringProperty(this.serviceName, "description", governanceActionTypeEntity.getProperties(), methodName);
        int waitTime = this.repositoryHelper.getIntProperty(this.serviceName, "waitTime", governanceActionTypeEntity.getProperties(), methodName);
        Date startDate = suppliedStartTime;
        if (suppliedStartTime == null) {
            long startTime = new Date().getTime() + (long)waitTime * 1000L;
            startDate = new Date(startTime);
        }
        ArrayList<String> receivedGuards = null;
        if (guard != null) {
            receivedGuards = new ArrayList<String>();
            receivedGuards.add(guard);
        }
        String governanceEngineName = this.repositoryHelper.getStringProperty(this.serviceName, "qualifiedName", governanceActionTypeExecutorRelationship.getEntityTwoProxy().getUniqueProperties(), methodName);
        String requestType = this.repositoryHelper.getStringProperty(this.serviceName, "requestType", governanceActionTypeExecutorRelationship.getProperties(), methodName);
        Map<String, String> requestParameters = this.repositoryHelper.getStringMapFromProperty(this.serviceName, "requestParameters", governanceActionTypeExecutorRelationship.getProperties(), methodName);
        if (initialRequestParameters != null && !initialRequestParameters.isEmpty()) {
            if (requestParameters == null) {
                requestParameters = initialRequestParameters;
            } else {
                requestParameters.putAll(initialRequestParameters);
            }
        }
        List<String> mandatoryGuards = this.getMandatoryGuards(userId, governanceActionTypeGUID);
        String newAnchorGUID = anchorGUID;
        if (anchorGUID == null) {
            newAnchorGUID = previousGovernanceActionGUID;
        }
        if ((governanceActionGUID = this.getGovernanceActionForType(userId, governanceActionTypeName + ":" + UUID.randomUUID(), domainIdentifier, displayName, description, requestSourceGUIDs, newActionTargets, mandatoryGuards, ignoreMultipleTriggers, receivedGuards, startDate, governanceEngineName, requestType, requestParameters, governanceActionTypeGUID, governanceActionTypeName, newAnchorGUID, processName, requestSourceName, originatorServiceName, originatorEngineName, methodName)) != null && previousGovernanceActionGUID != null) {
            InstanceProperties nextGovernanceActionProperties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, "guard", guard, methodName);
            nextGovernanceActionProperties = this.repositoryHelper.addBooleanPropertyToInstance(this.serviceName, nextGovernanceActionProperties, "mandatoryGuard", mandatoryGuard, methodName);
            this.repositoryHandler.createRelationship(userId, "4efd16d4-f397-449c-a75d-ebea42fe581b", null, null, previousGovernanceActionGUID, governanceActionGUID, nextGovernanceActionProperties, methodName);
        }
        this.runGovernanceActionIfReady(userId, governanceActionGUID, governanceActionTypeName + ":" + UUID.randomUUID(), mandatoryGuards, startDate, governanceEngineName, requestType, requestParameters, governanceActionTypeName, requestSourceName, methodName);
        return governanceActionGUID;
    }

    private void runGovernanceActionIfReady(String userId, String governanceActionGUID, String qualifiedName, List<String> mandatoryGuards, Date startTime, String governanceEngineName, String requestType, Map<String, String> requestParameters, String governanceActionTypeName, String requestSourceName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        List previousResults = this.repositoryHandler.getRelationshipsByType(userId, governanceActionGUID, "GovernanceAction", "4efd16d4-f397-449c-a75d-ebea42fe581b", "NextGovernanceAction", 1, false, false, 0, 0, null, methodName);
        ArrayList<String> receivedGuards = new ArrayList<String>();
        if (previousResults != null) {
            for (Relationship previousResult : previousResults) {
                if (previousResult == null || governanceActionGUID.equals(previousResult.getEntityOneProxy().getGUID())) continue;
                String guard = this.repositoryHelper.getStringProperty(this.serviceName, "guard", previousResult.getProperties(), methodName);
                receivedGuards.add(guard);
            }
        }
        if (mandatoryGuards == null || mandatoryGuards.isEmpty() || receivedGuards.containsAll(mandatoryGuards)) {
            this.approveGovernanceAction(userId, governanceActionGUID, qualifiedName, mandatoryGuards, receivedGuards, startTime, governanceEngineName, requestType, requestParameters, governanceActionTypeName, requestSourceName, methodName);
        }
    }

    public String approveGovernanceAction(String userId, String governanceActionGUID, String qualifiedName, List<String> mandatoryGuards, List<String> receivedGuards, Date startTime, String governanceEngineName, String requestType, Map<String, String> requestParameters, String governanceActionTypeName, String requestSourceName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String qualifiedNameParameterName = "qualifiedName";
        String engineNameParameterName = "governanceEngineName";
        String requestTypeParameterName = "requestType";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        this.invalidParameterHandler.validateName(governanceEngineName, "governanceEngineName", methodName);
        this.invalidParameterHandler.validateName(requestType, "requestType", methodName);
        String receivedGuardsString = "<null>";
        String mandatoryGuardsString = "<null>";
        String startTimeString = "<now>";
        String requestParameterNames = "<null>";
        if (receivedGuards != null) {
            receivedGuardsString = receivedGuards.toString();
        }
        if (mandatoryGuards != null) {
            mandatoryGuardsString = mandatoryGuards.toString();
        }
        if (startTime != null) {
            startTimeString = startTime.toString();
        }
        if (requestParameters != null) {
            requestParameterNames = requestParameters.keySet().toString();
        }
        if (governanceActionTypeName != null) {
            this.auditLog.logMessage(methodName, GenericHandlersAuditCode.INITIATE_GOVERNANCE_ACTION_FROM_TYPE.getMessageDefinition(qualifiedName, governanceActionTypeName, requestType, governanceEngineName, receivedGuardsString, mandatoryGuardsString, requestParameterNames, startTimeString, requestSourceName));
        } else {
            this.auditLog.logMessage(methodName, GenericHandlersAuditCode.INITIATE_GOVERNANCE_ACTION.getMessageDefinition(qualifiedName, requestType, governanceEngineName, receivedGuardsString, mandatoryGuardsString, requestParameterNames, startTimeString, requestSourceName));
        }
        this.updateGovernanceActionStatus(userId, governanceActionGUID, 1, null, methodName);
        return governanceActionGUID;
    }

    public String createGovernanceAction(String userId, String qualifiedName, int domainIdentifier, String displayName, String description, List<String> requestSourceGUIDs, List<NewActionTarget> actionTargets, List<String> mandatoryGuards, List<String> receivedGuards, Date startTime, String governanceEngineName, String requestType, Map<String, String> requestParameters, String governanceActionTypeGUID, String governanceActionTypeName, String anchorGUID, String processName, String requestSourceName, String originatorServiceName, String originatorEngineName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String governanceActionGUID;
        String qualifiedNameParameterName = "qualifiedName";
        String engineNameParameterName = "governanceEngineName";
        String requestTypeParameterName = "requestType";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        this.invalidParameterHandler.validateName(governanceEngineName, "governanceEngineName", methodName);
        this.invalidParameterHandler.validateName(requestType, "requestType", methodName);
        String governanceEngineGUID = this.validateGovernanceEngineName(userId, governanceEngineName, "governanceEngineName", requestType, methodName);
        GovernanceActionBuilder builder = new GovernanceActionBuilder(qualifiedName, domainIdentifier, displayName, description, governanceEngineGUID, governanceEngineName, processName, governanceActionTypeGUID, governanceActionTypeName, requestType, requestParameters, mandatoryGuards, receivedGuards, 0, startTime, null, null, null, null, this.repositoryHelper, this.serviceName, this.serverName);
        if (anchorGUID != null) {
            builder.setAnchors(userId, anchorGUID, methodName);
        }
        if ((governanceActionGUID = this.createBeanInRepository(userId, null, null, "c976d88a-2b11-4b40-b972-c38d41bfc6be", "GovernanceAction", builder, null, methodName)) != null) {
            String governanceActionGUIDParameterName = "governanceActionGUID";
            InstanceProperties originatorProperties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, "originGovernanceService", originatorServiceName, methodName);
            originatorProperties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, originatorProperties, "originGovernanceEngine", originatorEngineName, methodName);
            if (requestSourceGUIDs != null && !requestSourceGUIDs.isEmpty()) {
                String requestSourceGUIDParameterName = "requestSourceGUIDs[x]";
                originatorProperties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, originatorProperties, "requestSourceName", requestSourceName, methodName);
                for (String requestSourceGUID : requestSourceGUIDs) {
                    if (requestSourceGUID == null) continue;
                    this.linkElementToElement(userId, null, null, requestSourceGUID, "requestSourceGUIDs[x]", "OpenMetadataRoot", governanceActionGUID, "governanceActionGUID", "GovernanceAction", true, true, this.supportedZones, "5323a705-4c1f-456a-9741-41fdcb8e93ac", "GovernanceActionRequestSource", originatorProperties, null, null, null, methodName);
                }
            }
            this.addActionTargets(userId, governanceActionGUID, "governanceActionGUID", qualifiedName, actionTargets, methodName);
        }
        return governanceActionGUID;
    }

    private synchronized String getGovernanceActionForType(String userId, String qualifiedName, int domainIdentifier, String displayName, String description, List<String> requestSourceGUIDs, List<NewActionTarget> actionTargets, List<String> mandatoryGuards, boolean ignoreMultipleTriggers, List<String> receivedGuards, Date startTime, String governanceEngineName, String requestType, Map<String, String> requestParameters, String governanceActionTypeGUID, String governanceActionTypeName, String anchorGUID, String processName, String requestSourceName, String originatorServiceName, String originatorEngineName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String qualifiedNameParameterName = "qualifiedName";
        String engineNameParameterName = "governanceEngineName";
        String requestTypeParameterName = "requestType";
        String nameParameterName = "governanceActionTypeGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        this.invalidParameterHandler.validateName(governanceEngineName, "governanceEngineName", methodName);
        this.invalidParameterHandler.validateName(requestType, "requestType", methodName);
        ArrayList<String> specificMatchPropertyNames = new ArrayList<String>();
        specificMatchPropertyNames.add("processName");
        List<EntityDetail> entities = this.getEntitiesByValue(userId, processName, "governanceActionTypeGUID", "c976d88a-2b11-4b40-b972-c38d41bfc6be", "GovernanceAction", specificMatchPropertyNames, true, false, null, null, false, false, this.supportedZones, null, 0, 0, null, methodName);
        if (entities != null) {
            String selectedGovernanceAction = null;
            for (EntityDetail entity : entities) {
                String entityGovernanceActionTypeGUID = this.repositoryHelper.getStringProperty(this.serviceName, "governanceActionTypeGUID", entity.getProperties(), methodName);
                if (!governanceActionTypeGUID.equals(entityGovernanceActionTypeGUID)) continue;
                if (ignoreMultipleTriggers) {
                    return null;
                }
                GovernanceActionStatus status = this.getActionStatus("actionStatus", entity.getProperties());
                if (status != GovernanceActionStatus.REQUESTED) continue;
                selectedGovernanceAction = entity.getGUID();
            }
            if (selectedGovernanceAction != null) {
                return selectedGovernanceAction;
            }
        }
        return this.createGovernanceAction(userId, governanceActionTypeName + ":" + UUID.randomUUID(), domainIdentifier, displayName, description, requestSourceGUIDs, actionTargets, mandatoryGuards, receivedGuards, startTime, governanceEngineName, requestType, requestParameters, governanceActionTypeGUID, governanceActionTypeName, anchorGUID, processName, requestSourceName, originatorServiceName, originatorEngineName, methodName);
    }

    private void addActionTargets(String userId, String governanceActionGUID, String governanceActionGUIDParameterName, String governanceActionName, List<NewActionTarget> actionTargets, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        if (actionTargets != null && !actionTargets.isEmpty()) {
            String actionTargetGUIDParameterName = "actionTargets[x]";
            for (NewActionTarget actionTarget : actionTargets) {
                if (actionTarget == null) continue;
                String actionTargetGUID = actionTarget.getActionTargetGUID();
                String actionTargetName = actionTarget.getActionTargetName();
                if (actionTargetGUID == null) continue;
                InstanceProperties properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, "actionTargetName", actionTargetName, methodName);
                this.linkElementToElement(userId, null, null, governanceActionGUID, governanceActionGUIDParameterName, "GovernanceAction", actionTargetGUID, "actionTargets[x]", "Referenceable", true, true, this.supportedZones, "46ec49bf-af66-4575-aab7-06ce895120cd", "TargetForAction", properties, null, null, null, methodName);
                this.auditLog.logMessage(methodName, GenericHandlersAuditCode.ADD_ACTION_TARGETS.getMessageDefinition(actionTargetName, actionTargetGUID, governanceActionName, governanceActionGUID));
            }
        }
    }

    private String validateGovernanceEngineName(String userId, String governanceEngineName, String governanceEngineNameParameterName, String requestType, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String governanceEngineGUID = this.getBeanGUIDByUniqueName(userId, governanceEngineName, governanceEngineNameParameterName, "qualifiedName", "3fa23d4a-aceb-422f-9301-04ed474c6f74", "GovernanceEngine", false, false, this.supportedZones, new Date(), methodName);
        if (governanceEngineGUID == null) {
            throw new InvalidParameterException(GenericHandlersErrorCode.UNKNOWN_ENGINE_NAME.getMessageDefinition(governanceEngineName, this.serviceName, this.serverName), this.getClass().getName(), methodName, governanceEngineNameParameterName);
        }
        List<Relationship> relationships = this.getAttachmentLinks(userId, governanceEngineGUID, governanceEngineNameParameterName, "GovernanceEngine", "2726df0e-4f3a-44e1-8433-4ca5301457fd", "SupportedGovernanceService", null, "GovernanceService", 2, false, false, (List<String>)this.supportedZones, 0, 0, new Date(), methodName);
        if (relationships == null) {
            throw new InvalidParameterException(GenericHandlersErrorCode.NO_REQUEST_TYPE_FOR_ENGINE.getMessageDefinition(governanceEngineName, governanceEngineGUID, requestType, this.serviceName, this.serverName), this.getClass().getName(), methodName, governanceEngineNameParameterName);
        }
        for (Relationship relationship : relationships) {
            String relationshipRequestType = this.repositoryHelper.getStringProperty(this.serviceName, "requestType", relationship.getProperties(), methodName);
            if (!requestType.equals(relationshipRequestType)) continue;
            return governanceEngineGUID;
        }
        throw new InvalidParameterException(GenericHandlersErrorCode.UNKNOWN_REQUEST_TYPE.getMessageDefinition(governanceEngineName, governanceEngineGUID, requestType, this.serviceName, this.serverName), this.getClass().getName(), methodName, governanceEngineNameParameterName);
    }

    public B getGovernanceAction(String userId, String governanceActionGUID, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String governanceActionGUIDParameterName = "governanceActionGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(governanceActionGUID, "governanceActionGUID", methodName);
        EntityDetail primaryEntity = this.getEntityFromRepository(userId, governanceActionGUID, "governanceActionGUID", "GovernanceAction", null, null, false, false, this.supportedZones, effectiveTime, methodName);
        return this.getGovernanceAction(userId, primaryEntity, effectiveTime, methodName);
    }

    public B getGovernanceAction(String userId, EntityDetail primaryEntity, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String actionTargetGUIDParameterName = "actionTargetGUID";
        String requestSourceGUIDParameterName = "requestSourceGUID";
        if (primaryEntity != null) {
            ArrayList<Relationship> relationships = new ArrayList<Relationship>();
            ArrayList<EntityDetail> supplementaryEntities = new ArrayList<EntityDetail>();
            RepositoryRelationshipsIterator iterator = new RepositoryRelationshipsIterator(this.repositoryHandler, this.invalidParameterHandler, userId, primaryEntity.getGUID(), "GovernanceAction", null, null, 0, false, false, 0, this.invalidParameterHandler.getMaxPagingSize(), effectiveTime, methodName);
            while (iterator.moreToReceive()) {
                Relationship relationship = iterator.getNext();
                if (relationship == null || relationship.getType() == null) continue;
                String actualTypeName = relationship.getType().getTypeDefName();
                if (this.repositoryHelper.isTypeOf(this.serviceName, actualTypeName, "TargetForAction")) {
                    relationships.add(relationship);
                    String actionTargetGUID = relationship.getEntityTwoProxy().getGUID();
                    supplementaryEntities.add(this.getEntityFromRepository(userId, actionTargetGUID, "actionTargetGUID", "Referenceable", null, null, true, true, this.supportedZones, effectiveTime, methodName));
                    continue;
                }
                if (this.repositoryHelper.isTypeOf(this.serviceName, actualTypeName, "GovernanceActionRequestSource")) {
                    relationships.add(relationship);
                    String requestSourceGUID = relationship.getEntityOneProxy().getGUID();
                    supplementaryEntities.add(this.getEntityFromRepository(userId, requestSourceGUID, "requestSourceGUID", "OpenMetadataRoot", null, null, true, true, this.supportedZones, effectiveTime, methodName));
                    continue;
                }
                relationships.add(relationship);
            }
            return this.converter.getNewComplexBean(this.beanClass, primaryEntity, supplementaryEntities, relationships, methodName);
        }
        return null;
    }

    public GovernanceActionStatus getActionStatus(String propertyName, InstanceProperties properties) {
        InstancePropertyValue instancePropertyValue;
        Map instancePropertiesMap;
        GovernanceActionStatus governanceActionStatus = GovernanceActionStatus.OTHER;
        if (properties != null && (instancePropertiesMap = properties.getInstanceProperties()) != null && (instancePropertyValue = (InstancePropertyValue)instancePropertiesMap.get(propertyName)) instanceof EnumPropertyValue) {
            EnumPropertyValue enumPropertyValue = (EnumPropertyValue)instancePropertyValue;
            switch (enumPropertyValue.getOrdinal()) {
                case 0: {
                    governanceActionStatus = GovernanceActionStatus.REQUESTED;
                    break;
                }
                case 1: {
                    governanceActionStatus = GovernanceActionStatus.APPROVED;
                    break;
                }
                case 2: {
                    governanceActionStatus = GovernanceActionStatus.WAITING;
                    break;
                }
                case 3: {
                    governanceActionStatus = GovernanceActionStatus.ACTIVATING;
                    break;
                }
                case 4: {
                    governanceActionStatus = GovernanceActionStatus.IN_PROGRESS;
                    break;
                }
                case 10: {
                    governanceActionStatus = GovernanceActionStatus.ACTIONED;
                    break;
                }
                case 11: {
                    governanceActionStatus = GovernanceActionStatus.INVALID;
                    break;
                }
                case 12: {
                    governanceActionStatus = GovernanceActionStatus.IGNORED;
                    break;
                }
                case 13: {
                    governanceActionStatus = GovernanceActionStatus.FAILED;
                }
            }
        }
        return governanceActionStatus;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void claimGovernanceAction(String userId, String governanceActionGUID, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String guidParameterName = "governanceActionGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(governanceActionGUID, "governanceActionGUID", methodName);
        EntityDetail entity = this.getEntityFromRepository(userId, governanceActionGUID, "governanceActionGUID", "GovernanceAction", null, null, false, false, this.supportedZones, effectiveTime, methodName);
        if (entity == null) throw new PropertyServerException(GenericHandlersErrorCode.MISSING_GOVERNANCE_ACTION.getMessageDefinition(governanceActionGUID, "governanceActionGUID", this.serviceName, methodName), this.getClass().getName(), methodName);
        InstanceProperties properties = entity.getProperties();
        if (properties == null) throw new PropertyServerException(GenericHandlersErrorCode.MISSING_GOVERNANCE_ACTION_PROPERTIES.getMessageDefinition(governanceActionGUID, "governanceActionGUID", this.serviceName, methodName), this.getClass().getName(), methodName);
        GovernanceActionStatus status = this.getActionStatus("actionStatus", properties);
        String processingEngineUserId = this.repositoryHelper.getStringProperty(this.serviceName, "processingEngineUserId", properties, methodName);
        if (status != GovernanceActionStatus.APPROVED || processingEngineUserId != null) {
            throw new PropertyServerException(GenericHandlersErrorCode.INVALID_GOVERNANCE_ACTION_STATUS.getMessageDefinition(userId, governanceActionGUID, processingEngineUserId, status.getName()), this.getClass().getName(), methodName);
        }
        GovernanceActionBuilder builder = new GovernanceActionBuilder(2, userId, this.repositoryHelper, this.serviceName, this.serverName);
        this.updateBeanInRepository(userId, null, null, governanceActionGUID, "governanceActionGUID", "c976d88a-2b11-4b40-b972-c38d41bfc6be", "GovernanceAction", false, false, (List<String>)this.supportedZones, builder.getClaimInstanceProperties(methodName), true, effectiveTime, methodName);
        this.auditLog.logMessage(methodName, GenericHandlersAuditCode.SUCCESSFUL_ACTION_CLAIM_REQUEST.getMessageDefinition(userId, governanceActionGUID));
    }

    private String getGovernanceActionStatusName(int ordinal) {
        String governanceActionStatusName = "UNKNOWN";
        switch (ordinal) {
            case 0: {
                governanceActionStatusName = "REQUESTED";
                break;
            }
            case 1: {
                governanceActionStatusName = "APPROVED";
                break;
            }
            case 2: {
                governanceActionStatusName = "WAITING";
                break;
            }
            case 4: {
                governanceActionStatusName = "IN_PROGRESS";
                break;
            }
            case 10: {
                governanceActionStatusName = "ACTIONED";
                break;
            }
            case 11: {
                governanceActionStatusName = "INVALID";
                break;
            }
            case 12: {
                governanceActionStatusName = "IGNORED";
                break;
            }
            case 13: {
                governanceActionStatusName = "FAILED";
                break;
            }
            case 99: {
                governanceActionStatusName = "OTHER";
            }
        }
        return governanceActionStatusName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void updateGovernanceActionStatus(String userId, String governanceActionGUID, int governanceActionStatus, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String guidParameterName = "governanceActionGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(governanceActionGUID, "governanceActionGUID", methodName);
        EntityDetail entity = this.getEntityFromRepository(userId, governanceActionGUID, "governanceActionGUID", "GovernanceAction", null, null, false, false, this.supportedZones, effectiveTime, methodName);
        if (entity == null) throw new PropertyServerException(GenericHandlersErrorCode.MISSING_GOVERNANCE_ACTION.getMessageDefinition(governanceActionGUID, "governanceActionGUID", this.serviceName, methodName), this.getClass().getName(), methodName);
        InstanceProperties properties = entity.getProperties();
        if (properties == null) throw new PropertyServerException(GenericHandlersErrorCode.MISSING_GOVERNANCE_ACTION_PROPERTIES.getMessageDefinition(governanceActionGUID, "governanceActionGUID", this.serviceName, methodName), this.getClass().getName(), methodName);
        int currentStatus = this.repositoryHelper.getEnumPropertyOrdinal(this.serviceName, "actionStatus", properties, methodName);
        String processingEngineUserId = this.repositoryHelper.getStringProperty(this.serviceName, "processingEngineUserId", properties, methodName);
        if ((processingEngineUserId != null || governanceActionStatus != 1) && !userId.equals(processingEngineUserId)) throw new UserNotAuthorizedException(GenericHandlersErrorCode.INVALID_PROCESSING_USER.getMessageDefinition(userId, methodName, governanceActionGUID, processingEngineUserId), this.getClass().getName(), methodName, userId);
        try {
            properties = this.repositoryHelper.addEnumPropertyToInstance(this.serviceName, null, "actionStatus", "a6e698b0-a4f7-4a39-8c80-db0bb0f972ec", "GovernanceActionStatus", governanceActionStatus, methodName);
        }
        catch (TypeErrorException error) {
            throw new InvalidParameterException((OCFCheckedExceptionBase)error, "activityType");
        }
        this.updateBeanInRepository(userId, null, null, governanceActionGUID, "governanceActionGUID", "c976d88a-2b11-4b40-b972-c38d41bfc6be", "GovernanceAction", false, false, (List<String>)this.supportedZones, properties, true, effectiveTime, methodName);
        this.auditLog.logMessage(methodName, GenericHandlersAuditCode.GOVERNANCE_ACTION_STATUS_CHANGE.getMessageDefinition(this.getGovernanceActionStatusName(currentStatus), this.getGovernanceActionStatusName(governanceActionStatus), governanceActionGUID, userId));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void recordCompletionStatus(String userId, String governanceActionGUID, int status, Map<String, String> callerRequestParameters, List<String> outputGuards, List<NewActionTarget> newActionTargets, String completionMessage, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String guidParameterName = "governanceActionGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(governanceActionGUID, "governanceActionGUID", methodName);
        EntityDetail governanceActionEntity = this.getEntityFromRepository(userId, governanceActionGUID, "governanceActionGUID", "GovernanceAction", null, null, false, false, this.supportedZones, effectiveTime, methodName);
        if (governanceActionEntity == null) throw new PropertyServerException(GenericHandlersErrorCode.MISSING_GOVERNANCE_ACTION.getMessageDefinition(governanceActionGUID, "governanceActionGUID", this.serviceName, methodName), this.getClass().getName(), methodName);
        InstanceProperties properties = governanceActionEntity.getProperties();
        if (properties == null) throw new PropertyServerException(GenericHandlersErrorCode.MISSING_GOVERNANCE_ACTION_PROPERTIES.getMessageDefinition(governanceActionGUID, "governanceActionGUID", this.serviceName, methodName), this.getClass().getName(), methodName);
        String processingEngineUserId = this.repositoryHelper.getStringProperty(this.serviceName, "processingEngineUserId", properties, methodName);
        String governanceActionTypeGUID = this.repositoryHelper.getStringProperty(this.serviceName, "governanceActionTypeGUID", properties, methodName);
        if (!userId.equals(processingEngineUserId)) {
            throw new UserNotAuthorizedException(GenericHandlersErrorCode.INVALID_PROCESSING_USER.getMessageDefinition(userId, methodName, governanceActionGUID, processingEngineUserId), this.getClass().getName(), methodName, userId);
        }
        GovernanceActionBuilder builder = new GovernanceActionBuilder(this.repositoryHelper, this.serviceName, this.serverName);
        this.repositoryHandler.updateEntityProperties(userId, null, null, governanceActionGUID, governanceActionEntity, "c976d88a-2b11-4b40-b972-c38d41bfc6be", "GovernanceAction", builder.getCompletionInstanceProperties(governanceActionEntity.getProperties(), status, new Date(), outputGuards, completionMessage, methodName), methodName);
        this.markActionTargetsAsComplete(userId, governanceActionGUID, effectiveTime, status);
        String anchorGUID = this.getAnchorGUIDFromAnchorsClassification(governanceActionEntity, methodName);
        String processName = this.repositoryHelper.getStringProperty(this.serviceName, "processName", properties, methodName);
        this.initiateNextGovernanceActions(userId, governanceActionGUID, governanceActionTypeGUID, anchorGUID, processName, outputGuards, newActionTargets, callerRequestParameters, effectiveTime, methodName);
    }

    private void markActionTargetsAsComplete(String userId, String governanceActionGUID, Date effectiveTime, int status) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "markActionTargetsAsComplete";
        List actionTargetRelationships = this.repositoryHandler.getRelationshipsByType(userId, governanceActionGUID, "GovernanceAction", "46ec49bf-af66-4575-aab7-06ce895120cd", "TargetForAction", 2, false, false, 0, 0, effectiveTime, "markActionTargetsAsComplete");
        if (actionTargetRelationships != null) {
            for (Relationship actionTarget : actionTargetRelationships) {
                InstanceProperties newActionTargetProperties;
                InstanceProperties actionTargetProperties;
                if (actionTarget == null || (actionTargetProperties = actionTarget.getProperties()).getPropertyValue("status") != null) continue;
                try {
                    newActionTargetProperties = this.repositoryHelper.addEnumPropertyToInstance(this.serviceName, actionTarget.getProperties(), "status", "a6e698b0-a4f7-4a39-8c80-db0bb0f972ec", "GovernanceActionStatus", status, "markActionTargetsAsComplete");
                }
                catch (TypeErrorException error) {
                    throw new PropertyServerException((OCFCheckedExceptionBase)error);
                }
                newActionTargetProperties = this.repositoryHelper.addDatePropertyToInstance(this.serviceName, newActionTargetProperties, "completionDate", new Date(), "markActionTargetsAsComplete");
                this.repositoryHandler.updateRelationshipProperties(userId, null, null, actionTarget, newActionTargetProperties, "markActionTargetsAsComplete");
            }
        }
    }

    private void initiateNextGovernanceActions(String userId, String previousGovernanceActionGUID, String previousGovernanceActionTypeGUID, String anchorGUID, String processName, List<String> outputGuards, List<NewActionTarget> newActionTargets, Map<String, String> callerRequestParameters, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        List nextActionTypes;
        String nextGovernanceActionTypeParameterName = "nextActionType.getEntityTwoProxy().getGUID()";
        if (previousGovernanceActionTypeGUID != null && (nextActionTypes = this.repositoryHandler.getRelationshipsByType(userId, previousGovernanceActionTypeGUID, "GovernanceActionType", "d9567840-9904-43a5-990b-4585c0446e00", "NextGovernanceActionType", 2, false, false, 0, 0, effectiveTime, methodName)) != null) {
            for (Relationship nextActionType : nextActionTypes) {
                boolean validNextAction;
                if (nextActionType == null) continue;
                String guard = this.repositoryHelper.getStringProperty(this.serviceName, "guard", nextActionType.getProperties(), methodName);
                boolean mandatoryGuard = this.repositoryHelper.getBooleanProperty(this.serviceName, "mandatoryGuard", nextActionType.getProperties(), methodName);
                boolean bl = validNextAction = guard == null;
                if (guard != null && outputGuards != null) {
                    for (String outputGuard : outputGuards) {
                        if (outputGuard == null || !outputGuard.equals(guard)) continue;
                        validNextAction = true;
                    }
                }
                if (!validNextAction) continue;
                this.prepareGovernanceActionFromType(userId, anchorGUID, nextActionType.getEntityTwoProxy().getGUID(), "nextActionType.getEntityTwoProxy().getGUID()", guard, mandatoryGuard, null, previousGovernanceActionGUID, callerRequestParameters, null, newActionTargets, processName, null, null, null, methodName);
            }
        }
    }

    private List<String> getMandatoryGuards(String userId, String governanceActionTypeGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getMandatoryGuards";
        List dependedOnActionTypes = this.repositoryHandler.getRelationshipsByType(userId, governanceActionTypeGUID, "GovernanceActionType", "d9567840-9904-43a5-990b-4585c0446e00", "NextGovernanceActionType", 2, false, false, 0, 0, null, "getMandatoryGuards");
        if (dependedOnActionTypes != null) {
            ArrayList<String> mandatoryGuards = new ArrayList<String>();
            for (Relationship dependedOnActionType : dependedOnActionTypes) {
                String guard;
                boolean mandatoryGuard;
                if (dependedOnActionType == null || dependedOnActionType.getEntityTwoProxy() == null || !governanceActionTypeGUID.equals(dependedOnActionType.getEntityTwoProxy().getGUID()) || !(mandatoryGuard = this.repositoryHelper.getBooleanProperty(this.serviceName, "mandatoryGuard", dependedOnActionType.getProperties(), "getMandatoryGuards")) || (guard = this.repositoryHelper.getStringProperty(this.serviceName, "guard", dependedOnActionType.getProperties(), "getMandatoryGuards")) == null) continue;
                mandatoryGuards.add(guard);
            }
            if (mandatoryGuards.isEmpty()) {
                return null;
            }
            return mandatoryGuards;
        }
        return null;
    }

    public List<B> getGovernanceActions(String userId, int startFrom, int pageSize, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        RepositoryEntitiesIterator iterator = new RepositoryEntitiesIterator(this.repositoryHandler, this.invalidParameterHandler, userId, "c976d88a-2b11-4b40-b972-c38d41bfc6be", "GovernanceAction", "qualifiedName", false, false, 0, this.invalidParameterHandler.getMaxPagingSize(), effectiveTime, methodName);
        ArrayList<B> results = new ArrayList<B>();
        int entityCount = 0;
        while (iterator.moreToReceive() && (pageSize == 0 || results.size() < pageSize)) {
            B bean;
            EntityDetail nextGovernanceAction = iterator.getNext();
            if (++entityCount <= startFrom || (bean = this.getGovernanceAction(userId, nextGovernanceAction, effectiveTime, methodName)) == null) continue;
            results.add(bean);
        }
        if (results.isEmpty()) {
            return null;
        }
        return results;
    }

    public List<B> getActiveGovernanceActions(String userId, int startFrom, int pageSize, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        RepositoryEntitiesIterator iterator = new RepositoryEntitiesIterator(this.repositoryHandler, this.invalidParameterHandler, userId, "c976d88a-2b11-4b40-b972-c38d41bfc6be", "GovernanceAction", "qualifiedName", false, false, 0, this.invalidParameterHandler.getMaxPagingSize(), effectiveTime, methodName);
        ArrayList<B> results = new ArrayList<B>();
        int entityCount = 0;
        while (iterator.moreToReceive() && (pageSize == 0 || results.size() < pageSize)) {
            B bean;
            int status;
            EntityDetail nextGovernanceAction = iterator.getNext();
            if (++entityCount <= startFrom || (status = this.repositoryHelper.getEnumPropertyOrdinal(this.serviceName, "status", nextGovernanceAction.getProperties(), methodName)) != 0 && status != 1 && status != 2 && status != 4 || (bean = this.getGovernanceAction(userId, nextGovernanceAction, effectiveTime, methodName)) == null) continue;
            results.add(bean);
        }
        if (results.isEmpty()) {
            return null;
        }
        return results;
    }

    public List<B> getActiveClaimedGovernanceActions(String userId, String governanceEngineGUID, int startFrom, int pageSize, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String guidParameterName = "governanceEngineGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(governanceEngineGUID, "governanceEngineGUID", methodName);
        InstanceProperties properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, "processingEngineUserId", userId, methodName);
        RepositorySelectedEntitiesIterator iterator = new RepositorySelectedEntitiesIterator(this.repositoryHandler, this.invalidParameterHandler, userId, "c976d88a-2b11-4b40-b972-c38d41bfc6be", properties, MatchCriteria.ANY, "qualifiedName", false, false, 0, this.invalidParameterHandler.getMaxPagingSize(), effectiveTime, methodName);
        ArrayList<B> results = new ArrayList<B>();
        int entityCount = 0;
        while (iterator.moreToReceive() && (pageSize == 0 || results.size() < pageSize)) {
            B bean;
            int status;
            EntityDetail nextGovernanceAction = iterator.getNext();
            if (++entityCount <= startFrom || (status = this.repositoryHelper.getEnumPropertyOrdinal(this.serviceName, "status", nextGovernanceAction.getProperties(), methodName)) != 2 && status != 4 || (bean = this.getGovernanceAction(userId, nextGovernanceAction, effectiveTime, methodName)) == null) continue;
            results.add(bean);
        }
        if (results.isEmpty()) {
            return null;
        }
        return results;
    }

    public List<B> findGovernanceActions(String userId, String searchString, String searchStringParameterName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateSearchString(searchString, searchStringParameterName, methodName);
        List<EntityDetail> entities = this.findEntities(userId, searchString, searchStringParameterName, "c976d88a-2b11-4b40-b972-c38d41bfc6be", "GovernanceAction", null, null, null, startFrom, pageSize, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        if (entities != null) {
            ArrayList<B> results = new ArrayList<B>();
            for (EntityDetail entityDetail : entities) {
                B bean = this.getGovernanceAction(userId, entityDetail, effectiveTime, methodName);
                if (bean == null) continue;
                results.add(bean);
            }
            if (!results.isEmpty()) {
                return results;
            }
        }
        return null;
    }

    public List<B> getGovernanceActionsByName(String userId, String name, String nameParameterName, int startFrom, int pageSize, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateName(name, nameParameterName, methodName);
        ArrayList<String> specificMatchPropertyNames = new ArrayList<String>();
        specificMatchPropertyNames.add("qualifiedName");
        specificMatchPropertyNames.add("displayName");
        specificMatchPropertyNames.add("processName");
        List<EntityDetail> entities = this.getEntitiesByValue(userId, name, nameParameterName, "c976d88a-2b11-4b40-b972-c38d41bfc6be", "GovernanceAction", specificMatchPropertyNames, true, false, null, null, false, false, this.supportedZones, null, startFrom, pageSize, effectiveTime, methodName);
        if (entities != null) {
            ArrayList<B> results = new ArrayList<B>();
            for (EntityDetail entityDetail : entities) {
                B bean = this.getGovernanceAction(userId, entityDetail, effectiveTime, methodName);
                if (bean == null) continue;
                results.add(bean);
            }
            if (!results.isEmpty()) {
                return results;
            }
        }
        return null;
    }

    public void updateActionTargetStatus(String userId, String actionTargetGUID, int status, Date startDate, Date completionDate, String completionMessage, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String guidParameterName = "actionTargetGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(actionTargetGUID, "actionTargetGUID", methodName);
        Relationship actionTarget = this.repositoryHandler.getRelationshipByGUID(userId, actionTargetGUID, "actionTargetGUID", "TargetForAction", effectiveTime, methodName);
        if (actionTarget != null) {
            InstanceProperties newActionTargetProperties;
            try {
                newActionTargetProperties = this.repositoryHelper.addEnumPropertyToInstance(this.serviceName, actionTarget.getProperties(), "status", "a6e698b0-a4f7-4a39-8c80-db0bb0f972ec", "GovernanceActionStatus", status, methodName);
            }
            catch (TypeErrorException error) {
                throw new PropertyServerException((OCFCheckedExceptionBase)error);
            }
            newActionTargetProperties = this.repositoryHelper.addDatePropertyToInstance(this.serviceName, newActionTargetProperties, "startDate", startDate, methodName);
            newActionTargetProperties = this.repositoryHelper.addDatePropertyToInstance(this.serviceName, newActionTargetProperties, "completionDate", completionDate, methodName);
            newActionTargetProperties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, newActionTargetProperties, "completionMessage", completionMessage, methodName);
            this.repositoryHandler.updateRelationshipProperties(userId, null, null, actionTarget, newActionTargetProperties, methodName);
        }
    }
}

