/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericConverter;
import org.odpi.openmetadata.commonservices.generichandlers.PersonRoleBuilder;
import org.odpi.openmetadata.commonservices.generichandlers.ReferenceableHandler;
import org.odpi.openmetadata.commonservices.generichandlers.ffdc.GenericHandlersErrorCode;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.metadatasecurity.server.OpenMetadataServerSecurityVerifier;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class PersonRoleHandler<B>
extends ReferenceableHandler<B> {
    public PersonRoleHandler(OpenMetadataAPIGenericConverter<B> converter, Class<B> beanClass, String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper, String localServerUserId, OpenMetadataServerSecurityVerifier securityVerifier, List<String> supportedZones, List<String> defaultZones, List<String> publishZones, AuditLog auditLog) {
        super(converter, beanClass, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
    }

    public String createPersonRole(String userId, String externalSourceGUID, String externalSourceName, String qualifiedName, String identifier, String name, String description, String scope, int headCount, boolean headCountLimitSet, int domainIdentifier, Map<String, String> additionalProperties, String suppliedTypeName, Map<String, Object> extendedProperties, Date effectiveFrom, Date effectiveTo, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        String typeName = "PersonRole";
        if (suppliedTypeName != null) {
            typeName = suppliedTypeName;
        }
        String typeGUID = this.invalidParameterHandler.validateTypeName(typeName, "PersonRole", this.serviceName, methodName, this.repositoryHelper);
        boolean domainIdentifierSet = this.repositoryHelper.isTypeOf(this.serviceName, typeName, "GovernanceRole");
        PersonRoleBuilder roleBuilder = new PersonRoleBuilder(qualifiedName, identifier, name, description, scope, headCount, headCountLimitSet, domainIdentifier, domainIdentifierSet, additionalProperties, typeGUID, typeName, extendedProperties, this.repositoryHelper, this.serviceName, this.serverName);
        roleBuilder.setEffectivityDates(effectiveFrom, effectiveTo);
        return this.createBeanInRepository(userId, externalSourceGUID, externalSourceName, typeGUID, typeName, roleBuilder, effectiveTime, methodName);
    }

    public String createPersonRoleFromTemplate(String userId, String externalSourceGUID, String externalSourceName, String templateGUID, String qualifiedName, String identifier, String name, String description, int headCount, boolean headCountLimitSet, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String templateGUIDParameterName = "templateGUID";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(templateGUID, "templateGUID", methodName);
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        PersonRoleBuilder roleBuilder = new PersonRoleBuilder(qualifiedName, identifier, name, description, headCount, headCountLimitSet, this.repositoryHelper, this.serviceName, this.serverName);
        return this.createBeanFromTemplate(userId, externalSourceGUID, externalSourceName, templateGUID, "templateGUID", "ac406bf8-e53e-49f1-9088-2af28bcbd285", "PersonRole", qualifiedName, "qualifiedName", roleBuilder, this.supportedZones, methodName);
    }

    public String appointPersonToRole(String userId, String externalSourceGUID, String externalSourceName, String profileGUID, String profileGUIDParameterName, String roleGUID, String roleGUIDParameterName, boolean isPublic, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        PersonRoleBuilder builder = new PersonRoleBuilder(this.repositoryHelper, this.serviceName, this.serverName);
        return this.linkElementToElement(userId, externalSourceGUID, externalSourceName, profileGUID, profileGUIDParameterName, "Person", roleGUID, roleGUIDParameterName, "PersonRole", forLineage, forDuplicateProcessing, this.supportedZones, "4a316abe-bcce-4d11-ad5a-4bfb4079b80b", "PersonRoleAppointment", builder.getAppointmentProperties(isPublic, effectiveFrom, effectiveTo, methodName), effectiveFrom, effectiveTo, effectiveTime, methodName);
    }

    public void updateAppointment(String userId, String externalSourceGUID, String externalSourceName, String appointmentGUID, String appointmentGUIDParameterName, boolean isPublic, Date effectiveFrom, Date effectiveTo, boolean isMergeUpdate, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        PersonRoleBuilder builder = new PersonRoleBuilder(this.repositoryHelper, this.serviceName, this.serverName);
        this.updateRelationshipProperties(userId, externalSourceGUID, externalSourceName, appointmentGUID, appointmentGUIDParameterName, "PersonRoleAppointment", isMergeUpdate, builder.getAppointmentProperties(isPublic, effectiveFrom, effectiveTo, methodName), forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void relievePersonFromRole(String userId, String externalSourceGUID, String externalSourceName, String profileGUID, String profileGUIDParameterName, String roleGUID, String roleGUIDParameterName, String appointmentGUID, String appointmentGUIDParameterName, Date endDate, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateGUID(appointmentGUID, appointmentGUIDParameterName, methodName);
        Relationship relationship = this.repositoryHandler.getRelationshipByGUID(userId, appointmentGUID, appointmentGUIDParameterName, "PersonRoleAppointment", effectiveTime, methodName);
        if (relationship != null && relationship.getEntityOneProxy() != null && relationship.getEntityTwoProxy() != null) {
            if (roleGUID != null && !roleGUID.equals(relationship.getEntityTwoProxy().getGUID())) {
                String relationshipTypeName = "<Unknown>";
                String proxyTypeName = "<Unknown>";
                if (relationship.getType() != null) {
                    relationshipTypeName = relationship.getType().getTypeDefName();
                }
                if (relationship.getEntityTwoProxy().getType() != null) {
                    proxyTypeName = relationship.getEntityTwoProxy().getType().getTypeDefName();
                }
                throw new InvalidParameterException(GenericHandlersErrorCode.WRONG_END_GUID.getMessageDefinition(roleGUIDParameterName, roleGUID, proxyTypeName, relationship.getEntityTwoProxy().getGUID(), Integer.toString(2), relationshipTypeName, appointmentGUIDParameterName, appointmentGUID), this.getClass().getName(), methodName, roleGUIDParameterName);
            }
            if (profileGUID != null && !profileGUID.equals(relationship.getEntityOneProxy().getGUID())) {
                String relationshipTypeName = "<Unknown>";
                String proxyTypeName = "<Unknown>";
                if (relationship.getType() != null) {
                    relationshipTypeName = relationship.getType().getTypeDefName();
                }
                if (relationship.getEntityOneProxy().getType() != null) {
                    proxyTypeName = relationship.getEntityOneProxy().getType().getTypeDefName();
                }
                throw new InvalidParameterException(GenericHandlersErrorCode.WRONG_END_GUID.getMessageDefinition(profileGUIDParameterName, profileGUID, proxyTypeName, relationship.getEntityOneProxy().getGUID(), Integer.toString(1), relationshipTypeName, appointmentGUIDParameterName, appointmentGUID), this.getClass().getName(), methodName, roleGUIDParameterName);
            }
            InstanceProperties properties = new InstanceProperties(relationship.getProperties());
            if (endDate == null) {
                properties.setEffectiveToTime(new Date());
            } else {
                properties.setEffectiveToTime(endDate);
            }
            this.repositoryHandler.updateRelationshipProperties(userId, externalSourceGUID, externalSourceName, relationship, properties, methodName);
        }
    }

    public void addTeamLeader(String userId, String externalSourceGUID, String externalSourceName, String teamLeaderRoleGUID, String teamLeaderRoleGUIDParameterName, String teamGUID, String teamGUIDParameterName, String position, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        PersonRoleBuilder builder = new PersonRoleBuilder(this.repositoryHelper, this.serviceName, this.serverName);
        InstanceProperties relationshipProperties = builder.getTeamLeadershipProperties(position, methodName);
        this.linkElementToElement(userId, externalSourceGUID, externalSourceName, teamLeaderRoleGUID, teamLeaderRoleGUIDParameterName, "PersonRole", teamGUID, teamGUIDParameterName, "Team", forLineage, forDuplicateProcessing, this.supportedZones, "5ebc4fb2-b62a-4269-8f18-e9237a2119ca", "TeamLeadership", this.setUpEffectiveDates(relationshipProperties, effectiveFrom, effectiveTo), effectiveFrom, effectiveTo, effectiveTime, methodName);
    }

    public void removeTeamLeader(String userId, String externalSourceGUID, String externalSourceName, String teamLeaderRoleGUID, String teamLeaderRoleGUIDParameterName, String teamGUID, String teamGUIDParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.unlinkElementFromElement(userId, false, externalSourceGUID, externalSourceName, teamLeaderRoleGUID, teamLeaderRoleGUIDParameterName, "PersonRole", teamGUID, teamGUIDParameterName, "36db26d5-aba2-439b-bc15-d62d373c5db6", "Team", forLineage, forDuplicateProcessing, (List<String>)this.supportedZones, "5ebc4fb2-b62a-4269-8f18-e9237a2119ca", "TeamLeadership", effectiveTime, methodName);
    }

    public void addTeamMember(String userId, String externalSourceGUID, String externalSourceName, String teamMemberRoleGUID, String teamMemberRoleGUIDParameterName, String teamGUID, String teamGUIDParameterName, String position, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        PersonRoleBuilder builder = new PersonRoleBuilder(this.repositoryHelper, this.serviceName, this.serverName);
        InstanceProperties relationshipProperties = builder.getTeamMembershipProperties(position, methodName);
        this.linkElementToElement(userId, externalSourceGUID, externalSourceName, teamMemberRoleGUID, teamMemberRoleGUIDParameterName, "PersonRole", teamGUID, teamGUIDParameterName, "Team", forLineage, forDuplicateProcessing, this.supportedZones, "1ebc4fb2-b62a-4269-8f18-e9237a2119ca", "TeamMembership", this.setUpEffectiveDates(relationshipProperties, effectiveFrom, effectiveTo), effectiveFrom, effectiveTo, effectiveTime, methodName);
    }

    public void removeTeamMember(String userId, String externalSourceGUID, String externalSourceName, String teamMemberRoleGUID, String teamMemberRoleGUIDParameterName, String teamGUID, String teamGUIDParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.unlinkElementFromElement(userId, false, externalSourceGUID, externalSourceName, teamMemberRoleGUID, teamMemberRoleGUIDParameterName, "PersonRole", teamGUID, teamGUIDParameterName, "36db26d5-aba2-439b-bc15-d62d373c5db6", "Team", forLineage, forDuplicateProcessing, (List<String>)this.supportedZones, "1ebc4fb2-b62a-4269-8f18-e9237a2119ca", "TeamMembership", effectiveTime, methodName);
    }

    public void addGovernanceResponsibility(String userId, String externalSourceGUID, String externalSourceName, String personRoleGUID, String personRoleGUIDParameterName, String governanceResponsibilityGUID, String governanceResponsibilityGUIDParameterName, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.linkElementToElement(userId, externalSourceGUID, externalSourceName, personRoleGUID, personRoleGUIDParameterName, "PersonRole", governanceResponsibilityGUID, governanceResponsibilityGUIDParameterName, "Team", forLineage, forDuplicateProcessing, this.supportedZones, "1ebc4fb2-b62a-4269-8f18-e9237a2119ca", "TeamMembership", this.setUpEffectiveDates(null, effectiveFrom, effectiveTo), effectiveFrom, effectiveTo, effectiveTime, methodName);
    }

    public void removeGovernanceResponsibility(String userId, String externalSourceGUID, String externalSourceName, String personRoleGUID, String personRoleGUIDParameterName, String governanceResponsibilityGUID, String governanceResponsibilityGUIDParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.unlinkElementFromElement(userId, false, externalSourceGUID, externalSourceName, personRoleGUID, personRoleGUIDParameterName, "PersonRole", governanceResponsibilityGUID, governanceResponsibilityGUIDParameterName, "89a76b24-deb8-45bf-9304-a578a610326f", "GovernanceResponsibility", forLineage, forDuplicateProcessing, (List<String>)this.supportedZones, "cb15c107-b7af-475d-aab0-d78b8297b982", "GovernanceResponsibilityAssignment", effectiveTime, methodName);
    }

    public List<B> getRolesWithGovernanceResponsibility(String userId, String governanceResponsibilityGUID, String governanceResponsibilityGUIDParameterName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getAttachedElements(userId, null, null, governanceResponsibilityGUID, governanceResponsibilityGUIDParameterName, "GovernanceResponsibility", "cb15c107-b7af-475d-aab0-d78b8297b982", "GovernanceResponsibilityAssignment", "PersonRole", null, null, 1, forLineage, forDuplicateProcessing, this.supportedZones, startFrom, pageSize, effectiveTime, methodName);
    }

    public void updatePersonRole(String userId, String externalSourceGUID, String externalSourceName, String roleGUID, String roleGUIDParameterName, String qualifiedName, String qualifiedNameParameterName, String identifier, String name, String nameParameterName, String description, String scope, int headCount, boolean headCountLimitSet, int domainIdentifier, Map<String, String> additionalProperties, String typeName, Map<String, Object> extendedProperties, boolean isMergeUpdate, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(roleGUID, roleGUIDParameterName, methodName);
        if (!isMergeUpdate) {
            this.invalidParameterHandler.validateName(qualifiedName, qualifiedNameParameterName, methodName);
            this.invalidParameterHandler.validateName(name, nameParameterName, methodName);
        }
        String typeGUID = this.invalidParameterHandler.validateTypeName(typeName, "PersonRole", this.serviceName, methodName, this.repositoryHelper);
        boolean domainIdentifierSet = typeName != null && !isMergeUpdate && domainIdentifier == 0 && this.repositoryHelper.isTypeOf(this.serviceName, typeName, "GovernanceRole");
        PersonRoleBuilder roleBuilder = new PersonRoleBuilder(qualifiedName, identifier, name, description, scope, headCount, headCountLimitSet, domainIdentifier, domainIdentifierSet, additionalProperties, typeGUID, typeName, extendedProperties, this.repositoryHelper, this.serviceName, this.serverName);
        roleBuilder.setEffectivityDates(effectiveFrom, effectiveTo);
        this.updateBeanInRepository(userId, externalSourceGUID, externalSourceName, roleGUID, roleGUIDParameterName, typeGUID, typeName, forLineage, forDuplicateProcessing, (List<String>)this.supportedZones, roleBuilder.getInstanceProperties(methodName), isMergeUpdate, effectiveTime, methodName);
    }

    public void removePersonRole(String userId, String externalSourceGUID, String externalSourceName, String roleGUID, String roleGUIDParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.deleteBeanInRepository(userId, externalSourceGUID, externalSourceName, roleGUID, roleGUIDParameterName, "ac406bf8-e53e-49f1-9088-2af28bcbd285", "PersonRole", null, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public List<B> findPersonRoles(String userId, String searchString, String searchStringParameterName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.findBeans(userId, searchString, searchStringParameterName, "ac406bf8-e53e-49f1-9088-2af28bcbd285", "PersonRole", null, startFrom, pageSize, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public List<B> getPersonRolesByName(String userId, String name, String nameParameterName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        ArrayList<String> specificMatchPropertyNames = new ArrayList<String>();
        specificMatchPropertyNames.add("qualifiedName");
        specificMatchPropertyNames.add("identifier");
        specificMatchPropertyNames.add("name");
        return this.getBeansByValue(userId, name, nameParameterName, "ac406bf8-e53e-49f1-9088-2af28bcbd285", "PersonRole", specificMatchPropertyNames, true, null, null, forLineage, forDuplicateProcessing, this.supportedZones, null, startFrom, pageSize, effectiveTime, methodName);
    }

    public List<B> getProjectManagerRoles(String userId, String projectGUID, String projectGUIDParameterName, int startingFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getAttachedElements(userId, null, null, projectGUID, projectGUIDParameterName, "Project", "ac63ac45-a4d0-4fba-b583-92859de77dd8", "ProjectManagement", "PersonRole", null, null, 2, forLineage, forDuplicateProcessing, this.supportedZones, startingFrom, pageSize, effectiveTime, methodName);
    }

    public List<B> getTeamLeaderRoles(String userId, String teamGUID, String teamGUIDParameterName, int startingFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getAttachedElements(userId, null, null, teamGUID, teamGUIDParameterName, "Team", "5ebc4fb2-b62a-4269-8f18-e9237a2119ca", "TeamLeadership", "PersonRole", null, null, 1, forLineage, forDuplicateProcessing, this.supportedZones, startingFrom, pageSize, effectiveTime, methodName);
    }

    public List<B> getTeamMemberRoles(String userId, String teamGUID, String teamGUIDParameterName, int startingFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getAttachedElements(userId, null, null, teamGUID, teamGUIDParameterName, "Team", "1ebc4fb2-b62a-4269-8f18-e9237a2119ca", "TeamMembership", "PersonRole", null, null, 1, forLineage, forDuplicateProcessing, this.supportedZones, startingFrom, pageSize, effectiveTime, methodName);
    }

    public List<B> getCommunityRoles(String userId, String communityGUID, String communityGUIDParameterName, int startingFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getAttachedElements(userId, null, null, communityGUID, communityGUIDParameterName, "Community", "CommunityMembership", "CommunityMembership", "PersonRole", null, null, 2, forLineage, forDuplicateProcessing, this.supportedZones, startingFrom, pageSize, effectiveTime, methodName);
    }

    public B getPersonRoleByGUID(String userId, String personRoleGUID, String personRoleGUIDParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.getBeanFromRepository(userId, personRoleGUID, personRoleGUIDParameterName, "Person", forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public List<B> getPersonRolesForRoleId(String userId, String name, String nameParameterName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        ArrayList<String> specificMatchPropertyNames = new ArrayList<String>();
        specificMatchPropertyNames.add("qualifiedName");
        return this.getBeansByValue(userId, name, nameParameterName, "ac406bf8-e53e-49f1-9088-2af28bcbd285", "PersonRole", specificMatchPropertyNames, true, null, null, forLineage, forDuplicateProcessing, this.supportedZones, null, startFrom, pageSize, effectiveTime, methodName);
    }

    public List<B> getPersonRolesForTitle(String userId, String name, String nameParameterName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        ArrayList<String> specificMatchPropertyNames = new ArrayList<String>();
        specificMatchPropertyNames.add("name");
        return this.getBeansByValue(userId, name, nameParameterName, "ac406bf8-e53e-49f1-9088-2af28bcbd285", "PersonRole", specificMatchPropertyNames, true, null, null, forLineage, forDuplicateProcessing, this.supportedZones, null, startFrom, pageSize, effectiveTime, methodName);
    }

    public List<B> getPersonRolesForDomainId(String userId, int domainIdentifier, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        if (domainIdentifier == 0) {
            return this.getBeansByType(userId, "ac406bf8-e53e-49f1-9088-2af28bcbd285", "PersonRole", null, forLineage, forDuplicateProcessing, this.supportedZones, startFrom, pageSize, effectiveTime, methodName);
        }
        return this.getBeansByIntValue(userId, domainIdentifier, "ac406bf8-e53e-49f1-9088-2af28bcbd285", "PersonRole", "domainIdentifier", null, null, forLineage, forDuplicateProcessing, this.supportedZones, null, startFrom, pageSize, effectiveTime, methodName);
    }
}

