/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericConverter;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericHandler;
import org.odpi.openmetadata.commonservices.generichandlers.PropertyFacetBuilder;
import org.odpi.openmetadata.commonservices.generichandlers.ReferenceableBuilder;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.metadatasecurity.server.OpenMetadataServerSecurityVerifier;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntitySummary;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.ClassificationErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeErrorException;

public class ReferenceableHandler<B>
extends OpenMetadataAPIGenericHandler<B> {
    public ReferenceableHandler(OpenMetadataAPIGenericConverter<B> converter, Class<B> beanClass, String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper, String localServerUserId, OpenMetadataServerSecurityVerifier securityVerifier, List<String> supportedZones, List<String> defaultZones, List<String> publishZones, AuditLog auditLog) {
        super(converter, beanClass, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
    }

    public String getBeanGUIDByQualifiedName(String userId, String typeGUID, String typeName, String name, String nameParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getBeanGUIDByQualifiedName(userId, typeGUID, typeName, name, nameParameterName, forLineage, forDuplicateProcessing, this.supportedZones, effectiveTime, methodName);
    }

    public String getBeanGUIDByQualifiedName(String userId, String typeGUID, String typeName, String name, String nameParameterName, boolean forLineage, boolean forDuplicateProcessing, List<String> serviceSupportedZones, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String resultTypeGUID = "a32316b8-dc8c-48c5-b12b-71c1b2a080bf";
        String resultTypeName = "Referenceable";
        if (typeGUID != null) {
            resultTypeGUID = typeGUID;
        }
        if (typeName != null) {
            resultTypeName = typeName;
        }
        return this.getBeanGUIDByUniqueName(userId, name, nameParameterName, "qualifiedName", resultTypeGUID, resultTypeName, forLineage, forDuplicateProcessing, serviceSupportedZones, effectiveTime, methodName);
    }

    public B getBeanByQualifiedName(String userId, String typeGUID, String typeName, String name, String nameParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getBeanByQualifiedName(userId, typeGUID, typeName, name, nameParameterName, forLineage, forDuplicateProcessing, this.supportedZones, effectiveTime, methodName);
    }

    public B getBeanByQualifiedName(String userId, String typeGUID, String typeName, String name, String nameParameterName, boolean forLineage, boolean forDuplicateProcessing, List<String> serviceSupportedZones, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String resultTypeGUID = "a32316b8-dc8c-48c5-b12b-71c1b2a080bf";
        String resultTypeName = "Referenceable";
        if (typeGUID != null) {
            resultTypeGUID = typeGUID;
        }
        if (typeName != null) {
            resultTypeName = typeName;
        }
        return this.getBeanByUniqueName(userId, name, nameParameterName, "qualifiedName", resultTypeGUID, resultTypeName, forLineage, forDuplicateProcessing, serviceSupportedZones, effectiveTime, methodName);
    }

    public List<String> getBeanGUIDsByQualifiedName(String userId, String typeGUID, String typeName, String name, String nameParameterName, boolean forLineage, boolean forDuplicateProcessing, int startFrom, int pageSize, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getBeanGUIDsByQualifiedName(userId, typeGUID, typeName, name, nameParameterName, forLineage, forDuplicateProcessing, this.supportedZones, startFrom, pageSize, effectiveTime, methodName);
    }

    public List<String> getBeanGUIDsByQualifiedName(String userId, String typeGUID, String typeName, String name, String nameParameterName, boolean forLineage, boolean forDuplicateProcessing, List<String> serviceSupportedZones, int startFrom, int pageSize, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String resultTypeGUID = "a32316b8-dc8c-48c5-b12b-71c1b2a080bf";
        String resultTypeName = "Referenceable";
        if (typeGUID != null) {
            resultTypeGUID = typeGUID;
        }
        if (typeName != null) {
            resultTypeName = typeName;
        }
        ArrayList<String> specificMatchPropertyNames = new ArrayList<String>();
        specificMatchPropertyNames.add("qualifiedName");
        return this.getEntityGUIDsByValue(userId, name, nameParameterName, resultTypeGUID, resultTypeName, specificMatchPropertyNames, true, null, null, forLineage, forDuplicateProcessing, serviceSupportedZones, null, startFrom, pageSize, effectiveTime, methodName);
    }

    public List<B> getBeansByQualifiedName(String userId, String typeGUID, String typeName, String name, String nameParameterName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getBeansByQualifiedName(userId, typeGUID, typeName, name, nameParameterName, this.supportedZones, startFrom, pageSize, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public List<B> getBeansByQualifiedName(String userId, String typeGUID, String typeName, String name, String nameParameterName, List<String> serviceSupportedZones, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String resultTypeGUID = "a32316b8-dc8c-48c5-b12b-71c1b2a080bf";
        String resultTypeName = "Referenceable";
        if (typeGUID != null) {
            resultTypeGUID = typeGUID;
        }
        if (typeName != null) {
            resultTypeName = typeName;
        }
        ArrayList<String> specificMatchPropertyNames = new ArrayList<String>();
        specificMatchPropertyNames.add("qualifiedName");
        return this.getBeansByValue(userId, name, nameParameterName, resultTypeGUID, resultTypeName, specificMatchPropertyNames, true, null, null, forLineage, forDuplicateProcessing, serviceSupportedZones, null, startFrom, pageSize, effectiveTime, methodName);
    }

    public EntityDetail getEntityByUniqueQualifiedName(String userId, String typeGUID, String typeName, String name, String nameParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String resultTypeGUID = "a32316b8-dc8c-48c5-b12b-71c1b2a080bf";
        String resultTypeName = "Referenceable";
        if (typeGUID != null) {
            resultTypeGUID = typeGUID;
        }
        if (typeName != null) {
            resultTypeName = typeName;
        }
        ArrayList<String> specificMatchPropertyNames = new ArrayList<String>();
        specificMatchPropertyNames.add("qualifiedName");
        List<EntityDetail> matchingEntities = this.getEntitiesByValue(userId, name, nameParameterName, resultTypeGUID, resultTypeName, specificMatchPropertyNames, true, false, null, null, forLineage, forDuplicateProcessing, this.supportedZones, null, 0, 0, effectiveTime, methodName);
        if (matchingEntities == null) {
            return null;
        }
        if (matchingEntities.size() == 1) {
            return matchingEntities.get(0);
        }
        this.errorHandler.handleAmbiguousEntityName(name, nameParameterName, resultTypeName, matchingEntities, methodName);
        return null;
    }

    public List<String> findBeanGUIDsByQualifiedName(String userId, String typeGUID, String typeName, String name, String nameParameterName, boolean forLineage, boolean forDuplicateProcessing, List<String> serviceSupportedZones, int startFrom, int pageSize, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String resultTypeGUID = "896d14c2-7522-4f6c-8519-757711943fe6";
        String resultTypeName = "Asset";
        if (typeGUID != null) {
            resultTypeGUID = typeGUID;
        }
        if (typeName != null) {
            resultTypeName = typeName;
        }
        ArrayList<String> specificMatchPropertyNames = new ArrayList<String>();
        specificMatchPropertyNames.add("qualifiedName");
        return this.getEntityGUIDsByValue(userId, name, nameParameterName, resultTypeGUID, resultTypeName, specificMatchPropertyNames, false, null, null, forLineage, forDuplicateProcessing, serviceSupportedZones, null, startFrom, pageSize, effectiveTime, methodName);
    }

    public List<B> findBeansByQualifiedName(String userId, String typeGUID, String typeName, String name, String nameParameterName, boolean forLineage, boolean forDuplicateProcessing, int startFrom, int pageSize, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.findBeansByQualifiedName(userId, typeGUID, typeName, name, nameParameterName, forLineage, forDuplicateProcessing, this.supportedZones, startFrom, pageSize, effectiveTime, methodName);
    }

    public List<B> findBeansByQualifiedName(String userId, String typeGUID, String typeName, String name, String nameParameterName, boolean forLineage, boolean forDuplicateProcessing, List<String> serviceSupportedZones, int startFrom, int pageSize, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String resultTypeGUID = "a32316b8-dc8c-48c5-b12b-71c1b2a080bf";
        String resultTypeName = "Referenceable";
        if (typeGUID != null) {
            resultTypeGUID = typeGUID;
        }
        if (typeName != null) {
            resultTypeName = typeName;
        }
        ArrayList<String> specificMatchPropertyNames = new ArrayList<String>();
        specificMatchPropertyNames.add("qualifiedName");
        return this.getBeansByValue(userId, name, nameParameterName, resultTypeGUID, resultTypeName, specificMatchPropertyNames, false, null, null, forLineage, forDuplicateProcessing, serviceSupportedZones, null, startFrom, pageSize, effectiveTime, methodName);
    }

    public void addOwner(String userId, String beanGUID, String beanGUIDParameterName, String beanGUIDTypeName, String owner, String ownerTypeName, String ownerPropertyName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        ReferenceableBuilder builder = new ReferenceableBuilder("a32316b8-dc8c-48c5-b12b-71c1b2a080bf", "Referenceable", this.repositoryHelper, this.serviceName, this.serverName);
        this.setClassificationInRepository(userId, null, null, beanGUID, beanGUIDParameterName, beanGUIDTypeName, "8139a911-a4bd-432b-a9f4-f6d11c511abe", "Ownership", builder.getOwnershipProperties(owner, ownerTypeName, ownerPropertyName, methodName), true, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void removeOwner(String userId, String beanGUID, String beanGUIDParameterName, String beanGUIDTypeName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.removeClassificationFromRepository(userId, null, null, beanGUID, beanGUIDParameterName, beanGUIDTypeName, "8139a911-a4bd-432b-a9f4-f6d11c511abe", "Ownership", forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void addSecurityTags(String userId, String beanGUID, String beanGUIDParameterName, String beanGUIDTypeName, List<String> securityLabels, Map<String, Object> securityProperties, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        ReferenceableBuilder builder = new ReferenceableBuilder("a32316b8-dc8c-48c5-b12b-71c1b2a080bf", "Referenceable", this.repositoryHelper, this.serviceName, this.serverName);
        this.setClassificationInRepository(userId, null, null, beanGUID, beanGUIDParameterName, beanGUIDTypeName, "a0b07a86-9fd3-40ca-bb9b-fe83c6981deb", "SecurityTags", builder.getSecurityTagProperties(securityLabels, securityProperties, methodName), true, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void removeSecurityTags(String userId, String beanGUID, String beanGUIDParameterName, String beanGUIDTypeName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.removeClassificationFromRepository(userId, null, null, beanGUID, beanGUIDParameterName, beanGUIDTypeName, "a0b07a86-9fd3-40ca-bb9b-fe83c6981deb", "SecurityTags", forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void addGovernanceExpectationsClassification(String userId, String externalSourceGUID, String externalSourceName, String beanGUID, String beanGUIDParameterName, String beanGUIDTypeName, Map<String, Integer> counts, Map<String, String> values, Map<String, Boolean> flags, boolean forLineage, boolean forDuplicateProcessing, Date effectiveFrom, Date effectiveTo, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        InstanceProperties properties = this.repositoryHelper.addIntMapPropertyToInstance(this.serviceName, null, "counts", counts, methodName);
        properties = this.repositoryHelper.addStringMapPropertyToInstance(this.serviceName, properties, "values", values, methodName);
        properties = this.repositoryHelper.addBooleanMapPropertyToInstance(this.serviceName, properties, "flags", flags, methodName);
        this.setClassificationInRepository(userId, externalSourceGUID, externalSourceName, beanGUID, beanGUIDParameterName, beanGUIDTypeName, "fcda7261-865d-464d-b279-7d9880aaab39", "GovernanceExpectations", this.setUpEffectiveDates(properties, effectiveFrom, effectiveTo), true, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void removeGovernanceExpectationsClassification(String userId, String externalSourceGUID, String externalSourceName, String beanGUID, String beanGUIDParameterName, String beanGUIDTypeName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.removeClassificationFromRepository(userId, externalSourceGUID, externalSourceName, beanGUID, beanGUIDParameterName, beanGUIDTypeName, "fcda7261-865d-464d-b279-7d9880aaab39", "GovernanceExpectations", forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void addGovernanceMeasurementsClassification(String userId, String externalSourceGUID, String externalSourceName, String beanGUID, String beanGUIDParameterName, String beanGUIDTypeName, Map<String, Integer> counts, Map<String, String> values, Map<String, Boolean> flags, boolean forLineage, boolean forDuplicateProcessing, Date effectiveFrom, Date effectiveTo, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        InstanceProperties properties = this.repositoryHelper.addIntMapPropertyToInstance(this.serviceName, null, "measurementCounts", counts, methodName);
        properties = this.repositoryHelper.addStringMapPropertyToInstance(this.serviceName, properties, "measurementValues", values, methodName);
        properties = this.repositoryHelper.addBooleanMapPropertyToInstance(this.serviceName, properties, "measurementFlags", flags, methodName);
        this.setClassificationInRepository(userId, externalSourceGUID, externalSourceName, beanGUID, beanGUIDParameterName, beanGUIDTypeName, "9d99d962-0214-49ba-83f7-c9b1f9f5bed4", "GovernanceMeasurements", this.setUpEffectiveDates(properties, effectiveFrom, effectiveTo), true, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void removeGovernanceMeasurementsClassification(String userId, String externalSourceGUID, String externalSourceName, String beanGUID, String beanGUIDParameterName, String beanGUIDTypeName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.removeClassificationFromRepository(userId, externalSourceGUID, externalSourceName, beanGUID, beanGUIDParameterName, beanGUIDTypeName, "9d99d962-0214-49ba-83f7-c9b1f9f5bed4", "GovernanceMeasurements", forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void addSubjectAreaClassification(String userId, String externalSourceGUID, String externalSourceName, String beanGUID, String beanGUIDParameterName, String beanGUIDTypeName, String subjectAreaName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveFrom, Date effectiveTo, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        InstanceProperties properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, "name", subjectAreaName, methodName);
        this.setClassificationInRepository(userId, externalSourceGUID, externalSourceName, beanGUID, beanGUIDParameterName, beanGUIDTypeName, "480e6993-35c5-433a-b50b-0f5c4063fb5d", "SubjectArea", this.setUpEffectiveDates(properties, effectiveFrom, effectiveTo), true, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void removeSubjectAreaClassification(String userId, String externalSourceGUID, String externalSourceName, String beanGUID, String beanGUIDParameterName, String beanGUIDTypeName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.removeClassificationFromRepository(userId, externalSourceGUID, externalSourceName, beanGUID, beanGUIDParameterName, beanGUIDTypeName, "480e6993-35c5-433a-b50b-0f5c4063fb5d", "SubjectArea", forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public List<B> getSubjectAreaMembers(String userId, String subjectAreaName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getSubjectAreaMembers(userId, subjectAreaName, this.supportedZones, startFrom, pageSize, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public List<B> getSubjectAreaMembers(String userId, String subjectAreaName, List<String> serviceSupportedZones, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String guidParameterName = "subjectAreaEntity.getGUID";
        String nameParameterName = "subjectAreaName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateName(subjectAreaName, "subjectAreaName", methodName);
        int queryPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, methodName);
        List entities = this.repositoryHandler.getEntitiesForClassificationType(userId, "a32316b8-dc8c-48c5-b12b-71c1b2a080bf", "SubjectArea", forLineage, forDuplicateProcessing, startFrom, queryPageSize, effectiveTime, methodName);
        if (entities != null) {
            ArrayList beans = new ArrayList();
            for (EntityDetail entity : entities) {
                if (entity == null) continue;
                try {
                    this.validateAnchorEntity(userId, entity.getGUID(), "Referenceable", entity, "subjectAreaEntity.getGUID", false, forLineage, forDuplicateProcessing, serviceSupportedZones, effectiveTime, methodName);
                    Classification classification = this.repositoryHelper.getClassificationFromEntity(this.serviceName, (EntitySummary)entity, "SubjectArea", methodName);
                    if (classification == null) continue;
                    String name = this.repositoryHelper.getStringProperty(this.serviceName, "name", classification.getProperties(), methodName);
                    if (subjectAreaName != null && !subjectAreaName.equals(name)) continue;
                    beans.add(this.converter.getNewBean(this.beanClass, entity, methodName));
                }
                catch (Exception exception) {}
            }
            if (!beans.isEmpty()) {
                return beans;
            }
        }
        return null;
    }

    public void setBusinessSignificant(String userId, String beanGUID, String beanGUIDParameterName, String beanGUIDTypeName, String description, String scope, String businessCapabilityGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        ReferenceableBuilder builder = new ReferenceableBuilder("a32316b8-dc8c-48c5-b12b-71c1b2a080bf", "Referenceable", this.repositoryHelper, this.serviceName, this.serverName);
        this.setClassificationInRepository(userId, null, null, beanGUID, beanGUIDParameterName, beanGUIDTypeName, "085febdd-f129-4f4b-99aa-01f3e6294e9f", "BusinessSignificance", builder.getBusinessSignificanceProperties(description, scope, businessCapabilityGUID, methodName), true, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void clearBusinessSignificant(String userId, String beanGUID, String beanGUIDParameterName, String beanGUIDTypeName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.removeClassificationFromRepository(userId, null, null, beanGUID, beanGUIDParameterName, beanGUIDTypeName, "085febdd-f129-4f4b-99aa-01f3e6294e9f", "BusinessSignificance", forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void addTemplateClassification(String userId, String beanGUID, String beanGUIDParameterName, String beanGUIDTypeName, String name, String description, Map<String, String> additionalProperties, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        ReferenceableBuilder builder = new ReferenceableBuilder("a32316b8-dc8c-48c5-b12b-71c1b2a080bf", "Referenceable", this.repositoryHelper, this.serviceName, this.serverName);
        this.setClassificationInRepository(userId, null, null, beanGUID, beanGUIDParameterName, beanGUIDTypeName, "25fad4a2-c2d6-440d-a5b1-e537881f84ee", "Template", builder.getTemplateProperties(name, description, additionalProperties, methodName), true, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void removeTemplateClassification(String userId, String beanGUID, String beanGUIDParameterName, String beanGUIDTypeName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.removeClassificationFromRepository(userId, null, null, beanGUID, beanGUIDParameterName, beanGUIDTypeName, "25fad4a2-c2d6-440d-a5b1-e537881f84ee", "Template", forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public List<B> getValidValueConsumers(String userId, String validValueGUID, String validValueGUIDParameter, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.getAttachedElements(userId, validValueGUID, validValueGUIDParameter, "Referenceable", "c5d48b73-eadd-47db-ab64-3be99b2fb32d", "ValidValuesAssignment", "ValidValueDefinition", null, null, 1, forLineage, forDuplicateProcessing, startFrom, pageSize, effectiveTime, methodName);
    }

    public List<B> getReferenceValueAssignees(String userId, String validValueGUID, String validValueGUIDParameter, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.getAttachedElements(userId, validValueGUID, validValueGUIDParameter, "Referenceable", "111e6d2e-94e9-43ed-b4ed-f0d220668cbf", "ReferenceValueAssignment", "ValidValueDefinition", null, null, 1, forLineage, forDuplicateProcessing, startFrom, pageSize, effectiveTime, methodName);
    }

    public void addMoreInformation(String userId, String externalSourceGUID, String externalSourceName, String elementGUID, String elementGUIDParameterName, String moreInformationGUID, String moreInformationGUIDParameterName, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.linkElementToElement(userId, externalSourceGUID, externalSourceName, elementGUID, elementGUIDParameterName, "Referenceable", moreInformationGUID, moreInformationGUIDParameterName, "Referenceable", forLineage, forDuplicateProcessing, this.supportedZones, "28f63c94-aaef-4c84-98f7-d77aa605272e", "ImplementedBy", this.setUpEffectiveDates(null, effectiveFrom, effectiveTo), effectiveFrom, effectiveTo, effectiveTime, methodName);
    }

    public void removeMoreInformation(String userId, String externalSourceGUID, String externalSourceName, String elementGUID, String elementGUIDParameterName, String moreInformationGUID, String moreInformationGUIDParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.unlinkElementFromElement(userId, false, externalSourceGUID, externalSourceName, elementGUID, elementGUIDParameterName, "Referenceable", moreInformationGUID, moreInformationGUIDParameterName, "a32316b8-dc8c-48c5-b12b-71c1b2a080bf", "Referenceable", forLineage, forDuplicateProcessing, "1cbf059e-2c11-4e0c-8aae-1da42c1ee73f", "MoreInformation", effectiveTime, methodName);
    }

    public List<B> getMoreInformation(String userId, String startingGUID, String startingGUIDParameterName, String suppliedStartingTypeName, String suppliedResultingTypeName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getMoreInformation(userId, startingGUID, startingGUIDParameterName, suppliedStartingTypeName, suppliedResultingTypeName, this.supportedZones, startFrom, pageSize, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public List<B> getMoreInformation(String userId, String startingGUID, String startingGUIDParameterName, String suppliedStartingTypeName, String suppliedResultingTypeName, List<String> serviceSupportedZones, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String startingTypeName = "Referenceable";
        String resultingTypeName = "Referenceable";
        if (suppliedStartingTypeName != null) {
            startingTypeName = suppliedStartingTypeName;
        }
        if (suppliedResultingTypeName != null) {
            resultingTypeName = suppliedResultingTypeName;
        }
        return this.getAttachedElements(userId, null, null, startingGUID, startingGUIDParameterName, startingTypeName, "1cbf059e-2c11-4e0c-8aae-1da42c1ee73f", "MoreInformation", resultingTypeName, null, null, 2, forLineage, forDuplicateProcessing, serviceSupportedZones, startFrom, pageSize, effectiveTime, methodName);
    }

    public List<B> getDescriptiveElements(String userId, String startingGUID, String startingGUIDParameterName, String suppliedStartingTypeName, String suppliedResultingTypeName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String startingTypeName = "Referenceable";
        String resultingTypeName = "Referenceable";
        if (suppliedStartingTypeName != null) {
            startingTypeName = suppliedStartingTypeName;
        }
        if (suppliedResultingTypeName != null) {
            resultingTypeName = suppliedResultingTypeName;
        }
        return this.getAttachedElements(userId, null, null, startingGUID, startingGUIDParameterName, startingTypeName, "1cbf059e-2c11-4e0c-8aae-1da42c1ee73f", "MoreInformation", resultingTypeName, null, null, 1, forLineage, forDuplicateProcessing, this.supportedZones, startFrom, pageSize, effectiveTime, methodName);
    }

    public void saveSemanticAssignments(String userId, String externalSourceGUID, String externalSourceName, String beanGUID, String beanGUIDParameter, List<String> glossaryTermGUIDs, String glossaryTermGUIDsParameter, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        if (glossaryTermGUIDs != null) {
            for (String glossaryTermGUID : glossaryTermGUIDs) {
                if (glossaryTermGUID == null) continue;
                this.saveSemanticAssignment(userId, externalSourceGUID, externalSourceName, beanGUID, beanGUIDParameter, glossaryTermGUID, glossaryTermGUIDsParameter, effectiveFrom, effectiveTo, forLineage, forDuplicateProcessing, effectiveTime, methodName);
            }
        }
    }

    public void saveSemanticAssignment(String userId, String externalSourceGUID, String externalSourceName, String beanGUID, String beanGUIDParameter, String glossaryTermGUID, String glossaryTermGUIDParameter, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.linkElementToElement(userId, externalSourceGUID, externalSourceName, beanGUID, beanGUIDParameter, "Referenceable", glossaryTermGUID, glossaryTermGUIDParameter, "GlossaryTerm", forLineage, forDuplicateProcessing, this.supportedZones, "e6670973-645f-441a-bec7-6f5570345b92", "SemanticAssignment", this.setUpEffectiveDates(null, effectiveFrom, effectiveTo), effectiveFrom, effectiveTo, effectiveTime, methodName);
    }

    public void saveSemanticAssignment(String userId, String externalSourceGUID, String externalSourceName, String beanGUID, String beanGUIDParameter, String glossaryTermGUID, String glossaryTermGUIDParameter, String description, String expression, int statusOrdinal, int confidence, String createdBy, String steward, String source, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        InstanceProperties properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, "description", description, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "expression", expression, methodName);
        try {
            properties = this.repositoryHelper.addEnumPropertyToInstance(this.serviceName, properties, "status", "c8fe36ac-369f-4799-af75-46b9c1343ab3", "TermAssignmentStatus", statusOrdinal, methodName);
        }
        catch (TypeErrorException error) {
            this.errorHandler.handleUnsupportedType((Exception)((Object)error), methodName, "TermAssignmentStatus");
        }
        properties = this.repositoryHelper.addIntPropertyToInstance(this.serviceName, properties, "confidence", confidence, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "createdBy", createdBy, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "steward", steward, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "source", source, methodName);
        this.linkElementToElement(userId, externalSourceGUID, externalSourceName, beanGUID, beanGUIDParameter, "Referenceable", glossaryTermGUID, glossaryTermGUIDParameter, "GlossaryTerm", forLineage, forDuplicateProcessing, this.supportedZones, "e6670973-645f-441a-bec7-6f5570345b92", "SemanticAssignment", this.setUpEffectiveDates(properties, effectiveFrom, effectiveTo), effectiveFrom, effectiveTo, effectiveTime, methodName);
    }

    public void removeSemanticAssignment(String userId, String externalSourceGUID, String externalSourceName, String beanGUID, String beanGUIDParameter, String glossaryTermGUID, String glossaryTermGUIDParameter, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.unlinkElementFromElement(userId, false, externalSourceGUID, externalSourceName, beanGUID, beanGUIDParameter, "Referenceable", glossaryTermGUID, glossaryTermGUIDParameter, "0db3e6ec-f5ef-4d75-ae38-b7ee6fd6ec0a", "GlossaryTerm", forLineage, forDuplicateProcessing, (List<String>)this.supportedZones, "e6670973-645f-441a-bec7-6f5570345b92", "SemanticAssignment", effectiveTime, methodName);
    }

    public List<B> getMeanings(String userId, String startingGUID, String startingGUIDParameterName, String suppliedStartingTypeName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String startingTypeName = "Referenceable";
        String resultingTypeName = "GlossaryTerm";
        if (suppliedStartingTypeName != null) {
            startingTypeName = suppliedStartingTypeName;
        }
        return this.getAttachedElements(userId, null, null, startingGUID, startingGUIDParameterName, startingTypeName, "e6670973-645f-441a-bec7-6f5570345b92", "SemanticAssignment", resultingTypeName, null, null, 2, forLineage, forDuplicateProcessing, this.supportedZones, startFrom, pageSize, effectiveTime, methodName);
    }

    public List<B> getSemanticAssignments(String userId, String startingGUID, String startingGUIDParameterName, String suppliedResultingTypeName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String startingTypeName = "GlossaryTerm";
        String resultingTypeName = "Referenceable";
        if (suppliedResultingTypeName != null) {
            resultingTypeName = suppliedResultingTypeName;
        }
        return this.getAttachedElements(userId, null, null, startingGUID, startingGUIDParameterName, startingTypeName, "e6670973-645f-441a-bec7-6f5570345b92", "SemanticAssignment", resultingTypeName, null, null, 1, forLineage, forDuplicateProcessing, this.supportedZones, startFrom, pageSize, effectiveTime, methodName);
    }

    public void saveResourceListMember(String userId, String externalSourceGUID, String externalSourceName, String beanGUID, String beanGUIDParameter, String memberGUID, String memberGUIDParameter, String resourceUse, boolean watchResource, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        InstanceProperties properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, "resourceUse", resourceUse, methodName);
        properties = this.repositoryHelper.addBooleanPropertyToInstance(this.serviceName, properties, "watchResource", watchResource, methodName);
        this.linkElementToElement(userId, externalSourceGUID, externalSourceName, beanGUID, beanGUIDParameter, "Referenceable", memberGUID, memberGUIDParameter, "Referenceable", forLineage, forDuplicateProcessing, this.supportedZones, "73cf5658-6a73-4ebc-8f4d-44fdfac0b437", "ResourceList", this.setUpEffectiveDates(properties, effectiveFrom, effectiveTo), effectiveFrom, effectiveTo, effectiveTime, methodName);
    }

    public void removeResourceListMember(String userId, String externalSourceGUID, String externalSourceName, String beanGUID, String beanGUIDParameter, String memberGUID, String memberGUIDParameter, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        if (beanGUID != null) {
            this.unlinkElementFromElement(userId, false, externalSourceGUID, externalSourceName, beanGUID, beanGUIDParameter, "Referenceable", memberGUID, memberGUIDParameter, "a32316b8-dc8c-48c5-b12b-71c1b2a080bf", "Referenceable", forLineage, forDuplicateProcessing, (List<String>)this.supportedZones, "73cf5658-6a73-4ebc-8f4d-44fdfac0b437", "ResourceList", effectiveTime, methodName);
        }
    }

    public List<B> getResourceList(String userId, String startingGUID, String startingGUIDParameterName, String suppliedStartingTypeName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String startingTypeName = "Referenceable";
        String resultingTypeName = "Referenceable";
        if (suppliedStartingTypeName != null) {
            startingTypeName = suppliedStartingTypeName;
        }
        return this.getAttachedElements(userId, null, null, startingGUID, startingGUIDParameterName, startingTypeName, "73cf5658-6a73-4ebc-8f4d-44fdfac0b437", "ResourceList", resultingTypeName, null, null, 2, forLineage, forDuplicateProcessing, this.supportedZones, startFrom, pageSize, effectiveTime, methodName);
    }

    public List<B> getSupportedByResource(String userId, String startingGUID, String startingGUIDParameterName, String suppliedStartingTypeName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String startingTypeName = "Referenceable";
        String resultingTypeName = "Referenceable";
        if (suppliedStartingTypeName != null) {
            startingTypeName = suppliedStartingTypeName;
        }
        return this.getAttachedElements(userId, null, null, startingGUID, startingGUIDParameterName, startingTypeName, "73cf5658-6a73-4ebc-8f4d-44fdfac0b437", "ResourceList", resultingTypeName, null, null, 1, forLineage, forDuplicateProcessing, this.supportedZones, startFrom, pageSize, effectiveTime, methodName);
    }

    public void addAssignmentScope(String userId, String externalSourceGUID, String externalSourceName, String assignedActorGUID, String assignedActorGUIDParameterName, String assignedScopeGUID, String assignedScopeGUIDParameterName, String assignmentType, String description, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        InstanceProperties properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, "assignmentType", assignmentType, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "description", description, methodName);
        this.linkElementToElement(userId, externalSourceGUID, externalSourceName, assignedActorGUID, assignedActorGUIDParameterName, "Referenceable", assignedScopeGUID, assignedScopeGUIDParameterName, "Referenceable", forLineage, forDuplicateProcessing, this.supportedZones, "e3fdafe3-692a-46c6-a595-c538cc189dd9", "AssignmentScope", this.setUpEffectiveDates(properties, effectiveFrom, effectiveTo), effectiveFrom, effectiveTo, effectiveTime, methodName);
    }

    public void removeAssignmentScope(String userId, String externalSourceGUID, String externalSourceName, String assignedActorGUID, String assignedActorGUIDParameterName, String assignedScopeGUID, String assignedScopeGUIDParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.unlinkElementFromElement(userId, false, externalSourceGUID, externalSourceName, assignedActorGUID, assignedActorGUIDParameterName, "Referenceable", assignedScopeGUID, assignedScopeGUIDParameterName, "a32316b8-dc8c-48c5-b12b-71c1b2a080bf", "Referenceable", forLineage, forDuplicateProcessing, "e3fdafe3-692a-46c6-a595-c538cc189dd9", "AssignmentScope", effectiveTime, methodName);
    }

    public List<B> getAssignmentScope(String userId, String startingGUID, String startingGUIDParameterName, String suppliedStartingTypeName, String suppliedResultingTypeName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String startingTypeName = "Referenceable";
        String resultingTypeName = "Referenceable";
        if (suppliedStartingTypeName != null) {
            startingTypeName = suppliedStartingTypeName;
        }
        if (suppliedResultingTypeName != null) {
            resultingTypeName = suppliedResultingTypeName;
        }
        return this.getAttachedElements(userId, null, null, startingGUID, startingGUIDParameterName, startingTypeName, "e3fdafe3-692a-46c6-a595-c538cc189dd9", "AssignmentScope", resultingTypeName, null, null, 2, forLineage, forDuplicateProcessing, this.supportedZones, startFrom, pageSize, effectiveTime, methodName);
    }

    public List<B> getAssignedActors(String userId, String startingGUID, String startingGUIDParameterName, String suppliedStartingTypeName, String suppliedResultingTypeName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String startingTypeName = "Referenceable";
        String resultingTypeName = "Referenceable";
        if (suppliedStartingTypeName != null) {
            startingTypeName = suppliedStartingTypeName;
        }
        if (suppliedResultingTypeName != null) {
            resultingTypeName = suppliedResultingTypeName;
        }
        return this.getAttachedElements(userId, null, null, startingGUID, startingGUIDParameterName, startingTypeName, "e3fdafe3-692a-46c6-a595-c538cc189dd9", "AssignmentScope", resultingTypeName, null, null, 1, forLineage, forDuplicateProcessing, this.supportedZones, startFrom, pageSize, effectiveTime, methodName);
    }

    public void addStakeholder(String userId, String externalSourceGUID, String externalSourceName, String commissionedGUID, String commissionedGUIDParameterName, String stakeholderGUID, String stakeholderGUIDParameterName, String stakeholderRole, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        InstanceProperties properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, "stakeholderRole", stakeholderRole, methodName);
        this.linkElementToElement(userId, externalSourceGUID, externalSourceName, commissionedGUID, commissionedGUIDParameterName, "Referenceable", stakeholderGUID, stakeholderGUIDParameterName, "Referenceable", forLineage, forDuplicateProcessing, this.supportedZones, "efd8a136-0aea-4668-b91a-30f947e38b82", "Stakeholder", this.setUpEffectiveDates(properties, effectiveFrom, effectiveTo), effectiveFrom, effectiveTo, effectiveTime, methodName);
    }

    public void removeStakeholder(String userId, String externalSourceGUID, String externalSourceName, String commissionedGUID, String commissionedGUIDParameterName, String stakeholderGUID, String stakeholderGUIDParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.unlinkElementFromElement(userId, false, externalSourceGUID, externalSourceName, commissionedGUID, commissionedGUIDParameterName, "Referenceable", stakeholderGUID, stakeholderGUIDParameterName, "a32316b8-dc8c-48c5-b12b-71c1b2a080bf", "Referenceable", forLineage, forDuplicateProcessing, "efd8a136-0aea-4668-b91a-30f947e38b82", "Stakeholder", effectiveTime, methodName);
    }

    public List<B> getStakeholders(String userId, String startingGUID, String startingGUIDParameterName, String suppliedStartingTypeName, String suppliedResultingTypeName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String startingTypeName = "Referenceable";
        String resultingTypeName = "Referenceable";
        if (suppliedStartingTypeName != null) {
            startingTypeName = suppliedStartingTypeName;
        }
        if (suppliedResultingTypeName != null) {
            resultingTypeName = suppliedResultingTypeName;
        }
        return this.getAttachedElements(userId, null, null, startingGUID, startingGUIDParameterName, startingTypeName, "efd8a136-0aea-4668-b91a-30f947e38b82", "Stakeholder", resultingTypeName, null, null, 2, forLineage, forDuplicateProcessing, this.supportedZones, startFrom, pageSize, effectiveTime, methodName);
    }

    public List<B> getCommissionedByStakeholder(String userId, String startingGUID, String startingGUIDParameterName, String suppliedStartingTypeName, String suppliedResultingTypeName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String startingTypeName = "Referenceable";
        String resultingTypeName = "Referenceable";
        if (suppliedStartingTypeName != null) {
            startingTypeName = suppliedStartingTypeName;
        }
        if (suppliedResultingTypeName != null) {
            resultingTypeName = suppliedResultingTypeName;
        }
        return this.getAttachedElements(userId, null, null, startingGUID, startingGUIDParameterName, startingTypeName, "efd8a136-0aea-4668-b91a-30f947e38b82", "Stakeholder", resultingTypeName, null, null, 1, forLineage, forDuplicateProcessing, this.supportedZones, startFrom, pageSize, effectiveTime, methodName);
    }

    public void addGovernedBy(String userId, String externalSourceGUID, String externalSourceName, String governanceDefinitionGUID, String governanceDefinitionGUIDParameterName, String referenceableGUID, String referenceableGUIDParameterName, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.linkElementToElement(userId, externalSourceGUID, externalSourceName, governanceDefinitionGUID, governanceDefinitionGUIDParameterName, "GovernanceDefinition", referenceableGUID, referenceableGUIDParameterName, "Referenceable", forLineage, forDuplicateProcessing, this.supportedZones, "89c3c695-9e8d-4660-9f44-ed971fd55f89", "GovernedBy", this.setUpEffectiveDates(null, effectiveFrom, effectiveTo), effectiveFrom, effectiveTo, effectiveTime, methodName);
    }

    public void removeGovernedBy(String userId, String externalSourceGUID, String externalSourceName, String governanceDefinitionGUID, String governanceDefinitionGUIDParameterName, String referenceableGUID, String referenceableGUIDParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.unlinkElementFromElement(userId, false, externalSourceGUID, externalSourceName, governanceDefinitionGUID, governanceDefinitionGUIDParameterName, "GovernanceDefinition", referenceableGUID, referenceableGUIDParameterName, "a32316b8-dc8c-48c5-b12b-71c1b2a080bf", "Referenceable", forLineage, forDuplicateProcessing, "89c3c695-9e8d-4660-9f44-ed971fd55f89", "GovernedBy", effectiveTime, methodName);
    }

    public List<B> getGovernedElements(String userId, String governanceDefinitionGUID, String governanceDefinitionGUIDParameterName, String suppliedResultingTypeName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String resultingTypeName = "Referenceable";
        if (suppliedResultingTypeName != null) {
            resultingTypeName = suppliedResultingTypeName;
        }
        return this.getAttachedElements(userId, null, null, governanceDefinitionGUID, governanceDefinitionGUIDParameterName, "GovernanceDefinition", "89c3c695-9e8d-4660-9f44-ed971fd55f89", "GovernedBy", resultingTypeName, null, null, 2, forLineage, forDuplicateProcessing, this.supportedZones, startFrom, pageSize, effectiveTime, methodName);
    }

    public void addGovernanceDefinitionScope(String userId, String externalSourceGUID, String externalSourceName, String governanceDefinitionGUID, String governanceDefinitionGUIDParameterName, String referenceableGUID, String referenceableGUIDParameterName, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.linkElementToElement(userId, externalSourceGUID, externalSourceName, referenceableGUID, referenceableGUIDParameterName, "Referenceable", governanceDefinitionGUID, governanceDefinitionGUIDParameterName, "GovernanceDefinition", forLineage, forDuplicateProcessing, this.supportedZones, "3845b5cc-8c85-462f-b7e6-47472a568793", "GovernanceDefinitionScope", this.setUpEffectiveDates(null, effectiveFrom, effectiveTo), effectiveFrom, effectiveTo, effectiveTime, methodName);
    }

    public void removeGovernanceDefinitionScope(String userId, String externalSourceGUID, String externalSourceName, String governanceDefinitionGUID, String governanceDefinitionGUIDParameterName, String referenceableGUID, String referenceableGUIDParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.unlinkElementFromElement(userId, false, externalSourceGUID, externalSourceName, referenceableGUID, referenceableGUIDParameterName, "a32316b8-dc8c-48c5-b12b-71c1b2a080bf", governanceDefinitionGUID, governanceDefinitionGUIDParameterName, "578a3500-9ad3-45fe-8ada-e4e9572c37c8", "GovernanceDefinition", forLineage, forDuplicateProcessing, "3845b5cc-8c85-462f-b7e6-47472a568793", "GovernanceDefinitionScope", effectiveTime, methodName);
    }

    public List<B> getGovernanceDefinitionScope(String userId, String governanceDefinitionGUID, String governanceDefinitionGUIDParameterName, String suppliedResultingTypeName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String resultingTypeName = "Referenceable";
        if (suppliedResultingTypeName != null) {
            resultingTypeName = suppliedResultingTypeName;
        }
        return this.getAttachedElements(userId, null, null, governanceDefinitionGUID, governanceDefinitionGUIDParameterName, "GovernanceDefinition", "3845b5cc-8c85-462f-b7e6-47472a568793", "GovernanceDefinitionScope", resultingTypeName, null, null, 1, forLineage, forDuplicateProcessing, this.supportedZones, startFrom, pageSize, effectiveTime, methodName);
    }

    public void addImplementedBy(String userId, String externalSourceGUID, String externalSourceName, String designArtifactGUID, String designArtifactGUIDParameterName, String implementationGUID, String implementationGUIDParameterName, String designStep, String role, String description, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        InstanceProperties properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, "designStep", designStep, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "role", role, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "description", description, methodName);
        this.linkElementToElement(userId, externalSourceGUID, externalSourceName, designArtifactGUID, designArtifactGUIDParameterName, "Referenceable", implementationGUID, implementationGUIDParameterName, "Referenceable", forLineage, forDuplicateProcessing, this.supportedZones, "28f63c94-aaef-4c84-98f7-d77aa605272e", "ImplementedBy", this.setUpEffectiveDates(properties, effectiveFrom, effectiveTo), effectiveFrom, effectiveTo, effectiveTime, methodName);
    }

    public void removeImplementedBy(String userId, String externalSourceGUID, String externalSourceName, String designArtifactGUID, String designArtifactGUIDParameterName, String implementationGUID, String implementationGUIDParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.unlinkElementFromElement(userId, false, externalSourceGUID, externalSourceName, designArtifactGUID, designArtifactGUIDParameterName, "Referenceable", implementationGUID, implementationGUIDParameterName, "a32316b8-dc8c-48c5-b12b-71c1b2a080bf", "Referenceable", forLineage, forDuplicateProcessing, "28f63c94-aaef-4c84-98f7-d77aa605272e", "ImplementedBy", effectiveTime, methodName);
    }

    public List<B> getCollectionMembers(String userId, String collectionGUID, String collectionGUIDParameterName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.getAttachedElements(userId, collectionGUID, collectionGUIDParameterName, "Collection", "5cabb76a-e25b-4bb5-8b93-768bbac005af", "CollectionMembership", "Referenceable", null, null, 0, forLineage, forDuplicateProcessing, startFrom, pageSize, effectiveTime, methodName);
    }

    private void setKnowDuplicateClassification(String userId, EntityDetail entity, String guidParameterName, List<String> serviceSupportedZones, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        boolean classificationNeeded = true;
        try {
            if (this.repositoryHelper.getClassificationFromEntity(this.serviceName, (EntitySummary)entity, "KnownDuplicate", methodName) != null) {
                classificationNeeded = false;
            }
        }
        catch (ClassificationErrorException classificationErrorException) {
            // empty catch block
        }
        if (classificationNeeded) {
            this.setClassificationInRepository(userId, null, null, entity, guidParameterName, "Referenceable", "e55062b2-907f-44bd-9831-255642285731", "KnownDuplicate", null, true, false, true, serviceSupportedZones, new Date(), methodName);
        }
    }

    private InstanceProperties createStewardshipProperties(int statusIdentifier, String steward, String stewardTypeName, String stewardPropertyName, String source, String notes, String methodName) {
        InstanceProperties properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, "steward", steward, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "stewardTypeName", stewardTypeName, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "stewardPropertyName", stewardPropertyName, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "source", source, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "notes", notes, methodName);
        properties = this.repositoryHelper.addIntPropertyToInstance(this.serviceName, properties, "statusIdentifier", statusIdentifier, methodName);
        return properties;
    }

    public void linkElementsAsPeerDuplicates(String userId, String element1GUID, String element1GUIDParameter, String element2GUID, String element2GUIDParameter, boolean setKnownDuplicate, int statusIdentifier, String steward, String stewardTypeName, String stewardPropertyName, String source, String notes, List<String> serviceSupportedZones, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(element1GUID, element1GUIDParameter, methodName);
        this.invalidParameterHandler.validateGUID(element2GUID, element2GUIDParameter, methodName);
        EntityDetail entity1 = this.getEntityFromRepository(userId, element1GUID, element1GUIDParameter, "Referenceable", null, null, false, true, serviceSupportedZones, null, methodName);
        EntityDetail entity2 = this.getEntityFromRepository(userId, element2GUID, element2GUIDParameter, "Referenceable", null, null, false, true, serviceSupportedZones, null, methodName);
        if (setKnownDuplicate) {
            this.setKnowDuplicateClassification(userId, entity1, element1GUIDParameter, serviceSupportedZones, methodName);
            this.setKnowDuplicateClassification(userId, entity2, element2GUIDParameter, serviceSupportedZones, methodName);
        }
        InstanceProperties properties = this.createStewardshipProperties(statusIdentifier, steward, stewardTypeName, stewardPropertyName, source, notes, methodName);
        this.linkElementToElement(userId, null, null, element1GUID, element1GUIDParameter, "Referenceable", element2GUID, element2GUIDParameter, "Referenceable", false, true, serviceSupportedZones, "a94b2929-9e62-4b12-98ab-8ac45691e5bd", "PeerDuplicateLink", properties, null, null, null, methodName);
    }

    public void unlinkElementsAsPeerDuplicates(String userId, String element1GUID, String element1GUIDParameter, String element2GUID, String element2GUIDParameter, List<String> serviceSupportedZones, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(element1GUID, element1GUIDParameter, methodName);
        this.invalidParameterHandler.validateGUID(element2GUID, element2GUIDParameter, methodName);
        this.repositoryHandler.removeRelationshipBetweenEntities(userId, null, null, "a94b2929-9e62-4b12-98ab-8ac45691e5bd", "PeerDuplicateLink", element1GUID, "Referenceable", element2GUID, true, true, null, methodName);
        if (this.getAttachmentLinks(userId, element1GUID, element1GUIDParameter, "Referenceable", "a94b2929-9e62-4b12-98ab-8ac45691e5bd", "PeerDuplicateLink", null, null, 0, true, true, serviceSupportedZones, 0, this.invalidParameterHandler.getMaxPagingSize(), null, methodName) == null) {
            this.removeClassificationFromRepository(userId, null, null, element1GUID, element1GUIDParameter, "Referenceable", "e55062b2-907f-44bd-9831-255642285731", "KnownDuplicate", true, true, serviceSupportedZones, null, methodName);
        }
        if (this.getAttachmentLinks(userId, element2GUID, element2GUIDParameter, "Referenceable", "a94b2929-9e62-4b12-98ab-8ac45691e5bd", "PeerDuplicateLink", null, null, 0, false, true, serviceSupportedZones, 0, this.invalidParameterHandler.getMaxPagingSize(), null, methodName) == null) {
            this.removeClassificationFromRepository(userId, null, null, element2GUID, element2GUIDParameter, "Referenceable", "e55062b2-907f-44bd-9831-255642285731", "KnownDuplicate", false, true, serviceSupportedZones, null, methodName);
        }
    }

    private void setConsolidatedDuplicateClassification(String userId, EntityDetail entity, String guidParameterName, int statusIdentifier, String steward, String stewardTypeName, String stewardPropertyName, String source, String notes, List<String> serviceSupportedZones, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        InstanceProperties properties = this.createStewardshipProperties(statusIdentifier, steward, stewardTypeName, stewardPropertyName, source, notes, methodName);
        this.setClassificationInRepository(userId, null, null, entity, guidParameterName, "Referenceable", "e40e80d7-5a29-482c-9a88-0dc7251f08de", "ConsolidatedDuplicate", properties, false, false, true, serviceSupportedZones, null, methodName);
    }

    public void linkConsolidatedDuplicate(String userId, String consolidatedElementGUID, String consolidatedElementGUIDParameter, int statusIdentifier, String steward, String stewardTypeName, String stewardPropertyName, String source, String notes, List<String> sourceElementGUIDs, String sourceElementGUIDsParameterName, List<String> serviceSupportedZones, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(consolidatedElementGUID, consolidatedElementGUIDParameter, methodName);
        EntityDetail consolidatedEntity = this.getEntityFromRepository(userId, consolidatedElementGUID, consolidatedElementGUIDParameter, "Referenceable", null, null, false, true, serviceSupportedZones, null, methodName);
        if (consolidatedEntity != null) {
            this.setConsolidatedDuplicateClassification(userId, consolidatedEntity, consolidatedElementGUIDParameter, statusIdentifier, steward, stewardTypeName, stewardPropertyName, source, notes, serviceSupportedZones, methodName);
            if (sourceElementGUIDs != null) {
                for (String sourceElementGUID : sourceElementGUIDs) {
                    if (sourceElementGUID == null) continue;
                    this.linkElementToElement(userId, null, null, sourceElementGUID, sourceElementGUIDsParameterName, "Referenceable", consolidatedElementGUID, consolidatedElementGUIDParameter, "Referenceable", false, true, serviceSupportedZones, "a1fabffd-d6ec-4b2d-bfe4-646f27c07c82", "ConsolidatedDuplicateLink", null, null, null, null, methodName);
                }
            }
        }
    }

    public void setVendorProperties(String userId, String referenceableGUID, Map<String, String> vendorProperties, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        block5: {
            List<EntityDetail> propertyFacets;
            block4: {
                String referenceableGUIDParameter = "referenceableGUID";
                String propertyFacetGUIDParameter = "propertyFacet[x]";
                this.invalidParameterHandler.validateUserId(userId, methodName);
                this.invalidParameterHandler.validateGUID(referenceableGUID, "referenceableGUID", methodName);
                propertyFacets = this.getAttachedEntities(userId, referenceableGUID, "referenceableGUID", "Referenceable", "58c87647-ada9-4c90-a3c3-a40ace46b1f7", "ReferenceableFacet", "PropertyFacet", null, null, 2, forLineage, forDuplicateProcessing, (List<String>)this.supportedZones, 0, this.invalidParameterHandler.getMaxPagingSize(), effectiveTime, methodName);
                if (vendorProperties == null) break block4;
                PropertyFacetBuilder builder = new PropertyFacetBuilder(referenceableGUID + "_vendorProperties", null, "vendorProperties", vendorProperties, this.repositoryHelper, this.serviceName, this.serverName);
                if (propertyFacets != null) {
                    for (EntityDetail propertyFacet : propertyFacets) {
                        String description;
                        if (propertyFacet == null || !"vendorProperties".equals(description = this.repositoryHelper.getStringProperty(this.serviceName, "description", propertyFacet.getProperties(), methodName))) continue;
                        this.updateBeanInRepository(userId, null, null, propertyFacet.getGUID(), "propertyFacet[x]", "6403a704-aad6-41c2-8e08-b9525c006f85", "PropertyFacet", forLineage, forDuplicateProcessing, (List<String>)this.supportedZones, builder.getInstanceProperties(methodName), true, effectiveTime, methodName);
                    }
                } else {
                    builder.setAnchors(userId, referenceableGUID, methodName);
                    String propertyFacetGUID = this.createBeanInRepository(userId, null, null, "6403a704-aad6-41c2-8e08-b9525c006f85", "PropertyFacet", builder, effectiveTime, methodName);
                    InstanceProperties relationshipProperties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, "source", this.serviceName, methodName);
                    this.linkElementToElement(userId, null, null, referenceableGUID, "referenceableGUID", "Referenceable", propertyFacetGUID, "propertyFacet[x]", "PropertyFacet", forLineage, forDuplicateProcessing, this.supportedZones, "58c87647-ada9-4c90-a3c3-a40ace46b1f7", "ReferenceableFacet", relationshipProperties, null, null, effectiveTime, methodName);
                }
                break block5;
            }
            if (propertyFacets == null) break block5;
            for (EntityDetail propertyFacet : propertyFacets) {
                String description;
                if (propertyFacet == null || !"vendorProperties".equals(description = this.repositoryHelper.getStringProperty(this.serviceName, "description", propertyFacet.getProperties(), methodName))) continue;
                this.deleteBeanInRepository(userId, null, null, propertyFacet.getGUID(), "propertyFacet[x]", "6403a704-aad6-41c2-8e08-b9525c006f85", "PropertyFacet", null, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
            }
        }
    }

    public Map<String, String> getVendorProperties(String userId, String referenceableGUID, String referenceableGUIDParameter, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        List<EntityDetail> propertyFacets = this.getAttachedEntities(userId, referenceableGUID, referenceableGUIDParameter, "Referenceable", "58c87647-ada9-4c90-a3c3-a40ace46b1f7", "ReferenceableFacet", "PropertyFacet", null, null, 0, forLineage, forDuplicateProcessing, (List<String>)this.supportedZones, 0, this.invalidParameterHandler.getMaxPagingSize(), effectiveTime, methodName);
        if (propertyFacets != null) {
            for (EntityDetail propertyFacet : propertyFacets) {
                String description;
                if (propertyFacet == null || !"vendorProperties".equals(description = this.repositoryHelper.getStringProperty(this.serviceName, "description", propertyFacet.getProperties(), methodName))) continue;
                return this.repositoryHelper.getStringMapFromProperty(this.serviceName, "properties", propertyFacet.getProperties(), methodName);
            }
        }
        return null;
    }
}

