/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.commonservices.generichandlers.ReferenceableBuilder;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class SchemaTypeBuilder
extends ReferenceableBuilder {
    private String displayName = null;
    private String description = null;
    private boolean isDeprecated = false;
    private String versionNumber = null;
    private String author = null;
    private String usage = null;
    private String encodingStandard = null;
    private String namespace = null;
    private String dataType = null;
    private String defaultValue = null;
    private String fixedValue = null;
    private String externalSchemaTypeGUID = null;
    private String validValuesSetGUID = null;
    private SchemaTypeBuilder mapFrom = null;
    private SchemaTypeBuilder mapTo = null;
    private String mapFromGUID = null;
    private String mapToGUID = null;
    private List<SchemaTypeBuilder> schemaOptions = null;
    private String formula = null;

    public SchemaTypeBuilder(String qualifiedName, String displayName, OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(qualifiedName, repositoryHelper, serviceName, serverName);
        this.displayName = displayName;
    }

    public SchemaTypeBuilder(String qualifiedName, String typeId, String typeName, OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(qualifiedName, typeId, typeName, repositoryHelper, serviceName, serverName);
    }

    public SchemaTypeBuilder(String qualifiedName, String displayName, String description, String versionNumber, boolean isDeprecated, String author, String usage, String encodingStandard, String namespace, Map<String, String> additionalProperties, String typeId, String typeName, Map<String, Object> extendedProperties, OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(qualifiedName, additionalProperties, typeId, typeName, extendedProperties, repositoryHelper, serviceName, serverName);
        this.displayName = displayName;
        this.description = description;
        this.versionNumber = versionNumber;
        this.isDeprecated = isDeprecated;
        this.author = author;
        this.usage = usage;
        this.encodingStandard = encodingStandard;
        this.namespace = namespace;
    }

    public SchemaTypeBuilder(String qualifiedName, String displayName, String description, String versionNumber, boolean isDeprecated, String author, String usage, String encodingStandard, String namespace, String formula, Map<String, String> additionalProperties, String typeId, String typeName, Map<String, Object> extendedProperties, OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        this(qualifiedName, displayName, description, versionNumber, isDeprecated, author, usage, encodingStandard, namespace, additionalProperties, typeId, typeName, extendedProperties, repositoryHelper, serviceName, serverName);
        this.setDerivedProperties(formula);
    }

    public void setDataType(String dataType) {
        this.dataType = dataType;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public void setFixedValue(String fixedValue) {
        this.fixedValue = fixedValue;
    }

    public void setExternalSchemaTypeGUID(String guid) {
        this.externalSchemaTypeGUID = guid;
    }

    public String getExternalSchemaTypeGUID() {
        return this.externalSchemaTypeGUID;
    }

    public void setValidValuesSetGUID(String validValuesSetGUID) {
        this.validValuesSetGUID = validValuesSetGUID;
    }

    public String getValidValuesSetGUID() {
        return this.validValuesSetGUID;
    }

    public void setMapTypes(SchemaTypeBuilder mapFrom, SchemaTypeBuilder mapTo) {
        this.mapFrom = mapFrom;
        this.mapTo = mapTo;
    }

    public void setMapGUIDs(String mapFromGUID, String mapToGUID) {
        this.mapFromGUID = mapFromGUID;
        this.mapToGUID = mapToGUID;
    }

    public SchemaTypeBuilder getMapFrom() {
        return this.mapFrom;
    }

    public SchemaTypeBuilder getMapTo() {
        return this.mapTo;
    }

    public String getMapFromGUID() {
        return this.mapFromGUID;
    }

    public String getMapToGUID() {
        return this.mapToGUID;
    }

    public void setSchemaOptions(List<SchemaTypeBuilder> schemaOptions) {
        this.schemaOptions = schemaOptions;
    }

    public List<SchemaTypeBuilder> getSchemaOptions() {
        return this.schemaOptions;
    }

    public void setDerivedProperties(String formula) {
        this.formula = formula;
    }

    public boolean isDerived() {
        return this.formula != null;
    }

    public InstanceProperties getCalculatedValueProperties(String methodName) {
        InstanceProperties properties = null;
        if (this.formula != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, "formula", this.formula, methodName);
        }
        return properties;
    }

    List<SchemaTypeBuilder> getSchemaTypeBuilders() {
        ArrayList<SchemaTypeBuilder> builders = new ArrayList<SchemaTypeBuilder>();
        builders.add(this);
        if (this.mapFrom != null) {
            builders.add(this.mapFrom);
        }
        if (this.mapTo != null) {
            builders.add(this.mapTo);
        }
        if (this.schemaOptions != null && !this.schemaOptions.isEmpty()) {
            builders.addAll(this.schemaOptions);
        }
        return builders;
    }

    @Override
    public InstanceProperties getInstanceProperties(String methodName) throws InvalidParameterException {
        InstanceProperties properties = super.getInstanceProperties(methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "displayName", this.displayName, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "description", this.description, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "versionNumber", this.versionNumber, methodName);
        properties = this.repositoryHelper.addBooleanPropertyToInstance(this.serviceName, properties, "isDeprecated", this.isDeprecated, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "author", this.author, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "usage", this.usage, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "encodingStandard", this.encodingStandard, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "namespace", this.namespace, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "dataType", this.dataType, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "defaultValue", this.defaultValue, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "fixedValue", this.fixedValue, methodName);
        return properties;
    }

    public InstanceProperties getTypeEmbeddedInstanceProperties(String methodName) throws InvalidParameterException {
        InstanceProperties properties = this.getInstanceProperties(methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "schemaTypeName", this.typeName, methodName);
        return properties;
    }
}

