/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericConverter;
import org.odpi.openmetadata.commonservices.generichandlers.ReferenceableHandler;
import org.odpi.openmetadata.commonservices.generichandlers.ValidValuesBuilder;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.metadatasecurity.server.OpenMetadataServerSecurityVerifier;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class ValidValuesHandler<B>
extends ReferenceableHandler<B> {
    public ValidValuesHandler(OpenMetadataAPIGenericConverter<B> converter, Class<B> beanClass, String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper, String localServerUserId, OpenMetadataServerSecurityVerifier securityVerifier, List<String> supportedZones, List<String> defaultZones, List<String> publishZones, AuditLog auditLog) {
        super(converter, beanClass, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
    }

    public String createValidValue(String userId, String externalSourceGUID, String externalSourceName, String qualifiedName, String displayName, String description, String usage, String scope, boolean isDeprecated, String preferredValue, Map<String, String> additionalProperties, String suppliedTypeName, Map<String, Object> extendedProperties, Date effectiveFrom, Date effectiveTo, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String nameParameter = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        return this.createValidValue(userId, externalSourceGUID, externalSourceName, null, null, suppliedTypeName, false, qualifiedName, displayName, description, usage, scope, preferredValue, isDeprecated, additionalProperties, extendedProperties, effectiveFrom, effectiveTo, false, false, effectiveTime, methodName);
    }

    public String createValidValueSet(String userId, String externalSourceGUID, String externalSourceName, String qualifiedName, String displayName, String description, String usage, String scope, boolean isDeprecated, Map<String, String> additionalProperties, Map<String, Object> extendedProperties, Date effectiveFrom, Date effectiveTo, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.createValidValue(userId, externalSourceGUID, externalSourceName, null, null, "ValidValuesSet", false, qualifiedName, displayName, description, usage, scope, null, isDeprecated, additionalProperties, extendedProperties, effectiveFrom, effectiveTo, false, false, effectiveTime, methodName);
    }

    public String createValidValueDefinition(String userId, String externalSourceGUID, String externalSourceName, String setGUID, boolean isDefaultValue, String qualifiedName, String displayName, String description, String usage, String scope, String preferredValue, boolean isDeprecated, Map<String, String> additionalProperties, Map<String, Object> extendedProperties, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.createValidValue(userId, externalSourceGUID, externalSourceName, null, setGUID, "ValidValueDefinition", isDefaultValue, qualifiedName, displayName, description, usage, scope, preferredValue, isDeprecated, additionalProperties, extendedProperties, effectiveFrom, effectiveTo, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public String createValidValue(String userId, String externalSourceGUID, String externalSourceName, String anchorGUID, String setGUID, String suppliedTypeName, boolean isDefaultValue, String qualifiedName, String displayName, String description, String usage, String scope, String preferredValue, boolean isDeprecated, Map<String, String> additionalProperties, Map<String, Object> extendedProperties, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String definitionGUID;
        String nameParameter = "qualifiedName";
        String setParameter = "setGUID";
        String definitionParameter = "definitionGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        String typeName = "ValidValuesSet";
        if (suppliedTypeName != null) {
            typeName = suppliedTypeName;
        }
        String typeGUID = this.invalidParameterHandler.validateTypeName(typeName, "ValidValueDefinition", this.serviceName, methodName, this.repositoryHelper);
        ValidValuesBuilder builder = new ValidValuesBuilder(qualifiedName, displayName, description, usage, scope, preferredValue, isDeprecated, additionalProperties, extendedProperties, this.repositoryHelper, this.serviceName, this.serverName);
        builder.setEffectivityDates(effectiveFrom, effectiveTo);
        if (anchorGUID != null) {
            builder.setAnchors(userId, anchorGUID, methodName);
        }
        if ((definitionGUID = this.createBeanInRepository(userId, externalSourceGUID, externalSourceName, typeGUID, typeName, builder, effectiveTime, methodName)) != null && setGUID != null) {
            InstanceProperties relationshipProperties = this.repositoryHelper.addBooleanPropertyToInstance(this.serviceName, null, "isDefaultValue", isDefaultValue, methodName);
            this.uncheckedLinkElementToElement(userId, externalSourceGUID, externalSourceName, setGUID, "setGUID", "ValidValuesSet", definitionGUID, "definitionGUID", typeName, forLineage, forDuplicateProcessing, this.supportedZones, "6337c9cd-8e5a-461b-97f9-5151bcb97a9e", "ValidValueMember", relationshipProperties, effectiveTime, methodName);
        }
        return definitionGUID;
    }

    public void updateValidValue(String userId, String externalSourceGUID, String externalSourceName, String validValueGUID, String qualifiedName, String displayName, String description, String usage, String scope, boolean isDeprecated, String preferredValue, Map<String, String> additionalProperties, Map<String, Object> extendedProperties, Date effectiveFrom, Date effectiveTo, boolean isMergeUpdate, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String guidParameter = "validValueGUID";
        String nameParameter = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(validValueGUID, "validValueGUID", methodName);
        if (!isMergeUpdate) {
            this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        }
        ValidValuesBuilder builder = new ValidValuesBuilder(qualifiedName, displayName, description, usage, scope, preferredValue, isDeprecated, additionalProperties, extendedProperties, this.repositoryHelper, this.serviceName, this.serverName);
        builder.setEffectivityDates(effectiveFrom, effectiveTo);
        this.updateBeanInRepository(userId, externalSourceGUID, externalSourceName, validValueGUID, "validValueGUID", "09b2133a-f045-42cc-bb00-ee602b74c618", "ValidValueDefinition", forLineage, forDuplicateProcessing, (List<String>)this.supportedZones, builder.getInstanceProperties(methodName), isMergeUpdate, effectiveTime, methodName);
    }

    public void deleteValidValue(String userId, String externalSourceGUID, String externalSourceName, String validValueGUID, String qualifiedName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String guidParameter = "validValueGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(validValueGUID, "validValueGUID", methodName);
        this.deleteBeanInRepository(userId, externalSourceGUID, externalSourceName, validValueGUID, "validValueGUID", "09b2133a-f045-42cc-bb00-ee602b74c618", "ValidValueDefinition", "qualifiedName", qualifiedName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void attachValidValueToSet(String userId, String externalSourceGUID, String externalSourceName, String setGUID, String validValueGUID, boolean isDefaultValue, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String setGUIDParameter = "setGUID";
        String validValueGUIDParameter = "validValueGUID";
        InstanceProperties properties = this.repositoryHelper.addBooleanPropertyToInstance(this.serviceName, null, "isDefaultValue", isDefaultValue, methodName);
        this.linkElementToElement(userId, externalSourceGUID, externalSourceName, setGUID, "setGUID", "ValidValuesSet", validValueGUID, "validValueGUID", "ValidValueDefinition", forLineage, forDuplicateProcessing, this.supportedZones, "6337c9cd-8e5a-461b-97f9-5151bcb97a9e", "ValidValueMember", this.setUpEffectiveDates(properties, effectiveFrom, effectiveTo), effectiveFrom, effectiveTo, effectiveTime, methodName);
    }

    public void detachValidValueFromSet(String userId, String externalSourceGUID, String externalSourceName, String setGUID, String validValueGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String setGUIDParameter = "setGUID";
        String validValueGUIDParameter = "validValueGUID";
        this.unlinkElementFromElement(userId, false, externalSourceGUID, externalSourceName, setGUID, "setGUID", "ValidValuesSet", validValueGUID, "validValueGUID", "09b2133a-f045-42cc-bb00-ee602b74c618", "ValidValueDefinition", forLineage, forDuplicateProcessing, "6337c9cd-8e5a-461b-97f9-5151bcb97a9e", "ValidValueMember", effectiveTime, methodName);
    }

    public void assignValidValueToConsumer(String userId, String externalSourceGUID, String externalSourceName, String validValueGUID, String consumerGUID, boolean strictRequirement, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String validValueGUIDParameter = "validValueGUID";
        String consumerGUIDParameter = "consumerGUID";
        InstanceProperties relationshipProperties = this.repositoryHelper.addBooleanPropertyToInstance(this.serviceName, null, "strictRequirement", strictRequirement, methodName);
        this.linkElementToElement(userId, externalSourceGUID, externalSourceName, consumerGUID, "consumerGUID", "Referenceable", validValueGUID, "validValueGUID", "ValidValueDefinition", forLineage, forDuplicateProcessing, this.supportedZones, "c5d48b73-eadd-47db-ab64-3be99b2fb32d", "ValidValuesAssignment", this.setUpEffectiveDates(relationshipProperties, effectiveFrom, effectiveTo), effectiveFrom, effectiveTo, effectiveTime, methodName);
    }

    public void unassignValidValueFromConsumer(String userId, String externalSourceGUID, String externalSourceName, String validValueGUID, String consumerGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String validValueGUIDParameter = "validValueGUID";
        String consumerGUIDParameter = "consumerGUID";
        this.unlinkElementFromElement(userId, false, externalSourceGUID, externalSourceName, consumerGUID, "consumerGUID", "Referenceable", validValueGUID, "validValueGUID", "09b2133a-f045-42cc-bb00-ee602b74c618", "ValidValueDefinition", forLineage, forDuplicateProcessing, "c5d48b73-eadd-47db-ab64-3be99b2fb32d", "ValidValuesAssignment", effectiveTime, methodName);
    }

    public void assignReferenceValueToItem(String userId, String externalSourceGUID, String externalSourceName, String validValueGUID, String referenceableGUID, String attributeName, int confidence, String steward, String stewardTypeName, String stewardPropertyName, String notes, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String validValueGUIDParameter = "validValueGUID";
        String referenceableGUIDParameter = "referenceableGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(validValueGUID, "validValueGUID", methodName);
        this.invalidParameterHandler.validateGUID(referenceableGUID, "referenceableGUID", methodName);
        InstanceProperties relationshipProperties = this.repositoryHelper.addIntPropertyToInstance(this.serviceName, null, "confidence", confidence, methodName);
        relationshipProperties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, relationshipProperties, "attributeName", attributeName, methodName);
        relationshipProperties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, relationshipProperties, "steward", steward, methodName);
        relationshipProperties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, relationshipProperties, "stewardTypeName", stewardTypeName, methodName);
        relationshipProperties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, relationshipProperties, "stewardPropertyName", stewardPropertyName, methodName);
        relationshipProperties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, relationshipProperties, "notes", notes, methodName);
        this.linkElementToElement(userId, externalSourceGUID, externalSourceName, referenceableGUID, "referenceableGUID", "Referenceable", validValueGUID, "validValueGUID", "ValidValueDefinition", forLineage, forDuplicateProcessing, this.supportedZones, "111e6d2e-94e9-43ed-b4ed-f0d220668cbf", "ReferenceValueAssignment", this.setUpEffectiveDates(relationshipProperties, effectiveFrom, effectiveTo), effectiveFrom, effectiveTo, effectiveTime, methodName);
    }

    public void unassignReferenceValueFromItem(String userId, String externalSourceGUID, String externalSourceName, String validValueGUID, String referenceableGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String validValueGUIDParameter = "validValueGUID";
        String referenceableGUIDParameter = "referenceableGUID";
        this.unlinkElementFromElement(userId, false, externalSourceGUID, externalSourceName, referenceableGUID, "referenceableGUID", "Referenceable", validValueGUID, "validValueGUID", "09b2133a-f045-42cc-bb00-ee602b74c618", "ValidValueDefinition", forLineage, forDuplicateProcessing, "111e6d2e-94e9-43ed-b4ed-f0d220668cbf", "ReferenceValueAssignment", effectiveTime, methodName);
    }

    public B getValidValueByGUID(String userId, String validValueGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String validValueGUIDParameter = "validValueGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(validValueGUID, "validValueGUID", methodName);
        return this.getBeanFromRepository(userId, validValueGUID, "validValueGUID", "ValidValueDefinition", forLineage, forDuplicateProcessing, this.supportedZones, effectiveTime, methodName);
    }

    public List<B> getValidValueByName(String userId, String name, String nameParameterName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        ArrayList<String> specificMatchPropertyNames = new ArrayList<String>();
        specificMatchPropertyNames.add("qualifiedName");
        specificMatchPropertyNames.add("name");
        specificMatchPropertyNames.add("preferredValue");
        return this.getBeansByValue(userId, name, nameParameterName, "09b2133a-f045-42cc-bb00-ee602b74c618", "ValidValueDefinition", specificMatchPropertyNames, true, null, null, forLineage, forDuplicateProcessing, this.supportedZones, null, startFrom, pageSize, effectiveTime, methodName);
    }

    public List<B> findValidValues(String userId, String searchString, String searchStringParameterName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.findBeans(userId, searchString, searchStringParameterName, "09b2133a-f045-42cc-bb00-ee602b74c618", "ValidValueDefinition", forLineage, forDuplicateProcessing, this.supportedZones, null, startFrom, pageSize, effectiveTime, methodName);
    }

    public List<B> getValidValueSetMembers(String userId, String validValueSetGUID, String validValueSetGUIDParameter, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.getAttachedElements(userId, null, null, validValueSetGUID, validValueSetGUIDParameter, "ValidValuesSet", "6337c9cd-8e5a-461b-97f9-5151bcb97a9e", "ValidValueMember", "ValidValueDefinition", null, null, 2, forLineage, forDuplicateProcessing, this.supportedZones, startFrom, pageSize, effectiveTime, methodName);
    }

    public List<B> getSetsForValidValue(String userId, String validValueGUID, String validValueGUIDParameter, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.getAttachedElements(userId, null, null, validValueGUID, validValueGUIDParameter, "ValidValueDefinition", "6337c9cd-8e5a-461b-97f9-5151bcb97a9e", "ValidValueMember", "ValidValuesSet", null, null, 1, forLineage, forDuplicateProcessing, this.supportedZones, startFrom, pageSize, effectiveTime, methodName);
    }

    public B getAssignedValidValues(String userId, String referenceableGUID, String referenceableGUIDParameter, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.getAttachedElement(userId, referenceableGUID, referenceableGUIDParameter, "Referenceable", "c5d48b73-eadd-47db-ab64-3be99b2fb32d", "ValidValuesAssignment", "ValidValueDefinition", 2, forLineage, forDuplicateProcessing, this.supportedZones, effectiveTime, methodName);
    }

    public List<B> getReferenceValues(String userId, String referenceableGUID, String referenceableGUIDParameterName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.getAttachedElements(userId, referenceableGUID, referenceableGUIDParameterName, "Referenceable", "111e6d2e-94e9-43ed-b4ed-f0d220668cbf", "ReferenceValueAssignment", "ValidValueDefinition", null, null, 2, forLineage, forDuplicateProcessing, startFrom, pageSize, effectiveTime, methodName);
    }

    public List<B> getValidValues(String userId, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.getBeansByType(userId, "09b2133a-f045-42cc-bb00-ee602b74c618", "ValidValueDefinition", null, forLineage, forDuplicateProcessing, this.supportedZones, startFrom, pageSize, effectiveTime, methodName);
    }
}

