/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.generichandlers.CollectionBuilder;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericConverter;
import org.odpi.openmetadata.commonservices.generichandlers.ReferenceableHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.OCFCheckedExceptionBase;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.metadatasecurity.server.OpenMetadataServerSecurityVerifier;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeErrorException;

public class CollectionHandler<B>
extends ReferenceableHandler<B> {
    private static final String qualifiedNameParameterName = "qualifiedName";

    public CollectionHandler(OpenMetadataAPIGenericConverter<B> converter, Class<B> beanClass, String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper, String localServerUserId, OpenMetadataServerSecurityVerifier securityVerifier, List<String> supportedZones, List<String> defaultZones, List<String> publishZones, AuditLog auditLog) {
        super(converter, beanClass, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
    }

    public String createCollection(String userId, String externalSourceGUID, String externalSourceName, String qualifiedName, String displayName, String description, Map<String, String> additionalProperties, String suppliedTypeName, Map<String, Object> extendedProperties, String classificationName, Date effectiveFrom, Date effectiveTo, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateName(qualifiedName, qualifiedNameParameterName, methodName);
        String typeName = "Collection";
        if (suppliedTypeName != null) {
            typeName = suppliedTypeName;
        }
        String typeGUID = this.invalidParameterHandler.validateTypeName(typeName, "Collection", this.serviceName, methodName, this.repositoryHelper);
        CollectionBuilder builder = new CollectionBuilder(qualifiedName, displayName, description, additionalProperties, typeGUID, typeName, extendedProperties, this.repositoryHelper, this.serviceName, this.serverName);
        if (classificationName != null) {
            builder.setupCollectionClassification(userId, classificationName, methodName);
        }
        builder.setEffectivityDates(effectiveFrom, effectiveTo);
        return this.createBeanInRepository(userId, externalSourceGUID, externalSourceName, typeGUID, typeName, builder, effectiveTime, methodName);
    }

    public String createFolder(String userId, String externalSourceGUID, String externalSourceName, String qualifiedName, String displayName, String description, Map<String, String> additionalProperties, String suppliedTypeName, Map<String, Object> extendedProperties, int orderBy, String orderPropertyName, Date effectiveFrom, Date effectiveTo, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateName(qualifiedName, qualifiedNameParameterName, methodName);
        String typeName = "Collection";
        if (suppliedTypeName != null) {
            typeName = suppliedTypeName;
        }
        String typeGUID = this.invalidParameterHandler.validateTypeName(typeName, "Collection", this.serviceName, methodName, this.repositoryHelper);
        CollectionBuilder builder = new CollectionBuilder(qualifiedName, displayName, description, additionalProperties, typeGUID, typeName, extendedProperties, this.repositoryHelper, this.serviceName, this.serverName);
        builder.setupFolderClassification(userId, orderBy, orderPropertyName, methodName);
        builder.setEffectivityDates(effectiveFrom, effectiveTo);
        return this.createBeanInRepository(userId, externalSourceGUID, externalSourceName, typeGUID, typeName, builder, effectiveTime, methodName);
    }

    public String createCollectionFromTemplate(String userId, String externalSourceGUID, String externalSourceName, String templateGUID, String qualifiedName, String displayName, String description, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String templateGUIDParameterName = "templateGUID";
        String qualifiedNameParameterName = qualifiedNameParameterName;
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(templateGUID, "templateGUID", methodName);
        this.invalidParameterHandler.validateName(qualifiedName, qualifiedNameParameterName, methodName);
        CollectionBuilder builder = new CollectionBuilder(qualifiedName, displayName, description, this.repositoryHelper, this.serviceName, this.serverName);
        return this.createBeanFromTemplate(userId, externalSourceGUID, externalSourceName, templateGUID, "templateGUID", "347005ba-2b35-4670-b5a7-12c9ebed0cf7", "Collection", qualifiedName, qualifiedNameParameterName, builder, this.supportedZones, methodName);
    }

    public void updateCollection(String userId, String externalSourceGUID, String externalSourceName, String collectionGUID, String collectionGUIDParameterName, String qualifiedName, String displayName, String description, Map<String, String> additionalProperties, String suppliedTypeName, Map<String, Object> extendedProperties, Date effectiveFrom, Date effectiveTo, boolean isMergeUpdate, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(collectionGUID, collectionGUIDParameterName, methodName);
        this.invalidParameterHandler.validateName(qualifiedName, qualifiedNameParameterName, methodName);
        String typeName = "Collection";
        if (suppliedTypeName != null) {
            typeName = suppliedTypeName;
        }
        String typeGUID = this.invalidParameterHandler.validateTypeName(typeName, "Collection", this.serviceName, methodName, this.repositoryHelper);
        CollectionBuilder builder = new CollectionBuilder(qualifiedName, displayName, description, additionalProperties, typeGUID, typeName, extendedProperties, this.repositoryHelper, this.serviceName, this.serverName);
        builder.setEffectivityDates(effectiveFrom, effectiveTo);
        this.updateBeanInRepository(userId, externalSourceGUID, externalSourceName, collectionGUID, collectionGUIDParameterName, typeGUID, typeName, forLineage, forDuplicateProcessing, (List<String>)this.supportedZones, builder.getInstanceProperties(methodName), isMergeUpdate, effectiveTime, methodName);
    }

    public void addFolderClassificationToCollection(String userId, String collectionGUID, String collectionGUIDParameterName, int orderBy, String orderPropertyName, boolean isMergeUpdate, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(collectionGUID, collectionGUIDParameterName, methodName);
        CollectionBuilder builder = new CollectionBuilder(this.repositoryHelper, this.serviceName, this.serverName);
        this.setClassificationInRepository(userId, null, null, collectionGUID, collectionGUIDParameterName, "Collection", "3c0fa687-8a63-4c8e-8bda-ede9c78be6c7", "Folder", builder.getFolderProperties(orderBy, orderPropertyName, methodName), isMergeUpdate, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void removeFolderClassificationFromCollection(String userId, String collectionGUID, String collectionGUIDParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(collectionGUID, collectionGUIDParameterName, methodName);
        this.removeClassificationFromRepository(userId, null, null, collectionGUID, collectionGUIDParameterName, "Collection", "3c0fa687-8a63-4c8e-8bda-ede9c78be6c7", "Folder", forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void addMemberToCollection(String userId, String externalSourceGUID, String externalSourceName, String collectionGUID, String collectionGUIDParameterName, String memberGUID, String memberGUIDParameterName, String membershipRationale, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        InstanceProperties properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, "membershipRationale", membershipRationale, methodName);
        this.linkElementToElement(userId, externalSourceGUID, externalSourceName, collectionGUID, collectionGUIDParameterName, "Collection", memberGUID, memberGUIDParameterName, "Referenceable", forLineage, forDuplicateProcessing, this.supportedZones, "5cabb76a-e25b-4bb5-8b93-768bbac005af", "CollectionMembership", properties, effectiveFrom, effectiveTo, effectiveTime, methodName);
    }

    public void updateCollectionMembership(String userId, String externalSourceGUID, String externalSourceName, String collectionGUID, String collectionGUIDParameterName, String memberGUID, String memberGUIDParameterName, String membershipRationale, String expression, int membershipStatus, String userDefinedStatus, int confidence, String createdBy, String steward, String stewardTypeName, String stewardPropertyName, String source, String notes, Date effectiveFrom, Date effectiveTo, boolean isMergeUpdate, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        Relationship relationship;
        InstanceProperties properties = null;
        if (isMergeUpdate && (relationship = this.getUniqueAttachmentLink(userId, collectionGUID, collectionGUIDParameterName, "Collection", "5cabb76a-e25b-4bb5-8b93-768bbac005af", "CollectionMembership", memberGUID, "Referenceable", 2, forLineage, forDuplicateProcessing, this.supportedZones, effectiveTime, methodName)) != null) {
            properties = relationship.getProperties();
        }
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "membershipRationale", membershipRationale, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "expression", expression, methodName);
        try {
            properties = this.repositoryHelper.addEnumPropertyToInstance(this.serviceName, properties, "status", "a3bdb2ac-c28e-4e5a-8ab7-76aa01038832", "MembershipStatus", membershipStatus, methodName);
        }
        catch (TypeErrorException classificationNotSupported) {
            throw new InvalidParameterException((OCFCheckedExceptionBase)classificationNotSupported, "status");
        }
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "userDefinedStatus", userDefinedStatus, methodName);
        properties = this.repositoryHelper.addIntPropertyToInstance(this.serviceName, properties, "confidence", confidence, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "createdBy", createdBy, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "steward", steward, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "stewardTypeName", stewardTypeName, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "stewardPropertyName", stewardPropertyName, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "source", source, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "notes", notes, methodName);
        this.linkElementToElement(userId, externalSourceGUID, externalSourceName, collectionGUID, collectionGUIDParameterName, "Collection", memberGUID, memberGUIDParameterName, "Referenceable", forLineage, forDuplicateProcessing, this.supportedZones, "5cabb76a-e25b-4bb5-8b93-768bbac005af", "CollectionMembership", properties, effectiveFrom, effectiveTo, effectiveTime, methodName);
    }

    public void removeMemberFromCollection(String userId, String externalSourceGUID, String externalSourceName, String collectionGUID, String collectionGUIDParameterName, String memberGUID, String memberGUIDParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.unlinkElementFromElement(userId, false, externalSourceGUID, externalSourceName, collectionGUID, collectionGUIDParameterName, "Collection", memberGUID, memberGUIDParameterName, "a32316b8-dc8c-48c5-b12b-71c1b2a080bf", "Referenceable", forLineage, forDuplicateProcessing, "5cabb76a-e25b-4bb5-8b93-768bbac005af", "CollectionMembership", effectiveTime, methodName);
    }

    public void removeCollection(String userId, String externalSourceGUID, String externalSourceName, String collectionGUID, String collectionGUIDParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.deleteBeanInRepository(userId, externalSourceGUID, externalSourceName, collectionGUID, collectionGUIDParameterName, "347005ba-2b35-4670-b5a7-12c9ebed0cf7", "Collection", null, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public List<B> findCollections(String userId, String searchString, String searchStringParameterName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.findBeans(userId, searchString, searchStringParameterName, "347005ba-2b35-4670-b5a7-12c9ebed0cf7", "Collection", null, startFrom, pageSize, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public List<B> getCollectionsByName(String userId, String name, String nameParameterName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        ArrayList<String> specificMatchPropertyNames = new ArrayList<String>();
        specificMatchPropertyNames.add(qualifiedNameParameterName);
        specificMatchPropertyNames.add("name");
        return this.getBeansByValue(userId, name, nameParameterName, "347005ba-2b35-4670-b5a7-12c9ebed0cf7", "Collection", specificMatchPropertyNames, true, null, null, forLineage, forDuplicateProcessing, this.supportedZones, null, startFrom, pageSize, effectiveTime, methodName);
    }

    public B getCollectionByGUID(String userId, String guid, String guidParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.getBeanFromRepository(userId, guid, guidParameterName, "Collection", forLineage, forDuplicateProcessing, this.supportedZones, effectiveTime, methodName);
    }
}

