/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.generichandlers.GovernanceActionTypeBuilder;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericConverter;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.metadatasecurity.server.OpenMetadataServerSecurityVerifier;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class GovernanceActionTypeHandler<B>
extends OpenMetadataAPIGenericHandler<B> {
    public GovernanceActionTypeHandler(OpenMetadataAPIGenericConverter<B> converter, Class<B> beanClass, String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper, String localServerUserId, OpenMetadataServerSecurityVerifier securityVerifier, List<String> supportedZones, List<String> defaultZones, List<String> publishZones, AuditLog auditLog) {
        super(converter, beanClass, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
    }

    public String createGovernanceActionType(String userId, String qualifiedName, int domainIdentifier, String displayName, String description, List<String> supportedGuards, Map<String, String> additionalProperties, String governanceEngineGUID, String requestType, Map<String, String> requestParameters, boolean ignoreMultipleTriggers, int waitTime, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String qualifiedNameParameterName = "actionTypeProperties.getQualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateName(qualifiedName, "actionTypeProperties.getQualifiedName", methodName);
        GovernanceActionTypeBuilder builder = new GovernanceActionTypeBuilder(qualifiedName, domainIdentifier, displayName, description, supportedGuards, ignoreMultipleTriggers, waitTime, additionalProperties, this.repositoryHelper, this.serviceName, this.serverName);
        builder.setEffectivityDates(effectiveFrom, effectiveTo);
        String governanceActionTypeGUID = this.createBeanInRepository(userId, null, null, "92e20083-0393-40c0-a95b-090724a91ddc", "GovernanceActionType", builder, effectiveTime, methodName);
        if (governanceActionTypeGUID != null && governanceEngineGUID != null) {
            this.linkGovernanceActionExecutor(userId, governanceActionTypeGUID, governanceEngineGUID, requestType, requestParameters, effectiveFrom, effectiveTo, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        }
        return governanceActionTypeGUID;
    }

    private void linkGovernanceActionExecutor(String userId, String governanceActionTypeGUID, String governanceEngineGUID, String requestType, Map<String, String> requestParameters, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String governanceActionTypeGUIDParameterName = "governanceActionTypeGUID";
        String governanceEngineGUIDParameterName = "governanceEngineGUID";
        InstanceProperties relationshipProperties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, "requestType", requestType, methodName);
        relationshipProperties = this.repositoryHelper.addStringMapPropertyToInstance(this.serviceName, relationshipProperties, "requestParameters", requestParameters, methodName);
        this.linkElementToElement(userId, null, null, governanceActionTypeGUID, "governanceActionTypeGUID", "GovernanceActionType", governanceEngineGUID, "governanceEngineGUID", "GovernanceEngine", forLineage, forDuplicateProcessing, this.supportedZones, "f672245f-35b5-4ca7-b645-014cf61d5b75", "GovernanceActionTypeExecutor", this.setUpEffectiveDates(relationshipProperties, effectiveFrom, effectiveTo), effectiveFrom, effectiveTo, effectiveTime, methodName);
    }

    public void updateGovernanceActionType(String userId, String actionTypeGUID, boolean isMergeUpdate, String qualifiedName, int domainIdentifier, String displayName, String description, List<String> supportedGuards, Map<String, String> additionalProperties, String governanceEngineGUID, String requestType, Map<String, String> requestParameters, boolean ignoreMultipleTriggers, int waitTime, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String actionTypeGUIDParameterName = "actionTypeGUID";
        String governanceEngineGUIDParameterName = "governanceEngineGUID";
        String qualifiedNameParameterName = "actionTypeProperties.getQualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(actionTypeGUID, "actionTypeGUID", methodName);
        if (!isMergeUpdate) {
            this.invalidParameterHandler.validateName(qualifiedName, "actionTypeProperties.getQualifiedName", methodName);
        }
        if (!isMergeUpdate || governanceEngineGUID != null || requestType != null || requestParameters != null) {
            Relationship executorRelationship = this.repositoryHandler.getUniqueRelationshipByType(userId, actionTypeGUID, "GovernanceActionType", "f672245f-35b5-4ca7-b645-014cf61d5b75", "GovernanceActionTypeExecutor", 2, forLineage, forDuplicateProcessing, effectiveTime, methodName);
            if (executorRelationship == null) {
                this.invalidParameterHandler.validateGUID(governanceEngineGUID, "governanceEngineGUID", methodName);
                this.linkGovernanceActionExecutor(userId, actionTypeGUID, governanceEngineGUID, requestType, requestParameters, effectiveFrom, effectiveTo, forLineage, forDuplicateProcessing, effectiveTime, methodName);
            } else if (governanceEngineGUID == null) {
                if (!isMergeUpdate) {
                    this.repositoryHandler.removeRelationship(userId, null, null, executorRelationship, methodName);
                } else {
                    this.updateExecutorRelationship(userId, executorRelationship, requestType, requestParameters, effectiveFrom, effectiveTo, true, methodName);
                }
            } else if (governanceEngineGUID.equals(executorRelationship.getEntityTwoProxy().getGUID())) {
                this.updateExecutorRelationship(userId, executorRelationship, requestType, requestParameters, effectiveFrom, effectiveTo, isMergeUpdate, methodName);
            } else {
                this.repositoryHandler.removeRelationship(userId, null, null, executorRelationship, methodName);
                this.linkGovernanceActionExecutor(userId, actionTypeGUID, governanceEngineGUID, requestType, requestParameters, effectiveFrom, effectiveTo, forLineage, forDuplicateProcessing, effectiveTime, methodName);
            }
        }
        GovernanceActionTypeBuilder builder = new GovernanceActionTypeBuilder(qualifiedName, domainIdentifier, displayName, description, supportedGuards, ignoreMultipleTriggers, waitTime, additionalProperties, this.repositoryHelper, this.serviceName, this.serverName);
        builder.setEffectivityDates(effectiveFrom, effectiveTo);
        this.updateBeanInRepository(userId, null, null, actionTypeGUID, "actionTypeGUID", "92e20083-0393-40c0-a95b-090724a91ddc", "GovernanceActionType", forLineage, forDuplicateProcessing, (List<String>)this.supportedZones, builder.getInstanceProperties(methodName), isMergeUpdate, effectiveTime, methodName);
    }

    private void updateExecutorRelationship(String userId, Relationship executorRelationship, String requestType, Map<String, String> requestParameters, Date effectiveFrom, Date effectiveTo, boolean isMergeUpdate, String methodName) throws UserNotAuthorizedException, PropertyServerException {
        InstanceProperties relationshipProperties = null;
        if (isMergeUpdate) {
            relationshipProperties = executorRelationship.getProperties();
        }
        relationshipProperties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, relationshipProperties, "requestType", requestType, methodName);
        relationshipProperties = this.repositoryHelper.addStringMapPropertyToInstance(this.serviceName, relationshipProperties, "requestParameters", requestParameters, methodName);
        this.repositoryHandler.updateRelationshipProperties(userId, null, null, executorRelationship, this.setUpEffectiveDates(relationshipProperties, effectiveFrom, effectiveTo), methodName);
    }

    public void removeGovernanceActionType(String userId, String actionTypeGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String guidParameterName = "actionTypeGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(actionTypeGUID, "actionTypeGUID", methodName);
        this.deleteBeanInRepository(userId, null, null, actionTypeGUID, "actionTypeGUID", "92e20083-0393-40c0-a95b-090724a91ddc", "GovernanceActionType", null, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public List<B> findGovernanceActionTypes(String userId, String searchString, String searchStringParameterName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateSearchString(searchString, searchStringParameterName, methodName);
        return this.findBeans(userId, searchString, searchStringParameterName, "92e20083-0393-40c0-a95b-090724a91ddc", "GovernanceActionType", null, startFrom, pageSize, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public List<B> getGovernanceActionTypesByName(String userId, String name, String nameParameterName, int startFrom, int pageSize, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateName(name, nameParameterName, methodName);
        ArrayList<String> specificMatchPropertyNames = new ArrayList<String>();
        specificMatchPropertyNames.add("qualifiedName");
        specificMatchPropertyNames.add("displayName");
        return this.getBeansByValue(userId, name, nameParameterName, "92e20083-0393-40c0-a95b-090724a91ddc", "GovernanceActionType", specificMatchPropertyNames, true, null, null, false, false, this.supportedZones, null, startFrom, pageSize, effectiveTime, methodName);
    }

    public B getGovernanceActionTypeByGUID(String userId, String actionTypeGUID, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String guidParameterName = "actionTypeGUID";
        return this.getBeanFromRepository(userId, actionTypeGUID, "actionTypeGUID", "GovernanceActionType", false, false, effectiveTime, methodName);
    }

    public void setupFirstActionType(String userId, String processGUID, String actionTypeGUID, String guard, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String processGUIDParameterName = "processGUID";
        String actionTypeGUIDParameterName = "actionTypeGUID";
        InstanceProperties relationshipProperties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, "guard", guard, methodName);
        this.linkElementToElement(userId, null, null, processGUID, "processGUID", "GovernanceActionProcess", actionTypeGUID, "actionTypeGUID", "GovernanceActionType", forLineage, forDuplicateProcessing, this.supportedZones, "5f6ddee5-31ea-4d4f-9c3f-00ad2fcb2aa0", "GovernanceActionFlow", this.setUpEffectiveDates(relationshipProperties, effectiveFrom, effectiveTo), effectiveFrom, effectiveTo, effectiveTime, methodName);
    }

    public B getFirstActionType(String userId, String processGUID, Relationship firstActionTypeLink, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String processGUIDParameterName = "processGUID";
        if (firstActionTypeLink != null && firstActionTypeLink.getEntityTwoProxy() != null) {
            return this.getGovernanceActionTypeByGUID(userId, firstActionTypeLink.getEntityTwoProxy().getGUID(), effectiveTime, methodName);
        }
        return this.getAttachedElement(userId, processGUID, "processGUID", "GovernanceActionProcess", "5f6ddee5-31ea-4d4f-9c3f-00ad2fcb2aa0", "GovernanceActionFlow", "GovernanceActionType", 0, false, false, this.supportedZones, effectiveTime, methodName);
    }

    public Relationship getFirstActionTypeLink(String userId, String processGUID, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String processGUIDParameterName = "processGUID";
        return this.getUniqueAttachmentLink(userId, processGUID, "processGUID", "GovernanceActionProcess", "5f6ddee5-31ea-4d4f-9c3f-00ad2fcb2aa0", "GovernanceActionFlow", null, "GovernanceActionType", 2, false, false, effectiveTime, methodName);
    }

    public void removeFirstActionType(String userId, String processGUID, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String processGUIDParameterName = "processGUID";
        this.unlinkConnectedElement(userId, false, null, null, processGUID, "processGUID", "GovernanceActionProcess", false, false, this.supportedZones, "5f6ddee5-31ea-4d4f-9c3f-00ad2fcb2aa0", "GovernanceActionFlow", "GovernanceActionType", effectiveTime, methodName);
    }

    public String setupNextActionType(String userId, String currentActionTypeGUID, String nextActionTypeGUID, String guard, boolean mandatoryGuard, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String currentGUIDParameterName = "currentActionTypeGUID";
        String nextGUIDParameterName = "nextActionTypeGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(currentActionTypeGUID, "currentActionTypeGUID", methodName);
        this.invalidParameterHandler.validateGUID(nextActionTypeGUID, "nextActionTypeGUID", methodName);
        InstanceProperties relationshipProperties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, "guard", guard, methodName);
        relationshipProperties = this.repositoryHelper.addBooleanPropertyToInstance(this.serviceName, relationshipProperties, "mandatoryGuard", mandatoryGuard, methodName);
        return this.linkElementToElement(userId, null, null, currentActionTypeGUID, "currentActionTypeGUID", "GovernanceActionType", nextActionTypeGUID, "nextActionTypeGUID", "GovernanceActionType", forLineage, forDuplicateProcessing, this.supportedZones, "d9567840-9904-43a5-990b-4585c0446e00", "NextGovernanceActionType", this.setUpEffectiveDates(relationshipProperties, effectiveFrom, effectiveTo), effectiveFrom, effectiveTo, effectiveTime, methodName);
    }

    public void updateNextActionType(String userId, String nextActionLinkGUID, String guard, boolean mandatoryGuard, Date effectiveFrom, Date effectiveTo, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String guidParameterName = "nextActionLinkGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(nextActionLinkGUID, "nextActionLinkGUID", methodName);
        InstanceProperties relationshipProperties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, "guard", guard, methodName);
        relationshipProperties = this.repositoryHelper.addBooleanPropertyToInstance(this.serviceName, relationshipProperties, "mandatoryGuard", mandatoryGuard, methodName);
        this.setUpEffectiveDates(relationshipProperties, effectiveFrom, effectiveTo);
        this.repositoryHandler.updateRelationshipProperties(userId, null, null, nextActionLinkGUID, relationshipProperties, methodName);
    }

    public List<Relationship> getNextGovernanceActionTypes(String userId, String actionTypeGUID, int startFrom, int pageSize, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String guidParameterName = "actionTypeGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(actionTypeGUID, "actionTypeGUID", methodName);
        return this.repositoryHandler.getRelationshipsByType(userId, actionTypeGUID, "GovernanceActionType", "d9567840-9904-43a5-990b-4585c0446e00", "NextGovernanceActionType", 2, false, false, startFrom, pageSize, effectiveTime, methodName);
    }

    public void removeNextActionType(String userId, String actionLinkGUID, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String guidParameterName = "processGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(actionLinkGUID, "processGUID", methodName);
        this.repositoryHandler.removeRelationship(userId, null, null, "NextGovernanceActionType", actionLinkGUID, methodName);
    }
}

