/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.generichandlers.AssetHandler;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericConverter;
import org.odpi.openmetadata.commonservices.generichandlers.PortHandler;
import org.odpi.openmetadata.commonservices.generichandlers.ReferenceableHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.OCFCheckedExceptionBase;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.metadatasecurity.server.OpenMetadataServerSecurityVerifier;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeErrorException;

public class ProcessHandler<PROCESS, PORT, DATA_FLOW, CONTROL_FLOW, PROCESS_CALL, LINEAGE_MAPPING>
extends ReferenceableHandler<PROCESS> {
    private final AssetHandler<PROCESS> processHandler;
    private final PortHandler<PORT> portHandler;
    private final OpenMetadataAPIGenericConverter<DATA_FLOW> dataFlowConverter;
    private final Class<DATA_FLOW> dataFlowBeanClass;
    private final OpenMetadataAPIGenericConverter<CONTROL_FLOW> controlFlowConverter;
    private final Class<CONTROL_FLOW> controlFlowBeanClass;
    private final OpenMetadataAPIGenericConverter<PROCESS_CALL> processCallConverter;
    private final Class<PROCESS_CALL> processCallBeanClass;
    private final OpenMetadataAPIGenericConverter<LINEAGE_MAPPING> lineageMappingConverter;
    private final Class<LINEAGE_MAPPING> lineageMappingClass;

    public ProcessHandler(OpenMetadataAPIGenericConverter<PROCESS> converter, Class<PROCESS> beanClass, OpenMetadataAPIGenericConverter<PORT> portConverter, Class<PORT> portBeanClass, OpenMetadataAPIGenericConverter<DATA_FLOW> dataFlowConverter, Class<DATA_FLOW> dataFlowBeanClass, OpenMetadataAPIGenericConverter<CONTROL_FLOW> controlFlowConverter, Class<CONTROL_FLOW> controlFlowBeanClass, OpenMetadataAPIGenericConverter<PROCESS_CALL> processCallConverter, Class<PROCESS_CALL> processCallBeanClass, OpenMetadataAPIGenericConverter<LINEAGE_MAPPING> lineageMappingConverter, Class<LINEAGE_MAPPING> lineageMappingClass, String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper, String localServerUserId, OpenMetadataServerSecurityVerifier securityVerifier, List<String> supportedZones, List<String> defaultZones, List<String> publishZones, AuditLog auditLog) {
        super(converter, beanClass, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
        this.processHandler = new AssetHandler<PROCESS>(converter, beanClass, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
        this.portHandler = new PortHandler<PORT>(portConverter, portBeanClass, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
        this.dataFlowConverter = dataFlowConverter;
        this.dataFlowBeanClass = dataFlowBeanClass;
        this.controlFlowConverter = controlFlowConverter;
        this.controlFlowBeanClass = controlFlowBeanClass;
        this.processCallConverter = processCallConverter;
        this.processCallBeanClass = processCallBeanClass;
        this.lineageMappingConverter = lineageMappingConverter;
        this.lineageMappingClass = lineageMappingClass;
    }

    public String createProcess(String userId, String externalSourceGUID, String externalSourceName, String qualifiedName, String technicalName, String versionIdentifier, String technicalDescription, String formula, String formulaType, String implementationLanguage, Map<String, String> additionalProperties, String suppliedTypeName, Map<String, Object> suppliedExtendedProperties, InstanceStatus initialStatus, Date effectiveFrom, Date effectiveTo, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String typeName = "Process";
        if (suppliedTypeName != null) {
            typeName = suppliedTypeName;
        }
        this.invalidParameterHandler.validateTypeName(typeName, "Process", this.serviceName, methodName, this.repositoryHelper);
        Map<String, Object> extendedProperties = suppliedExtendedProperties;
        if (formula != null) {
            if (extendedProperties == null) {
                extendedProperties = new HashMap<String, Object>();
            }
            extendedProperties.put("formula", formula);
        }
        if (formulaType != null) {
            if (extendedProperties == null) {
                extendedProperties = new HashMap<String, Object>();
            }
            extendedProperties.put("formulaType", formulaType);
        }
        if (implementationLanguage != null) {
            if (extendedProperties == null) {
                extendedProperties = new HashMap<String, Object>();
            }
            extendedProperties.put("implementationLanguage", implementationLanguage);
        }
        return this.processHandler.createAssetInRepository(userId, externalSourceGUID, externalSourceName, qualifiedName, technicalName, versionIdentifier, technicalDescription, additionalProperties, typeName, extendedProperties, initialStatus, effectiveFrom, effectiveTo, effectiveTime, methodName);
    }

    public String createProcessFromTemplate(String userId, String externalSourceGUID, String externalSourceName, String templateGUID, String templateGUIDParameterName, String qualifiedName, String qualifiedNameParameterName, String technicalName, String versionIdentifier, String description, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.processHandler.addAssetFromTemplate(userId, externalSourceGUID, externalSourceName, templateGUID, templateGUIDParameterName, "d8f33bd7-afa9-4a11-a8c7-07dcec83c050", "Process", qualifiedName, qualifiedNameParameterName, technicalName, versionIdentifier, description, null, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void updateProcess(String userId, String externalSourceGUID, String externalSourceName, String processGUID, String processGUIDParameterName, boolean isMergeUpdate, String qualifiedName, String technicalName, String versionIdentifier, String technicalDescription, String formula, String implementationLanguage, Map<String, String> additionalProperties, String suppliedTypeName, Map<String, Object> suppliedExtendedProperties, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String typeName = "Process";
        if (suppliedTypeName != null) {
            typeName = suppliedTypeName;
        }
        String typeGUID = this.invalidParameterHandler.validateTypeName(typeName, "Asset", this.serviceName, methodName, this.repositoryHelper);
        Map<String, Object> extendedProperties = suppliedExtendedProperties;
        if (formula != null) {
            if (extendedProperties == null) {
                extendedProperties = new HashMap<String, Object>();
            }
            extendedProperties.put("formula", formula);
        }
        if (implementationLanguage != null) {
            if (extendedProperties == null) {
                extendedProperties = new HashMap<String, Object>();
            }
            extendedProperties.put("implementationLanguage", implementationLanguage);
        }
        this.processHandler.updateAsset(userId, externalSourceGUID, externalSourceName, processGUID, processGUIDParameterName, qualifiedName, technicalName, versionIdentifier, technicalDescription, additionalProperties, typeGUID, typeName, this.supportedZones, extendedProperties, effectiveFrom, effectiveTo, isMergeUpdate, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void updateProcessStatus(String userId, String externalSourceGUID, String externalSourceName, String processGUID, String processGUIDParameterName, InstanceStatus processStatus, String processStatusParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.updateBeanStatusInRepository(userId, externalSourceGUID, externalSourceName, processGUID, processGUIDParameterName, "d8f33bd7-afa9-4a11-a8c7-07dcec83c050", "Process", forLineage, forDuplicateProcessing, this.supportedZones, processStatus, processStatusParameterName, effectiveTime, methodName);
    }

    public void setupProcessParent(String userId, String externalSourceGUID, String externalSourceName, String parentProcessGUID, String parentProcessGUIDParameterName, String childProcessGUID, String childProcessGUIDParameterName, Date effectiveFrom, Date effectiveTo, int containmentType, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        InstanceProperties properties;
        try {
            properties = this.repositoryHelper.addEnumPropertyToInstance(this.serviceName, null, "containmentType", "1bb4b908-7983-4802-a2b5-91b095552ee9", "ProcessContainmentType", containmentType, methodName);
        }
        catch (TypeErrorException classificationNotSupported) {
            throw new InvalidParameterException((OCFCheckedExceptionBase)classificationNotSupported, "containmentType");
        }
        this.processHandler.linkElementToElement(userId, externalSourceGUID, externalSourceName, parentProcessGUID, parentProcessGUIDParameterName, "Process", childProcessGUID, childProcessGUIDParameterName, "Process", forLineage, forDuplicateProcessing, this.supportedZones, "70dbbda3-903f-49f7-9782-32b503c43e0e", "ProcessHierarchy", properties, effectiveFrom, effectiveTo, effectiveTime, methodName);
    }

    public void clearProcessParent(String userId, String externalSourceGUID, String externalSourceName, String parentProcessGUID, String parentProcessGUIDParameterName, String childProcessGUID, String childProcessGUIDParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.processHandler.unlinkElementFromElement(userId, false, externalSourceGUID, externalSourceName, parentProcessGUID, parentProcessGUIDParameterName, "Process", childProcessGUID, childProcessGUIDParameterName, "d8f33bd7-afa9-4a11-a8c7-07dcec83c050", "Process", forLineage, forDuplicateProcessing, (List<String>)this.supportedZones, "70dbbda3-903f-49f7-9782-32b503c43e0e", "ProcessHierarchy", effectiveTime, methodName);
    }

    public void publishProcess(String userId, String processGUID, String processGUIDParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.processHandler.publishAsset(userId, processGUID, processGUIDParameterName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void withdrawProcess(String userId, String processGUID, String processGUIDParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.processHandler.publishAsset(userId, processGUID, processGUIDParameterName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void removeProcess(String userId, String externalSourceGUID, String externalSourceName, String processGUID, String processGUIDParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.processHandler.deleteBeanInRepository(userId, externalSourceGUID, externalSourceName, processGUID, processGUIDParameterName, "d8f33bd7-afa9-4a11-a8c7-07dcec83c050", "Process", null, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public List<PROCESS> findProcesses(String userId, String searchString, String searchStringParameterName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateSearchString(searchString, searchStringParameterName, methodName);
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, methodName);
        return this.processHandler.findAssets(userId, "d8f33bd7-afa9-4a11-a8c7-07dcec83c050", "Process", searchString, searchStringParameterName, startFrom, validatedPageSize, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public List<PROCESS> getProcessesByName(String userId, String name, String nameParameterName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.processHandler.getAssetsByName(userId, "d8f33bd7-afa9-4a11-a8c7-07dcec83c050", "Process", name, nameParameterName, this.supportedZones, startFrom, pageSize, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public PROCESS getProcessByGUID(String userId, String processGUID, String processGUIDParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return (PROCESS)this.processHandler.getBeanFromRepository(userId, processGUID, processGUIDParameterName, "Process", forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public PROCESS getProcessParent(String userId, String processGUID, String processGUIDParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return (PROCESS)this.processHandler.getAttachedElement(userId, processGUID, processGUIDParameterName, "Process", "70dbbda3-903f-49f7-9782-32b503c43e0e", "ProcessHierarchy", "Process", 2, forLineage, forDuplicateProcessing, this.supportedZones, effectiveTime, methodName);
    }

    public List<PROCESS> getSubProcesses(String userId, String processGUID, String processGUIDParameterName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(processGUID, processGUIDParameterName, methodName);
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, methodName);
        return this.processHandler.getAttachedElements(userId, null, null, processGUID, processGUIDParameterName, "Process", "70dbbda3-903f-49f7-9782-32b503c43e0e", "ProcessHierarchy", "Process", null, null, 2, forLineage, forDuplicateProcessing, this.supportedZones, startFrom, validatedPageSize, effectiveTime, methodName);
    }

    public String createPort(String userId, String externalSourceGUID, String externalSourceName, String processGUID, String processGUIDParameterName, String qualifiedName, String displayName, int portType, Map<String, String> additionalProperties, String suppliedTypeName, Map<String, Object> extendedProperties, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.portHandler.createPort(userId, externalSourceGUID, externalSourceName, processGUID, processGUIDParameterName, qualifiedName, displayName, portType, additionalProperties, suppliedTypeName, extendedProperties, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void updatePort(String userId, String externalSourceGUID, String externalSourceName, String portGUID, String portGUIDParameterName, String qualifiedName, String displayName, int portType, Map<String, String> additionalProperties, String suppliedTypeName, Map<String, Object> extendedProperties, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.portHandler.updatePort(userId, externalSourceGUID, externalSourceName, portGUID, portGUIDParameterName, qualifiedName, displayName, portType, additionalProperties, suppliedTypeName, extendedProperties, effectiveFrom, effectiveTo, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void setupProcessPort(String userId, String externalSourceGUID, String externalSourceName, String processGUID, String processGUIDParameterName, String portGUID, String portGUIDParameterName, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.portHandler.setupProcessPort(userId, externalSourceGUID, externalSourceName, processGUID, processGUIDParameterName, portGUID, portGUIDParameterName, effectiveFrom, effectiveTo, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void clearProcessPort(String userId, String externalSourceGUID, String externalSourceName, String processGUID, String processGUIDParameterName, String portGUID, String portGUIDParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.portHandler.clearProcessPort(userId, externalSourceGUID, externalSourceName, processGUID, processGUIDParameterName, portGUID, portGUIDParameterName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void setupPortDelegation(String userId, String externalSourceGUID, String externalSourceName, String portOneGUID, String portOneGUIDParameterName, String portTwoGUID, String portTwoGUIDParameterName, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.portHandler.setupPortDelegation(userId, externalSourceGUID, externalSourceName, portOneGUID, portOneGUIDParameterName, portTwoGUID, portTwoGUIDParameterName, effectiveFrom, effectiveTo, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void clearPortDelegation(String userId, String externalSourceGUID, String externalSourceName, String portOneGUID, String portOneGUIDParameterName, String portTwoGUID, String portTwoGUIDParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.portHandler.clearPortDelegation(userId, externalSourceGUID, externalSourceName, portOneGUID, portOneGUIDParameterName, portTwoGUID, portTwoGUIDParameterName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void setupPortSchemaType(String userId, String externalSourceGUID, String externalSourceName, String portGUID, String portGUIDParameterName, String schemaTypeGUID, String schemaTypeGUIDParameterName, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.portHandler.setupPortSchemaType(userId, externalSourceGUID, externalSourceName, portGUID, portGUIDParameterName, schemaTypeGUID, schemaTypeGUIDParameterName, effectiveFrom, effectiveTo, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void clearPortSchemaType(String userId, String externalSourceGUID, String externalSourceName, String portGUID, String portGUIDParameterName, String schemaTypeGUID, String schemaTypeGUIDParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.portHandler.clearPortSchemaType(userId, externalSourceGUID, externalSourceName, portGUID, portGUIDParameterName, schemaTypeGUID, schemaTypeGUIDParameterName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void removePort(String userId, String externalSourceGUID, String externalSourceName, String portGUID, String portGUIDParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.portHandler.removePort(userId, externalSourceGUID, externalSourceName, portGUID, portGUIDParameterName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public List<PORT> findPorts(String userId, String searchString, String searchStringParameterName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.portHandler.findPorts(userId, searchString, searchStringParameterName, startFrom, pageSize, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public List<PORT> getPortsForProcess(String userId, String processGUID, String processGUIDParameterName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.portHandler.getPortsForProcess(userId, processGUID, processGUIDParameterName, startFrom, pageSize, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public List<PORT> getPortUse(String userId, String portGUID, String portGUIDParameterName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.portHandler.getPortUse(userId, portGUID, portGUIDParameterName, startFrom, pageSize, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public PORT getPortDelegation(String userId, String portGUID, String portGUIDParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.portHandler.getPortDelegation(userId, portGUID, portGUIDParameterName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public List<PORT> getPortsByName(String userId, String name, String nameParameterName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.portHandler.getPortsByName(userId, name, nameParameterName, startFrom, pageSize, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public PORT getPortByGUID(String userId, String portGUID, String portGUIDParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.portHandler.getPortByGUID(userId, portGUID, portGUIDParameterName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public String setupDataFlow(String userId, String externalSourceGUID, String externalSourceName, String dataSupplierGUID, String dataSupplierGUIDParameterName, String dataConsumerGUID, String dataConsumerGUIDParameterName, Date effectiveFrom, Date effectiveTo, String qualifiedName, String description, String formula, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(dataSupplierGUID, dataSupplierGUIDParameterName, methodName);
        this.invalidParameterHandler.validateGUID(dataConsumerGUID, dataConsumerGUIDParameterName, methodName);
        InstanceProperties relationshipProperties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, "qualifiedName", qualifiedName, methodName);
        relationshipProperties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, relationshipProperties, "description", description, methodName);
        relationshipProperties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, relationshipProperties, "formula", formula, methodName);
        return super.multiLinkElementToElement(userId, externalSourceGUID, externalSourceName, dataSupplierGUID, dataSupplierGUIDParameterName, "Referenceable", dataConsumerGUID, dataConsumerGUIDParameterName, "Referenceable", forLineage, forDuplicateProcessing, this.supportedZones, "d2490c0c-06cc-458a-add2-33cf2f5dd724", "DataFlow", this.setUpEffectiveDates(relationshipProperties, effectiveFrom, effectiveTo), effectiveTime, methodName);
    }

    public DATA_FLOW getDataFlow(String userId, String dataSupplierGUID, String dataSupplierGUIDParameterName, String dataConsumerGUID, String dataConsumerGUIDParameterName, String qualifiedName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(dataSupplierGUID, dataSupplierGUIDParameterName, methodName);
        this.invalidParameterHandler.validateGUID(dataConsumerGUID, dataConsumerGUIDParameterName, methodName);
        List<Relationship> relationships = super.getAttachmentLinks(userId, dataSupplierGUID, dataSupplierGUIDParameterName, "Referenceable", "d2490c0c-06cc-458a-add2-33cf2f5dd724", "DataFlow", dataConsumerGUID, "Referenceable", 2, forLineage, forDuplicateProcessing, (List<String>)this.supportedZones, 0, 0, effectiveTime, methodName);
        if (relationships != null) {
            for (Relationship relationship : relationships) {
                if (relationship == null) continue;
                if (qualifiedName == null) {
                    return this.dataFlowConverter.getNewRelationshipBean(this.dataFlowBeanClass, relationship, methodName);
                }
                String relationshipQualifiedName = this.repositoryHelper.getStringProperty(this.serviceName, "qualifiedName", relationship.getProperties(), methodName);
                if (!qualifiedName.equals(relationshipQualifiedName)) continue;
                return this.dataFlowConverter.getNewRelationshipBean(this.dataFlowBeanClass, relationship, methodName);
            }
        }
        return null;
    }

    public void updateDataFlow(String userId, String externalSourceGUID, String externalSourceName, String dataFlowGUID, String dataFlowGUIDParameterName, Date effectiveFrom, Date effectiveTo, String qualifiedName, String description, String formula, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(dataFlowGUID, dataFlowGUIDParameterName, methodName);
        InstanceProperties properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, "qualifiedName", qualifiedName, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "description", description, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "formula", formula, methodName);
        super.updateRelationshipProperties(userId, externalSourceGUID, externalSourceName, dataFlowGUID, dataFlowGUIDParameterName, "DataFlow", false, this.setUpEffectiveDates(properties, effectiveFrom, effectiveTo), forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void clearDataFlow(String userId, String externalSourceGUID, String externalSourceName, String dataFlowGUID, String dataFlowGUIDParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(dataFlowGUID, dataFlowGUIDParameterName, methodName);
        super.deleteRelationship(userId, externalSourceGUID, externalSourceName, dataFlowGUID, dataFlowGUIDParameterName, "DataFlow", forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public List<DATA_FLOW> getDataFlowConsumers(String userId, String dataSupplierGUID, String dataSupplierGUIDParameterName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(dataSupplierGUID, dataSupplierGUIDParameterName, methodName);
        List<Relationship> relationships = super.getAttachmentLinks(userId, dataSupplierGUID, dataSupplierGUIDParameterName, "Referenceable", "d2490c0c-06cc-458a-add2-33cf2f5dd724", "DataFlow", null, "Referenceable", 2, forLineage, forDuplicateProcessing, (List<String>)this.supportedZones, startFrom, pageSize, effectiveTime, methodName);
        ArrayList<DATA_FLOW> dataFlowConsumers = new ArrayList<DATA_FLOW>();
        if (relationships != null) {
            for (Relationship relationship : relationships) {
                if (relationship == null) continue;
                dataFlowConsumers.add(this.dataFlowConverter.getNewRelationshipBean(this.dataFlowBeanClass, relationship, methodName));
            }
        }
        if (dataFlowConsumers.isEmpty()) {
            dataFlowConsumers = null;
        }
        return dataFlowConsumers;
    }

    public List<DATA_FLOW> getDataFlowSuppliers(String userId, String dataConsumerGUID, String dataConsumerGUIDParameterName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(dataConsumerGUID, dataConsumerGUIDParameterName, methodName);
        List<Relationship> relationships = super.getAttachmentLinks(userId, dataConsumerGUID, dataConsumerGUIDParameterName, "Referenceable", "d2490c0c-06cc-458a-add2-33cf2f5dd724", "DataFlow", null, "Referenceable", 1, forLineage, forDuplicateProcessing, (List<String>)this.supportedZones, startFrom, pageSize, effectiveTime, methodName);
        ArrayList<DATA_FLOW> dataFlowSuppliers = new ArrayList<DATA_FLOW>();
        if (relationships != null) {
            for (Relationship relationship : relationships) {
                if (relationship == null) continue;
                dataFlowSuppliers.add(this.dataFlowConverter.getNewRelationshipBean(this.dataFlowBeanClass, relationship, methodName));
            }
        }
        if (dataFlowSuppliers.isEmpty()) {
            dataFlowSuppliers = null;
        }
        return dataFlowSuppliers;
    }

    public String setupControlFlow(String userId, String externalSourceGUID, String externalSourceName, String currentStepGUID, String currentStepGUIDParameterName, String nextStepGUID, String nextStepGUIDParameterName, Date effectiveFrom, Date effectiveTo, String qualifiedName, String description, String guard, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(currentStepGUID, currentStepGUIDParameterName, methodName);
        this.invalidParameterHandler.validateGUID(nextStepGUID, nextStepGUIDParameterName, methodName);
        InstanceProperties relationshipProperties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, "qualifiedName", qualifiedName, methodName);
        relationshipProperties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, relationshipProperties, "description", description, methodName);
        relationshipProperties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, relationshipProperties, "guard", guard, methodName);
        return super.multiLinkElementToElement(userId, externalSourceGUID, externalSourceName, currentStepGUID, currentStepGUIDParameterName, "Referenceable", nextStepGUID, nextStepGUIDParameterName, "Referenceable", forLineage, forDuplicateProcessing, this.supportedZones, "35450726-1c32-4d41-b928-22db6d1ae2f4", "ControlFlow", this.setUpEffectiveDates(relationshipProperties, effectiveFrom, effectiveTo), effectiveTime, methodName);
    }

    public CONTROL_FLOW getControlFlow(String userId, String currentStepGUID, String currentStepGUIDParameterName, String nextStepGUID, String nextStepGUIDParameterName, String qualifiedName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(currentStepGUID, currentStepGUIDParameterName, methodName);
        this.invalidParameterHandler.validateGUID(nextStepGUID, nextStepGUIDParameterName, methodName);
        List<Relationship> relationships = super.getAttachmentLinks(userId, currentStepGUID, currentStepGUIDParameterName, "Referenceable", "35450726-1c32-4d41-b928-22db6d1ae2f4", "ControlFlow", nextStepGUID, "Referenceable", 2, forLineage, forDuplicateProcessing, (List<String>)this.supportedZones, 0, 0, effectiveTime, methodName);
        if (relationships != null) {
            for (Relationship relationship : relationships) {
                if (relationship == null) continue;
                if (qualifiedName == null) {
                    return this.controlFlowConverter.getNewRelationshipBean(this.controlFlowBeanClass, relationship, methodName);
                }
                String relationshipQualifiedName = this.repositoryHelper.getStringProperty(this.serviceName, "qualifiedName", relationship.getProperties(), methodName);
                if (!qualifiedName.equals(relationshipQualifiedName)) continue;
                return this.controlFlowConverter.getNewRelationshipBean(this.controlFlowBeanClass, relationship, methodName);
            }
        }
        return null;
    }

    public void updateControlFlow(String userId, String externalSourceGUID, String externalSourceName, String controlFlowGUID, String controlFlowGUIDParameterName, Date effectiveFrom, Date effectiveTo, String qualifiedName, String description, String guard, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(controlFlowGUID, controlFlowGUIDParameterName, methodName);
        InstanceProperties properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, "qualifiedName", qualifiedName, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "description", description, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "guard", guard, methodName);
        super.updateRelationshipProperties(userId, externalSourceGUID, externalSourceName, controlFlowGUID, controlFlowGUIDParameterName, "ControlFlow", false, this.setUpEffectiveDates(properties, effectiveFrom, effectiveTo), forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void clearControlFlow(String userId, String externalSourceGUID, String externalSourceName, String controlFlowGUID, String controlFlowGUIDParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(controlFlowGUID, controlFlowGUIDParameterName, methodName);
        super.deleteRelationship(userId, externalSourceGUID, externalSourceName, controlFlowGUID, controlFlowGUIDParameterName, "ControlFlow", forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public List<CONTROL_FLOW> getControlFlowNextSteps(String userId, String currentStepGUID, String currentStepGUIDParameterName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(currentStepGUID, currentStepGUIDParameterName, methodName);
        List<Relationship> relationships = super.getAttachmentLinks(userId, currentStepGUID, currentStepGUIDParameterName, "Referenceable", "35450726-1c32-4d41-b928-22db6d1ae2f4", "ControlFlow", null, "Referenceable", 2, forLineage, forDuplicateProcessing, (List<String>)this.supportedZones, startFrom, pageSize, effectiveTime, methodName);
        ArrayList<CONTROL_FLOW> nextSteps = new ArrayList<CONTROL_FLOW>();
        if (relationships != null) {
            for (Relationship relationship : relationships) {
                if (relationship == null) continue;
                nextSteps.add(this.controlFlowConverter.getNewRelationshipBean(this.controlFlowBeanClass, relationship, methodName));
            }
        }
        if (nextSteps.isEmpty()) {
            nextSteps = null;
        }
        return nextSteps;
    }

    public List<CONTROL_FLOW> getControlFlowPreviousSteps(String userId, String currentStepGUID, String currentStepGUIDParameterName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(currentStepGUID, currentStepGUIDParameterName, methodName);
        List<Relationship> relationships = super.getAttachmentLinks(userId, currentStepGUID, currentStepGUIDParameterName, "Referenceable", "35450726-1c32-4d41-b928-22db6d1ae2f4", "ControlFlow", null, "Referenceable", 1, forLineage, forDuplicateProcessing, (List<String>)this.supportedZones, startFrom, pageSize, effectiveTime, methodName);
        ArrayList<CONTROL_FLOW> nextSteps = new ArrayList<CONTROL_FLOW>();
        if (relationships != null) {
            for (Relationship relationship : relationships) {
                if (relationship == null) continue;
                nextSteps.add(this.controlFlowConverter.getNewRelationshipBean(this.controlFlowBeanClass, relationship, methodName));
            }
        }
        if (nextSteps.isEmpty()) {
            nextSteps = null;
        }
        return nextSteps;
    }

    public String setupProcessCall(String userId, String externalSourceGUID, String externalSourceName, String callerGUID, String callerGUIDParameterName, String calledGUID, String calledGUIDParameterName, Date effectiveFrom, Date effectiveTo, String qualifiedName, String description, String formula, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(callerGUID, callerGUIDParameterName, methodName);
        this.invalidParameterHandler.validateGUID(calledGUID, calledGUIDParameterName, methodName);
        InstanceProperties relationshipProperties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, "qualifiedName", qualifiedName, methodName);
        relationshipProperties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, relationshipProperties, "description", description, methodName);
        relationshipProperties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, relationshipProperties, "formula", formula, methodName);
        return super.multiLinkElementToElement(userId, externalSourceGUID, externalSourceName, callerGUID, callerGUIDParameterName, "Referenceable", calledGUID, calledGUIDParameterName, "Referenceable", forLineage, forDuplicateProcessing, this.supportedZones, "af904501-6347-4f52-8378-da50e8d74828", "ProcessCall", this.setUpEffectiveDates(relationshipProperties, effectiveFrom, effectiveTo), effectiveTime, methodName);
    }

    public PROCESS_CALL getProcessCall(String userId, String callerGUID, String callerGUIDParameterName, String calledGUID, String calledGUIDParameterName, String qualifiedName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(callerGUID, callerGUIDParameterName, methodName);
        this.invalidParameterHandler.validateGUID(calledGUID, calledGUIDParameterName, methodName);
        List<Relationship> relationships = super.getAttachmentLinks(userId, callerGUID, callerGUIDParameterName, "Referenceable", "af904501-6347-4f52-8378-da50e8d74828", "ProcessCall", calledGUID, "Referenceable", 2, forLineage, forDuplicateProcessing, (List<String>)this.supportedZones, 0, 0, effectiveTime, methodName);
        if (relationships != null) {
            for (Relationship relationship : relationships) {
                if (relationship == null) continue;
                if (qualifiedName == null) {
                    return this.processCallConverter.getNewRelationshipBean(this.processCallBeanClass, relationship, methodName);
                }
                String relationshipQualifiedName = this.repositoryHelper.getStringProperty(this.serviceName, "qualifiedName", relationship.getProperties(), methodName);
                if (!qualifiedName.equals(relationshipQualifiedName)) continue;
                return this.processCallConverter.getNewRelationshipBean(this.processCallBeanClass, relationship, methodName);
            }
        }
        return null;
    }

    public void updateProcessCall(String userId, String externalSourceGUID, String externalSourceName, String processCallGUID, String processCallGUIDParameterName, Date effectiveFrom, Date effectiveTo, String qualifiedName, String description, String formula, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(processCallGUID, processCallGUIDParameterName, methodName);
        InstanceProperties properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, "qualifiedName", qualifiedName, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "description", description, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "formula", formula, methodName);
        super.updateRelationshipProperties(userId, externalSourceGUID, externalSourceName, processCallGUID, processCallGUIDParameterName, "ProcessCall", false, this.setUpEffectiveDates(properties, effectiveFrom, effectiveTo), forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void clearProcessCall(String userId, String externalSourceGUID, String externalSourceName, String processCallGUID, String processCallGUIDParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(processCallGUID, processCallGUIDParameterName, methodName);
        super.deleteRelationship(userId, externalSourceGUID, externalSourceName, processCallGUID, processCallGUIDParameterName, "ProcessCall", forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public List<PROCESS_CALL> getProcessCalled(String userId, String callerGUID, String callerGUIDParameterName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(callerGUID, callerGUIDParameterName, methodName);
        List<Relationship> relationships = super.getAttachmentLinks(userId, callerGUID, callerGUIDParameterName, "Referenceable", "af904501-6347-4f52-8378-da50e8d74828", "ProcessCall", null, "Referenceable", 2, forLineage, forDuplicateProcessing, (List<String>)this.supportedZones, startFrom, pageSize, effectiveTime, methodName);
        ArrayList<PROCESS_CALL> called = new ArrayList<PROCESS_CALL>();
        if (relationships != null) {
            for (Relationship relationship : relationships) {
                if (relationship == null) continue;
                called.add(this.processCallConverter.getNewRelationshipBean(this.processCallBeanClass, relationship, methodName));
            }
        }
        if (called.isEmpty()) {
            called = null;
        }
        return called;
    }

    public List<PROCESS_CALL> getProcessCallers(String userId, String calledGUID, String calledGUIDParameterName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(calledGUID, calledGUIDParameterName, methodName);
        List<Relationship> relationships = super.getAttachmentLinks(userId, calledGUID, calledGUIDParameterName, "Referenceable", "af904501-6347-4f52-8378-da50e8d74828", "ProcessCall", null, "Referenceable", 1, forLineage, forDuplicateProcessing, (List<String>)this.supportedZones, startFrom, pageSize, effectiveTime, methodName);
        ArrayList<PROCESS_CALL> caller = new ArrayList<PROCESS_CALL>();
        if (relationships != null) {
            for (Relationship relationship : relationships) {
                if (relationship == null) continue;
                caller.add(this.processCallConverter.getNewRelationshipBean(this.processCallBeanClass, relationship, methodName));
            }
        }
        if (caller.isEmpty()) {
            caller = null;
        }
        return caller;
    }

    public String setupLineageMapping(String userId, String sourceElementGUID, String sourceElementGUIDParameterName, String destinationElementGUID, String destinationElementGUIDParameterName, String qualifiedName, String description, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(sourceElementGUID, sourceElementGUIDParameterName, methodName);
        this.invalidParameterHandler.validateGUID(destinationElementGUID, destinationElementGUIDParameterName, methodName);
        InstanceProperties properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, "qualifiedName", qualifiedName, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "description", description, methodName);
        return super.multiLinkElementToElement(userId, null, null, sourceElementGUID, sourceElementGUIDParameterName, "Referenceable", destinationElementGUID, destinationElementGUIDParameterName, "Referenceable", forLineage, forDuplicateProcessing, this.supportedZones, "a5991bB2-660D-A3a1-2955-fAcDA2d5F4Ff", "LineageMapping", this.setUpEffectiveDates(properties, effectiveFrom, effectiveTo), effectiveTime, methodName);
    }

    public LINEAGE_MAPPING getLineageMapping(String userId, String sourceElementGUID, String sourceElementGUIDParameterName, String destinationElementGUID, String destinationElementGUIDParameterName, String qualifiedName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(sourceElementGUID, sourceElementGUIDParameterName, methodName);
        this.invalidParameterHandler.validateGUID(destinationElementGUID, destinationElementGUIDParameterName, methodName);
        List<Relationship> relationships = super.getAttachmentLinks(userId, sourceElementGUID, sourceElementGUIDParameterName, "Referenceable", "a5991bB2-660D-A3a1-2955-fAcDA2d5F4Ff", "LineageMapping", destinationElementGUID, "Referenceable", 2, forLineage, forDuplicateProcessing, (List<String>)this.supportedZones, 0, 0, effectiveTime, methodName);
        if (relationships != null) {
            for (Relationship relationship : relationships) {
                if (relationship == null) continue;
                if (qualifiedName == null) {
                    return this.lineageMappingConverter.getNewRelationshipBean(this.lineageMappingClass, relationship, methodName);
                }
                String relationshipQualifiedName = this.repositoryHelper.getStringProperty(this.serviceName, "qualifiedName", relationship.getProperties(), methodName);
                if (!qualifiedName.equals(relationshipQualifiedName)) continue;
                return this.lineageMappingConverter.getNewRelationshipBean(this.lineageMappingClass, relationship, methodName);
            }
        }
        return null;
    }

    public void updateLineageMapping(String userId, String lineageMappingGUID, String lineageMappingGUIDParameterName, String qualifiedName, String description, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(lineageMappingGUID, lineageMappingGUIDParameterName, methodName);
        InstanceProperties properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, "qualifiedName", qualifiedName, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "description", description, methodName);
        super.updateRelationshipProperties(userId, null, null, lineageMappingGUID, lineageMappingGUIDParameterName, "LineageMapping", false, this.setUpEffectiveDates(properties, effectiveFrom, effectiveTo), forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void clearLineageMapping(String userId, String lineageMappingGUID, String lineageMappingGUIDParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(lineageMappingGUID, lineageMappingGUIDParameterName, methodName);
        super.deleteRelationship(userId, null, null, lineageMappingGUID, lineageMappingGUIDParameterName, "LineageMapping", forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public List<LINEAGE_MAPPING> getDestinationLineageMappings(String userId, String sourceElementGUID, String sourceElementGUIDParameterName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(sourceElementGUID, sourceElementGUIDParameterName, methodName);
        List<Relationship> relationships = super.getAttachmentLinks(userId, sourceElementGUID, sourceElementGUIDParameterName, "Referenceable", "a5991bB2-660D-A3a1-2955-fAcDA2d5F4Ff", "LineageMapping", null, "Referenceable", 2, forLineage, forDuplicateProcessing, (List<String>)this.supportedZones, startFrom, pageSize, effectiveTime, methodName);
        ArrayList<LINEAGE_MAPPING> mappings = new ArrayList<LINEAGE_MAPPING>();
        if (relationships != null) {
            for (Relationship relationship : relationships) {
                if (relationship == null) continue;
                mappings.add(this.lineageMappingConverter.getNewRelationshipBean(this.lineageMappingClass, relationship, methodName));
            }
        }
        if (mappings.isEmpty()) {
            mappings = null;
        }
        return mappings;
    }

    public List<LINEAGE_MAPPING> getSourceLineageMappings(String userId, String destinationElementGUID, String destinationElementGUIDParameterName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(destinationElementGUID, destinationElementGUIDParameterName, methodName);
        List<Relationship> relationships = super.getAttachmentLinks(userId, destinationElementGUID, destinationElementGUIDParameterName, "Referenceable", "a5991bB2-660D-A3a1-2955-fAcDA2d5F4Ff", "LineageMapping", null, "Referenceable", 1, forLineage, forDuplicateProcessing, (List<String>)this.supportedZones, startFrom, pageSize, effectiveTime, methodName);
        ArrayList<LINEAGE_MAPPING> mappings = new ArrayList<LINEAGE_MAPPING>();
        if (relationships != null) {
            for (Relationship relationship : relationships) {
                if (relationship == null) continue;
                mappings.add(this.lineageMappingConverter.getNewRelationshipBean(this.lineageMappingClass, relationship, methodName));
            }
        }
        if (mappings.isEmpty()) {
            mappings = null;
        }
        return mappings;
    }
}

