/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.generichandlers.AssetHandler;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericConverter;
import org.odpi.openmetadata.commonservices.generichandlers.SchemaAttributeBuilder;
import org.odpi.openmetadata.commonservices.generichandlers.SchemaAttributeHandler;
import org.odpi.openmetadata.commonservices.generichandlers.SchemaTypeBuilder;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryErrorHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.OCFCheckedExceptionBase;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.metadatasecurity.server.OpenMetadataServerSecurityVerifier;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntitySummary;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.ClassificationErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeErrorException;

public class RelationalDataHandler<DATABASE, DATABASE_SCHEMA, DATABASE_TABLE, DATABASE_VIEW, DATABASE_COLUMN, SCHEMA_TYPE> {
    private final String serviceName;
    private final String serverName;
    private final OMRSRepositoryHelper repositoryHelper;
    private final InvalidParameterHandler invalidParameterHandler;
    private final AssetHandler<DATABASE> databaseHandler;
    private final AssetHandler<DATABASE_SCHEMA> databaseSchemaHandler;
    private final SchemaAttributeHandler<DATABASE_TABLE, SCHEMA_TYPE> databaseTableHandler;
    private final SchemaAttributeHandler<DATABASE_VIEW, SCHEMA_TYPE> databaseViewHandler;
    private final SchemaAttributeHandler<DATABASE_COLUMN, SCHEMA_TYPE> databaseColumnHandler;
    protected RepositoryErrorHandler errorHandler;

    public RelationalDataHandler(OpenMetadataAPIGenericConverter<DATABASE> databaseConverter, Class<DATABASE> databaseClass, OpenMetadataAPIGenericConverter<DATABASE_SCHEMA> databaseSchemaConverter, Class<DATABASE_SCHEMA> databaseSchemaClass, OpenMetadataAPIGenericConverter<DATABASE_TABLE> databaseTableConverter, Class<DATABASE_TABLE> databaseTableClass, OpenMetadataAPIGenericConverter<DATABASE_VIEW> databaseViewConverter, Class<DATABASE_VIEW> databaseViewClass, OpenMetadataAPIGenericConverter<DATABASE_COLUMN> databaseColumnConverter, Class<DATABASE_COLUMN> databaseColumnClass, OpenMetadataAPIGenericConverter<SCHEMA_TYPE> schemaTypeConverter, Class<SCHEMA_TYPE> schemaTypeClass, String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper, String localServerUserId, OpenMetadataServerSecurityVerifier securityVerifier, List<String> supportedZones, List<String> defaultZones, List<String> publishZones, AuditLog auditLog) {
        this.serviceName = serviceName;
        this.serverName = serverName;
        this.invalidParameterHandler = invalidParameterHandler;
        this.repositoryHelper = repositoryHelper;
        this.databaseHandler = new AssetHandler<DATABASE>(databaseConverter, databaseClass, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
        this.databaseSchemaHandler = new AssetHandler<DATABASE_SCHEMA>(databaseSchemaConverter, databaseSchemaClass, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
        this.databaseTableHandler = new SchemaAttributeHandler<DATABASE_TABLE, SCHEMA_TYPE>(databaseTableConverter, databaseTableClass, schemaTypeConverter, schemaTypeClass, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
        this.databaseViewHandler = new SchemaAttributeHandler<DATABASE_VIEW, SCHEMA_TYPE>(databaseViewConverter, databaseViewClass, schemaTypeConverter, schemaTypeClass, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
        this.databaseColumnHandler = new SchemaAttributeHandler<DATABASE_COLUMN, SCHEMA_TYPE>(databaseColumnConverter, databaseColumnClass, schemaTypeConverter, schemaTypeClass, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
        this.errorHandler = new RepositoryErrorHandler(repositoryHelper, serviceName, serverName, auditLog);
    }

    public String createDatabase(String userId, String databaseManagerGUID, String databaseManagerName, String qualifiedName, String technicalName, String versionIdentifier, String description, String owner, int ownerTypeOrdinal, List<String> zoneMembership, String originOrganizationGUID, String originBusinessCapabilityGUID, Map<String, String> otherOriginValues, String pathName, Date createTime, Date modifiedTime, String encodingType, String encodingLanguage, String encodingDescription, Map<String, String> encodingProperties, String databaseType, String databaseVersion, String databaseInstance, String databaseImportedFrom, Map<String, String> additionalProperties, String typeName, Map<String, Object> extendedProperties, Map<String, String> vendorProperties, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String databaseManagerGUIDParameterName = "databaseManagerGUID";
        String databaseGUIDParameterName = "databaseGUID";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        this.databaseHandler.verifyExternalSourceIdentity(userId, databaseManagerGUID, databaseManagerName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        String assetTypeName = "Database";
        if (typeName != null) {
            assetTypeName = typeName;
        }
        String assetTypeId = this.invalidParameterHandler.validateTypeName(assetTypeName, "Database", this.serviceName, methodName, this.repositoryHelper);
        HashMap<String, Object> assetExtendedProperties = new HashMap<String, Object>();
        if (extendedProperties != null) {
            assetExtendedProperties.putAll(extendedProperties);
        }
        assetExtendedProperties.put("pathName", pathName);
        assetExtendedProperties.put("storeCreateTime", createTime);
        assetExtendedProperties.put("storeUpdateTime", modifiedTime);
        assetExtendedProperties.put("deployedImplementationType", databaseType);
        assetExtendedProperties.put("databaseVersion", databaseVersion);
        assetExtendedProperties.put("instance", databaseInstance);
        assetExtendedProperties.put("importedFrom", databaseImportedFrom);
        String databaseGUID = this.databaseHandler.createAssetInRepository(userId, databaseManagerGUID, databaseManagerName, qualifiedName, technicalName, versionIdentifier, description, zoneMembership, owner, ownerTypeOrdinal, originOrganizationGUID, originBusinessCapabilityGUID, otherOriginValues, additionalProperties, assetTypeId, assetTypeName, assetExtendedProperties, effectiveFrom, effectiveTo, InstanceStatus.ACTIVE, effectiveFrom, methodName);
        if (databaseGUID != null) {
            if (encodingType != null || encodingLanguage != null || encodingDescription != null) {
                InstanceProperties classificationProperties = this.getEncodingProperties(encodingType, encodingLanguage, encodingDescription, encodingProperties, methodName);
                this.databaseHandler.setClassificationInRepository(userId, databaseManagerGUID, databaseManagerName, databaseGUID, "databaseGUID", "Database", "f08e48b5-6b66-40f5-8ff6-c2bfe527330b", "DataStoreEncoding", classificationProperties, true, forLineage, forDuplicateProcessing, effectiveTime, methodName);
            }
            this.databaseHandler.setVendorProperties(userId, databaseGUID, vendorProperties, forLineage, forDuplicateProcessing, effectiveTime, methodName);
            try {
                InstanceProperties relationshipProperties = this.repositoryHelper.addEnumPropertyToInstance(this.serviceName, null, "useType", "09439481-9489-467c-9ae5-178a6e0b6b5a", "ServerAssetUseType", 0, methodName);
                this.databaseHandler.linkElementToElement(userId, databaseManagerGUID, databaseManagerName, databaseManagerGUID, "databaseManagerGUID", "SoftwareCapability", databaseGUID, "databaseGUID", "Database", forLineage, forDuplicateProcessing, "56315447-88a6-4235-ba91-fead86524ebf", "ServerAssetUse", relationshipProperties, effectiveFrom, effectiveTo, effectiveTime, methodName);
            }
            catch (TypeErrorException error) {
                throw new org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException((OCFCheckedExceptionBase)error, "useType");
            }
        }
        return databaseGUID;
    }

    public String createDatabase(String userId, String databaseManagerGUID, String databaseManagerName, String qualifiedName, String name, String versionIdentifier, String description, String pathName, Date createTime, Date modifiedTime, String encodingType, String encodingLanguage, String encodingDescription, Map<String, String> encodingProperties, String databaseType, String databaseVersion, String databaseInstance, String databaseImportedFrom, Map<String, String> additionalProperties, String typeName, Map<String, Object> extendedProperties, Map<String, String> vendorProperties, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String databaseManagerGUIDParameterName = "databaseManagerGUID";
        String databaseGUIDParameterName = "databaseGUID";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        this.databaseHandler.verifyExternalSourceIdentity(userId, databaseManagerGUID, databaseManagerName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        String assetTypeName = "Database";
        if (typeName != null) {
            assetTypeName = typeName;
        }
        HashMap<String, Object> assetExtendedProperties = new HashMap<String, Object>();
        if (extendedProperties != null) {
            assetExtendedProperties.putAll(extendedProperties);
        }
        assetExtendedProperties.put("pathName", pathName);
        assetExtendedProperties.put("storeCreateTime", createTime);
        assetExtendedProperties.put("storeUpdateTime", modifiedTime);
        assetExtendedProperties.put("deployedImplementationType", databaseType);
        assetExtendedProperties.put("databaseVersion", databaseVersion);
        assetExtendedProperties.put("instance", databaseInstance);
        assetExtendedProperties.put("importedFrom", databaseImportedFrom);
        String databaseGUID = this.databaseHandler.createAssetInRepository(userId, databaseManagerGUID, databaseManagerName, qualifiedName, name, versionIdentifier, description, additionalProperties, assetTypeName, assetExtendedProperties, InstanceStatus.ACTIVE, effectiveFrom, effectiveTo, effectiveTime, methodName);
        if (databaseGUID != null) {
            if (encodingType != null || encodingLanguage != null || encodingDescription != null) {
                InstanceProperties classificationProperties = this.getEncodingProperties(encodingType, encodingLanguage, encodingDescription, encodingProperties, methodName);
                this.databaseHandler.setClassificationInRepository(userId, databaseManagerGUID, databaseManagerName, databaseGUID, "databaseGUID", "Database", "f08e48b5-6b66-40f5-8ff6-c2bfe527330b", "DataStoreEncoding", classificationProperties, true, forLineage, forDuplicateProcessing, effectiveTime, methodName);
            }
            this.databaseHandler.setVendorProperties(userId, databaseGUID, vendorProperties, forLineage, forDuplicateProcessing, effectiveTime, methodName);
            try {
                InstanceProperties relationshipProperties = this.repositoryHelper.addEnumPropertyToInstance(this.serviceName, null, "useType", "09439481-9489-467c-9ae5-178a6e0b6b5a", "ServerAssetUseType", 0, methodName);
                this.databaseHandler.linkElementToElement(userId, databaseManagerGUID, databaseManagerName, databaseManagerGUID, "databaseManagerGUID", "SoftwareCapability", databaseGUID, "databaseGUID", "Database", forLineage, forDuplicateProcessing, "56315447-88a6-4235-ba91-fead86524ebf", "ServerAssetUse", relationshipProperties, effectiveFrom, effectiveTo, effectiveTime, methodName);
            }
            catch (TypeErrorException error) {
                throw new org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException((OCFCheckedExceptionBase)error, "useType");
            }
        }
        return databaseGUID;
    }

    public String createDatabaseFromTemplate(String userId, String databaseManagerGUID, String databaseManagerName, String templateGUID, String qualifiedName, String technicalName, String versionIdentifier, String description, String pathName, String networkAddress, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String templateGUIDParameterName = "templateGUID";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(templateGUID, "templateGUID", methodName);
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        return this.databaseHandler.addAssetFromTemplate(userId, databaseManagerGUID, databaseManagerName, templateGUID, "templateGUID", "0921c83f-b2db-4086-a52c-0d10e52ca078", "Database", qualifiedName, "qualifiedName", technicalName, versionIdentifier, description, pathName, networkAddress, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void updateDatabase(String userId, String databaseManagerGUID, String databaseManagerName, String databaseGUID, String qualifiedName, String technicalName, String description, String owner, int ownerTypeOrdinal, List<String> zoneMembership, String originOrganizationGUID, String originBusinessCapabilityGUID, Map<String, String> otherOriginValues, Date createTime, Date modifiedTime, String encodingType, String encodingLanguage, String encodingDescription, Map<String, String> encodingProperties, String databaseType, String databaseVersion, String databaseInstance, String databaseImportedFrom, Map<String, String> additionalProperties, String typeName, Map<String, Object> extendedProperties, Map<String, String> vendorProperties, Date effectiveFrom, Date effectiveTo, boolean isMergeUpdate, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String elementGUIDParameterName = "databaseGUID";
        this.updateDatabase(userId, databaseManagerGUID, databaseManagerName, databaseGUID, qualifiedName, technicalName, null, description, null, createTime, modifiedTime, encodingType, encodingLanguage, encodingDescription, encodingProperties, databaseType, databaseVersion, databaseInstance, databaseImportedFrom, additionalProperties, typeName, extendedProperties, vendorProperties, effectiveFrom, effectiveTo, isMergeUpdate, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        this.updateGovernanceClassifications(userId, databaseGUID, "databaseGUID", owner, ownerTypeOrdinal, zoneMembership, originOrganizationGUID, originBusinessCapabilityGUID, otherOriginValues, effectiveFrom, effectiveTo, isMergeUpdate, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void updateGovernanceClassifications(String userId, String elementGUID, String elementGUIDParameterName, String owner, int ownerTypeOrdinal, List<String> zoneMembership, String originOrganizationGUID, String originBusinessCapabilityGUID, Map<String, String> otherOriginValues, Date effectiveFrom, Date effectiveTo, boolean isMergeUpdate, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        if (owner != null) {
            this.databaseHandler.updateAssetOwner(userId, elementGUID, elementGUIDParameterName, owner, ownerTypeOrdinal, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        }
        this.databaseHandler.updateAssetZones(userId, elementGUID, elementGUIDParameterName, zoneMembership, isMergeUpdate, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        if (originOrganizationGUID != null || originBusinessCapabilityGUID != null || otherOriginValues != null) {
            String organizationGUIDParameterName = "originOrganizationGUID";
            String businessCapabilityGUIDParameterName = "originBusinessCapabilityGUID";
            this.databaseHandler.addAssetOrigin(userId, elementGUID, elementGUIDParameterName, originOrganizationGUID, "originOrganizationGUID", originBusinessCapabilityGUID, "originBusinessCapabilityGUID", otherOriginValues, effectiveFrom, effectiveTo, isMergeUpdate, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        } else {
            this.databaseHandler.removeAssetOrigin(userId, elementGUID, elementGUIDParameterName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        }
    }

    public void updateDatabase(String userId, String databaseManagerGUID, String databaseManagerName, String databaseGUID, String qualifiedName, String technicalName, String versionIdentifier, String description, String pathName, Date createTime, Date modifiedTime, String encodingType, String encodingLanguage, String encodingDescription, Map<String, String> encodingProperties, String databaseType, String databaseVersion, String databaseInstance, String databaseImportedFrom, Map<String, String> additionalProperties, String typeName, Map<String, Object> extendedProperties, Map<String, String> vendorProperties, Date effectiveFrom, Date effectiveTo, boolean isMergeUpdate, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String elementGUIDParameterName = "databaseGUID";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(databaseGUID, "databaseGUID", methodName);
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        String assetTypeName = "Database";
        if (typeName != null) {
            assetTypeName = typeName;
        }
        String assetTypeId = this.invalidParameterHandler.validateTypeName(assetTypeName, "Database", this.serviceName, methodName, this.repositoryHelper);
        HashMap<String, Object> assetExtendedProperties = new HashMap<String, Object>();
        if (extendedProperties != null) {
            assetExtendedProperties.putAll(extendedProperties);
        }
        assetExtendedProperties.put("pathName", pathName);
        assetExtendedProperties.put("storeCreateTime", createTime);
        assetExtendedProperties.put("storeUpdateTime", modifiedTime);
        assetExtendedProperties.put("deployedImplementationType", databaseType);
        assetExtendedProperties.put("databaseVersion", databaseVersion);
        assetExtendedProperties.put("instance", databaseInstance);
        assetExtendedProperties.put("importedFrom", databaseImportedFrom);
        this.databaseHandler.updateAsset(userId, databaseManagerGUID, databaseManagerName, databaseGUID, "databaseGUID", qualifiedName, technicalName, versionIdentifier, description, additionalProperties, assetTypeId, assetTypeName, assetExtendedProperties, effectiveFrom, effectiveTo, isMergeUpdate, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        if (encodingType != null || encodingLanguage != null || encodingDescription != null) {
            InstanceProperties classificationProperties = this.getEncodingProperties(encodingType, encodingLanguage, encodingDescription, encodingProperties, methodName);
            this.databaseHandler.setClassificationInRepository(userId, databaseManagerGUID, databaseManagerName, databaseGUID, "databaseGUID", "Database", "f08e48b5-6b66-40f5-8ff6-c2bfe527330b", "DataStoreEncoding", classificationProperties, isMergeUpdate, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        }
        if (vendorProperties != null) {
            this.databaseHandler.setVendorProperties(userId, databaseGUID, vendorProperties, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        }
    }

    private InstanceProperties getEncodingProperties(String encodingType, String encodingLanguage, String encodingDescription, Map<String, String> encodingProperties, String methodName) {
        InstanceProperties classificationProperties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, "encoding", encodingType, methodName);
        classificationProperties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, classificationProperties, "language", encodingLanguage, methodName);
        classificationProperties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, classificationProperties, "description", encodingDescription, methodName);
        classificationProperties = this.repositoryHelper.addStringMapPropertyToInstance(this.serviceName, classificationProperties, "description", encodingProperties, methodName);
        return classificationProperties;
    }

    public void publishDatabase(String userId, String databaseGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String elementGUIDParameterName = "databaseGUID";
        this.databaseHandler.publishAsset(userId, databaseGUID, "databaseGUID", forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void withdrawDatabase(String userId, String databaseGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String elementGUIDParameterName = "databaseGUID";
        this.databaseHandler.withdrawAsset(userId, databaseGUID, "databaseGUID", forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void removeDatabase(String userId, String databaseManagerGUID, String databaseManagerName, String databaseGUID, String qualifiedName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String elementGUIDParameterName = "databaseGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(databaseGUID, "databaseGUID", methodName);
        this.databaseHandler.removeLinkedDataSets(userId, databaseManagerGUID, databaseManagerName, databaseGUID, "Database", forLineage, forDuplicateProcessing, effectiveTime, methodName);
        if (qualifiedName != null) {
            this.databaseHandler.deleteBeanInRepository(userId, databaseManagerGUID, databaseManagerName, databaseGUID, "databaseGUID", "0921c83f-b2db-4086-a52c-0d10e52ca078", "Database", "qualifiedName", qualifiedName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        } else {
            this.databaseHandler.deleteBeanInRepository(userId, databaseManagerGUID, databaseManagerName, databaseGUID, "databaseGUID", "0921c83f-b2db-4086-a52c-0d10e52ca078", "Database", null, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        }
    }

    public List<DATABASE> findDatabases(String userId, String searchString, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String searchStringParameterName = "searchString";
        return this.databaseHandler.findAssets(userId, "0921c83f-b2db-4086-a52c-0d10e52ca078", "Database", searchString, "searchString", startFrom, pageSize, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public List<DATABASE> getDatabases(String userId, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.databaseHandler.getBeansByType(userId, "0921c83f-b2db-4086-a52c-0d10e52ca078", "Database", null, startFrom, pageSize, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public List<DATABASE> getDatabasesByName(String userId, String name, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String nameParameterName = "name";
        return this.databaseHandler.getAssetsByName(userId, "0921c83f-b2db-4086-a52c-0d10e52ca078", "Database", name, "name", startFrom, pageSize, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public List<DATABASE> getDatabasesForDatabaseManager(String userId, String databaseManagerGUID, String databaseManagerName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String databaseManagerGUIDParameterName = "databaseManagerGUID";
        return this.databaseHandler.getAttachedElements(userId, databaseManagerGUID, "databaseManagerGUID", "DatabaseManager", "56315447-88a6-4235-ba91-fead86524ebf", "ServerAssetUse", "Database", null, null, 0, forLineage, forDuplicateProcessing, startFrom, pageSize, effectiveTime, methodName);
    }

    public DATABASE getDatabaseByGUID(String userId, String guid, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String guidParameterName = "guid";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(guid, "guid", methodName);
        return (DATABASE)this.databaseHandler.getBeanFromRepository(userId, guid, "guid", "Database", forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public String createDatabaseSchema(String userId, String databaseManagerGUID, String databaseManagerName, String databaseGUID, String qualifiedName, String technicalName, String versionIdentifier, String technicalDescription, Map<String, String> additionalProperties, String typeName, Map<String, Object> extendedProperties, Map<String, String> vendorProperties, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String parentElementGUIDParameterName = "databaseGUID";
        String createdElementGUIDParameterName = "databaseSchemaGUID";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        this.databaseSchemaHandler.verifyExternalSourceIdentity(userId, databaseManagerGUID, databaseManagerName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        String assetTypeName = "DeployedDatabaseSchema";
        if (typeName != null) {
            assetTypeName = typeName;
        }
        this.invalidParameterHandler.validateTypeName(assetTypeName, "DeployedDatabaseSchema", this.serviceName, methodName, this.repositoryHelper);
        String databaseSchemaGUID = this.databaseSchemaHandler.createAssetInRepository(userId, databaseManagerGUID, databaseManagerName, qualifiedName, technicalName, versionIdentifier, technicalDescription, additionalProperties, assetTypeName, extendedProperties, InstanceStatus.ACTIVE, effectiveFrom, effectiveTo, effectiveTime, methodName);
        if (databaseGUID != null) {
            this.databaseSchemaHandler.linkElementToElement(userId, databaseManagerGUID, databaseManagerName, databaseGUID, "databaseGUID", "Database", databaseSchemaGUID, "databaseSchemaGUID", "DeployedDatabaseSchema", forLineage, forDuplicateProcessing, "b827683c-2924-4df3-a92d-7be1888e23c0", "DataContentForDataSet", null, effectiveFrom, effectiveTo, effectiveTime, methodName);
            if (vendorProperties != null) {
                this.databaseHandler.setVendorProperties(userId, databaseSchemaGUID, vendorProperties, forLineage, forDuplicateProcessing, effectiveTime, methodName);
            }
        }
        return databaseSchemaGUID;
    }

    public String createDatabaseSchema(String userId, String databaseManagerGUID, String databaseManagerName, String databaseGUID, String qualifiedName, String technicalName, String versionIdentifier, String technicalDescription, String owner, int ownerTypeOrdinal, List<String> zoneMembership, String originOrganizationGUID, String originBusinessCapabilityGUID, Map<String, String> otherOriginValues, Map<String, String> additionalProperties, String typeName, Map<String, Object> extendedProperties, Map<String, String> vendorProperties, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String parentElementGUIDParameterName = "databaseGUID";
        String createdElementGUIDParameterName = "databaseSchemaGUID";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        this.databaseSchemaHandler.verifyExternalSourceIdentity(userId, databaseManagerGUID, databaseManagerName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        String assetTypeName = "DeployedDatabaseSchema";
        if (typeName != null) {
            assetTypeName = typeName;
        }
        String assetTypeId = this.invalidParameterHandler.validateTypeName(assetTypeName, "DeployedDatabaseSchema", this.serviceName, methodName, this.repositoryHelper);
        String databaseSchemaGUID = this.databaseSchemaHandler.createAssetInRepository(userId, databaseManagerGUID, databaseManagerName, qualifiedName, technicalName, versionIdentifier, technicalDescription, zoneMembership, owner, ownerTypeOrdinal, originOrganizationGUID, originBusinessCapabilityGUID, otherOriginValues, additionalProperties, assetTypeId, assetTypeName, extendedProperties, effectiveFrom, effectiveTo, InstanceStatus.ACTIVE, effectiveTime, methodName);
        if (databaseGUID != null) {
            this.databaseSchemaHandler.linkElementToElement(userId, databaseManagerGUID, databaseManagerName, databaseGUID, "databaseGUID", "Database", databaseSchemaGUID, "databaseSchemaGUID", "DeployedDatabaseSchema", forLineage, forDuplicateProcessing, "b827683c-2924-4df3-a92d-7be1888e23c0", "DataContentForDataSet", null, effectiveFrom, effectiveTo, effectiveTime, methodName);
            if (vendorProperties != null) {
                this.databaseHandler.setVendorProperties(userId, databaseSchemaGUID, vendorProperties, forLineage, forDuplicateProcessing, effectiveTime, methodName);
            }
        }
        return databaseSchemaGUID;
    }

    public String createDatabaseSchemaFromTemplate(String userId, String databaseManagerGUID, String databaseManagerName, String templateGUID, String databaseGUID, String qualifiedName, String technicalName, String versionIdentifier, String technicalDescription, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String templateGUIDParameterName = "templateGUID";
        String parentElementGUIDParameterName = "databaseGUID";
        String createdElementGUIDParameterName = "databaseSchemaGUID";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(templateGUID, "templateGUID", methodName);
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        String databaseSchemaGUID = this.databaseSchemaHandler.addAssetFromTemplate(userId, databaseManagerGUID, databaseManagerName, templateGUID, "templateGUID", "eab811ec-556a-45f1-9091-bc7ac8face0f", "DeployedDatabaseSchema", qualifiedName, "qualifiedName", technicalName, versionIdentifier, technicalDescription, null, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        if (databaseGUID != null) {
            this.databaseSchemaHandler.linkElementToElement(userId, databaseManagerGUID, databaseManagerName, databaseGUID, "databaseGUID", "Database", databaseSchemaGUID, "databaseSchemaGUID", "DeployedDatabaseSchema", forLineage, forDuplicateProcessing, "b827683c-2924-4df3-a92d-7be1888e23c0", "DataContentForDataSet", null, effectiveFrom, effectiveTo, effectiveTime, methodName);
        }
        return databaseSchemaGUID;
    }

    public void updateDatabaseSchema(String userId, String databaseManagerGUID, String databaseManagerName, String databaseSchemaGUID, String qualifiedName, String technicalName, String versionIdentifier, String description, String owner, int ownerTypeOrdinal, List<String> zoneMembership, String originOrganizationGUID, String originBusinessCapabilityGUID, Map<String, String> otherOriginValues, Map<String, String> additionalProperties, String typeName, Map<String, Object> extendedProperties, Map<String, String> vendorProperties, Date effectiveFrom, Date effectiveTo, boolean isMergeUpdate, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String elementGUIDParameterName = "databaseSchemaGUID";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(databaseSchemaGUID, "databaseSchemaGUID", methodName);
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        String assetTypeName = "DeployedDatabaseSchema";
        if (typeName != null) {
            assetTypeName = typeName;
        }
        String assetTypeId = this.invalidParameterHandler.validateTypeName(assetTypeName, "DeployedDatabaseSchema", this.serviceName, methodName, this.repositoryHelper);
        this.databaseSchemaHandler.updateAsset(userId, databaseManagerGUID, databaseManagerName, databaseSchemaGUID, "databaseSchemaGUID", qualifiedName, technicalName, versionIdentifier, description, additionalProperties, assetTypeId, assetTypeName, extendedProperties, effectiveFrom, effectiveTo, isMergeUpdate, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        this.updateGovernanceClassifications(userId, databaseSchemaGUID, "databaseSchemaGUID", owner, ownerTypeOrdinal, zoneMembership, originOrganizationGUID, originBusinessCapabilityGUID, otherOriginValues, effectiveFrom, effectiveTo, isMergeUpdate, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        if (vendorProperties != null) {
            this.databaseHandler.setVendorProperties(userId, databaseSchemaGUID, vendorProperties, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        }
    }

    public void publishDatabaseSchema(String userId, String databaseSchemaGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String elementGUIDParameterName = "databaseSchemaGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(databaseSchemaGUID, "databaseSchemaGUID", methodName);
        this.databaseSchemaHandler.publishAsset(userId, databaseSchemaGUID, "databaseSchemaGUID", forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void withdrawDatabaseSchema(String userId, String databaseSchemaGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String elementGUIDParameterName = "databaseSchemaGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(databaseSchemaGUID, "databaseSchemaGUID", methodName);
        this.databaseSchemaHandler.withdrawAsset(userId, databaseSchemaGUID, "databaseSchemaGUID", forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void removeDatabaseSchema(String userId, String databaseManagerGUID, String databaseManagerName, String databaseSchemaGUID, String qualifiedName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String elementGUIDParameterName = "databaseSchemaGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(databaseSchemaGUID, "databaseSchemaGUID", methodName);
        if (qualifiedName != null) {
            this.databaseSchemaHandler.deleteBeanInRepository(userId, databaseManagerGUID, databaseManagerName, databaseSchemaGUID, "databaseSchemaGUID", "eab811ec-556a-45f1-9091-bc7ac8face0f", "DeployedDatabaseSchema", "qualifiedName", qualifiedName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        } else {
            this.databaseSchemaHandler.deleteBeanInRepository(userId, databaseManagerGUID, databaseManagerName, databaseSchemaGUID, "databaseSchemaGUID", "eab811ec-556a-45f1-9091-bc7ac8face0f", "DeployedDatabaseSchema", null, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        }
    }

    public List<DATABASE_SCHEMA> findDatabaseSchemas(String userId, String searchString, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String searchStringParameterName = "searchString";
        return this.databaseSchemaHandler.findAssets(userId, "eab811ec-556a-45f1-9091-bc7ac8face0f", "DeployedDatabaseSchema", searchString, "searchString", startFrom, pageSize, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public List<DATABASE_SCHEMA> getSchemasForDatabase(String userId, String databaseGUID, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String parentElementGUIDParameterName = "databaseGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(databaseGUID, "databaseGUID", methodName);
        return this.databaseSchemaHandler.getAttachedElements(userId, databaseGUID, "databaseGUID", "Database", "b827683c-2924-4df3-a92d-7be1888e23c0", "DataContentForDataSet", "DeployedDatabaseSchema", null, null, 0, forLineage, forDuplicateProcessing, startFrom, pageSize, effectiveTime, methodName);
    }

    public List<DATABASE_SCHEMA> getDatabaseSchemasByName(String userId, String name, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String nameParameterName = "name";
        return this.databaseSchemaHandler.getAssetsByName(userId, "eab811ec-556a-45f1-9091-bc7ac8face0f", "DeployedDatabaseSchema", name, "name", startFrom, pageSize, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public DATABASE_SCHEMA getDatabaseSchemaByGUID(String userId, String guid, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String guidParameterName = "guid";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(guid, "guid", methodName);
        return (DATABASE_SCHEMA)this.databaseSchemaHandler.getBeanFromRepository(userId, guid, "guid", "DeployedDatabaseSchema", forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public String createDatabaseSchemaType(String userId, String databaseManagerGUID, String databaseManagerName, String qualifiedName, Date effectiveFrom, Date effectiveTo, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        SchemaTypeBuilder builder = new SchemaTypeBuilder(qualifiedName, "f20f5f45-1afb-41c1-9a09-34d8812626a4", "RelationalDBSchemaType", this.repositoryHelper, this.serviceName, this.serverName);
        builder.setEffectivityDates(effectiveFrom, effectiveTo);
        return this.databaseTableHandler.createBeanInRepository(userId, databaseManagerGUID, databaseManagerName, "f20f5f45-1afb-41c1-9a09-34d8812626a4", "RelationalDBSchemaType", builder, effectiveTime, methodName);
    }

    public void attachSchemaTypeToDatabaseAsset(String userId, String databaseManagerGUID, String databaseManagerName, String databaseAssetGUID, String schemaTypeGUID, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String databaseAssetGUIDParameterName = "databaseAssetGUID";
        String schemaTypeGUIDParameterName = "schemaTypeGUID";
        this.databaseHandler.attachSchemaTypeToAsset(userId, databaseManagerGUID, databaseManagerName, databaseAssetGUID, "databaseAssetGUID", schemaTypeGUID, "schemaTypeGUID", effectiveFrom, effectiveTo, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    @Deprecated
    public String createDatabaseTable(String userId, String databaseManagerGUID, String databaseManagerName, String databaseAssetGUID, String qualifiedName, String displayName, String description, boolean isDeprecated, List<String> aliases, Map<String, String> additionalProperties, String typeName, Map<String, Object> extendedProperties, Map<String, String> vendorProperties, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.createDatabaseTable(userId, databaseManagerGUID, databaseManagerName, databaseAssetGUID, qualifiedName, displayName, description, isDeprecated, aliases, additionalProperties, typeName, extendedProperties, vendorProperties, null, null, false, false, new Date(), methodName);
    }

    public String createDatabaseTable(String userId, String databaseManagerGUID, String databaseManagerName, String databaseAssetGUID, String qualifiedName, String displayName, String description, boolean isDeprecated, List<String> aliases, Map<String, String> additionalProperties, String typeName, Map<String, Object> extendedProperties, Map<String, String> vendorProperties, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String parentElementGUIDParameterName = "databaseAssetGUID";
        String databaseSchemaTypeGUID = this.databaseTableHandler.getAssetSchemaTypeGUID(userId, databaseManagerGUID, databaseManagerName, databaseAssetGUID, "databaseAssetGUID", "Asset", "f20f5f45-1afb-41c1-9a09-34d8812626a4", "RelationalDBSchemaType", effectiveFrom, effectiveTo, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        return this.createDatabaseTableForSchemaType(userId, databaseManagerGUID, databaseManagerName, databaseSchemaTypeGUID, qualifiedName, displayName, description, isDeprecated, aliases, additionalProperties, typeName, extendedProperties, vendorProperties, effectiveFrom, effectiveTo, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public String createDatabaseTableForSchemaType(String userId, String databaseManagerGUID, String databaseManagerName, String databaseSchemaTypeGUID, String qualifiedName, String displayName, String description, boolean isDeprecated, List<String> aliases, Map<String, String> additionalProperties, String typeName, Map<String, Object> extendedProperties, Map<String, String> vendorProperties, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String schemaTypeGUIDParameterName = "databaseSchemaTypeGUID";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateGUID(databaseSchemaTypeGUID, "databaseSchemaTypeGUID", methodName);
        String attributeTypeName = "RelationalTable";
        String attributeTypeId = "ce7e72b8-396a-4013-8688-f9d973067425";
        if (typeName != null) {
            attributeTypeName = typeName;
            attributeTypeId = this.invalidParameterHandler.validateTypeName(typeName, "RelationalTable", this.serviceName, methodName, this.repositoryHelper);
        }
        SchemaAttributeBuilder schemaAttributeBuilder = new SchemaAttributeBuilder(qualifiedName, displayName, description, 0, 1, 1, isDeprecated, null, true, false, 0, 0, 0, 0, false, null, aliases, additionalProperties, attributeTypeId, attributeTypeName, extendedProperties, this.repositoryHelper, this.serviceName, this.serverName);
        schemaAttributeBuilder.setAnchors(userId, databaseSchemaTypeGUID, methodName);
        SchemaTypeBuilder schemaTypeBuilder = new SchemaTypeBuilder(qualifiedName + ":tableType", "1321bcc0-dc6a-48ed-9ca6-0c6f934b0b98", "RelationalTableType", this.repositoryHelper, this.serviceName, this.serverName);
        schemaAttributeBuilder.setSchemaType(userId, schemaTypeBuilder, methodName);
        schemaAttributeBuilder.setEffectivityDates(effectiveFrom, effectiveTo);
        String databaseTableGUID = this.databaseTableHandler.createNestedSchemaAttribute(userId, databaseManagerGUID, databaseManagerName, databaseSchemaTypeGUID, "databaseSchemaTypeGUID", "RelationalDBSchemaType", "86b176a2-015c-44a6-8106-54d5d69ba661", "AttributeForSchema", qualifiedName, "qualifiedName", schemaAttributeBuilder, effectiveFrom, effectiveTo, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        if (databaseTableGUID != null) {
            this.databaseHandler.setVendorProperties(userId, databaseTableGUID, vendorProperties, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        }
        return databaseTableGUID;
    }

    public String createDatabaseTableFromTemplate(String userId, String databaseManagerGUID, String databaseManagerName, String templateGUID, String databaseAssetGUID, String qualifiedName, String technicalName, String description, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String guidParameterName = "databaseAssetGUID";
        String parentElementGUIDParameterName = "databaseAssetGUID";
        String templateParameterName = "templateGUID";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateGUID(databaseAssetGUID, "databaseAssetGUID", methodName);
        this.invalidParameterHandler.validateGUID(templateGUID, "templateGUID", methodName);
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        String databaseSchemaTypeGUID = this.databaseTableHandler.getAssetSchemaTypeGUID(userId, databaseManagerGUID, databaseManagerName, databaseAssetGUID, "databaseAssetGUID", "Asset", "f20f5f45-1afb-41c1-9a09-34d8812626a4", "RelationalDBSchemaType", effectiveFrom, effectiveTo, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        if (databaseSchemaTypeGUID != null) {
            SchemaAttributeBuilder builder = new SchemaAttributeBuilder(qualifiedName, technicalName, description, this.repositoryHelper, this.serviceName, this.serverName);
            builder.setAnchors(userId, databaseAssetGUID, methodName);
            String databaseTableGUID = this.databaseTableHandler.createBeanFromTemplate(userId, databaseManagerGUID, databaseManagerName, templateGUID, "templateGUID", "ce7e72b8-396a-4013-8688-f9d973067425", "RelationalTable", qualifiedName, "qualifiedName", builder, methodName);
            if (databaseTableGUID != null) {
                String databaseSchemaTypeGUIDParameterName = "databaseSchemaTypeGUID";
                String databaseTableGUIDParameterName = "databaseTableGUID";
                this.databaseTableHandler.linkElementToElement(userId, databaseManagerGUID, databaseManagerName, databaseSchemaTypeGUID, "databaseSchemaTypeGUID", "RelationalDBSchemaType", databaseTableGUID, "databaseTableGUID", "RelationalTable", forLineage, forDuplicateProcessing, "86b176a2-015c-44a6-8106-54d5d69ba661", "AttributeForSchema", null, effectiveFrom, effectiveTo, effectiveTime, methodName);
                return databaseTableGUID;
            }
        }
        return null;
    }

    public void updateDatabaseTable(String userId, String databaseManagerGUID, String databaseManagerName, String databaseTableGUID, String qualifiedName, String displayName, String description, boolean isDeprecated, List<String> aliases, Map<String, String> additionalProperties, String typeName, Map<String, Object> extendedProperties, Map<String, String> vendorProperties, Date effectiveFrom, Date effectiveTo, boolean isMergeUpdate, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String elementGUIDParameterName = "databaseTableGUID";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(databaseTableGUID, "databaseTableGUID", methodName);
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        String attributeTypeName = "RelationalTable";
        String attributeTypeId = "ce7e72b8-396a-4013-8688-f9d973067425";
        if (typeName != null) {
            attributeTypeName = typeName;
            attributeTypeId = this.invalidParameterHandler.validateTypeName(typeName, "RelationalTable", this.serviceName, methodName, this.repositoryHelper);
        }
        InstanceProperties properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, "qualifiedName", qualifiedName, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "displayName", displayName, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "description", description, methodName);
        properties = this.repositoryHelper.addBooleanPropertyToInstance(this.serviceName, properties, "isDeprecated", isDeprecated, methodName);
        properties = this.repositoryHelper.addStringArrayPropertyToInstance(this.serviceName, properties, "aliases", aliases, methodName);
        properties = this.repositoryHelper.addStringMapPropertyToInstance(this.serviceName, properties, "additionalProperties", additionalProperties, methodName);
        if (extendedProperties != null) {
            try {
                properties = this.repositoryHelper.addPropertyMapToInstance(this.serviceName, null, extendedProperties, methodName);
            }
            catch (InvalidParameterException error) {
                String propertyName = "extendedProperties";
                this.errorHandler.handleUnsupportedProperty((Exception)((Object)error), methodName, "extendedProperties");
            }
        }
        this.databaseTableHandler.updateBeanInRepository(userId, databaseManagerGUID, databaseManagerName, databaseTableGUID, "databaseTableGUID", attributeTypeId, attributeTypeName, forLineage, forDuplicateProcessing, this.databaseTableHandler.setUpEffectiveDates(properties, effectiveFrom, effectiveTo), isMergeUpdate, effectiveTime, methodName);
        this.databaseHandler.setVendorProperties(userId, databaseTableGUID, vendorProperties, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void removeDatabaseTable(String userId, String databaseManagerGUID, String databaseManagerName, String databaseTableGUID, String databaseTableGUIDParameterName, String qualifiedName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        if (qualifiedName != null) {
            this.databaseTableHandler.deleteBeanInRepository(userId, databaseManagerGUID, databaseManagerName, databaseTableGUID, databaseTableGUIDParameterName, "ce7e72b8-396a-4013-8688-f9d973067425", "RelationalTable", "qualifiedName", qualifiedName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        } else {
            this.databaseTableHandler.deleteBeanInRepository(userId, databaseManagerGUID, databaseManagerName, databaseTableGUID, databaseTableGUIDParameterName, "ce7e72b8-396a-4013-8688-f9d973067425", "RelationalTable", null, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        }
    }

    public List<DATABASE_TABLE> findDatabaseTables(String userId, String searchString, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String searchStringParameterName = "searchString";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateSearchString(searchString, "searchString", methodName);
        return this.databaseTableHandler.findSchemaAttributes(userId, searchString, "searchString", "ce7e72b8-396a-4013-8688-f9d973067425", "RelationalTable", null, "CalculatedValue", startFrom, pageSize, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public List<DATABASE_TABLE> getTablesForDatabaseAsset(String userId, String databaseAssetGUID, int startFrom, int pageSize, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String parentElementGUIDParameterName = "databaseAssetGUID";
        String databaseSchemaTypeGUID = this.databaseTableHandler.getAssetSchemaTypeGUID(userId, null, null, databaseAssetGUID, "databaseAssetGUID", "Asset", "f20f5f45-1afb-41c1-9a09-34d8812626a4", "RelationalDBSchemaType", effectiveFrom, effectiveTo, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        if (databaseSchemaTypeGUID != null) {
            String databaseSchemaTypeGUIDParameterName = "databaseSchemaTypeGUID";
            return this.databaseTableHandler.getSchemaAttributesForComplexSchemaType(userId, databaseSchemaTypeGUID, "databaseSchemaTypeGUID", null, "CalculatedValue", startFrom, pageSize, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        }
        return null;
    }

    public List<DATABASE_TABLE> getDatabaseTablesByName(String userId, String name, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.databaseTableHandler.getSchemaAttributesByName(userId, "ce7e72b8-396a-4013-8688-f9d973067425", "RelationalTable", name, null, "CalculatedValue", startFrom, pageSize, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public DATABASE_TABLE getDatabaseTableByGUID(String userId, String guid, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String guidParameterName = "guid";
        return this.databaseTableHandler.getSchemaAttribute(userId, guid, "guid", "RelationalTable", null, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public String createDatabaseView(String userId, String databaseManagerGUID, String databaseManagerName, String databaseAssetGUID, String qualifiedName, String displayName, String description, boolean isDeprecated, List<String> aliases, String expression, Map<String, String> additionalProperties, String typeName, Map<String, Object> extendedProperties, Map<String, String> vendorProperties, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String parentElementGUIDParameterName = "databaseAssetGUID";
        String databaseSchemaTypeGUID = this.databaseViewHandler.getAssetSchemaTypeGUID(userId, databaseManagerGUID, databaseManagerName, databaseAssetGUID, "databaseAssetGUID", "Asset", "f20f5f45-1afb-41c1-9a09-34d8812626a4", "RelationalDBSchemaType", effectiveFrom, effectiveTo, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        return this.createDatabaseViewForSchemaType(userId, databaseManagerGUID, databaseManagerName, databaseSchemaTypeGUID, qualifiedName, displayName, description, isDeprecated, aliases, expression, additionalProperties, typeName, extendedProperties, vendorProperties, effectiveFrom, effectiveTo, forDuplicateProcessing, forLineage, effectiveTime, methodName);
    }

    public String createDatabaseViewForSchemaType(String userId, String databaseManagerGUID, String databaseManagerName, String databaseSchemaTypeGUID, String qualifiedName, String displayName, String description, boolean isDeprecated, List<String> aliases, String expression, Map<String, String> additionalProperties, String typeName, Map<String, Object> extendedProperties, Map<String, String> vendorProperties, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String schemaTypeGUIDParameterName = "databaseSchemaTypeGUID";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateGUID(databaseSchemaTypeGUID, "databaseSchemaTypeGUID", methodName);
        String attributeTypeName = "RelationalTable";
        String attributeTypeId = "ce7e72b8-396a-4013-8688-f9d973067425";
        if (typeName != null) {
            attributeTypeName = typeName;
            attributeTypeId = this.invalidParameterHandler.validateTypeName(typeName, "RelationalTable", this.serviceName, methodName, this.repositoryHelper);
        }
        int tableCount = this.databaseViewHandler.countSchemaAttributes(userId, databaseSchemaTypeGUID, "databaseSchemaTypeGUID", effectiveTime, methodName);
        SchemaAttributeBuilder schemaAttributeBuilder = new SchemaAttributeBuilder(qualifiedName, displayName, description, tableCount, 1, 1, isDeprecated, null, true, false, 0, 0, 0, 0, false, null, aliases, additionalProperties, attributeTypeId, attributeTypeName, extendedProperties, this.repositoryHelper, this.serviceName, this.serverName);
        schemaAttributeBuilder.setAnchors(userId, databaseSchemaTypeGUID, methodName);
        SchemaTypeBuilder schemaTypeBuilder = new SchemaTypeBuilder(qualifiedName + ":viewType", "1321bcc0-dc6a-48ed-9ca6-0c6f934b0b98", "RelationalTableType", this.repositoryHelper, this.serviceName, this.serverName);
        schemaAttributeBuilder.setSchemaType(userId, schemaTypeBuilder, methodName);
        schemaAttributeBuilder.setEffectivityDates(effectiveFrom, effectiveTo);
        schemaAttributeBuilder.setCalculatedValue(userId, databaseManagerGUID, databaseManagerName, expression, methodName);
        String databaseViewGUID = this.databaseViewHandler.createNestedSchemaAttribute(userId, databaseManagerGUID, databaseManagerName, databaseSchemaTypeGUID, "databaseSchemaTypeGUID", "RelationalDBSchemaType", "86b176a2-015c-44a6-8106-54d5d69ba661", "AttributeForSchema", qualifiedName, "qualifiedName", schemaAttributeBuilder, effectiveFrom, effectiveTo, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        if (databaseViewGUID != null) {
            this.databaseViewHandler.setVendorProperties(userId, databaseViewGUID, vendorProperties, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        }
        return databaseViewGUID;
    }

    public String createDatabaseViewFromTemplate(String userId, String databaseManagerGUID, String databaseManagerName, String templateGUID, String databaseAssetGUID, String qualifiedName, String displayName, String description, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.createDatabaseTableFromTemplate(userId, databaseManagerGUID, databaseManagerName, templateGUID, databaseAssetGUID, qualifiedName, displayName, description, effectiveFrom, effectiveTo, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void updateDatabaseView(String userId, String databaseManagerGUID, String databaseManagerName, String databaseViewGUID, String qualifiedName, String displayName, String description, boolean isDeprecated, List<String> aliases, String expression, Map<String, String> additionalProperties, String typeName, Map<String, Object> extendedProperties, Map<String, String> vendorProperties, Date effectiveFrom, Date effectiveTo, boolean isMergeUpdate, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String elementGUIDParameterName = "databaseViewGUID";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(databaseViewGUID, "databaseViewGUID", methodName);
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        String expectedTypeName = "RelationalTable";
        if (typeName != null) {
            expectedTypeName = typeName;
        }
        this.updateDatabaseTable(userId, databaseManagerGUID, databaseManagerName, databaseViewGUID, qualifiedName, displayName, description, isDeprecated, aliases, additionalProperties, typeName, extendedProperties, vendorProperties, effectiveFrom, effectiveTo, isMergeUpdate, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        InstanceProperties properties = null;
        if (expression != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, "formula", expression, methodName);
        }
        this.databaseViewHandler.setClassificationInRepository(userId, databaseManagerGUID, databaseManagerName, databaseViewGUID, "databaseViewGUID", expectedTypeName, "4814bec8-482d-463d-8376-160b0358e139", "CalculatedValue", properties, isMergeUpdate, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public List<DATABASE_VIEW> findDatabaseViews(String userId, String searchString, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String searchStringParameterName = "searchString";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateSearchString(searchString, "searchString", methodName);
        return this.databaseViewHandler.findSchemaAttributes(userId, searchString, "searchString", "ce7e72b8-396a-4013-8688-f9d973067425", "RelationalTable", "CalculatedValue", null, startFrom, pageSize, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public List<DATABASE_VIEW> getViewsForDatabaseAsset(String userId, String databaseAssetGUID, int startFrom, int pageSize, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String parentElementGUIDParameterName = "databaseAssetGUID";
        String databaseSchemaTypeGUID = this.databaseViewHandler.getAssetSchemaTypeGUID(userId, null, null, databaseAssetGUID, "databaseAssetGUID", "Asset", "f20f5f45-1afb-41c1-9a09-34d8812626a4", "RelationalDBSchemaType", effectiveFrom, effectiveTo, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        if (databaseSchemaTypeGUID != null) {
            String databaseSchemaTypeGUIDParameterName = "databaseSchemaTypeGUID";
            return this.databaseViewHandler.getSchemaAttributesForComplexSchemaType(userId, databaseSchemaTypeGUID, "databaseSchemaTypeGUID", "CalculatedValue", null, startFrom, pageSize, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        }
        return null;
    }

    public List<DATABASE_VIEW> getDatabaseViewsByName(String userId, String name, String nameParameterName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateName(name, nameParameterName, methodName);
        return this.databaseViewHandler.getSchemaAttributesByName(userId, "ce7e72b8-396a-4013-8688-f9d973067425", "RelationalTable", name, "CalculatedValue", null, startFrom, pageSize, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public DATABASE_VIEW getDatabaseViewByGUID(String userId, String guid, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String guidParameterName = "guid";
        return this.databaseViewHandler.getSchemaAttribute(userId, guid, "guid", "RelationalTable", null, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    @Deprecated
    public String createDatabaseColumn(String userId, String databaseManagerGUID, String databaseManagerName, String databaseTableGUID, String qualifiedName, String displayName, String description, String externalSchemaTypeGUID, String dataType, String defaultValue, String fixedValue, String validValuesSetGUID, String formula, boolean isDeprecated, int elementPosition, int minCardinality, int maxCardinality, boolean allowsDuplicateValues, boolean orderedValues, String defaultValueOverride, int sortOrder, int minimumLength, int length, int significantDigits, boolean isNullable, String nativeJavaClass, List<String> aliases, Map<String, String> additionalProperties, String typeName, Map<String, Object> extendedProperties, Map<String, String> vendorProperties, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.createDatabaseColumn(userId, databaseManagerGUID, databaseManagerName, databaseTableGUID, qualifiedName, displayName, description, externalSchemaTypeGUID, dataType, defaultValue, fixedValue, validValuesSetGUID, formula, isDeprecated, elementPosition, minCardinality, maxCardinality, allowsDuplicateValues, orderedValues, defaultValueOverride, sortOrder, minimumLength, length, significantDigits, isNullable, nativeJavaClass, aliases, additionalProperties, typeName, extendedProperties, vendorProperties, null, null, false, false, new Date(), methodName);
    }

    public String createDatabaseColumn(String userId, String databaseManagerGUID, String databaseManagerName, String databaseTableGUID, String qualifiedName, String displayName, String description, String externalSchemaTypeGUID, String dataType, String defaultValue, String fixedValue, String validValuesSetGUID, String formula, boolean isDeprecated, int elementPosition, int minCardinality, int maxCardinality, boolean allowsDuplicateValues, boolean orderedValues, String defaultValueOverride, int sortOrder, int minimumLength, int length, int significantDigits, boolean isNullable, String nativeJavaClass, List<String> aliases, Map<String, String> additionalProperties, String typeName, Map<String, Object> extendedProperties, Map<String, String> vendorProperties, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        EntityDetail databaseTableEntity;
        String databaseTableGUIDParameterName = "databaseTableGUID";
        String qualifiedNameParameterName = "qualifiedName";
        String dataTypeParameterName = "dataType";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(databaseTableGUID, "databaseTableGUID", methodName);
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        if (externalSchemaTypeGUID == null) {
            this.invalidParameterHandler.validateName(dataType, "dataType", methodName);
        }
        if ((databaseTableEntity = this.databaseColumnHandler.getEntityFromRepository(userId, databaseTableGUID, "databaseTableGUID", "RelationalTable", null, null, forLineage, forDuplicateProcessing, effectiveTime, methodName)) != null) {
            String databaseColumnGUID;
            String attributeTypeName = "RelationalColumn";
            String attributeTypeId = "aa8d5470-6dbc-4648-9e2f-045e5df9d2f9";
            if (typeName != null) {
                attributeTypeName = typeName;
                attributeTypeId = this.invalidParameterHandler.validateTypeName(typeName, "RelationalColumn", this.serviceName, methodName, this.repositoryHelper);
            }
            SchemaAttributeBuilder schemaAttributeBuilder = new SchemaAttributeBuilder(qualifiedName, displayName, description, elementPosition, minCardinality, maxCardinality, isDeprecated, defaultValueOverride, allowsDuplicateValues, orderedValues, sortOrder, minimumLength, length, significantDigits, isNullable, nativeJavaClass, aliases, additionalProperties, attributeTypeId, attributeTypeName, extendedProperties, this.repositoryHelper, this.serviceName, this.serverName);
            String anchorGUID = this.databaseColumnHandler.getAnchorGUIDFromAnchorsClassification(databaseTableEntity, methodName);
            if (anchorGUID != null) {
                schemaAttributeBuilder.setAnchors(userId, anchorGUID, methodName);
            }
            String parentTypeName = "RelationalTableType";
            String parentAttachmentTypeGUID = "86b176a2-015c-44a6-8106-54d5d69ba661";
            String parentAttachmentTypeName = "AttributeForSchema";
            String parentGUID = this.databaseColumnHandler.getAttachedElementGUID(userId, databaseTableGUID, "databaseTableGUID", "RelationalTable", "2d955049-e59b-45dd-8e62-cde1add59f9e", "SchemaAttributeType", "SchemaType", 2, forLineage, forDuplicateProcessing, effectiveTime, methodName);
            if (parentGUID == null) {
                try {
                    Classification typeClassification = this.repositoryHelper.getClassificationFromEntity(this.serviceName, (EntitySummary)databaseTableEntity, "TypeEmbeddedAttribute", methodName);
                    if (typeClassification != null) {
                        parentGUID = databaseTableGUID;
                        parentTypeName = "RelationalTable";
                        parentAttachmentTypeGUID = "0ffb9d87-7074-45da-a9b0-ae0859611133";
                        parentAttachmentTypeName = "NestedSchemaAttribute";
                    }
                }
                catch (ClassificationErrorException typeClassification) {
                    // empty catch block
                }
            }
            if (parentGUID == null) {
                this.invalidParameterHandler.throwUnknownElement(userId, databaseTableGUID, "RelationalTableType", this.serviceName, this.serverName, methodName);
                return null;
            }
            SchemaTypeBuilder schemaTypeBuilder = this.databaseColumnHandler.getSchemaTypeBuilder(qualifiedName, externalSchemaTypeGUID, dataType, defaultValue, fixedValue, validValuesSetGUID);
            schemaAttributeBuilder.setSchemaType(userId, schemaTypeBuilder, methodName);
            schemaAttributeBuilder.setEffectivityDates(effectiveFrom, effectiveTo);
            if (formula != null) {
                schemaAttributeBuilder.setCalculatedValue(userId, databaseManagerGUID, databaseManagerName, formula, methodName);
            }
            if ((databaseColumnGUID = this.databaseColumnHandler.createBeanInRepository(userId, databaseManagerGUID, databaseManagerName, "aa8d5470-6dbc-4648-9e2f-045e5df9d2f9", "RelationalColumn", schemaAttributeBuilder, effectiveTime, methodName)) != null) {
                String databaseColumnGUIDParameterName = "databaseColumnGUID";
                this.databaseColumnHandler.linkElementToElement(userId, databaseManagerGUID, databaseManagerName, parentGUID, "databaseTableGUID", parentTypeName, databaseColumnGUID, "databaseColumnGUID", "RelationalColumn", forLineage, forDuplicateProcessing, parentAttachmentTypeGUID, parentAttachmentTypeName, null, effectiveFrom, effectiveTo, effectiveTime, methodName);
                this.databaseColumnHandler.setVendorProperties(userId, databaseColumnGUID, vendorProperties, forLineage, forDuplicateProcessing, effectiveTime, methodName);
                return databaseColumnGUID;
            }
            return null;
        }
        this.invalidParameterHandler.throwUnknownElement(userId, databaseTableGUID, "RelationalTable", this.serviceName, this.serverName, methodName);
        return null;
    }

    public void createDatabaseColumnQuery(String userId, String databaseManagerGUID, String databaseManagerName, String databaseColumnGUID, String queryId, String query, String queryTargetGUID, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String parentElementGUIDParameterName = "databaseColumnGUID";
        String targetElementGUIDParameterName = "queryTargetGUID";
        String queryParameterName = "query";
        this.invalidParameterHandler.validateObject((Object)query, "query", methodName);
        InstanceProperties properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, "query", query, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "queryId", queryId, methodName);
        this.databaseColumnHandler.linkElementToElement(userId, databaseManagerGUID, databaseManagerName, databaseColumnGUID, "databaseColumnGUID", "RelationalColumn", queryTargetGUID, "queryTargetGUID", "SchemaElement", forLineage, forDuplicateProcessing, "1c2622b7-ac21-413c-89e1-6f61f348cd19", "DerivedSchemaTypeQueryTarget", properties, effectiveFrom, effectiveTo, effectiveTime, methodName);
    }

    public String createDatabaseColumnFromTemplate(String userId, String databaseManagerGUID, String databaseManagerName, String templateGUID, String databaseTableGUID, String qualifiedName, String displayName, String description, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String databaseColumnGUID;
        String templateGUIDParameterName = "templateGUID";
        String databaseTableGUIDParameterName = "databaseTableGUID";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(templateGUID, "templateGUID", methodName);
        this.invalidParameterHandler.validateGUID(databaseTableGUID, "databaseTableGUID", methodName);
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        String anchorGUID = null;
        String parentTypeName = null;
        String parentAttachmentTypeGUID = null;
        String parentAttachmentTypeName = null;
        String parentGUID = null;
        EntityDetail databaseTableEntity = this.databaseColumnHandler.getEntityFromRepository(userId, databaseTableGUID, "databaseTableGUID", "RelationalTable", null, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        if (databaseTableEntity != null) {
            anchorGUID = this.databaseColumnHandler.getAnchorGUIDFromAnchorsClassification(databaseTableEntity, methodName);
            try {
                Classification typeClassification = this.repositoryHelper.getClassificationFromEntity(this.serviceName, (EntitySummary)databaseTableEntity, "TypeEmbeddedAttribute", methodName);
                if (typeClassification != null) {
                    parentGUID = databaseTableGUID;
                    parentTypeName = "RelationalTable";
                    parentAttachmentTypeGUID = "0ffb9d87-7074-45da-a9b0-ae0859611133";
                    parentAttachmentTypeName = "NestedSchemaAttribute";
                }
            }
            catch (ClassificationErrorException typeClassification) {
                // empty catch block
            }
            if (parentGUID == null) {
                parentTypeName = "RelationalTableType";
                parentAttachmentTypeGUID = "86b176a2-015c-44a6-8106-54d5d69ba661";
                parentAttachmentTypeName = "AttributeForSchema";
                parentGUID = this.databaseColumnHandler.getAttachedElementGUID(userId, databaseTableGUID, "databaseTableGUID", "RelationalTable", "2d955049-e59b-45dd-8e62-cde1add59f9e", "SchemaAttributeType", "SchemaType", 2, forLineage, forDuplicateProcessing, effectiveTime, methodName);
            }
        }
        if (parentGUID == null) {
            this.invalidParameterHandler.throwUnknownElement(userId, databaseTableGUID, "RelationalTable", this.serviceName, this.serverName, methodName);
            return null;
        }
        SchemaAttributeBuilder builder = new SchemaAttributeBuilder(qualifiedName, displayName, description, this.repositoryHelper, this.serviceName, this.serverName);
        if (anchorGUID != null) {
            builder.setAnchors(userId, anchorGUID, methodName);
        }
        if ((databaseColumnGUID = this.databaseColumnHandler.createBeanFromTemplate(userId, databaseManagerGUID, databaseManagerName, templateGUID, "templateGUID", "aa8d5470-6dbc-4648-9e2f-045e5df9d2f9", "RelationalColumn", qualifiedName, "qualifiedName", builder, methodName)) != null) {
            String databaseColumnGUIDParameterName = "databaseColumnGUID";
            this.databaseColumnHandler.linkElementToElement(userId, databaseManagerGUID, databaseManagerName, parentGUID, "databaseTableGUID", parentTypeName, databaseColumnGUID, "databaseColumnGUID", "RelationalColumn", forLineage, forDuplicateProcessing, parentAttachmentTypeGUID, parentAttachmentTypeName, null, effectiveFrom, effectiveTo, effectiveTime, methodName);
        }
        return databaseColumnGUID;
    }

    public void updateDatabaseColumn(String userId, String databaseManagerGUID, String databaseManagerName, String databaseColumnGUID, String qualifiedName, String displayName, String description, String dataType, String defaultValue, String fixedValue, String formula, boolean isDeprecated, int elementPosition, int minCardinality, int maxCardinality, boolean allowsDuplicateValues, boolean orderedValues, String defaultValueOverride, int sortOrder, int minimumLength, int length, int significantDigits, boolean isNullable, String nativeJavaClass, List<String> aliases, Map<String, String> additionalProperties, String typeName, Map<String, Object> extendedProperties, Map<String, String> vendorProperties, Date effectiveFrom, Date effectiveTo, boolean isMergeUpdate, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.updateDatabaseColumn(userId, databaseManagerGUID, databaseManagerName, databaseColumnGUID, qualifiedName, displayName, description, null, dataType, defaultValue, fixedValue, null, formula, isDeprecated, elementPosition, minCardinality, maxCardinality, allowsDuplicateValues, orderedValues, defaultValueOverride, sortOrder, minimumLength, length, significantDigits, isNullable, nativeJavaClass, aliases, additionalProperties, typeName, extendedProperties, vendorProperties, effectiveFrom, effectiveTo, isMergeUpdate, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void updateDatabaseColumn(String userId, String databaseManagerGUID, String databaseManagerName, String databaseColumnGUID, String qualifiedName, String displayName, String description, String externalSchemaTypeGUID, String dataType, String defaultValue, String fixedValue, String validValuesSetGUID, String formula, boolean isDeprecated, int elementPosition, int minCardinality, int maxCardinality, boolean allowsDuplicateValues, boolean orderedValues, String defaultValueOverride, int sortOrder, int minimumLength, int length, int significantDigits, boolean isNullable, String nativeJavaClass, List<String> aliases, Map<String, String> additionalProperties, String typeName, Map<String, Object> extendedProperties, Map<String, String> vendorProperties, Date effectiveFrom, Date effectiveTo, boolean isMergeUpdate, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String elementGUIDParameterName = "databaseColumnGUID";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(databaseColumnGUID, "databaseColumnGUID", methodName);
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        String attributeTypeName = "RelationalColumn";
        if (typeName != null) {
            attributeTypeName = typeName;
            this.invalidParameterHandler.validateTypeName(typeName, "RelationalColumn", this.serviceName, methodName, this.repositoryHelper);
        }
        this.databaseColumnHandler.updateSchemaAttribute(userId, databaseManagerGUID, databaseManagerName, databaseColumnGUID, "databaseColumnGUID", qualifiedName, "qualifiedName", displayName, description, externalSchemaTypeGUID, dataType, defaultValue, fixedValue, validValuesSetGUID, formula, isDeprecated, elementPosition, minCardinality, maxCardinality, allowsDuplicateValues, orderedValues, defaultValueOverride, sortOrder, minimumLength, length, significantDigits, isNullable, nativeJavaClass, aliases, additionalProperties, attributeTypeName, extendedProperties, effectiveFrom, effectiveTo, isMergeUpdate, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        this.databaseColumnHandler.setVendorProperties(userId, databaseColumnGUID, vendorProperties, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void removeDatabaseColumn(String userId, String databaseManagerGUID, String databaseManagerName, String databaseColumnGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String elementGUIDParameterName = "databaseColumnGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(databaseColumnGUID, "databaseColumnGUID", methodName);
        this.databaseColumnHandler.deleteBeanInRepository(userId, databaseManagerGUID, databaseManagerName, databaseColumnGUID, "databaseColumnGUID", "aa8d5470-6dbc-4648-9e2f-045e5df9d2f9", "RelationalColumn", null, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public List<DATABASE_COLUMN> findDatabaseColumns(String userId, String searchString, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String searchStringParameterName = "searchString";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateSearchString(searchString, "searchString", methodName);
        return this.databaseColumnHandler.findSchemaAttributes(userId, searchString, "searchString", "aa8d5470-6dbc-4648-9e2f-045e5df9d2f9", "RelationalColumn", null, null, startFrom, pageSize, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public List<DATABASE_COLUMN> getColumnsForDatabaseTable(String userId, String databaseTableGUID, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String parentElementGUIDParameterName = "databaseTableGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(databaseTableGUID, "databaseTableGUID", methodName);
        return this.databaseColumnHandler.getNestedSchemaAttributes(userId, databaseTableGUID, "databaseTableGUID", startFrom, pageSize, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public List<DATABASE_COLUMN> getDatabaseColumnsByName(String userId, String name, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String nameParameterName = "name";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateName(name, "name", methodName);
        return this.databaseColumnHandler.getSchemaAttributesByName(userId, "aa8d5470-6dbc-4648-9e2f-045e5df9d2f9", "RelationalColumn", name, null, null, startFrom, pageSize, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public DATABASE_COLUMN getDatabaseColumnByGUID(String userId, String guid, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String guidParameterName = "guid";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(guid, "guid", methodName);
        return this.databaseColumnHandler.getSchemaAttribute(userId, guid, "guid", "RelationalColumn", null, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void setPrimaryKeyOnColumn(String userId, String databaseManagerGUID, String databaseManagerName, String databaseColumnGUID, String name, int keyPatternOrdinal, Date effectiveFrom, Date effectiveTo, boolean isMergeUpdate, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String parentElementGUIDParameterName = "databaseColumnGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(databaseColumnGUID, "databaseColumnGUID", methodName);
        InstanceProperties properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, "name", name, methodName);
        try {
            properties = this.repositoryHelper.addEnumPropertyToInstance(this.serviceName, properties, "keyPattern", "8904df8f-1aca-4de8-9abd-1ef2aadba300", "KeyPattern", keyPatternOrdinal, methodName);
        }
        catch (TypeErrorException classificationNotSupported) {
            throw new org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException((OCFCheckedExceptionBase)classificationNotSupported, "keyPattern");
        }
        this.databaseColumnHandler.setUpEffectiveDates(properties, effectiveFrom, effectiveTo);
        this.databaseColumnHandler.setClassificationInRepository(userId, databaseManagerGUID, databaseManagerName, databaseColumnGUID, "databaseColumnGUID", "RelationalColumn", "b239d832-50bd-471b-b17a-15a335fc7f40", "PrimaryKey", properties, isMergeUpdate, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void removePrimaryKeyFromColumn(String userId, String databaseManagerGUID, String databaseManagerName, String databaseColumnGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String parentElementGUIDParameterName = "databaseColumnGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(databaseColumnGUID, "databaseColumnGUID", methodName);
        this.databaseColumnHandler.removeClassificationFromRepository(userId, databaseManagerGUID, databaseManagerName, databaseColumnGUID, "databaseColumnGUID", "RelationalColumn", "b239d832-50bd-471b-b17a-15a335fc7f40", "PrimaryKey", forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void addForeignKeyRelationship(String userId, String databaseManagerGUID, String databaseManagerName, String primaryKeyColumnGUID, String foreignKeyColumnGUID, String name, String description, int confidence, String steward, String source, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String primaryElementGUIDParameterName = "primaryKeyColumnGUID";
        String foreignElementGUIDParameterName = "foreignKeyColumnGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(primaryKeyColumnGUID, "primaryKeyColumnGUID", methodName);
        this.invalidParameterHandler.validateGUID(foreignKeyColumnGUID, "foreignKeyColumnGUID", methodName);
        InstanceProperties properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, "name", name, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "description", description, methodName);
        properties = this.repositoryHelper.addIntPropertyToInstance(this.serviceName, properties, "confidence", confidence, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "steward", steward, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "source", source, methodName);
        this.databaseColumnHandler.linkElementToElement(userId, databaseManagerGUID, databaseManagerName, primaryKeyColumnGUID, "primaryKeyColumnGUID", "RelationalColumn", foreignKeyColumnGUID, "foreignKeyColumnGUID", "RelationalColumn", forLineage, forDuplicateProcessing, "3cd4e0e7-fdbf-47a6-ae88-d4b3205e0c07", "ForeignKey", this.databaseColumnHandler.setUpEffectiveDates(properties, effectiveFrom, effectiveTo), effectiveFrom, effectiveTo, effectiveTime, methodName);
    }

    public void removeForeignKeyRelationship(String userId, String databaseManagerGUID, String databaseManagerName, String primaryKeyColumnGUID, String foreignKeyColumnGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String primaryElementGUIDParameterName = "primaryKeyColumnGUID";
        String foreignElementGUIDParameterName = "foreignKeyColumnGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(primaryKeyColumnGUID, "primaryKeyColumnGUID", methodName);
        this.invalidParameterHandler.validateGUID(foreignKeyColumnGUID, "foreignKeyColumnGUID", methodName);
        this.databaseColumnHandler.unlinkElementFromElement(userId, false, databaseManagerGUID, databaseManagerName, primaryKeyColumnGUID, "primaryKeyColumnGUID", "RelationalColumn", foreignKeyColumnGUID, "foreignKeyColumnGUID", "aa8d5470-6dbc-4648-9e2f-045e5df9d2f9", "RelationalColumn", forLineage, forDuplicateProcessing, "3cd4e0e7-fdbf-47a6-ae88-d4b3205e0c07", "ForeignKey", effectiveTime, methodName);
    }
}

