/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.generichandlers.GlossaryCategoryBuilder;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericConverter;
import org.odpi.openmetadata.commonservices.generichandlers.ReferenceableHandler;
import org.odpi.openmetadata.commonservices.generichandlers.ffdc.GenericHandlersErrorCode;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryIteratorForEntities;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.metadatasecurity.server.OpenMetadataServerSecurityVerifier;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class GlossaryCategoryHandler<B>
extends ReferenceableHandler<B> {
    public GlossaryCategoryHandler(OpenMetadataAPIGenericConverter<B> converter, Class<B> beanClass, String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper, String localServerUserId, OpenMetadataServerSecurityVerifier securityVerifier, List<String> supportedZones, List<String> defaultZones, List<String> publishZones, AuditLog auditLog) {
        super(converter, beanClass, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
    }

    public String createGlossaryCategory(String userId, String externalSourceGUID, String externalSourceName, String glossaryGUID, String glossaryGUIDParameterName, String qualifiedName, String displayName, String description, Map<String, String> additionalProperties, boolean rootCategory, String suppliedTypeName, Map<String, Object> extendedProperties, Date effectiveFrom, Date effectiveTo, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String glossaryCategoryGUID;
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(glossaryGUID, glossaryGUIDParameterName, methodName);
        String typeName = "GlossaryCategory";
        if (suppliedTypeName != null) {
            typeName = suppliedTypeName;
        }
        String typeGUID = this.invalidParameterHandler.validateTypeName(typeName, "GlossaryCategory", this.serviceName, methodName, this.repositoryHelper);
        GlossaryCategoryBuilder builder = new GlossaryCategoryBuilder(qualifiedName, displayName, description, additionalProperties, extendedProperties, this.repositoryHelper, this.serviceName, this.serverName);
        builder.setAnchors(userId, glossaryGUID, methodName);
        builder.setEffectivityDates(effectiveFrom, effectiveTo);
        if (rootCategory) {
            builder.setRootCategory(userId, methodName);
        }
        if ((glossaryCategoryGUID = this.createBeanInRepository(userId, externalSourceGUID, externalSourceName, typeGUID, typeName, builder, effectiveTime, methodName)) != null) {
            String glossaryCategoryGUIDParameterName = "glossaryCategoryGUID";
            this.uncheckedLinkElementToElement(userId, externalSourceGUID, externalSourceName, glossaryGUID, glossaryGUIDParameterName, "Glossary", glossaryCategoryGUID, "glossaryCategoryGUID", "GlossaryCategory", true, true, this.supportedZones, "c628938e-815e-47db-8d1c-59bb2e84e028", "CategoryAnchor", null, effectiveTime, methodName);
        }
        return glossaryCategoryGUID;
    }

    public String createGlossaryCategoryFromTemplate(String userId, String externalSourceGUID, String externalSourceName, String glossaryGUID, String glossaryGUIDParameterName, String templateGUID, String qualifiedName, String displayName, String description, boolean deepCopy, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String templateGUIDParameterName = "templateGUID";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(templateGUID, "templateGUID", methodName);
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        GlossaryCategoryBuilder builder = new GlossaryCategoryBuilder(qualifiedName, displayName, description, this.repositoryHelper, this.serviceName, this.serverName);
        builder.setAnchors(userId, glossaryGUID, methodName);
        String glossaryCategoryGUID = this.createBeanFromTemplate(userId, externalSourceGUID, externalSourceName, templateGUID, "templateGUID", "e507485b-9b5a-44c9-8a28-6967f7ff3672", "GlossaryCategory", qualifiedName, "qualifiedName", builder, this.supportedZones, deepCopy, false, methodName);
        if (glossaryCategoryGUID != null) {
            String glossaryCategoryGUIDParameterName = "glossaryCategoryGUID";
            this.uncheckedLinkElementToElement(userId, externalSourceGUID, externalSourceName, glossaryGUID, glossaryGUIDParameterName, "Glossary", glossaryCategoryGUID, "glossaryCategoryGUID", "GlossaryCategory", true, true, this.supportedZones, "c628938e-815e-47db-8d1c-59bb2e84e028", "CategoryAnchor", null, null, methodName);
        }
        return glossaryCategoryGUID;
    }

    public void updateGlossaryCategory(String userId, String externalSourceGUID, String externalSourceName, String glossaryCategoryGUID, String glossaryCategoryGUIDParameterName, String qualifiedName, String displayName, String description, Map<String, String> additionalProperties, String suppliedTypeName, Map<String, Object> extendedProperties, Date effectiveFrom, Date effectiveTo, Date effectiveTime, boolean isMergeUpdate, boolean forLineage, boolean forDuplicateProcessing, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(glossaryCategoryGUID, glossaryCategoryGUIDParameterName, methodName);
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        String typeName = "GlossaryCategory";
        if (suppliedTypeName != null) {
            typeName = suppliedTypeName;
        }
        String typeGUID = this.invalidParameterHandler.validateTypeName(typeName, "GlossaryCategory", this.serviceName, methodName, this.repositoryHelper);
        GlossaryCategoryBuilder builder = new GlossaryCategoryBuilder(qualifiedName, displayName, description, additionalProperties, extendedProperties, this.repositoryHelper, this.serviceName, this.serverName);
        builder.setEffectivityDates(effectiveFrom, effectiveTo);
        this.updateBeanInRepository(userId, externalSourceGUID, externalSourceName, glossaryCategoryGUID, glossaryCategoryGUIDParameterName, typeGUID, typeName, forLineage, forDuplicateProcessing, (List<String>)this.supportedZones, builder.getInstanceProperties(methodName), isMergeUpdate, effectiveTime, methodName);
    }

    public void setupCategoryParent(String userId, String externalSourceGUID, String externalSourceName, String glossaryParentCategoryGUID, String glossaryParentCategoryGUIDParameterName, String glossaryChildCategoryGUID, String glossaryChildCategoryGUIDParameterName, Date effectiveFrom, Date effectiveTo, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.linkElementToElement(userId, externalSourceGUID, externalSourceName, glossaryParentCategoryGUID, glossaryParentCategoryGUIDParameterName, "GlossaryCategory", glossaryChildCategoryGUID, glossaryChildCategoryGUIDParameterName, "GlossaryCategory", forLineage, forDuplicateProcessing, this.supportedZones, "71e4b6fb-3412-4193-aff3-a16eccd87e8e", "CategoryHierarchyLink", null, effectiveFrom, effectiveTo, effectiveTime, methodName);
    }

    public void clearCategoryParent(String userId, String externalSourceGUID, String externalSourceName, String glossaryParentCategoryGUID, String glossaryParentCategoryGUIDParameterName, String glossaryChildCategoryGUID, String glossaryChildCategoryGUIDParameterName, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.unlinkElementFromElement(userId, false, externalSourceGUID, externalSourceName, glossaryParentCategoryGUID, glossaryParentCategoryGUIDParameterName, "GlossaryCategory", glossaryChildCategoryGUID, glossaryChildCategoryGUIDParameterName, "e507485b-9b5a-44c9-8a28-6967f7ff3672", "GlossaryCategory", forLineage, forDuplicateProcessing, "71e4b6fb-3412-4193-aff3-a16eccd87e8e", "CategoryHierarchyLink", effectiveTime, methodName);
    }

    public void removeGlossaryCategory(String userId, String externalSourceGUID, String externalSourceName, String glossaryCategoryGUID, String glossaryCategoryGUIDParameterName, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.deleteBeanInRepository(userId, externalSourceGUID, externalSourceName, glossaryCategoryGUID, glossaryCategoryGUIDParameterName, "e507485b-9b5a-44c9-8a28-6967f7ff3672", "GlossaryCategory", null, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public List<B> findGlossaryCategories(String userId, String glossaryGUID, String searchString, String searchStringParameterName, int startFrom, int pageSize, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        if (glossaryGUID == null) {
            return this.findBeans(userId, searchString, searchStringParameterName, "e507485b-9b5a-44c9-8a28-6967f7ff3672", "GlossaryCategory", forLineage, forDuplicateProcessing, this.supportedZones, null, startFrom, pageSize, effectiveTime, methodName);
        }
        String entityGUIDParameterName = "categoryEntity.getGUID";
        int queryPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, methodName);
        RepositoryIteratorForEntities iterator = this.getEntitySearchIterator(userId, searchString, "e507485b-9b5a-44c9-8a28-6967f7ff3672", "GlossaryCategory", null, false, false, null, forLineage, forDuplicateProcessing, 0, queryPageSize, effectiveTime, methodName);
        ArrayList results = new ArrayList();
        while (iterator.moreToReceive() && (queryPageSize == 0 || results.size() < queryPageSize)) {
            EntityDetail entity = iterator.getNext();
            int matchCount = 0;
            if (entity == null) continue;
            try {
                this.validateAnchorEntity(userId, entity.getGUID(), entity.getType().getTypeDefName(), entity, "categoryEntity.getGUID", false, forLineage, forDuplicateProcessing, this.supportedZones, effectiveTime, methodName);
                String anchorGUID = this.getAnchorGUIDFromAnchorsClassification(entity, methodName);
                if (!glossaryGUID.equals(anchorGUID) || ++matchCount <= startFrom) continue;
                results.add(this.converter.getNewBean(this.beanClass, entity, methodName));
            }
            catch (Exception exception) {}
        }
        if (!results.isEmpty()) {
            return results;
        }
        return null;
    }

    public List<B> getCategoriesForGlossary(String userId, String glossaryGUID, String glossaryGUIDParameterName, int startFrom, int pageSize, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.getAttachedElements(userId, glossaryGUID, glossaryGUIDParameterName, "Glossary", "c628938e-815e-47db-8d1c-59bb2e84e028", "CategoryAnchor", "GlossaryCategory", null, null, 2, forLineage, forDuplicateProcessing, startFrom, pageSize, effectiveTime, methodName);
    }

    public List<B> getCategoriesForTerm(String userId, String glossaryTermGUID, String glossaryTermGUIDParameterName, int startFrom, int pageSize, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.getAttachedElements(userId, glossaryTermGUID, glossaryTermGUIDParameterName, "GlossaryTerm", "696a81f5-ac60-46c7-b9fd-6979a1e7ad27", "TermCategorization", "GlossaryCategory", null, null, 1, forLineage, forDuplicateProcessing, startFrom, pageSize, effectiveTime, methodName);
    }

    public List<B> getGlossaryCategoriesByName(String userId, String glossaryGUID, String name, String nameParameterName, int startFrom, int pageSize, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateName(name, nameParameterName, methodName);
        ArrayList<String> specificMatchPropertyNames = new ArrayList<String>();
        specificMatchPropertyNames.add("qualifiedName");
        specificMatchPropertyNames.add("displayName");
        if (glossaryGUID == null) {
            return this.getBeansByValue(userId, name, nameParameterName, "e507485b-9b5a-44c9-8a28-6967f7ff3672", "GlossaryCategory", specificMatchPropertyNames, true, null, null, forLineage, forDuplicateProcessing, this.supportedZones, null, startFrom, pageSize, effectiveTime, methodName);
        }
        String entityGUIDParameterName = "categoryEntity.getGUID";
        int queryPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, methodName);
        RepositoryIteratorForEntities iterator = this.getEntitySearchIterator(userId, name, "e507485b-9b5a-44c9-8a28-6967f7ff3672", "GlossaryCategory", specificMatchPropertyNames, true, false, null, forLineage, forDuplicateProcessing, 0, queryPageSize, effectiveTime, methodName);
        ArrayList results = new ArrayList();
        while (iterator.moreToReceive() && (queryPageSize == 0 || results.size() < queryPageSize)) {
            EntityDetail entity = iterator.getNext();
            int matchCount = 0;
            if (entity == null) continue;
            try {
                this.validateAnchorEntity(userId, entity.getGUID(), entity.getType().getTypeDefName(), entity, "categoryEntity.getGUID", false, forLineage, forDuplicateProcessing, this.supportedZones, effectiveTime, methodName);
                String anchorGUID = this.getAnchorGUIDFromAnchorsClassification(entity, methodName);
                if (!glossaryGUID.equals(anchorGUID) || ++matchCount <= startFrom) continue;
                results.add(this.converter.getNewBean(this.beanClass, entity, methodName));
            }
            catch (Exception exception) {}
        }
        if (!results.isEmpty()) {
            return results;
        }
        return null;
    }

    public B getGlossaryCategoryParent(String userId, String glossaryCategoryGUID, String glossaryCategoryGUIDParameterName, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        List results = this.getAttachedElements(userId, glossaryCategoryGUID, glossaryCategoryGUIDParameterName, "GlossaryCategory", "71e4b6fb-3412-4193-aff3-a16eccd87e8e", "CategoryHierarchyLink", "GlossaryCategory", null, null, 1, forLineage, forDuplicateProcessing, 0, this.invalidParameterHandler.getMaxPagingSize(), effectiveTime, methodName);
        if (results == null || results.isEmpty()) {
            return null;
        }
        if (results.size() == 1) {
            return results.get(0);
        }
        throw new PropertyServerException(GenericHandlersErrorCode.MULTIPLE_BEANS_FOUND.getMessageDefinition("GlossaryCategory", methodName, results.toString(), glossaryCategoryGUID, this.serviceName, this.serverName), this.getClass().getName(), methodName);
    }

    public List<B> getGlossarySubCategories(String userId, String glossaryCategoryGUID, String glossaryCategoryGUIDParameterName, int startFrom, int pageSize, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.getAttachedElements(userId, glossaryCategoryGUID, glossaryCategoryGUIDParameterName, "GlossaryCategory", "71e4b6fb-3412-4193-aff3-a16eccd87e8e", "CategoryHierarchyLink", "GlossaryCategory", null, null, 2, forLineage, forDuplicateProcessing, startFrom, pageSize, effectiveTime, methodName);
    }

    public B getGlossaryCategoryByGUID(String userId, String guid, String guidParameterName, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.getBeanFromRepository(userId, guid, guidParameterName, "GlossaryCategory", forLineage, forDuplicateProcessing, this.supportedZones, effectiveTime, methodName);
    }
}

