/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.generichandlers.GovernanceDomainBuilder;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericConverter;
import org.odpi.openmetadata.commonservices.generichandlers.ReferenceableHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.metadatasecurity.server.OpenMetadataServerSecurityVerifier;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class GovernanceDomainHandler<B>
extends ReferenceableHandler<B> {
    public GovernanceDomainHandler(OpenMetadataAPIGenericConverter<B> converter, Class<B> beanClass, String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper, String localServerUserId, OpenMetadataServerSecurityVerifier securityVerifier, List<String> supportedZones, List<String> defaultZones, List<String> publishZones, AuditLog auditLog) {
        super(converter, beanClass, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
    }

    public String createGovernanceDomain(String userId, String qualifiedName, String displayName, String description, int domainIdentifier, Map<String, String> additionalProperties, String suppliedTypeName, Map<String, Object> extendedProperties, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        String typeName = "GovernanceDomainDescription";
        if (suppliedTypeName != null) {
            typeName = suppliedTypeName;
        }
        String typeGUID = this.invalidParameterHandler.validateTypeName(typeName, "GovernanceDomainDescription", this.serviceName, methodName, this.repositoryHelper);
        GovernanceDomainBuilder builder = new GovernanceDomainBuilder(qualifiedName, displayName, description, domainIdentifier, additionalProperties, typeGUID, typeName, extendedProperties, this.repositoryHelper, this.serviceName, this.serverName);
        return this.createBeanInRepository(userId, null, null, typeGUID, typeName, builder, effectiveTime, methodName);
    }

    public void updateGovernanceDomain(String userId, String governanceDomainGUID, String governanceDomainGUIDParameterName, String qualifiedName, String displayName, String description, int domainIdentifier, Map<String, String> additionalProperties, String suppliedTypeName, Map<String, Object> extendedProperties, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(governanceDomainGUID, governanceDomainGUIDParameterName, methodName);
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        String typeName = "GovernanceDomainDescription";
        if (suppliedTypeName != null) {
            typeName = suppliedTypeName;
        }
        String typeGUID = this.invalidParameterHandler.validateTypeName(typeName, "GovernanceDomainDescription", this.serviceName, methodName, this.repositoryHelper);
        GovernanceDomainBuilder builder = new GovernanceDomainBuilder(qualifiedName, displayName, description, domainIdentifier, additionalProperties, typeGUID, typeName, extendedProperties, this.repositoryHelper, this.serviceName, this.serverName);
        this.updateBeanInRepository(userId, null, null, governanceDomainGUID, governanceDomainGUIDParameterName, typeGUID, typeName, false, false, (List<String>)this.supportedZones, builder.getInstanceProperties(methodName), false, new Date(), methodName);
    }

    public void removeGovernanceDomain(String userId, String governanceDomainGUID, String governanceDomainGUIDParameterName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.deleteBeanInRepository(userId, null, null, governanceDomainGUID, governanceDomainGUIDParameterName, "578a3500-9ad3-45fe-8ada-e4e9572c37c8", "GovernanceDomainDescription", null, null, false, false, new Date(), methodName);
    }

    public List<B> findGovernanceDomains(String userId, String searchString, String searchStringParameterName, int startFrom, int pageSize, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.findBeans(userId, searchString, searchStringParameterName, "578a3500-9ad3-45fe-8ada-e4e9572c37c8", "GovernanceDomainDescription", null, startFrom, pageSize, false, false, new Date(), methodName);
    }

    public List<B> getGovernanceDomainsByName(String userId, String name, String nameParameterName, int startFrom, int pageSize, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        ArrayList<String> specificMatchPropertyNames = new ArrayList<String>();
        specificMatchPropertyNames.add("qualifiedName");
        specificMatchPropertyNames.add("displayName");
        return this.getBeansByValue(userId, name, nameParameterName, "578a3500-9ad3-45fe-8ada-e4e9572c37c8", "GovernanceDomainDescription", specificMatchPropertyNames, true, null, null, false, false, this.supportedZones, null, startFrom, pageSize, null, methodName);
    }

    public List<B> getDomainsInSet(String userId, String startingGUID, String startingGUIDParameterName, int startingFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getAttachedElements(userId, null, null, startingGUID, startingGUIDParameterName, "Collection", "5cabb76a-e25b-4bb5-8b93-768bbac005af", "CollectionMembership", "GovernanceDomainDescription", null, null, 2, forLineage, forDuplicateProcessing, this.supportedZones, startingFrom, pageSize, effectiveTime, methodName);
    }

    public B getGovernanceDomainByGUID(String userId, String guid, String guidParameterName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.getBeanFromRepository(userId, guid, guidParameterName, "GovernanceDomainDescription", false, false, new Date(), methodName);
    }

    public B getGovernanceDomainByDomainIdentifier(String userId, int domainIdentifier, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.getBeanByUniqueName(userId, "GovernanceDomain:" + domainIdentifier, "domainIdentifier", "domainIdentifier", "578a3500-9ad3-45fe-8ada-e4e9572c37c8", "GovernanceDomainDescription", false, false, this.supportedZones, new Date(), methodName);
    }
}

