/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.util.Date;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericBuilder;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.OCFCheckedExceptionBase;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeErrorException;

public class ITInfrastructureBuilder
extends OpenMetadataAPIGenericBuilder {
    ITInfrastructureBuilder(OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super("151e6dd1-54a0-4b7f-a072-85caa09d1dda", "ITInfrastructure", repositoryHelper, serviceName, serverName);
    }

    @Override
    public InstanceProperties getInstanceProperties(String methodName) throws InvalidParameterException {
        return super.getInstanceProperties(methodName);
    }

    InstanceProperties getSoftwareServerPlatformDeploymentProperties(Date deploymentTime, String deployer, int platformStatus, String methodName) throws InvalidParameterException {
        InstanceProperties properties = this.repositoryHelper.addDatePropertyToInstance(this.serviceName, null, "deploymentTime", deploymentTime, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "deployer", deployer, methodName);
        try {
            properties = this.repositoryHelper.addEnumPropertyToInstance(this.serviceName, properties, "platformStatus", "24e1e33e-9250-4a6c-8b07-05c7adec3a1d", "OperationalStatus", platformStatus, methodName);
        }
        catch (TypeErrorException error) {
            throw new InvalidParameterException((OCFCheckedExceptionBase)((Object)error), "platformStatus");
        }
        this.setEffectivityDates(properties);
        return properties;
    }

    InstanceProperties getSoftwareServerDeploymentProperties(Date deploymentTime, String deployer, int serverStatus, String methodName) throws InvalidParameterException {
        InstanceProperties properties = this.repositoryHelper.addDatePropertyToInstance(this.serviceName, null, "deploymentTime", deploymentTime, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "deployer", deployer, methodName);
        try {
            properties = this.repositoryHelper.addEnumPropertyToInstance(this.serviceName, properties, "serverStatus", "24e1e33e-9250-4a6c-8b07-05c7adec3a1d", "OperationalStatus", serverStatus, methodName);
        }
        catch (TypeErrorException error) {
            throw new InvalidParameterException((OCFCheckedExceptionBase)((Object)error), "serverStatus");
        }
        this.setEffectivityDates(properties);
        return properties;
    }

    InstanceProperties getSoftwareServerSupportedCapabilitiesProperties(Date deploymentTime, String deployer, int serverCapabilityStatus, String methodName) throws InvalidParameterException {
        InstanceProperties properties = this.repositoryHelper.addDatePropertyToInstance(this.serviceName, null, "deploymentTime", deploymentTime, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "deployer", deployer, methodName);
        try {
            properties = this.repositoryHelper.addEnumPropertyToInstance(this.serviceName, properties, "serverCapabilityStatus", "24e1e33e-9250-4a6c-8b07-05c7adec3a1d", "OperationalStatus", serverCapabilityStatus, methodName);
        }
        catch (TypeErrorException error) {
            throw new InvalidParameterException((OCFCheckedExceptionBase)((Object)error), "serverCapabilityStatus");
        }
        this.setEffectivityDates(properties);
        return properties;
    }

    InstanceProperties getSoftwareServerCapabilitiesAssetUseProperties(String description, int useType, String methodName) throws InvalidParameterException {
        InstanceProperties properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, "description", description, methodName);
        try {
            properties = this.repositoryHelper.addEnumPropertyToInstance(this.serviceName, properties, "useType", "09439481-9489-467c-9ae5-178a6e0b6b5a", "ServerAssetUseType", useType, methodName);
        }
        catch (TypeErrorException error) {
            throw new InvalidParameterException((OCFCheckedExceptionBase)((Object)error), "useType");
        }
        this.setEffectivityDates(properties);
        return properties;
    }

    InstanceProperties getCloudProviderProperties(String providerName, String methodName) {
        InstanceProperties properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, "providerName", providerName, methodName);
        this.setEffectivityDates(properties);
        return properties;
    }

    InstanceProperties getCloudPlatformProperties(String implementationType, String methodName) {
        InstanceProperties properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, "deployedImplementationType", implementationType, methodName);
        this.setEffectivityDates(properties);
        return properties;
    }

    InstanceProperties getCloudTenantProperties(String tenantName, String tenantType, String methodName) {
        InstanceProperties properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, "TenantName", tenantName, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "TenantType", tenantType, methodName);
        this.setEffectivityDates(properties);
        return properties;
    }

    InstanceProperties getCloudServiceProperties(String offeringName, String serviceType, String methodName) {
        InstanceProperties properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, "offeringName", offeringName, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "serviceType", serviceType, methodName);
        this.setEffectivityDates(properties);
        return properties;
    }
}

